#include <assert.h>

#include "hackerlab/vu/vu.h"
#include "hackerlab/vu/vu-sys.h"

#include "hackerlab/vu/vu.h"
#include "vu-pathcompress.h"

#include <stdio.h>
#include <string.h>

#define MAX_PATH_LEN 4096

int main(int argc, char* argv[])
{
  regex_t reg;
  char* pattern = "/*";
  char* dirpath = argv[1];
  char* p;
  char* last;
  int err;
  int recurse = 0;

  if (argc>2) {
	dirpath = argv[2];
	if (argv[1][0] == '-') {
	  switch(argv[1][1]) {
	  case 'p':
		recurse = 1;
		break;
	  }
	}
  } else {
	dirpath = argv[1];
  }

  last = dirpath+strlen(dirpath)-1;

  while (last>dirpath) {
	if (*last=='/') {
	  *last=0;
	} else {
	  break;
	}
	last--;
  }

#ifdef PUSH
  if (strcmp("pathcompress", PUSH)==0) {
    pattern = "{arch}";
    regcomp(&reg, pattern, 0);
    vu_push_name_handler("pathcompress", NULL, &reg, 0, &pathcompress_fs_vtable, NULL, 0);
  }
#endif

  if (recurse) {
	p = dirpath;
	while (++p<=last) {
	  if (*p == '/') {
		*p = '\0';
		vu_mkdir(&err, dirpath, 0700);
		*p = '/';
	  }
	}
  }
  vu_mkdir(&err, dirpath, 0700);

  return 0;
}
