import sys, itertools
from spigot import Spigot

def spigprint(spig):
    s = ""
    spig.sp.base()
    while len(s) < 40:
        s = s + spig.sp.readfmt()
    print s

pi = Spigot("pi")

def funcscope(name):
    if name == "y":
        return pi
    return None
pisquared = Spigot("x^2", [{'x':pi}, funcscope])
spigprint(pisquared)
pisquared = Spigot("y^2", [{'x':pi}, funcscope])
spigprint(pisquared)

test = Spigot("pi^e - exp(pi)")
print test.sp.sign()

test = Spigot("tan(1e100)")
print float(test)

test = Spigot("e")
print ",".join(["%d" % n for n in
                itertools.islice(test.continued_fraction(), 0, 30)])

test = Spigot("pi")
print ",".join(["%d/%d" % (n,d) for (n,d) in
                itertools.islice(test.convergents(), 0, 10)])
