# $FreeBSD: head/audio/praat/files/makefile.defs.freebsd.alsa 532890 2020-04-24 19:22:03Z jwb $
# File: makefile.defs.freebsd.alsa.BE

# System: FreeBSD
# Paul Boersma, 23 March 2020
# J Bacon, 24 April 2020
# Adriaan de Groot, 30 September 2020
# Paul Boersma, 14 November 2021
# Paul Boersma, 29 December 2025: big-endian

# Where external / third-party software is installed; needs to be
# added to include and linker paths. (In the FreeBSD ports system,
# this is already set so nothing is overridden)
LOCALBASE ?= /usr/local

# FreeBSD defaults to clang, not gcc
CC ?= cc
CXX ?= c++
LINK ?= $(CXX)

# -DALSA and -DJACK: Use ALSA and Jack audio in pa_unix_hostapis.c
AUDIO = -DALSA -DJACK

# FreeBSD pretends to be Linux for most of the code; add CPPFLAGS
# explicitly because GNU make / gcc uses those preprocessor flags,
# but clang does not.
COMMONFLAGS = -DUNIX -Dlinux $(AUDIO) -D_FILE_OFFSET_BITS=64 `pkg-config --cflags gtk+-3.0` \
	-DWORDS_BIGENDIAN=1 -DPA_BIG_ENDIAN \
	-Wreturn-type -Wunused -Wunused-parameter -Wuninitialized -O1 -g1 -pthread $(CPPFLAGS)

CFLAGS = -std=gnu99 $(COMMONFLAGS) \
	-DHAVE_SYS_SOUNDCARD_H \
	-Werror=implicit

CXXFLAGS = -std=c++17 $(COMMONFLAGS) \
	-DHAVE_SYS_SOUNDCARD_H \
	-Wshadow \
	-Werror=return-type \
	-I$(LOCALBASE)/include -I$(LOCALBASE)/include/unicode

EXECUTABLE = praat

LIBS = `pkg-config --libs gtk+-3.0` -L$(LOCALBASE)/lib -lasound -ljack -lm -lpthread -ltinfow

AR = ar
RANLIB = ls
RM = rm -f

ICON =
MAIN_ICON =

