--
-- Copyright 2025 The Android Open Source Project
--
-- Licensed under the Apache License, Version 2.0 (the "License");
-- you may not use this file except in compliance with the License.
-- You may obtain a copy of the License at
--
--     https://www.apache.org/licenses/LICENSE-2.0
--
-- Unless required by applicable law or agreed to in writing, software
-- distributed under the License is distributed on an "AS IS" BASIS,
-- WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
-- See the License for the specific language governing permissions and
-- limitations under the License.
-- Device specific device curves with 2D dependency (i.e. curve characteristics
-- are dependent on another CPU policy). See go/wattson for more info.
INCLUDE PERFETTO MODULE wattson.curves.tg5_cpu_2d;

INCLUDE PERFETTO MODULE wattson.utils;

CREATE PERFETTO TABLE _device_curves_2d AS
WITH
  data(device, policy, freq_khz, dep_policy, dep_freq, static, active, idle0, idle1) AS (
    SELECT
      *
    FROM (VALUES
      ("SXR2230P", 0, 691200, 2, 691200, 5.34, 73.1, 4.23, 0),
      ("SXR2230P", 0, 691200, 2, 960000, 6.7, 83.35, 3.49, 0),
      ("SXR2230P", 0, 691200, 2, 1094400, 7.42, 86.89, 3.18, 0),
      ("SXR2230P", 0, 691200, 2, 1228800, 6.29, 89.16, 3.96, 0),
      ("SXR2230P", 0, 691200, 2, 1382400, 7.4, 93.91, 3.61, 0),
      ("SXR2230P", 0, 691200, 2, 1516800, 5.02, 96.56, 4.33, 0),
      ("SXR2230P", 0, 691200, 2, 1651200, 7.95, 114.92, 3.23, 0),
      ("SXR2230P", 0, 691200, 2, 1920000, 5.23, 142.71, 4.86, 0),
      ("SXR2230P", 0, 691200, 2, 2054400, 7.42, 147.29, 3.42, 0),
      ("SXR2230P", 0, 691200, 2, 2208000, 6.0, 153.88, 4.15, 0),
      ("SXR2230P", 0, 691200, 2, 2361600, 5.47, 158.24, 4.7, 0),
      ("SXR2230P", 0, 960000, 2, 691200, 4.43, 112.69, 5.76, 0),
      ("SXR2230P", 0, 960000, 2, 960000, 7.97, 119.75, 3.93, 0),
      ("SXR2230P", 0, 960000, 2, 1094400, 7.95, 127.6, 4.3, 0),
      ("SXR2230P", 0, 960000, 2, 1228800, 7.82, 127.88, 4.13, 0),
      ("SXR2230P", 0, 960000, 2, 1382400, 8.95, 132.33, 3.57, 0),
      ("SXR2230P", 0, 960000, 2, 1516800, 8.5, 139.06, 3.34, 0),
      ("SXR2230P", 0, 960000, 2, 1651200, 7.89, 145.34, 4.46, 0),
      ("SXR2230P", 0, 960000, 2, 1920000, 9.37, 105.38, 3.49, 0),
      ("SXR2230P", 0, 960000, 2, 2054400, 10.28, 168.55, 3.23, 0),
      ("SXR2230P", 0, 960000, 2, 2208000, 7.63, 178.74, 4.68, 0),
      ("SXR2230P", 0, 960000, 2, 2361600, 9.65, 184.9, 3.74, 0),
      ("SXR2230P", 0, 1094400, 2, 691200, 5.8, 113.33, 5.92, 0),
      ("SXR2230P", 0, 1094400, 2, 960000, 9.25, 122.61, 4.16, 0),
      ("SXR2230P", 0, 1094400, 2, 1094400, 9.25, 140.83, 4.07, 0),
      ("SXR2230P", 0, 1094400, 2, 1228800, 8.5, 146.5, 4.94, 0),
      ("SXR2230P", 0, 1094400, 2, 1382400, 8.0, 151.15, 5.13, 0),
      ("SXR2230P", 0, 1094400, 2, 1516800, 8.9, 155.82, 4.71, 0),
      ("SXR2230P", 0, 1094400, 2, 1651200, 8.99, 160.4, 4.72, 0),
      ("SXR2230P", 0, 1094400, 2, 1920000, 8.16, 151.02, 5.6, 0),
      ("SXR2230P", 0, 1094400, 2, 2054400, 10.33, 181.34, 3.76, 0),
      ("SXR2230P", 0, 1094400, 2, 2208000, 9.23, 190.48, 4.7, 0),
      ("SXR2230P", 0, 1094400, 2, 2361600, 10.46, 199.27, 3.99, 0),
      ("SXR2230P", 0, 1228800, 2, 691200, 10.06, 174.09, 4.73, 0),
      ("SXR2230P", 0, 1228800, 2, 960000, 10.44, 151.01, 4.34, 0),
      ("SXR2230P", 0, 1228800, 2, 1094400, 9.46, 179.44, 4.86, 0),
      ("SXR2230P", 0, 1228800, 2, 1228800, 9.55, 179.64, 4.6, 0),
      ("SXR2230P", 0, 1228800, 2, 1382400, 9.37, 183.18, 4.83, 0),
      ("SXR2230P", 0, 1228800, 2, 1516800, 10.14, 186.37, 4.49, 0),
      ("SXR2230P", 0, 1228800, 2, 1651200, 8.23, 194.77, 5.79, 0),
      ("SXR2230P", 0, 1228800, 2, 1920000, 11.1, 207.61, 4.54, 0),
      ("SXR2230P", 0, 1228800, 2, 2054400, 11.51, 202.23, 3.71, 0),
      ("SXR2230P", 0, 1228800, 2, 2208000, 9.88, 211.16, 5.16, 0),
      ("SXR2230P", 0, 1228800, 2, 2361600, 10.42, 223.38, 4.36, 0),
      ("SXR2230P", 0, 1382400, 2, 691200, 11.41, 208.76, 4.51, 0),
      ("SXR2230P", 0, 1382400, 2, 960000, 12.92, 223.28, 3.84, 0),
      ("SXR2230P", 0, 1382400, 2, 1094400, 9.82, 216.2, 5.66, 0),
      ("SXR2230P", 0, 1382400, 2, 1228800, 11.52, 215.85, 4.66, 0),
      ("SXR2230P", 0, 1382400, 2, 1382400, 12.27, 216.04, 4.15, 0),
      ("SXR2230P", 0, 1382400, 2, 1516800, 12.37, 217.03, 4.48, 0),
      ("SXR2230P", 0, 1382400, 2, 1651200, 12.33, 220.17, 4.74, 0),
      ("SXR2230P", 0, 1382400, 2, 1920000, 11.71, 175.68, 4.67, 0),
      ("SXR2230P", 0, 1382400, 2, 2054400, 12.0, 225.95, 4.62, 0),
      ("SXR2230P", 0, 1382400, 2, 2208000, 11.25, 235.89, 5.0, 0),
      ("SXR2230P", 0, 1382400, 2, 2361600, 16.02, 241.14, 0.31, 0),
      ("SXR2230P", 0, 1516800, 2, 691200, 16.17, 249.02, 2.22, 0),
      ("SXR2230P", 0, 1516800, 2, 960000, 13.86, 262.22, 4.48, 0),
      ("SXR2230P", 0, 1516800, 2, 1094400, 14.58, 250.77, 4.36, 0),
      ("SXR2230P", 0, 1516800, 2, 1228800, 13.69, 252.42, 5.01, 0),
      ("SXR2230P", 0, 1516800, 2, 1382400, 14.65, 253.06, 3.98, 0),
      ("SXR2230P", 0, 1516800, 2, 1516800, 13.83, 252.54, 5.12, 0),
      ("SXR2230P", 0, 1516800, 2, 1651200, 13.83, 257.63, 4.78, 0),
      ("SXR2230P", 0, 1516800, 2, 1920000, 10.22, 273.89, 7.5, 0),
      ("SXR2230P", 0, 1516800, 2, 2054400, 15.56, 259.65, 3.9, 0),
      ("SXR2230P", 0, 1516800, 2, 2208000, 16.29, 266.37, 3.53, 0),
      ("SXR2230P", 0, 1516800, 2, 2361600, 12.06, 269.13, 6.78, 0),
      ("SXR2230P", 0, 1651200, 2, 691200, 4.86, 314.16, 11.42, 0),
      ("SXR2230P", 0, 1651200, 2, 960000, 16.05, 308.85, 5.66, 0),
      ("SXR2230P", 0, 1651200, 2, 1094400, 15.7, 308.84, 5.79, 0),
      ("SXR2230P", 0, 1651200, 2, 1228800, 10.62, 309.05, 8.69, 0),
      ("SXR2230P", 0, 1651200, 2, 1382400, 13.54, 305.82, 7.02, 0),
      ("SXR2230P", 0, 1651200, 2, 1516800, 15.22, 310.24, 6.22, 0),
      ("SXR2230P", 0, 1651200, 2, 1651200, 9.84, 299.11, 9.09, 0),
      ("SXR2230P", 0, 1651200, 2, 1920000, 13.47, 308.14, 7.36, 0),
      ("SXR2230P", 0, 1651200, 2, 2054400, 9.97, 307.97, 9.37, 0),
      ("SXR2230P", 0, 1651200, 2, 2208000, 12.16, 310.25, 8.74, 0),
      ("SXR2230P", 0, 1651200, 2, 2361600, 12.83, 316.8, 8.04, 0),
      ("SXR2230P", 0, 1920000, 2, 691200, 18.27, 446.95, 10.87, 0),
      ("SXR2230P", 0, 1920000, 2, 960000, 20.99, 442.55, 9.57, 0),
      ("SXR2230P", 0, 1920000, 2, 1094400, 21.94, 440.41, 8.98, 0),
      ("SXR2230P", 0, 1920000, 2, 1228800, 20.64, 438.2, 9.58, 0),
      ("SXR2230P", 0, 1920000, 2, 1382400, 21.27, 438.35, 9.3, 0),
      ("SXR2230P", 0, 1920000, 2, 1516800, 23.18, 440.48, 8.4, 0),
      ("SXR2230P", 0, 1920000, 2, 1651200, 21.64, 445.15, 9.2, 0),
      ("SXR2230P", 0, 1920000, 2, 1920000, 20.92, 446.87, 9.9, 0),
      ("SXR2230P", 0, 1920000, 2, 2054400, 18.88, 449.33, 10.92, 0),
      ("SXR2230P", 0, 1920000, 2, 2208000, 17.67, 452.42, 12.19, 0),
      ("SXR2230P", 0, 1920000, 2, 2361600, 20.34, 446.46, 10.13, 0),
      ("SXR2230P", 0, 2054400, 2, 691200, 25.29, 487.7, 11.34, 0),
      ("SXR2230P", 0, 2054400, 2, 960000, 21.23, 498.35, 13.13, 0),
      ("SXR2230P", 0, 2054400, 2, 1094400, 22.14, 499.03, 12.87, 0),
      ("SXR2230P", 0, 2054400, 2, 1228800, 25.15, 501.82, 10.88, 0),
      ("SXR2230P", 0, 2054400, 2, 1382400, 26.74, 494.33, 10.41, 0),
      ("SXR2230P", 0, 2054400, 2, 1516800, 23.5, 496.78, 11.63, 0),
      ("SXR2230P", 0, 2054400, 2, 1651200, 21.63, 497.24, 13.17, 0),
      ("SXR2230P", 0, 2054400, 2, 1920000, 25.96, 509.92, 9.92, 0),
      ("SXR2230P", 0, 2054400, 2, 2054400, 24.33, 505.24, 11.43, 0),
      ("SXR2230P", 0, 2054400, 2, 2208000, 21.87, 493.99, 13.22, 0),
      ("SXR2230P", 0, 2054400, 2, 2361600, 21.86, 500.45, 14.98, 0),
      ("SXR2230P", 0, 2208000, 2, 691200, 25.26, 574.75, 17.27, 0),
      ("SXR2230P", 0, 2208000, 2, 960000, 23.23, 584.93, 16.36, 0),
      ("SXR2230P", 0, 2208000, 2, 1094400, 30.38, 583.05, 13.17, 0),
      ("SXR2230P", 0, 2208000, 2, 1228800, 30.02, 584.26, 13.14, 0),
      ("SXR2230P", 0, 2208000, 2, 1382400, 24.91, 586.68, 15.8, 0),
      ("SXR2230P", 0, 2208000, 2, 1516800, 29.21, 583.11, 13.16, 0),
      ("SXR2230P", 0, 2208000, 2, 1651200, 29.1, 591.9, 13.36, 0),
      ("SXR2230P", 0, 2208000, 2, 1920000, 24.37, 583.06, 16.55, 0),
      ("SXR2230P", 0, 2208000, 2, 2054400, 28.96, 584.9, 14.02, 0),
      ("SXR2230P", 0, 2208000, 2, 2208000, 26.58, 571.14, 15.65, 0),
      ("SXR2230P", 0, 2208000, 2, 2361600, 29.37, 597.33, 13.77, 0),
      ("SXR2230P", 0, 2361600, 2, 691200, 37.04, 647.09, 15.06, 0),
      ("SXR2230P", 0, 2361600, 2, 960000, 36.23, 678.92, 15.13, 0),
      ("SXR2230P", 0, 2361600, 2, 1094400, 30.92, 674.54, 19.06, 0),
      ("SXR2230P", 0, 2361600, 2, 1228800, 36.11, 681.8, 14.71, 0),
      ("SXR2230P", 0, 2361600, 2, 1382400, 36.57, 687.57, 15.02, 0),
      ("SXR2230P", 0, 2361600, 2, 1516800, 31.04, 685.31, 18.26, 0),
      ("SXR2230P", 0, 2361600, 2, 1651200, 33.82, 685.91, 17.14, 0),
      ("SXR2230P", 0, 2361600, 2, 1920000, 32.44, 690.61, 18.78, 0),
      ("SXR2230P", 0, 2361600, 2, 2054400, 32.02, 685.81, 18.99, 0),
      ("SXR2230P", 0, 2361600, 2, 2208000, 28.21, 686.98, 21.17, 0),
      ("SXR2230P", 0, 2361600, 2, 2361600, 34.34, 682.86, 17.29, 0),
      ("Tensor", 0, 300000, 4, 400000, 3.73, 21.84, 0.47, 0),
      ("Tensor", 0, 300000, 4, 553000, 5.66, 18.97, 0.99, 0),
      ("Tensor", 0, 300000, 6, 500000, 2.61, 22.89, 0.76, 0),
      ("Tensor", 0, 574000, 4, 400000, 5.73, 35.85, 0.93, 0),
      ("Tensor", 0, 574000, 4, 553000, 5.41, 36.54, 0.98, 0),
      ("Tensor", 0, 574000, 4, 696000, 5.61, 32.98, 0.99, 0),
      ("Tensor", 0, 574000, 4, 799000, 9.7, 40.29, 1.33, 0),
      ("Tensor", 0, 574000, 4, 910000, 9.81, 44.42, 1.24, 0),
      ("Tensor", 0, 574000, 4, 1024000, 9.71, 43.95, 1.31, 0),
      ("Tensor", 0, 574000, 6, 500000, 5.6, 34.69, 1.03, 0),
      ("Tensor", 0, 574000, 6, 851000, 5.57, 33.66, 1.02, 0),
      ("Tensor", 0, 574000, 6, 984000, 5.68, 36.2, 0.98, 0),
      ("Tensor", 0, 574000, 6, 1106000, 5.59, 36.27, 1.02, 0),
      ("Tensor", 0, 738000, 4, 400000, 6.62, 47.66, 1.08, 0),
      ("Tensor", 0, 738000, 4, 553000, 6.7, 45.71, 1.03, 0),
      ("Tensor", 0, 738000, 4, 696000, 6.7, 46.21, 1.04, 0),
      ("Tensor", 0, 738000, 4, 799000, 9.8, 55.47, 1.23, 0),
      ("Tensor", 0, 738000, 4, 910000, 9.69, 52.58, 1.31, 0),
      ("Tensor", 0, 738000, 4, 1024000, 9.77, 54.81, 1.3, 0),
      ("Tensor", 0, 738000, 4, 1197000, 18.75, 75.3, 2.05, 0),
      ("Tensor", 0, 738000, 4, 1328000, 18.98, 75.84, 1.91, 0),
      ("Tensor", 0, 738000, 6, 500000, 6.63, 44.56, 1.11, 0),
      ("Tensor", 0, 738000, 6, 851000, 6.65, 46.62, 1.08, 0),
      ("Tensor", 0, 738000, 6, 984000, 6.63, 50.28, 1.08, 0),
      ("Tensor", 0, 738000, 6, 1106000, 6.74, 44.83, 1.07, 0),
      ("Tensor", 0, 738000, 6, 1277000, 6.6, 44.15, 1.09, 0),
      ("Tensor", 0, 738000, 6, 1426000, 18.97, 74.73, 1.94, 0),
      ("Tensor", 0, 930000, 4, 400000, 9.64, 81.16, 1.27, 0),
      ("Tensor", 0, 930000, 4, 553000, 9.88, 67.4, 1.28, 0),
      ("Tensor", 0, 930000, 4, 696000, 9.69, 67.33, 1.3, 0),
      ("Tensor", 0, 930000, 4, 799000, 9.69, 67.82, 1.3, 0),
      ("Tensor", 0, 930000, 4, 910000, 9.79, 67.52, 1.29, 0),
      ("Tensor", 0, 930000, 4, 1024000, 9.75, 65.44, 1.28, 0),
      ("Tensor", 0, 930000, 4, 1197000, 18.84, 83.73, 2.0, 0),
      ("Tensor", 0, 930000, 4, 1328000, 18.88, 101.57, 1.97, 0),
      ("Tensor", 0, 930000, 4, 1491000, 18.86, 94.45, 1.99, 0),
      ("Tensor", 0, 930000, 4, 1663000, 35.46, 134.93, 3.29, 0),
      ("Tensor", 0, 930000, 4, 1836000, 35.34, 135.55, 3.36, 0),
      ("Tensor", 0, 930000, 6, 500000, 9.76, 66.0, 1.28, 0),
      ("Tensor", 0, 930000, 6, 851000, 9.8, 73.08, 1.24, 0),
      ("Tensor", 0, 930000, 6, 984000, 9.75, 74.87, 1.25, 0),
      ("Tensor", 0, 930000, 6, 1106000, 9.68, 77.31, 1.3, 0),
      ("Tensor", 0, 930000, 6, 1277000, 9.83, 80.03, 1.25, 0),
      ("Tensor", 0, 930000, 6, 1426000, 19.01, 98.31, 1.94, 0),
      ("Tensor", 0, 930000, 6, 1582000, 18.94, 94.51, 1.98, 0),
      ("Tensor", 0, 930000, 6, 1745000, 19.0, 94.38, 1.93, 0),
      ("Tensor", 0, 930000, 6, 1826000, 18.98, 100.84, 1.92, 0),
      ("Tensor", 0, 1098000, 4, 400000, 12.93, 109.45, 1.47, 0),
      ("Tensor", 0, 1098000, 4, 553000, 12.92, 120.82, 1.48, 0),
      ("Tensor", 0, 1098000, 4, 696000, 13.09, 107.17, 1.41, 0),
      ("Tensor", 0, 1098000, 4, 799000, 12.82, 91.84, 1.56, 0),
      ("Tensor", 0, 1098000, 4, 910000, 12.88, 99.1, 1.52, 0),
      ("Tensor", 0, 1098000, 4, 1024000, 12.81, 87.32, 1.57, 0),
      ("Tensor", 0, 1098000, 4, 1197000, 18.92, 115.83, 1.97, 0),
      ("Tensor", 0, 1098000, 4, 1328000, 18.97, 137.08, 1.93, 0),
      ("Tensor", 0, 1098000, 4, 1491000, 18.94, 120.36, 1.94, 0),
      ("Tensor", 0, 1098000, 4, 1663000, 35.21, 156.0, 3.43, 0),
      ("Tensor", 0, 1098000, 4, 1836000, 35.21, 155.3, 3.42, 0),
      ("Tensor", 0, 1098000, 4, 1999000, 35.49, 157.04, 3.24, 0),
      ("Tensor", 0, 1098000, 4, 2130000, 35.17, 156.91, 3.41, 0),
      ("Tensor", 0, 1098000, 6, 500000, 13.0, 93.54, 1.45, 0),
      ("Tensor", 0, 1098000, 6, 851000, 13.12, 104.28, 1.4, 0),
      ("Tensor", 0, 1098000, 6, 984000, 12.85, 94.73, 1.52, 0),
      ("Tensor", 0, 1098000, 6, 1106000, 12.68, 95.73, 1.6, 0),
      ("Tensor", 0, 1098000, 6, 1277000, 12.94, 92.78, 1.46, 0),
      ("Tensor", 0, 1098000, 6, 1426000, 18.81, 128.5, 2.03, 0),
      ("Tensor", 0, 1098000, 6, 1582000, 19.0, 124.51, 1.89, 0),
      ("Tensor", 0, 1098000, 6, 1745000, 18.75, 121.84, 2.0, 0),
      ("Tensor", 0, 1098000, 6, 1826000, 19.01, 117.69, 1.9, 0),
      ("Tensor", 0, 1098000, 6, 2048000, 18.97, 107.49, 1.89, 0),
      ("Tensor", 0, 1098000, 6, 2188000, 18.95, 124.24, 1.92, 0),
      ("Tensor", 0, 1197000, 4, 400000, 14.5, 128.64, 1.54, 0),
      ("Tensor", 0, 1197000, 4, 553000, 14.41, 126.94, 1.58, 0),
      ("Tensor", 0, 1197000, 4, 696000, 14.43, 123.96, 1.63, 0),
      ("Tensor", 0, 1197000, 4, 799000, 14.39, 125.32, 1.59, 0),
      ("Tensor", 0, 1197000, 4, 910000, 14.42, 126.37, 1.55, 0),
      ("Tensor", 0, 1197000, 4, 1024000, 14.5, 110.43, 1.54, 0),
      ("Tensor", 0, 1197000, 4, 1197000, 19.0, 121.68, 1.9, 222.0),
      ("Tensor", 0, 1197000, 4, 1328000, 18.88, 122.27, 1.96, 0),
      ("Tensor", 0, 1197000, 4, 1491000, 18.84, 118.62, 1.98, 0),
      ("Tensor", 0, 1197000, 4, 1663000, 35.35, 175.31, 3.32, 0),
      ("Tensor", 0, 1197000, 4, 1836000, 35.37, 178.17, 3.38, 0),
      ("Tensor", 0, 1197000, 4, 1999000, 35.34, 186.68, 3.38, 0),
      ("Tensor", 0, 1197000, 4, 2130000, 35.37, 176.06, 3.34, 0),
      ("Tensor", 0, 1197000, 4, 2253000, 35.29, 169.24, 3.38, 111.0),
      ("Tensor", 0, 1197000, 6, 500000, 14.47, 95.77, 1.55, 0),
      ("Tensor", 0, 1197000, 6, 851000, 14.42, 101.17, 1.6, 0),
      ("Tensor", 0, 1197000, 6, 984000, 14.21, 116.52, 1.68, 0),
      ("Tensor", 0, 1197000, 6, 1106000, 14.32, 111.16, 1.62, 0),
      ("Tensor", 0, 1197000, 6, 1277000, 14.42, 84.46, 1.6, 0),
      ("Tensor", 0, 1197000, 6, 1426000, 18.83, 130.44, 2.01, 0),
      ("Tensor", 0, 1197000, 6, 1582000, 18.98, 140.9, 1.9, 0),
      ("Tensor", 0, 1197000, 6, 1745000, 18.82, 143.87, 1.94, 0),
      ("Tensor", 0, 1197000, 6, 1826000, 18.91, 131.75, 1.96, 0),
      ("Tensor", 0, 1197000, 6, 2048000, 18.99, 128.36, 1.96, 0),
      ("Tensor", 0, 1197000, 6, 2188000, 18.71, 132.46, 2.07, 0),
      ("Tensor", 0, 1197000, 6, 2252000, 18.82, 130.95, 2.0, 0),
      ("Tensor", 0, 1328000, 4, 400000, 17.0, 135.89, 1.84, 0),
      ("Tensor", 0, 1328000, 4, 553000, 17.1, 161.84, 1.78, 0),
      ("Tensor", 0, 1328000, 4, 696000, 16.99, 142.03, 1.87, 0),
      ("Tensor", 0, 1328000, 4, 799000, 17.07, 169.36, 1.83, 0),
      ("Tensor", 0, 1328000, 4, 910000, 17.19, 111.73, 1.81, 0),
      ("Tensor", 0, 1328000, 4, 1024000, 17.21, 128.66, 1.78, 0),
      ("Tensor", 0, 1328000, 4, 1197000, 18.83, 129.66, 2.02, 0),
      ("Tensor", 0, 1328000, 4, 1328000, 18.88, 132.55, 1.96, 0),
      ("Tensor", 0, 1328000, 4, 1491000, 18.87, 146.14, 2.0, 0),
      ("Tensor", 0, 1328000, 4, 1663000, 35.43, 185.94, 3.27, 0),
      ("Tensor", 0, 1328000, 4, 1836000, 35.46, 165.55, 3.27, 0),
      ("Tensor", 0, 1328000, 4, 1999000, 35.37, 186.76, 3.29, 0),
      ("Tensor", 0, 1328000, 4, 2130000, 35.35, 207.2, 3.34, 0),
      ("Tensor", 0, 1328000, 4, 2253000, 35.31, 209.73, 3.42, 0),
      ("Tensor", 0, 1328000, 6, 500000, 17.15, 130.76, 1.77, 0),
      ("Tensor", 0, 1328000, 6, 851000, 17.06, 123.6, 1.84, 0),
      ("Tensor", 0, 1328000, 6, 984000, 17.21, 130.23, 1.77, 0),
      ("Tensor", 0, 1328000, 6, 1106000, 17.16, 139.65, 1.84, 0),
      ("Tensor", 0, 1328000, 6, 1277000, 17.14, 123.95, 1.83, 0),
      ("Tensor", 0, 1328000, 6, 1426000, 19.15, 141.04, 1.91, 0),
      ("Tensor", 0, 1328000, 6, 1582000, 19.13, 108.29, 1.91, 0),
      ("Tensor", 0, 1328000, 6, 1745000, 19.12, 133.38, 1.9, 0),
      ("Tensor", 0, 1328000, 6, 1826000, 18.87, 137.51, 2.06, 0),
      ("Tensor", 0, 1328000, 6, 2048000, 19.02, 145.9, 1.96, 0),
      ("Tensor", 0, 1328000, 6, 2188000, 19.06, 129.5, 1.94, 0),
      ("Tensor", 0, 1328000, 6, 2252000, 19.05, 125.72, 1.91, 0),
      ("Tensor", 0, 1328000, 6, 2401000, 35.57, 187.29, 3.33, 0),
      ("Tensor", 0, 1328000, 6, 2507000, 35.38, 213.14, 3.44, 0),
      ("Tensor", 0, 1328000, 6, 2630000, 35.47, 181.15, 3.41, 0),
      ("Tensor", 0, 1401000, 4, 400000, 18.85, 184.12, 2.06, 0),
      ("Tensor", 0, 1401000, 4, 553000, 18.91, 168.23, 1.98, 0),
      ("Tensor", 0, 1401000, 4, 696000, 19.11, 184.69, 1.92, 0),
      ("Tensor", 0, 1401000, 4, 799000, 19.16, 175.13, 1.91, 0),
      ("Tensor", 0, 1401000, 4, 910000, 19.02, 161.7, 1.97, 0),
      ("Tensor", 0, 1401000, 4, 1024000, 18.97, 156.68, 2.01, 0),
      ("Tensor", 0, 1401000, 4, 1197000, 19.07, 155.0, 1.97, 0),
      ("Tensor", 0, 1401000, 4, 1328000, 18.95, 159.64, 1.96, 0),
      ("Tensor", 0, 1401000, 4, 1491000, 19.13, 136.78, 1.95, 0),
      ("Tensor", 0, 1401000, 4, 1663000, 35.67, 186.73, 3.29, 0),
      ("Tensor", 0, 1401000, 4, 1836000, 35.51, 220.26, 3.45, 0),
      ("Tensor", 0, 1401000, 4, 1999000, 35.75, 249.18, 3.3, 0),
      ("Tensor", 0, 1401000, 4, 2130000, 35.65, 217.48, 3.4, 0),
      ("Tensor", 0, 1401000, 4, 2253000, 35.66, 248.9, 3.41, 0),
      ("Tensor", 0, 1401000, 6, 500000, 19.05, 152.39, 1.98, 0),
      ("Tensor", 0, 1401000, 6, 851000, 19.0, 148.12, 2.03, 0),
      ("Tensor", 0, 1401000, 6, 984000, 19.01, 128.71, 2.0, 0),
      ("Tensor", 0, 1401000, 6, 1106000, 18.18, 132.83, 2.01, 0),
      ("Tensor", 0, 1401000, 6, 1277000, 19.07, 138.09, 1.95, 0),
      ("Tensor", 0, 1401000, 6, 1426000, 18.92, 144.69, 2.05, 0),
      ("Tensor", 0, 1401000, 6, 1582000, 18.95, 151.34, 2.05, 0),
      ("Tensor", 0, 1401000, 6, 1745000, 18.98, 152.04, 2.01, 0),
      ("Tensor", 0, 1401000, 6, 1826000, 19.11, 151.71, 1.95, 0),
      ("Tensor", 0, 1401000, 6, 2048000, 19.04, 136.69, 1.98, 0),
      ("Tensor", 0, 1401000, 6, 2188000, 18.97, 152.56, 2.0, 0),
      ("Tensor", 0, 1401000, 6, 2252000, 19.09, 149.02, 1.97, 0),
      ("Tensor", 0, 1401000, 6, 2401000, 35.91, 210.3, 3.23, 0),
      ("Tensor", 0, 1401000, 6, 2507000, 35.64, 188.64, 3.32, 0),
      ("Tensor", 0, 1401000, 6, 2630000, 35.41, 202.75, 3.5, 0),
      ("Tensor", 0, 1401000, 6, 2704000, 35.69, 204.49, 3.4, 0),
      ("Tensor", 0, 1401000, 6, 2802000, 35.64, 208.14, 3.45, 0),
      ("Tensor", 0, 1598000, 4, 400000, 24.83, 196.05, 2.36, 0),
      ("Tensor", 0, 1598000, 4, 553000, 24.68, 234.53, 2.37, 0),
      ("Tensor", 0, 1598000, 4, 696000, 24.71, 230.15, 2.34, 0),
      ("Tensor", 0, 1598000, 4, 799000, 24.87, 175.64, 2.34, 0),
      ("Tensor", 0, 1598000, 4, 910000, 24.76, 228.23, 2.36, 0),
      ("Tensor", 0, 1598000, 4, 1024000, 24.6, 228.37, 2.47, 0),
      ("Tensor", 0, 1598000, 4, 1197000, 24.77, 201.12, 2.43, 0),
      ("Tensor", 0, 1598000, 4, 1328000, 24.68, 202.37, 2.41, 0),
      ("Tensor", 0, 1598000, 4, 1491000, 24.58, 199.78, 2.52, 0),
      ("Tensor", 0, 1598000, 4, 1663000, 35.59, 210.2, 3.46, 0),
      ("Tensor", 0, 1598000, 4, 1836000, 35.74, 315.02, 3.33, 0),
      ("Tensor", 0, 1598000, 4, 1999000, 35.65, 285.37, 3.44, 0),
      ("Tensor", 0, 1598000, 4, 2130000, 35.31, 256.84, 3.7, 0),
      ("Tensor", 0, 1598000, 4, 2253000, 35.91, 255.65, 3.37, 0),
      ("Tensor", 0, 1598000, 6, 500000, 24.78, 184.21, 2.34, 0),
      ("Tensor", 0, 1598000, 6, 851000, 24.73, 175.69, 2.41, 0),
      ("Tensor", 0, 1598000, 6, 984000, 24.68, 195.14, 2.43, 0),
      ("Tensor", 0, 1598000, 6, 1106000, 24.65, 194.89, 2.46, 0),
      ("Tensor", 0, 1598000, 6, 1277000, 24.63, 167.1, 2.49, 0),
      ("Tensor", 0, 1598000, 6, 1426000, 24.7, 190.42, 2.45, 0),
      ("Tensor", 0, 1598000, 6, 1582000, 24.79, 190.72, 2.39, 0),
      ("Tensor", 0, 1598000, 6, 1745000, 24.73, 180.52, 2.44, 0),
      ("Tensor", 0, 1598000, 6, 1826000, 24.72, 203.15, 2.4, 0),
      ("Tensor", 0, 1598000, 6, 2048000, 24.82, 197.7, 2.39, 0),
      ("Tensor", 0, 1598000, 6, 2188000, 24.7, 185.45, 2.47, 0),
      ("Tensor", 0, 1598000, 6, 2252000, 24.83, 155.38, 2.35, 0),
      ("Tensor", 0, 1598000, 6, 2401000, 36.0, 237.12, 3.25, 0),
      ("Tensor", 0, 1598000, 6, 2507000, 35.89, 253.55, 3.34, 0),
      ("Tensor", 0, 1598000, 6, 2630000, 35.76, 208.38, 3.45, 0),
      ("Tensor", 0, 1598000, 6, 2704000, 35.7, 218.73, 3.46, 0),
      ("Tensor", 0, 1598000, 6, 2802000, 35.65, 248.51, 3.47, 0),
      ("Tensor", 0, 1704000, 4, 400000, 28.98, 234.84, 2.73, 0),
      ("Tensor", 0, 1704000, 4, 553000, 29.01, 210.31, 2.66, 0),
      ("Tensor", 0, 1704000, 4, 696000, 28.95, 300.74, 2.73, 0),
      ("Tensor", 0, 1704000, 4, 799000, 28.77, 270.96, 2.79, 0),
      ("Tensor", 0, 1704000, 4, 910000, 28.84, 284.84, 2.76, 0),
      ("Tensor", 0, 1704000, 4, 1024000, 28.76, 251.86, 2.85, 0),
      ("Tensor", 0, 1704000, 4, 1197000, 28.75, 256.3, 2.78, 0),
      ("Tensor", 0, 1704000, 4, 1328000, 28.65, 246.88, 2.86, 0),
      ("Tensor", 0, 1704000, 4, 1491000, 28.73, 267.07, 2.88, 0),
      ("Tensor", 0, 1704000, 4, 1663000, 35.81, 266.03, 3.49, 0),
      ("Tensor", 0, 1704000, 4, 1836000, 35.78, 274.06, 3.35, 0),
      ("Tensor", 0, 1704000, 4, 1999000, 35.67, 268.14, 3.46, 0),
      ("Tensor", 0, 1704000, 4, 2130000, 35.75, 273.4, 3.41, 0),
      ("Tensor", 0, 1704000, 4, 2253000, 35.42, 276.92, 3.72, 0),
      ("Tensor", 0, 1704000, 6, 500000, 29.1, 239.74, 2.65, 0),
      ("Tensor", 0, 1704000, 6, 851000, 28.79, 216.53, 2.74, 0),
      ("Tensor", 0, 1704000, 6, 984000, 28.9, 259.03, 2.76, 0),
      ("Tensor", 0, 1704000, 6, 1106000, 28.71, 211.76, 2.82, 0),
      ("Tensor", 0, 1704000, 6, 1277000, 28.79, 216.77, 2.8, 0),
      ("Tensor", 0, 1704000, 6, 1426000, 28.94, 207.8, 2.71, 0),
      ("Tensor", 0, 1704000, 6, 1582000, 28.96, 232.83, 2.67, 0),
      ("Tensor", 0, 1704000, 6, 1745000, 28.67, 237.37, 2.85, 0),
      ("Tensor", 0, 1704000, 6, 1826000, 29.0, 224.71, 2.71, 0),
      ("Tensor", 0, 1704000, 6, 2048000, 28.86, 239.69, 2.73, 0),
      ("Tensor", 0, 1704000, 6, 2188000, 28.88, 218.8, 2.76, 0),
      ("Tensor", 0, 1704000, 6, 2252000, 28.87, 272.23, 2.76, 0),
      ("Tensor", 0, 1704000, 6, 2401000, 35.74, 258.98, 3.33, 0),
      ("Tensor", 0, 1704000, 6, 2507000, 35.74, 276.92, 3.4, 0),
      ("Tensor", 0, 1704000, 6, 2630000, 35.71, 249.7, 3.45, 0),
      ("Tensor", 0, 1704000, 6, 2704000, 36.01, 253.04, 3.29, 0),
      ("Tensor", 0, 1704000, 6, 2802000, 35.91, 266.15, 3.4, 0),
      ("Tensor", 0, 1803000, 4, 400000, 35.71, 342.95, 3.49, 0),
      ("Tensor", 0, 1803000, 4, 553000, 35.76, 330.57, 3.41, 0),
      ("Tensor", 0, 1803000, 4, 696000, 35.71, 355.0, 3.41, 0),
      ("Tensor", 0, 1803000, 4, 799000, 35.67, 310.42, 3.45, 0),
      ("Tensor", 0, 1803000, 4, 910000, 35.95, 309.22, 3.38, 0),
      ("Tensor", 0, 1803000, 4, 1024000, 35.6, 303.94, 3.55, 0),
      ("Tensor", 0, 1803000, 4, 1197000, 36.0, 346.31, 3.26, 0),
      ("Tensor", 0, 1803000, 4, 1328000, 35.9, 300.16, 3.36, 0),
      ("Tensor", 0, 1803000, 4, 1491000, 35.88, 215.33, 3.33, 0),
      ("Tensor", 0, 1803000, 4, 1663000, 35.72, 284.35, 3.47, 0),
      ("Tensor", 0, 1803000, 4, 1836000, 35.9, 289.0, 3.32, 0),
      ("Tensor", 0, 1803000, 4, 1999000, 34.96, 293.38, 3.33, 0),
      ("Tensor", 0, 1803000, 4, 2130000, 35.07, 359.86, 3.19, 0),
      ("Tensor", 0, 1803000, 4, 2253000, 35.07, 295.24, 3.23, 0),
      ("Tensor", 0, 1803000, 6, 500000, 34.68, 223.89, 3.4, 0),
      ("Tensor", 0, 1803000, 6, 851000, 34.74, 261.39, 3.4, 0),
      ("Tensor", 0, 1803000, 6, 984000, 35.08, 269.51, 3.26, 0),
      ("Tensor", 0, 1803000, 6, 1106000, 35.06, 269.58, 3.21, 0),
      ("Tensor", 0, 1803000, 6, 1277000, 34.87, 218.3, 3.39, 0),
      ("Tensor", 0, 1803000, 6, 1426000, 34.86, 264.34, 3.36, 0),
      ("Tensor", 0, 1803000, 6, 1582000, 34.9, 263.56, 3.36, 0),
      ("Tensor", 0, 1803000, 6, 1745000, 35.09, 210.36, 3.29, 0),
      ("Tensor", 0, 1803000, 6, 1826000, 35.06, 256.1, 3.34, 0),
      ("Tensor", 0, 1803000, 6, 2048000, 35.18, 269.91, 3.16, 0),
      ("Tensor", 0, 1803000, 6, 2188000, 35.16, 261.04, 3.25, 0),
      ("Tensor", 0, 1803000, 6, 2252000, 34.84, 272.92, 3.49, 0),
      ("Tensor", 0, 1803000, 6, 2401000, 35.2, 260.24, 3.38, 0),
      ("Tensor", 0, 1803000, 6, 2507000, 34.89, 240.7, 3.58, 0),
      ("Tensor", 0, 1803000, 6, 2630000, 35.21, 150.76, 3.42, 0),
      ("Tensor", 0, 1803000, 6, 2704000, 35.2, 277.28, 3.44, 0),
      ("Tensor", 0, 1803000, 6, 2802000, 35.12, 269.2, 3.62, 0),
      ("Tensor G4", 0, 820000, _dsu_dep!(), 610000, 3.3, 47.6, 1.04, 0),
      ("Tensor G4", 0, 820000, _dsu_dep!(), 820000, 6.77, 65.48, 1.17, 0),
      ("Tensor G4", 0, 820000, _dsu_dep!(), 970000, 8.61, 78.56, 1.28, 0),
      ("Tensor G4", 0, 820000, _dsu_dep!(), 1098000, 12.5, 92.7, 1.28, 0),
      ("Tensor G4", 0, 820000, _dsu_dep!(), 1197000, 15.24, 110.72, 1.46, 0),
      ("Tensor G4", 0, 820000, _dsu_dep!(), 1328000, 21.73, 134.04, 1.58, 0),
      ("Tensor G4", 0, 820000, _dsu_dep!(), 1444000, 26.89, 151.02, 1.75, 0),
      ("Tensor G4", 0, 820000, _dsu_dep!(), 1548000, 31.53, 164.93, 1.8, 0),
      ("Tensor G4", 0, 820000, _dsu_dep!(), 1704000, 43.86, 157.18, 2.24, 0),
      ("Tensor G4", 0, 820000, _dsu_dep!(), 1800000, 52.1, 137.62, 2.64, 0),
      ("Tensor G4", 0, 820000, _dsu_dep!(), 1880000, 59.74, 145.28, 2.44, 0),
      ("Tensor G4", 0, 820000, _dsu_dep!(), 1950000, 71.34, 156.19, 3.12, 0),
      ("Tensor G4", 0, 820000, _dsu_dep!(), 2024000, 86.3, 155.05, 3.53, 0),
      ("Tensor G4", 0, 820000, _dsu_dep!(), 2120000, 112.45, 176.15, 4.74, 0),
      ("Tensor G4", 0, 820000, _dsu_dep!(), 2150000, 112.1, 155.11, 4.69, 0),
      ("Tensor G4", 0, 955000, _dsu_dep!(), 610000, 6.18, 56.03, 0.68, 0),
      ("Tensor G4", 0, 955000, _dsu_dep!(), 820000, 6.39, 74.22, 1.21, 0),
      ("Tensor G4", 0, 955000, _dsu_dep!(), 970000, 9.18, 82.2, 1.26, 0),
      ("Tensor G4", 0, 955000, _dsu_dep!(), 1098000, 12.62, 98.11, 1.34, 0),
      ("Tensor G4", 0, 955000, _dsu_dep!(), 1197000, 15.72, 117.95, 1.41, 0),
      ("Tensor G4", 0, 955000, _dsu_dep!(), 1328000, 21.94, 141.91, 1.57, 0),
      ("Tensor G4", 0, 955000, _dsu_dep!(), 1444000, 27.38, 162.99, 1.85, 0),
      ("Tensor G4", 0, 955000, _dsu_dep!(), 1548000, 31.94, 175.19, 1.72, 0),
      ("Tensor G4", 0, 955000, _dsu_dep!(), 1704000, 43.84, 130.38, 2.44, 0),
      ("Tensor G4", 0, 955000, _dsu_dep!(), 1800000, 52.67, 117.99, 2.5, 0),
      ("Tensor G4", 0, 955000, _dsu_dep!(), 1880000, 59.69, 145.08, 2.91, 0),
      ("Tensor G4", 0, 955000, _dsu_dep!(), 1950000, 73.33, 141.24, 3.23, 0),
      ("Tensor G4", 0, 955000, _dsu_dep!(), 2024000, 86.96, 171.19, 3.7, 0),
      ("Tensor G4", 0, 955000, _dsu_dep!(), 2120000, 112.7, 188.38, 5.0, 0),
      ("Tensor G4", 0, 955000, _dsu_dep!(), 2150000, 111.86, 179.34, 5.53, 0),
      ("Tensor G4", 0, 1098000, _dsu_dep!(), 610000, 7.23, 66.6, 1.26, 0),
      ("Tensor G4", 0, 1098000, _dsu_dep!(), 820000, 8.04, 80.19, 1.21, 0),
      ("Tensor G4", 0, 1098000, _dsu_dep!(), 970000, 9.56, 90.34, 1.22, 0),
      ("Tensor G4", 0, 1098000, _dsu_dep!(), 1098000, 12.86, 109.5, 1.33, 0),
      ("Tensor G4", 0, 1098000, _dsu_dep!(), 1197000, 16.57, 120.41, 1.07, 0),
      ("Tensor G4", 0, 1098000, _dsu_dep!(), 1328000, 22.15, 145.31, 1.54, 0),
      ("Tensor G4", 0, 1098000, _dsu_dep!(), 1444000, 27.91, 163.9, 1.68, 0),
      ("Tensor G4", 0, 1098000, _dsu_dep!(), 1548000, 32.01, 174.89, 1.87, 0),
      ("Tensor G4", 0, 1098000, _dsu_dep!(), 1704000, 44.5, 139.63, 2.24, 0),
      ("Tensor G4", 0, 1098000, _dsu_dep!(), 1800000, 53.21, 140.32, 2.52, 0),
      ("Tensor G4", 0, 1098000, _dsu_dep!(), 1880000, 60.44, 157.97, 2.83, 0),
      ("Tensor G4", 0, 1098000, _dsu_dep!(), 1950000, 73.65, 169.76, 3.28, 0),
      ("Tensor G4", 0, 1098000, _dsu_dep!(), 2024000, 87.15, 182.83, 3.98, 0),
      ("Tensor G4", 0, 1098000, _dsu_dep!(), 2120000, 114.08, 187.49, 4.17, 0),
      ("Tensor G4", 0, 1098000, _dsu_dep!(), 2150000, 113.79, 189.6, 4.65, 0),
      ("Tensor G4", 0, 1197000, _dsu_dep!(), 610000, 8.34, 75.11, 1.27, 0),
      ("Tensor G4", 0, 1197000, _dsu_dep!(), 820000, 9.54, 84.82, 1.14, 0),
      ("Tensor G4", 0, 1197000, _dsu_dep!(), 970000, 10.37, 89.93, 1.18, 0),
      ("Tensor G4", 0, 1197000, _dsu_dep!(), 1098000, 12.81, 104.44, 1.37, 0),
      ("Tensor G4", 0, 1197000, _dsu_dep!(), 1197000, 16.36, 129.81, 1.39, 0),
      ("Tensor G4", 0, 1197000, _dsu_dep!(), 1328000, 22.4, 145.01, 1.64, 0),
      ("Tensor G4", 0, 1197000, _dsu_dep!(), 1444000, 28.1, 170.53, 1.61, 0),
      ("Tensor G4", 0, 1197000, _dsu_dep!(), 1548000, 32.23, 186.28, 1.91, 0),
      ("Tensor G4", 0, 1197000, _dsu_dep!(), 1704000, 44.93, 156.69, 2.32, 0),
      ("Tensor G4", 0, 1197000, _dsu_dep!(), 1800000, 53.17, 151.91, 2.43, 0),
      ("Tensor G4", 0, 1197000, _dsu_dep!(), 1880000, 60.94, 141.69, 2.72, 0),
      ("Tensor G4", 0, 1197000, _dsu_dep!(), 1950000, 73.72, 189.86, 3.42, 0),
      ("Tensor G4", 0, 1197000, _dsu_dep!(), 2024000, 87.87, 158.58, 3.7, 0),
      ("Tensor G4", 0, 1197000, _dsu_dep!(), 2120000, 114.16, 193.12, 4.81, 0),
      ("Tensor G4", 0, 1197000, _dsu_dep!(), 2150000, 113.59, 191.22, 4.8, 0),
      ("Tensor G4", 0, 1328000, _dsu_dep!(), 610000, 10.73, 90.03, 1.33, 0),
      ("Tensor G4", 0, 1328000, _dsu_dep!(), 820000, 11.88, 99.06, 1.31, 0),
      ("Tensor G4", 0, 1328000, _dsu_dep!(), 970000, 12.77, 106.72, 1.33, 0),
      ("Tensor G4", 0, 1328000, _dsu_dep!(), 1098000, 13.12, 110.06, 1.39, 0),
      ("Tensor G4", 0, 1328000, _dsu_dep!(), 1197000, 16.68, 127.98, 1.33, 0),
      ("Tensor G4", 0, 1328000, _dsu_dep!(), 1328000, 22.66, 154.27, 1.68, 0),
      ("Tensor G4", 0, 1328000, _dsu_dep!(), 1444000, 28.49, 174.25, 1.72, 0),
      ("Tensor G4", 0, 1328000, _dsu_dep!(), 1548000, 32.16, 191.25, 1.73, 0),
      ("Tensor G4", 0, 1328000, _dsu_dep!(), 1704000, 44.27, 129.41, 2.25, 0),
      ("Tensor G4", 0, 1328000, _dsu_dep!(), 1800000, 53.79, 154.61, 2.51, 0),
      ("Tensor G4", 0, 1328000, _dsu_dep!(), 1880000, 61.04, 163.47, 2.68, 0),
      ("Tensor G4", 0, 1328000, _dsu_dep!(), 1950000, 75.05, 189.16, 3.08, 0),
      ("Tensor G4", 0, 1328000, _dsu_dep!(), 2024000, 89.05, 204.54, 3.43, 0),
      ("Tensor G4", 0, 1328000, _dsu_dep!(), 2120000, 115.33, 210.24, 4.36, 0),
      ("Tensor G4", 0, 1328000, _dsu_dep!(), 2150000, 114.98, 206.93, 4.34, 0),
      ("Tensor G4", 0, 1425000, _dsu_dep!(), 610000, 13.32, 101.33, 1.43, 0),
      ("Tensor G4", 0, 1425000, _dsu_dep!(), 820000, 14.56, 111.02, 1.46, 0),
      ("Tensor G4", 0, 1425000, _dsu_dep!(), 970000, 15.11, 121.09, 1.47, 0),
      ("Tensor G4", 0, 1425000, _dsu_dep!(), 1098000, 16.25, 128.03, 1.41, 0),
      ("Tensor G4", 0, 1425000, _dsu_dep!(), 1197000, 16.68, 127.43, 1.45, 0),
      ("Tensor G4", 0, 1425000, _dsu_dep!(), 1328000, 22.57, 156.98, 1.68, 0),
      ("Tensor G4", 0, 1425000, _dsu_dep!(), 1444000, 28.81, 182.29, 1.72, 0),
      ("Tensor G4", 0, 1425000, _dsu_dep!(), 1548000, 33.08, 198.0, 1.83, 0),
      ("Tensor G4", 0, 1425000, _dsu_dep!(), 1704000, 45.21, 162.21, 2.12, 0),
      ("Tensor G4", 0, 1425000, _dsu_dep!(), 1800000, 54.37, 167.27, 2.5, 0),
      ("Tensor G4", 0, 1425000, _dsu_dep!(), 1880000, 61.48, 116.14, 2.89, 0),
      ("Tensor G4", 0, 1425000, _dsu_dep!(), 1950000, 74.85, 180.6, 3.49, 0),
      ("Tensor G4", 0, 1425000, _dsu_dep!(), 2024000, 89.32, 187.51, 3.6, 0),
      ("Tensor G4", 0, 1425000, _dsu_dep!(), 2120000, 115.2, 203.97, 4.57, 0),
      ("Tensor G4", 0, 1425000, _dsu_dep!(), 2150000, 115.53, 210.01, 4.25, 0),
      ("Tensor G4", 0, 1548000, _dsu_dep!(), 610000, 16.36, 123.83, 1.45, 0),
      ("Tensor G4", 0, 1548000, _dsu_dep!(), 820000, 17.5, 128.9, 1.62, 0),
      ("Tensor G4", 0, 1548000, _dsu_dep!(), 970000, 18.34, 139.52, 1.58, 0),
      ("Tensor G4", 0, 1548000, _dsu_dep!(), 1098000, 19.32, 149.77, 1.53, 0),
      ("Tensor G4", 0, 1548000, _dsu_dep!(), 1197000, 19.8, 152.01, 1.43, 0),
      ("Tensor G4", 0, 1548000, _dsu_dep!(), 1328000, 22.59, 159.55, 1.61, 0),
      ("Tensor G4", 0, 1548000, _dsu_dep!(), 1444000, 28.75, 198.79, 1.86, 0),
      ("Tensor G4", 0, 1548000, _dsu_dep!(), 1548000, 33.46, 211.95, 1.77, 0),
      ("Tensor G4", 0, 1548000, _dsu_dep!(), 1704000, 46.36, 169.26, 2.11, 0),
      ("Tensor G4", 0, 1548000, _dsu_dep!(), 1800000, 54.71, 177.24, 2.42, 0),
      ("Tensor G4", 0, 1548000, _dsu_dep!(), 1880000, 62.25, 145.44, 2.76, 0),
      ("Tensor G4", 0, 1548000, _dsu_dep!(), 1950000, 75.84, 191.27, 3.09, 0),
      ("Tensor G4", 0, 1548000, _dsu_dep!(), 2024000, 88.97, 198.32, 3.86, 0),
      ("Tensor G4", 0, 1548000, _dsu_dep!(), 2120000, 115.79, 232.48, 4.72, 0),
      ("Tensor G4", 0, 1548000, _dsu_dep!(), 2150000, 115.31, 222.76, 4.71, 0),
      ("Tensor G4", 0, 1696000, _dsu_dep!(), 610000, 19.61, 132.84, 1.68, 0),
      ("Tensor G4", 0, 1696000, _dsu_dep!(), 820000, 21.09, 151.29, 1.59, 0),
      ("Tensor G4", 0, 1696000, _dsu_dep!(), 970000, 21.92, 157.59, 1.75, 0),
      ("Tensor G4", 0, 1696000, _dsu_dep!(), 1098000, 22.76, 163.33, 1.59, 0),
      ("Tensor G4", 0, 1696000, _dsu_dep!(), 1197000, 23.53, 173.96, 1.67, 0),
      ("Tensor G4", 0, 1696000, _dsu_dep!(), 1328000, 24.28, 184.05, 1.58, 0),
      ("Tensor G4", 0, 1696000, _dsu_dep!(), 1444000, 29.47, 203.99, 1.77, 0),
      ("Tensor G4", 0, 1696000, _dsu_dep!(), 1548000, 33.94, 225.78, 1.7, 0),
      ("Tensor G4", 0, 1696000, _dsu_dep!(), 1704000, 46.92, 171.8, 2.16, 0),
      ("Tensor G4", 0, 1696000, _dsu_dep!(), 1800000, 55.32, 217.17, 2.38, 0),
      ("Tensor G4", 0, 1696000, _dsu_dep!(), 1880000, 62.55, 224.61, 2.77, 0),
      ("Tensor G4", 0, 1696000, _dsu_dep!(), 1950000, 76.98, 204.48, 2.82, 0),
      ("Tensor G4", 0, 1696000, _dsu_dep!(), 2024000, 90.13, 226.98, 3.76, 0),
      ("Tensor G4", 0, 1696000, _dsu_dep!(), 2120000, 116.77, 245.48, 4.52, 0),
      ("Tensor G4", 0, 1696000, _dsu_dep!(), 2150000, 112.69, 222.79, 6.43, 0),
      ("Tensor G4", 0, 1849000, _dsu_dep!(), 610000, 29.35, 176.28, 1.8, 0),
      ("Tensor G4", 0, 1849000, _dsu_dep!(), 820000, 30.31, 187.61, 1.94, 0),
      ("Tensor G4", 0, 1849000, _dsu_dep!(), 970000, 31.7, 202.99, 2.05, 0),
      ("Tensor G4", 0, 1849000, _dsu_dep!(), 1098000, 32.48, 207.22, 2.01, 0),
      ("Tensor G4", 0, 1849000, _dsu_dep!(), 1197000, 33.7, 222.81, 1.9, 0),
      ("Tensor G4", 0, 1849000, _dsu_dep!(), 1328000, 34.79, 229.5, 1.9, 0),
      ("Tensor G4", 0, 1849000, _dsu_dep!(), 1444000, 35.97, 228.13, 1.91, 0),
      ("Tensor G4", 0, 1849000, _dsu_dep!(), 1548000, 36.59, 235.62, 2.01, 0),
      ("Tensor G4", 0, 1849000, _dsu_dep!(), 1704000, 47.47, 233.89, 2.16, 0),
      ("Tensor G4", 0, 1849000, _dsu_dep!(), 1800000, 55.69, 211.69, 2.53, 0),
      ("Tensor G4", 0, 1849000, _dsu_dep!(), 1880000, 63.47, 225.85, 2.39, 0),
      ("Tensor G4", 0, 1849000, _dsu_dep!(), 1950000, 77.22, 209.34, 3.0, 0),
      ("Tensor G4", 0, 1849000, _dsu_dep!(), 2024000, 90.92, 230.3, 3.48, 0),
      ("Tensor G4", 0, 1849000, _dsu_dep!(), 2120000, 117.19, 247.78, 4.49, 0),
      ("Tensor G4", 0, 1849000, _dsu_dep!(), 2150000, 117.53, 239.55, 4.32, 0),
      ("Tensor G4", 0, 1950000, _dsu_dep!(), 610000, 40.27, 197.26, 2.54, 0),
      ("Tensor G4", 0, 1950000, _dsu_dep!(), 820000, 41.93, 221.2, 2.67, 0),
      ("Tensor G4", 0, 1950000, _dsu_dep!(), 970000, 43.45, 239.45, 2.56, 0),
      ("Tensor G4", 0, 1950000, _dsu_dep!(), 1098000, 44.27, 240.43, 2.64, 0),
      ("Tensor G4", 0, 1950000, _dsu_dep!(), 1197000, 45.84, 259.94, 2.42, 0),
      ("Tensor G4", 0, 1950000, _dsu_dep!(), 1328000, 47.03, 273.66, 2.55, 0),
      ("Tensor G4", 0, 1950000, _dsu_dep!(), 1444000, 48.53, 267.32, 2.32, 0),
      ("Tensor G4", 0, 1950000, _dsu_dep!(), 1548000, 49.59, 232.85, 2.35, 0),
      ("Tensor G4", 0, 1950000, _dsu_dep!(), 1704000, 51.2, 234.87, 2.23, 0),
      ("Tensor G4", 0, 1950000, _dsu_dep!(), 1800000, 55.47, 205.6, 2.67, 0),
      ("Tensor G4", 0, 1950000, _dsu_dep!(), 1880000, 63.68, 201.13, 2.59, 0),
      ("Tensor G4", 0, 1950000, _dsu_dep!(), 1950000, 77.22, 201.28, 3.13, 0),
      ("Tensor G4", 0, 1950000, _dsu_dep!(), 2024000, 90.93, 230.61, 3.81, 0),
      ("Tensor G4", 0, 1950000, _dsu_dep!(), 2120000, 118.19, 233.8, 4.28, 0),
      ("Tensor G4", 0, 1950000, _dsu_dep!(), 2150000, 118.61, 240.57, 4.6, 0)) AS _values
  )
SELECT
  *
FROM data
UNION ALL
SELECT
  *
FROM _tg5_2d_lut;
