/**
 * \file pappsomspp/processing/specpeptidoms/types.h
 * \date 24/03/2025
 * \author Aurélien Berthier
 *
 * C++ implementation of the SpecPeptidOMS algorithm described in :
 * (1) Benoist, É.; Jean, G.; Rogniaux, H.; Fertin, G.; Tessier, D. SpecPeptidOMS Directly and
 * Rapidly Aligns Mass Spectra on Whole Proteomes and Identifies Peptides That Are Not Necessarily
 * Tryptic: Implications for Peptidomics. J. Proteome Res. 2025.
 * https://doi.org/10.1021/acs.jproteome.4c00870.
 */

/*
 * Copyright (c) 2025 Aurélien Berthier
 * <aurelien.berthier@ls2n.fr>
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#pragma once

#include "../../amino_acid/aa.h"

namespace pappso
{
namespace specpeptidoms
{
// const std::unordered_map<pappso::Aa, double> aaMasses;
enum class ScoreType : std::uint8_t
{
  foundDouble      = 0,
  found            = 1,
  foundShiftDouble = 2,
  foundShift       = 3,
  notFound         = 4,
  init             = 5,
};

enum class AlignType
{
  found,
  shift,
  perfectShift,
  notFound,
  init
};

const uint MAX_SAVED_ALIGNMENTS(5);
const uint ALIGNMENT_SURPLUS(5);
const int MIN_ALIGNMENT_SCORE(15);
const uint MAX_RETURNED_RESULTS(2);
const uint TOL_PEAKS_MISSING(4);
const uint TOL_PEAKS_MISSING_FIRST_COLUMN(5);

} // namespace specpeptidoms
} // namespace pappso
