/**
 * Copyright (c) Members of the EGEE Collaboration. 2004-2010. 
 * See http://www.eu-egee.org/partners/ for details on the copyright
 * holders.  
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 *
 *
 *  Authors:
 *  2009-
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     Mischa Sall\'e <msalle@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *     <grid-mw-security@nikhef.nl> 
 *
 *  2007-2009
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *
 *  2003-2007
 *     Martijn Steenbakkers <martijn@nikhef.nl>
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *
 */


/*!
    \file   lcas_types.h
    \brief  Public header file with typedefs for LCAS
    \author Martijn Steenbakkers for the EU DataGrid.
    \ingroup APIforLcasPlugins
    \ingroup LcasInterface
*/

#ifndef LCAS_TYPES_H
#define LCAS_TYPES_H

/******************************************************************************
                             Include header files
******************************************************************************/

#ifndef NOGLOBUS
    #include <gssapi.h>
#endif /* NOGLOBUS */
#include <openssl/x509.h>

/******************************************************************************
                               Type definitions
******************************************************************************/

/*!
    \typedef lcas_request_t
    \brief Type of the LCAS request expressed in RSL/JDL

    (Internal) just a string.
*/
typedef char *lcas_request_t;

/*!
    \struct lcas_cred_id_s
    \brief structure representing an LCAS credential.
*/
/*!
    \typedef lcas_cred_id_t
    \brief Type of LCAS credentials
*/
typedef struct lcas_cred_id_s
{
#ifndef NOGLOBUS
    gss_cred_id_t  cred;          /*!< the original gss (globus) credential */
#endif /* NOGLOBUS */
    char *         dn;            /*!< the user distinguished name (DN) */
#ifdef LCAS_INTERFACE_EXTENDED
    STACK_OF (X509) * cert_stack; /*!< The user certificate stack */
    X509 * user_cert;             /*!< The user certificate stack */
    X509 * first_delegation;      /*!< The user certificate stack */
    X509 * leaf_proxy;            /*!< The user certificate stack */
#endif /* LCAS_INTERFACE_EXTENDED */
}
lcas_cred_id_t;

/*!
    \typedef lcas_proc_t
    \brief this type corresponds to the types of the plugin interface functions
*/
typedef int (*lcas_proc_t)();
/*!
    \typedef lcas_init_proc_t
    \brief this type is for plugin_initialize()
*/
typedef int (*lcas_init_proc_t)(int argc, char** argv);
/*!
    \typedef lcas_auth_proc_t
    \brief this type is for plugin_confirm_authorization()
*/
typedef int (*lcas_auth_proc_t)(lcas_request_t request, lcas_cred_id_t credential);
/*!
    \typedef lcas_authx509_proc_t
    \brief this type is for plugin_confirm_authorization_from_x509()
*/
typedef int (*lcas_authx509_proc_t)(lcas_request_t request, lcas_cred_id_t credential,
                                    X509* proxy, STACK_OF(X509)* chain);
/*!
    \typedef lcas_term_proc_t
    \brief this type is for plugin_terminate()
*/
typedef int (*lcas_term_proc_t)(void);

#endif /* LCAS_TYPES_H */

/******************************************************************************
CVS Information:
    $Source: /srv/home/dennisvd/svn/mw-security/lcas/interface/lcas_types.h,v $
    $Date: 2010-05-03 10:43:18 $
    $Revision: 1.6 $
    $Author: okoeroo $
******************************************************************************/
