//*****************************************************************************
//                                  PrcGWave.cpp                              *
//                                 --------------                             *
//  Started     : 29/03/2004                                                  *
//  Last Update : 18/04/2011                                                  *
//  Copyright   : (C) 2004 by MSWaters                                        *
//  Email       : M.Waters@bom.gov.au                                         *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#include "process/PrcGWave.hpp"

//*****************************************************************************
// Constructor.

PrcGWave::PrcGWave( void ) : PrcBase( wxPROCESS_REDIRECT )
{
  // Initialize the object attributes
  m_ofnResults.Clear( );
  m_ofnLog    .Clear( );

  // Attempt to set and find the gWave binary
  bSetBinary( wxT("gwave") );
}

//*****************************************************************************
// Destructor.

PrcGWave::~PrcGWave( )
{
}

//*****************************************************************************
// Set the simulation results file name.
//
// Argument List:
//   psFileName - a string containing the full path and file name
//
// Return Values:
//   TRUE  - Success
//   FALSE - Failure

bool  PrcGWave::bSetResults( const wxString & rosFileName )
{
  wxFileName  ofn1;

  ofn1 = rosFileName;
  if( ofn1.GetPath( ).IsEmpty( ) ) ofn1.SetPath( wxT(".") );

  if( ! ofn1.IsOk( )       ) return( FALSE );
  if( ! ofn1.FileExists( ) ) return( FALSE );

  m_ofnResults = ofn1;

  return( TRUE );
}

//*****************************************************************************
// Filter the results file so that the data viewer utility is happy with it.
//
// There are several things that a data viewer can object to :
//  - gwave doesn't like the GNU-Cap banner at the start to the results file,
//    so it's removed here.
//  - gwave doesn't like error messages interspersed with the lines of data,
//    so they are removed here.
//  - For good measure lines and fields are also formatted.
//
// Return Values:
//   TRUE  - Success
//   FALSE - Failure

bool  PrcGWave::bFilterFile( void )
{
  wxString  os1;
  size_t    szt1, szt2;
  wxChar    oc1;
  bool      bRtn=TRUE;

  // Attempt to open the results file
  wxTextFile  oFileCct( m_ofnResults.GetFullPath( ) );
  if( ! oFileCct.Exists( ) ) return( FALSE );
  if( ! oFileCct.Open( ) )   return( FALSE );

  // Has this file been formatted already?
  if( oFileCct.GetFirstLine( ).GetChar( 0 ) == wxT('#') ) return( TRUE );

  // Find the beginning of the data area (ie. the last line beginning with '#')
  for( szt1=szt2=0; szt1<oFileCct.GetLineCount( ); szt1++ )
  {
    os1 = oFileCct.GetLine( szt1 );
    if( ! os1.IsEmpty( ) )
      if( os1.GetChar( 0 ) == wxT('#') )
        szt2 = szt1;
  }

  // Delete the banner
  for( szt1=0; szt1<szt2; szt1++ ) oFileCct.RemoveLine( 0 );
  if( oFileCct.GetLineCount( ) <= 1 )                     return( FALSE );

  // Delete any simulator error messages eg. "open circuit: internal node 3"
  // (All lines should start with a digit except for the first)
  for( szt1=1; !oFileCct.Eof( ) && szt1<oFileCct.GetLineCount( ); szt1++ )
  {
    os1 = oFileCct.GetLine( szt1 );
    if( os1.Length( ) <= 1 )
    { // Delete empty lines
      oFileCct.RemoveLine( szt1 );
      szt1--;
      continue;
    }
    oc1 = os1.GetChar( 1 );
    if( ! wxIsdigit( oc1 ) )
    { // Delete non-data lines
      oFileCct.RemoveLine( szt1 );
      szt1--;
      continue;
    }
  }

  // Format each data line in the file
//  for( szt1=1; szt1<oFileCct.GetLineCount( ); szt1++ )
//    if( ! bFormatLine( oFileCct.GetLine( szt1 ) ) )
//      bRtn = FALSE;

  oFileCct.Write( ); // Save the changes to disk
  oFileCct.Close( ); // Close the file

  return( bRtn );
}

//*****************************************************************************
// Reformat the lines from the results file.
//
// Argument List:
//   rosLine - The line to be formatted
//
// Return Values:
//   TRUE  - Success
//   FALSE - Failure
/*
bool  PrcGWave::bFormatLine( wxString & rosLine )
{
  wxStringTokenizer  ostk1;
  wxString  os1, os2;

  // Check for an empty string
  if( rosLine.IsEmpty( ) )         return( FALSE );

  // Break the line into fields
  ostk1.SetString( rosLine );
  if( ostk1.CountTokens( ) < 2 ) return( FALSE );

  // Reformat the line
  while( ostk1.HasMoreTokens( ) )
  {
    os1 = ostk1.GetNextToken( );
    if( ! bFormatField( os1 ) )    return( FALSE );
    if( os2.IsEmpty( ) ) os2 = os1;
    else                 os2 << wxT("     ") << os1;
  }

  rosLine = os2;

  return( TRUE );
}
*/
//*****************************************************************************
// Reformat the fields from the results file.
//
// Argument List:
//   rosField - The field to be formatted
//
// Return Values:
//   TRUE  - Success
//   FALSE - Failure
/*
bool  PrcGWave::bFormatField( wxString & rosField )
{
  wxString  os1;
  wxChar    oc1;
  size_t    szt1;

  // Check for an empty string
  if( rosField.IsEmpty( ) ) return( FALSE );

  // Extract the value and the units
  oc1 = 0;
  for( szt1=0; szt1<rosField.Length( ); szt1++ )
  {
    oc1 = rosField.GetChar( szt1 );
    if( oc1!=wxT('-') && !wxIsdigit( oc1 ) && oc1!=wxT('.') ) break;
    else oc1 = 0;
  }
  os1 = rosField.Left( szt1 );

  // Reformat the field
  switch( oc1 )
  {
    case wxT('M'): os1 << wxT("E+06"); break;
    case wxT('K'): os1 << wxT("E+03"); break;
    case wxT('m'): os1 << wxT("E-03"); break;
    case wxT('u'): os1 << wxT("E-06"); break;
    case wxT('n'): os1 << wxT("E-09"); break;
    case wxT('p'): os1 << wxT("E-12"); break;
    case 0: break;
    default : return( FALSE );
  }

  rosField = os1;

  return( TRUE );
}
*/
//*****************************************************************************
// View the results of a simulation.
// (Eg. using the following: gwave ../sch/test-amp1.gnucap.dc)
//
// Return Values:
//   TRUE  - Success
//   FALSE - Failure

bool  PrcGWave::bExec( void )
{
  wxString  os1;

  // Test file names needed by this function
  if( ! bBinExists( ) )                             return( FALSE );
  if( !m_ofnResults.FileExists( ) || !m_ofnResults.IsOk( ) )
  {
    os1 = m_ofnResults.GetFullPath( );
    m_osErrMsg.Empty( );
    if( os1.IsEmpty( ) )
         m_osErrMsg << wxT("The results file has not been set.");
    else m_osErrMsg << wxT("The results file doesn't exist : ") << os1;
    return( FALSE );
  }

  // Append input file name to argument list
  if( ! bSetArgLst( m_ofnResults.GetFullPath( ) ) ) return( FALSE );

  // Filter the file before passing it to the waveform viewer process
  if( ! bFilterFile( ) )                            return( FALSE );

  // Execute the process
  if( ! PrcBase::bExecAsync( ) )                    return( FALSE );

  return( TRUE );
}

//*****************************************************************************
