/* -----------------------------------------------------------------------------
 *
 * Monocasual Utils
 *
 * -----------------------------------------------------------------------------
 *
 * Copyright (C) 2021-2025 Giovanni A. Zuliani | Monocasual
 *
 * This file is part of Monocasual Utils.
 *
 * Monocasual Utils is free software: you can
 * redistribute it and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation, either
 * version 3 of the License, or (at your option) any later version.
 *
 * Monocasual Utils is distributed in the hope that it
 * will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Giada - Monocasual Utils. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * -------------------------------------------------------------------------- */

#ifndef MONOCASUAL_UTILS_LOG_H
#define MONOCASUAL_UTILS_LOG_H

#include <cstdio>
#include <iostream>
#include <string>
#include <type_traits>
#include <utility>

namespace mcl::utils::log
{
#ifndef NDEBUG
#define ML_DEBUG(x) std::cerr << __FILE__ << "::" << __func__ << "() - " << x << std::endl
#else
#define ML_DEBUG(x) \
	do              \
	{               \
	} while (0)
#endif
} // namespace mcl::utils::log

#endif
