"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.readEncoding = readEncoding;
exports.writeEncoding = writeEncoding;
const bin_util_1 = require("@ot-builder/bin-util");
const ot_encoding_1 = require("@ot-builder/ot-encoding");
const read_1 = require("../cmap/read");
const write_1 = require("../cmap/write");
const interface_1 = require("../stat/interface");
const os2_min_max_char_index_1 = require("../stat/os2-min-max-char-index");
const os2_unicode_range_1 = require("../stat/os2-unicode-range");
function readEncoding(sfnt, cfg, gOrd, md) {
    const result = {};
    const bCmap = sfnt.tables.get(ot_encoding_1.Cmap.Tag);
    if (bCmap)
        result.cmap = new bin_util_1.BinaryView(bCmap).next(read_1.ReadCmap, gOrd);
    return result;
}
function writeEncoding(out, cfg, encoding, gOrd, md) {
    if (encoding.cmap) {
        let stat = new interface_1.EmptyStat();
        if (cfg.encoding.statOs2UnicodeRanges && md.os2) {
            stat = new os2_min_max_char_index_1.Os2MinMaxCharStat(md.os2, new os2_unicode_range_1.Os2UnicodeRangeStat(md.os2, stat));
        }
        for (const [u, g] of encoding.cmap.unicode.entries())
            stat.addEncoding(u);
        stat.settle();
        out.add(ot_encoding_1.Cmap.Tag, bin_util_1.Frag.packFrom(write_1.WriteCmap, encoding.cmap, gOrd, cfg));
    }
}
//# sourceMappingURL=index.js.map