#!/usr/bin/perl -w

# This file is distributed as part of the bit-babbler package.
# Copyright 2015,  Ron <ron@debian.org>

use strict;

use IO::Socket;

my $addr = '127.0.0.1';
my $port = 1200;
my $max_msg_size = 32768;
my $data;
my $flags;

my ($bytes_requested) = (shift // "") =~ /^(\d+)$/a
    or die "Usage: $0 <number of bytes to read>\n";

die "Not reading 0 bytes" if $bytes_requested < 1;
die "Maximum request is $max_msg_size" if $bytes_requested > $max_msg_size;


my $sock = IO::Socket::INET->new(
    Proto    => 'udp',
    PeerAddr => $addr,
    PeerPort => $port,
) or die "Could not create socket: $!\n";

# Send the requested number of bytes as a network-order short.
my $msg = pack("n*", $bytes_requested);

$sock->send($msg) or die "Failed to send request for $bytes_requested bytes";
$sock->recv($data,$max_msg_size,$flags) or die "Failed to read reply";

# Display the binary octets as hex digits
print "read: " . unpack("H*", $data) . "\n";

