/*****************************************************************************
 * Copyright (c) 2014-2025 OpenRCT2 developers
 *
 * For a complete list of all authors, please refer to contributors.md
 * Interested in contributing? Visit https://github.com/OpenRCT2/OpenRCT2
 *
 * OpenRCT2 is licensed under the GNU General Public License version 3.
 *****************************************************************************/

#pragma once

#include "../localisation/StringIdType.h"

enum : StringId
{
    STR_RIDE_NAME_DEFAULT = 1,

    STR_GUEST_X = 767,
    STR_HANDYMAN_X = 768,
    STR_MECHANIC_X = 769,
    STR_SECURITY_GUARD_X = 770,
    STR_ENTERTAINER_X = 771,

    STR_UNNAMED_PARK = 777,
    STR_DEFAULT_SIGN = 778,
    STR_DATE_DAY_1 = 779,
    STR_DATE_DAY_2 = STR_DATE_DAY_1 + 1,
    STR_DATE_DAY_3 = STR_DATE_DAY_1 + 2,
    STR_DATE_DAY_4 = STR_DATE_DAY_1 + 3,
    STR_DATE_DAY_5 = STR_DATE_DAY_1 + 4,
    STR_DATE_DAY_6 = STR_DATE_DAY_1 + 5,
    STR_DATE_DAY_7 = STR_DATE_DAY_1 + 6,
    STR_DATE_DAY_8 = STR_DATE_DAY_1 + 7,
    STR_DATE_DAY_9 = STR_DATE_DAY_1 + 8,
    STR_DATE_DAY_10 = STR_DATE_DAY_1 + 9,
    STR_DATE_DAY_11 = STR_DATE_DAY_1 + 10,
    STR_DATE_DAY_12 = STR_DATE_DAY_1 + 11,
    STR_DATE_DAY_13 = STR_DATE_DAY_1 + 12,
    STR_DATE_DAY_14 = STR_DATE_DAY_1 + 13,
    STR_DATE_DAY_15 = STR_DATE_DAY_1 + 14,
    STR_DATE_DAY_16 = STR_DATE_DAY_1 + 15,
    STR_DATE_DAY_17 = STR_DATE_DAY_1 + 16,
    STR_DATE_DAY_18 = STR_DATE_DAY_1 + 17,
    STR_DATE_DAY_19 = STR_DATE_DAY_1 + 18,
    STR_DATE_DAY_20 = STR_DATE_DAY_1 + 19,
    STR_DATE_DAY_21 = STR_DATE_DAY_1 + 20,
    STR_DATE_DAY_22 = STR_DATE_DAY_1 + 21,
    STR_DATE_DAY_23 = STR_DATE_DAY_1 + 22,
    STR_DATE_DAY_24 = STR_DATE_DAY_1 + 23,
    STR_DATE_DAY_25 = STR_DATE_DAY_1 + 24,
    STR_DATE_DAY_26 = STR_DATE_DAY_1 + 25,
    STR_DATE_DAY_27 = STR_DATE_DAY_1 + 26,
    STR_DATE_DAY_28 = STR_DATE_DAY_1 + 27,
    STR_DATE_DAY_29 = STR_DATE_DAY_1 + 28,
    STR_DATE_DAY_30 = STR_DATE_DAY_1 + 29,
    STR_DATE_DAY_31 = STR_DATE_DAY_1 + 30,
    STR_MONTH_SHORT_JAN = 810, // Unused
    STR_MONTH_SHORT_FEB = 811, // Unused
    STR_MONTH_SHORT_MAR = 812,
    STR_MONTH_SHORT_APR = 813,
    STR_MONTH_SHORT_MAY = 814,
    STR_MONTH_SHORT_JUN = 815,
    STR_MONTH_SHORT_JUL = 816,
    STR_MONTH_SHORT_AUG = 817,
    STR_MONTH_SHORT_SEP = 818,
    STR_MONTH_SHORT_OCT = 819,
    STR_MONTH_SHORT_NOV = 820, // Unused
    STR_MONTH_SHORT_DEC = 821, // Unused

    STR_CHOSEN_NAME_IN_USE_ALREADY = 825,
    STR_TOO_MANY_NAMES_DEFINED = 826,
    STR_NOT_ENOUGH_CASH_REQUIRES = 827,

    // STR_0858 to 0864 are removed.
    STR_STRINGID = 865,
    STR_ARG_2_STRINGID = 866, // Unused
    STR_ARG_4_STRINGID = 867, // Unused
    STR_ARG_8_STRINGID = 869, // Unused
    STR_ARG_12_STRINGID = 871,

    STR_TOO_LOW = 877,
    STR_TOO_HIGH = 878,
    STR_CANT_LOWER_LAND_HERE = 879,
    STR_CANT_RAISE_LAND_HERE = 880,
    STR_OBJECT_IN_THE_WAY = 881,
    STR_LOAD_GAME = 882,
    STR_SAVE_GAME = 883,

    STR_SCREENSHOT_SAVED_AS = 892,
    STR_SCREENSHOT_FAILED = 893,
    STR_ERR_LANDSCAPE_DATA_AREA_FULL = 894,
    STR_CANT_BUILD_PARTLY_ABOVE_AND_PARTLY_BELOW_GROUND = 895,
    STR_RIDE_CONSTRUCTION_CANT_REMOVE_THIS = 926,
    STR_RIDE_CONSTRUCTION_CANT_CONSTRUCT_THIS_HERE = 927,
    STR_S_BEND_LEFT = 929,
    STR_S_BEND_RIGHT = 930,
    STR_VERTICAL_LOOP_LEFT = 931,
    STR_VERTICAL_LOOP_RIGHT = 932,
    STR_RAISE_OR_LOWER_LAND_FIRST = 933,
    STR_RIDE_ENTRANCE_IN_THE_WAY = 934,
    STR_RIDE_EXIT_IN_THE_WAY = 935,
    STR_PARK_ENTRANCE_IN_THE_WAY = 936,

    STR_TOO_MANY_RIDES = 987,
    STR_CANT_CREATE_NEW_RIDE_ATTRACTION = 988,
    STR_STATION_PLATFORM = 991,
    STR_NO_MORE_STATIONS_ALLOWED_ON_THIS_RIDE = 998,
    STR_REQUIRES_A_STATION_PLATFORM = 999,
    STR_TRACK_IS_NOT_A_COMPLETE_CIRCUIT = 1000,
    STR_TRACK_UNSUITABLE_FOR_TYPE_OF_TRAIN = 1001,
    STR_CANT_OPEN = 1002,
    STR_CANT_TEST = 1003,
    STR_CANT_CLOSE = 1004,
    STR_CANT_START_CONSTRUCTION_ON = 1005,
    STR_MUST_BE_CLOSED_FIRST = 1006,
    STR_UNABLE_TO_CREATE_ENOUGH_VEHICLES = 1007,
    STR_UNABLE_TO_OPERATE_WITH_MORE_THAN_ONE_STATION_IN_THIS_MODE = 1015,
    STR_UNABLE_TO_OPERATE_WITH_LESS_THAN_TWO_STATIONS_IN_THIS_MODE = 1016,
    STR_CANT_CHANGE_OPERATING_MODE = 1017,
    STR_RIDE_SET_VEHICLE_TYPE_FAIL = 1018,
    STR_RIDE_SET_VEHICLE_SET_NUM_CARS_PER_TRAIN_FAIL = 1019,
    STR_RIDE_SET_VEHICLE_SET_NUM_TRAINS_FAIL = 1020,
    // STR_1024    :{COMMA16} car per train
    // STR_1025    :{COMMA16} cars per train
    STR_STATION_PLATFORM_TOO_LONG = 1026,
    STR_OFF_EDGE_OF_MAP = 1028,
    STR_CANNOT_BUILD_PARTLY_ABOVE_AND_PARTLY_BELOW_WATER = 1029,
    STR_CAN_ONLY_BUILD_THIS_UNDERWATER = 1030,
    STR_RIDE_CANT_BUILD_THIS_UNDERWATER = 1031,
    STR_CAN_ONLY_BUILD_THIS_ON_WATER = 1032,
    STR_CAN_ONLY_BUILD_THIS_ABOVE_GROUND = 1033,
    STR_CAN_ONLY_BUILD_THIS_ON_LAND = 1034,
    STR_LOCAL_AUTHORITY_WONT_ALLOW_CONSTRUCTION_ABOVE_TREE_HEIGHT = 1035,
    STR_FILE_DIALOG_TITLE_CONVERT_SAVED_GAME_TO_SCENARIO = 1038, // Unused
    STR_FILE_DIALOG_TITLE_SAVE_SCENARIO = 1041,
    STR_FAILED_TO_LOAD_FILE_CONTAINS_INVALID_DATA = 1050,
    STR_INVISIBLE_PEOPLE = 1052,
    STR_CANT_RENAME_RIDE_ATTRACTION = 1059,
    STR_INVALID_RIDE_ATTRACTION_NAME = 1060,
    STR_RIDE_MODE_NORMAL = 1061,
    STR_RIDE_MODE_CONTINUOUS_CIRCUIT = 1062,
    STR_RIDE_MODE_REVERSE_INCLINE_LAUNCHED_SHUTTLE = 1063,
    STR_RIDE_MODE_POWERED_LAUNCH_PASSTROUGH = 1064,
    STR_RIDE_MODE_SHUTTLE = 1065,
    STR_RIDE_MODE_BOAT_HIRE = 1066,
    STR_RIDE_MODE_UPWARD_LAUNCH = 1067,
    STR_RIDE_MODE_ROTATING_LIFT = 1068,
    STR_RIDE_MODE_STATION_TO_STATION = 1069,
    STR_RIDE_MODE_SINGLE_RIDE_PER_ADMISSION = 1070,
    STR_RIDE_MODE_UNLIMITED_RIDES_PER_ADMISSION = 1071,
    STR_RIDE_MODE_MAZE = 1072,
    STR_RIDE_MODE_RACE = 1073,
    STR_RIDE_MODE_DODGEMS = 1074,
    STR_RIDE_MODE_SWING = 1075,
    STR_RIDE_MODE_SHOP_STALL = 1076,
    STR_RIDE_MODE_ROTATION = 1077,
    STR_RIDE_MODE_FORWARD_ROTATION = 1078,
    STR_RIDE_MODE_BACKWARD_ROTATION = 1079,
    STR_RIDE_MODE_FILM_AVENGING_AVIATORS = 1080,
    STR_RIDE_MODE_3D_FILM_MOUSE_TAILS = 1081,
    STR_RIDE_MODE_SPACE_RINGS = 1082,
    STR_RIDE_MODE_BEGINNERS = 1083,
    STR_RIDE_MODE_LIM_POWERED_LAUNCH = 1084,
    STR_RIDE_MODE_FILM_THRILL_RIDERS = 1085,
    STR_RIDE_MODE_3D_FILM_STORM_CHASERS = 1086,
    STR_RIDE_MODE_3D_FILM_SPACE_RAIDERS = 1087,
    STR_RIDE_MODE_INTENSE = 1088,
    STR_RIDE_MODE_BERSERK = 1089,
    STR_RIDE_MODE_HAUNTED_HOUSE = 1090,
    STR_RIDE_MODE_CIRCUS_SHOW = 1091,
    STR_RIDE_MODE_DOWNWARD_LAUNCH = 1092,
    STR_RIDE_MODE_CROOKED_HOUSE = 1093,
    STR_RIDE_MODE_FREEFALL_DROP = 1094,
    STR_RIDE_MODE_CONTINUOUS_CIRCUIT_BLOCK_SECTIONED = 1095,
    STR_RIDE_MODE_POWERED_LAUNCH = 1096,
    STR_RIDE_MODE_POWERED_LAUNCH_BLOCK_SECTIONED_MODE = 1097,

    STR_CANT_BUILD_MOVE_ENTRANCE_FOR_THIS_RIDE_ATTRACTION = 1144,
    STR_CANT_BUILD_MOVE_EXIT_FOR_THIS_RIDE_ATTRACTION = 1145,
    STR_ENTRANCE_NOT_YET_BUILT = 1146,
    STR_EXIT_NOT_YET_BUILT = 1147,

    STR_CANT_REMOVE_THIS = 1158,
    STR_CANT_POSITION_THIS_HERE = 1161,
    STR_MAP_TOOLTIP_STRINGID_STRINGID = 1165,
    STR_CANT_LOWER_WATER_LEVEL_HERE = 1166,
    STR_CANT_RAISE_WATER_LEVEL_HERE = 1167,
    STR_STRING = 1170,
    STR_RIDE_ENTRANCE_CLOSED = 1171,
    STR_RIDE_ENTRANCE_NAME = 1172,
    STR_BANNER_SIGN_IN_THE_WAY = 1174,
    STR_CANT_BUILD_THIS_ON_SLOPED_FOOTPATH = 1175,
    STR_CANT_BUILD_FOOTPATH_HERE = 1176,
    STR_CANT_REMOVE_FOOTPATH_FROM_HERE = 1177,
    STR_LAND_SLOPE_UNSUITABLE = 1178,
    STR_FOOTPATH_IN_THE_WAY = 1179,
    STR_CANT_BUILD_THIS_UNDERWATER = 1180,
    STR_BLACK_STRING = 1191,
    STR_WINDOW_COLOUR_2_STRINGID = 1193,
    STR_CLOSED = 1194,
    STR_TEST_RUN = 1195,
    STR_OPEN = 1196,
    STR_BROKEN_DOWN = 1197,
    STR_CRASHED = 1198,
    STR_PERSON_ON_RIDE = 1199,
    STR_PEOPLE_ON_RIDE = 1200,
    STR_QUEUE_EMPTY = 1201,
    STR_QUEUE_ONE_PERSON = 1202,
    STR_QUEUE_PEOPLE = 1203,
    STR_QUEUE_PATHS_CANNOT_BE_USED_FOR_LEVEL_CROSSINGS = 6751,

    STR_RIDE_COMPONENT_TRAIN = 1229,
    STR_RIDE_COMPONENT_TRAIN_PLURAL = 1230,
    STR_RIDE_COMPONENT_TRAIN_CAPITALISED = 1231,
    STR_RIDE_COMPONENT_TRAIN_CAPITALISED_PLURAL = 1232,
    STR_RIDE_COMPONENT_TRAIN_COUNT = 1233,
    STR_RIDE_COMPONENT_TRAIN_COUNT_PLURAL = 1234,
    STR_RIDE_COMPONENT_TRAIN_NO = 1235,
    STR_RIDE_COMPONENT_BOAT = 1236,
    STR_RIDE_COMPONENT_BOAT_PLURAL = 1237,
    STR_RIDE_COMPONENT_BOAT_CAPITALISED = 1238,
    STR_RIDE_COMPONENT_BOAT_CAPITALISED_PLURAL = 1239,
    STR_RIDE_COMPONENT_BOAT_COUNT = 1240,
    STR_RIDE_COMPONENT_BOAT_COUNT_PLURAL = 1241,
    STR_RIDE_COMPONENT_BOAT_NO = 1242,
    STR_RIDE_COMPONENT_TRACK = 1243,
    STR_RIDE_COMPONENT_TRACK_PLURAL = 1244,
    STR_RIDE_COMPONENT_TRACK_CAPITALISED = 1245,
    STR_RIDE_COMPONENT_TRACK_CAPITALISED_PLURAL = 1246,
    STR_RIDE_COMPONENT_TRACK_COUNT = 1247,
    STR_RIDE_COMPONENT_TRACK_COUNT_PLURAL = 1248,
    STR_RIDE_COMPONENT_TRACK_NO = 1249,
    STR_RIDE_COMPONENT_DOCKING_PLATFORM = 1250,
    STR_RIDE_COMPONENT_DOCKING_PLATFORM_PLURAL = 1251,
    STR_RIDE_COMPONENT_DOCKING_PLATFORM_CAPITALISED = 1252,
    STR_RIDE_COMPONENT_DOCKING_PLATFORM_CAPITALISED_PLURAL = 1253,
    STR_RIDE_COMPONENT_DOCKING_PLATFORM_COUNT = 1254,
    STR_RIDE_COMPONENT_DOCKING_PLATFORM_COUNT_PLURAL = 1255,
    STR_RIDE_COMPONENT_DOCKING_PLATFORM_NO = 1256,
    STR_RIDE_COMPONENT_STATION = 1257,
    STR_RIDE_COMPONENT_STATION_PLURAL = 1258,
    STR_RIDE_COMPONENT_STATION_CAPITALISED = 1259,
    STR_RIDE_COMPONENT_STATION_CAPITALISED_PLURAL = 1260,
    STR_RIDE_COMPONENT_STATION_COUNT = 1261,
    STR_RIDE_COMPONENT_STATION_COUNT_PLURAL = 1262,
    STR_RIDE_COMPONENT_STATION_NO = 1263,
    STR_RIDE_COMPONENT_CAR = 1264,
    STR_RIDE_COMPONENT_CAR_PLURAL = 1265,
    STR_RIDE_COMPONENT_CAR_CAPITALISED = 1266,
    STR_RIDE_COMPONENT_CAR_CAPITALISED_PLURAL = 1267,
    STR_RIDE_COMPONENT_CAR_COUNT = 1268,
    STR_RIDE_COMPONENT_CAR_COUNT_PLURAL = 1269,
    STR_RIDE_COMPONENT_CAR_NO = 1270,
    STR_RIDE_COMPONENT_BUILDING = 1271,
    STR_RIDE_COMPONENT_BUILDING_PLURAL = 1272,
    STR_RIDE_COMPONENT_BUILDING_CAPITALISED = 1273,
    STR_RIDE_COMPONENT_BUILDING_CAPITALISED_PLURAL = 1274,
    STR_RIDE_COMPONENT_BUILDING_COUNT = 1275,
    STR_RIDE_COMPONENT_BUILDING_COUNT_PLURAL = 1276,
    STR_RIDE_COMPONENT_BUILDING_NO = 1277,
    STR_RIDE_COMPONENT_STRUCTURE = 1278,
    STR_RIDE_COMPONENT_STRUCTURE_PLURAL = 1279,
    STR_RIDE_COMPONENT_STRUCTURE_CAPITALISED = 1280,
    STR_RIDE_COMPONENT_STRUCTURE_CAPITALISED_PLURAL = 1281,
    STR_RIDE_COMPONENT_STRUCTURE_COUNT = 1282,
    STR_RIDE_COMPONENT_STRUCTURE_COUNT_PLURAL = 1283,
    STR_RIDE_COMPONENT_STRUCTURE_NO = 1284,
    STR_RIDE_COMPONENT_SHIP = 1285,
    STR_RIDE_COMPONENT_SHIP_PLURAL = 1286,
    STR_RIDE_COMPONENT_SHIP_CAPITALISED = 1287,
    STR_RIDE_COMPONENT_SHIP_CAPITALISED_PLURAL = 1288,
    STR_RIDE_COMPONENT_SHIP_COUNT = 1289,
    STR_RIDE_COMPONENT_SHIP_COUNT_PLURAL = 1290,
    STR_RIDE_COMPONENT_SHIP_NO = 1291,
    STR_RIDE_COMPONENT_CABIN = 1292,
    STR_RIDE_COMPONENT_CABIN_PLURAL = 1293,
    STR_RIDE_COMPONENT_CABIN_CAPITALISED = 1294,
    STR_RIDE_COMPONENT_CABIN_CAPITALISED_PLURAL = 1295,
    STR_RIDE_COMPONENT_CABIN_COUNT = 1296,
    STR_RIDE_COMPONENT_CABIN_COUNT_PLURAL = 1297,
    STR_RIDE_COMPONENT_CABIN_NO = 1298,
    STR_RIDE_COMPONENT_WHEEL = 1299,
    STR_RIDE_COMPONENT_WHEEL_PLURAL = 1300,
    STR_RIDE_COMPONENT_WHEEL_CAPITALISED = 1301,
    STR_RIDE_COMPONENT_WHEEL_CAPITALISED_PLURAL = 1302,
    STR_RIDE_COMPONENT_WHEEL_COUNT = 1303,
    STR_RIDE_COMPONENT_WHEEL_COUNT_PLURAL = 1304,
    STR_RIDE_COMPONENT_WHEEL_NO = 1305,
    STR_RIDE_COMPONENT_RING = 1306,
    STR_RIDE_COMPONENT_RING_PLURAL = 1307,
    STR_RIDE_COMPONENT_RING_CAPITALISED = 1308,
    STR_RIDE_COMPONENT_RING_CAPITALISED_PLURAL = 1309,
    STR_RIDE_COMPONENT_RING_COUNT = 1310,
    STR_RIDE_COMPONENT_RING_COUNT_PLURAL = 1311,
    STR_RIDE_COMPONENT_RING_NO = 1312,
    STR_RIDE_COMPONENT_PLAYER = 1313,
    STR_RIDE_COMPONENT_PLAYER_PLURAL = 1314,
    STR_RIDE_COMPONENT_PLAYER_CAPITALISED = 1315,
    STR_RIDE_COMPONENT_PLAYER_CAPITALISED_PLURAL = 1316,
    STR_RIDE_COMPONENT_PLAYER_COUNT = 1317,
    STR_RIDE_COMPONENT_PLAYER_COUNT_PLURAL = 1318,
    STR_RIDE_COMPONENT_PLAYER_NO = 1319,
    STR_RIDE_COMPONENT_COURSE = 1320,
    STR_RIDE_COMPONENT_COURSE_PLURAL = 1321,
    STR_RIDE_COMPONENT_COURSE_CAPITALISED = 1322,
    STR_RIDE_COMPONENT_COURSE_CAPITALISED_PLURAL = 1323,
    STR_RIDE_COMPONENT_COURSE_COUNT = 1324,
    STR_RIDE_COMPONENT_COURSE_COUNT_PLURAL = 1325,
    STR_RIDE_COMPONENT_COURSE_NO = 1326,
    STR_LEVEL_LAND_REQUIRED = 1328,
    // 1332 not used. Likely ride_mode_speed value
    STR_RIDE_STATION = 1333,
    STR_RIDE_STATION_X = 1334,
    STR_RIDE_ENTRANCE = 1335,
    STR_RIDE_STATION_X_ENTRANCE = 1336,
    STR_RIDE_EXIT = 1337,
    STR_RIDE_STATION_X_EXIT = 1338,
    STR_CANT_CHANGE_SPEED = 1361,
    STR_CANT_CHANGE_LAUNCH_SPEED = 1362,
    STR_TOO_HIGH_FOR_SUPPORTS = 1363,
    STR_SUPPORTS_CANT_BE_EXTENDED = 1364,
    STR_IN_LINE_TWIST_LEFT = 1365,
    STR_IN_LINE_TWIST_RIGHT = 1366,
    STR_HALF_LOOP = 1367,
    STR_HALF_CORKSCREW_LEFT = 1368,
    STR_HALF_CORKSCREW_RIGHT = 1369,
    STR_BARREL_ROLL_LEFT = 1370,
    STR_BARREL_ROLL_RIGHT = 1371,
    STR_LAUNCHED_LIFT_HILL = 1372,
    STR_LARGE_HALF_LOOP_LEFT = 1373,
    STR_LARGE_HALF_LOOP_RIGHT = 1374,
    STR_UPPER_TRANSFER = 1375,
    STR_LOWER_TRANSFER = 1376,
    STR_HEARTLINE_ROLL_LEFT = 1377,
    STR_HEARTLINE_ROLL_RIGHT = 1378,
    STR_REVERSER_LEFT = 1379,
    STR_REVERSER_RIGHT = 1380,
    STR_CURVED_LIFT_HILL_LEFT = 1381,
    STR_CURVED_LIFT_HILL_RIGHT = 1382,
    STR_QUARTER_LOOP = 1383,
    STR_CANT_CHANGE_LAND_TYPE = 1387,
    STR_MONEY_EFFECT_RECEIVE = 1388,
    STR_MONEY_EFFECT_SPEND = 1389,
    STR_ENTRY_EXIT_PLATFORM = 1409,
    STR_VERTICAL_TOWER = 1410,
    STR_X_IN_THE_WAY = 1411,
    STR_DATA_LOGGING_NOT_AVAILABLE_FOR_THIS_TYPE_OF_RIDE = 1412,
    STR_DATA_LOGGING_WILL_START_WHEN_NEXT_LEAVES = 1413,
    STR_FOOTPATH_MAP_TIP = 1425,
    STR_QUEUE_LINE_MAP_TIP = 1426,
    STR_FREE = 1430,
    STR_WALKING = 1431,
    STR_HEADING_FOR = 1432,
    STR_QUEUING_FOR = 1433,
    STR_DROWNING = 1434,
    STR_ON_RIDE = 1435,
    STR_IN_RIDE = 1436,
    STR_AT_RIDE = 1437,
    STR_SITTING = 1438,
    STR_SELECT_LOCATION = 1439,
    STR_MOWING_GRASS = 1440,
    STR_SWEEPING_FOOTPATH = 1441,
    STR_EMPTYING_LITTER_BIN = 1442,
    STR_WATERING_GARDENS = 1443,
    STR_WATCHING_RIDE = 1444,
    STR_WATCHING_CONSTRUCTION_OF = 1445,
    STR_LOOKING_AT_SCENERY = 1446,
    STR_LEAVING_PARK = 1447,
    STR_WATCHING_NEW_RIDE_BEING_CONSTRUCTED = 1448,
    STR_GUEST_MAP_TIP = 1449,
    STR_TRACKED_GUEST_MAP_TIP = 1450,
    STR_STAFF_MAP_TIP = 1451,
    STR_CANT_NAME_GUEST = 1454,
    STR_ERR_INVALID_NAME_FOR_GUEST = 1455,
    STR_TOO_STEEP_FOR_LIFT_HILL = 1462,
    STR_HELIX_UP_SMALL = 1464,
    STR_HELIX_UP_LARGE = 1465,
    STR_HELIX_DOWN_SMALL = 1466,
    STR_HELIX_DOWN_LARGE = 1467,
    STR_RIDE_MUST_START_AND_END_WITH_STATIONS = 1469,
    STR_STATION_NOT_LONG_ENOUGH = 1470,
    STR_PEEP_THOUGHT_TYPE_CANT_AFFORD_0 = 1480,
    STR_PEEP_THOUGHT_TYPE_SPENT_MONEY = 1481,
    STR_PEEP_THOUGHT_TYPE_SICK = 1482,
    STR_PEEP_THOUGHT_TYPE_VERY_SICK = 1483,
    STR_PEEP_THOUGHT_TYPE_MORE_THRILLING = 1484,
    STR_PEEP_THOUGHT_TYPE_INTENSE = 1485,
    STR_PEEP_THOUGHT_TYPE_HAVENT_FINISHED = 1486,
    STR_PEEP_THOUGHT_TYPE_SICKENING = 1487,
    STR_PEEP_THOUGHT_TYPE_BAD_VALUE = 1488,
    STR_PEEP_THOUGHT_TYPE_GO_HOME = 1489,
    STR_PEEP_THOUGHT_TYPE_GOOD_VALUE = 1490,
    STR_PEEP_THOUGHT_TYPE_ALREADY_GOT = 1491,
    STR_PEEP_THOUGHT_TYPE_CANT_AFFORD = 1492,
    STR_PEEP_THOUGHT_TYPE_NOT_HUNGRY = 1493,
    STR_PEEP_THOUGHT_TYPE_NOT_THIRSTY = 1494,
    STR_PEEP_THOUGHT_TYPE_DROWNING = 1495,
    STR_PEEP_THOUGHT_TYPE_LOST = 1496,
    STR_PEEP_THOUGHT_TYPE_WAS_GREAT = 1497,
    STR_PEEP_THOUGHT_TYPE_QUEUING_AGES = 1498,
    STR_PEEP_THOUGHT_TYPE_TIRED = 1499,
    STR_PEEP_THOUGHT_TYPE_HUNGRY = 1500,
    STR_PEEP_THOUGHT_TYPE_THIRSTY = 1501,
    STR_PEEP_THOUGHT_TYPE_TOILET = 1502,
    STR_PEEP_THOUGHT_TYPE_CANT_FIND = 1503,
    STR_PEEP_THOUGHT_TYPE_NOT_PAYING = 1504,
    STR_PEEP_THOUGHT_TYPE_NOT_WHILE_RAINING = 1505,
    STR_PEEP_THOUGHT_TYPE_BAD_LITTER = 1506,
    STR_PEEP_THOUGHT_TYPE_CANT_FIND_EXIT = 1507,
    STR_PEEP_THOUGHT_TYPE_GET_OFF = 1508,
    STR_PEEP_THOUGHT_TYPE_GET_OUT = 1509,
    STR_PEEP_THOUGHT_TYPE_NOT_SAFE = 1510,
    STR_PEEP_THOUGHT_TYPE_PATH_DISGUSTING = 1511,
    STR_PEEP_THOUGHT_TYPE_CROWDED = 1512,
    STR_PEEP_THOUGHT_TYPE_VANDALISM = 1513,
    STR_PEEP_THOUGHT_TYPE_SCENERY = 1514,
    STR_PEEP_THOUGHT_TYPE_VERY_CLEAN = 1515,
    STR_PEEP_THOUGHT_TYPE_FOUNTAINS = 1516,
    STR_PEEP_THOUGHT_TYPE_MUSIC = 1517,
    STR_PEEP_THOUGHT_TYPE_BALLOON = 1518,
    STR_PEEP_THOUGHT_TYPE_TOY = 1519,
    STR_PEEP_THOUGHT_TYPE_MAP = 1520,
    STR_PEEP_THOUGHT_TYPE_PHOTO = 1521,
    STR_PEEP_THOUGHT_TYPE_UMBRELLA = 1522,
    STR_PEEP_THOUGHT_TYPE_DRINK = 1523,
    STR_PEEP_THOUGHT_TYPE_BURGER = 1524,
    STR_PEEP_THOUGHT_TYPE_CHIPS = 1525,
    STR_PEEP_THOUGHT_TYPE_ICE_CREAM = 1526,
    STR_PEEP_THOUGHT_TYPE_CANDYFLOSS = 1527,
    // STR_1528    :
    // STR_1529    :
    // STR_1530    :
    STR_PEEP_THOUGHT_TYPE_PIZZA = 1531,
    // STR_1532    :
    STR_PEEP_THOUGHT_TYPE_POPCORN = 1533,
    STR_PEEP_THOUGHT_TYPE_HOT_DOG = 1534,
    STR_PEEP_THOUGHT_TYPE_TENTACLE = 1535,
    STR_PEEP_THOUGHT_TYPE_HAT = 1536,
    STR_PEEP_THOUGHT_TYPE_TOFFEE_APPLE = 1537,
    STR_PEEP_THOUGHT_TYPE_TSHIRT = 1538,
    STR_PEEP_THOUGHT_TYPE_DOUGHNUT = 1539,
    STR_PEEP_THOUGHT_TYPE_COFFEE = 1540,
    // STR_1541    :
    STR_PEEP_THOUGHT_TYPE_CHICKEN = 1542,
    STR_PEEP_THOUGHT_TYPE_LEMONADE = 1543,
    // STR_1544    :
    // STR_1545    :
    // STR_1546    :
    STR_PEEP_THOUGHT_TYPE_WOW = 1547, // This string is empty! STR_1547    :
                                      // STR_1548    :
                                      // STR_1549    :
    STR_PEEP_THOUGHT_TYPE_WOW2 = 1550,
    STR_PEEP_THOUGHT_TYPE_WATCHED = 1551,
    STR_PEEP_THOUGHT_TYPE_BALLOON_MUCH = 1552,
    STR_PEEP_THOUGHT_TYPE_TOY_MUCH = 1553,
    STR_PEEP_THOUGHT_TYPE_MAP_MUCH = 1554,
    STR_PEEP_THOUGHT_TYPE_PHOTO_MUCH = 1555,
    STR_PEEP_THOUGHT_TYPE_UMBRELLA_MUCH = 1556,
    STR_PEEP_THOUGHT_TYPE_DRINK_MUCH = 1557,
    STR_PEEP_THOUGHT_TYPE_BURGER_MUCH = 1558,
    STR_PEEP_THOUGHT_TYPE_CHIPS_MUCH = 1559,
    STR_PEEP_THOUGHT_TYPE_ICE_CREAM_MUCH = 1560,
    STR_PEEP_THOUGHT_TYPE_CANDYFLOSS_MUCH = 1561,
    // STR_1562    :
    // STR_1563    :
    // STR_1564    :
    STR_PEEP_THOUGHT_TYPE_PIZZA_MUCH = 1565,
    // STR_1566    :
    STR_PEEP_THOUGHT_TYPE_POPCORN_MUCH = 1567,
    STR_PEEP_THOUGHT_TYPE_HOT_DOG_MUCH = 1568,
    STR_PEEP_THOUGHT_TYPE_TENTACLE_MUCH = 1569,
    STR_PEEP_THOUGHT_TYPE_HAT_MUCH = 1570,
    STR_PEEP_THOUGHT_TYPE_TOFFEE_APPLE_MUCH = 1571,
    STR_PEEP_THOUGHT_TYPE_TSHIRT_MUCH = 1572,
    STR_PEEP_THOUGHT_TYPE_DOUGHNUT_MUCH = 1573,
    STR_PEEP_THOUGHT_TYPE_COFFEE_MUCH = 1574,
    // STR_1575    :
    STR_PEEP_THOUGHT_TYPE_CHICKEN_MUCH = 1576,
    STR_PEEP_THOUGHT_TYPE_LEMONADE_MUCH = 1577,
    // STR_1578    :
    // STR_1579    :
    // STR_1580    :
    // STR_1581    :
    // STR_1582    :
    // STR_1583    :
    STR_PEEP_THOUGHT_TYPE_PHOTO2 = 1584,
    STR_PEEP_THOUGHT_TYPE_PHOTO3 = 1585,
    STR_PEEP_THOUGHT_TYPE_PHOTO4 = 1586,
    STR_PEEP_THOUGHT_TYPE_PRETZEL = 1587,
    STR_PEEP_THOUGHT_TYPE_HOT_CHOCOLATE = 1588,
    STR_PEEP_THOUGHT_TYPE_ICED_TEA = 1589,
    STR_PEEP_THOUGHT_TYPE_FUNNEL_CAKE = 1590,
    STR_PEEP_THOUGHT_TYPE_SUNGLASSES = 1591,
    STR_PEEP_THOUGHT_TYPE_BEEF_NOODLES = 1592,
    STR_PEEP_THOUGHT_TYPE_FRIED_RICE_NOODLES = 1593,
    STR_PEEP_THOUGHT_TYPE_WONTON_SOUP = 1594,
    STR_PEEP_THOUGHT_TYPE_MEATBALL_SOUP = 1595,
    STR_PEEP_THOUGHT_TYPE_FRUIT_JUICE = 1596,
    STR_PEEP_THOUGHT_TYPE_SOYBEAN_MILK = 1597,
    STR_PEEP_THOUGHT_TYPE_SU_JONGKWA = 1598,
    STR_PEEP_THOUGHT_TYPE_SUB_SANDWICH = 1599,
    STR_PEEP_THOUGHT_TYPE_COOKIE = 1600,
    // STR_1601    :
    // STR_1602    :
    // STR_1603    :
    STR_PEEP_THOUGHT_TYPE_ROAST_SAUSAGE = 1604,
    // STR_1605    :
    // STR_1606    :
    // STR_1607    :
    // STR_1608    :
    // STR_1609    :
    // STR_1610    :
    // STR_1611    :
    // STR_1612    :
    // STR_1613    :
    // STR_1614    :
    // STR_1615    :
    STR_PEEP_THOUGHT_TYPE_PHOTO2_MUCH = 1616,
    STR_PEEP_THOUGHT_TYPE_PHOTO3_MUCH = 1617,
    STR_PEEP_THOUGHT_TYPE_PHOTO4_MUCH = 1618,
    STR_PEEP_THOUGHT_TYPE_PRETZEL_MUCH = 1619,
    STR_PEEP_THOUGHT_TYPE_HOT_CHOCOLATE_MUCH = 1620,
    STR_PEEP_THOUGHT_TYPE_ICED_TEA_MUCH = 1621,
    STR_PEEP_THOUGHT_TYPE_FUNNEL_CAKE_MUCH = 1622,
    STR_PEEP_THOUGHT_TYPE_SUNGLASSES_MUCH = 1623,
    STR_PEEP_THOUGHT_TYPE_BEEF_NOODLES_MUCH = 1624,
    STR_PEEP_THOUGHT_TYPE_FRIED_RICE_NOODLES_MUCH = 1625,
    STR_PEEP_THOUGHT_TYPE_WONTON_SOUP_MUCH = 1626,
    STR_PEEP_THOUGHT_TYPE_MEATBALL_SOUP_MUCH = 1627,
    STR_PEEP_THOUGHT_TYPE_FRUIT_JUICE_MUCH = 1628,
    STR_PEEP_THOUGHT_TYPE_SOYBEAN_MILK_MUCH = 1629,
    STR_PEEP_THOUGHT_TYPE_SU_JONGKWA_MUCH = 1630,
    STR_PEEP_THOUGHT_TYPE_SUB_SANDWICH_MUCH = 1631,
    STR_PEEP_THOUGHT_TYPE_COOKIE_MUCH = 1632,
    // STR_1633    :
    // STR_1634    :
    // STR_1635    :
    STR_PEEP_THOUGHT_TYPE_ROAST_SAUSAGE_MUCH = 1636,
    // STR_1637    :
    // STR_1638    :
    // STR_1639    :
    // STR_1640    :
    // STR_1641    :
    // STR_1642    :
    // STR_1643    :
    // STR_1644    :
    // STR_1645    :
    // STR_1646    :
    // STR_1647    :
    STR_PEEP_THOUGHT_TYPE_HELP = 1648,
    STR_PEEP_THOUGHT_TYPE_RUNNING_OUT = 1649,
    STR_PEEP_THOUGHT_TYPE_NEW_RIDE = 1650,
    STR_PEEP_THOUGHT_TYPE_NICE_RIDE_DEPRECATED = 1651,
    STR_PEEP_THOUGHT_TYPE_EXCITED_DEPRECATED = 1652,
    STR_PEEP_THOUGHT_TYPE_HERE_WE_ARE = 1653,
    STR_BRAKES = 1672,
    STR_SPINNING_CONTROL_TOGGLE_TRACK = 1673,
    STR_HELIX_UP_LEFT = 1679,
    STR_HELIX_UP_RIGHT = 1680,
    STR_HELIX_DOWN_LEFT = 1681,
    STR_HELIX_DOWN_RIGHT = 1682,
    STR_BASE_SIZE_2_X_2 = 1683,
    STR_BASE_SIZE_4_X_4 = 1684,
    STR_BASE_SIZE_2_X_4 = 1685,
    STR_BASE_SIZE_5_X_1 = 1686,
    STR_WATER_SPLASH = 1687,
    STR_BASE_SIZE_4_X_1 = 1688, // Unused
    STR_BLOCK_BRAKES = 1689,
    STR_CANNOT_PLACE_THESE_ON_QUEUE_LINE_AREA = 1697,
    STR_CAN_ONLY_PLACE_THESE_ON_QUEUE_AREA = 1698,
    STR_TOO_MANY_PEOPLE_IN_GAME = 1699,
    STR_CANT_HIRE_NEW_STAFF = 1704,
    STR_TOO_MANY_STAFF_IN_GAME = 1707,
    STR_INVALID_NAME_FOR_PARK = 1716,
    STR_CANT_RENAME_PARK = 1717,
    STR_CANT_OPEN_PARK = 1723,
    STR_CANT_CLOSE_PARK = 1724,
    STR_CANT_BUY_LAND = 1725,
    STR_LAND_NOT_FOR_SALE = 1726,
    STR_CONSTRUCTION_RIGHTS_NOT_FOR_SALE = 1727,
    STR_CANT_BUY_CONSTRUCTION_RIGHTS_HERE = 1728,
    STR_LAND_NOT_OWNED_BY_PARK = 1729,
    STR_BANNER_TEXT_CLOSED = 1730,
    STR_BANNER_TEXT_FORMAT = 1731,
    // STR_1737    :{COMMA16}
    STR_CANT_CHANGE_NUMBER_OF_LAPS = 1738,
    STR_RACE_WON_BY_GUEST = 1739,
    STR_RACE_WON_BY = 1740,
    STR_NOT_YET_CONSTRUCTED = 1741,
    // STR_1745    :{COMMA16}
    STR_CANT_CHANGE_THIS = 1746,
    // STR_1750    :{DURATION}
    STR_CANT_CHANGE_TIME_LIMIT = 1751,
    STR_WATERFALLS = 1762,
    STR_RAPIDS = 1763,
    STR_ON_RIDE_PHOTO_SECTION = 1765,
    STR_REVERSER_TURNTABLE = 1766,
    STR_SPINNING_TUNNEL = 1767,
    STR_CANT_CHANGE_NUMBER_OF_SWINGS = 1768,
    // STR_1772    :{COMMA16}
    STR_ONLY_ONE_ON_RIDE_PHOTO_PER_RIDE = 1773,
    STR_ONLY_ONE_CABLE_LIFT_HILL_PER_RIDE = 1774,
    // STR_OPTIONS_RIDE_MUSIC_OFF = 1775,
    // STR_OPTIONS_RIDE_MUSIC_ON = 1776,
    STR_SCROLLING_SIGN_TEXT = 1778,
    // STR_STAFF_OPTION_COSTUME_PANDA = 1779,
    // STR_STAFF_OPTION_COSTUME_TIGER = 1780,
    // STR_STAFF_OPTION_COSTUME_ELEPHANT = 1781,
    // STR_STAFF_OPTION_COSTUME_ROMAN = 1782,
    // STR_STAFF_OPTION_COSTUME_GORILLA = 1783,
    // STR_STAFF_OPTION_COSTUME_SNOWMAN = 1784,
    // STR_STAFF_OPTION_COSTUME_KNIGHT = 1785,
    // STR_STAFF_OPTION_COSTUME_ASTRONAUT = 1786,
    // STR_STAFF_OPTION_COSTUME_BANDIT = 1787,
    // STR_STAFF_OPTION_COSTUME_SHERIFF = 1788,
    // STR_STAFF_OPTION_COSTUME_PIRATE = 1789,
    STR_RESPONDING_TO_RIDE_BREAKDOWN_CALL = 1792,
    STR_HEADING_TO_RIDE_FOR_INSPECTION = 1793,
    STR_FIXING_RIDE = 1794,
    STR_ANSWERING_RADIO_CALL = 1795,
    STR_HAS_BROKEN_DOWN_AND_REQUIRES_FIXING = 1796,
    // STR_1797    :This option cannot be changed for this ride
    STR_WHIRLPOOL = 1798,
    STR_CANT_BUILD_THIS_HERE = 1811,
    // STR_1845    :{MONTHYEAR}  // Used in window_game_bottom_toolbar_onpaint
    STR_CANT_CHANGE_NUMBER_OF_ROTATIONS = 1868,
    // STR_1872    :{COMMA16}
    STR_EVERY_10_MINUTES = 1879,
    STR_EVERY_20_MINUTES = 1880,
    STR_EVERY_30_MINUTES = 1881,
    STR_EVERY_45_MINUTES = 1882,
    STR_EVERY_HOUR = 1883,
    STR_EVERY_2_HOURS = 1884,
    STR_NEVER = 1885,
    STR_INSPECTING_RIDE = 1886,
    // STR_1892    :<removed string - do not use>
    // STR_1893    :<removed string - do not use>
    STR_CANT_BORROW_ANY_MORE_MONEY = 1918,
    STR_NOT_ENOUGH_CASH_AVAILABLE = 1919,
    STR_CANT_PAY_BACK_LOAN = 1920,
    STR_ERR_CANT_PLACE_PERSON_HERE = 1925,
    // STR_1926    :<removed string - do not use>
    STR_RIDE_IS_BROKEN_DOWN = 1927,
    STR_RIDE_HAS_CRASHED = 1928,
    STR_RIDE_IS_STILL_NOT_FIXED = 1929,
    STR_PEEP_TRACKING_PEEP_JOINED_QUEUE_FOR_X = 1931,
    STR_PEEP_TRACKING_PEEP_IS_ON_X = 1932,
    STR_PEEP_TRACKING_PEEP_IS_IN_X = 1933,
    STR_PEEP_TRACKING_LEFT_RIDE_X = 1934,
    STR_PEEP_TRACKING_LEFT_PARK = 1935,
    STR_PEEP_TRACKING_NOTIFICATION_BOUGHT_X = 1936,
    // STR_1958    :{COMMA16}
    // STR_1959    :Can't change number of circuits...
    STR_SHOP_ITEM_PRICE_LABEL_BALLOON = 1960,
    STR_SHOP_ITEM_PRICE_LABEL_CUDDLY_TOY = 1961,
    STR_SHOP_ITEM_PRICE_LABEL_PARK_MAP = 1962,
    STR_SHOP_ITEM_PRICE_LABEL_ON_RIDE_PHOTO = 1963,
    STR_SHOP_ITEM_PRICE_LABEL_UMBRELLA = 1964,
    STR_SHOP_ITEM_PRICE_LABEL_DRINK = 1965,
    STR_SHOP_ITEM_PRICE_LABEL_BURGER = 1966,
    STR_SHOP_ITEM_PRICE_LABEL_CHIPS = 1967,
    STR_SHOP_ITEM_PRICE_LABEL_ICE_CREAM = 1968,
    STR_SHOP_ITEM_PRICE_LABEL_CANDYFLOSS = 1969,
    STR_SHOP_ITEM_PRICE_LABEL_EMPTY_CAN = 1970,        // Empty
    STR_SHOP_ITEM_PRICE_LABEL_RUBBISH = 1971,          // Empty
    STR_SHOP_ITEM_PRICE_LABEL_EMPTY_BURGER_BOX = 1972, // Empty
    STR_SHOP_ITEM_PRICE_LABEL_PIZZA = 1973,
    STR_SHOP_ITEM_PRICE_LABEL_VOUCHER = 1974, // Empty
    STR_SHOP_ITEM_PRICE_LABEL_POPCORN = 1975,
    STR_SHOP_ITEM_PRICE_LABEL_HOT_DOG = 1976,
    STR_SHOP_ITEM_PRICE_LABEL_TENTACLE = 1977,
    STR_SHOP_ITEM_PRICE_LABEL_HAT = 1978,
    STR_SHOP_ITEM_PRICE_LABEL_TOFFEE_APPLE = 1979,
    STR_SHOP_ITEM_PRICE_LABEL_T_SHIRT = 1980,
    STR_SHOP_ITEM_PRICE_LABEL_DOUGHNUT = 1981,
    STR_SHOP_ITEM_PRICE_LABEL_COFFEE = 1982,
    STR_SHOP_ITEM_PRICE_LABEL_EMPTY_CUP = 1983, // Empty
    STR_SHOP_ITEM_PRICE_LABEL_FRIED_CHICKEN = 1984,
    STR_SHOP_ITEM_PRICE_LABEL_LEMONADE = 1985,
    STR_SHOP_ITEM_PRICE_LABEL_EMPTY_BOX = 1986,    // Empty
    STR_SHOP_ITEM_PRICE_LABEL_EMPTY_BOTTLE = 1987, // Empty
    STR_SHOP_ITEM_SINGULAR_BALLOON = 1988,
    STR_SHOP_ITEM_SINGULAR_CUDDLY_TOY = 1989,
    STR_SHOP_ITEM_SINGULAR_PARK_MAP = 1990,
    STR_SHOP_ITEM_SINGULAR_ON_RIDE_PHOTO = 1991,
    STR_SHOP_ITEM_SINGULAR_UMBRELLA = 1992,
    STR_SHOP_ITEM_SINGULAR_DRINK = 1993,
    STR_SHOP_ITEM_SINGULAR_BURGER = 1994,
    STR_SHOP_ITEM_SINGULAR_CHIPS = 1995,
    STR_SHOP_ITEM_SINGULAR_ICE_CREAM = 1996,
    STR_SHOP_ITEM_SINGULAR_CANDYFLOSS = 1997,
    STR_SHOP_ITEM_SINGULAR_EMPTY_CAN = 1998,
    STR_SHOP_ITEM_SINGULAR_RUBBISH = 1999,
    STR_SHOP_ITEM_SINGULAR_EMPTY_BURGER_BOX = 2000,
    STR_SHOP_ITEM_SINGULAR_PIZZA = 2001,
    STR_SHOP_ITEM_SINGULAR_VOUCHER = 2002,
    STR_SHOP_ITEM_SINGULAR_POPCORN = 2003,
    STR_SHOP_ITEM_SINGULAR_HOT_DOG = 2004,
    STR_SHOP_ITEM_SINGULAR_TENTACLE = 2005,
    STR_SHOP_ITEM_SINGULAR_HAT = 2006,
    STR_SHOP_ITEM_SINGULAR_TOFFEE_APPLE = 2007,
    STR_SHOP_ITEM_SINGULAR_T_SHIRT = 2008,
    STR_SHOP_ITEM_SINGULAR_DOUGHNUT = 2009,
    STR_SHOP_ITEM_SINGULAR_COFFEE = 2010,
    STR_SHOP_ITEM_SINGULAR_EMPTY_CUP = 2011,
    STR_SHOP_ITEM_SINGULAR_FRIED_CHICKEN = 2012,
    STR_SHOP_ITEM_SINGULAR_LEMONADE = 2013,
    STR_SHOP_ITEM_SINGULAR_EMPTY_BOX = 2014,
    STR_SHOP_ITEM_SINGULAR_EMPTY_BOTTLE = 2015,
    STR_SHOP_ITEM_PLURAL_BALLOON = 2016,
    STR_SHOP_ITEM_PLURAL_CUDDLY_TOY = 2017,
    STR_SHOP_ITEM_PLURAL_PARK_MAP = 2018,
    STR_SHOP_ITEM_PLURAL_ON_RIDE_PHOTO = 2019,
    STR_SHOP_ITEM_PLURAL_UMBRELLA = 2020,
    STR_SHOP_ITEM_PLURAL_DRINK = 2021,
    STR_SHOP_ITEM_PLURAL_BURGER = 2022,
    STR_SHOP_ITEM_PLURAL_CHIPS = 2023,
    STR_SHOP_ITEM_PLURAL_ICE_CREAM = 2024,
    STR_SHOP_ITEM_PLURAL_CANDYFLOSS = 2025,
    STR_SHOP_ITEM_PLURAL_EMPTY_CAN = 2026,
    STR_SHOP_ITEM_PLURAL_RUBBISH = 2027,
    STR_SHOP_ITEM_PLURAL_EMPTY_BURGER_BOX = 2028,
    STR_SHOP_ITEM_PLURAL_PIZZA = 2029,
    STR_SHOP_ITEM_PLURAL_VOUCHER = 2030,
    STR_SHOP_ITEM_PLURAL_POPCORN = 2031,
    STR_SHOP_ITEM_PLURAL_HOT_DOG = 2032,
    STR_SHOP_ITEM_PLURAL_TENTACLE = 2033,
    STR_SHOP_ITEM_PLURAL_HAT = 2034,
    STR_SHOP_ITEM_PLURAL_TOFFEE_APPLE = 2035,
    STR_SHOP_ITEM_PLURAL_T_SHIRT = 2036,
    STR_SHOP_ITEM_PLURAL_DOUGHNUT = 2037,
    STR_SHOP_ITEM_PLURAL_COFFEE = 2038,
    STR_SHOP_ITEM_PLURAL_EMPTY_CUP = 2039,
    STR_SHOP_ITEM_PLURAL_FRIED_CHICKEN = 2040,
    STR_SHOP_ITEM_PLURAL_LEMONADE = 2041,
    STR_SHOP_ITEM_PLURAL_EMPTY_BOX = 2042,
    STR_SHOP_ITEM_PLURAL_EMPTY_BOTTLE = 2043,
    STR_SHOP_ITEM_INDEFINITE_BALLOON = 2044,
    STR_SHOP_ITEM_INDEFINITE_CUDDLY_TOY = 2045,
    STR_SHOP_ITEM_INDEFINITE_PARK_MAP = 2046,
    STR_SHOP_ITEM_INDEFINITE_ON_RIDE_PHOTO = 2047,
    STR_SHOP_ITEM_INDEFINITE_UMBRELLA = 2048,
    STR_SHOP_ITEM_INDEFINITE_DRINK = 2049,
    STR_SHOP_ITEM_INDEFINITE_BURGER = 2050,
    STR_SHOP_ITEM_INDEFINITE_CHIPS = 2051,
    STR_SHOP_ITEM_INDEFINITE_ICE_CREAM = 2052,
    STR_SHOP_ITEM_INDEFINITE_CANDYFLOSS = 2053,
    STR_SHOP_ITEM_INDEFINITE_EMPTY_CAN = 2054,
    STR_SHOP_ITEM_INDEFINITE_RUBBISH = 2055,
    STR_SHOP_ITEM_INDEFINITE_EMPTY_BURGER_BOX = 2056,
    STR_SHOP_ITEM_INDEFINITE_PIZZA = 2057,
    STR_SHOP_ITEM_INDEFINITE_VOUCHER = 2058,
    STR_SHOP_ITEM_INDEFINITE_POPCORN = 2059,
    STR_SHOP_ITEM_INDEFINITE_HOT_DOG = 2060,
    STR_SHOP_ITEM_INDEFINITE_TENTACLE = 2061,
    STR_SHOP_ITEM_INDEFINITE_HAT = 2062,
    STR_SHOP_ITEM_INDEFINITE_TOFFEE_APPLE = 2063,
    STR_SHOP_ITEM_INDEFINITE_T_SHIRT = 2064,
    STR_SHOP_ITEM_INDEFINITE_DOUGHNUT = 2065,
    STR_SHOP_ITEM_INDEFINITE_COFFEE = 2066,
    STR_SHOP_ITEM_INDEFINITE_EMPTY_CUP = 2067,
    STR_SHOP_ITEM_INDEFINITE_FRIED_CHICKEN = 2068,
    STR_SHOP_ITEM_INDEFINITE_LEMONADE = 2069,
    STR_SHOP_ITEM_INDEFINITE_EMPTY_BOX = 2070,
    STR_SHOP_ITEM_INDEFINITE_EMPTY_BOTTLE = 2071,
    STR_SHOP_ITEM_DISPLAY_BALLOON = 2072,
    STR_SHOP_ITEM_DISPLAY_CUDDLY_TOY = 2073,
    STR_SHOP_ITEM_DISPLAY_PARK_MAP = 2074,
    STR_SHOP_ITEM_DISPLAY_ON_RIDE_PHOTO = 2075,
    STR_SHOP_ITEM_DISPLAY_UMBRELLA = 2076,
    STR_SHOP_ITEM_DISPLAY_DRINK = 2077,
    STR_SHOP_ITEM_DISPLAY_BURGER = 2078,
    STR_SHOP_ITEM_DISPLAY_CHIPS = 2079,
    STR_SHOP_ITEM_DISPLAY_ICE_CREAM = 2080,
    STR_SHOP_ITEM_DISPLAY_CANDYFLOSS = 2081,
    STR_SHOP_ITEM_DISPLAY_EMPTY_CAN = 2082,
    STR_SHOP_ITEM_DISPLAY_RUBBISH = 2083,
    STR_SHOP_ITEM_DISPLAY_EMPTY_BURGER_BOX = 2084,
    STR_SHOP_ITEM_DISPLAY_PIZZA = 2085,
    STR_SHOP_ITEM_DISPLAY_VOUCHER = 2086,
    STR_SHOP_ITEM_DISPLAY_POPCORN = 2087,
    STR_SHOP_ITEM_DISPLAY_HOT_DOG = 2088,
    STR_SHOP_ITEM_DISPLAY_TENTACLE = 2089,
    STR_SHOP_ITEM_DISPLAY_HAT = 2090,
    STR_SHOP_ITEM_DISPLAY_TOFFEE_APPLE = 2091,
    STR_SHOP_ITEM_DISPLAY_T_SHIRT = 2092,
    STR_SHOP_ITEM_DISPLAY_DOUGHNUT = 2093,
    STR_SHOP_ITEM_DISPLAY_COFFEE = 2094,
    STR_SHOP_ITEM_DISPLAY_EMPTY_CUP = 2095,
    STR_SHOP_ITEM_DISPLAY_FRIED_CHICKEN = 2096,
    STR_SHOP_ITEM_DISPLAY_LEMONADE = 2097,
    STR_SHOP_ITEM_DISPLAY_EMPTY_BOX = 2098,
    STR_SHOP_ITEM_DISPLAY_EMPTY_BOTTLE = 2099,

    STR_SHOP_ITEM_PRICE_LABEL_PRETZEL = 2103,
    STR_SHOP_ITEM_PRICE_LABEL_HOT_CHOCOLATE = 2104,
    STR_SHOP_ITEM_PRICE_LABEL_ICED_TEA = 2105,
    STR_SHOP_ITEM_PRICE_LABEL_FUNNEL_CAKE = 2106,
    STR_SHOP_ITEM_PRICE_LABEL_SUNGLASSES = 2107,
    STR_SHOP_ITEM_PRICE_LABEL_BEEF_NOODLES = 2108,
    STR_SHOP_ITEM_PRICE_LABEL_FRIED_RICE_NOODLES = 2109,
    STR_SHOP_ITEM_PRICE_LABEL_WONTON_SOUP = 2110,
    STR_SHOP_ITEM_PRICE_LABEL_MEATBALL_SOUP = 2111,
    STR_SHOP_ITEM_PRICE_LABEL_FRUIT_JUICE = 2112,
    STR_SHOP_ITEM_PRICE_LABEL_SOYBEAN_MILK = 2113,
    STR_SHOP_ITEM_PRICE_LABEL_SUJONGKWA = 2114,
    STR_SHOP_ITEM_PRICE_LABEL_SUB_SANDWICH = 2115,
    STR_SHOP_ITEM_PRICE_LABEL_COOKIE = 2116,
    STR_SHOP_ITEM_PRICE_LABEL_EMPTY_BOWL_RED = 2117,     // Empty
    STR_SHOP_ITEM_PRICE_LABEL_EMPTY_DRINK_CARTON = 2118, // Empty
    STR_SHOP_ITEM_PRICE_LABEL_EMPTY_JUICE_CUP = 2119,    // Empty
    STR_SHOP_ITEM_PRICE_LABEL_ROAST_SAUSAGE = 2120,
    STR_SHOP_ITEM_PRICE_LABEL_EMPTY_BOWL_BLUE = 2121, // Empty

    STR_SHOP_ITEM_SINGULAR_PRETZEL = 2125,
    STR_SHOP_ITEM_SINGULAR_HOT_CHOCOLATE = 2126,
    STR_SHOP_ITEM_SINGULAR_ICED_TEA = 2127,
    STR_SHOP_ITEM_SINGULAR_FUNNEL_CAKE = 2128,
    STR_SHOP_ITEM_SINGULAR_SUNGLASSES = 2129,
    STR_SHOP_ITEM_SINGULAR_BEEF_NOODLES = 2130,
    STR_SHOP_ITEM_SINGULAR_FRIED_RICE_NOODLES = 2131,
    STR_SHOP_ITEM_SINGULAR_WONTON_SOUP = 2132,
    STR_SHOP_ITEM_SINGULAR_MEATBALL_SOUP = 2133,
    STR_SHOP_ITEM_SINGULAR_FRUIT_JUICE = 2134,
    STR_SHOP_ITEM_SINGULAR_SOYBEAN_MILK = 2135,
    STR_SHOP_ITEM_SINGULAR_SUJONGKWA = 2136,
    STR_SHOP_ITEM_SINGULAR_SUB_SANDWICH = 2137,
    STR_SHOP_ITEM_SINGULAR_COOKIE = 2138,
    STR_SHOP_ITEM_SINGULAR_EMPTY_BOWL_RED = 2139,
    STR_SHOP_ITEM_SINGULAR_EMPTY_DRINK_CARTON = 2140,
    STR_SHOP_ITEM_SINGULAR_EMPTY_JUICE_CUP = 2141,
    STR_SHOP_ITEM_SINGULAR_ROAST_SAUSAGE = 2142,
    STR_SHOP_ITEM_SINGULAR_EMPTY_BOWL_BLUE = 2143,

    STR_SHOP_ITEM_PLURAL_PRETZEL = 2147,
    STR_SHOP_ITEM_PLURAL_HOT_CHOCOLATE = 2148,
    STR_SHOP_ITEM_PLURAL_ICED_TEA = 2149,
    STR_SHOP_ITEM_PLURAL_FUNNEL_CAKE = 2150,
    STR_SHOP_ITEM_PLURAL_SUNGLASSES = 2151,
    STR_SHOP_ITEM_PLURAL_BEEF_NOODLES = 2152,
    STR_SHOP_ITEM_PLURAL_FRIED_RICE_NOODLES = 2153,
    STR_SHOP_ITEM_PLURAL_WONTON_SOUP = 2154,
    STR_SHOP_ITEM_PLURAL_MEATBALL_SOUP = 2155,
    STR_SHOP_ITEM_PLURAL_FRUIT_JUICE = 2156,
    STR_SHOP_ITEM_PLURAL_SOYBEAN_MILK = 2157,
    STR_SHOP_ITEM_PLURAL_SUJONGKWA = 2158,
    STR_SHOP_ITEM_PLURAL_SUB_SANDWICH = 2159,
    STR_SHOP_ITEM_PLURAL_COOKIE = 2160,
    STR_SHOP_ITEM_PLURAL_EMPTY_BOWL_RED = 2161,
    STR_SHOP_ITEM_PLURAL_EMPTY_DRINK_CARTON = 2162,
    STR_SHOP_ITEM_PLURAL_EMPTY_JUICE_CUP = 2163,
    STR_SHOP_ITEM_PLURAL_ROAST_SAUSAGE = 2164,
    STR_SHOP_ITEM_PLURAL_EMPTY_BOWL_BLUE = 2165,

    STR_SHOP_ITEM_INDEFINITE_PRETZEL = 2169,
    STR_SHOP_ITEM_INDEFINITE_HOT_CHOCOLATE = 2170,
    STR_SHOP_ITEM_INDEFINITE_ICED_TEA = 2171,
    STR_SHOP_ITEM_INDEFINITE_FUNNEL_CAKE = 2172,
    STR_SHOP_ITEM_INDEFINITE_SUNGLASSES = 2173,
    STR_SHOP_ITEM_INDEFINITE_BEEF_NOODLES = 2174,
    STR_SHOP_ITEM_INDEFINITE_FRIED_RICE_NOODLES = 2175,
    STR_SHOP_ITEM_INDEFINITE_WONTON_SOUP = 2176,
    STR_SHOP_ITEM_INDEFINITE_MEATBALL_SOUP = 2177,
    STR_SHOP_ITEM_INDEFINITE_FRUIT_JUICE = 2178,
    STR_SHOP_ITEM_INDEFINITE_SOYBEAN_MILK = 2179,
    STR_SHOP_ITEM_INDEFINITE_SUJONGKWA = 2180,
    STR_SHOP_ITEM_INDEFINITE_SUB_SANDWICH = 2181,
    STR_SHOP_ITEM_INDEFINITE_COOKIE = 2182,
    STR_SHOP_ITEM_INDEFINITE_EMPTY_BOWL_RED = 2183,
    STR_SHOP_ITEM_INDEFINITE_EMPTY_DRINK_CARTON = 2184,
    STR_SHOP_ITEM_INDEFINITE_EMPTY_JUICE_CUP = 2185,
    STR_SHOP_ITEM_INDEFINITE_ROAST_SAUSAGE = 2186,
    STR_SHOP_ITEM_INDEFINITE_EMPTY_BOWL_BLUE = 2187,

    STR_SHOP_ITEM_DISPLAY_PRETZEL = 2191,
    STR_SHOP_ITEM_DISPLAY_HOT_CHOCOLATE = 2192,
    STR_SHOP_ITEM_DISPLAY_ICED_TEA = 2193,
    STR_SHOP_ITEM_DISPLAY_FUNNEL_CAKE = 2194,
    STR_SHOP_ITEM_DISPLAY_SUNGLASSES = 2195,
    STR_SHOP_ITEM_DISPLAY_BEEF_NOODLES = 2196,
    STR_SHOP_ITEM_DISPLAY_FRIED_RICE_NOODLES = 2197,
    STR_SHOP_ITEM_DISPLAY_WONTON_SOUP = 2198,
    STR_SHOP_ITEM_DISPLAY_MEATBALL_SOUP = 2199,
    STR_SHOP_ITEM_DISPLAY_FRUIT_JUICE = 2200,
    STR_SHOP_ITEM_DISPLAY_SOYBEAN_MILK = 2201,
    STR_SHOP_ITEM_DISPLAY_SUJONGKWA = 2202,
    STR_SHOP_ITEM_DISPLAY_SUB_SANDWICH = 2203,
    STR_SHOP_ITEM_DISPLAY_COOKIE = 2204,
    STR_SHOP_ITEM_DISPLAY_EMPTY_BOWL_RED = 2205,
    STR_SHOP_ITEM_DISPLAY_EMPTY_DRINK_CARTON = 2206,
    STR_SHOP_ITEM_DISPLAY_EMPTY_JUICE_CUP = 2207,
    STR_SHOP_ITEM_DISPLAY_ROAST_SAUSAGE = 2208,
    STR_SHOP_ITEM_DISPLAY_EMPTY_BOWL_BLUE = 2209,
    STR_CONSTRUCTION_NOT_POSSIBLE_WHILE_GAME_IS_PAUSED = 2214,
    STR_RIDE_MAP_TIP = 2215,
    STR_NEWS_VEHICLE_HAS_STALLED = 2218,
    STR_X_PEOPLE_DIED_ON_X = 2219,
    STR_SLOPE_UP_TO_VERTICAL = 2229,
    STR_VERTICAL_TRACK = 2230,
    STR_HOLDING_BRAKE_FOR_DROP = 2231,
    STR_CABLE_LIFT_HILL = 2232,
    STR_MONTH_JANUARY = 2236,  // unused
    STR_MONTH_FEBRUARY = 2237, // unused
    STR_MONTH_MARCH = 2238,
    STR_MONTH_APRIL = 2239,
    STR_MONTH_MAY = 2240,
    STR_MONTH_JUNE = 2241,
    STR_MONTH_JULY = 2242,
    STR_MONTH_AUGUST = 2243,
    STR_MONTH_SEPTEMBER = 2244,
    STR_MONTH_OCTOBER = 2245,
    STR_MONTH_NOVEMBER = 2246, // unused
    STR_MONTH_DECEMBER = 2247, // unused
    STR_CANT_DEMOLISH_RIDE = 2248,
    STR_NEWS_ITEM_RESEARCH_NEW_RIDE_AVAILABLE = 2249,
    STR_NEWS_ITEM_RESEARCH_NEW_SCENERY_SET_AVAILABLE = 2250,
    STR_CAN_ONLY_BE_BUILT_ON_PATHS = 2251,
    STR_CAN_ONLY_BE_BUILT_ACROSS_PATHS = 2252,
    STR_RESEARCH_NEW_TRANSPORT_RIDES = 2253,
    STR_RESEARCH_NEW_GENTLE_RIDES = 2254,
    STR_RESEARCH_NEW_ROLLER_COASTERS = 2255,
    STR_RESEARCH_NEW_THRILL_RIDES = 2256,
    STR_RESEARCH_NEW_WATER_RIDES = 2257,
    STR_RESEARCH_NEW_SHOPS_AND_STALLS = 2258,
    STR_RESEARCH_NEW_SCENERY_AND_THEMING = 2259,
    STR_RESEARCH_FUNDING_NONE = 2260,
    STR_RESEARCH_FUNDING_MINIMUM = 2261,
    STR_RESEARCH_FUNDING_NORMAL = 2262,
    STR_RESEARCH_FUNDING_MAXIMUM = 2263,
    STR_RESEARCH_CATEGORY_TRANSPORT = 2278,
    STR_RESEARCH_CATEGORY_GENTLE = 2279,
    STR_RESEARCH_CATEGORY_ROLLERCOASTER = 2280,
    STR_RESEARCH_CATEGORY_THRILL = 2281,
    STR_RESEARCH_CATEGORY_WATER = 2282,
    STR_RESEARCH_CATEGORY_SHOP = 2283,
    STR_RESEARCH_CATEGORY_SCENERY_GROUP = 2284,
    // STR_2290    :<removed string - do not use>
    // STR_2305    :Track design files
    // STR_2306    :Save track design
    // STR_2317    :<removed string - do not use>
    // STR_2318    :<removed string - do not use>
    // STR_2319    :<removed string - do not use>
    // STR_2320    :<removed string - do not use>
    STR_UNITS = 2332,
    STR_POUNDS = 2334,
    STR_DOLLARS = 2335,
    STR_FRANC = 2336,
    STR_DEUTSCHE_MARK = 2337,
    STR_YEN = 2338,
    STR_PESETA = 2339,
    STR_LIRA = 2340,
    STR_GUILDERS = 2341,
    STR_KRONA = 2342,
    STR_EUROS = 2343,
    // STR_DISPLAY = 2346, // Unused
    STR_NEWS_ITEM_GUEST_DROWNED = 2347,
    // STR_2357    :House
    STR_BANK_REFUSES_TO_INCREASE_LOAN = 2365,
    STR_OBJECTIVE_NONE = 2385,
    STR_OBJECTIVE_GUESTS_BY = STR_OBJECTIVE_NONE + 1,
    STR_OBJECTIVE_PARK_VALUE_BY = STR_OBJECTIVE_NONE + 2,
    STR_OBJECTIVE_HAVE_FUN = STR_OBJECTIVE_NONE + 3,
    STR_OBJECTIVE_BUILD_THE_BEST = STR_OBJECTIVE_NONE + 4,
    STR_OBJECTIVE_10_ROLLERCOASTERS = STR_OBJECTIVE_NONE + 5,
    STR_OBJECTIVE_GUESTS_AND_RATING = STR_OBJECTIVE_NONE + 6,
    STR_OBJECTIVE_MONTHLY_RIDE_INCOME = STR_OBJECTIVE_NONE + 7,
    STR_OBJECTIVE_10_ROLLERCOASTERS_LENGTH = STR_OBJECTIVE_NONE + 8,
    STR_OBJECTIVE_FINISH_5_ROLLERCOASTERS = STR_OBJECTIVE_NONE + 9,
    STR_OBJECTIVE_REPLAY_LOAN_AND_PARK_VALUE = STR_OBJECTIVE_NONE + 10,
    STR_OBJECTIVE_MONTHLY_FOOD_INCOME = STR_OBJECTIVE_NONE + 11,
    // STR_2422    :Advertising campaign for {STRINGID}
    // STR_2423    :Advertising campaign for {STRINGID}
    STR_MARKETING_VOUCHERS_FOR_FREE_ENTRY_TO_THE_PARK = 2424,
    STR_MARKETING_VOUCHERS_FOR_FREE_RIDES_ON_A_PARTICULAR_RIDE = 2425,
    STR_MARKETING_VOUCHERS_FOR_HALF_PRICE_ENTRY_TO_THE_PARK = 2426,
    STR_MARKETING_VOUCHERS_FOR_FREE_FOOD_OR_DRINK = 2427,
    STR_MARKETING_ADVERTISING_CAMPAIGN_FOR_THE_PARK = 2428,
    STR_MARKETING_ADVERTISING_CAMPAIGN_FOR_A_PARTICULAR_RIDE = 2429,
    STR_VOUCHERS_FOR_FREE_ENTRY_TO = 2430,
    STR_VOUCHERS_FOR_FREE_RIDE_ON = 2431,
    STR_VOUCHERS_FOR_HALF_PRICE_ENTRY_TO = 2432,
    STR_VOUCHERS_FOR_FREE = 2433,
    STR_ADVERTISING_CAMPAIGN_FOR_1 = 2434,
    STR_ADVERTISING_CAMPAIGN_FOR_2 = 2435,
    // STR_2437    :<removed string - do not use>
    // STR_2438    :<removed string - do not use>
    // STR_2439    :<removed string - do not use>
    // STR_2440    :<removed string - do not use>
    // STR_2441    :<removed string - do not use>
    // STR_2442    :<removed string - do not use>
    STR_MARKETING_FINISHED_FREE_ENTRY = 2446,
    STR_MARKETING_FINISHED_FREE_RIDES = 2447,
    STR_MARKETING_FINISHED_HALF_PRICE_ENTRY = 2448,
    STR_MARKETING_FINISHED_FREE_RIDE = 2449,
    STR_MARKETING_FINISHED_PARK_ADS = 2450,
    STR_MARKETING_FINISHED_RIDE_ADS = 2451,
    // STR_FINANCES_FINANCIAL_GRAPH_CASH_VALUE_POSITIVE = 2455, // Unused
    // STR_FINANCES_FINANCIAL_GRAPH_CASH_VALUE_NEGATIVE = 2456, // Unused
    // STR_CONTROLS = 2485, // Unused
    // STR_GENERAL = 2486,  // Unused
    STR_SHORTCUT_ACTION_RESET = 2491,
    STR_SHORTCUT_INVISIBLE_PEOPLE_TOGGLE = 2507,
    STR_SHORTCUT_SHOW_MAP = 2523,

    // 2525--2532 unused

    // 2535--2536 unused

    STR_SHORTCUT_CLEAR = 2537,

    // 2539--2542 unused

    STR_SHORTCUT_ALT = 2543,
    STR_SHORTCUT_PAUSE = 2544,
    STR_SHORTCUT_CAPS = 2545,

    // 2546--2551 unused

    // 2553--2556 unused

    STR_SHORTCUT_END = 2560,
    STR_SHORTCUT_HOME = 2561,
    STR_SHORTCUT_SELECT = 2566,
    STR_SHORTCUT_PRINT = 2567,
    STR_SHORTCUT_EXECUTE = 2568,
    STR_SHORTCUT_SNAPSHOT = 2569,
    STR_SHORTCUT_HELP = 2572,

    // 2573--2617 unused

    STR_SHORTCUT_MENU = 2618,

    // 2619--2620 unused

    // 2633 unused

    // 2637--2668 unused

    STR_SHORTCUT_NUMLOCK = 2669,
    STR_SHORTCUT_SCROLL = 2670,

    // 2671--2679 unused

    // STR_2681    :<removed string - do not use>
    // STR_2682    :<removed string - do not use>
    // STR_2683    :<removed string - do not use>

    // 2697--2699 unused

    // 2711--2717 unused

    STR_DURATION_SEC = 2720,
    STR_DURATION_SECS = 2721,
    STR_DURATION_MIN_SEC = 2722,
    STR_DURATION_MIN_SECS = 2723,
    STR_DURATION_MINS_SEC = 2724,
    STR_DURATION_MINS_SECS = 2725,
    STR_REALTIME_MIN = 2726,
    STR_REALTIME_MINS = 2727,
    STR_REALTIME_HOUR_MIN = 2728,
    STR_REALTIME_HOUR_MINS = 2729,
    STR_REALTIME_HOURS_MIN = 2730,
    STR_REALTIME_HOURS_MINS = 2731,
    STR_UNIT_SUFFIX_FEET = 2732,
    STR_UNIT_SUFFIX_METRES = 2733,
    STR_UNIT_SUFFIX_MILES_PER_HOUR = 2734,
    STR_UNIT_SUFFIX_KILOMETRES_PER_HOUR = 2735,
    STR_DATE_FORMAT_MY = 2736,
    STR_DATE_FORMAT_DMY = 2737,
    STR_ROLLERCOASTER_TYCOON_2_DROPDOWN = 2741,

    // 2744--2748 unused

    STR_MY_NEW_SCENARIO = 2749,
    STR_CHEAT_CLEAR_GRASS = 2752,
    STR_CHEAT_WATER_PLANTS = 2754,
    STR_CHEAT_FIX_VANDALISM = 2755,
    STR_CHEAT_REMOVE_LITTER = 2756,

    // 2757--2764 unused

    STR_CHEAT_LARGE_TRAM_GUESTS = 2765,
    STR_CHEAT_WIN_SCENARIO = 2766,
    STR_CHEAT_FREEZE_WEATHER = 2767,

    STR_CHEAT_OPEN_PARK = 2769,
    // STR_2771    :Slower Gamespeed
    // STR_2772    :Faster Gamespeed
    STR_SHIFT_PLUS = 2782,
    STR_CTRL_PLUS = 2783,
    STR_PEEPS_DISGUSTED_BY_PATHS = 2806,
    STR_PEEPS_DISLIKE_LITTER = 2807,
    STR_PEEPS_DISLIKE_VANDALISM = 2808,
    STR_PEEPS_ARE_HUNGRY = 2809,
    STR_PEEPS_ARE_THIRSTY = 2810,
    STR_PEEPS_CANT_FIND_TOILET = 2811,
    STR_PEEPS_GETTING_LOST_OR_STUCK = 2812,
    STR_ENTRANCE_FEE_TOO_HI = 2813,
    STR_AWARD_MOST_UNTIDY = 2814,
    STR_AWARD_BEST_CUSTOM_DESIGNED_RIDES = STR_AWARD_MOST_UNTIDY + 13,
    STR_AWARD_BEST_FOOD = STR_AWARD_MOST_UNTIDY + 8,
    STR_AWARD_BEST_GENTLE_RIDES = STR_AWARD_MOST_UNTIDY + 16,
    STR_AWARD_BEST_ROLLERCOASTERS = STR_AWARD_MOST_UNTIDY + 2,
    STR_AWARD_BEST_STAFF = STR_AWARD_MOST_UNTIDY + 7,
    STR_AWARD_BEST_TOILETS = STR_AWARD_MOST_UNTIDY + 10,
    STR_AWARD_BEST_VALUE = STR_AWARD_MOST_UNTIDY + 3,
    STR_AWARD_BEST_WATER_RIDES = STR_AWARD_MOST_UNTIDY + 12,
    STR_AWARD_MOST_BEAUTIFUL = STR_AWARD_MOST_UNTIDY + 4,
    STR_AWARD_MOST_CONFUSING_LAYOUT = STR_AWARD_MOST_UNTIDY + 15,
    STR_AWARD_MOST_DAZZLING_RIDE_COLOURS = STR_AWARD_MOST_UNTIDY + 14,
    STR_AWARD_MOST_DISAPPOINTING = STR_AWARD_MOST_UNTIDY + 11,
    STR_AWARD_MOST_TIDY = STR_AWARD_MOST_UNTIDY + 1,
    STR_AWARD_SAFEST = STR_AWARD_MOST_UNTIDY + 6,
    STR_AWARD_WORST_FOOD = STR_AWARD_MOST_UNTIDY + 9,
    STR_AWARD_WORST_VALUE = STR_AWARD_MOST_UNTIDY + 5,
    STR_NEWS_ITEM_AWARD_MOST_UNTIDY = 2831,
    STR_NEWS_ITEM_MOST_TIDY = STR_NEWS_ITEM_AWARD_MOST_UNTIDY + 1,
    STR_NEWS_ITEM_BEST_ROLLERCOASTERS = STR_NEWS_ITEM_AWARD_MOST_UNTIDY + 2,
    STR_NEWS_ITEM_BEST_VALUE = STR_NEWS_ITEM_AWARD_MOST_UNTIDY + 3,
    STR_NEWS_ITEM_MOST_BEAUTIFUL = STR_NEWS_ITEM_AWARD_MOST_UNTIDY + 4,
    STR_NEWS_ITEM_WORST_VALUE = STR_NEWS_ITEM_AWARD_MOST_UNTIDY + 5,
    STR_NEWS_ITEM_SAFEST = STR_NEWS_ITEM_AWARD_MOST_UNTIDY + 6,
    STR_NEWS_ITEM_BEST_STAFF = STR_NEWS_ITEM_AWARD_MOST_UNTIDY + 7,
    STR_NEWS_ITEM_BEST_FOOD = STR_NEWS_ITEM_AWARD_MOST_UNTIDY + 8,
    STR_NEWS_ITEM_WORST_FOOD = STR_NEWS_ITEM_AWARD_MOST_UNTIDY + 9,
    STR_NEWS_ITEM_BEST_TOILETS = STR_NEWS_ITEM_AWARD_MOST_UNTIDY + 10,
    STR_NEWS_ITEM_MOST_DISAPPOINTING = STR_NEWS_ITEM_AWARD_MOST_UNTIDY + 11,
    STR_NEWS_ITEM_BEST_WATER_RIDES = STR_NEWS_ITEM_AWARD_MOST_UNTIDY + 12,
    STR_NEWS_ITEM_BEST_CUSTOM_DESIGNED_RIDES = STR_NEWS_ITEM_AWARD_MOST_UNTIDY + 13,
    STR_NEWS_ITEM_MOST_DAZZLING_RIDE_COLOURS = STR_NEWS_ITEM_AWARD_MOST_UNTIDY + 14,
    STR_NEWS_ITEM_MOST_CONFUSING_LAYOUT = STR_NEWS_ITEM_AWARD_MOST_UNTIDY + 15,
    STR_NEWS_ITEM_BEST_GENTLE_RIDES = STR_NEWS_ITEM_AWARD_MOST_UNTIDY + 16,
    // STR_2849    :New scenario installed successfully
    // STR_2850    :New track design installed successfully
    // STR_2851    :Scenario already installed
    // STR_2852    :Track design already installed
    STR_FORBIDDEN_BY_THE_LOCAL_AUTHORITY = 2853,
    STR_ENTRANCE_NOT_CONNECTED = 2854,
    STR_EXIT_NOT_CONNECTED = 2855,
    STR_CANT_START_MARKETING_CAMPAIGN = 2858,
    // STR_2859    :Another instance of OpenRCT2 is already running

    STR_STAFF_ERROR_CANT_NAME_STAFF_MEMBER = 2979,
    STR_TOO_MANY_BANNERS_IN_GAME = 2980,
    STR_NO_ENTRY = 2981,
    STR_ERR_CANT_SET_BANNER_TEXT = 2984,
    STR_FILE_CONTAINS_INVALID_DATA = 3011,
    STR_MUSIC_STYLE_DODGEMS_BEAT = 3012,
    STR_MUSIC_STYLE_FAIRGROUND_ORGAN = 3013,
    STR_MUSIC_STYLE_ROMAN_FANFARE = 3014,
    STR_MUSIC_STYLE_ORIENTAL = 3015,
    STR_MUSIC_STYLE_MARTIAN = 3016,
    STR_MUSIC_STYLE_JUNGLE_DRUMS = 3017,
    STR_MUSIC_STYLE_EGYPTIAN = 3018,
    STR_MUSIC_STYLE_TOYLAND = 3019,
    STR_MUSIC_STYLE_CIRCUS_SHOW = 3020,
    STR_MUSIC_STYLE_SPACE = 3021,
    STR_MUSIC_STYLE_HORROR = 3022,
    STR_MUSIC_STYLE_TECHNO = 3023,
    STR_MUSIC_STYLE_GENTLE = 3024,
    STR_MUSIC_STYLE_SUMMER = 3025,
    STR_MUSIC_STYLE_WATER = 3026,
    STR_MUSIC_STYLE_WILD_WEST = 3027,
    STR_MUSIC_STYLE_JURASSIC = 3028,
    STR_MUSIC_STYLE_ROCK = 3029,
    STR_MUSIC_STYLE_RAGTIME = 3030,
    STR_MUSIC_STYLE_FANTASY = 3031,
    STR_MUSIC_STYLE_ROCK_STYLE_2 = 3032,
    STR_MUSIC_STYLE_ICE = 3033,
    STR_MUSIC_STYLE_SNOW = 3034,
    STR_MUSIC_STYLE_CUSTOM_MUSIC_1 = 3035,
    STR_MUSIC_STYLE_CUSTOM_MUSIC_2 = 3036,
    STR_MUSIC_STYLE_MEDIEVAL = 3037,
    STR_MUSIC_STYLE_URBAN = 3038,
    STR_MUSIC_STYLE_ORGAN = 3039,
    STR_MUSIC_STYLE_MECHANICAL = 3040,
    STR_MUSIC_STYLE_MODERN = 3041,
    STR_MUSIC_STYLE_PIRATES = 3042,
    STR_MUSIC_STYLE_ROCK_STYLE_3 = 3043,
    STR_MUSIC_STYLE_CANDY_STYLE = 3044,
    // STR_THIS_RIDE_CANNOT_BE_MODIFIED = 3046, // Unused
    STR_LOCAL_AUTHORITY_FORBIDS_DEMOLITION_OR_MODIFICATIONS_TO_THIS_RIDE = 3047,
    STR_MARKETING_CAMPAIGNS_FORBIDDEN_BY_LOCAL_AUTHORITY = 3048,
    STR_GOLF_HOLE_A = 3049,
    STR_GOLF_HOLE_B = 3050,
    STR_GOLF_HOLE_C = 3051,
    STR_GOLF_HOLE_D = 3052,
    STR_GOLF_HOLE_E = 3053,
    STR_BEGINNER_PARKS = 3064,
    STR_CHALLENGING_PARKS = STR_BEGINNER_PARKS + 1,
    STR_EXPERT_PARKS = STR_BEGINNER_PARKS + 2,
    STR_REAL_PARKS = STR_BEGINNER_PARKS + 3,
    STR_OTHER_PARKS = STR_BEGINNER_PARKS + 4,
    STR_TOP_SECTION = 3069,
    STR_SLOPE_TO_LEVEL = 3070,
    STR_PARK_RATING_WARNING_4_WEEKS_REMAINING = 3073,
    STR_PARK_RATING_WARNING_3_WEEKS_REMAINING = 3074,
    STR_PARK_RATING_WARNING_2_WEEKS_REMAINING = 3075,
    STR_PARK_RATING_WARNING_1_WEEK_REMAINING = 3076,
    STR_PARK_HAS_BEEN_CLOSED_DOWN = 3077,
    STR_YOU_ARE_NOT_ALLOWED_TO_REMOVE_THIS_SECTION = 3091,
    STR_NOT_ALLOWED_TO_MODIFY_STATION = 3092,
    STR_SELECT_LIFT_HILL_CHAIN_SPEED_TIP = 3097,
    // STR_3098    :Can't change lift hill speed...
    STR_CANT_REPAINT_THIS = 3103,
    STR_ERR_UNABLE_TO_BUILD_THIS_ON_SLOPE = 3133,
    STR_CABLE_LIFT_UNABLE_TO_WORK_IN_THIS_OPERATING_MODE = 3139,
    STR_CABLE_LIFT_HILL_MUST_START_IMMEDIATELY_AFTER_STATION_OR_BLOCK_BRAKE = 6729,
    STR_MULTICIRCUIT_NOT_POSSIBLE_WITH_CABLE_LIFT_HILL = 3141,

    STR_SELECT_NUMBER_OF_CIRCUITS_TIP = 3160,

    STR_ERR_REASON_NOT_ENOUGH_MEMORY = 3162,

    STR_OBJECT_SELECTION_ERR_OBJECT_DATA_NOT_FOUND = 3169,
    STR_OBJECT_SELECTION_ERR_NOT_ENOUGH_SPACE_FOR_GRAPHICS = 3170,
    STR_OBJECT_SELECTION_ERR_TOO_MANY_OF_TYPE_SELECTED = 3171,
    STR_OBJECT_SELECTION_ERR_SHOULD_SELECT_X_FIRST = 3172,
    STR_OBJECT_SELECTION_ERR_CURRENTLY_IN_USE = 3173,
    STR_OBJECT_SELECTION_ERR_IS_REQUIRED_BY_ANOTHER = 3174,
    STR_OBJECT_SELECTION_ERR_ALWAYS_REQUIRED = 3175,
    STR_AT_LEAST_ONE_RIDE_OBJECT_MUST_BE_SELECTED = 3179,
    STR_INVALID_SELECTION_OF_OBJECTS = 3180,
    STR_PARK_ENTRANCE_TYPE_MUST_BE_SELECTED = 3182,
    STR_WATER_TYPE_MUST_BE_SELECTED = 3183,
    STR_OBJECT_SELECTION_RIDE_VEHICLES_ATTRACTIONS = 3184,
    STR_OBJECT_SELECTION_SMALL_SCENERY = 3185,
    STR_OBJECT_SELECTION_LARGE_SCENERY = 3186,
    STR_OBJECT_SELECTION_WALLS_FENCES = 3187,
    STR_OBJECT_SELECTION_PATH_SIGNS = 3188,
    STR_OBJECT_SELECTION_FOOTPATHS = 3189,
    STR_OBJECT_SELECTION_PATH_EXTRAS = 3190,
    STR_OBJECT_SELECTION_SCENERY_GROUPS = 3191,
    STR_OBJECT_SELECTION_PARK_ENTRANCE = 3192,
    STR_OBJECT_SELECTION_WATER = 3193,

    STR_CANT_DECREASE_MAP_SIZE_ANY_FURTHER = 3213,
    STR_CANT_INCREASE_MAP_SIZE_ANY_FURTHER = 3214,
    STR_TOO_CLOSE_TO_EDGE_OF_MAP = 3215,
    STR_ERR_TOO_MANY_PARK_ENTRANCES = 3227,
    STR_BLOCK_BRAKES_CANNOT_BE_USED_DIRECTLY_AFTER_STATION = 3229,
    STR_BLOCK_BRAKES_CANNOT_BE_USED_DIRECTLY_AFTER_EACH_OTHER = 3230,
    STR_BLOCK_BRAKES_CANNOT_BE_USED_DIRECTLY_AFTER_THE_TOP_OF_THIS_LIFT_HILL = 3231,
    STR_MAKE_PARK_NO_MONEY = 3238,
    STR_OBJECTIVE_PRESERVED_RIDES_TITLE = 3285,
    STR_NO_DETAILS_YET = 3317,

    STR_WINDOW_NO_IMAGE = 3326,
    STR_PEEP_SPAWNS_NOT_SET = 3327,
    STR_NO_PARK_ENTRANCES = 3329,
    STR_PARK_MUST_OWN_SOME_LAND = 3330,
    STR_PARK_ENTRANCE_PATH_INCOMPLETE_OR_COMPLEX = 3331,
    STR_PARK_ENTRANCE_WRONG_DIRECTION_OR_NO_PATH = 3332,

    STR_CANT_SAVE_TRACK_DESIGN = 3346,
    STR_TRACK_TOO_LARGE_OR_TOO_MUCH_SCENERY = 3347,
    STR_WARNING = 3360,
    STR_TOO_MANY_TRACK_DESIGNS_OF_THIS_TYPE = 3361,

    STR_SAVE_TRACK_SCENERY_UNABLE_TO_SELECT_ADDITIONAL_ITEM_OF_SCENERY = 3389,
    STR_SAVE_TRACK_SCENERY_TOO_MANY_ITEMS_SELECTED = 3390,

    STR_UNABLE_TO_REMOVE_ALL_SCENERY_FROM_HERE = 3438,
    STR_SET_PATROL_AREA = 3445,

    // 3447--5119 reserved for user strings.

    STR_CHEAT_RENEW_RIDES = 5123,

    STR_CHEAT_MAKE_DESTRUCTABLE = 5125,
    STR_CHEAT_FIX_ALL_RIDES = 5132,
    STR_CHEAT_UNLOCK_OPERATING_LIMITS = 5137,
    STR_CHEAT_DISABLE_BRAKES_FAILURE = 5140,
    STR_CHEAT_DISABLE_BREAKDOWNS = 5141,
    STR_LOCALE_THOUSANDS_SEPARATOR = 5151,
    STR_LOCALE_DECIMAL_POINT = 5152,
    STR_HARDWARE_DISPLAY = 5154, // Unused
    STR_CHEAT_UNLOCK_PRICES = 5157,
    STR_DATE_FORMAT_MDY = 5160,
    STR_DATE_FORMAT_DAY_MONTH_YEAR = 5162,
    STR_DATE_FORMAT_MONTH_DAY_YEAR = 5163,
    STR_CHEAT_TITLE = 5217,
    STR_OBJECT_FILTER_WW = 5262,
    STR_OBJECT_FILTER_TT = 5263,
    STR_OBJECT_FILTER_CUSTOM = 5264,
    STR_OBJECT_SEARCH = 5275,      // Unused (commented out)
    STR_OBJECT_SEARCH_DESC = 5276, // Unused (commented out)
    STR_CHEAT_SANDBOX_MODE = 5278,
    STR_CHEAT_SANDBOX_MODE_DISABLE = 5279,
    STR_CHEAT_SANDBOX_MODE_TIP = 5280,

    STR_CHEAT_CLEAR_LOAN_TIP = 5301,
    STR_CHEAT_CLEAR_LOAN = 5302,
    STR_CHEAT_BUILD_IN_PAUSE_MODE = 5303,
    STR_TITLE_SEQUENCE = 5304,
    STR_TITLE_SEQUENCE_RCT1 = 5305,
    STR_TITLE_SEQUENCE_RCT1_AA = 5306,
    STR_TITLE_SEQUENCE_RCT1_AA_LL = 5307,
    STR_TITLE_SEQUENCE_RCT2 = 5308,
    STR_TITLE_SEQUENCE_OPENRCT2 = 5309,

    STR_CHEAT_REMOVE_ALL_GUESTS = 5359,
    STR_CHEAT_GIVE_ALL_GUESTS = 5361,
    STR_CHEAT_STAFF_SPEED = 5365,
    STR_CHEAT_RESET_CRASH_STATUS = 5368,
    STR_UP = 5375,
    STR_DOWN = 5376,
    STR_ERROR_EXISTING_NAME = 5404,

    STR_FORCE_PARK_RATING = 5442,
    STR_DISABLE_CLEARANCE_CHECKS = 5456,
    STR_DISABLE_SUPPORT_LIMITS = 5457,
    STR_CHEAT_SET_GUESTS_PARAMETERS = 5461,
    STR_CHEAT_HAVE_FUN = 5463,
    STR_ALT_PLUS = 5467,

    STR_PLAYER_LIST = 5495, // Unused
    STR_SERVER_LIST = 5498,
    STR_MULTIPLAYER = 5502,
    STR_UNABLE_TO_CONNECT_TO_SERVER = 5505,
    STR_CHEAT_IGNORE_INTENSITY = 5506,
    STR_OPTIONS_SOUND_VALUE_DEFAULT = 5510,
    STR_OPTIONS_SOUND_VALUE_UNKNOWN = 5511,
    STR_SHORTCUT_QUICK_SAVE_GAME = 5513,
    STR_CHEAT_DISABLE_VANDALISM = 5514,
    STR_CHEAT_SHOW_ALL_OPERATING_MODES = 5548,
    STR_DATE_FORMAT_YEAR_MONTH_DAY = 5549,
    STR_DATE_FORMAT_YMD = 5550,
    STR_DATE_FORMAT_YEAR_DAY_MONTH = 5551,
    STR_DATE_FORMAT_YDM = 5552,
    STR_CHEAT_SHOW_VEHICLES_FROM_OTHER_TRACK_TYPES = 5555,
    STR_CHEAT_10_MINUTE_INSPECTIONS = 5559,

    STR_WON = 5577,
    STR_ROUBLE = 5578,
    STR_CZECH_KORUNA = 5580,
    STR_UNIT_SUFFIX_METRES_PER_SECOND = 5583,
    STR_TILE_INSPECTOR_FLAG_BROKEN_SHORT = 5613,
    STR_TILE_INSPECTOR_FLAG_BROKEN = 5614,
    STR_SCENARIO_CATEGORY_RCT1 = 5619,
    STR_SCENARIO_CATEGORY_RCT1_AA = 5620,
    STR_SCENARIO_CATEGORY_RCT1_LL = 5621,
    STR_DLC_PARKS = 5631,
    STR_BUILD_YOUR_OWN_PARKS = 5632,
    STR_CMD_PLUS = 5633,
    STR_OPTION_PLUS = 5634,
    STR_CANT_DO_THIS = 5637,
    STR_PERMISSION_DENIED = 5638,
    STR_ACTION_CHAT = 5645,
    STR_ACTION_TERRAFORM = 5646,
    STR_ACTION_TOGGLE_PAUSE = 5647,
    STR_ACTION_SET_WATER_LEVEL = 5648,
    STR_ACTION_CREATE_RIDE = 5649,
    STR_ACTION_REMOVE_RIDE = 5650,
    STR_ACTION_BUILD_RIDE = 5651,
    STR_ACTION_RIDE_PROPERTIES = 5652,
    STR_ACTION_SCENERY = 5653,
    STR_ACTION_PATH = 5654,
    STR_ACTION_GUEST = 5655,
    STR_ACTION_STAFF = 5656,
    STR_ACTION_PARK_PROPERTIES = 5657,
    STR_ACTION_PARK_FUNDING = 5658,
    STR_ACTION_KICK_PLAYER = 5659,
    STR_ACTION_MODIFY_GROUPS = 5660,
    STR_ACTION_SET_PLAYER_GROUP = 5661,
    STR_ACTION_CLEAR_LANDSCAPE = 5663,
    STR_ACTION_CHEAT = 5664,
    STR_ACTION_TOGGLE_SCENERY_CLUSTER = 5665,
    STR_ACTION_PASSWORDLESS_LOGIN = 5666,
    // Empty block
    STR_CANT_KICK_THE_HOST = 5703,
    STR_CANT_SET_TO_THIS_GROUP = 5705,
    STR_CANT_REMOVE_GROUP_THAT_PLAYERS_BELONG_TO = 5706,
    STR_THIS_GROUP_CANNOT_BE_MODIFIED = 5707,
    STR_CANT_CHANGE_GROUP_THAT_THE_HOST_BELONGS_TO = 5708,
    STR_CANT_MODIFY_PERMISSION_THAT_YOU_DO_NOT_HAVE_YOURSELF = 5712,
    // STR_5713    :Kick Player (unused)
    STR_NOT_ALLOWED_IN_MULTIPLAYER = 5716, // Unused
    STR_CHANGE_WEATHER = 5725,
    STR_CLOSED_WITH_PERSON = 5737,
    STR_CLOSED_WITH_PEOPLE = 5738,
    STR_CHEAT_NEVERENDING_MARKETING = 5740,
    STR_MULTIPLAYER_AUTHENTICATING = 5742,
    STR_MULTIPLAYER_CONNECTING = 5743,
    STR_MULTIPLAYER_RESOLVING = 5744,
    STR_MULTIPLAYER_DESYNC = 5745,
    STR_MULTIPLAYER_DISCONNECTED_NO_REASON = 5746,
    STR_MULTIPLAYER_DISCONNECTED_WITH_REASON = 5747,
    STR_MULTIPLAYER_KICKED = 5748,
    STR_MULTIPLAYER_KICKED_REASON = 5749,
    STR_MULTIPLAYER_CONNECTION_CLOSED = 5750,
    STR_MULTIPLAYER_NO_DATA = 5751,
    STR_MULTIPLAYER_PLAYER_HAS_DISCONNECTED_NO_REASON = 5752,
    STR_MULTIPLAYER_PLAYER_HAS_DISCONNECTED_WITH_REASON = 5753,
    STR_MULTIPLAYER_BAD_PLAYER_NAME = 5754,
    STR_MULTIPLAYER_INCORRECT_SOFTWARE_VERSION = 5755,
    STR_MULTIPLAYER_BAD_PASSWORD = 5756,
    STR_MULTIPLAYER_SERVER_FULL = 5757,
    STR_MULTIPLAYER_PLAYER_HAS_JOINED_THE_GAME = 5758,
    STR_MULTIPLAYER_DOWNLOADING_MAP = 5759,
    STR_HONG_KONG_DOLLAR = 5760,
    STR_NEW_TAIWAN_DOLLAR = 5761,
    STR_CHINESE_YUAN = 5762,
    STR_ALL_FILES = 5763,
    STR_INVALID_RIDE_TYPE = 5764,
    STR_CANT_EDIT_INVALID_RIDE_TYPE = 5765,
    STR_HUNGARIAN_FORINT = 5766,
    STR_POLISH_ZLOTY = 7012,
    STR_MULTIPLAYER_CONNECTED_CHAT_HINT = 5782,
    STR_CANT_RENAME_GROUP = 5785,
    STR_INVALID_GROUP_NAME = 5786,
    STR_CHEAT_UNLOCK_PRICES_TIP = 5790,
    STR_CHEAT_DISABLE_LITTERING = 5801,
    STR_CHEAT_DISABLE_TRAIN_LENGTH_LIMIT = 5810,
    STR_HANDYMEN_MOW_BY_DEFAULT_TIP = 5850,
    STR_HARDWARE_DISPLAY_TIP = 5858, // Unused
    STR_SHORTCUT_PAINT_ORIGINAL = 5860,
    STR_MULTIPLAYER_VERIFICATION_FAILURE = 5861,
    STR_MULTIPLAYER_UNKNOWN_KEY_DISALLOWED = 5864,
    STR_CHEAT_DISABLE_PLANT_AGING = 5871,
    STR_CHEAT_ENABLE_CHAIN_LIFT_ON_ALL_TRACK = 5873,
    STR_DRAWING_ENGINE_SOFTWARE = 5877,
    STR_DRAWING_ENGINE_SOFTWARE_WITH_HARDWARE_DISPLAY = 5878,
    STR_DRAWING_ENGINE_OPENGL = 5879,
    STR_CUSTOM_CURRENCY = 5882,
    STR_DEBUG_PAINT_USE_OLD_DRAWING = 5900,
    STR_CHEAT_RESET_DATE = 5904,
    STR_CHEAT_ALLOW_ARBITRARY_RIDE_TYPE_CHANGES = 5908,
    STR_APPLY = 5910,
    STR_RIDE_DESCRIPTION_UNKNOWN = 5914,
    STR_MULTIPLAYER_DEFAULT_NAME = 5915,
    STR_TILE_INSPECTOR_GROUPBOX_LARGE_SCENERY_INFO = 5930,
    STR_TILE_INSPECTOR_CLAMP_TO_NEXT = 5973,
    STR_TILE_INSPECTOR_CLAMP_TO_NEXT_TIP = 5974,
    STR_NO_LAND_OR_CONSTRUCTION_RIGHTS_FOR_SALE_TIP = 5990,
    STR_CANT_PASTE = 5991,
    STR_TILE_ELEMENT_LIMIT_REACHED = 5992,
    STR_BOOSTER = 5995,

    STR_SET_MONEY = 5999,

    STR_VIEW_CLIPPING_TITLE = 6004,
    STR_ACTION_MODIFY_TILE = 6016,
    STR_NETWORK_ACTION_RATE_LIMIT_MESSAGE = 6017,

    STR_ACTION_EDIT_SCENARIO_OPTIONS = 6040,

    STR_HEIGHT_MAP_ERROR = 6048,
    STR_ERROR_READING_PNG = 6049,
    STR_ERROR_READING_BITMAP = 6050,

    STR_ERROR_HEIGHT_MAP_TOO_BIG = 6052,
    STR_ERROR_CANNOT_NORMALIZE = 6053,
    STR_ERROR_24_BIT_BITMAP = 6054,

    STR_MONEY_EFFECT_RECEIVE_HIGHP = 6062,
    STR_MONEY_EFFECT_SPEND_HIGHP = 6063,

    STR_CHEAT_OWN_ALL_LAND = 6064,

    STR_LOG_SERVER_STARTED = 6067,
    STR_LOG_SERVER_STOPPED = 6068,
    STR_LOG_PLAYER_KICKED = 6069,
    STR_LOG_SET_PLAYER_GROUP = 6070,
    STR_LOG_ADD_PLAYER_GROUP = 6071,
    STR_LOG_REMOVE_PLAYER_GROUP = 6072,
    STR_LOG_EDIT_PLAYER_GROUP_PERMISSIONS = 6073,
    STR_LOG_EDIT_PLAYER_GROUP_NAME = 6074,
    STR_LOG_EDIT_DEFAULT_PLAYER_GROUP = 6075,
    STR_LOG_CHEAT_USED = 6076,
    STR_LOG_CHEAT_ADD_MONEY = 6077,
    STR_LOG_CREATE_RIDE = 6078,
    STR_LOG_DEMOLISH_RIDE = 6079,
    STR_LOG_RIDE_APPEARANCE = 6080,
    STR_LOG_RIDE_STATUS_CLOSED = 6081,
    STR_LOG_RIDE_STATUS_OPEN = 6082,
    STR_LOG_RIDE_STATUS_TESTING = 6083,
    STR_LOG_RIDE_VEHICLES = 6084,
    STR_LOG_RIDE_SETTINGS = 6085,
    STR_LOG_RIDE_NAME = 6086,
    STR_LOG_RIDE_PRICE = 6087,
    STR_LOG_RIDE_SECONDARY_PRICE = 6088,
    STR_LOG_PARK_NAME = 6089,
    STR_LOG_PARK_CLOSED = 6090,
    STR_LOG_PARK_OPEN = 6091,
    STR_LOG_PARK_ENTRANCE_FEE = 6092,
    STR_LOG_PLACE_SCENERY = 6093,
    STR_LOG_REMOVE_SCENERY = 6094,
    STR_LOG_EDIT_SCENERY = 6095,
    STR_LOG_SET_SIGN_NAME = 6096,
    STR_LOG_PLACE_TRACK = 6097,
    STR_LOG_REMOVE_TRACK = 6098,
    STR_LOG_CLIENT_STARTED = 6099,
    STR_LOG_CLIENT_STOPPED = 6100,
    STR_CHEAT_DISABLE_RIDE_VALUE_AGING = 6101,

    STR_NEWS_ITEM_RESEARCH_NEW_VEHICLE_AVAILABLE = 6120,

    STR_NOT_ENOUGH_ROLLER_COASTERS = 6122,

    STR_UNKNOWN_OBJECT_TYPE = 6126,

    STR_CHEAT_IGNORE_RESEARCH_STATUS = 6132,

    STR_MULTIPLAYER_CLIENT_INVALID_REQUEST = 6135,
    STR_MULTIPLAYER_SERVER_INVALID_REQUEST = 6136,

    STR_CHEAT_ENABLE_ALL_DRAWABLE_TRACK_PIECES = 6146,

    STR_SERVER_LIST_NO_CONNECTION = 6149,
    STR_SERVER_LIST_INVALID_RESPONSE_JSON_NUMBER = 6150,
    STR_SERVER_LIST_MASTER_SERVER_FAILED = 6151,
    STR_SERVER_LIST_INVALID_RESPONSE_JSON_ARRAY = 6152,

    STR_ADMIN_NOT_RECOMMENDED = 6154,

    STR_ERROR_RESERVED_NAME = 6156,

    STR_CONSOLE = 6157,

    STR_LITTER_VOMIT = 6188,
    STR_DUCK = 6189,

    STR_OBJECT_FILTER_OPENRCT2_OFFICIAL = 6218,

    STR_ERR_CANT_PLACE_PEEP_SPAWN_HERE = 6222,
    STR_ERR_MUST_BE_OUTSIDE_PARK_BOUNDARIES = 6223,
    STR_LOG_PLACE_PEEP_SPAWN = 6224,

    STR_NOT_SUPPPORTED_IN_OPENGL = 6225,

    STR_INVENTIONS_LIST_RIDE_AND_VEHICLE_NAME = 6230,
    STR_INVENTIONS_LIST_RIDE_AND_VEHICLE_NAME_DRAG = 6231,

    STR_CANT_REFURBISH_RIDE = 6244,
    STR_CANT_REFURBISH_NOT_NEEDED = 6245,
    STR_RIDE_NOT_YET_EMPTY = 6251,

    STR_INVALID_URL = 6255,

    STR_INVALID_CLIMATE_ID = 6269,

    STR_OBJECT_SELECTION_TERRAIN_SURFACES = 6270,
    STR_OBJECT_SELECTION_TERRAIN_EDGES = 6271,
    STR_OBJECT_SELECTION_STATIONS = 6272,
    STR_OBJECT_SELECTION_MUSIC = 6273,
    STR_CANT_SET_COLOUR_SCHEME = 6274,

    STR_GUESTS_GETTING_STUCK_ON_RIDE = 6276,

    STR_SIZE_BYTE = 6293,
    STR_SIZE_KILOBYTE = 6294,
    STR_SIZE_MEGABYTE = 6295,
    STR_SIZE_GIGABYTE = 6296,
    STR_SIZE_TERABYTE = 6297,

    STR_NETWORK_SPEED_SEC = 6298,

    STR_DESYNC_REPORT = 6318,

    STR_SIMULATING = 6323,
    STR_CANT_SIMULATE = 6326,

    STR_STRING_STRINGID = 6329,

    STR_CANNOT_BUILD_PATH_ADDITIONS_ON_LEVEL_CROSSINGS = 6347,
    STR_REMOVE_LEVEL_CROSSING_FIRST = 6348,

    STR_OPTIONS_RANDOM_TITLE_SEQUENCE = 6349,

    STR_X_PERSON_DIED_ON_X = 6364,

    STR_WINE_NOT_RECOMMENDED = 6368,
    STR_CHEAT_ALLOW_TRACK_PLACE_INVALID_HEIGHTS = 6369,

    STR_UNKNOWN_RIDE = 6375,

    STR_MULTIPLAYER_RECEIVING_OBJECTS_LIST = 6378,
    STR_MULTIPLAYER_RECEIVING_SCRIPTS = 7009,

    STR_MULTIPLAYER_RECEIVED_INVALID_DATA = 6379,

    STR_CANT_LOWER_ELEMENT_HERE = 6387,
    STR_CANT_RAISE_ELEMENT_HERE = 6388,
    STR_NO_CLEARANCE = 6389,

    STR_NEEDS_RCT2_FILES = 6390,
    STR_PICK_RCT2_DIR = 6391,
    STR_COULD_NOT_FIND_AT_PATH = 6392,

    STR_FILE_CONTAINS_UNSUPPORTED_RIDE_TYPES = 6398,

    STR_NEEDS_RCT2_FILES_MANUAL = 6399,

    STR_OWN_ON_GOG = 6400,
    STR_INSTALLED_ON_HDD = 6401,
    STR_OPENRCT2_SETUP = 6402,
    STR_WHICH_APPLIES_BEST = 6403,
    STR_PLEASE_SELECT_GOG_INSTALLER = 6404,
    STR_SELECT_GOG_INSTALLER = 6405,
    STR_GOG_INSTALLER = 6406,
    STR_THIS_WILL_TAKE_A_FEW_MINUTES = 6407,
    STR_INSTALL_INNOEXTRACT = 6408,
    STR_NOT_THE_GOG_INSTALLER = 6409,
    STR_OWN_ON_STEAM = 7014,
    STR_PLEASE_CLOSE_STEAM = 7015,
    STR_WAIT_FOR_STEAM_DOWNLOAD = 7016,

    STR_TILE_INSPECTOR_TOGGLE_INVISIBILITY_TIP = 6436,

    STR_VIEWPORT_TRANSPARENT_WATER = 6440,

    STR_AT_LEAST_ONE_FOOTPATH_NON_QUEUE_SURFACE_OBJECT_MUST_BE_SELECTED = 6441,
    STR_AT_LEAST_ONE_FOOTPATH_QUEUE_SURFACE_OBJECT_MUST_BE_SELECTED = 6442,
    STR_AT_LEAST_ONE_FOOTPATH_RAILING_OBJECT_MUST_BE_SELECTED = 6443,
    STR_OBJECT_SELECTION_FOOTPATH_SURFACES = 6444,
    STR_OBJECT_SELECTION_FOOTPATH_RAILINGS = 6445,

    STR_UNSUPPORTED_OBJECT_FORMAT = 6448,

    STR_CANT_RENAME_BANNER = 6454,
    STR_CANT_RENAME_SIGN = 6455,

    STR_TRANSPARENCY_OPTIONS_TITLE = 6482,

    STR_PEEPS_COMPLAINING_ABOUT_QUEUE_LENGTH_WARNING = 6488,

    STR_ERROR_PARK_VERSION_TITLE = 6489,
    STR_WARNING_PARK_VERSION_TITLE = 6490,
    STR_ERROR_PARK_VERSION_TOO_NEW_MESSAGE = 6491,
    STR_ERROR_PARK_VERSION_TOO_OLD_MESSAGE = 6492,
    STR_WARNING_PARK_VERSION_MESSAGE = 6493,

    STR_VEHICLE_UNSUPPORTED_TD6 = 6499,
    STR_TRACK_ELEM_UNSUPPORTED_TD6 = 6500,

    STR_AT_LEAST_ONE_STATION_OBJECT_MUST_BE_SELECTED = 6503,
    STR_AT_LEAST_ONE_TERRAIN_SURFACE_OBJECT_MUST_BE_SELECTED = 6504,
    STR_AT_LEAST_ONE_TERRAIN_EDGE_OBJECT_MUST_BE_SELECTED = 6505,

    STR_LARGE_HALF_CORKSCREW_LEFT = 6506,
    STR_LARGE_HALF_CORKSCREW_RIGHT = 6507,
    STR_MEDIUM_HALF_LOOP_LEFT = 6508,
    STR_MEDIUM_HALF_LOOP_RIGHT = 6509,
    STR_ZERO_G_ROLL_LEFT = 6510,
    STR_ZERO_G_ROLL_RIGHT = 6511,
    STR_LARGE_ZERO_G_ROLL_LEFT = 6512,
    STR_LARGE_ZERO_G_ROLL_RIGHT = 6513,

    STR_INVALID_HEIGHT = 6514,

    STR_PARK_USES_FALLBACK_IMAGES_WARNING = 6517,

    STR_COMPETITIONS = 6527,

    STR_INVALID_TRACK_PARAMETERS = 6528,
    STR_INVALID_COLOUR_SCHEME_PARAMETER = 6529,

    STR_UCES_TM = 6531,
    STR_UCES_KD = 6532,

    STR_ERROR_PARK_VERSION_TOO_NEW_MESSAGE_2 = 6536,

    STR_CHEAT_ALLOW_PATH_AS_QUEUE = 6537,

    STR_LOAN_CANT_BE_NEGATIVE = 6544,

    STR_OBJECT_SELECTION_ERR_COMPAT_OBJECT = 6549,

    STR_CHEAT_ALLOW_SPECIAL_COLOUR_SCHEMES = 6575,

    STR_RIDE_CONSTRUCTION_BLOCK_BRAKE_SPEED = 6577,
    STR_RIDE_CONSTRUCTION_BLOCK_BRAKE_SPEED_LIMIT_TIP = 6578,

    STR_TRACK_DESIGN_BLOCK_BRAKE_SPEED_RESET = 6579,

    STR_RIDE_SET_VEHICLE_REVERSED_FAIL = 6585,

    STR_CANT_FIRE_STAFF_FIXING = 6591,
    STR_CANT_FIRE_STAFF_INSPECTING = 6592,

    STR_CHEAT_REMOVE_PARK_FENCES = 6593,

    STR_ERR_INVALID_PARAMETER = 6597,
    STR_ERR_VALUE_OUT_OF_RANGE = 6598,
    STR_ERR_GHOST_ELEMENT_NOT_FOUND = 6599,
    STR_ERR_BALLOON_NOT_FOUND = 6600,
    STR_ERR_STAFF_NOT_FOUND = 6601,
    STR_ERR_RIDE_NOT_FOUND = 6602,
    STR_ERR_RIDE_OBJECT_ENTRY_NOT_FOUND = 6603,
    STR_ERR_PLAYER_NOT_FOUND = 6604,
    STR_ERR_ENTRANCE_ELEMENT_NOT_FOUND = 6605,
    STR_ERR_SURFACE_ELEMENT_NOT_FOUND = 6606,
    STR_ERR_TILE_ELEMENT_NOT_FOUND = 6607,
    STR_ERR_TRACK_ELEMENT_NOT_FOUND = 6608,
    STR_ERR_TRACK_BLOCK_NOT_FOUND = 6609,
    STR_ERR_PATH_ELEMENT_NOT_FOUND = 6610,
    STR_ERR_WALL_ELEMENT_NOT_FOUND = 6611,
    STR_ERR_BANNER_ELEMENT_NOT_FOUND = 6612,
    STR_ERR_CANT_CHANGE_PARK_ENTRANCE_FEE = 6614,
    STR_ERR_TRACK_ON_THIS_TILE_NEEDS_WATER = 6615,
    STR_ERR_ACTION_INVALID_FOR_THAT_STAFF_TYPE = 6616,
    STR_ERR_CANT_SWAP_TILE_ELEMENT_WITH_ITSELF = 6617,

    STR_CANT_RESTRICT_OBJECT = 6618,
    STR_OBJECT_TYPE_CANNOT_BE_RESTRICTED = 6619,
    STR_OBJECT_NOT_FOUND = 6620,

    STR_ERR_INVALID_COLOUR = 6625,

    STR_SPEED_TOO_HIGH = 6627,

    STR_CAN_ONLY_BE_PLACED_ON_PATH_EDGES = 6628,

    STR_LOADING_GENERIC = 6631,
    STR_CHECKING_OBJECT_FILES = 6632,
    STR_CHECKING_SCENARIO_FILES = 6633,
    STR_CHECKING_TRACK_DESIGN_FILES = 6634,
    STR_CHECKING_ASSET_PACKS = 6635,
    STR_CHECKING_TITLE_SEQUENCES = 6636,
    STR_LOADING_TITLE_SEQUENCE = 6637,

    STR_THEME_LOADING_WINDOW = 6641,
    STR_STRING_M_OF_N = 6642,
    STR_STRING_M_OF_N_KIB = 6643,

    STR_LOADING_PLUGIN_ENGINE = 6648,
    STR_LOADING_SCENARIO = 6649,
    STR_LOADING_SAVED_GAME = 6650,
    STR_STRING_M_PERCENT = 6651,

    STR_CHEAT_IGNORE_PRICE = 6659,

    STR_DATE_FORMAT_MY_SENTENCE = 6674,

    STR_OBJECT_SELECTION_PEEP_NAMES = 6675,
    STR_AT_LEAST_ONE_PEEP_NAMES_OBJECT_MUST_BE_SELECTED = 6676,

    STR_OBJECT_SELECTION_PEEP_ANIMATIONS = 6718,
    STR_AT_LEAST_ONE_GUEST_PEEP_ANIMATIONS_OBJECT_MUST_BE_SELECTED = 6719,
    STR_AT_LEAST_ONE_HANDYMAN_PEEP_ANIMATIONS_OBJECT_MUST_BE_SELECTED = 6720,
    STR_AT_LEAST_ONE_MECHANIC_PEEP_ANIMATIONS_OBJECT_MUST_BE_SELECTED = 6721,
    STR_AT_LEAST_ONE_SECURITY_PEEP_ANIMATIONS_OBJECT_MUST_BE_SELECTED = 6722,
    STR_AT_LEAST_ONE_ENTERTAINER_PEEP_ANIMATIONS_OBJECT_MUST_BE_SELECTED = 6723,
    STR_OBJECT_SELECTION_SCENARIO_TEXTS = 6724,

    STR_DIVE_LOOP_LEFT = 6727,
    STR_DIVE_LOOP_RIGHT = 6728,

    STR_OBJECT_SELECTION_CLIMATE = 6743,
    STR_CLIMATE_WEATHER_PERCENT = 6744,

    // Gamepad settings
    STR_GAMEPAD_GROUP = 6785,
    STR_GAMEPAD_DEADZONE_LABEL = 6786,
    STR_GAMEPAD_DEADZONE_TIP = 6787,
    STR_GAMEPAD_SENSITIVITY_LABEL = 6788,
    STR_GAMEPAD_SENSITIVITY_TIP = 6789,
    STR_GAMEPAD_DEADZONE_TOOLTIP_FORMAT = 6790,
    STR_GAMEPAD_SENSITIVITY_TOOLTIP_FORMAT = 6791,

    // Window: Error
    STR_AUDIO_FILE_TRUNCATED = 7003,

    STR_REPLAY_FILE_NOT_FOUND = 7010,
    STR_REPLAY_NOT_STARTED = 7011,

    STR_ACTION_PATH_DRAG_AREA = 7013,

    // Have to include resource strings (from scenarios and objects) for the time being now that language is partially working
    /* MAX_STR_COUNT = 32768 */ // MAX_STR_COUNT - upper limit for number of strings, not the current count strings
};
