/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.i18n.client.LocaleInfo;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.CellPanel;
import com.google.gwt.user.client.ui.HasAlignment;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;

public class DockPanel
extends CellPanel
implements HasAlignment {
    public static final DockLayoutConstant CENTER = new DockLayoutConstant();
    public static final DockLayoutConstant LINE_START = new DockLayoutConstant();
    public static final DockLayoutConstant LINE_END = new DockLayoutConstant();
    public static final DockLayoutConstant EAST = new DockLayoutConstant();
    public static final DockLayoutConstant NORTH = new DockLayoutConstant();
    public static final DockLayoutConstant SOUTH = new DockLayoutConstant();
    public static final DockLayoutConstant WEST = new DockLayoutConstant();
    private HasHorizontalAlignment.HorizontalAlignmentConstant horzAlign = ALIGN_DEFAULT;
    private HasVerticalAlignment.VerticalAlignmentConstant vertAlign = ALIGN_TOP;
    private Widget center;

    private static String generateDebugId(DockLayoutConstant direction, int count) {
        if (direction == NORTH) {
            return "north" + count;
        }
        if (direction == SOUTH) {
            return "south" + count;
        }
        if (direction == WEST) {
            return "west" + count;
        }
        if (direction == EAST) {
            return "east" + count;
        }
        if (direction == LINE_START) {
            return "linestart" + count;
        }
        if (direction == LINE_END) {
            return "lineend" + count;
        }
        return "center";
    }

    public DockPanel() {
        DOM.setElementPropertyInt(this.getTable(), "cellSpacing", 0);
        DOM.setElementPropertyInt(this.getTable(), "cellPadding", 0);
    }

    public void add(Widget widget, DockLayoutConstant direction) {
        if (direction == CENTER) {
            if (widget == this.center) {
                return;
            }
            if (this.center != null) {
                throw new IllegalArgumentException("Only one CENTER widget may be added");
            }
        }
        widget.removeFromParent();
        this.getChildren().add(widget);
        if (direction == CENTER) {
            this.center = widget;
        }
        LayoutData layout = new LayoutData(direction);
        widget.setLayoutData(layout);
        this.setCellHorizontalAlignment(widget, this.horzAlign);
        this.setCellVerticalAlignment(widget, this.vertAlign);
        this.realizeTable();
        this.adopt(widget);
    }

    public void add(IsWidget widget, DockLayoutConstant direction) {
        this.add(widget.asWidget(), direction);
    }

    public HasHorizontalAlignment.HorizontalAlignmentConstant getHorizontalAlignment() {
        return this.horzAlign;
    }

    public HasVerticalAlignment.VerticalAlignmentConstant getVerticalAlignment() {
        return this.vertAlign;
    }

    public DockLayoutConstant getWidgetDirection(Widget w) {
        if (w.getParent() != this) {
            return null;
        }
        return ((LayoutData)w.getLayoutData()).direction;
    }

    public boolean remove(Widget w) {
        boolean removed = super.remove(w);
        if (removed) {
            if (w == this.center) {
                this.center = null;
            }
            this.realizeTable();
        }
        return removed;
    }

    public void setCellHeight(Widget w, String height) {
        LayoutData data = (LayoutData)w.getLayoutData();
        data.height = height;
        if (data.td != null) {
            DOM.setStyleAttribute(data.td, "height", data.height);
        }
    }

    public void setCellHorizontalAlignment(Widget w, HasHorizontalAlignment.HorizontalAlignmentConstant align) {
        LayoutData data = (LayoutData)w.getLayoutData();
        data.hAlign = align.getTextAlignString();
        if (data.td != null) {
            this.setCellHorizontalAlignment(data.td, align);
        }
    }

    public void setCellVerticalAlignment(Widget w, HasVerticalAlignment.VerticalAlignmentConstant align) {
        LayoutData data = (LayoutData)w.getLayoutData();
        data.vAlign = align.getVerticalAlignString();
        if (data.td != null) {
            this.setCellVerticalAlignment(data.td, align);
        }
    }

    public void setCellWidth(Widget w, String width) {
        LayoutData data = (LayoutData)w.getLayoutData();
        data.width = width;
        if (data.td != null) {
            DOM.setStyleAttribute(data.td, "width", data.width);
        }
    }

    public void setHorizontalAlignment(HasHorizontalAlignment.HorizontalAlignmentConstant align) {
        this.horzAlign = align;
    }

    public void setVerticalAlignment(HasVerticalAlignment.VerticalAlignmentConstant align) {
        this.vertAlign = align;
    }

    protected void onEnsureDebugId(String baseID) {
        super.onEnsureDebugId(baseID);
        HashMap<DockLayoutConstant, Integer> dirCount = new HashMap<DockLayoutConstant, Integer>();
        for (Widget child : this.getChildren()) {
            DockLayoutConstant dir = ((LayoutData)child.getLayoutData()).direction;
            Integer countObj = (Integer)dirCount.get(dir);
            int count = countObj == null ? 1 : countObj;
            String debugID = DockPanel.generateDebugId(dir, count);
            DockPanel.ensureDebugId(DOM.getParent(child.getElement()), baseID, debugID);
            dirCount.put(dir, count + 1);
        }
    }

    private void realizeTable() {
        Element bodyElem = this.getBody();
        while (DOM.getChildCount(bodyElem) > 0) {
            DOM.removeChild(bodyElem, DOM.getChild(bodyElem, 0));
        }
        int rowCount = 1;
        int colCount = 1;
        for (Widget child : this.getChildren()) {
            DockLayoutConstant dir = ((LayoutData)child.getLayoutData()).direction;
            if (dir == NORTH || dir == SOUTH) {
                ++rowCount;
                continue;
            }
            if (dir != EAST && dir != WEST && dir != LINE_START && dir != LINE_END) continue;
            ++colCount;
        }
        TmpRow[] rows = new TmpRow[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            rows[i] = new TmpRow();
            rows[i].tr = DOM.createTR();
            DOM.appendChild(bodyElem, rows[i].tr);
        }
        int logicalLeftCol = 0;
        int logicalRightCol = colCount - 1;
        int northRow = 0;
        int southRow = rowCount - 1;
        Element centerTd = null;
        for (Widget child : this.getChildren()) {
            TmpRow row;
            Element td;
            LayoutData layout = (LayoutData)child.getLayoutData();
            layout.td = td = DOM.createTD();
            DOM.setElementProperty(layout.td, "align", layout.hAlign);
            DOM.setStyleAttribute(layout.td, "verticalAlign", layout.vAlign);
            DOM.setElementProperty(layout.td, "width", layout.width);
            DOM.setElementProperty(layout.td, "height", layout.height);
            if (layout.direction == NORTH) {
                DOM.insertChild(rows[northRow].tr, td, rows[northRow].center);
                DOM.appendChild(td, child.getElement());
                DOM.setElementPropertyInt(td, "colSpan", logicalRightCol - logicalLeftCol + 1);
                ++northRow;
                continue;
            }
            if (layout.direction == SOUTH) {
                DOM.insertChild(rows[southRow].tr, td, rows[southRow].center);
                DOM.appendChild(td, child.getElement());
                DOM.setElementPropertyInt(td, "colSpan", logicalRightCol - logicalLeftCol + 1);
                --southRow;
                continue;
            }
            if (layout.direction == CENTER) {
                centerTd = td;
                continue;
            }
            if (this.shouldAddToLogicalLeftOfTable(layout.direction)) {
                row = rows[northRow];
                DOM.insertChild(row.tr, td, row.center++);
                DOM.appendChild(td, child.getElement());
                DOM.setElementPropertyInt(td, "rowSpan", southRow - northRow + 1);
                ++logicalLeftCol;
                continue;
            }
            if (!this.shouldAddToLogicalRightOfTable(layout.direction)) continue;
            row = rows[northRow];
            DOM.insertChild(row.tr, td, row.center);
            DOM.appendChild(td, child.getElement());
            DOM.setElementPropertyInt(td, "rowSpan", southRow - northRow + 1);
            --logicalRightCol;
        }
        if (this.center != null) {
            TmpRow row = rows[northRow];
            DOM.insertChild(row.tr, centerTd, row.center);
            DOM.appendChild(centerTd, this.center.getElement());
        }
    }

    private boolean shouldAddToLogicalLeftOfTable(DockLayoutConstant widgetDirection) {
        assert (widgetDirection == LINE_START || widgetDirection == LINE_END || widgetDirection == EAST || widgetDirection == WEST);
        if (widgetDirection == LINE_START) {
            return true;
        }
        if (LocaleInfo.getCurrentLocale().isRTL()) {
            return widgetDirection == EAST;
        }
        return widgetDirection == WEST;
    }

    private boolean shouldAddToLogicalRightOfTable(DockLayoutConstant widgetDirection) {
        assert (widgetDirection == LINE_START || widgetDirection == LINE_END || widgetDirection == EAST || widgetDirection == WEST);
        if (widgetDirection == LINE_END) {
            return true;
        }
        if (LocaleInfo.getCurrentLocale().isRTL()) {
            return widgetDirection == WEST;
        }
        return widgetDirection == EAST;
    }

    private static class TmpRow {
        public int center;
        public Element tr;

        private TmpRow() {
        }
    }

    static class LayoutData {
        public DockLayoutConstant direction;
        public String hAlign = HasHorizontalAlignment.ALIGN_DEFAULT.getTextAlignString();
        public String height = "";
        public Element td;
        public String vAlign = HasVerticalAlignment.ALIGN_TOP.getVerticalAlignString();
        public String width = "";

        public LayoutData(DockLayoutConstant dir) {
            this.direction = dir;
        }
    }

    public static class DockLayoutConstant {
        private DockLayoutConstant() {
        }
    }
}

