# Authors:
#  Stephen Gallagher <sgallagh@redhat.com>
#
# Copyright (C) 2009  Red Hat
# see file 'COPYING' for use and warranty information
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

"""
Python-level packaging using setuptools.
"""

from setuptools import setup

def sanitize_version(version):
    """
    We need to convert Fedora version guidelines which we follow in version.m4
    to Python guidelines. See:
    * https://docs.fedoraproject.org/en-US/packaging-guidelines/Versioning/
    * https://packaging.python.org/en/latest/discussions/versioning/
    """
    # X.Y.Z-alpha1 -> X.Y.Za1
    # X.Y.Z-beta1 -> X.Y.Zb1
    # X.Y.Z-rc1 -> X.Y.Zrc1
    return version.replace('-', '').replace('alpha', 'a').replace('beta', 'b')

setup(
    name='SSSDConfig',
    version=sanitize_version('2.12.0'),
    license='GPLv3+',
    url='https://github.com/SSSD/sssd/',
    packages=['SSSDConfig'],
)
