#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""
Generate .h for LTTng ust event description.
"""

__author__     = "Mohamad Gebai <mohamad.gebai@polymtl.ca>"
__copyright__  = "Copyright 2012, Mohamad Gebai <mohamad.gebai@polymtl.ca>"
__license__    = "GPL version 2 or (at your option) any later version"

__maintainer__ = "Stefan Hajnoczi"
__email__      = "stefanha@redhat.com"


from tracetool import out


def begin(events):
    out('/* This file is autogenerated by tracetool, do not edit. */',
        '',
        '#undef TRACEPOINT_PROVIDER',
        '#define TRACEPOINT_PROVIDER qemu',
        '',
        '#undef TRACEPOINT_INCLUDE_FILE',
        '#define TRACEPOINT_INCLUDE_FILE ./generated-ust-provider.h',
        '',
        '#if !defined (TRACE__GENERATED_UST_H) || defined(TRACEPOINT_HEADER_MULTI_READ)',
        '#define TRACE__GENERATED_UST_H',
        '',
        '#include "qemu-common.h"',
        '#include <lttng/tracepoint.h>',
        '',
        '/*',
        ' * LTTng ust 2.0 does not allow you to use TP_ARGS(void) for tracepoints',
        ' * requiring no arguments. We define these macros introduced in more recent'
        ' * versions of LTTng ust as a workaround',
        ' */',
        '#ifndef _TP_EXPROTO1',
        '#define _TP_EXPROTO1(a)               void',
        '#endif',
        '#ifndef _TP_EXDATA_PROTO1',
        '#define _TP_EXDATA_PROTO1(a)          void *__tp_data',
        '#endif',
        '#ifndef _TP_EXDATA_VAR1',
        '#define _TP_EXDATA_VAR1(a)            __tp_data',
        '#endif',
        '#ifndef _TP_EXVAR1',
        '#define _TP_EXVAR1(a)',
        '#endif',
        '')

def end(events):
    out('#endif /* TRACE__GENERATED_UST_H */',
        '',
        '/* This part must be outside ifdef protection */',
        '#include <lttng/tracepoint-event.h>')
