# PySNMP SMI module. Autogenerated from smidump -f python CIRCUIT-IF-MIB
# by libsmi2pysnmp-0.1.3 at Mon Apr  2 20:38:45 2012,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ConstraintsIntersection, ConstraintsUnion, SingleValueConstraint, ValueRangeConstraint, ValueSizeConstraint, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ConstraintsIntersection", "ConstraintsUnion", "SingleValueConstraint", "ValueRangeConstraint", "ValueSizeConstraint")
( InterfaceIndex, ifIndex, ) = mibBuilder.importSymbols("IF-MIB", "InterfaceIndex", "ifIndex")
( ModuleCompliance, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "ObjectGroup")
( Bits, Gauge32, Integer32, ModuleIdentity, MibIdentifier, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, mib_2, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Gauge32", "Integer32", "ModuleIdentity", "MibIdentifier", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "mib-2")
( RowPointer, RowStatus, StorageType, TextualConvention, TimeStamp, ) = mibBuilder.importSymbols("SNMPv2-TC", "RowPointer", "RowStatus", "StorageType", "TextualConvention", "TimeStamp")

# Types

class CiFlowDirection(Integer):
    subtypeSpec = Integer.subtypeSpec+SingleValueConstraint(3,2,1,)
    namedValues = NamedValues(("transmit", 1), ("receive", 2), ("both", 3), )
    

# Objects

circuitIfMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 94)).setRevisions(("2002-01-03 00:00",))
if mibBuilder.loadTexts: circuitIfMIB.setOrganization("IETF Frame Relay Service MIB Working Group")
if mibBuilder.loadTexts: circuitIfMIB.setContactInfo("IETF Frame Relay Service MIB (frnetmib) Working Group\n\nWG Charter:    http://www.ietf.org/html.charters/\n                      frnetmib-charter.html\nWG-email:      frnetmib@sunroof.eng.sun.com\nSubscribe:     frnetmib-request@sunroof.eng.sun.com\nEmail Archive: ftp://ftp.ietf.org/ietf-mail-archive/frnetmib\n\nChair:      Andy Malis\n            Vivace Networks\nEmail:      Andy.Malis@vivacenetworks.com\n\nWG editor:  Robert Steinberger\n            Paradyne Networks and\n            Fujitsu Network Communications\nEmail:      robert.steinberger@fnc.fujitsu.com\n\nCo-author:  Orly Nicklass\n            RAD Data Communications Ltd.\nEMail:      Orly_n@rad.co.il")
if mibBuilder.loadTexts: circuitIfMIB.setDescription("The MIB module to allow insertion of selected circuit into\nthe ifTable.")
ciObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 94, 1))
ciCircuitTable = MibTable((1, 3, 6, 1, 2, 1, 94, 1, 1))
if mibBuilder.loadTexts: ciCircuitTable.setDescription("The Circuit Interface Circuit Table.")
ciCircuitEntry = MibTableRow((1, 3, 6, 1, 2, 1, 94, 1, 1, 1)).setIndexNames((0, "CIRCUIT-IF-MIB", "ciCircuitObject"), (0, "CIRCUIT-IF-MIB", "ciCircuitFlow"))
if mibBuilder.loadTexts: ciCircuitEntry.setDescription("An entry in the Circuit Interface Circuit Table.")
ciCircuitObject = MibTableColumn((1, 3, 6, 1, 2, 1, 94, 1, 1, 1, 1), RowPointer()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ciCircuitObject.setDescription("This value contains the RowPointer that uniquely\n\n\ndescribes the circuit that is to be added to this table.\nAny RowPointer that will force the size of OBJECT\nIDENTIFIER of the row to grow beyond the legal limit\nMUST be rejected.\n\nThe purpose of this object is to point a network manager\nto the table in which the circuit was created as well as\ndefine the circuit on which the interface is defined.\n\nValid tables for this object include the frCircuitTable\nfrom the Frame Relay DTE MIB(FRAME-RELAY-DTE-MIB), the\nfrPVCEndptTable from the Frame Relay Service MIB\n(FRNETSERV-MIB), and the aal5VccTable from the ATM MIB\n(ATM MIB).  However, including circuits from other MIB\ntables IS NOT prohibited.")
ciCircuitFlow = MibTableColumn((1, 3, 6, 1, 2, 1, 94, 1, 1, 1, 2), CiFlowDirection()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ciCircuitFlow.setDescription("The direction of data flow through the circuit for which\nthe virtual interface is defined.  The following define\nthe information that the virtual interface will report.\n\n   transmit(1) - Only transmitted frames\n   receive(2)  - Only received frames\n   both(3)     - Both transmitted and received frames.\n\nIt is recommended that the ifDescr of the circuit\ninterfaces that are not both(3) SHOULD have text warning\nthe operators that the particular interface represents\nonly half the traffic on the circuit.")
ciCircuitStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 94, 1, 1, 1, 3), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ciCircuitStatus.setDescription("The status of the current row.  This object is\nused to add, delete, and disable rows in this\ntable.  When the status changes to active(1), a row\nwill also be added to the interface map table below\nand a row will be added to the ifTable.  These rows\nSHOULD not be removed until the status is changed\nfrom active(1).  The value of ifIndex for the row that\n\n\nis added to the ifTable is determined by the agent\nand MUST follow the rules of the ifTable.  The value\nof ifType for that interface will be frDlciEndPt(193)\nfor a frame relay circuit, atmVciEndPt(194) for an\nATM circuit, or another ifType defining the circuit\ntype for any other circuit.\n\nWhen this object is set to destroy(6), the associated\nrow in the interface map table will be removed and the\nifIndex will be removed from the ifTable.  Removing\nthe ifIndex MAY initiate a chain of events that causes\nchanges to other tables as well.\n\nThe rows added to this table MUST have a valid object\nidentifier for ciCircuitObject.  This means that the\nreferenced object must exist and it must be in a table\nthat supports circuits.\n\nThe object referenced by ciCircuitObject MUST exist\nprior to transitioning a row to active(1).  If at any\npoint the object referenced by ciCircuitObject does not\nexist or the row containing it is not in the active(1)\nstate, the status SHOULD either age out the row or\nreport notReady(3).  The effects transitioning from\nactive(1) to notReady(3) are the same as those caused\nby setting the status to destroy(6).\n\nEach row in this table relies on information from other\nMIB modules.  The rules persistence of data SHOULD follow\nthe same rules as those of the underlying MIB module.\nFor example, if the circuit defined by ciCircuitObject\nwould normally be stored in non-volatile memory, then\nthe row SHOULD also be non-volatile.")
ciCircuitIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 94, 1, 1, 1, 4), InterfaceIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ciCircuitIfIndex.setDescription("The ifIndex that the agent assigns to this row.")
ciCircuitCreateTime = MibTableColumn((1, 3, 6, 1, 2, 1, 94, 1, 1, 1, 5), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ciCircuitCreateTime.setDescription("This object returns the value of sysUpTime at the time\nthe value of ciCircuitStatus last transitioned to\nactive(1).  If ciCircuitStatus has never been active(1),\nthis object SHOULD return 0.")
ciCircuitStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 94, 1, 1, 1, 6), StorageType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ciCircuitStorageType.setDescription("The storage type used for this row.")
ciIfMapTable = MibTable((1, 3, 6, 1, 2, 1, 94, 1, 2))
if mibBuilder.loadTexts: ciIfMapTable.setDescription("The Circuit Interface Map Table.")
ciIfMapEntry = MibTableRow((1, 3, 6, 1, 2, 1, 94, 1, 2, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: ciIfMapEntry.setDescription("An entry in the Circuit Interface Map Table.")
ciIfMapObject = MibTableColumn((1, 3, 6, 1, 2, 1, 94, 1, 2, 1, 1), RowPointer()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ciIfMapObject.setDescription("This value contains the value of RowPointer that\ncorresponds to the current ifIndex.")
ciIfMapFlow = MibTableColumn((1, 3, 6, 1, 2, 1, 94, 1, 2, 1, 2), CiFlowDirection()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ciIfMapFlow.setDescription("The value contains the value of ciCircuitFlow that\ncorresponds to the current ifIndex.")
ciIfLastChange = MibScalar((1, 3, 6, 1, 2, 1, 94, 1, 3), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ciIfLastChange.setDescription("The value of sysUpTime at the most recent change to\nciCircuitStatus for any row in ciCircuitTable.")
ciIfNumActive = MibScalar((1, 3, 6, 1, 2, 1, 94, 1, 4), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ciIfNumActive.setDescription("The number of active rows in ciCircuitTable.")
ciCapabilities = MibIdentifier((1, 3, 6, 1, 2, 1, 94, 2))
ciConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 94, 3))
ciMIBGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 94, 3, 1))
ciMIBCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 94, 3, 2))

# Augmentions

# Groups

ciCircuitGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 94, 3, 1, 1)).setObjects(*(("CIRCUIT-IF-MIB", "ciCircuitStatus"), ("CIRCUIT-IF-MIB", "ciCircuitStorageType"), ("CIRCUIT-IF-MIB", "ciCircuitIfIndex"), ("CIRCUIT-IF-MIB", "ciCircuitCreateTime"), ) )
if mibBuilder.loadTexts: ciCircuitGroup.setDescription("A collection of required objects providing\ninformation from the circuit table.")
ciIfMapGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 94, 3, 1, 2)).setObjects(*(("CIRCUIT-IF-MIB", "ciIfMapObject"), ("CIRCUIT-IF-MIB", "ciIfMapFlow"), ) )
if mibBuilder.loadTexts: ciIfMapGroup.setDescription("A collection of required objects providing\ninformation from the interface map table.")
ciStatsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 94, 3, 1, 3)).setObjects(*(("CIRCUIT-IF-MIB", "ciIfNumActive"), ("CIRCUIT-IF-MIB", "ciIfLastChange"), ) )
if mibBuilder.loadTexts: ciStatsGroup.setDescription("A collection of statistical metrics used to help manage\nthe ciCircuitTable.")

# Compliances

ciCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 94, 3, 2, 1)).setObjects(*(("CIRCUIT-IF-MIB", "ciCircuitGroup"), ("CIRCUIT-IF-MIB", "ciStatsGroup"), ("CIRCUIT-IF-MIB", "ciIfMapGroup"), ) )
if mibBuilder.loadTexts: ciCompliance.setDescription("The compliance statement for SNMP entities\n\n\nwhich support of the Circuit Interfaces MIB module.\nThis group defines the minimum level of support\nrequired for compliance.")

# Exports

# Module identity
mibBuilder.exportSymbols("CIRCUIT-IF-MIB", PYSNMP_MODULE_ID=circuitIfMIB)

# Types
mibBuilder.exportSymbols("CIRCUIT-IF-MIB", CiFlowDirection=CiFlowDirection)

# Objects
mibBuilder.exportSymbols("CIRCUIT-IF-MIB", circuitIfMIB=circuitIfMIB, ciObjects=ciObjects, ciCircuitTable=ciCircuitTable, ciCircuitEntry=ciCircuitEntry, ciCircuitObject=ciCircuitObject, ciCircuitFlow=ciCircuitFlow, ciCircuitStatus=ciCircuitStatus, ciCircuitIfIndex=ciCircuitIfIndex, ciCircuitCreateTime=ciCircuitCreateTime, ciCircuitStorageType=ciCircuitStorageType, ciIfMapTable=ciIfMapTable, ciIfMapEntry=ciIfMapEntry, ciIfMapObject=ciIfMapObject, ciIfMapFlow=ciIfMapFlow, ciIfLastChange=ciIfLastChange, ciIfNumActive=ciIfNumActive, ciCapabilities=ciCapabilities, ciConformance=ciConformance, ciMIBGroups=ciMIBGroups, ciMIBCompliances=ciMIBCompliances)

# Groups
mibBuilder.exportSymbols("CIRCUIT-IF-MIB", ciCircuitGroup=ciCircuitGroup, ciIfMapGroup=ciIfMapGroup, ciStatsGroup=ciStatsGroup)

# Compliances
mibBuilder.exportSymbols("CIRCUIT-IF-MIB", ciCompliance=ciCompliance)
