/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.javadraw;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureAttributeConstant;
import org.jhotdraw.standard.AbstractTool;
import org.jhotdraw.util.FloatingTextField;

public class URLTool
extends AbstractTool {
    private FloatingTextField fTextField;
    private Figure fURLTarget;

    public URLTool(DrawingEditor drawingEditor) {
        super(drawingEditor);
    }

    public void mouseDown(MouseEvent mouseEvent, int n, int n2) {
        super.mouseDown(mouseEvent, n, n2);
        Figure figure = this.drawing().findFigureInside(n, n2);
        if (figure != null) {
            this.beginEdit(figure);
            return;
        }
        this.endEdit();
        this.editor().toolDone();
    }

    public void mouseUp(MouseEvent mouseEvent, int n, int n2) {
    }

    public void deactivate(DrawingView drawingView) {
        super.deactivate();
        this.endEdit();
    }

    private void beginEdit(Figure figure) {
        if (this.fTextField == null) {
            this.fTextField = new FloatingTextField();
            this.fTextField.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    URLTool.this.endEdit();
                }
            });
        }
        if (figure != this.fURLTarget && this.fURLTarget != null) {
            this.endEdit();
        }
        if (figure != this.fURLTarget) {
            this.fTextField.createOverlay((Container)((Object)this.view()));
            this.fTextField.setBounds(this.fieldBounds(figure), this.getURL(figure));
            this.fURLTarget = figure;
        }
    }

    private void endEdit() {
        if (this.fURLTarget != null) {
            this.setURL(this.fURLTarget, this.fTextField.getText());
            this.fURLTarget = null;
            this.fTextField.endOverlay();
        }
    }

    private Rectangle fieldBounds(Figure figure) {
        Rectangle rectangle = figure.displayBox();
        int n = Math.max(20, this.getURL(figure).length());
        Dimension dimension = this.fTextField.getPreferredSize(n);
        rectangle.x = Math.max(0, rectangle.x + (rectangle.width - dimension.width) / 2);
        rectangle.y = Math.max(0, rectangle.y + (rectangle.height - dimension.height) / 2);
        return new Rectangle(rectangle.x, rectangle.y, dimension.width, dimension.height);
    }

    private String getURL(Figure figure) {
        String string = (String)figure.getAttribute(FigureAttributeConstant.URL);
        if (string == null) {
            string = "";
        }
        return string;
    }

    private void setURL(Figure figure, String string) {
        figure.setAttribute(FigureAttributeConstant.URL, (Object)string);
    }
}

