; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mcpu=pwr9 -verify-machineinstrs -mtriple=powerpc64le-unknown-linux \
; RUN:    < %s | FileCheck --check-prefixes=CHECK,CHECK-P9 %s
; RUN: llc -mcpu=pwr8 -verify-machineinstrs -mtriple=powerpc64le-unknown-linux \
; RUN:    < %s | FileCheck --check-prefixes=CHECK,CHECK-P8 %s

declare ppc_fp128 @llvm.ppc.maxfe(ppc_fp128 %a, ppc_fp128 %b, ppc_fp128 %c, ...)
define ppc_fp128 @test_maxfe(ppc_fp128 %a, ppc_fp128 %b, ppc_fp128 %c, ppc_fp128 %d) {
; CHECK-LABEL: test_maxfe:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fcmpu 0, 6, 4
; CHECK-NEXT:    fcmpu 1, 5, 3
; CHECK-NEXT:    crand 20, 6, 1
; CHECK-NEXT:    cror 20, 5, 20
; CHECK-NEXT:    bc 12, 20, .LBB0_2
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    fmr 6, 4
; CHECK-NEXT:  .LBB0_2: # %entry
; CHECK-NEXT:    fcmpu 0, 6, 2
; CHECK-NEXT:    bc 12, 20, .LBB0_4
; CHECK-NEXT:  # %bb.3: # %entry
; CHECK-NEXT:    fmr 5, 3
; CHECK-NEXT:  .LBB0_4: # %entry
; CHECK-NEXT:    fcmpu 1, 5, 1
; CHECK-NEXT:    crand 20, 6, 1
; CHECK-NEXT:    cror 20, 5, 20
; CHECK-NEXT:    bc 12, 20, .LBB0_6
; CHECK-NEXT:  # %bb.5: # %entry
; CHECK-NEXT:    fmr 6, 2
; CHECK-NEXT:  .LBB0_6: # %entry
; CHECK-NEXT:    fcmpu 0, 6, 8
; CHECK-NEXT:    bc 12, 20, .LBB0_8
; CHECK-NEXT:  # %bb.7: # %entry
; CHECK-NEXT:    fmr 5, 1
; CHECK-NEXT:  .LBB0_8: # %entry
; CHECK-NEXT:    fcmpu 1, 5, 7
; CHECK-NEXT:    crand 20, 6, 1
; CHECK-NEXT:    cror 20, 5, 20
; CHECK-NEXT:    bc 12, 20, .LBB0_10
; CHECK-NEXT:  # %bb.9: # %entry
; CHECK-NEXT:    fmr 5, 7
; CHECK-NEXT:  .LBB0_10: # %entry
; CHECK-NEXT:    bc 12, 20, .LBB0_12
; CHECK-NEXT:  # %bb.11: # %entry
; CHECK-NEXT:    fmr 6, 8
; CHECK-NEXT:  .LBB0_12: # %entry
; CHECK-NEXT:    fmr 1, 5
; CHECK-NEXT:    fmr 2, 6
; CHECK-NEXT:    blr
entry:
  %0 = call ppc_fp128 (ppc_fp128, ppc_fp128, ppc_fp128, ...) @llvm.ppc.maxfe(ppc_fp128 %a, ppc_fp128 %b, ppc_fp128 %c, ppc_fp128 %d)
  ret ppc_fp128 %0
}

declare double @llvm.ppc.maxfl(double %a, double %b, double %c, ...)
define double @test_maxfl(double %a, double %b, double %c, double %d) {
; CHECK-P9-LABEL: test_maxfl:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    xsmaxcdp 0, 3, 2
; CHECK-P9-NEXT:    xsmaxcdp 0, 0, 1
; CHECK-P9-NEXT:    xsmaxcdp 1, 0, 4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: test_maxfl:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscmpudp 0, 3, 2
; CHECK-P8-NEXT:    ble 0, .LBB1_4
; CHECK-P8-NEXT:  # %bb.1: # %entry
; CHECK-P8-NEXT:    xscmpudp 0, 3, 1
; CHECK-P8-NEXT:    ble 0, .LBB1_5
; CHECK-P8-NEXT:  .LBB1_2: # %entry
; CHECK-P8-NEXT:    xscmpudp 0, 3, 4
; CHECK-P8-NEXT:    ble 0, .LBB1_6
; CHECK-P8-NEXT:  .LBB1_3: # %entry
; CHECK-P8-NEXT:    fmr 1, 3
; CHECK-P8-NEXT:    blr
; CHECK-P8-NEXT:  .LBB1_4: # %entry
; CHECK-P8-NEXT:    fmr 3, 2
; CHECK-P8-NEXT:    xscmpudp 0, 3, 1
; CHECK-P8-NEXT:    bgt 0, .LBB1_2
; CHECK-P8-NEXT:  .LBB1_5: # %entry
; CHECK-P8-NEXT:    fmr 3, 1
; CHECK-P8-NEXT:    xscmpudp 0, 3, 4
; CHECK-P8-NEXT:    bgt 0, .LBB1_3
; CHECK-P8-NEXT:  .LBB1_6: # %entry
; CHECK-P8-NEXT:    fmr 3, 4
; CHECK-P8-NEXT:    fmr 1, 3
; CHECK-P8-NEXT:    blr
entry:
  %0 = call double (double, double, double, ...) @llvm.ppc.maxfl(double %a, double %b, double %c, double %d)
  ret double %0
}

declare float @llvm.ppc.maxfs(float %a, float %b, float %c, ...)
define float @test_maxfs(float %a, float %b, float %c, float %d) {
; CHECK-P9-LABEL: test_maxfs:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    xsmaxcdp 0, 3, 2
; CHECK-P9-NEXT:    xsmaxcdp 0, 0, 1
; CHECK-P9-NEXT:    xsmaxcdp 1, 0, 4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: test_maxfs:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    fcmpu 0, 3, 2
; CHECK-P8-NEXT:    ble 0, .LBB2_4
; CHECK-P8-NEXT:  # %bb.1: # %entry
; CHECK-P8-NEXT:    fcmpu 0, 3, 1
; CHECK-P8-NEXT:    ble 0, .LBB2_5
; CHECK-P8-NEXT:  .LBB2_2: # %entry
; CHECK-P8-NEXT:    fcmpu 0, 3, 4
; CHECK-P8-NEXT:    ble 0, .LBB2_6
; CHECK-P8-NEXT:  .LBB2_3: # %entry
; CHECK-P8-NEXT:    fmr 1, 3
; CHECK-P8-NEXT:    blr
; CHECK-P8-NEXT:  .LBB2_4: # %entry
; CHECK-P8-NEXT:    fmr 3, 2
; CHECK-P8-NEXT:    fcmpu 0, 3, 1
; CHECK-P8-NEXT:    bgt 0, .LBB2_2
; CHECK-P8-NEXT:  .LBB2_5: # %entry
; CHECK-P8-NEXT:    fmr 3, 1
; CHECK-P8-NEXT:    fcmpu 0, 3, 4
; CHECK-P8-NEXT:    bgt 0, .LBB2_3
; CHECK-P8-NEXT:  .LBB2_6: # %entry
; CHECK-P8-NEXT:    fmr 3, 4
; CHECK-P8-NEXT:    fmr 1, 3
; CHECK-P8-NEXT:    blr
entry:
  %0 = call float (float, float, float, ...) @llvm.ppc.maxfs(float %a, float %b, float %c, float %d)
  ret float %0
}

declare ppc_fp128 @llvm.ppc.minfe(ppc_fp128 %a, ppc_fp128 %b, ppc_fp128 %c, ...)
define ppc_fp128 @test_minfe(ppc_fp128 %a, ppc_fp128 %b, ppc_fp128 %c, ppc_fp128 %d) {
; CHECK-LABEL: test_minfe:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fcmpu 0, 6, 4
; CHECK-NEXT:    fcmpu 1, 5, 3
; CHECK-NEXT:    crand 20, 6, 0
; CHECK-NEXT:    cror 20, 4, 20
; CHECK-NEXT:    bc 12, 20, .LBB3_2
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    fmr 6, 4
; CHECK-NEXT:  .LBB3_2: # %entry
; CHECK-NEXT:    fcmpu 0, 6, 2
; CHECK-NEXT:    bc 12, 20, .LBB3_4
; CHECK-NEXT:  # %bb.3: # %entry
; CHECK-NEXT:    fmr 5, 3
; CHECK-NEXT:  .LBB3_4: # %entry
; CHECK-NEXT:    fcmpu 1, 5, 1
; CHECK-NEXT:    crand 20, 6, 0
; CHECK-NEXT:    cror 20, 4, 20
; CHECK-NEXT:    bc 12, 20, .LBB3_6
; CHECK-NEXT:  # %bb.5: # %entry
; CHECK-NEXT:    fmr 6, 2
; CHECK-NEXT:  .LBB3_6: # %entry
; CHECK-NEXT:    fcmpu 0, 6, 8
; CHECK-NEXT:    bc 12, 20, .LBB3_8
; CHECK-NEXT:  # %bb.7: # %entry
; CHECK-NEXT:    fmr 5, 1
; CHECK-NEXT:  .LBB3_8: # %entry
; CHECK-NEXT:    fcmpu 1, 5, 7
; CHECK-NEXT:    crand 20, 6, 0
; CHECK-NEXT:    cror 20, 4, 20
; CHECK-NEXT:    bc 12, 20, .LBB3_10
; CHECK-NEXT:  # %bb.9: # %entry
; CHECK-NEXT:    fmr 5, 7
; CHECK-NEXT:  .LBB3_10: # %entry
; CHECK-NEXT:    bc 12, 20, .LBB3_12
; CHECK-NEXT:  # %bb.11: # %entry
; CHECK-NEXT:    fmr 6, 8
; CHECK-NEXT:  .LBB3_12: # %entry
; CHECK-NEXT:    fmr 1, 5
; CHECK-NEXT:    fmr 2, 6
; CHECK-NEXT:    blr
entry:
  %0 = call ppc_fp128 (ppc_fp128, ppc_fp128, ppc_fp128, ...) @llvm.ppc.minfe(ppc_fp128 %a, ppc_fp128 %b, ppc_fp128 %c, ppc_fp128 %d)
  ret ppc_fp128 %0
}

declare double @llvm.ppc.minfl(double %a, double %b, double %c, ...)
define double @test_minfl(double %a, double %b, double %c, double %d) {
; CHECK-P9-LABEL: test_minfl:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    xsmincdp 0, 3, 2
; CHECK-P9-NEXT:    xsmincdp 0, 0, 1
; CHECK-P9-NEXT:    xsmincdp 1, 0, 4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: test_minfl:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscmpudp 0, 3, 2
; CHECK-P8-NEXT:    bge 0, .LBB4_4
; CHECK-P8-NEXT:  # %bb.1: # %entry
; CHECK-P8-NEXT:    xscmpudp 0, 3, 1
; CHECK-P8-NEXT:    bge 0, .LBB4_5
; CHECK-P8-NEXT:  .LBB4_2: # %entry
; CHECK-P8-NEXT:    xscmpudp 0, 3, 4
; CHECK-P8-NEXT:    bge 0, .LBB4_6
; CHECK-P8-NEXT:  .LBB4_3: # %entry
; CHECK-P8-NEXT:    fmr 1, 3
; CHECK-P8-NEXT:    blr
; CHECK-P8-NEXT:  .LBB4_4: # %entry
; CHECK-P8-NEXT:    fmr 3, 2
; CHECK-P8-NEXT:    xscmpudp 0, 3, 1
; CHECK-P8-NEXT:    blt 0, .LBB4_2
; CHECK-P8-NEXT:  .LBB4_5: # %entry
; CHECK-P8-NEXT:    fmr 3, 1
; CHECK-P8-NEXT:    xscmpudp 0, 3, 4
; CHECK-P8-NEXT:    blt 0, .LBB4_3
; CHECK-P8-NEXT:  .LBB4_6: # %entry
; CHECK-P8-NEXT:    fmr 3, 4
; CHECK-P8-NEXT:    fmr 1, 3
; CHECK-P8-NEXT:    blr
entry:
  %0 = call double (double, double, double, ...) @llvm.ppc.minfl(double %a, double %b, double %c, double %d)
  ret double %0
}

declare float @llvm.ppc.minfs(float %a, float %b, float %c, ...)
define float @test_minfs(float %a, float %b, float %c, float %d) {
; CHECK-P9-LABEL: test_minfs:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    xsmincdp 0, 3, 2
; CHECK-P9-NEXT:    xsmincdp 0, 0, 1
; CHECK-P9-NEXT:    xsmincdp 1, 0, 4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: test_minfs:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    fcmpu 0, 3, 2
; CHECK-P8-NEXT:    bge 0, .LBB5_4
; CHECK-P8-NEXT:  # %bb.1: # %entry
; CHECK-P8-NEXT:    fcmpu 0, 3, 1
; CHECK-P8-NEXT:    bge 0, .LBB5_5
; CHECK-P8-NEXT:  .LBB5_2: # %entry
; CHECK-P8-NEXT:    fcmpu 0, 3, 4
; CHECK-P8-NEXT:    bge 0, .LBB5_6
; CHECK-P8-NEXT:  .LBB5_3: # %entry
; CHECK-P8-NEXT:    fmr 1, 3
; CHECK-P8-NEXT:    blr
; CHECK-P8-NEXT:  .LBB5_4: # %entry
; CHECK-P8-NEXT:    fmr 3, 2
; CHECK-P8-NEXT:    fcmpu 0, 3, 1
; CHECK-P8-NEXT:    blt 0, .LBB5_2
; CHECK-P8-NEXT:  .LBB5_5: # %entry
; CHECK-P8-NEXT:    fmr 3, 1
; CHECK-P8-NEXT:    fcmpu 0, 3, 4
; CHECK-P8-NEXT:    blt 0, .LBB5_3
; CHECK-P8-NEXT:  .LBB5_6: # %entry
; CHECK-P8-NEXT:    fmr 3, 4
; CHECK-P8-NEXT:    fmr 1, 3
; CHECK-P8-NEXT:    blr
entry:
  %0 = call float (float, float, float, ...) @llvm.ppc.minfs(float %a, float %b, float %c, float %d)
  ret float %0
}
