; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown | FileCheck %s

; PR19758

define i32 @unsigned_tree_way_cmp_i32(i32 %a, i32 %b) {
; CHECK-LABEL: unsigned_tree_way_cmp_i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xorl %ecx, %ecx
; CHECK-NEXT:    cmpl %esi, %edi
; CHECK-NEXT:    seta %cl
; CHECK-NEXT:    movl $-1, %eax
; CHECK-NEXT:    cmovael %ecx, %eax
; CHECK-NEXT:    retq
  %c = icmp ult i32 %a, %b
  %d = icmp ugt i32 %a, %b
  %z = zext i1 %d to i32
  %res = select i1 %c, i32 -1, i32 %z
  ret i32 %res
}

define i32 @unsigned_tree_way_cmp_i64(i64 %a, i64 %b) {
; CHECK-LABEL: unsigned_tree_way_cmp_i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xorl %ecx, %ecx
; CHECK-NEXT:    cmpq %rsi, %rdi
; CHECK-NEXT:    seta %cl
; CHECK-NEXT:    movl $-1, %eax
; CHECK-NEXT:    cmovael %ecx, %eax
; CHECK-NEXT:    retq
  %c = icmp ult i64 %a, %b
  %d = icmp ugt i64 %a, %b
  %z = zext i1 %d to i32
  %res = select i1 %c, i32 -1, i32 %z
  ret i32 %res
}

define i32 @signed_tree_way_cmp(i32 %a, i32 %b) {
; CHECK-LABEL: signed_tree_way_cmp:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xorl %ecx, %ecx
; CHECK-NEXT:    cmpl %esi, %edi
; CHECK-NEXT:    setg %cl
; CHECK-NEXT:    movl $-1, %eax
; CHECK-NEXT:    cmovgel %ecx, %eax
; CHECK-NEXT:    retq
  %c = icmp slt i32 %a, %b
  %d = icmp sgt i32 %a, %b
  %z = zext i1 %d to i32
  %res = select i1 %c, i32 -1, i32 %z
  ret i32 %res
}

define i32 @signed_tree_way_cmp_i64(i64 %a, i64 %b) {
; CHECK-LABEL: signed_tree_way_cmp_i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xorl %ecx, %ecx
; CHECK-NEXT:    cmpq %rsi, %rdi
; CHECK-NEXT:    setg %cl
; CHECK-NEXT:    movl $-1, %eax
; CHECK-NEXT:    cmovgel %ecx, %eax
; CHECK-NEXT:    retq
  %c = icmp slt i64 %a, %b
  %d = icmp sgt i64 %a, %b
  %z = zext i1 %d to i32
  %res = select i1 %c, i32 -1, i32 %z
  ret i32 %res
}
