/* Simulator instruction semantics for @cpu@.

THIS FILE IS MACHINE GENERATED WITH CGEN.

Copyright 1996, 1997, 1998, 1999, 2000, 2001, 2002 Free Software Foundation, Inc.

This file is part of the GNU simulators.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

*/

#define WANT_CPU @cpu@
#define WANT_CPU_@CPU@

#include "sim-main.h"
#include "cgen-mem.h"
#include "cgen-ops.h"

#undef GET_ATTR
#if defined (__STDC__) || defined (ALMOST_STDC) || defined (HAVE_STRINGIZE)
#define GET_ATTR(cpu, num, attr) CGEN_ATTR_VALUE (NULL, abuf->idesc->attrs, CGEN_INSN_##attr)
#else
#define GET_ATTR(cpu, num, attr) CGEN_ATTR_VALUE (NULL, abuf->idesc->attrs, CGEN_INSN_/**/attr)
#endif

/* This is used so that we can compile two copies of the semantic code,
   one with full feature support and one without that runs fast(er).
   FAST_P, when desired, is defined on the command line, -DFAST_P=1.  */
#if FAST_P
#define SEM_FN_NAME(cpu,fn) XCONCAT3 (cpu,_semf_,fn)
#undef TRACE_RESULT
#define TRACE_RESULT(cpu, abuf, name, type, val)
#else
#define SEM_FN_NAME(cpu,fn) XCONCAT3 (cpu,_sem_,fn)
#endif

/* x-invalid: --invalid-- */

static SEM_STATUS
SEM_FN_NAME (@prefix@,x_invalid) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 0);
  EXTRACT_IFMT_EMPTY_VARS /* */
  EXTRACT_IFMT_EMPTY_CODE

  {
    /* Update the recorded pc in the cpu state struct.
       Only necessary for WITH_SCACHE case, but to avoid the
       conditional compilation ....  */
    SET_H_PC (pc);
    /* Virtual insns have zero size.  Overwrite vpc with address of next insn
       using the default-insn-bitsize spec.  When executing insns in parallel
       we may want to queue the fault and continue execution.  */
    vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
    vpc = sim_engine_invalid_insn (current_cpu, pc, vpc);
  }

  SEM_NBRANCH_FINI (vpc, 0|(1<<CGEN_INSN_VIRTUAL));
#undef FLD
  return status;
}

/* x-after: --after-- */

static SEM_STATUS
SEM_FN_NAME (@prefix@,x_after) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 0);
  EXTRACT_IFMT_EMPTY_VARS /* */
  EXTRACT_IFMT_EMPTY_CODE

  {
#if WITH_SCACHE_PBB_@PREFIX@
    @prefix@_pbb_after (current_cpu, sem_arg);
#endif
  }

  SEM_NBRANCH_FINI (vpc, 0|(1<<CGEN_INSN_PBB)|(1<<CGEN_INSN_VIRTUAL));
#undef FLD
  return status;
}

/* x-before: --before-- */

static SEM_STATUS
SEM_FN_NAME (@prefix@,x_before) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 0);
  EXTRACT_IFMT_EMPTY_VARS /* */
  EXTRACT_IFMT_EMPTY_CODE

  {
#if WITH_SCACHE_PBB_@PREFIX@
    @prefix@_pbb_before (current_cpu, sem_arg);
#endif
  }

  SEM_NBRANCH_FINI (vpc, 0|(1<<CGEN_INSN_PBB)|(1<<CGEN_INSN_VIRTUAL));
#undef FLD
  return status;
}

/* x-cti-chain: --cti-chain-- */

static SEM_STATUS
SEM_FN_NAME (@prefix@,x_cti_chain) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 0);
  EXTRACT_IFMT_EMPTY_VARS /* */
  EXTRACT_IFMT_EMPTY_CODE

  {
#if WITH_SCACHE_PBB_@PREFIX@
#ifdef DEFINE_SWITCH
    vpc = @prefix@_pbb_cti_chain (current_cpu, sem_arg,
			       pbb_br_type, pbb_br_npc);
    BREAK (sem);
#else
    /* FIXME: Allow provision of explicit ifmt spec in insn spec.  */
    vpc = @prefix@_pbb_cti_chain (current_cpu, sem_arg,
			       CPU_PBB_BR_TYPE (current_cpu),
			       CPU_PBB_BR_NPC (current_cpu));
#endif
#endif
  }

  SEM_NBRANCH_FINI (vpc, 0|(1<<CGEN_INSN_PBB)|(1<<CGEN_INSN_VIRTUAL));
#undef FLD
  return status;
}

/* x-chain: --chain-- */

static SEM_STATUS
SEM_FN_NAME (@prefix@,x_chain) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 0);
  EXTRACT_IFMT_EMPTY_VARS /* */
  EXTRACT_IFMT_EMPTY_CODE

  {
#if WITH_SCACHE_PBB_@PREFIX@
    vpc = @prefix@_pbb_chain (current_cpu, sem_arg);
#ifdef DEFINE_SWITCH
    BREAK (sem);
#endif
#endif
  }

  SEM_NBRANCH_FINI (vpc, 0|(1<<CGEN_INSN_PBB)|(1<<CGEN_INSN_VIRTUAL));
#undef FLD
  return status;
}

/* x-begin: --begin-- */

static SEM_STATUS
SEM_FN_NAME (@prefix@,x_begin) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 0);
  EXTRACT_IFMT_EMPTY_VARS /* */
  EXTRACT_IFMT_EMPTY_CODE

  {
#if WITH_SCACHE_PBB_@PREFIX@
#if defined DEFINE_SWITCH || defined FAST_P
    /* In the switch case FAST_P is a constant, allowing several optimizations
       in any called inline functions.  */
    vpc = @prefix@_pbb_begin (current_cpu, FAST_P);
#else
#if 0 /* cgen engine can't handle dynamic fast/full switching yet.  */
    vpc = @prefix@_pbb_begin (current_cpu, STATE_RUN_FAST_P (CPU_STATE (current_cpu)));
#else
    vpc = @prefix@_pbb_begin (current_cpu, 0);
#endif
#endif
#endif
  }

  SEM_NBRANCH_FINI (vpc, 0|(1<<CGEN_INSN_PBB)|(1<<CGEN_INSN_VIRTUAL));
#undef FLD
  return status;
}

/* add: add $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,add) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

  {
    DI opval = ADDDI (GET_H_GR (f_left), GET_H_GR (f_right));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* addl: add.l $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,addl) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

  {
    DI opval = ADDSI (SUBWORDDISI (GET_H_GR (f_left), 1), SUBWORDDISI (GET_H_GR (f_right), 1));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* addi: addi $rm, $disp10, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,addi) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADDI_VARS /* f-op f-left f-disp10 f-dest f-rsvd */
  EXTRACT_IFMT_ADDI_CODE

  {
    DI opval = ADDDI (GET_H_GR (f_left), EXTSIDI (f_disp10));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* addil: addi.l $rm, $disp10, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,addil) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADDI_VARS /* f-op f-left f-disp10 f-dest f-rsvd */
  EXTRACT_IFMT_ADDI_CODE

  {
    DI opval = EXTSIDI (ADDSI (EXTSISI (f_disp10), SUBWORDDISI (GET_H_GR (f_left), 1)));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* addzl: addz.l $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,addzl) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

  {
    DI opval = ZEXTSIDI (ADDSI (SUBWORDDISI (GET_H_GR (f_left), 1), SUBWORDDISI (GET_H_GR (f_right), 1)));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* alloco: alloco $rm, $disp6x32 */

static SEM_STATUS
SEM_FN_NAME (@prefix@,alloco) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ALLOCO_VARS /* f-op f-left f-ext f-disp6x32 f-dest f-rsvd */
  EXTRACT_IFMT_ALLOCO_CODE

((void) 0); /*nop*/

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* and: and $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,and) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

  {
    DI opval = ANDDI (GET_H_GR (f_left), GET_H_GR (f_right));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* andc: andc $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,andc) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

  {
    DI opval = ANDDI (GET_H_GR (f_left), INVDI (GET_H_GR (f_right)));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* andi: andi $rm, $disp10, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,andi) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADDI_VARS /* f-op f-left f-disp10 f-dest f-rsvd */
  EXTRACT_IFMT_ADDI_CODE

  {
    DI opval = ANDDI (GET_H_GR (f_left), EXTSIDI (f_disp10));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* beq: beq$likely $rm, $rn, $tra */

static SEM_STATUS
SEM_FN_NAME (@prefix@,beq) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_BRANCH_INIT
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_BEQ_VARS /* f-op f-left f-ext f-right f-likely f-8-2 f-tra f-rsvd */
  EXTRACT_IFMT_BEQ_CODE

if (EQDI (GET_H_GR (f_left), GET_H_GR (f_right))) {
  {
    UDI opval = CPU (h_tr[f_tra]);
    SEM_BRANCH_VIA_ADDR (current_cpu, sem_arg, opval, vpc);
    written |= (1 << 3);
    TRACE_RESULT (current_cpu, abuf, "pc", 'D', opval);
  }
}

  abuf->written = written;
  SEM_BRANCH_FINI (vpc, 0|(1<<CGEN_INSN_COND_CTI));
#undef FLD
  return status;
}

/* beqi: beqi$likely $rm, $imm6, $tra */

static SEM_STATUS
SEM_FN_NAME (@prefix@,beqi) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_BRANCH_INIT
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_BEQI_VARS /* f-op f-left f-ext f-imm6 f-likely f-8-2 f-tra f-rsvd */
  EXTRACT_IFMT_BEQI_CODE

if (EQDI (GET_H_GR (f_left), EXTSIDI (f_imm6))) {
  {
    UDI opval = CPU (h_tr[f_tra]);
    SEM_BRANCH_VIA_ADDR (current_cpu, sem_arg, opval, vpc);
    written |= (1 << 3);
    TRACE_RESULT (current_cpu, abuf, "pc", 'D', opval);
  }
}

  abuf->written = written;
  SEM_BRANCH_FINI (vpc, 0|(1<<CGEN_INSN_COND_CTI));
#undef FLD
  return status;
}

/* bge: bge$likely $rm, $rn, $tra */

static SEM_STATUS
SEM_FN_NAME (@prefix@,bge) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_BRANCH_INIT
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_BEQ_VARS /* f-op f-left f-ext f-right f-likely f-8-2 f-tra f-rsvd */
  EXTRACT_IFMT_BEQ_CODE

if (GEDI (GET_H_GR (f_left), GET_H_GR (f_right))) {
  {
    UDI opval = CPU (h_tr[f_tra]);
    SEM_BRANCH_VIA_ADDR (current_cpu, sem_arg, opval, vpc);
    written |= (1 << 3);
    TRACE_RESULT (current_cpu, abuf, "pc", 'D', opval);
  }
}

  abuf->written = written;
  SEM_BRANCH_FINI (vpc, 0|(1<<CGEN_INSN_COND_CTI));
#undef FLD
  return status;
}

/* bgeu: bgeu$likely $rm, $rn, $tra */

static SEM_STATUS
SEM_FN_NAME (@prefix@,bgeu) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_BRANCH_INIT
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_BEQ_VARS /* f-op f-left f-ext f-right f-likely f-8-2 f-tra f-rsvd */
  EXTRACT_IFMT_BEQ_CODE

if (GEUDI (GET_H_GR (f_left), GET_H_GR (f_right))) {
  {
    UDI opval = CPU (h_tr[f_tra]);
    SEM_BRANCH_VIA_ADDR (current_cpu, sem_arg, opval, vpc);
    written |= (1 << 3);
    TRACE_RESULT (current_cpu, abuf, "pc", 'D', opval);
  }
}

  abuf->written = written;
  SEM_BRANCH_FINI (vpc, 0|(1<<CGEN_INSN_COND_CTI));
#undef FLD
  return status;
}

/* bgt: bgt$likely $rm, $rn, $tra */

static SEM_STATUS
SEM_FN_NAME (@prefix@,bgt) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_BRANCH_INIT
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_BEQ_VARS /* f-op f-left f-ext f-right f-likely f-8-2 f-tra f-rsvd */
  EXTRACT_IFMT_BEQ_CODE

if (GTDI (GET_H_GR (f_left), GET_H_GR (f_right))) {
  {
    UDI opval = CPU (h_tr[f_tra]);
    SEM_BRANCH_VIA_ADDR (current_cpu, sem_arg, opval, vpc);
    written |= (1 << 3);
    TRACE_RESULT (current_cpu, abuf, "pc", 'D', opval);
  }
}

  abuf->written = written;
  SEM_BRANCH_FINI (vpc, 0|(1<<CGEN_INSN_COND_CTI));
#undef FLD
  return status;
}

/* bgtu: bgtu$likely $rm, $rn, $tra */

static SEM_STATUS
SEM_FN_NAME (@prefix@,bgtu) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_BRANCH_INIT
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_BEQ_VARS /* f-op f-left f-ext f-right f-likely f-8-2 f-tra f-rsvd */
  EXTRACT_IFMT_BEQ_CODE

if (GTUDI (GET_H_GR (f_left), GET_H_GR (f_right))) {
  {
    UDI opval = CPU (h_tr[f_tra]);
    SEM_BRANCH_VIA_ADDR (current_cpu, sem_arg, opval, vpc);
    written |= (1 << 3);
    TRACE_RESULT (current_cpu, abuf, "pc", 'D', opval);
  }
}

  abuf->written = written;
  SEM_BRANCH_FINI (vpc, 0|(1<<CGEN_INSN_COND_CTI));
#undef FLD
  return status;
}

/* blink: blink $trb, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,blink) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_BRANCH_INIT
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_BLINK_VARS /* f-op f-25 f-trb f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_BLINK_CODE

{
  {
    DI opval = ORDI (ADDDI (pc, 4), 1);
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }
  {
    UDI opval = CPU (h_tr[f_trb]);
    SEM_BRANCH_VIA_ADDR (current_cpu, sem_arg, opval, vpc);
    TRACE_RESULT (current_cpu, abuf, "pc", 'D', opval);
  }
}

  SEM_BRANCH_FINI (vpc, 0|(1<<CGEN_INSN_UNCOND_CTI));
#undef FLD
  return status;
}

/* bne: bne$likely $rm, $rn, $tra */

static SEM_STATUS
SEM_FN_NAME (@prefix@,bne) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_BRANCH_INIT
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_BEQ_VARS /* f-op f-left f-ext f-right f-likely f-8-2 f-tra f-rsvd */
  EXTRACT_IFMT_BEQ_CODE

if (NEDI (GET_H_GR (f_left), GET_H_GR (f_right))) {
  {
    UDI opval = CPU (h_tr[f_tra]);
    SEM_BRANCH_VIA_ADDR (current_cpu, sem_arg, opval, vpc);
    written |= (1 << 3);
    TRACE_RESULT (current_cpu, abuf, "pc", 'D', opval);
  }
}

  abuf->written = written;
  SEM_BRANCH_FINI (vpc, 0|(1<<CGEN_INSN_COND_CTI));
#undef FLD
  return status;
}

/* bnei: bnei$likely $rm, $imm6, $tra */

static SEM_STATUS
SEM_FN_NAME (@prefix@,bnei) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_BRANCH_INIT
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_BEQ_VARS /* f-op f-left f-ext f-right f-likely f-8-2 f-tra f-rsvd */
  EXTRACT_IFMT_BEQ_CODE

if (NEDI (GET_H_GR (f_left), EXTSIDI (f_imm6))) {
  {
    UDI opval = CPU (h_tr[f_tra]);
    SEM_BRANCH_VIA_ADDR (current_cpu, sem_arg, opval, vpc);
    written |= (1 << 3);
    TRACE_RESULT (current_cpu, abuf, "pc", 'D', opval);
  }
}

  abuf->written = written;
  SEM_BRANCH_FINI (vpc, 0|(1<<CGEN_INSN_COND_CTI));
#undef FLD
  return status;
}

/* brk: brk */

static SEM_STATUS
SEM_FN_NAME (@prefix@,brk) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_BRK_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_BRK_CODE

sh64_break (current_cpu, pc);

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* byterev: byterev $rm, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,byterev) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_BYTEREV_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_BYTEREV_CODE

{
  DI tmp_source;
  DI tmp_result;
  tmp_source = GET_H_GR (f_left);
  tmp_result = 0;
{
  tmp_result = ORDI (SLLDI (tmp_result, 8), ANDDI (tmp_source, 255));
  tmp_source = SRLDI (tmp_source, 8);
}
{
  tmp_result = ORDI (SLLDI (tmp_result, 8), ANDDI (tmp_source, 255));
  tmp_source = SRLDI (tmp_source, 8);
}
{
  tmp_result = ORDI (SLLDI (tmp_result, 8), ANDDI (tmp_source, 255));
  tmp_source = SRLDI (tmp_source, 8);
}
{
  tmp_result = ORDI (SLLDI (tmp_result, 8), ANDDI (tmp_source, 255));
  tmp_source = SRLDI (tmp_source, 8);
}
{
  tmp_result = ORDI (SLLDI (tmp_result, 8), ANDDI (tmp_source, 255));
  tmp_source = SRLDI (tmp_source, 8);
}
{
  tmp_result = ORDI (SLLDI (tmp_result, 8), ANDDI (tmp_source, 255));
  tmp_source = SRLDI (tmp_source, 8);
}
{
  tmp_result = ORDI (SLLDI (tmp_result, 8), ANDDI (tmp_source, 255));
  tmp_source = SRLDI (tmp_source, 8);
}
{
  tmp_result = ORDI (SLLDI (tmp_result, 8), ANDDI (tmp_source, 255));
  tmp_source = SRLDI (tmp_source, 8);
}
  {
    DI opval = tmp_result;
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }
}

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* cmpeq: cmpeq $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,cmpeq) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

  {
    DI opval = ((EQDI (GET_H_GR (f_left), GET_H_GR (f_right))) ? (1) : (0));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* cmpgt: cmpgt $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,cmpgt) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

  {
    DI opval = ((GTDI (GET_H_GR (f_left), GET_H_GR (f_right))) ? (1) : (0));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* cmpgtu: cmpgtu $rm,$rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,cmpgtu) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

  {
    DI opval = ((GTUDI (GET_H_GR (f_left), GET_H_GR (f_right))) ? (1) : (0));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* cmveq: cmveq $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,cmveq) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

if (EQDI (GET_H_GR (f_left), 0)) {
  {
    DI opval = GET_H_GR (f_right);
    SET_H_GR (f_dest, opval);
    written |= (1 << 2);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }
}

  abuf->written = written;
  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* cmvne: cmvne $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,cmvne) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

if (NEDI (GET_H_GR (f_left), 0)) {
  {
    DI opval = GET_H_GR (f_right);
    SET_H_GR (f_dest, opval);
    written |= (1 << 2);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }
}

  abuf->written = written;
  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* fabsd: fabs.d $drgh, $drf */

static SEM_STATUS
SEM_FN_NAME (@prefix@,fabsd) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_FABSD_VARS /* f-op f-ext f-left f-right f-left-right f-dest f-rsvd */
  EXTRACT_IFMT_FABSD_CODE

  {
    DF opval = sh64_fabsd (current_cpu, GET_H_DR (f_left_right));
    SET_H_DR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "dr", 'f', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* fabss: fabs.s $frgh, $frf */

static SEM_STATUS
SEM_FN_NAME (@prefix@,fabss) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_FABSS_VARS /* f-op f-ext f-left f-right f-left-right f-dest f-rsvd */
  EXTRACT_IFMT_FABSS_CODE

  {
    SF opval = sh64_fabss (current_cpu, CPU (h_fr[f_left_right]));
    CPU (h_fr[f_dest]) = opval;
    TRACE_RESULT (current_cpu, abuf, "fr", 'f', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* faddd: fadd.d $drg, $drh, $drf */

static SEM_STATUS
SEM_FN_NAME (@prefix@,faddd) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_FADDD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FADDD_CODE

  {
    DF opval = sh64_faddd (current_cpu, GET_H_DR (f_left), GET_H_DR (f_right));
    SET_H_DR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "dr", 'f', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* fadds: fadd.s $frg, $frh, $frf */

static SEM_STATUS
SEM_FN_NAME (@prefix@,fadds) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_FADDS_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FADDS_CODE

  {
    SF opval = sh64_fadds (current_cpu, CPU (h_fr[f_left]), CPU (h_fr[f_right]));
    CPU (h_fr[f_dest]) = opval;
    TRACE_RESULT (current_cpu, abuf, "fr", 'f', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* fcmpeqd: fcmpeq.d $drg, $drh, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,fcmpeqd) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_FCMPEQD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FCMPEQD_CODE

  {
    DI opval = ZEXTBIDI (sh64_fcmpeqd (current_cpu, GET_H_DR (f_left), GET_H_DR (f_right)));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* fcmpeqs: fcmpeq.s $frg, $frh, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,fcmpeqs) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_FCMPEQS_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FCMPEQS_CODE

  {
    DI opval = ZEXTBIDI (sh64_fcmpeqs (current_cpu, CPU (h_fr[f_left]), CPU (h_fr[f_right])));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* fcmpged: fcmpge.d $drg, $drh, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,fcmpged) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_FCMPEQD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FCMPEQD_CODE

  {
    DI opval = ZEXTBIDI (sh64_fcmpged (current_cpu, GET_H_DR (f_left), GET_H_DR (f_right)));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* fcmpges: fcmpge.s $frg, $frh, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,fcmpges) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_FCMPEQS_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FCMPEQS_CODE

  {
    DI opval = ZEXTBIDI (sh64_fcmpges (current_cpu, CPU (h_fr[f_left]), CPU (h_fr[f_right])));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* fcmpgtd: fcmpgt.d $drg, $drh, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,fcmpgtd) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_FCMPEQD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FCMPEQD_CODE

  {
    DI opval = ZEXTBIDI (sh64_fcmpgtd (current_cpu, GET_H_DR (f_left), GET_H_DR (f_right)));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* fcmpgts: fcmpgt.s $frg, $frh, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,fcmpgts) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_FCMPEQS_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FCMPEQS_CODE

  {
    DI opval = ZEXTBIDI (sh64_fcmpgts (current_cpu, CPU (h_fr[f_left]), CPU (h_fr[f_right])));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* fcmpund: fcmpun.d $drg, $drh, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,fcmpund) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_FCMPEQD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FCMPEQD_CODE

  {
    DI opval = ZEXTBIDI (sh64_fcmpund (current_cpu, GET_H_DR (f_left), GET_H_DR (f_right)));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* fcmpuns: fcmpun.s $frg, $frh, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,fcmpuns) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_FCMPEQS_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FCMPEQS_CODE

  {
    DI opval = ZEXTBIDI (sh64_fcmpuns (current_cpu, CPU (h_fr[f_left]), CPU (h_fr[f_right])));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* fcnvds: fcnv.ds $drgh, $frf */

static SEM_STATUS
SEM_FN_NAME (@prefix@,fcnvds) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_FCNVDS_VARS /* f-op f-ext f-left f-right f-left-right f-dest f-rsvd */
  EXTRACT_IFMT_FCNVDS_CODE

  {
    SF opval = sh64_fcnvds (current_cpu, GET_H_DR (f_left_right));
    CPU (h_fr[f_dest]) = opval;
    TRACE_RESULT (current_cpu, abuf, "fr", 'f', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* fcnvsd: fcnv.sd $frgh, $drf */

static SEM_STATUS
SEM_FN_NAME (@prefix@,fcnvsd) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_FCNVSD_VARS /* f-op f-ext f-left f-right f-left-right f-dest f-rsvd */
  EXTRACT_IFMT_FCNVSD_CODE

  {
    DF opval = sh64_fcnvsd (current_cpu, CPU (h_fr[f_left_right]));
    SET_H_DR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "dr", 'f', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* fdivd: fdiv.d $drg, $drh, $drf */

static SEM_STATUS
SEM_FN_NAME (@prefix@,fdivd) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_FADDD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FADDD_CODE

  {
    DF opval = sh64_fdivd (current_cpu, GET_H_DR (f_left), GET_H_DR (f_right));
    SET_H_DR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "dr", 'f', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* fdivs: fdiv.s $frg, $frh, $frf */

static SEM_STATUS
SEM_FN_NAME (@prefix@,fdivs) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_FADDS_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FADDS_CODE

  {
    SF opval = sh64_fdivs (current_cpu, CPU (h_fr[f_left]), CPU (h_fr[f_right]));
    CPU (h_fr[f_dest]) = opval;
    TRACE_RESULT (current_cpu, abuf, "fr", 'f', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* fgetscr: fgetscr $frf */

static SEM_STATUS
SEM_FN_NAME (@prefix@,fgetscr) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_FGETSCR_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FGETSCR_CODE

((void) 0); /*nop*/

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* fiprs: fipr.s $fvg, $fvh, $frf */

static SEM_STATUS
SEM_FN_NAME (@prefix@,fiprs) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_FIPRS_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FIPRS_CODE

{
  UQI tmp_g;
  UQI tmp_h;
  SF tmp_temp;
  tmp_g = f_left;
  tmp_h = f_right;
  tmp_temp = sh64_fmuls (current_cpu, CPU (h_fr[tmp_g]), CPU (h_fr[tmp_h]));
  tmp_temp = sh64_fadds (current_cpu, tmp_temp, sh64_fmuls (current_cpu, CPU (h_fr[ADDQI (tmp_g, 1)]), CPU (h_fr[ADDQI (tmp_h, 1)])));
  tmp_temp = sh64_fadds (current_cpu, tmp_temp, sh64_fmuls (current_cpu, CPU (h_fr[ADDQI (tmp_g, 2)]), CPU (h_fr[ADDQI (tmp_h, 2)])));
  tmp_temp = sh64_fadds (current_cpu, tmp_temp, sh64_fmuls (current_cpu, CPU (h_fr[ADDQI (tmp_g, 3)]), CPU (h_fr[ADDQI (tmp_h, 3)])));
  {
    SF opval = tmp_temp;
    CPU (h_fr[f_dest]) = opval;
    TRACE_RESULT (current_cpu, abuf, "fr", 'f', opval);
  }
}

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* fldd: fld.d $rm, $disp10x8, $drf */

static SEM_STATUS
SEM_FN_NAME (@prefix@,fldd) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_FLDD_VARS /* f-op f-left f-disp10x8 f-dest f-rsvd */
  EXTRACT_IFMT_FLDD_CODE

  {
    DF opval = GETMEMDF (current_cpu, pc, ADDDI (GET_H_GR (f_left), f_disp10x8));
    SET_H_DR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "dr", 'f', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* fldp: fld.p $rm, $disp10x8, $fpf */

static SEM_STATUS
SEM_FN_NAME (@prefix@,fldp) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_FLDP_VARS /* f-op f-left f-disp10x8 f-dest f-rsvd */
  EXTRACT_IFMT_FLDP_CODE

{
  QI tmp_f;
  tmp_f = f_dest;
  {
    SF opval = GETMEMSF (current_cpu, pc, ADDDI (GET_H_GR (f_left), f_disp10x8));
    CPU (h_fr[tmp_f]) = opval;
    TRACE_RESULT (current_cpu, abuf, "fr", 'f', opval);
  }
  {
    SF opval = GETMEMSF (current_cpu, pc, ADDDI (GET_H_GR (f_left), ADDSI (f_disp10x8, 4)));
    CPU (h_fr[ADDQI (tmp_f, 1)]) = opval;
    TRACE_RESULT (current_cpu, abuf, "fr", 'f', opval);
  }
}

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* flds: fld.s $rm, $disp10x4, $frf */

static SEM_STATUS
SEM_FN_NAME (@prefix@,flds) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_FLDS_VARS /* f-op f-left f-disp10x4 f-dest f-rsvd */
  EXTRACT_IFMT_FLDS_CODE

  {
    SF opval = GETMEMSF (current_cpu, pc, ADDDI (GET_H_GR (f_left), f_disp10x4));
    CPU (h_fr[f_dest]) = opval;
    TRACE_RESULT (current_cpu, abuf, "fr", 'f', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* fldxd: fldx.d $rm, $rn, $drf */

static SEM_STATUS
SEM_FN_NAME (@prefix@,fldxd) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_FLDXD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FLDXD_CODE

  {
    DF opval = GETMEMDF (current_cpu, pc, ADDDI (GET_H_GR (f_left), GET_H_GR (f_right)));
    SET_H_DR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "dr", 'f', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* fldxp: fldx.p $rm, $rn, $fpf */

static SEM_STATUS
SEM_FN_NAME (@prefix@,fldxp) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_FLDXP_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FLDXP_CODE

{
  QI tmp_f;
  tmp_f = f_dest;
  {
    SF opval = GETMEMSF (current_cpu, pc, ADDDI (GET_H_GR (f_left), GET_H_GR (f_right)));
    CPU (h_fr[tmp_f]) = opval;
    TRACE_RESULT (current_cpu, abuf, "fr", 'f', opval);
  }
  {
    SF opval = GETMEMSF (current_cpu, pc, ADDDI (GET_H_GR (f_left), ADDDI (GET_H_GR (f_right), 4)));
    CPU (h_fr[ADDQI (tmp_f, 1)]) = opval;
    TRACE_RESULT (current_cpu, abuf, "fr", 'f', opval);
  }
}

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* fldxs: fldx.s $rm, $rn, $frf */

static SEM_STATUS
SEM_FN_NAME (@prefix@,fldxs) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_FLDXD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FLDXD_CODE

  {
    SF opval = GETMEMSF (current_cpu, pc, ADDDI (GET_H_GR (f_left), GET_H_GR (f_right)));
    CPU (h_fr[f_dest]) = opval;
    TRACE_RESULT (current_cpu, abuf, "fr", 'f', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* floatld: float.ld $frgh, $drf */

static SEM_STATUS
SEM_FN_NAME (@prefix@,floatld) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_FCNVSD_VARS /* f-op f-ext f-left f-right f-left-right f-dest f-rsvd */
  EXTRACT_IFMT_FCNVSD_CODE

  {
    DF opval = sh64_floatld (current_cpu, CPU (h_fr[f_left_right]));
    SET_H_DR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "dr", 'f', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* floatls: float.ls $frgh, $frf */

static SEM_STATUS
SEM_FN_NAME (@prefix@,floatls) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_FABSS_VARS /* f-op f-ext f-left f-right f-left-right f-dest f-rsvd */
  EXTRACT_IFMT_FABSS_CODE

  {
    SF opval = sh64_floatls (current_cpu, CPU (h_fr[f_left_right]));
    CPU (h_fr[f_dest]) = opval;
    TRACE_RESULT (current_cpu, abuf, "fr", 'f', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* floatqd: float.qd $drgh, $drf */

static SEM_STATUS
SEM_FN_NAME (@prefix@,floatqd) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_FABSD_VARS /* f-op f-ext f-left f-right f-left-right f-dest f-rsvd */
  EXTRACT_IFMT_FABSD_CODE

  {
    DF opval = sh64_floatqd (current_cpu, GET_H_DR (f_left_right));
    SET_H_DR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "dr", 'f', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* floatqs: float.qs $drgh, $frf */

static SEM_STATUS
SEM_FN_NAME (@prefix@,floatqs) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_FCNVDS_VARS /* f-op f-ext f-left f-right f-left-right f-dest f-rsvd */
  EXTRACT_IFMT_FCNVDS_CODE

  {
    SF opval = sh64_floatqs (current_cpu, GET_H_DR (f_left_right));
    CPU (h_fr[f_dest]) = opval;
    TRACE_RESULT (current_cpu, abuf, "fr", 'f', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* fmacs: fmac.s $frg, $frh, $frf */

static SEM_STATUS
SEM_FN_NAME (@prefix@,fmacs) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_FADDS_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FADDS_CODE

  {
    SF opval = sh64_fadds (current_cpu, CPU (h_fr[f_dest]), sh64_fmuls (current_cpu, CPU (h_fr[f_left]), CPU (h_fr[f_right])));
    CPU (h_fr[f_dest]) = opval;
    TRACE_RESULT (current_cpu, abuf, "fr", 'f', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* fmovd: fmov.d $drgh, $drf */

static SEM_STATUS
SEM_FN_NAME (@prefix@,fmovd) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_FABSD_VARS /* f-op f-ext f-left f-right f-left-right f-dest f-rsvd */
  EXTRACT_IFMT_FABSD_CODE

  {
    DF opval = GET_H_DR (f_left_right);
    SET_H_DR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "dr", 'f', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* fmovdq: fmov.dq $drgh, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,fmovdq) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_FMOVDQ_VARS /* f-op f-ext f-left f-right f-left-right f-dest f-rsvd */
  EXTRACT_IFMT_FMOVDQ_CODE

  {
    DI opval = SUBWORDDFDI (GET_H_DR (f_left_right));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* fmovls: fmov.ls $rm, $frf */

static SEM_STATUS
SEM_FN_NAME (@prefix@,fmovls) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_FMOVLS_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FMOVLS_CODE

  {
    SF opval = SUBWORDSISF (SUBWORDDISI (GET_H_GR (f_left), 1));
    CPU (h_fr[f_dest]) = opval;
    TRACE_RESULT (current_cpu, abuf, "fr", 'f', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* fmovqd: fmov.qd $rm, $drf */

static SEM_STATUS
SEM_FN_NAME (@prefix@,fmovqd) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_FMOVLS_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FMOVLS_CODE

  {
    DF opval = SUBWORDDIDF (GET_H_GR (f_left));
    SET_H_DR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "dr", 'f', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* fmovs: fmov.s $frgh, $frf */

static SEM_STATUS
SEM_FN_NAME (@prefix@,fmovs) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_FABSS_VARS /* f-op f-ext f-left f-right f-left-right f-dest f-rsvd */
  EXTRACT_IFMT_FABSS_CODE

  {
    SF opval = CPU (h_fr[f_left_right]);
    CPU (h_fr[f_dest]) = opval;
    TRACE_RESULT (current_cpu, abuf, "fr", 'f', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* fmovsl: fmov.sl $frgh, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,fmovsl) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_FMOVSL_VARS /* f-op f-ext f-left f-right f-left-right f-dest f-rsvd */
  EXTRACT_IFMT_FMOVSL_CODE

  {
    DI opval = EXTSIDI (SUBWORDSFSI (CPU (h_fr[f_left_right])));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* fmuld: fmul.d $drg, $drh, $drf */

static SEM_STATUS
SEM_FN_NAME (@prefix@,fmuld) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_FADDD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FADDD_CODE

  {
    DF opval = sh64_fmuld (current_cpu, GET_H_DR (f_left), GET_H_DR (f_right));
    SET_H_DR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "dr", 'f', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* fmuls: fmul.s $frg, $frh, $frf */

static SEM_STATUS
SEM_FN_NAME (@prefix@,fmuls) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_FADDS_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FADDS_CODE

  {
    SF opval = sh64_fmuls (current_cpu, CPU (h_fr[f_left]), CPU (h_fr[f_right]));
    CPU (h_fr[f_dest]) = opval;
    TRACE_RESULT (current_cpu, abuf, "fr", 'f', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* fnegd: fneg.d $drgh, $drf */

static SEM_STATUS
SEM_FN_NAME (@prefix@,fnegd) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_FABSD_VARS /* f-op f-ext f-left f-right f-left-right f-dest f-rsvd */
  EXTRACT_IFMT_FABSD_CODE

  {
    DF opval = sh64_fnegd (current_cpu, GET_H_DR (f_left_right));
    SET_H_DR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "dr", 'f', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* fnegs: fneg.s $frgh, $frf */

static SEM_STATUS
SEM_FN_NAME (@prefix@,fnegs) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_FABSS_VARS /* f-op f-ext f-left f-right f-left-right f-dest f-rsvd */
  EXTRACT_IFMT_FABSS_CODE

  {
    SF opval = sh64_fnegs (current_cpu, CPU (h_fr[f_left_right]));
    CPU (h_fr[f_dest]) = opval;
    TRACE_RESULT (current_cpu, abuf, "fr", 'f', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* fputscr: fputscr $frgh */

static SEM_STATUS
SEM_FN_NAME (@prefix@,fputscr) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_FPUTSCR_VARS /* f-op f-ext f-left f-right f-left-right f-dest f-rsvd */
  EXTRACT_IFMT_FPUTSCR_CODE

((void) 0); /*nop*/

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* fsqrtd: fsqrt.d $drgh, $drf */

static SEM_STATUS
SEM_FN_NAME (@prefix@,fsqrtd) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_FABSD_VARS /* f-op f-ext f-left f-right f-left-right f-dest f-rsvd */
  EXTRACT_IFMT_FABSD_CODE

  {
    DF opval = sh64_fsqrtd (current_cpu, GET_H_DR (f_left_right));
    SET_H_DR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "dr", 'f', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* fsqrts: fsqrt.s $frgh, $frf */

static SEM_STATUS
SEM_FN_NAME (@prefix@,fsqrts) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_FABSS_VARS /* f-op f-ext f-left f-right f-left-right f-dest f-rsvd */
  EXTRACT_IFMT_FABSS_CODE

  {
    SF opval = sh64_fsqrts (current_cpu, CPU (h_fr[f_left_right]));
    CPU (h_fr[f_dest]) = opval;
    TRACE_RESULT (current_cpu, abuf, "fr", 'f', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* fstd: fst.d $rm, $disp10x8, $drf */

static SEM_STATUS
SEM_FN_NAME (@prefix@,fstd) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_FLDD_VARS /* f-op f-left f-disp10x8 f-dest f-rsvd */
  EXTRACT_IFMT_FLDD_CODE

  {
    DF opval = GET_H_DR (f_dest);
    SETMEMDF (current_cpu, pc, ADDDI (GET_H_GR (f_left), f_disp10x8), opval);
    TRACE_RESULT (current_cpu, abuf, "memory", 'f', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* fstp: fst.p $rm, $disp10x8, $fpf */

static SEM_STATUS
SEM_FN_NAME (@prefix@,fstp) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_FLDP_VARS /* f-op f-left f-disp10x8 f-dest f-rsvd */
  EXTRACT_IFMT_FLDP_CODE

{
  QI tmp_f;
  tmp_f = f_dest;
  {
    SF opval = CPU (h_fr[tmp_f]);
    SETMEMSF (current_cpu, pc, ADDDI (GET_H_GR (f_left), f_disp10x8), opval);
    TRACE_RESULT (current_cpu, abuf, "memory", 'f', opval);
  }
  {
    SF opval = CPU (h_fr[ADDQI (tmp_f, 1)]);
    SETMEMSF (current_cpu, pc, ADDDI (GET_H_GR (f_left), ADDSI (f_disp10x8, 4)), opval);
    TRACE_RESULT (current_cpu, abuf, "memory", 'f', opval);
  }
}

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* fsts: fst.s $rm, $disp10x4, $frf */

static SEM_STATUS
SEM_FN_NAME (@prefix@,fsts) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_FLDS_VARS /* f-op f-left f-disp10x4 f-dest f-rsvd */
  EXTRACT_IFMT_FLDS_CODE

  {
    SF opval = CPU (h_fr[f_dest]);
    SETMEMSF (current_cpu, pc, ADDDI (GET_H_GR (f_left), f_disp10x4), opval);
    TRACE_RESULT (current_cpu, abuf, "memory", 'f', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* fstxd: fstx.d $rm, $rn, $drf */

static SEM_STATUS
SEM_FN_NAME (@prefix@,fstxd) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_FSTXD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FSTXD_CODE

  {
    DF opval = GET_H_DR (f_dest);
    SETMEMDF (current_cpu, pc, ADDDI (GET_H_GR (f_left), GET_H_GR (f_right)), opval);
    TRACE_RESULT (current_cpu, abuf, "memory", 'f', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* fstxp: fstx.p $rm, $rn, $fpf */

static SEM_STATUS
SEM_FN_NAME (@prefix@,fstxp) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_FLDXP_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FLDXP_CODE

{
  QI tmp_f;
  tmp_f = f_dest;
  {
    SF opval = CPU (h_fr[tmp_f]);
    SETMEMSF (current_cpu, pc, ADDDI (GET_H_GR (f_left), GET_H_GR (f_right)), opval);
    TRACE_RESULT (current_cpu, abuf, "memory", 'f', opval);
  }
  {
    SF opval = CPU (h_fr[ADDQI (tmp_f, 1)]);
    SETMEMSF (current_cpu, pc, ADDDI (GET_H_GR (f_left), ADDDI (GET_H_GR (f_right), 4)), opval);
    TRACE_RESULT (current_cpu, abuf, "memory", 'f', opval);
  }
}

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* fstxs: fstx.s $rm, $rn, $frf */

static SEM_STATUS
SEM_FN_NAME (@prefix@,fstxs) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_FLDXD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FLDXD_CODE

  {
    SF opval = CPU (h_fr[f_dest]);
    SETMEMSF (current_cpu, pc, ADDDI (GET_H_GR (f_left), GET_H_GR (f_right)), opval);
    TRACE_RESULT (current_cpu, abuf, "memory", 'f', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* fsubd: fsub.d $drg, $drh, $drf */

static SEM_STATUS
SEM_FN_NAME (@prefix@,fsubd) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_FADDS_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FADDS_CODE

  {
    DF opval = sh64_fsubd (current_cpu, GET_H_DR (f_left), GET_H_DR (f_right));
    SET_H_DR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "dr", 'f', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* fsubs: fsub.s $frg, $frh, $frf */

static SEM_STATUS
SEM_FN_NAME (@prefix@,fsubs) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_FADDS_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FADDS_CODE

  {
    SF opval = sh64_fsubs (current_cpu, CPU (h_fr[f_left]), CPU (h_fr[f_right]));
    CPU (h_fr[f_dest]) = opval;
    TRACE_RESULT (current_cpu, abuf, "fr", 'f', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* ftrcdl: ftrc.dl $drgh, $frf */

static SEM_STATUS
SEM_FN_NAME (@prefix@,ftrcdl) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_FCNVDS_VARS /* f-op f-ext f-left f-right f-left-right f-dest f-rsvd */
  EXTRACT_IFMT_FCNVDS_CODE

  {
    SF opval = sh64_ftrcdl (current_cpu, GET_H_DR (f_left_right));
    CPU (h_fr[f_dest]) = opval;
    TRACE_RESULT (current_cpu, abuf, "fr", 'f', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* ftrcsl: ftrc.sl $frgh, $frf */

static SEM_STATUS
SEM_FN_NAME (@prefix@,ftrcsl) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_FABSS_VARS /* f-op f-ext f-left f-right f-left-right f-dest f-rsvd */
  EXTRACT_IFMT_FABSS_CODE

  {
    SF opval = sh64_ftrcsl (current_cpu, CPU (h_fr[f_left_right]));
    CPU (h_fr[f_dest]) = opval;
    TRACE_RESULT (current_cpu, abuf, "fr", 'f', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* ftrcdq: ftrc.dq $drgh, $drf */

static SEM_STATUS
SEM_FN_NAME (@prefix@,ftrcdq) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_FCNVDS_VARS /* f-op f-ext f-left f-right f-left-right f-dest f-rsvd */
  EXTRACT_IFMT_FCNVDS_CODE

  {
    DF opval = sh64_ftrcdq (current_cpu, GET_H_DR (f_left_right));
    SET_H_DR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "dr", 'f', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* ftrcsq: ftrc.sq $frgh, $drf */

static SEM_STATUS
SEM_FN_NAME (@prefix@,ftrcsq) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_FCNVSD_VARS /* f-op f-ext f-left f-right f-left-right f-dest f-rsvd */
  EXTRACT_IFMT_FCNVSD_CODE

  {
    DF opval = sh64_ftrcsq (current_cpu, CPU (h_fr[f_left_right]));
    SET_H_DR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "dr", 'f', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* ftrvs: ftrv.s $mtrxg, $fvh, $fvf */

static SEM_STATUS
SEM_FN_NAME (@prefix@,ftrvs) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_FTRVS_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_FTRVS_CODE

sh64_ftrvs (current_cpu, f_left, f_right, f_dest);

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* getcfg: getcfg $rm, $disp6, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,getcfg) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_GETCFG_VARS /* f-op f-left f-ext f-disp6 f-dest f-rsvd */
  EXTRACT_IFMT_GETCFG_CODE

((void) 0); /*nop*/

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* getcon: getcon $crk, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,getcon) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_GETCON_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_GETCON_CODE

  {
    DI opval = GET_H_CR (f_left);
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* gettr: gettr $trb, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,gettr) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_BLINK_VARS /* f-op f-25 f-trb f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_BLINK_CODE

  {
    DI opval = CPU (h_tr[f_trb]);
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* icbi: icbi $rm, $disp6x32 */

static SEM_STATUS
SEM_FN_NAME (@prefix@,icbi) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ALLOCO_VARS /* f-op f-left f-ext f-disp6x32 f-dest f-rsvd */
  EXTRACT_IFMT_ALLOCO_CODE

((void) 0); /*nop*/

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* ldb: ld.b $rm, $disp10, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,ldb) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADDI_VARS /* f-op f-left f-disp10 f-dest f-rsvd */
  EXTRACT_IFMT_ADDI_CODE

if (NESI (f_rsvd, 63)) {
  {
    DI opval = EXTQIDI (GETMEMQI (current_cpu, pc, ADDDI (GET_H_GR (f_left), EXTSIDI (f_disp10))));
    SET_H_GR (f_dest, opval);
    written |= (1 << 4);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }
}

  abuf->written = written;
  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* ldl: ld.l $rm, $disp10x4, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,ldl) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_LDL_VARS /* f-op f-left f-disp10x4 f-dest f-rsvd */
  EXTRACT_IFMT_LDL_CODE

  {
    DI opval = EXTSIDI (GETMEMSI (current_cpu, pc, ADDDI (GET_H_GR (f_left), EXTSIDI (f_disp10x4))));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* ldq: ld.q $rm, $disp10x8, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,ldq) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_LDQ_VARS /* f-op f-left f-disp10x8 f-dest f-rsvd */
  EXTRACT_IFMT_LDQ_CODE

  {
    DI opval = GETMEMDI (current_cpu, pc, ADDDI (GET_H_GR (f_left), EXTSIDI (f_disp10x8)));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* ldub: ld.ub $rm, $disp10, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,ldub) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADDI_VARS /* f-op f-left f-disp10 f-dest f-rsvd */
  EXTRACT_IFMT_ADDI_CODE

  {
    DI opval = ZEXTQIDI (GETMEMQI (current_cpu, pc, ADDDI (GET_H_GR (f_left), EXTSIDI (f_disp10))));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* lduw: ld.uw $rm, $disp10x2, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,lduw) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADDI_VARS /* f-op f-left f-disp10 f-dest f-rsvd */
  EXTRACT_IFMT_ADDI_CODE

  {
    DI opval = ZEXTHIDI (GETMEMHI (current_cpu, pc, ADDDI (GET_H_GR (f_left), EXTSIDI (f_disp10x2))));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* ldw: ld.w $rm, $disp10x2, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,ldw) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADDI_VARS /* f-op f-left f-disp10 f-dest f-rsvd */
  EXTRACT_IFMT_ADDI_CODE

  {
    DI opval = EXTHIDI (GETMEMHI (current_cpu, pc, ADDDI (GET_H_GR (f_left), EXTSIDI (f_disp10x2))));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* ldhil: ldhi.l $rm, $disp6, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,ldhil) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_GETCFG_VARS /* f-op f-left f-ext f-disp6 f-dest f-rsvd */
  EXTRACT_IFMT_GETCFG_CODE

{
  DI tmp_addr;
  QI tmp_bytecount;
  SI tmp_val;
  tmp_addr = ADDDI (GET_H_GR (f_left), f_disp6);
  tmp_bytecount = ADDDI (ANDDI (tmp_addr, 3), 1);
  tmp_val = 0;
if (ANDQI (tmp_bytecount, 4)) {
  {
    DI opval = EXTSIDI (GETMEMSI (current_cpu, pc, ANDDI (tmp_addr, -4)));
    SET_H_GR (f_dest, opval);
    written |= (1 << 6);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }
} else {
if (GET_H_ENDIAN ()) {
{
if (ANDQI (tmp_bytecount, 2)) {
  tmp_val = ADDSI (SLLSI (tmp_val, 16), ZEXTHIDI (GETMEMHI (current_cpu, pc, ANDDI (tmp_addr, -4))));
}
if (ANDQI (tmp_bytecount, 1)) {
  tmp_val = ADDSI (SLLSI (tmp_val, 8), ZEXTQIDI (GETMEMQI (current_cpu, pc, tmp_addr)));
}
  {
    DI opval = EXTSIDI (tmp_val);
    SET_H_GR (f_dest, opval);
    written |= (1 << 6);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }
}
} else {
{
if (ANDQI (tmp_bytecount, 1)) {
  tmp_val = ADDSI (SLLSI (tmp_val, 8), ZEXTQIDI (GETMEMQI (current_cpu, pc, tmp_addr)));
}
if (ANDQI (tmp_bytecount, 2)) {
  tmp_val = ADDSI (SLLSI (tmp_val, 16), ZEXTHIDI (GETMEMHI (current_cpu, pc, ANDDI (tmp_addr, -4))));
}
  {
    DI opval = EXTSIDI (SLLSI (tmp_val, SUBSI (32, MULSI (8, tmp_bytecount))));
    SET_H_GR (f_dest, opval);
    written |= (1 << 6);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }
}
}
}
}

  abuf->written = written;
  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* ldhiq: ldhi.q $rm, $disp6, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,ldhiq) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_GETCFG_VARS /* f-op f-left f-ext f-disp6 f-dest f-rsvd */
  EXTRACT_IFMT_GETCFG_CODE

{
  DI tmp_addr;
  QI tmp_bytecount;
  DI tmp_val;
  tmp_addr = ADDDI (GET_H_GR (f_left), f_disp6);
  tmp_bytecount = ADDDI (ANDDI (tmp_addr, 7), 1);
  tmp_val = 0;
if (ANDQI (tmp_bytecount, 8)) {
  {
    DI opval = GETMEMDI (current_cpu, pc, ANDDI (tmp_addr, -8));
    SET_H_GR (f_dest, opval);
    written |= (1 << 7);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }
} else {
if (GET_H_ENDIAN ()) {
{
if (ANDQI (tmp_bytecount, 4)) {
  tmp_val = ADDDI (SLLDI (tmp_val, 32), ZEXTSIDI (GETMEMSI (current_cpu, pc, ANDDI (tmp_addr, -8))));
}
if (ANDQI (tmp_bytecount, 2)) {
  tmp_val = ADDDI (SLLDI (tmp_val, 16), ZEXTHIDI (GETMEMHI (current_cpu, pc, ANDDI (tmp_addr, -4))));
}
if (ANDQI (tmp_bytecount, 1)) {
  tmp_val = ADDDI (SLLDI (tmp_val, 8), ZEXTQIDI (GETMEMQI (current_cpu, pc, tmp_addr)));
}
  {
    DI opval = tmp_val;
    SET_H_GR (f_dest, opval);
    written |= (1 << 7);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }
}
} else {
{
if (ANDQI (tmp_bytecount, 1)) {
  tmp_val = ADDDI (SLLDI (tmp_val, 8), ZEXTQIDI (GETMEMQI (current_cpu, pc, tmp_addr)));
}
if (ANDQI (tmp_bytecount, 2)) {
  tmp_val = ADDDI (SLLDI (tmp_val, 16), ZEXTHIDI (GETMEMHI (current_cpu, pc, ANDDI (tmp_addr, -4))));
}
if (ANDQI (tmp_bytecount, 4)) {
  tmp_val = ADDDI (SLLDI (tmp_val, 32), ZEXTSIDI (GETMEMSI (current_cpu, pc, ANDDI (tmp_addr, -8))));
}
  {
    DI opval = SLLDI (tmp_val, SUBSI (64, MULSI (8, tmp_bytecount)));
    SET_H_GR (f_dest, opval);
    written |= (1 << 7);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }
}
}
}
}

  abuf->written = written;
  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* ldlol: ldlo.l $rm, $disp6, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,ldlol) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_GETCFG_VARS /* f-op f-left f-ext f-disp6 f-dest f-rsvd */
  EXTRACT_IFMT_GETCFG_CODE

{
  DI tmp_addr;
  QI tmp_bytecount;
  SI tmp_val;
  tmp_addr = ADDDI (GET_H_GR (f_left), f_disp6);
  tmp_bytecount = SUBSI (4, ANDDI (tmp_addr, 3));
  tmp_val = 0;
if (ANDQI (tmp_bytecount, 4)) {
  {
    DI opval = EXTSIDI (GETMEMSI (current_cpu, pc, tmp_addr));
    SET_H_GR (f_dest, opval);
    written |= (1 << 6);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }
} else {
if (GET_H_ENDIAN ()) {
{
if (ANDQI (tmp_bytecount, 1)) {
  tmp_val = ADDSI (SLLSI (tmp_val, 8), ZEXTQIDI (GETMEMQI (current_cpu, pc, tmp_addr)));
}
if (ANDQI (tmp_bytecount, 2)) {
  tmp_val = ADDSI (SLLSI (tmp_val, 16), ZEXTHIDI (GETMEMHI (current_cpu, pc, ANDDI (ADDDI (tmp_addr, 1), -2))));
}
  {
    DI opval = EXTSIDI (SLLSI (tmp_val, SUBSI (32, MULSI (8, tmp_bytecount))));
    SET_H_GR (f_dest, opval);
    written |= (1 << 6);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }
}
} else {
{
if (ANDQI (tmp_bytecount, 2)) {
  tmp_val = ADDSI (SLLSI (tmp_val, 16), ZEXTHIDI (GETMEMHI (current_cpu, pc, ANDDI (ADDDI (tmp_addr, 1), -2))));
}
if (ANDQI (tmp_bytecount, 1)) {
  tmp_val = ADDSI (SLLSI (tmp_val, 8), ZEXTQIDI (GETMEMQI (current_cpu, pc, tmp_addr)));
}
  {
    DI opval = EXTSIDI (tmp_val);
    SET_H_GR (f_dest, opval);
    written |= (1 << 6);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }
}
}
}
}

  abuf->written = written;
  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* ldloq: ldlo.q $rm, $disp6, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,ldloq) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_GETCFG_VARS /* f-op f-left f-ext f-disp6 f-dest f-rsvd */
  EXTRACT_IFMT_GETCFG_CODE

{
  DI tmp_addr;
  QI tmp_bytecount;
  DI tmp_val;
  tmp_addr = ADDDI (GET_H_GR (f_left), f_disp6);
  tmp_bytecount = SUBSI (8, ANDDI (tmp_addr, 7));
  tmp_val = 0;
if (ANDQI (tmp_bytecount, 8)) {
  {
    DI opval = GETMEMDI (current_cpu, pc, tmp_addr);
    SET_H_GR (f_dest, opval);
    written |= (1 << 7);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }
} else {
if (GET_H_ENDIAN ()) {
{
if (ANDQI (tmp_bytecount, 1)) {
  tmp_val = ADDDI (SLLDI (tmp_val, 8), ZEXTQIDI (GETMEMQI (current_cpu, pc, tmp_addr)));
}
if (ANDQI (tmp_bytecount, 2)) {
  tmp_val = ADDDI (SLLDI (tmp_val, 16), ZEXTHIDI (GETMEMHI (current_cpu, pc, ANDDI (ADDDI (tmp_addr, 1), -2))));
}
if (ANDQI (tmp_bytecount, 4)) {
  tmp_val = ADDDI (SLLDI (tmp_val, 32), ZEXTSIDI (GETMEMSI (current_cpu, pc, ANDDI (ADDDI (tmp_addr, 3), -4))));
}
  {
    DI opval = SLLDI (tmp_val, SUBSI (64, MULSI (8, tmp_bytecount)));
    SET_H_GR (f_dest, opval);
    written |= (1 << 7);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }
}
} else {
{
if (ANDQI (tmp_bytecount, 4)) {
  tmp_val = ADDDI (SLLDI (tmp_val, 32), ZEXTSIDI (GETMEMSI (current_cpu, pc, ANDDI (ADDDI (tmp_addr, 3), -4))));
}
if (ANDQI (tmp_bytecount, 2)) {
  tmp_val = ADDDI (SLLDI (tmp_val, 16), ZEXTHIDI (GETMEMHI (current_cpu, pc, ANDDI (ADDDI (tmp_addr, 1), -2))));
}
if (ANDQI (tmp_bytecount, 1)) {
  tmp_val = ADDDI (SLLDI (tmp_val, 8), ZEXTQIDI (GETMEMQI (current_cpu, pc, tmp_addr)));
}
  {
    DI opval = tmp_val;
    SET_H_GR (f_dest, opval);
    written |= (1 << 7);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }
}
}
}
}

  abuf->written = written;
  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* ldxb: ldx.b $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,ldxb) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

  {
    DI opval = EXTQIDI (GETMEMQI (current_cpu, pc, ADDDI (GET_H_GR (f_left), GET_H_GR (f_right))));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* ldxl: ldx.l $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,ldxl) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

  {
    DI opval = EXTSIDI (GETMEMSI (current_cpu, pc, ADDDI (GET_H_GR (f_left), GET_H_GR (f_right))));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* ldxq: ldx.q $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,ldxq) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

  {
    DI opval = GETMEMDI (current_cpu, pc, ADDDI (GET_H_GR (f_left), GET_H_GR (f_right)));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* ldxub: ldx.ub $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,ldxub) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

  {
    DI opval = ZEXTQIDI (GETMEMUQI (current_cpu, pc, ADDDI (GET_H_GR (f_left), GET_H_GR (f_right))));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* ldxuw: ldx.uw $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,ldxuw) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

  {
    DI opval = ZEXTHIDI (GETMEMUHI (current_cpu, pc, ADDDI (GET_H_GR (f_left), GET_H_GR (f_right))));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* ldxw: ldx.w $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,ldxw) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

  {
    DI opval = EXTHIDI (GETMEMHI (current_cpu, pc, ADDDI (GET_H_GR (f_left), GET_H_GR (f_right))));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* mabsl: mabs.l $rm, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,mabsl) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_BYTEREV_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_BYTEREV_CODE

{
  SI tmp_result1;
  SI tmp_result0;
  tmp_result0 = ABSSI (SUBWORDDISI (GET_H_GR (f_left), 1));
  tmp_result1 = ABSSI (SUBWORDDISI (GET_H_GR (f_left), 0));
  {
    DI opval = ORDI (SLLDI (ZEXTSIDI (tmp_result1), 32), ZEXTSIDI (tmp_result0));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }
}

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* mabsw: mabs.w $rm, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,mabsw) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_BYTEREV_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_BYTEREV_CODE

{
  HI tmp_result3;
  HI tmp_result2;
  HI tmp_result1;
  HI tmp_result0;
  tmp_result0 = ABSHI (SUBWORDDIHI (GET_H_GR (f_left), 3));
  tmp_result1 = ABSHI (SUBWORDDIHI (GET_H_GR (f_left), 2));
  tmp_result2 = ABSHI (SUBWORDDIHI (GET_H_GR (f_left), 1));
  tmp_result3 = ABSHI (SUBWORDDIHI (GET_H_GR (f_left), 0));
  {
    DI opval = ORDI (SLLDI (ZEXTHIDI (tmp_result3), 48), ORDI (SLLDI (ZEXTHIDI (tmp_result2), 32), ORDI (SLLDI (ZEXTHIDI (tmp_result1), 16), ZEXTHIDI (tmp_result0))));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }
}

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* maddl: madd.l $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,maddl) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

{
  SI tmp_result1;
  SI tmp_result0;
  tmp_result0 = ADDSI (SUBWORDDISI (GET_H_GR (f_left), 1), SUBWORDDISI (GET_H_GR (f_right), 1));
  tmp_result1 = ADDSI (SUBWORDDISI (GET_H_GR (f_left), 0), SUBWORDDISI (GET_H_GR (f_right), 0));
  {
    DI opval = ORDI (SLLDI (ZEXTSIDI (tmp_result1), 32), ZEXTSIDI (tmp_result0));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }
}

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* maddw: madd.w $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,maddw) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

{
  HI tmp_result3;
  HI tmp_result2;
  HI tmp_result1;
  HI tmp_result0;
  tmp_result0 = ADDHI (SUBWORDDIHI (GET_H_GR (f_left), 3), SUBWORDDIHI (GET_H_GR (f_right), 3));
  tmp_result1 = ADDHI (SUBWORDDIHI (GET_H_GR (f_left), 2), SUBWORDDIHI (GET_H_GR (f_right), 2));
  tmp_result2 = ADDHI (SUBWORDDIHI (GET_H_GR (f_left), 1), SUBWORDDIHI (GET_H_GR (f_right), 1));
  tmp_result3 = ADDHI (SUBWORDDIHI (GET_H_GR (f_left), 0), SUBWORDDIHI (GET_H_GR (f_right), 0));
  {
    DI opval = ORDI (SLLDI (ZEXTHIDI (tmp_result3), 48), ORDI (SLLDI (ZEXTHIDI (tmp_result2), 32), ORDI (SLLDI (ZEXTHIDI (tmp_result1), 16), ZEXTHIDI (tmp_result0))));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }
}

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* maddsl: madds.l $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,maddsl) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

{
  SI tmp_result1;
  SI tmp_result0;
  tmp_result0 = ((LTDI (ADDDI (EXTSIDI (SUBWORDDISI (GET_H_GR (f_left), 1)), EXTSIDI (SUBWORDDISI (GET_H_GR (f_right), 1))), NEGDI (SLLDI (1, SUBSI (32, 1))))) ? (NEGSI (SLLSI (1, SUBSI (32, 1)))) : (((LTDI (ADDDI (EXTSIDI (SUBWORDDISI (GET_H_GR (f_left), 1)), EXTSIDI (SUBWORDDISI (GET_H_GR (f_right), 1))), SLLDI (1, SUBSI (32, 1)))) ? (ADDDI (EXTSIDI (SUBWORDDISI (GET_H_GR (f_left), 1)), EXTSIDI (SUBWORDDISI (GET_H_GR (f_right), 1)))) : (SUBSI (SLLSI (1, SUBSI (32, 1)), 1)))));
  tmp_result1 = ((LTDI (ADDDI (EXTSIDI (SUBWORDDISI (GET_H_GR (f_left), 0)), EXTSIDI (SUBWORDDISI (GET_H_GR (f_right), 0))), NEGDI (SLLDI (1, SUBSI (32, 1))))) ? (NEGSI (SLLSI (1, SUBSI (32, 1)))) : (((LTDI (ADDDI (EXTSIDI (SUBWORDDISI (GET_H_GR (f_left), 0)), EXTSIDI (SUBWORDDISI (GET_H_GR (f_right), 0))), SLLDI (1, SUBSI (32, 1)))) ? (ADDDI (EXTSIDI (SUBWORDDISI (GET_H_GR (f_left), 0)), EXTSIDI (SUBWORDDISI (GET_H_GR (f_right), 0)))) : (SUBSI (SLLSI (1, SUBSI (32, 1)), 1)))));
  {
    DI opval = ORDI (SLLDI (ZEXTSIDI (tmp_result1), 32), ZEXTSIDI (tmp_result0));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }
}

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* maddsub: madds.ub $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,maddsub) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

{
  QI tmp_result7;
  QI tmp_result6;
  QI tmp_result5;
  QI tmp_result4;
  QI tmp_result3;
  QI tmp_result2;
  QI tmp_result1;
  QI tmp_result0;
  tmp_result0 = ((LTDI (ADDDI (ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_left), 7)), ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_right), 7))), MAKEDI (0, 0))) ? (0) : (((LTDI (ADDDI (ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_left), 7)), ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_right), 7))), SLLDI (1, 8))) ? (ADDDI (ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_left), 7)), ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_right), 7)))) : (SUBQI (SLLQI (1, 8), 1)))));
  tmp_result1 = ((LTDI (ADDDI (ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_left), 6)), ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_right), 6))), MAKEDI (0, 0))) ? (0) : (((LTDI (ADDDI (ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_left), 6)), ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_right), 6))), SLLDI (1, 8))) ? (ADDDI (ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_left), 6)), ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_right), 6)))) : (SUBQI (SLLQI (1, 8), 1)))));
  tmp_result2 = ((LTDI (ADDDI (ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_left), 5)), ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_right), 5))), MAKEDI (0, 0))) ? (0) : (((LTDI (ADDDI (ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_left), 5)), ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_right), 5))), SLLDI (1, 8))) ? (ADDDI (ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_left), 5)), ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_right), 5)))) : (SUBQI (SLLQI (1, 8), 1)))));
  tmp_result3 = ((LTDI (ADDDI (ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_left), 4)), ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_right), 4))), MAKEDI (0, 0))) ? (0) : (((LTDI (ADDDI (ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_left), 4)), ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_right), 4))), SLLDI (1, 8))) ? (ADDDI (ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_left), 4)), ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_right), 4)))) : (SUBQI (SLLQI (1, 8), 1)))));
  tmp_result4 = ((LTDI (ADDDI (ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_left), 3)), ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_right), 3))), MAKEDI (0, 0))) ? (0) : (((LTDI (ADDDI (ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_left), 3)), ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_right), 3))), SLLDI (1, 8))) ? (ADDDI (ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_left), 3)), ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_right), 3)))) : (SUBQI (SLLQI (1, 8), 1)))));
  tmp_result5 = ((LTDI (ADDDI (ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_left), 2)), ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_right), 2))), MAKEDI (0, 0))) ? (0) : (((LTDI (ADDDI (ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_left), 2)), ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_right), 2))), SLLDI (1, 8))) ? (ADDDI (ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_left), 2)), ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_right), 2)))) : (SUBQI (SLLQI (1, 8), 1)))));
  tmp_result6 = ((LTDI (ADDDI (ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_left), 1)), ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_right), 1))), MAKEDI (0, 0))) ? (0) : (((LTDI (ADDDI (ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_left), 1)), ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_right), 1))), SLLDI (1, 8))) ? (ADDDI (ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_left), 1)), ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_right), 1)))) : (SUBQI (SLLQI (1, 8), 1)))));
  tmp_result7 = ((LTDI (ADDDI (ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_left), 0)), ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_right), 0))), MAKEDI (0, 0))) ? (0) : (((LTDI (ADDDI (ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_left), 0)), ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_right), 0))), SLLDI (1, 8))) ? (ADDDI (ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_left), 0)), ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_right), 0)))) : (SUBQI (SLLQI (1, 8), 1)))));
  {
    DI opval = ORDI (SLLDI (ZEXTQIDI (tmp_result7), 56), ORDI (SLLDI (ZEXTQIDI (tmp_result6), 48), ORDI (SLLDI (ZEXTQIDI (tmp_result5), 40), ORDI (SLLDI (ZEXTQIDI (tmp_result4), 32), ORDI (SLLDI (ZEXTQIDI (tmp_result3), 24), ORDI (SLLDI (ZEXTQIDI (tmp_result2), 16), ORDI (SLLDI (ZEXTQIDI (tmp_result1), 8), ZEXTQIDI (tmp_result0))))))));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }
}

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* maddsw: madds.w $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,maddsw) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

{
  HI tmp_result3;
  HI tmp_result2;
  HI tmp_result1;
  HI tmp_result0;
  tmp_result0 = ((LTDI (ADDDI (EXTHIDI (SUBWORDDIHI (GET_H_GR (f_left), 3)), EXTHIDI (SUBWORDDIHI (GET_H_GR (f_right), 3))), NEGDI (SLLDI (1, SUBSI (16, 1))))) ? (NEGHI (SLLHI (1, SUBSI (16, 1)))) : (((LTDI (ADDDI (EXTHIDI (SUBWORDDIHI (GET_H_GR (f_left), 3)), EXTHIDI (SUBWORDDIHI (GET_H_GR (f_right), 3))), SLLDI (1, SUBSI (16, 1)))) ? (ADDDI (EXTHIDI (SUBWORDDIHI (GET_H_GR (f_left), 3)), EXTHIDI (SUBWORDDIHI (GET_H_GR (f_right), 3)))) : (SUBHI (SLLHI (1, SUBSI (16, 1)), 1)))));
  tmp_result1 = ((LTDI (ADDDI (EXTHIDI (SUBWORDDIHI (GET_H_GR (f_left), 2)), EXTHIDI (SUBWORDDIHI (GET_H_GR (f_right), 2))), NEGDI (SLLDI (1, SUBSI (16, 1))))) ? (NEGHI (SLLHI (1, SUBSI (16, 1)))) : (((LTDI (ADDDI (EXTHIDI (SUBWORDDIHI (GET_H_GR (f_left), 2)), EXTHIDI (SUBWORDDIHI (GET_H_GR (f_right), 2))), SLLDI (1, SUBSI (16, 1)))) ? (ADDDI (EXTHIDI (SUBWORDDIHI (GET_H_GR (f_left), 2)), EXTHIDI (SUBWORDDIHI (GET_H_GR (f_right), 2)))) : (SUBHI (SLLHI (1, SUBSI (16, 1)), 1)))));
  tmp_result2 = ((LTDI (ADDDI (EXTHIDI (SUBWORDDIHI (GET_H_GR (f_left), 1)), EXTHIDI (SUBWORDDIHI (GET_H_GR (f_right), 1))), NEGDI (SLLDI (1, SUBSI (16, 1))))) ? (NEGHI (SLLHI (1, SUBSI (16, 1)))) : (((LTDI (ADDDI (EXTHIDI (SUBWORDDIHI (GET_H_GR (f_left), 1)), EXTHIDI (SUBWORDDIHI (GET_H_GR (f_right), 1))), SLLDI (1, SUBSI (16, 1)))) ? (ADDDI (EXTHIDI (SUBWORDDIHI (GET_H_GR (f_left), 1)), EXTHIDI (SUBWORDDIHI (GET_H_GR (f_right), 1)))) : (SUBHI (SLLHI (1, SUBSI (16, 1)), 1)))));
  tmp_result3 = ((LTDI (ADDDI (EXTHIDI (SUBWORDDIHI (GET_H_GR (f_left), 0)), EXTHIDI (SUBWORDDIHI (GET_H_GR (f_right), 0))), NEGDI (SLLDI (1, SUBSI (16, 1))))) ? (NEGHI (SLLHI (1, SUBSI (16, 1)))) : (((LTDI (ADDDI (EXTHIDI (SUBWORDDIHI (GET_H_GR (f_left), 0)), EXTHIDI (SUBWORDDIHI (GET_H_GR (f_right), 0))), SLLDI (1, SUBSI (16, 1)))) ? (ADDDI (EXTHIDI (SUBWORDDIHI (GET_H_GR (f_left), 0)), EXTHIDI (SUBWORDDIHI (GET_H_GR (f_right), 0)))) : (SUBHI (SLLHI (1, SUBSI (16, 1)), 1)))));
  {
    DI opval = ORDI (SLLDI (ZEXTHIDI (tmp_result3), 48), ORDI (SLLDI (ZEXTHIDI (tmp_result2), 32), ORDI (SLLDI (ZEXTHIDI (tmp_result1), 16), ZEXTHIDI (tmp_result0))));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }
}

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* mcmpeqb: mcmpeq.b $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,mcmpeqb) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

{
  QI tmp_result7;
  QI tmp_result6;
  QI tmp_result5;
  QI tmp_result4;
  QI tmp_result3;
  QI tmp_result2;
  QI tmp_result1;
  QI tmp_result0;
  tmp_result0 = ((EQQI (SUBWORDDIQI (GET_H_GR (f_left), 7), SUBWORDDIQI (GET_H_GR (f_right), 7))) ? (INVQI (0)) : (0));
  tmp_result1 = ((EQQI (SUBWORDDIQI (GET_H_GR (f_left), 6), SUBWORDDIQI (GET_H_GR (f_right), 6))) ? (INVQI (0)) : (0));
  tmp_result2 = ((EQQI (SUBWORDDIQI (GET_H_GR (f_left), 5), SUBWORDDIQI (GET_H_GR (f_right), 5))) ? (INVQI (0)) : (0));
  tmp_result3 = ((EQQI (SUBWORDDIQI (GET_H_GR (f_left), 4), SUBWORDDIQI (GET_H_GR (f_right), 4))) ? (INVQI (0)) : (0));
  tmp_result4 = ((EQQI (SUBWORDDIQI (GET_H_GR (f_left), 3), SUBWORDDIQI (GET_H_GR (f_right), 3))) ? (INVQI (0)) : (0));
  tmp_result5 = ((EQQI (SUBWORDDIQI (GET_H_GR (f_left), 2), SUBWORDDIQI (GET_H_GR (f_right), 2))) ? (INVQI (0)) : (0));
  tmp_result6 = ((EQQI (SUBWORDDIQI (GET_H_GR (f_left), 1), SUBWORDDIQI (GET_H_GR (f_right), 1))) ? (INVQI (0)) : (0));
  tmp_result7 = ((EQQI (SUBWORDDIQI (GET_H_GR (f_left), 0), SUBWORDDIQI (GET_H_GR (f_right), 0))) ? (INVQI (0)) : (0));
  {
    DI opval = ORDI (SLLDI (ZEXTQIDI (tmp_result7), 56), ORDI (SLLDI (ZEXTQIDI (tmp_result6), 48), ORDI (SLLDI (ZEXTQIDI (tmp_result5), 40), ORDI (SLLDI (ZEXTQIDI (tmp_result4), 32), ORDI (SLLDI (ZEXTQIDI (tmp_result3), 24), ORDI (SLLDI (ZEXTQIDI (tmp_result2), 16), ORDI (SLLDI (ZEXTQIDI (tmp_result1), 8), ZEXTQIDI (tmp_result0))))))));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }
}

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* mcmpeql: mcmpeq.l $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,mcmpeql) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

{
  SI tmp_result1;
  SI tmp_result0;
  tmp_result0 = ((EQSI (SUBWORDDISI (GET_H_GR (f_left), 1), SUBWORDDISI (GET_H_GR (f_right), 1))) ? (INVSI (0)) : (0));
  tmp_result1 = ((EQSI (SUBWORDDISI (GET_H_GR (f_left), 0), SUBWORDDISI (GET_H_GR (f_right), 0))) ? (INVSI (0)) : (0));
  {
    DI opval = ORDI (SLLDI (ZEXTSIDI (tmp_result1), 32), ZEXTSIDI (tmp_result0));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }
}

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* mcmpeqw: mcmpeq.w $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,mcmpeqw) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

{
  HI tmp_result3;
  HI tmp_result2;
  HI tmp_result1;
  HI tmp_result0;
  tmp_result0 = ((EQHI (SUBWORDDIHI (GET_H_GR (f_left), 3), SUBWORDDIHI (GET_H_GR (f_right), 3))) ? (INVHI (0)) : (0));
  tmp_result1 = ((EQHI (SUBWORDDIHI (GET_H_GR (f_left), 2), SUBWORDDIHI (GET_H_GR (f_right), 2))) ? (INVHI (0)) : (0));
  tmp_result2 = ((EQHI (SUBWORDDIHI (GET_H_GR (f_left), 1), SUBWORDDIHI (GET_H_GR (f_right), 1))) ? (INVHI (0)) : (0));
  tmp_result3 = ((EQHI (SUBWORDDIHI (GET_H_GR (f_left), 0), SUBWORDDIHI (GET_H_GR (f_right), 0))) ? (INVHI (0)) : (0));
  {
    DI opval = ORDI (SLLDI (ZEXTHIDI (tmp_result3), 48), ORDI (SLLDI (ZEXTHIDI (tmp_result2), 32), ORDI (SLLDI (ZEXTHIDI (tmp_result1), 16), ZEXTHIDI (tmp_result0))));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }
}

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* mcmpgtl: mcmpgt.l $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,mcmpgtl) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

{
  SI tmp_result1;
  SI tmp_result0;
  tmp_result0 = ((GTSI (SUBWORDDISI (GET_H_GR (f_left), 1), SUBWORDDISI (GET_H_GR (f_right), 1))) ? (INVSI (0)) : (0));
  tmp_result1 = ((GTSI (SUBWORDDISI (GET_H_GR (f_left), 0), SUBWORDDISI (GET_H_GR (f_right), 0))) ? (INVSI (0)) : (0));
  {
    DI opval = ORDI (SLLDI (ZEXTSIDI (tmp_result1), 32), ZEXTSIDI (tmp_result0));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }
}

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* mcmpgtub: mcmpgt.ub $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,mcmpgtub) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

{
  QI tmp_result7;
  QI tmp_result6;
  QI tmp_result5;
  QI tmp_result4;
  QI tmp_result3;
  QI tmp_result2;
  QI tmp_result1;
  QI tmp_result0;
  tmp_result0 = ((GTUQI (SUBWORDDIQI (GET_H_GR (f_left), 7), SUBWORDDIQI (GET_H_GR (f_right), 7))) ? (INVQI (0)) : (0));
  tmp_result1 = ((GTUQI (SUBWORDDIQI (GET_H_GR (f_left), 6), SUBWORDDIQI (GET_H_GR (f_right), 6))) ? (INVQI (0)) : (0));
  tmp_result2 = ((GTUQI (SUBWORDDIQI (GET_H_GR (f_left), 5), SUBWORDDIQI (GET_H_GR (f_right), 5))) ? (INVQI (0)) : (0));
  tmp_result3 = ((GTUQI (SUBWORDDIQI (GET_H_GR (f_left), 4), SUBWORDDIQI (GET_H_GR (f_right), 4))) ? (INVQI (0)) : (0));
  tmp_result4 = ((GTUQI (SUBWORDDIQI (GET_H_GR (f_left), 3), SUBWORDDIQI (GET_H_GR (f_right), 3))) ? (INVQI (0)) : (0));
  tmp_result5 = ((GTUQI (SUBWORDDIQI (GET_H_GR (f_left), 2), SUBWORDDIQI (GET_H_GR (f_right), 2))) ? (INVQI (0)) : (0));
  tmp_result6 = ((GTUQI (SUBWORDDIQI (GET_H_GR (f_left), 1), SUBWORDDIQI (GET_H_GR (f_right), 1))) ? (INVQI (0)) : (0));
  tmp_result7 = ((GTUQI (SUBWORDDIQI (GET_H_GR (f_left), 0), SUBWORDDIQI (GET_H_GR (f_right), 0))) ? (INVQI (0)) : (0));
  {
    DI opval = ORDI (SLLDI (ZEXTQIDI (tmp_result7), 56), ORDI (SLLDI (ZEXTQIDI (tmp_result6), 48), ORDI (SLLDI (ZEXTQIDI (tmp_result5), 40), ORDI (SLLDI (ZEXTQIDI (tmp_result4), 32), ORDI (SLLDI (ZEXTQIDI (tmp_result3), 24), ORDI (SLLDI (ZEXTQIDI (tmp_result2), 16), ORDI (SLLDI (ZEXTQIDI (tmp_result1), 8), ZEXTQIDI (tmp_result0))))))));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }
}

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* mcmpgtw: mcmpgt.w $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,mcmpgtw) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

{
  HI tmp_result3;
  HI tmp_result2;
  HI tmp_result1;
  HI tmp_result0;
  tmp_result0 = ((GTHI (SUBWORDDIHI (GET_H_GR (f_left), 3), SUBWORDDIHI (GET_H_GR (f_right), 3))) ? (INVHI (0)) : (0));
  tmp_result1 = ((GTHI (SUBWORDDIHI (GET_H_GR (f_left), 2), SUBWORDDIHI (GET_H_GR (f_right), 2))) ? (INVHI (0)) : (0));
  tmp_result2 = ((GTHI (SUBWORDDIHI (GET_H_GR (f_left), 1), SUBWORDDIHI (GET_H_GR (f_right), 1))) ? (INVHI (0)) : (0));
  tmp_result3 = ((GTHI (SUBWORDDIHI (GET_H_GR (f_left), 0), SUBWORDDIHI (GET_H_GR (f_right), 0))) ? (INVHI (0)) : (0));
  {
    DI opval = ORDI (SLLDI (ZEXTHIDI (tmp_result3), 48), ORDI (SLLDI (ZEXTHIDI (tmp_result2), 32), ORDI (SLLDI (ZEXTHIDI (tmp_result1), 16), ZEXTHIDI (tmp_result0))));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }
}

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* mcmv: mcmv $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,mcmv) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

  {
    DI opval = ORDI (ANDDI (GET_H_GR (f_left), GET_H_GR (f_right)), ANDDI (GET_H_GR (f_dest), INVDI (GET_H_GR (f_right))));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* mcnvslw: mcnvs.lw $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,mcnvslw) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

{
  HI tmp_result3;
  HI tmp_result2;
  HI tmp_result1;
  HI tmp_result0;
  tmp_result0 = ((LTSI (SUBWORDDISI (GET_H_GR (f_left), 1), NEGDI (SLLDI (1, SUBSI (16, 1))))) ? (NEGHI (SLLHI (1, SUBSI (16, 1)))) : (((LTSI (SUBWORDDISI (GET_H_GR (f_left), 1), SLLDI (1, SUBSI (16, 1)))) ? (SUBWORDDISI (GET_H_GR (f_left), 1)) : (SUBHI (SLLHI (1, SUBSI (16, 1)), 1)))));
  tmp_result1 = ((LTSI (SUBWORDDISI (GET_H_GR (f_left), 0), NEGDI (SLLDI (1, SUBSI (16, 1))))) ? (NEGHI (SLLHI (1, SUBSI (16, 1)))) : (((LTSI (SUBWORDDISI (GET_H_GR (f_left), 0), SLLDI (1, SUBSI (16, 1)))) ? (SUBWORDDISI (GET_H_GR (f_left), 0)) : (SUBHI (SLLHI (1, SUBSI (16, 1)), 1)))));
  tmp_result2 = ((LTSI (SUBWORDDISI (GET_H_GR (f_right), 1), NEGDI (SLLDI (1, SUBSI (16, 1))))) ? (NEGHI (SLLHI (1, SUBSI (16, 1)))) : (((LTSI (SUBWORDDISI (GET_H_GR (f_right), 1), SLLDI (1, SUBSI (16, 1)))) ? (SUBWORDDISI (GET_H_GR (f_right), 1)) : (SUBHI (SLLHI (1, SUBSI (16, 1)), 1)))));
  tmp_result3 = ((LTSI (SUBWORDDISI (GET_H_GR (f_right), 0), NEGDI (SLLDI (1, SUBSI (16, 1))))) ? (NEGHI (SLLHI (1, SUBSI (16, 1)))) : (((LTSI (SUBWORDDISI (GET_H_GR (f_right), 0), SLLDI (1, SUBSI (16, 1)))) ? (SUBWORDDISI (GET_H_GR (f_right), 0)) : (SUBHI (SLLHI (1, SUBSI (16, 1)), 1)))));
  {
    DI opval = ORDI (SLLDI (ZEXTHIDI (tmp_result3), 48), ORDI (SLLDI (ZEXTHIDI (tmp_result2), 32), ORDI (SLLDI (ZEXTHIDI (tmp_result1), 16), ZEXTHIDI (tmp_result0))));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }
}

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* mcnvswb: mcnvs.wb $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,mcnvswb) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

{
  QI tmp_result7;
  QI tmp_result6;
  QI tmp_result5;
  QI tmp_result4;
  QI tmp_result3;
  QI tmp_result2;
  QI tmp_result1;
  QI tmp_result0;
  tmp_result0 = ((LTHI (SUBWORDDIHI (GET_H_GR (f_left), 3), NEGDI (SLLDI (1, SUBSI (8, 1))))) ? (NEGQI (SLLQI (1, SUBSI (8, 1)))) : (((LTHI (SUBWORDDIHI (GET_H_GR (f_left), 3), SLLDI (1, SUBSI (8, 1)))) ? (SUBWORDDIHI (GET_H_GR (f_left), 3)) : (SUBQI (SLLQI (1, SUBSI (8, 1)), 1)))));
  tmp_result1 = ((LTHI (SUBWORDDIHI (GET_H_GR (f_left), 2), NEGDI (SLLDI (1, SUBSI (8, 1))))) ? (NEGQI (SLLQI (1, SUBSI (8, 1)))) : (((LTHI (SUBWORDDIHI (GET_H_GR (f_left), 2), SLLDI (1, SUBSI (8, 1)))) ? (SUBWORDDIHI (GET_H_GR (f_left), 2)) : (SUBQI (SLLQI (1, SUBSI (8, 1)), 1)))));
  tmp_result2 = ((LTHI (SUBWORDDIHI (GET_H_GR (f_left), 1), NEGDI (SLLDI (1, SUBSI (8, 1))))) ? (NEGQI (SLLQI (1, SUBSI (8, 1)))) : (((LTHI (SUBWORDDIHI (GET_H_GR (f_left), 1), SLLDI (1, SUBSI (8, 1)))) ? (SUBWORDDIHI (GET_H_GR (f_left), 1)) : (SUBQI (SLLQI (1, SUBSI (8, 1)), 1)))));
  tmp_result3 = ((LTHI (SUBWORDDIHI (GET_H_GR (f_left), 0), NEGDI (SLLDI (1, SUBSI (8, 1))))) ? (NEGQI (SLLQI (1, SUBSI (8, 1)))) : (((LTHI (SUBWORDDIHI (GET_H_GR (f_left), 0), SLLDI (1, SUBSI (8, 1)))) ? (SUBWORDDIHI (GET_H_GR (f_left), 0)) : (SUBQI (SLLQI (1, SUBSI (8, 1)), 1)))));
  tmp_result4 = ((LTHI (SUBWORDDIHI (GET_H_GR (f_right), 3), NEGDI (SLLDI (1, SUBSI (8, 1))))) ? (NEGQI (SLLQI (1, SUBSI (8, 1)))) : (((LTHI (SUBWORDDIHI (GET_H_GR (f_right), 3), SLLDI (1, SUBSI (8, 1)))) ? (SUBWORDDIHI (GET_H_GR (f_right), 3)) : (SUBQI (SLLQI (1, SUBSI (8, 1)), 1)))));
  tmp_result5 = ((LTHI (SUBWORDDIHI (GET_H_GR (f_right), 2), NEGDI (SLLDI (1, SUBSI (8, 1))))) ? (NEGQI (SLLQI (1, SUBSI (8, 1)))) : (((LTHI (SUBWORDDIHI (GET_H_GR (f_right), 2), SLLDI (1, SUBSI (8, 1)))) ? (SUBWORDDIHI (GET_H_GR (f_right), 2)) : (SUBQI (SLLQI (1, SUBSI (8, 1)), 1)))));
  tmp_result6 = ((LTHI (SUBWORDDIHI (GET_H_GR (f_right), 1), NEGDI (SLLDI (1, SUBSI (8, 1))))) ? (NEGQI (SLLQI (1, SUBSI (8, 1)))) : (((LTHI (SUBWORDDIHI (GET_H_GR (f_right), 1), SLLDI (1, SUBSI (8, 1)))) ? (SUBWORDDIHI (GET_H_GR (f_right), 1)) : (SUBQI (SLLQI (1, SUBSI (8, 1)), 1)))));
  tmp_result7 = ((LTHI (SUBWORDDIHI (GET_H_GR (f_right), 0), NEGDI (SLLDI (1, SUBSI (8, 1))))) ? (NEGQI (SLLQI (1, SUBSI (8, 1)))) : (((LTHI (SUBWORDDIHI (GET_H_GR (f_right), 0), SLLDI (1, SUBSI (8, 1)))) ? (SUBWORDDIHI (GET_H_GR (f_right), 0)) : (SUBQI (SLLQI (1, SUBSI (8, 1)), 1)))));
  {
    DI opval = ORDI (SLLDI (ZEXTQIDI (tmp_result7), 56), ORDI (SLLDI (ZEXTQIDI (tmp_result6), 48), ORDI (SLLDI (ZEXTQIDI (tmp_result5), 40), ORDI (SLLDI (ZEXTQIDI (tmp_result4), 32), ORDI (SLLDI (ZEXTQIDI (tmp_result3), 24), ORDI (SLLDI (ZEXTQIDI (tmp_result2), 16), ORDI (SLLDI (ZEXTQIDI (tmp_result1), 8), ZEXTQIDI (tmp_result0))))))));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }
}

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* mcnvswub: mcnvs.wub $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,mcnvswub) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

{
  QI tmp_result7;
  QI tmp_result6;
  QI tmp_result5;
  QI tmp_result4;
  QI tmp_result3;
  QI tmp_result2;
  QI tmp_result1;
  QI tmp_result0;
  tmp_result0 = ((LTHI (SUBWORDDIHI (GET_H_GR (f_left), 3), MAKEDI (0, 0))) ? (0) : (((LTHI (SUBWORDDIHI (GET_H_GR (f_left), 3), SLLDI (1, 8))) ? (SUBWORDDIHI (GET_H_GR (f_left), 3)) : (SUBQI (SLLQI (1, 8), 1)))));
  tmp_result1 = ((LTHI (SUBWORDDIHI (GET_H_GR (f_left), 2), MAKEDI (0, 0))) ? (0) : (((LTHI (SUBWORDDIHI (GET_H_GR (f_left), 2), SLLDI (1, 8))) ? (SUBWORDDIHI (GET_H_GR (f_left), 2)) : (SUBQI (SLLQI (1, 8), 1)))));
  tmp_result2 = ((LTHI (SUBWORDDIHI (GET_H_GR (f_left), 1), MAKEDI (0, 0))) ? (0) : (((LTHI (SUBWORDDIHI (GET_H_GR (f_left), 1), SLLDI (1, 8))) ? (SUBWORDDIHI (GET_H_GR (f_left), 1)) : (SUBQI (SLLQI (1, 8), 1)))));
  tmp_result3 = ((LTHI (SUBWORDDIHI (GET_H_GR (f_left), 0), MAKEDI (0, 0))) ? (0) : (((LTHI (SUBWORDDIHI (GET_H_GR (f_left), 0), SLLDI (1, 8))) ? (SUBWORDDIHI (GET_H_GR (f_left), 0)) : (SUBQI (SLLQI (1, 8), 1)))));
  tmp_result4 = ((LTHI (SUBWORDDIHI (GET_H_GR (f_right), 3), MAKEDI (0, 0))) ? (0) : (((LTHI (SUBWORDDIHI (GET_H_GR (f_right), 3), SLLDI (1, 8))) ? (SUBWORDDIHI (GET_H_GR (f_right), 3)) : (SUBQI (SLLQI (1, 8), 1)))));
  tmp_result5 = ((LTHI (SUBWORDDIHI (GET_H_GR (f_right), 2), MAKEDI (0, 0))) ? (0) : (((LTHI (SUBWORDDIHI (GET_H_GR (f_right), 2), SLLDI (1, 8))) ? (SUBWORDDIHI (GET_H_GR (f_right), 2)) : (SUBQI (SLLQI (1, 8), 1)))));
  tmp_result6 = ((LTHI (SUBWORDDIHI (GET_H_GR (f_right), 1), MAKEDI (0, 0))) ? (0) : (((LTHI (SUBWORDDIHI (GET_H_GR (f_right), 1), SLLDI (1, 8))) ? (SUBWORDDIHI (GET_H_GR (f_right), 1)) : (SUBQI (SLLQI (1, 8), 1)))));
  tmp_result7 = ((LTHI (SUBWORDDIHI (GET_H_GR (f_right), 0), MAKEDI (0, 0))) ? (0) : (((LTHI (SUBWORDDIHI (GET_H_GR (f_right), 0), SLLDI (1, 8))) ? (SUBWORDDIHI (GET_H_GR (f_right), 0)) : (SUBQI (SLLQI (1, 8), 1)))));
  {
    DI opval = ORDI (SLLDI (ZEXTQIDI (tmp_result7), 56), ORDI (SLLDI (ZEXTQIDI (tmp_result6), 48), ORDI (SLLDI (ZEXTQIDI (tmp_result5), 40), ORDI (SLLDI (ZEXTQIDI (tmp_result4), 32), ORDI (SLLDI (ZEXTQIDI (tmp_result3), 24), ORDI (SLLDI (ZEXTQIDI (tmp_result2), 16), ORDI (SLLDI (ZEXTQIDI (tmp_result1), 8), ZEXTQIDI (tmp_result0))))))));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }
}

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* mextr1: mextr1 $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,mextr1) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

{
  QI tmp_count;
  DI tmp_mask;
  DI tmp_rhs;
  tmp_count = MULQI (8, 1);
  tmp_mask = SLLDI (INVSI (0), tmp_count);
  tmp_rhs = SRLDI (ANDDI (GET_H_GR (f_left), tmp_mask), tmp_count);
  tmp_count = MULQI (8, SUBQI (8, 1));
  tmp_mask = SRLDI (INVSI (0), tmp_count);
  {
    DI opval = ORDI (tmp_rhs, SLLDI (ANDDI (GET_H_GR (f_right), tmp_mask), tmp_count));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }
}

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* mextr2: mextr2 $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,mextr2) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

{
  QI tmp_count;
  DI tmp_mask;
  DI tmp_rhs;
  tmp_count = MULQI (8, 2);
  tmp_mask = SLLDI (INVSI (0), tmp_count);
  tmp_rhs = SRLDI (ANDDI (GET_H_GR (f_left), tmp_mask), tmp_count);
  tmp_count = MULQI (8, SUBQI (8, 2));
  tmp_mask = SRLDI (INVSI (0), tmp_count);
  {
    DI opval = ORDI (tmp_rhs, SLLDI (ANDDI (GET_H_GR (f_right), tmp_mask), tmp_count));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }
}

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* mextr3: mextr3 $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,mextr3) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

{
  QI tmp_count;
  DI tmp_mask;
  DI tmp_rhs;
  tmp_count = MULQI (8, 3);
  tmp_mask = SLLDI (INVSI (0), tmp_count);
  tmp_rhs = SRLDI (ANDDI (GET_H_GR (f_left), tmp_mask), tmp_count);
  tmp_count = MULQI (8, SUBQI (8, 3));
  tmp_mask = SRLDI (INVSI (0), tmp_count);
  {
    DI opval = ORDI (tmp_rhs, SLLDI (ANDDI (GET_H_GR (f_right), tmp_mask), tmp_count));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }
}

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* mextr4: mextr4 $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,mextr4) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

{
  QI tmp_count;
  DI tmp_mask;
  DI tmp_rhs;
  tmp_count = MULQI (8, 4);
  tmp_mask = SLLDI (INVSI (0), tmp_count);
  tmp_rhs = SRLDI (ANDDI (GET_H_GR (f_left), tmp_mask), tmp_count);
  tmp_count = MULQI (8, SUBQI (8, 4));
  tmp_mask = SRLDI (INVSI (0), tmp_count);
  {
    DI opval = ORDI (tmp_rhs, SLLDI (ANDDI (GET_H_GR (f_right), tmp_mask), tmp_count));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }
}

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* mextr5: mextr5 $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,mextr5) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

{
  QI tmp_count;
  DI tmp_mask;
  DI tmp_rhs;
  tmp_count = MULQI (8, 5);
  tmp_mask = SLLDI (INVSI (0), tmp_count);
  tmp_rhs = SRLDI (ANDDI (GET_H_GR (f_left), tmp_mask), tmp_count);
  tmp_count = MULQI (8, SUBQI (8, 5));
  tmp_mask = SRLDI (INVSI (0), tmp_count);
  {
    DI opval = ORDI (tmp_rhs, SLLDI (ANDDI (GET_H_GR (f_right), tmp_mask), tmp_count));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }
}

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* mextr6: mextr6 $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,mextr6) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

{
  QI tmp_count;
  DI tmp_mask;
  DI tmp_rhs;
  tmp_count = MULQI (8, 6);
  tmp_mask = SLLDI (INVSI (0), tmp_count);
  tmp_rhs = SRLDI (ANDDI (GET_H_GR (f_left), tmp_mask), tmp_count);
  tmp_count = MULQI (8, SUBQI (8, 6));
  tmp_mask = SRLDI (INVSI (0), tmp_count);
  {
    DI opval = ORDI (tmp_rhs, SLLDI (ANDDI (GET_H_GR (f_right), tmp_mask), tmp_count));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }
}

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* mextr7: mextr7 $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,mextr7) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

{
  QI tmp_count;
  DI tmp_mask;
  DI tmp_rhs;
  tmp_count = MULQI (8, 7);
  tmp_mask = SLLDI (INVSI (0), tmp_count);
  tmp_rhs = SRLDI (ANDDI (GET_H_GR (f_left), tmp_mask), tmp_count);
  tmp_count = MULQI (8, SUBQI (8, 7));
  tmp_mask = SRLDI (INVSI (0), tmp_count);
  {
    DI opval = ORDI (tmp_rhs, SLLDI (ANDDI (GET_H_GR (f_right), tmp_mask), tmp_count));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }
}

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* mmacfxwl: mmacfx.wl $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,mmacfxwl) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

{
  SI tmp_temp;
  SI tmp_result1;
  SI tmp_result0;
  tmp_result0 = SUBWORDDISI (GET_H_GR (f_dest), 1);
  tmp_result1 = SUBWORDDISI (GET_H_GR (f_dest), 0);
  tmp_temp = MULSI (ZEXTHISI (SUBWORDDIHI (GET_H_GR (f_left), 3)), ZEXTHISI (SUBWORDDIHI (GET_H_GR (f_right), 3)));
  tmp_temp = ((LTDI (SLLDI (tmp_temp, 1), NEGDI (SLLDI (1, SUBSI (32, 1))))) ? (NEGSI (SLLSI (1, SUBSI (32, 1)))) : (((LTDI (SLLDI (tmp_temp, 1), SLLDI (1, SUBSI (32, 1)))) ? (SLLDI (tmp_temp, 1)) : (SUBSI (SLLSI (1, SUBSI (32, 1)), 1)))));
  tmp_result0 = ((LTDI (ADDDI (EXTSIDI (tmp_result0), EXTSIDI (tmp_temp)), NEGDI (SLLDI (1, SUBSI (32, 1))))) ? (NEGSI (SLLSI (1, SUBSI (32, 1)))) : (((LTDI (ADDDI (EXTSIDI (tmp_result0), EXTSIDI (tmp_temp)), SLLDI (1, SUBSI (32, 1)))) ? (ADDDI (EXTSIDI (tmp_result0), EXTSIDI (tmp_temp))) : (SUBSI (SLLSI (1, SUBSI (32, 1)), 1)))));
  tmp_temp = MULSI (ZEXTHISI (SUBWORDDIHI (GET_H_GR (f_left), 2)), ZEXTHISI (SUBWORDDIHI (GET_H_GR (f_right), 2)));
  tmp_temp = ((LTDI (SLLDI (tmp_temp, 1), NEGDI (SLLDI (1, SUBSI (32, 1))))) ? (NEGSI (SLLSI (1, SUBSI (32, 1)))) : (((LTDI (SLLDI (tmp_temp, 1), SLLDI (1, SUBSI (32, 1)))) ? (SLLDI (tmp_temp, 1)) : (SUBSI (SLLSI (1, SUBSI (32, 1)), 1)))));
  tmp_result1 = ((LTDI (ADDDI (EXTSIDI (tmp_result1), EXTSIDI (tmp_temp)), NEGDI (SLLDI (1, SUBSI (32, 1))))) ? (NEGSI (SLLSI (1, SUBSI (32, 1)))) : (((LTDI (ADDDI (EXTSIDI (tmp_result1), EXTSIDI (tmp_temp)), SLLDI (1, SUBSI (32, 1)))) ? (ADDDI (EXTSIDI (tmp_result1), EXTSIDI (tmp_temp))) : (SUBSI (SLLSI (1, SUBSI (32, 1)), 1)))));
  {
    DI opval = ORDI (SLLDI (ZEXTSIDI (tmp_result1), 32), ZEXTSIDI (tmp_result0));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }
}

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* mmacnfx.wl: mmacnfx.wl $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,mmacnfx_wl) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_MMACNFX_WL_VARS /* f-op f-ext f-right f-right f-dest f-rsvd */
  EXTRACT_IFMT_MMACNFX_WL_CODE

{
  SI tmp_temp;
  SI tmp_result1;
  SI tmp_result0;
  tmp_result0 = SUBWORDDISI (GET_H_GR (f_dest), 1);
  tmp_result1 = SUBWORDDISI (GET_H_GR (f_dest), 0);
  tmp_temp = MULSI (ZEXTHISI (SUBWORDDIHI (GET_H_GR (f_left), 3)), ZEXTHISI (SUBWORDDIHI (GET_H_GR (f_right), 3)));
  tmp_temp = ((LTDI (SLLDI (tmp_temp, 1), NEGDI (SLLDI (1, SUBSI (32, 1))))) ? (NEGSI (SLLSI (1, SUBSI (32, 1)))) : (((LTDI (SLLDI (tmp_temp, 1), SLLDI (1, SUBSI (32, 1)))) ? (SLLDI (tmp_temp, 1)) : (SUBSI (SLLSI (1, SUBSI (32, 1)), 1)))));
  tmp_result0 = ((LTDI (SUBDI (EXTSIDI (tmp_result0), EXTSIDI (tmp_temp)), NEGDI (SLLDI (1, SUBSI (32, 1))))) ? (NEGSI (SLLSI (1, SUBSI (32, 1)))) : (((LTDI (SUBDI (EXTSIDI (tmp_result0), EXTSIDI (tmp_temp)), SLLDI (1, SUBSI (32, 1)))) ? (SUBDI (EXTSIDI (tmp_result0), EXTSIDI (tmp_temp))) : (SUBSI (SLLSI (1, SUBSI (32, 1)), 1)))));
  tmp_temp = MULSI (ZEXTHISI (SUBWORDDIHI (GET_H_GR (f_left), 2)), ZEXTHISI (SUBWORDDIHI (GET_H_GR (f_right), 2)));
  tmp_temp = ((LTDI (SLLDI (tmp_temp, 1), NEGDI (SLLDI (1, SUBSI (32, 1))))) ? (NEGSI (SLLSI (1, SUBSI (32, 1)))) : (((LTDI (SLLDI (tmp_temp, 1), SLLDI (1, SUBSI (32, 1)))) ? (SLLDI (tmp_temp, 1)) : (SUBSI (SLLSI (1, SUBSI (32, 1)), 1)))));
  tmp_result1 = ((LTDI (SUBDI (EXTSIDI (tmp_result1), EXTSIDI (tmp_temp)), NEGDI (SLLDI (1, SUBSI (32, 1))))) ? (NEGSI (SLLSI (1, SUBSI (32, 1)))) : (((LTDI (SUBDI (EXTSIDI (tmp_result1), EXTSIDI (tmp_temp)), SLLDI (1, SUBSI (32, 1)))) ? (SUBDI (EXTSIDI (tmp_result1), EXTSIDI (tmp_temp))) : (SUBSI (SLLSI (1, SUBSI (32, 1)), 1)))));
  {
    DI opval = ORDI (SLLDI (ZEXTSIDI (tmp_result1), 32), ZEXTSIDI (tmp_result0));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }
}

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* mmull: mmul.l $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,mmull) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

{
  SI tmp_result1;
  SI tmp_result0;
  tmp_result0 = MULSI (SUBWORDDISI (GET_H_GR (f_left), 1), SUBWORDDISI (GET_H_GR (f_right), 1));
  tmp_result1 = MULSI (SUBWORDDISI (GET_H_GR (f_left), 0), SUBWORDDISI (GET_H_GR (f_right), 0));
  {
    DI opval = ORDI (SLLDI (ZEXTSIDI (tmp_result1), 32), ZEXTSIDI (tmp_result0));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }
}

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* mmulw: mmul.w $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,mmulw) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

{
  HI tmp_result3;
  HI tmp_result2;
  HI tmp_result1;
  HI tmp_result0;
  tmp_result0 = MULHI (SUBWORDDIHI (GET_H_GR (f_left), 3), SUBWORDDIHI (GET_H_GR (f_right), 3));
  tmp_result1 = MULHI (SUBWORDDIHI (GET_H_GR (f_left), 2), SUBWORDDIHI (GET_H_GR (f_right), 2));
  tmp_result2 = MULHI (SUBWORDDIHI (GET_H_GR (f_left), 1), SUBWORDDIHI (GET_H_GR (f_right), 1));
  tmp_result3 = MULHI (SUBWORDDIHI (GET_H_GR (f_left), 0), SUBWORDDIHI (GET_H_GR (f_right), 0));
  {
    DI opval = ORDI (SLLDI (ZEXTHIDI (tmp_result3), 48), ORDI (SLLDI (ZEXTHIDI (tmp_result2), 32), ORDI (SLLDI (ZEXTHIDI (tmp_result1), 16), ZEXTHIDI (tmp_result0))));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }
}

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* mmulfxl: mmulfx.l $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,mmulfxl) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

{
  DI tmp_temp;
  SI tmp_result0;
  SI tmp_result1;
  tmp_temp = MULDI (ZEXTSIDI (SUBWORDDISI (GET_H_GR (f_left), 1)), ZEXTSIDI (SUBWORDDISI (GET_H_GR (f_right), 1)));
  tmp_result0 = ((LTDI (SRADI (tmp_temp, 31), NEGDI (SLLDI (1, SUBSI (32, 1))))) ? (NEGSI (SLLSI (1, SUBSI (32, 1)))) : (((LTDI (SRADI (tmp_temp, 31), SLLDI (1, SUBSI (32, 1)))) ? (SRADI (tmp_temp, 31)) : (SUBSI (SLLSI (1, SUBSI (32, 1)), 1)))));
  tmp_temp = MULDI (ZEXTSIDI (SUBWORDDISI (GET_H_GR (f_left), 0)), ZEXTSIDI (SUBWORDDISI (GET_H_GR (f_right), 0)));
  tmp_result1 = ((LTDI (SRADI (tmp_temp, 31), NEGDI (SLLDI (1, SUBSI (32, 1))))) ? (NEGSI (SLLSI (1, SUBSI (32, 1)))) : (((LTDI (SRADI (tmp_temp, 31), SLLDI (1, SUBSI (32, 1)))) ? (SRADI (tmp_temp, 31)) : (SUBSI (SLLSI (1, SUBSI (32, 1)), 1)))));
  {
    DI opval = ORDI (SLLDI (ZEXTSIDI (tmp_result1), 32), ZEXTSIDI (tmp_result0));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }
}

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* mmulfxw: mmulfx.w $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,mmulfxw) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

{
  SI tmp_temp;
  HI tmp_result0;
  HI tmp_result1;
  HI tmp_result2;
  HI tmp_result3;
  tmp_temp = MULSI (ZEXTHISI (SUBWORDDIHI (GET_H_GR (f_left), 3)), ZEXTHISI (SUBWORDDIHI (GET_H_GR (f_right), 3)));
  tmp_result0 = ((LTSI (SRASI (tmp_temp, 15), NEGDI (SLLDI (1, SUBSI (16, 1))))) ? (NEGHI (SLLHI (1, SUBSI (16, 1)))) : (((LTSI (SRASI (tmp_temp, 15), SLLDI (1, SUBSI (16, 1)))) ? (SRASI (tmp_temp, 15)) : (SUBHI (SLLHI (1, SUBSI (16, 1)), 1)))));
  tmp_temp = MULSI (ZEXTHISI (SUBWORDDIHI (GET_H_GR (f_left), 2)), ZEXTHISI (SUBWORDDIHI (GET_H_GR (f_right), 2)));
  tmp_result1 = ((LTSI (SRASI (tmp_temp, 15), NEGDI (SLLDI (1, SUBSI (16, 1))))) ? (NEGHI (SLLHI (1, SUBSI (16, 1)))) : (((LTSI (SRASI (tmp_temp, 15), SLLDI (1, SUBSI (16, 1)))) ? (SRASI (tmp_temp, 15)) : (SUBHI (SLLHI (1, SUBSI (16, 1)), 1)))));
  tmp_temp = MULSI (ZEXTHISI (SUBWORDDIHI (GET_H_GR (f_left), 1)), ZEXTHISI (SUBWORDDIHI (GET_H_GR (f_right), 1)));
  tmp_result2 = ((LTSI (SRASI (tmp_temp, 15), NEGDI (SLLDI (1, SUBSI (16, 1))))) ? (NEGHI (SLLHI (1, SUBSI (16, 1)))) : (((LTSI (SRASI (tmp_temp, 15), SLLDI (1, SUBSI (16, 1)))) ? (SRASI (tmp_temp, 15)) : (SUBHI (SLLHI (1, SUBSI (16, 1)), 1)))));
  tmp_temp = MULSI (ZEXTHISI (SUBWORDDIHI (GET_H_GR (f_left), 0)), ZEXTHISI (SUBWORDDIHI (GET_H_GR (f_right), 0)));
  tmp_result3 = ((LTSI (SRASI (tmp_temp, 15), NEGDI (SLLDI (1, SUBSI (16, 1))))) ? (NEGHI (SLLHI (1, SUBSI (16, 1)))) : (((LTSI (SRASI (tmp_temp, 15), SLLDI (1, SUBSI (16, 1)))) ? (SRASI (tmp_temp, 15)) : (SUBHI (SLLHI (1, SUBSI (16, 1)), 1)))));
  {
    DI opval = ORDI (SLLDI (ZEXTHIDI (tmp_result3), 48), ORDI (SLLDI (ZEXTHIDI (tmp_result2), 32), ORDI (SLLDI (ZEXTHIDI (tmp_result1), 16), ZEXTHIDI (tmp_result0))));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }
}

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* mmulfxrpw: mmulfxrp.w $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,mmulfxrpw) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

{
  SI tmp_temp;
  HI tmp_result0;
  HI tmp_result1;
  HI tmp_result2;
  HI tmp_result3;
  HI tmp_c;
  tmp_c = SLLSI (1, 14);
  tmp_temp = MULSI (ZEXTHISI (SUBWORDDIHI (GET_H_GR (f_left), 3)), ZEXTHISI (SUBWORDDIHI (GET_H_GR (f_right), 3)));
  tmp_result0 = ((LTSI (SRASI (ADDSI (tmp_temp, tmp_c), 15), NEGDI (SLLDI (1, SUBSI (16, 1))))) ? (NEGHI (SLLHI (1, SUBSI (16, 1)))) : (((LTSI (SRASI (ADDSI (tmp_temp, tmp_c), 15), SLLDI (1, SUBSI (16, 1)))) ? (SRASI (ADDSI (tmp_temp, tmp_c), 15)) : (SUBHI (SLLHI (1, SUBSI (16, 1)), 1)))));
  tmp_temp = MULSI (ZEXTHISI (SUBWORDDIHI (GET_H_GR (f_left), 2)), ZEXTHISI (SUBWORDDIHI (GET_H_GR (f_right), 2)));
  tmp_result1 = ((LTSI (SRASI (ADDSI (tmp_temp, tmp_c), 15), NEGDI (SLLDI (1, SUBSI (16, 1))))) ? (NEGHI (SLLHI (1, SUBSI (16, 1)))) : (((LTSI (SRASI (ADDSI (tmp_temp, tmp_c), 15), SLLDI (1, SUBSI (16, 1)))) ? (SRASI (ADDSI (tmp_temp, tmp_c), 15)) : (SUBHI (SLLHI (1, SUBSI (16, 1)), 1)))));
  tmp_temp = MULSI (ZEXTHISI (SUBWORDDIHI (GET_H_GR (f_left), 1)), ZEXTHISI (SUBWORDDIHI (GET_H_GR (f_right), 1)));
  tmp_result2 = ((LTSI (SRASI (ADDSI (tmp_temp, tmp_c), 15), NEGDI (SLLDI (1, SUBSI (16, 1))))) ? (NEGHI (SLLHI (1, SUBSI (16, 1)))) : (((LTSI (SRASI (ADDSI (tmp_temp, tmp_c), 15), SLLDI (1, SUBSI (16, 1)))) ? (SRASI (ADDSI (tmp_temp, tmp_c), 15)) : (SUBHI (SLLHI (1, SUBSI (16, 1)), 1)))));
  tmp_temp = MULSI (ZEXTHISI (SUBWORDDIHI (GET_H_GR (f_left), 0)), ZEXTHISI (SUBWORDDIHI (GET_H_GR (f_right), 0)));
  tmp_result3 = ((LTSI (SRASI (ADDSI (tmp_temp, tmp_c), 15), NEGDI (SLLDI (1, SUBSI (16, 1))))) ? (NEGHI (SLLHI (1, SUBSI (16, 1)))) : (((LTSI (SRASI (ADDSI (tmp_temp, tmp_c), 15), SLLDI (1, SUBSI (16, 1)))) ? (SRASI (ADDSI (tmp_temp, tmp_c), 15)) : (SUBHI (SLLHI (1, SUBSI (16, 1)), 1)))));
  {
    DI opval = ORDI (SLLDI (ZEXTHIDI (tmp_result3), 48), ORDI (SLLDI (ZEXTHIDI (tmp_result2), 32), ORDI (SLLDI (ZEXTHIDI (tmp_result1), 16), ZEXTHIDI (tmp_result0))));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }
}

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* mmulhiwl: mmulhi.wl $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,mmulhiwl) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

{
  SI tmp_result1;
  SI tmp_result0;
  tmp_result0 = MULSI (ZEXTHISI (SUBWORDDIHI (GET_H_GR (f_left), 1)), ZEXTHISI (SUBWORDDIHI (GET_H_GR (f_right), 1)));
  tmp_result1 = MULSI (ZEXTHISI (SUBWORDDIHI (GET_H_GR (f_left), 0)), ZEXTHISI (SUBWORDDIHI (GET_H_GR (f_right), 0)));
  {
    DI opval = ORDI (SLLDI (ZEXTSIDI (tmp_result1), 32), ZEXTSIDI (tmp_result0));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }
}

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* mmullowl: mmullo.wl $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,mmullowl) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

{
  SI tmp_result1;
  SI tmp_result0;
  tmp_result0 = MULSI (ZEXTHISI (SUBWORDDIHI (GET_H_GR (f_left), 3)), ZEXTHISI (SUBWORDDIHI (GET_H_GR (f_right), 3)));
  tmp_result1 = MULSI (ZEXTHISI (SUBWORDDIHI (GET_H_GR (f_left), 2)), ZEXTHISI (SUBWORDDIHI (GET_H_GR (f_right), 2)));
  {
    DI opval = ORDI (SLLDI (ZEXTSIDI (tmp_result1), 32), ZEXTSIDI (tmp_result0));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }
}

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* mmulsumwq: mmulsum.wq $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,mmulsumwq) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

{
  DI tmp_acc;
  tmp_acc = MULSI (ZEXTHISI (SUBWORDDIHI (GET_H_GR (f_left), 0)), ZEXTHISI (SUBWORDDIHI (GET_H_GR (f_right), 0)));
  tmp_acc = ADDDI (tmp_acc, MULSI (ZEXTHISI (SUBWORDDIHI (GET_H_GR (f_left), 1)), ZEXTHISI (SUBWORDDIHI (GET_H_GR (f_right), 1))));
  tmp_acc = ADDDI (tmp_acc, MULSI (ZEXTHISI (SUBWORDDIHI (GET_H_GR (f_left), 2)), ZEXTHISI (SUBWORDDIHI (GET_H_GR (f_right), 2))));
  tmp_acc = ADDDI (tmp_acc, MULSI (ZEXTHISI (SUBWORDDIHI (GET_H_GR (f_left), 3)), ZEXTHISI (SUBWORDDIHI (GET_H_GR (f_right), 3))));
  {
    DI opval = ADDDI (GET_H_GR (f_dest), tmp_acc);
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }
}

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* movi: movi $imm16, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,movi) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_MOVI_VARS /* f-op f-imm16 f-dest f-rsvd */
  EXTRACT_IFMT_MOVI_CODE

  {
    DI opval = EXTSIDI (f_imm16);
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* mpermw: mperm.w $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,mpermw) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

{
  QI tmp_control;
  HI tmp_result3;
  HI tmp_result2;
  HI tmp_result1;
  HI tmp_result0;
  tmp_control = ANDQI (GET_H_GR (f_right), 255);
  tmp_result0 = SUBWORDDIHI (GET_H_GR (f_left), SUBSI (3, ANDQI (tmp_control, 3)));
  tmp_result1 = SUBWORDDIHI (GET_H_GR (f_left), SUBSI (3, ANDQI (SRLQI (tmp_control, 2), 3)));
  tmp_result2 = SUBWORDDIHI (GET_H_GR (f_left), SUBSI (3, ANDQI (SRLQI (tmp_control, 4), 3)));
  tmp_result3 = SUBWORDDIHI (GET_H_GR (f_left), SUBSI (3, ANDQI (SRLQI (tmp_control, 6), 3)));
  {
    DI opval = ORDI (SLLDI (ZEXTHIDI (tmp_result3), 48), ORDI (SLLDI (ZEXTHIDI (tmp_result2), 32), ORDI (SLLDI (ZEXTHIDI (tmp_result1), 16), ZEXTHIDI (tmp_result0))));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }
}

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* msadubq: msad.ubq $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,msadubq) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

{
  DI tmp_acc;
  tmp_acc = ABSDI (SUBQI (SUBWORDDIQI (GET_H_GR (f_left), 0), SUBWORDDIQI (GET_H_GR (f_right), 0)));
  tmp_acc = ADDDI (tmp_acc, ABSQI (SUBQI (SUBWORDDIQI (GET_H_GR (f_left), 1), SUBWORDDIQI (GET_H_GR (f_right), 1))));
  tmp_acc = ADDDI (tmp_acc, ABSQI (SUBQI (SUBWORDDIQI (GET_H_GR (f_left), 2), SUBWORDDIQI (GET_H_GR (f_right), 2))));
  tmp_acc = ADDDI (tmp_acc, ABSQI (SUBQI (SUBWORDDIQI (GET_H_GR (f_left), 3), SUBWORDDIQI (GET_H_GR (f_right), 3))));
  tmp_acc = ADDDI (tmp_acc, ABSQI (SUBQI (SUBWORDDIQI (GET_H_GR (f_left), 4), SUBWORDDIQI (GET_H_GR (f_right), 4))));
  tmp_acc = ADDDI (tmp_acc, ABSQI (SUBQI (SUBWORDDIQI (GET_H_GR (f_left), 5), SUBWORDDIQI (GET_H_GR (f_right), 5))));
  tmp_acc = ADDDI (tmp_acc, ABSQI (SUBQI (SUBWORDDIQI (GET_H_GR (f_left), 6), SUBWORDDIQI (GET_H_GR (f_right), 6))));
  tmp_acc = ADDDI (tmp_acc, ABSQI (SUBQI (SUBWORDDIQI (GET_H_GR (f_left), 7), SUBWORDDIQI (GET_H_GR (f_right), 7))));
  {
    DI opval = ADDDI (GET_H_GR (f_dest), tmp_acc);
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }
}

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* mshaldsl: mshalds.l $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,mshaldsl) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

{
  SI tmp_result1;
  SI tmp_result0;
  tmp_result0 = ((LTDI (SLLDI (SUBWORDDISI (GET_H_GR (f_left), 1), ANDDI (GET_H_GR (f_right), 31)), NEGDI (SLLDI (1, SUBSI (32, 1))))) ? (NEGSI (SLLSI (1, SUBSI (32, 1)))) : (((LTDI (SLLDI (SUBWORDDISI (GET_H_GR (f_left), 1), ANDDI (GET_H_GR (f_right), 31)), SLLDI (1, SUBSI (32, 1)))) ? (SLLDI (SUBWORDDISI (GET_H_GR (f_left), 1), ANDDI (GET_H_GR (f_right), 31))) : (SUBSI (SLLSI (1, SUBSI (32, 1)), 1)))));
  tmp_result1 = ((LTDI (SLLDI (SUBWORDDISI (GET_H_GR (f_left), 0), ANDDI (GET_H_GR (f_right), 31)), NEGDI (SLLDI (1, SUBSI (32, 1))))) ? (NEGSI (SLLSI (1, SUBSI (32, 1)))) : (((LTDI (SLLDI (SUBWORDDISI (GET_H_GR (f_left), 0), ANDDI (GET_H_GR (f_right), 31)), SLLDI (1, SUBSI (32, 1)))) ? (SLLDI (SUBWORDDISI (GET_H_GR (f_left), 0), ANDDI (GET_H_GR (f_right), 31))) : (SUBSI (SLLSI (1, SUBSI (32, 1)), 1)))));
  {
    DI opval = ORDI (SLLDI (ZEXTSIDI (tmp_result1), 32), ZEXTSIDI (tmp_result0));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }
}

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* mshaldsw: mshalds.w $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,mshaldsw) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

{
  HI tmp_result3;
  HI tmp_result2;
  HI tmp_result1;
  HI tmp_result0;
  tmp_result0 = ((LTDI (SLLDI (SUBWORDDIHI (GET_H_GR (f_left), 3), ANDDI (GET_H_GR (f_right), 15)), NEGDI (SLLDI (1, SUBSI (16, 1))))) ? (NEGHI (SLLHI (1, SUBSI (16, 1)))) : (((LTDI (SLLDI (SUBWORDDIHI (GET_H_GR (f_left), 3), ANDDI (GET_H_GR (f_right), 15)), SLLDI (1, SUBSI (16, 1)))) ? (SLLDI (SUBWORDDIHI (GET_H_GR (f_left), 3), ANDDI (GET_H_GR (f_right), 15))) : (SUBHI (SLLHI (1, SUBSI (16, 1)), 1)))));
  tmp_result1 = ((LTDI (SLLDI (SUBWORDDIHI (GET_H_GR (f_left), 2), ANDDI (GET_H_GR (f_right), 15)), NEGDI (SLLDI (1, SUBSI (16, 1))))) ? (NEGHI (SLLHI (1, SUBSI (16, 1)))) : (((LTDI (SLLDI (SUBWORDDIHI (GET_H_GR (f_left), 2), ANDDI (GET_H_GR (f_right), 15)), SLLDI (1, SUBSI (16, 1)))) ? (SLLDI (SUBWORDDIHI (GET_H_GR (f_left), 2), ANDDI (GET_H_GR (f_right), 15))) : (SUBHI (SLLHI (1, SUBSI (16, 1)), 1)))));
  tmp_result2 = ((LTDI (SLLDI (SUBWORDDIHI (GET_H_GR (f_left), 1), ANDDI (GET_H_GR (f_right), 15)), NEGDI (SLLDI (1, SUBSI (16, 1))))) ? (NEGHI (SLLHI (1, SUBSI (16, 1)))) : (((LTDI (SLLDI (SUBWORDDIHI (GET_H_GR (f_left), 1), ANDDI (GET_H_GR (f_right), 15)), SLLDI (1, SUBSI (16, 1)))) ? (SLLDI (SUBWORDDIHI (GET_H_GR (f_left), 1), ANDDI (GET_H_GR (f_right), 15))) : (SUBHI (SLLHI (1, SUBSI (16, 1)), 1)))));
  tmp_result3 = ((LTDI (SLLDI (SUBWORDDIHI (GET_H_GR (f_left), 0), ANDDI (GET_H_GR (f_right), 15)), NEGDI (SLLDI (1, SUBSI (16, 1))))) ? (NEGHI (SLLHI (1, SUBSI (16, 1)))) : (((LTDI (SLLDI (SUBWORDDIHI (GET_H_GR (f_left), 0), ANDDI (GET_H_GR (f_right), 15)), SLLDI (1, SUBSI (16, 1)))) ? (SLLDI (SUBWORDDIHI (GET_H_GR (f_left), 0), ANDDI (GET_H_GR (f_right), 15))) : (SUBHI (SLLHI (1, SUBSI (16, 1)), 1)))));
  {
    DI opval = ORDI (SLLDI (ZEXTHIDI (tmp_result3), 48), ORDI (SLLDI (ZEXTHIDI (tmp_result2), 32), ORDI (SLLDI (ZEXTHIDI (tmp_result1), 16), ZEXTHIDI (tmp_result0))));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }
}

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* mshardl: mshard.l $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,mshardl) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

{
  SI tmp_result1;
  SI tmp_result0;
  tmp_result0 = SRASI (SUBWORDDISI (GET_H_GR (f_left), 1), ANDDI (GET_H_GR (f_right), 31));
  tmp_result1 = SRASI (SUBWORDDISI (GET_H_GR (f_left), 0), ANDDI (GET_H_GR (f_right), 31));
  {
    DI opval = ORDI (SLLDI (ZEXTSIDI (tmp_result1), 32), ZEXTSIDI (tmp_result0));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }
}

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* mshardw: mshard.w $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,mshardw) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

{
  HI tmp_result3;
  HI tmp_result2;
  HI tmp_result1;
  HI tmp_result0;
  tmp_result0 = SRAHI (SUBWORDDIHI (GET_H_GR (f_left), 3), ANDDI (GET_H_GR (f_right), 15));
  tmp_result1 = SRAHI (SUBWORDDIHI (GET_H_GR (f_left), 2), ANDDI (GET_H_GR (f_right), 15));
  tmp_result2 = SRAHI (SUBWORDDIHI (GET_H_GR (f_left), 1), ANDDI (GET_H_GR (f_right), 15));
  tmp_result3 = SRAHI (SUBWORDDIHI (GET_H_GR (f_left), 0), ANDDI (GET_H_GR (f_right), 15));
  {
    DI opval = ORDI (SLLDI (ZEXTHIDI (tmp_result3), 48), ORDI (SLLDI (ZEXTHIDI (tmp_result2), 32), ORDI (SLLDI (ZEXTHIDI (tmp_result1), 16), ZEXTHIDI (tmp_result0))));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }
}

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* mshardsq: mshards.q $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,mshardsq) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

  {
    DI opval = ((LTDI (SRADI (GET_H_GR (f_left), ANDDI (GET_H_GR (f_right), 63)), NEGDI (SLLDI (1, SUBSI (16, 1))))) ? (NEGDI (SLLDI (1, SUBSI (16, 1)))) : (((LTDI (SRADI (GET_H_GR (f_left), ANDDI (GET_H_GR (f_right), 63)), SLLDI (1, SUBSI (16, 1)))) ? (SRADI (GET_H_GR (f_left), ANDDI (GET_H_GR (f_right), 63))) : (SUBDI (SLLDI (1, SUBSI (16, 1)), 1)))));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* mshfhib: mshfhi.b $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,mshfhib) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

{
  QI tmp_result7;
  QI tmp_result6;
  QI tmp_result5;
  QI tmp_result4;
  QI tmp_result3;
  QI tmp_result2;
  QI tmp_result1;
  QI tmp_result0;
  tmp_result0 = SUBWORDDIQI (GET_H_GR (f_left), 3);
  tmp_result1 = SUBWORDDIQI (GET_H_GR (f_right), 3);
  tmp_result2 = SUBWORDDIQI (GET_H_GR (f_left), 2);
  tmp_result3 = SUBWORDDIQI (GET_H_GR (f_right), 2);
  tmp_result4 = SUBWORDDIQI (GET_H_GR (f_left), 1);
  tmp_result5 = SUBWORDDIQI (GET_H_GR (f_right), 1);
  tmp_result6 = SUBWORDDIQI (GET_H_GR (f_left), 0);
  tmp_result7 = SUBWORDDIQI (GET_H_GR (f_right), 0);
  {
    DI opval = ORDI (SLLDI (ZEXTQIDI (tmp_result7), 56), ORDI (SLLDI (ZEXTQIDI (tmp_result6), 48), ORDI (SLLDI (ZEXTQIDI (tmp_result5), 40), ORDI (SLLDI (ZEXTQIDI (tmp_result4), 32), ORDI (SLLDI (ZEXTQIDI (tmp_result3), 24), ORDI (SLLDI (ZEXTQIDI (tmp_result2), 16), ORDI (SLLDI (ZEXTQIDI (tmp_result1), 8), ZEXTQIDI (tmp_result0))))))));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }
}

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* mshfhil: mshfhi.l $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,mshfhil) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

{
  SI tmp_result1;
  SI tmp_result0;
  tmp_result0 = SUBWORDDISI (GET_H_GR (f_left), 0);
  tmp_result1 = SUBWORDDISI (GET_H_GR (f_right), 0);
  {
    DI opval = ORDI (SLLDI (ZEXTSIDI (tmp_result1), 32), ZEXTSIDI (tmp_result0));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }
}

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* mshfhiw: mshfhi.w $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,mshfhiw) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

{
  HI tmp_result3;
  HI tmp_result2;
  HI tmp_result1;
  HI tmp_result0;
  tmp_result0 = SUBWORDDIHI (GET_H_GR (f_left), 1);
  tmp_result1 = SUBWORDDIHI (GET_H_GR (f_right), 1);
  tmp_result2 = SUBWORDDIHI (GET_H_GR (f_left), 0);
  tmp_result3 = SUBWORDDIHI (GET_H_GR (f_right), 0);
  {
    DI opval = ORDI (SLLDI (ZEXTHIDI (tmp_result3), 48), ORDI (SLLDI (ZEXTHIDI (tmp_result2), 32), ORDI (SLLDI (ZEXTHIDI (tmp_result1), 16), ZEXTHIDI (tmp_result0))));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }
}

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* mshflob: mshflo.b $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,mshflob) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

{
  QI tmp_result7;
  QI tmp_result6;
  QI tmp_result5;
  QI tmp_result4;
  QI tmp_result3;
  QI tmp_result2;
  QI tmp_result1;
  QI tmp_result0;
  tmp_result0 = SUBWORDDIQI (GET_H_GR (f_left), 7);
  tmp_result1 = SUBWORDDIQI (GET_H_GR (f_right), 7);
  tmp_result2 = SUBWORDDIQI (GET_H_GR (f_left), 6);
  tmp_result3 = SUBWORDDIQI (GET_H_GR (f_right), 6);
  tmp_result4 = SUBWORDDIQI (GET_H_GR (f_left), 5);
  tmp_result5 = SUBWORDDIQI (GET_H_GR (f_right), 5);
  tmp_result6 = SUBWORDDIQI (GET_H_GR (f_left), 4);
  tmp_result7 = SUBWORDDIQI (GET_H_GR (f_right), 4);
  {
    DI opval = ORDI (SLLDI (ZEXTQIDI (tmp_result7), 56), ORDI (SLLDI (ZEXTQIDI (tmp_result6), 48), ORDI (SLLDI (ZEXTQIDI (tmp_result5), 40), ORDI (SLLDI (ZEXTQIDI (tmp_result4), 32), ORDI (SLLDI (ZEXTQIDI (tmp_result3), 24), ORDI (SLLDI (ZEXTQIDI (tmp_result2), 16), ORDI (SLLDI (ZEXTQIDI (tmp_result1), 8), ZEXTQIDI (tmp_result0))))))));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }
}

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* mshflol: mshflo.l $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,mshflol) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

{
  SI tmp_result1;
  SI tmp_result0;
  tmp_result0 = SUBWORDDISI (GET_H_GR (f_left), 1);
  tmp_result1 = SUBWORDDISI (GET_H_GR (f_right), 1);
  {
    DI opval = ORDI (SLLDI (ZEXTSIDI (tmp_result1), 32), ZEXTSIDI (tmp_result0));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }
}

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* mshflow: mshflo.w $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,mshflow) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

{
  HI tmp_result3;
  HI tmp_result2;
  HI tmp_result1;
  HI tmp_result0;
  tmp_result0 = SUBWORDDIHI (GET_H_GR (f_left), 3);
  tmp_result1 = SUBWORDDIHI (GET_H_GR (f_right), 3);
  tmp_result2 = SUBWORDDIHI (GET_H_GR (f_left), 2);
  tmp_result3 = SUBWORDDIHI (GET_H_GR (f_right), 2);
  {
    DI opval = ORDI (SLLDI (ZEXTHIDI (tmp_result3), 48), ORDI (SLLDI (ZEXTHIDI (tmp_result2), 32), ORDI (SLLDI (ZEXTHIDI (tmp_result1), 16), ZEXTHIDI (tmp_result0))));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }
}

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* mshlldl: mshlld.l $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,mshlldl) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

{
  SI tmp_result1;
  SI tmp_result0;
  tmp_result0 = SLLSI (SUBWORDDISI (GET_H_GR (f_left), 1), ANDDI (GET_H_GR (f_right), 31));
  tmp_result1 = SLLSI (SUBWORDDISI (GET_H_GR (f_left), 0), ANDDI (GET_H_GR (f_right), 31));
  {
    DI opval = ORDI (SLLDI (ZEXTSIDI (tmp_result1), 32), ZEXTSIDI (tmp_result0));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }
}

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* mshlldw: mshlld.w $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,mshlldw) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

{
  HI tmp_result3;
  HI tmp_result2;
  HI tmp_result1;
  HI tmp_result0;
  tmp_result0 = SLLHI (SUBWORDDIHI (GET_H_GR (f_left), 3), ANDDI (GET_H_GR (f_right), 15));
  tmp_result1 = SLLHI (SUBWORDDIHI (GET_H_GR (f_left), 2), ANDDI (GET_H_GR (f_right), 15));
  tmp_result2 = SLLHI (SUBWORDDIHI (GET_H_GR (f_left), 1), ANDDI (GET_H_GR (f_right), 15));
  tmp_result3 = SLLHI (SUBWORDDIHI (GET_H_GR (f_left), 0), ANDDI (GET_H_GR (f_right), 15));
  {
    DI opval = ORDI (SLLDI (ZEXTHIDI (tmp_result3), 48), ORDI (SLLDI (ZEXTHIDI (tmp_result2), 32), ORDI (SLLDI (ZEXTHIDI (tmp_result1), 16), ZEXTHIDI (tmp_result0))));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }
}

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* mshlrdl: mshlrd.l $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,mshlrdl) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

{
  SI tmp_result1;
  SI tmp_result0;
  tmp_result0 = SRLSI (SUBWORDDISI (GET_H_GR (f_left), 1), ANDDI (GET_H_GR (f_right), 31));
  tmp_result1 = SRLSI (SUBWORDDISI (GET_H_GR (f_left), 0), ANDDI (GET_H_GR (f_right), 31));
  {
    DI opval = ORDI (SLLDI (ZEXTSIDI (tmp_result1), 32), ZEXTSIDI (tmp_result0));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }
}

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* mshlrdw: mshlrd.w $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,mshlrdw) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

{
  HI tmp_result3;
  HI tmp_result2;
  HI tmp_result1;
  HI tmp_result0;
  tmp_result0 = SRLHI (SUBWORDDIHI (GET_H_GR (f_left), 3), ANDDI (GET_H_GR (f_right), 15));
  tmp_result1 = SRLHI (SUBWORDDIHI (GET_H_GR (f_left), 2), ANDDI (GET_H_GR (f_right), 15));
  tmp_result2 = SRLHI (SUBWORDDIHI (GET_H_GR (f_left), 1), ANDDI (GET_H_GR (f_right), 15));
  tmp_result3 = SRLHI (SUBWORDDIHI (GET_H_GR (f_left), 0), ANDDI (GET_H_GR (f_right), 15));
  {
    DI opval = ORDI (SLLDI (ZEXTHIDI (tmp_result3), 48), ORDI (SLLDI (ZEXTHIDI (tmp_result2), 32), ORDI (SLLDI (ZEXTHIDI (tmp_result1), 16), ZEXTHIDI (tmp_result0))));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }
}

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* msubl: msub.l $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,msubl) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

{
  SI tmp_result1;
  SI tmp_result0;
  tmp_result0 = SUBSI (SUBWORDDISI (GET_H_GR (f_left), 1), SUBWORDDISI (GET_H_GR (f_right), 1));
  tmp_result1 = SUBSI (SUBWORDDISI (GET_H_GR (f_left), 0), SUBWORDDISI (GET_H_GR (f_right), 0));
  {
    DI opval = ORDI (SLLDI (ZEXTSIDI (tmp_result1), 32), ZEXTSIDI (tmp_result0));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }
}

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* msubw: msub.w $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,msubw) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

{
  HI tmp_result3;
  HI tmp_result2;
  HI tmp_result1;
  HI tmp_result0;
  tmp_result0 = SUBHI (SUBWORDDIHI (GET_H_GR (f_left), 3), SUBWORDDIHI (GET_H_GR (f_right), 3));
  tmp_result1 = SUBHI (SUBWORDDIHI (GET_H_GR (f_left), 2), SUBWORDDIHI (GET_H_GR (f_right), 2));
  tmp_result2 = SUBHI (SUBWORDDIHI (GET_H_GR (f_left), 1), SUBWORDDIHI (GET_H_GR (f_right), 1));
  tmp_result3 = SUBHI (SUBWORDDIHI (GET_H_GR (f_left), 0), SUBWORDDIHI (GET_H_GR (f_right), 0));
  {
    DI opval = ORDI (SLLDI (ZEXTHIDI (tmp_result3), 48), ORDI (SLLDI (ZEXTHIDI (tmp_result2), 32), ORDI (SLLDI (ZEXTHIDI (tmp_result1), 16), ZEXTHIDI (tmp_result0))));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }
}

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* msubsl: msubs.l $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,msubsl) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

{
  SI tmp_result1;
  SI tmp_result0;
  tmp_result0 = ((LTDI (SUBDI (EXTSIDI (SUBWORDDISI (GET_H_GR (f_left), 1)), EXTSIDI (SUBWORDDISI (GET_H_GR (f_right), 1))), NEGDI (SLLDI (1, SUBSI (32, 1))))) ? (NEGSI (SLLSI (1, SUBSI (32, 1)))) : (((LTDI (SUBDI (EXTSIDI (SUBWORDDISI (GET_H_GR (f_left), 1)), EXTSIDI (SUBWORDDISI (GET_H_GR (f_right), 1))), SLLDI (1, SUBSI (32, 1)))) ? (SUBDI (EXTSIDI (SUBWORDDISI (GET_H_GR (f_left), 1)), EXTSIDI (SUBWORDDISI (GET_H_GR (f_right), 1)))) : (SUBSI (SLLSI (1, SUBSI (32, 1)), 1)))));
  tmp_result1 = ((LTDI (SUBDI (EXTSIDI (SUBWORDDISI (GET_H_GR (f_left), 0)), EXTSIDI (SUBWORDDISI (GET_H_GR (f_right), 0))), NEGDI (SLLDI (1, SUBSI (32, 1))))) ? (NEGSI (SLLSI (1, SUBSI (32, 1)))) : (((LTDI (SUBDI (EXTSIDI (SUBWORDDISI (GET_H_GR (f_left), 0)), EXTSIDI (SUBWORDDISI (GET_H_GR (f_right), 0))), SLLDI (1, SUBSI (32, 1)))) ? (SUBDI (EXTSIDI (SUBWORDDISI (GET_H_GR (f_left), 0)), EXTSIDI (SUBWORDDISI (GET_H_GR (f_right), 0)))) : (SUBSI (SLLSI (1, SUBSI (32, 1)), 1)))));
  {
    DI opval = ORDI (SLLDI (ZEXTSIDI (tmp_result1), 32), ZEXTSIDI (tmp_result0));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }
}

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* msubsub: msubs.ub $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,msubsub) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

{
  QI tmp_result7;
  QI tmp_result6;
  QI tmp_result5;
  QI tmp_result4;
  QI tmp_result3;
  QI tmp_result2;
  QI tmp_result1;
  QI tmp_result0;
  tmp_result0 = ((LTDI (SUBDI (ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_left), 7)), ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_right), 7))), MAKEDI (0, 0))) ? (0) : (((LTDI (SUBDI (ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_left), 7)), ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_right), 7))), SLLDI (1, 8))) ? (SUBDI (ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_left), 7)), ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_right), 7)))) : (SUBQI (SLLQI (1, 8), 1)))));
  tmp_result1 = ((LTDI (SUBDI (ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_left), 6)), ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_right), 6))), MAKEDI (0, 0))) ? (0) : (((LTDI (SUBDI (ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_left), 6)), ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_right), 6))), SLLDI (1, 8))) ? (SUBDI (ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_left), 6)), ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_right), 6)))) : (SUBQI (SLLQI (1, 8), 1)))));
  tmp_result2 = ((LTDI (SUBDI (ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_left), 5)), ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_right), 5))), MAKEDI (0, 0))) ? (0) : (((LTDI (SUBDI (ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_left), 5)), ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_right), 5))), SLLDI (1, 8))) ? (SUBDI (ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_left), 5)), ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_right), 5)))) : (SUBQI (SLLQI (1, 8), 1)))));
  tmp_result3 = ((LTDI (SUBDI (ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_left), 4)), ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_right), 4))), MAKEDI (0, 0))) ? (0) : (((LTDI (SUBDI (ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_left), 4)), ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_right), 4))), SLLDI (1, 8))) ? (SUBDI (ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_left), 4)), ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_right), 4)))) : (SUBQI (SLLQI (1, 8), 1)))));
  tmp_result4 = ((LTDI (SUBDI (ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_left), 3)), ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_right), 3))), MAKEDI (0, 0))) ? (0) : (((LTDI (SUBDI (ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_left), 3)), ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_right), 3))), SLLDI (1, 8))) ? (SUBDI (ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_left), 3)), ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_right), 3)))) : (SUBQI (SLLQI (1, 8), 1)))));
  tmp_result5 = ((LTDI (SUBDI (ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_left), 2)), ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_right), 2))), MAKEDI (0, 0))) ? (0) : (((LTDI (SUBDI (ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_left), 2)), ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_right), 2))), SLLDI (1, 8))) ? (SUBDI (ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_left), 2)), ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_right), 2)))) : (SUBQI (SLLQI (1, 8), 1)))));
  tmp_result6 = ((LTDI (SUBDI (ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_left), 1)), ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_right), 1))), MAKEDI (0, 0))) ? (0) : (((LTDI (SUBDI (ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_left), 1)), ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_right), 1))), SLLDI (1, 8))) ? (SUBDI (ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_left), 1)), ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_right), 1)))) : (SUBQI (SLLQI (1, 8), 1)))));
  tmp_result7 = ((LTDI (SUBDI (ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_left), 0)), ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_right), 0))), MAKEDI (0, 0))) ? (0) : (((LTDI (SUBDI (ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_left), 0)), ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_right), 0))), SLLDI (1, 8))) ? (SUBDI (ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_left), 0)), ZEXTQIDI (SUBWORDDIQI (GET_H_GR (f_right), 0)))) : (SUBQI (SLLQI (1, 8), 1)))));
  {
    DI opval = ORDI (SLLDI (ZEXTQIDI (tmp_result7), 56), ORDI (SLLDI (ZEXTQIDI (tmp_result6), 48), ORDI (SLLDI (ZEXTQIDI (tmp_result5), 40), ORDI (SLLDI (ZEXTQIDI (tmp_result4), 32), ORDI (SLLDI (ZEXTQIDI (tmp_result3), 24), ORDI (SLLDI (ZEXTQIDI (tmp_result2), 16), ORDI (SLLDI (ZEXTQIDI (tmp_result1), 8), ZEXTQIDI (tmp_result0))))))));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }
}

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* msubsw: msubs.w $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,msubsw) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

{
  QI tmp_result7;
  QI tmp_result6;
  QI tmp_result5;
  QI tmp_result4;
  QI tmp_result3;
  QI tmp_result2;
  QI tmp_result1;
  QI tmp_result0;
  tmp_result0 = ((LTDI (SUBDI (EXTQIDI (SUBWORDDIQI (GET_H_GR (f_left), 7)), EXTQIDI (SUBWORDDIQI (GET_H_GR (f_right), 7))), NEGDI (SLLDI (1, SUBSI (16, 1))))) ? (NEGHI (SLLHI (1, SUBSI (16, 1)))) : (((LTDI (SUBDI (EXTQIDI (SUBWORDDIQI (GET_H_GR (f_left), 7)), EXTQIDI (SUBWORDDIQI (GET_H_GR (f_right), 7))), SLLDI (1, SUBSI (16, 1)))) ? (SUBDI (EXTQIDI (SUBWORDDIQI (GET_H_GR (f_left), 7)), EXTQIDI (SUBWORDDIQI (GET_H_GR (f_right), 7)))) : (SUBHI (SLLHI (1, SUBSI (16, 1)), 1)))));
  tmp_result1 = ((LTDI (SUBDI (EXTQIDI (SUBWORDDIQI (GET_H_GR (f_left), 6)), EXTQIDI (SUBWORDDIQI (GET_H_GR (f_right), 6))), NEGDI (SLLDI (1, SUBSI (16, 1))))) ? (NEGHI (SLLHI (1, SUBSI (16, 1)))) : (((LTDI (SUBDI (EXTQIDI (SUBWORDDIQI (GET_H_GR (f_left), 6)), EXTQIDI (SUBWORDDIQI (GET_H_GR (f_right), 6))), SLLDI (1, SUBSI (16, 1)))) ? (SUBDI (EXTQIDI (SUBWORDDIQI (GET_H_GR (f_left), 6)), EXTQIDI (SUBWORDDIQI (GET_H_GR (f_right), 6)))) : (SUBHI (SLLHI (1, SUBSI (16, 1)), 1)))));
  tmp_result2 = ((LTDI (SUBDI (EXTQIDI (SUBWORDDIQI (GET_H_GR (f_left), 5)), EXTQIDI (SUBWORDDIQI (GET_H_GR (f_right), 5))), NEGDI (SLLDI (1, SUBSI (16, 1))))) ? (NEGHI (SLLHI (1, SUBSI (16, 1)))) : (((LTDI (SUBDI (EXTQIDI (SUBWORDDIQI (GET_H_GR (f_left), 5)), EXTQIDI (SUBWORDDIQI (GET_H_GR (f_right), 5))), SLLDI (1, SUBSI (16, 1)))) ? (SUBDI (EXTQIDI (SUBWORDDIQI (GET_H_GR (f_left), 5)), EXTQIDI (SUBWORDDIQI (GET_H_GR (f_right), 5)))) : (SUBHI (SLLHI (1, SUBSI (16, 1)), 1)))));
  tmp_result3 = ((LTDI (SUBDI (EXTQIDI (SUBWORDDIQI (GET_H_GR (f_left), 4)), EXTQIDI (SUBWORDDIQI (GET_H_GR (f_right), 4))), NEGDI (SLLDI (1, SUBSI (16, 1))))) ? (NEGHI (SLLHI (1, SUBSI (16, 1)))) : (((LTDI (SUBDI (EXTQIDI (SUBWORDDIQI (GET_H_GR (f_left), 4)), EXTQIDI (SUBWORDDIQI (GET_H_GR (f_right), 4))), SLLDI (1, SUBSI (16, 1)))) ? (SUBDI (EXTQIDI (SUBWORDDIQI (GET_H_GR (f_left), 4)), EXTQIDI (SUBWORDDIQI (GET_H_GR (f_right), 4)))) : (SUBHI (SLLHI (1, SUBSI (16, 1)), 1)))));
  tmp_result4 = ((LTDI (SUBDI (EXTQIDI (SUBWORDDIQI (GET_H_GR (f_left), 3)), EXTQIDI (SUBWORDDIQI (GET_H_GR (f_right), 3))), NEGDI (SLLDI (1, SUBSI (16, 1))))) ? (NEGHI (SLLHI (1, SUBSI (16, 1)))) : (((LTDI (SUBDI (EXTQIDI (SUBWORDDIQI (GET_H_GR (f_left), 3)), EXTQIDI (SUBWORDDIQI (GET_H_GR (f_right), 3))), SLLDI (1, SUBSI (16, 1)))) ? (SUBDI (EXTQIDI (SUBWORDDIQI (GET_H_GR (f_left), 3)), EXTQIDI (SUBWORDDIQI (GET_H_GR (f_right), 3)))) : (SUBHI (SLLHI (1, SUBSI (16, 1)), 1)))));
  tmp_result5 = ((LTDI (SUBDI (EXTQIDI (SUBWORDDIQI (GET_H_GR (f_left), 2)), EXTQIDI (SUBWORDDIQI (GET_H_GR (f_right), 2))), NEGDI (SLLDI (1, SUBSI (16, 1))))) ? (NEGHI (SLLHI (1, SUBSI (16, 1)))) : (((LTDI (SUBDI (EXTQIDI (SUBWORDDIQI (GET_H_GR (f_left), 2)), EXTQIDI (SUBWORDDIQI (GET_H_GR (f_right), 2))), SLLDI (1, SUBSI (16, 1)))) ? (SUBDI (EXTQIDI (SUBWORDDIQI (GET_H_GR (f_left), 2)), EXTQIDI (SUBWORDDIQI (GET_H_GR (f_right), 2)))) : (SUBHI (SLLHI (1, SUBSI (16, 1)), 1)))));
  tmp_result6 = ((LTDI (SUBDI (EXTQIDI (SUBWORDDIQI (GET_H_GR (f_left), 1)), EXTQIDI (SUBWORDDIQI (GET_H_GR (f_right), 1))), NEGDI (SLLDI (1, SUBSI (16, 1))))) ? (NEGHI (SLLHI (1, SUBSI (16, 1)))) : (((LTDI (SUBDI (EXTQIDI (SUBWORDDIQI (GET_H_GR (f_left), 1)), EXTQIDI (SUBWORDDIQI (GET_H_GR (f_right), 1))), SLLDI (1, SUBSI (16, 1)))) ? (SUBDI (EXTQIDI (SUBWORDDIQI (GET_H_GR (f_left), 1)), EXTQIDI (SUBWORDDIQI (GET_H_GR (f_right), 1)))) : (SUBHI (SLLHI (1, SUBSI (16, 1)), 1)))));
  tmp_result7 = ((LTDI (SUBDI (EXTQIDI (SUBWORDDIQI (GET_H_GR (f_left), 0)), EXTQIDI (SUBWORDDIQI (GET_H_GR (f_right), 0))), NEGDI (SLLDI (1, SUBSI (16, 1))))) ? (NEGHI (SLLHI (1, SUBSI (16, 1)))) : (((LTDI (SUBDI (EXTQIDI (SUBWORDDIQI (GET_H_GR (f_left), 0)), EXTQIDI (SUBWORDDIQI (GET_H_GR (f_right), 0))), SLLDI (1, SUBSI (16, 1)))) ? (SUBDI (EXTQIDI (SUBWORDDIQI (GET_H_GR (f_left), 0)), EXTQIDI (SUBWORDDIQI (GET_H_GR (f_right), 0)))) : (SUBHI (SLLHI (1, SUBSI (16, 1)), 1)))));
  {
    DI opval = ORDI (SLLDI (ZEXTQIDI (tmp_result7), 56), ORDI (SLLDI (ZEXTQIDI (tmp_result6), 48), ORDI (SLLDI (ZEXTQIDI (tmp_result5), 40), ORDI (SLLDI (ZEXTQIDI (tmp_result4), 32), ORDI (SLLDI (ZEXTQIDI (tmp_result3), 24), ORDI (SLLDI (ZEXTQIDI (tmp_result2), 16), ORDI (SLLDI (ZEXTQIDI (tmp_result1), 8), ZEXTQIDI (tmp_result0))))))));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }
}

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* mulsl: muls.l $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,mulsl) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

  {
    DI opval = MULDI (EXTSIDI (SUBWORDDISI (GET_H_GR (f_left), 1)), EXTSIDI (SUBWORDDISI (GET_H_GR (f_right), 1)));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* mulul: mulu.l $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,mulul) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

  {
    DI opval = MULDI (ZEXTSIDI (SUBWORDDISI (GET_H_GR (f_left), 1)), ZEXTSIDI (SUBWORDDISI (GET_H_GR (f_right), 1)));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* nop: nop */

static SEM_STATUS
SEM_FN_NAME (@prefix@,nop) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_BRK_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_BRK_CODE

((void) 0); /*nop*/

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* nsb: nsb $rm, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,nsb) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_BYTEREV_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_BYTEREV_CODE

  {
    DI opval = sh64_nsb (current_cpu, GET_H_GR (f_left));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* ocbi: ocbi $rm, $disp6x32 */

static SEM_STATUS
SEM_FN_NAME (@prefix@,ocbi) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ALLOCO_VARS /* f-op f-left f-ext f-disp6x32 f-dest f-rsvd */
  EXTRACT_IFMT_ALLOCO_CODE

((void) 0); /*nop*/

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* ocbp: ocbp $rm, $disp6x32 */

static SEM_STATUS
SEM_FN_NAME (@prefix@,ocbp) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ALLOCO_VARS /* f-op f-left f-ext f-disp6x32 f-dest f-rsvd */
  EXTRACT_IFMT_ALLOCO_CODE

((void) 0); /*nop*/

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* ocbwb: ocbwb $rm, $disp6x32 */

static SEM_STATUS
SEM_FN_NAME (@prefix@,ocbwb) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ALLOCO_VARS /* f-op f-left f-ext f-disp6x32 f-dest f-rsvd */
  EXTRACT_IFMT_ALLOCO_CODE

((void) 0); /*nop*/

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* or: or $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,or) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

  {
    DI opval = ORDI (GET_H_GR (f_left), GET_H_GR (f_right));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* ori: ori $rm, $imm10, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,ori) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ORI_VARS /* f-op f-left f-imm10 f-dest f-rsvd */
  EXTRACT_IFMT_ORI_CODE

  {
    DI opval = ORDI (GET_H_GR (f_left), EXTSIDI (f_imm10));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* prefi: prefi $rm, $disp6x32 */

static SEM_STATUS
SEM_FN_NAME (@prefix@,prefi) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_PREFI_VARS /* f-op f-left f-ext f-disp6x32 f-right f-rsvd */
  EXTRACT_IFMT_PREFI_CODE

((void) 0); /*nop*/

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* pta: pta$likely $disp16, $tra */

static SEM_STATUS
SEM_FN_NAME (@prefix@,pta) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_PTA_VARS /* f-op f-disp16 f-likely f-8-2 f-tra f-rsvd */
  EXTRACT_IFMT_PTA_CODE

  {
    DI opval = ADDSI (f_disp16, 1);
    CPU (h_tr[f_tra]) = opval;
    TRACE_RESULT (current_cpu, abuf, "tr", 'D', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* ptabs: ptabs$likely $rn, $tra */

static SEM_STATUS
SEM_FN_NAME (@prefix@,ptabs) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_PTABS_VARS /* f-op f-left f-ext f-right f-likely f-8-2 f-tra f-rsvd */
  EXTRACT_IFMT_PTABS_CODE

  {
    DI opval = GET_H_GR (f_right);
    CPU (h_tr[f_tra]) = opval;
    TRACE_RESULT (current_cpu, abuf, "tr", 'D', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* ptb: ptb$likely $disp16, $tra */

static SEM_STATUS
SEM_FN_NAME (@prefix@,ptb) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_PTA_VARS /* f-op f-disp16 f-likely f-8-2 f-tra f-rsvd */
  EXTRACT_IFMT_PTA_CODE

  {
    DI opval = f_disp16;
    CPU (h_tr[f_tra]) = opval;
    TRACE_RESULT (current_cpu, abuf, "tr", 'D', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* ptrel: ptrel$likely $rn, $tra */

static SEM_STATUS
SEM_FN_NAME (@prefix@,ptrel) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_PTABS_VARS /* f-op f-left f-ext f-right f-likely f-8-2 f-tra f-rsvd */
  EXTRACT_IFMT_PTABS_CODE

  {
    DI opval = ADDDI (pc, GET_H_GR (f_right));
    CPU (h_tr[f_tra]) = opval;
    TRACE_RESULT (current_cpu, abuf, "tr", 'D', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* putcfg: putcfg $rm, $disp6, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,putcfg) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_GETCFG_VARS /* f-op f-left f-ext f-disp6 f-dest f-rsvd */
  EXTRACT_IFMT_GETCFG_CODE

((void) 0); /*nop*/

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* putcon: putcon $rm, $crj */

static SEM_STATUS
SEM_FN_NAME (@prefix@,putcon) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_PUTCON_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_PUTCON_CODE

  {
    DI opval = GET_H_GR (f_left);
    SET_H_CR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "cr", 'D', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* rte: rte */

static SEM_STATUS
SEM_FN_NAME (@prefix@,rte) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_BRK_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_BRK_CODE

((void) 0); /*nop*/

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* shard: shard $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,shard) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

  {
    DI opval = SRADI (GET_H_GR (f_left), ANDDI (GET_H_GR (f_right), 63));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* shardl: shard.l $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,shardl) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

  {
    DI opval = EXTSIDI (SRASI (SUBWORDDISI (GET_H_GR (f_left), 1), ANDDI (GET_H_GR (f_right), 63)));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* shari: shari $rm, $uimm6, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,shari) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_SHARI_VARS /* f-op f-left f-ext f-uimm6 f-dest f-rsvd */
  EXTRACT_IFMT_SHARI_CODE

  {
    DI opval = SRADI (GET_H_GR (f_left), f_uimm6);
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* sharil: shari.l $rm, $uimm6, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,sharil) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_SHARI_VARS /* f-op f-left f-ext f-uimm6 f-dest f-rsvd */
  EXTRACT_IFMT_SHARI_CODE

  {
    DI opval = EXTSIDI (SRASI (SUBWORDDISI (GET_H_GR (f_left), 1), ANDSI (f_uimm6, 63)));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* shlld: shlld $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,shlld) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

  {
    DI opval = SLLDI (GET_H_GR (f_left), ANDDI (GET_H_GR (f_right), 63));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* shlldl: shlld.l $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,shlldl) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

  {
    DI opval = EXTSIDI (SLLSI (SUBWORDDISI (GET_H_GR (f_left), 1), ANDDI (GET_H_GR (f_right), 63)));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* shlli: shlli $rm, $uimm6, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,shlli) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_SHARI_VARS /* f-op f-left f-ext f-uimm6 f-dest f-rsvd */
  EXTRACT_IFMT_SHARI_CODE

  {
    DI opval = SLLDI (GET_H_GR (f_left), f_uimm6);
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* shllil: shlli.l $rm, $uimm6, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,shllil) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_SHARI_VARS /* f-op f-left f-ext f-uimm6 f-dest f-rsvd */
  EXTRACT_IFMT_SHARI_CODE

  {
    DI opval = EXTSIDI (SLLSI (SUBWORDDISI (GET_H_GR (f_left), 1), ANDSI (f_uimm6, 63)));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* shlrd: shlrd $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,shlrd) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

  {
    DI opval = SRLDI (GET_H_GR (f_left), ANDDI (GET_H_GR (f_right), 63));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* shlrdl: shlrd.l $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,shlrdl) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

  {
    DI opval = EXTSIDI (SRLSI (SUBWORDDISI (GET_H_GR (f_left), 1), ANDDI (GET_H_GR (f_right), 63)));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* shlri: shlri $rm, $uimm6, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,shlri) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_SHARI_VARS /* f-op f-left f-ext f-uimm6 f-dest f-rsvd */
  EXTRACT_IFMT_SHARI_CODE

  {
    DI opval = SRLDI (GET_H_GR (f_left), f_uimm6);
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* shlril: shlri.l $rm, $uimm6, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,shlril) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_SHARI_VARS /* f-op f-left f-ext f-uimm6 f-dest f-rsvd */
  EXTRACT_IFMT_SHARI_CODE

  {
    DI opval = EXTSIDI (SRLSI (SUBWORDDISI (GET_H_GR (f_left), 1), ANDSI (f_uimm6, 63)));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* shori: shori $uimm16, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,shori) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_SHORI_VARS /* f-op f-uimm16 f-dest f-rsvd */
  EXTRACT_IFMT_SHORI_CODE

  {
    DI opval = ORDI (SLLDI (GET_H_GR (f_dest), 16), ZEXTSIDI (f_uimm16));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* sleep: sleep */

static SEM_STATUS
SEM_FN_NAME (@prefix@,sleep) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_BRK_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_BRK_CODE

((void) 0); /*nop*/

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* stb: st.b $rm, $disp10, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,stb) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADDI_VARS /* f-op f-left f-disp10 f-dest f-rsvd */
  EXTRACT_IFMT_ADDI_CODE

  {
    UQI opval = ANDQI (GET_H_GR (f_dest), 255);
    SETMEMUQI (current_cpu, pc, ADDDI (GET_H_GR (f_left), EXTSIDI (f_disp10)), opval);
    TRACE_RESULT (current_cpu, abuf, "memory", 'x', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* stl: st.l $rm, $disp10x4, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,stl) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_LDL_VARS /* f-op f-left f-disp10x4 f-dest f-rsvd */
  EXTRACT_IFMT_LDL_CODE

  {
    SI opval = ANDSI (GET_H_GR (f_dest), 0xffffffff);
    SETMEMSI (current_cpu, pc, ADDDI (GET_H_GR (f_left), EXTSIDI (f_disp10x4)), opval);
    TRACE_RESULT (current_cpu, abuf, "memory", 'x', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* stq: st.q $rm, $disp10x8, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,stq) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_LDQ_VARS /* f-op f-left f-disp10x8 f-dest f-rsvd */
  EXTRACT_IFMT_LDQ_CODE

  {
    DI opval = GET_H_GR (f_dest);
    SETMEMDI (current_cpu, pc, ADDDI (GET_H_GR (f_left), EXTSIDI (f_disp10x8)), opval);
    TRACE_RESULT (current_cpu, abuf, "memory", 'D', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* stw: st.w $rm, $disp10x2, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,stw) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_STW_VARS /* f-op f-left f-disp10x2 f-dest f-rsvd */
  EXTRACT_IFMT_STW_CODE

  {
    HI opval = ANDHI (GET_H_GR (f_dest), 65535);
    SETMEMHI (current_cpu, pc, ADDDI (GET_H_GR (f_left), EXTSIDI (f_disp10x2)), opval);
    TRACE_RESULT (current_cpu, abuf, "memory", 'x', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* sthil: sthi.l $rm, $disp6, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,sthil) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_GETCFG_VARS /* f-op f-left f-ext f-disp6 f-dest f-rsvd */
  EXTRACT_IFMT_GETCFG_CODE

{
  DI tmp_addr;
  QI tmp_bytecount;
  DI tmp_val;
  tmp_addr = ADDDI (GET_H_GR (f_left), f_disp6);
  tmp_bytecount = ADDDI (ANDDI (tmp_addr, 3), 1);
if (ANDQI (tmp_bytecount, 4)) {
  {
    SI opval = GET_H_GR (f_dest);
    SETMEMSI (current_cpu, pc, ANDDI (tmp_addr, -4), opval);
    written |= (1 << 5);
    TRACE_RESULT (current_cpu, abuf, "memory", 'x', opval);
  }
} else {
if (GET_H_ENDIAN ()) {
{
  tmp_val = GET_H_GR (f_dest);
if (ANDQI (tmp_bytecount, 1)) {
{
  {
    UQI opval = ANDQI (tmp_val, 255);
    SETMEMUQI (current_cpu, pc, tmp_addr, opval);
    written |= (1 << 6);
    TRACE_RESULT (current_cpu, abuf, "memory", 'x', opval);
  }
  tmp_val = SRLDI (tmp_val, 8);
}
}
if (ANDQI (tmp_bytecount, 2)) {
{
  {
    HI opval = ANDHI (tmp_val, 65535);
    SETMEMHI (current_cpu, pc, ANDDI (tmp_addr, -4), opval);
    written |= (1 << 4);
    TRACE_RESULT (current_cpu, abuf, "memory", 'x', opval);
  }
  tmp_val = SRLDI (tmp_val, 16);
}
}
}
} else {
{
  tmp_val = SRLDI (GET_H_GR (f_dest), SUBSI (32, MULSI (8, tmp_bytecount)));
if (ANDQI (tmp_bytecount, 2)) {
{
  {
    HI opval = ANDHI (tmp_val, 65535);
    SETMEMHI (current_cpu, pc, ANDDI (tmp_addr, -4), opval);
    written |= (1 << 4);
    TRACE_RESULT (current_cpu, abuf, "memory", 'x', opval);
  }
  tmp_val = SRLDI (tmp_val, 16);
}
}
if (ANDQI (tmp_bytecount, 1)) {
{
  {
    UQI opval = ANDQI (tmp_val, 255);
    SETMEMUQI (current_cpu, pc, tmp_addr, opval);
    written |= (1 << 6);
    TRACE_RESULT (current_cpu, abuf, "memory", 'x', opval);
  }
  tmp_val = SRLDI (tmp_val, 8);
}
}
}
}
}
}

  abuf->written = written;
  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* sthiq: sthi.q $rm, $disp6, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,sthiq) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_GETCFG_VARS /* f-op f-left f-ext f-disp6 f-dest f-rsvd */
  EXTRACT_IFMT_GETCFG_CODE

{
  DI tmp_addr;
  QI tmp_bytecount;
  DI tmp_val;
  tmp_addr = ADDDI (GET_H_GR (f_left), f_disp6);
  tmp_bytecount = ADDDI (ANDDI (tmp_addr, 7), 1);
if (ANDQI (tmp_bytecount, 8)) {
  {
    DI opval = GET_H_GR (f_dest);
    SETMEMDI (current_cpu, pc, ANDDI (tmp_addr, -8), opval);
    written |= (1 << 4);
    TRACE_RESULT (current_cpu, abuf, "memory", 'D', opval);
  }
} else {
if (GET_H_ENDIAN ()) {
{
  tmp_val = GET_H_GR (f_dest);
if (ANDQI (tmp_bytecount, 1)) {
{
  {
    UQI opval = ANDQI (tmp_val, 255);
    SETMEMUQI (current_cpu, pc, tmp_addr, opval);
    written |= (1 << 7);
    TRACE_RESULT (current_cpu, abuf, "memory", 'x', opval);
  }
  tmp_val = SRLDI (tmp_val, 8);
}
}
if (ANDQI (tmp_bytecount, 2)) {
{
  {
    HI opval = ANDHI (tmp_val, 65535);
    SETMEMHI (current_cpu, pc, ANDDI (tmp_addr, -4), opval);
    written |= (1 << 5);
    TRACE_RESULT (current_cpu, abuf, "memory", 'x', opval);
  }
  tmp_val = SRLDI (tmp_val, 16);
}
}
if (ANDQI (tmp_bytecount, 4)) {
{
  {
    SI opval = ANDSI (tmp_val, 0xffffffff);
    SETMEMSI (current_cpu, pc, ANDDI (tmp_addr, -8), opval);
    written |= (1 << 6);
    TRACE_RESULT (current_cpu, abuf, "memory", 'x', opval);
  }
  tmp_val = SRLDI (tmp_val, 32);
}
}
}
} else {
{
  tmp_val = SRLDI (GET_H_GR (f_dest), SUBSI (64, MULSI (8, tmp_bytecount)));
if (ANDQI (tmp_bytecount, 4)) {
{
  {
    SI opval = ANDSI (tmp_val, 0xffffffff);
    SETMEMSI (current_cpu, pc, ANDDI (tmp_addr, -8), opval);
    written |= (1 << 6);
    TRACE_RESULT (current_cpu, abuf, "memory", 'x', opval);
  }
  tmp_val = SRLDI (tmp_val, 32);
}
}
if (ANDQI (tmp_bytecount, 2)) {
{
  {
    HI opval = ANDHI (tmp_val, 65535);
    SETMEMHI (current_cpu, pc, ANDDI (tmp_addr, -4), opval);
    written |= (1 << 5);
    TRACE_RESULT (current_cpu, abuf, "memory", 'x', opval);
  }
  tmp_val = SRLDI (tmp_val, 16);
}
}
if (ANDQI (tmp_bytecount, 1)) {
{
  {
    UQI opval = ANDQI (tmp_val, 255);
    SETMEMUQI (current_cpu, pc, tmp_addr, opval);
    written |= (1 << 7);
    TRACE_RESULT (current_cpu, abuf, "memory", 'x', opval);
  }
  tmp_val = SRLDI (tmp_val, 8);
}
}
}
}
}
}

  abuf->written = written;
  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* stlol: stlo.l $rm, $disp6, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,stlol) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_GETCFG_VARS /* f-op f-left f-ext f-disp6 f-dest f-rsvd */
  EXTRACT_IFMT_GETCFG_CODE

{
  DI tmp_addr;
  QI tmp_bytecount;
  DI tmp_val;
  tmp_addr = ADDDI (GET_H_GR (f_left), f_disp6);
  tmp_bytecount = SUBSI (4, ANDDI (tmp_addr, 3));
if (ANDQI (tmp_bytecount, 4)) {
  {
    USI opval = GET_H_GR (f_dest);
    SETMEMUSI (current_cpu, pc, tmp_addr, opval);
    written |= (1 << 6);
    TRACE_RESULT (current_cpu, abuf, "memory", 'x', opval);
  }
} else {
if (GET_H_ENDIAN ()) {
{
  tmp_val = SRLDI (GET_H_GR (f_dest), SUBSI (32, MULSI (8, tmp_bytecount)));
if (ANDQI (tmp_bytecount, 2)) {
{
  {
    UHI opval = ANDHI (tmp_val, 65535);
    SETMEMUHI (current_cpu, pc, ANDDI (ADDDI (tmp_addr, 1), -2), opval);
    written |= (1 << 4);
    TRACE_RESULT (current_cpu, abuf, "memory", 'x', opval);
  }
  tmp_val = SRLDI (tmp_val, 16);
}
}
if (ANDQI (tmp_bytecount, 1)) {
{
  {
    UQI opval = ANDQI (tmp_val, 255);
    SETMEMUQI (current_cpu, pc, tmp_addr, opval);
    written |= (1 << 5);
    TRACE_RESULT (current_cpu, abuf, "memory", 'x', opval);
  }
  tmp_val = SRLDI (tmp_val, 8);
}
}
}
} else {
{
  tmp_val = GET_H_GR (f_dest);
if (ANDQI (tmp_bytecount, 1)) {
{
  {
    UQI opval = ANDQI (tmp_val, 255);
    SETMEMUQI (current_cpu, pc, tmp_addr, opval);
    written |= (1 << 5);
    TRACE_RESULT (current_cpu, abuf, "memory", 'x', opval);
  }
  tmp_val = SRLDI (tmp_val, 8);
}
}
if (ANDQI (tmp_bytecount, 2)) {
{
  {
    UHI opval = ANDHI (tmp_val, 65535);
    SETMEMUHI (current_cpu, pc, ANDDI (ADDDI (tmp_addr, 1), -2), opval);
    written |= (1 << 4);
    TRACE_RESULT (current_cpu, abuf, "memory", 'x', opval);
  }
  tmp_val = SRLDI (tmp_val, 16);
}
}
}
}
}
}

  abuf->written = written;
  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* stloq: stlo.q $rm, $disp6, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,stloq) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_GETCFG_VARS /* f-op f-left f-ext f-disp6 f-dest f-rsvd */
  EXTRACT_IFMT_GETCFG_CODE

{
  DI tmp_addr;
  QI tmp_bytecount;
  DI tmp_val;
  tmp_addr = ADDDI (GET_H_GR (f_left), f_disp6);
  tmp_bytecount = SUBSI (8, ANDDI (tmp_addr, 7));
if (ANDQI (tmp_bytecount, 8)) {
  {
    UDI opval = GET_H_GR (f_dest);
    SETMEMUDI (current_cpu, pc, tmp_addr, opval);
    written |= (1 << 4);
    TRACE_RESULT (current_cpu, abuf, "memory", 'D', opval);
  }
} else {
if (GET_H_ENDIAN ()) {
{
  tmp_val = SRLDI (GET_H_GR (f_dest), SUBSI (64, MULSI (8, tmp_bytecount)));
if (ANDQI (tmp_bytecount, 4)) {
{
  {
    USI opval = ANDSI (tmp_val, 0xffffffff);
    SETMEMUSI (current_cpu, pc, ANDDI (ADDDI (tmp_addr, 3), -4), opval);
    written |= (1 << 7);
    TRACE_RESULT (current_cpu, abuf, "memory", 'x', opval);
  }
  tmp_val = SRLDI (tmp_val, 32);
}
}
if (ANDQI (tmp_bytecount, 2)) {
{
  {
    UHI opval = ANDHI (tmp_val, 65535);
    SETMEMUHI (current_cpu, pc, ANDDI (ADDDI (tmp_addr, 1), -2), opval);
    written |= (1 << 5);
    TRACE_RESULT (current_cpu, abuf, "memory", 'x', opval);
  }
  tmp_val = SRLDI (tmp_val, 16);
}
}
if (ANDQI (tmp_bytecount, 1)) {
{
  {
    UQI opval = ANDQI (tmp_val, 255);
    SETMEMUQI (current_cpu, pc, tmp_addr, opval);
    written |= (1 << 6);
    TRACE_RESULT (current_cpu, abuf, "memory", 'x', opval);
  }
  tmp_val = SRLDI (tmp_val, 8);
}
}
}
} else {
{
  tmp_val = GET_H_GR (f_dest);
if (ANDQI (tmp_bytecount, 1)) {
{
  {
    UQI opval = ANDQI (tmp_val, 255);
    SETMEMUQI (current_cpu, pc, tmp_addr, opval);
    written |= (1 << 6);
    TRACE_RESULT (current_cpu, abuf, "memory", 'x', opval);
  }
  tmp_val = SRLDI (tmp_val, 8);
}
}
if (ANDQI (tmp_bytecount, 2)) {
{
  {
    UHI opval = ANDHI (tmp_val, 65535);
    SETMEMUHI (current_cpu, pc, ANDDI (ADDDI (tmp_addr, 1), -2), opval);
    written |= (1 << 5);
    TRACE_RESULT (current_cpu, abuf, "memory", 'x', opval);
  }
  tmp_val = SRLDI (tmp_val, 16);
}
}
if (ANDQI (tmp_bytecount, 4)) {
{
  {
    USI opval = ANDSI (tmp_val, 0xffffffff);
    SETMEMUSI (current_cpu, pc, ANDDI (ADDDI (tmp_addr, 3), -4), opval);
    written |= (1 << 7);
    TRACE_RESULT (current_cpu, abuf, "memory", 'x', opval);
  }
  tmp_val = SRLDI (tmp_val, 32);
}
}
}
}
}
}

  abuf->written = written;
  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* stxb: stx.b $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,stxb) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

  {
    UQI opval = SUBWORDDIQI (GET_H_GR (f_dest), 7);
    SETMEMUQI (current_cpu, pc, ADDDI (GET_H_GR (f_left), GET_H_GR (f_right)), opval);
    TRACE_RESULT (current_cpu, abuf, "memory", 'x', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* stxl: stx.l $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,stxl) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

  {
    SI opval = SUBWORDDISI (GET_H_GR (f_dest), 1);
    SETMEMSI (current_cpu, pc, ADDDI (GET_H_GR (f_left), GET_H_GR (f_right)), opval);
    TRACE_RESULT (current_cpu, abuf, "memory", 'x', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* stxq: stx.q $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,stxq) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

  {
    DI opval = GET_H_GR (f_dest);
    SETMEMDI (current_cpu, pc, ADDDI (GET_H_GR (f_left), GET_H_GR (f_right)), opval);
    TRACE_RESULT (current_cpu, abuf, "memory", 'D', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* stxw: stx.w $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,stxw) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

  {
    HI opval = SUBWORDDIHI (GET_H_GR (f_dest), 3);
    SETMEMHI (current_cpu, pc, ADDDI (GET_H_GR (f_left), GET_H_GR (f_right)), opval);
    TRACE_RESULT (current_cpu, abuf, "memory", 'x', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* sub: sub $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,sub) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

  {
    DI opval = SUBDI (GET_H_GR (f_left), GET_H_GR (f_right));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* subl: sub.l $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,subl) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

  {
    DI opval = EXTSIDI (SUBSI (SUBWORDDISI (GET_H_GR (f_left), 1), SUBWORDDISI (GET_H_GR (f_right), 1)));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* swapq: swap.q $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,swapq) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

{
  DI tmp_addr;
  DI tmp_temp;
  tmp_addr = ADDDI (GET_H_GR (f_left), GET_H_GR (f_right));
  tmp_temp = GETMEMDI (current_cpu, pc, tmp_addr);
  {
    DI opval = GET_H_GR (f_dest);
    SETMEMDI (current_cpu, pc, tmp_addr, opval);
    TRACE_RESULT (current_cpu, abuf, "memory", 'D', opval);
  }
  {
    DI opval = tmp_temp;
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }
}

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* synci: synci */

static SEM_STATUS
SEM_FN_NAME (@prefix@,synci) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_BRK_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_BRK_CODE

((void) 0); /*nop*/

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* synco: synco */

static SEM_STATUS
SEM_FN_NAME (@prefix@,synco) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_BRK_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_BRK_CODE

((void) 0); /*nop*/

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* trapa: trapa $rm */

static SEM_STATUS
SEM_FN_NAME (@prefix@,trapa) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_TRAPA_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_TRAPA_CODE

sh64_trapa (current_cpu, GET_H_GR (f_left), pc);

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* xor: xor $rm, $rn, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,xor) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

  {
    DI opval = XORDI (GET_H_GR (f_left), GET_H_GR (f_right));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* xori: xori $rm, $imm6, $rd */

static SEM_STATUS
SEM_FN_NAME (@prefix@,xori) (SIM_CPU *current_cpu, SEM_ARG sem_arg, CGEN_INSN_INT insn)
{
  SEM_STATUS status = 0;
  ARGBUF *abuf = SEM_ARGBUF (sem_arg);
#define FLD(f) f
  int UNUSED written = 0;
  IADDR UNUSED pc = GET_H_PC ();
  SEM_PC vpc = SEM_NEXT_VPC (sem_arg, pc, 4);
  EXTRACT_IFMT_ADD_VARS /* f-op f-left f-ext f-right f-dest f-rsvd */
  EXTRACT_IFMT_ADD_CODE

  {
    DI opval = XORDI (GET_H_GR (f_left), EXTSIDI (f_imm6));
    SET_H_GR (f_dest, opval);
    TRACE_RESULT (current_cpu, abuf, "gr", 'D', opval);
  }

  SEM_NBRANCH_FINI (vpc, 0);
#undef FLD
  return status;
}

/* Table of all semantic fns.  */

static const struct sem_fn_desc sem_fns[] = {
  { @PREFIX@_INSN_X_INVALID, SEM_FN_NAME (@prefix@,x_invalid) },
  { @PREFIX@_INSN_X_AFTER, SEM_FN_NAME (@prefix@,x_after) },
  { @PREFIX@_INSN_X_BEFORE, SEM_FN_NAME (@prefix@,x_before) },
  { @PREFIX@_INSN_X_CTI_CHAIN, SEM_FN_NAME (@prefix@,x_cti_chain) },
  { @PREFIX@_INSN_X_CHAIN, SEM_FN_NAME (@prefix@,x_chain) },
  { @PREFIX@_INSN_X_BEGIN, SEM_FN_NAME (@prefix@,x_begin) },
  { @PREFIX@_INSN_ADD, SEM_FN_NAME (@prefix@,add) },
  { @PREFIX@_INSN_ADDL, SEM_FN_NAME (@prefix@,addl) },
  { @PREFIX@_INSN_ADDI, SEM_FN_NAME (@prefix@,addi) },
  { @PREFIX@_INSN_ADDIL, SEM_FN_NAME (@prefix@,addil) },
  { @PREFIX@_INSN_ADDZL, SEM_FN_NAME (@prefix@,addzl) },
  { @PREFIX@_INSN_ALLOCO, SEM_FN_NAME (@prefix@,alloco) },
  { @PREFIX@_INSN_AND, SEM_FN_NAME (@prefix@,and) },
  { @PREFIX@_INSN_ANDC, SEM_FN_NAME (@prefix@,andc) },
  { @PREFIX@_INSN_ANDI, SEM_FN_NAME (@prefix@,andi) },
  { @PREFIX@_INSN_BEQ, SEM_FN_NAME (@prefix@,beq) },
  { @PREFIX@_INSN_BEQI, SEM_FN_NAME (@prefix@,beqi) },
  { @PREFIX@_INSN_BGE, SEM_FN_NAME (@prefix@,bge) },
  { @PREFIX@_INSN_BGEU, SEM_FN_NAME (@prefix@,bgeu) },
  { @PREFIX@_INSN_BGT, SEM_FN_NAME (@prefix@,bgt) },
  { @PREFIX@_INSN_BGTU, SEM_FN_NAME (@prefix@,bgtu) },
  { @PREFIX@_INSN_BLINK, SEM_FN_NAME (@prefix@,blink) },
  { @PREFIX@_INSN_BNE, SEM_FN_NAME (@prefix@,bne) },
  { @PREFIX@_INSN_BNEI, SEM_FN_NAME (@prefix@,bnei) },
  { @PREFIX@_INSN_BRK, SEM_FN_NAME (@prefix@,brk) },
  { @PREFIX@_INSN_BYTEREV, SEM_FN_NAME (@prefix@,byterev) },
  { @PREFIX@_INSN_CMPEQ, SEM_FN_NAME (@prefix@,cmpeq) },
  { @PREFIX@_INSN_CMPGT, SEM_FN_NAME (@prefix@,cmpgt) },
  { @PREFIX@_INSN_CMPGTU, SEM_FN_NAME (@prefix@,cmpgtu) },
  { @PREFIX@_INSN_CMVEQ, SEM_FN_NAME (@prefix@,cmveq) },
  { @PREFIX@_INSN_CMVNE, SEM_FN_NAME (@prefix@,cmvne) },
  { @PREFIX@_INSN_FABSD, SEM_FN_NAME (@prefix@,fabsd) },
  { @PREFIX@_INSN_FABSS, SEM_FN_NAME (@prefix@,fabss) },
  { @PREFIX@_INSN_FADDD, SEM_FN_NAME (@prefix@,faddd) },
  { @PREFIX@_INSN_FADDS, SEM_FN_NAME (@prefix@,fadds) },
  { @PREFIX@_INSN_FCMPEQD, SEM_FN_NAME (@prefix@,fcmpeqd) },
  { @PREFIX@_INSN_FCMPEQS, SEM_FN_NAME (@prefix@,fcmpeqs) },
  { @PREFIX@_INSN_FCMPGED, SEM_FN_NAME (@prefix@,fcmpged) },
  { @PREFIX@_INSN_FCMPGES, SEM_FN_NAME (@prefix@,fcmpges) },
  { @PREFIX@_INSN_FCMPGTD, SEM_FN_NAME (@prefix@,fcmpgtd) },
  { @PREFIX@_INSN_FCMPGTS, SEM_FN_NAME (@prefix@,fcmpgts) },
  { @PREFIX@_INSN_FCMPUND, SEM_FN_NAME (@prefix@,fcmpund) },
  { @PREFIX@_INSN_FCMPUNS, SEM_FN_NAME (@prefix@,fcmpuns) },
  { @PREFIX@_INSN_FCNVDS, SEM_FN_NAME (@prefix@,fcnvds) },
  { @PREFIX@_INSN_FCNVSD, SEM_FN_NAME (@prefix@,fcnvsd) },
  { @PREFIX@_INSN_FDIVD, SEM_FN_NAME (@prefix@,fdivd) },
  { @PREFIX@_INSN_FDIVS, SEM_FN_NAME (@prefix@,fdivs) },
  { @PREFIX@_INSN_FGETSCR, SEM_FN_NAME (@prefix@,fgetscr) },
  { @PREFIX@_INSN_FIPRS, SEM_FN_NAME (@prefix@,fiprs) },
  { @PREFIX@_INSN_FLDD, SEM_FN_NAME (@prefix@,fldd) },
  { @PREFIX@_INSN_FLDP, SEM_FN_NAME (@prefix@,fldp) },
  { @PREFIX@_INSN_FLDS, SEM_FN_NAME (@prefix@,flds) },
  { @PREFIX@_INSN_FLDXD, SEM_FN_NAME (@prefix@,fldxd) },
  { @PREFIX@_INSN_FLDXP, SEM_FN_NAME (@prefix@,fldxp) },
  { @PREFIX@_INSN_FLDXS, SEM_FN_NAME (@prefix@,fldxs) },
  { @PREFIX@_INSN_FLOATLD, SEM_FN_NAME (@prefix@,floatld) },
  { @PREFIX@_INSN_FLOATLS, SEM_FN_NAME (@prefix@,floatls) },
  { @PREFIX@_INSN_FLOATQD, SEM_FN_NAME (@prefix@,floatqd) },
  { @PREFIX@_INSN_FLOATQS, SEM_FN_NAME (@prefix@,floatqs) },
  { @PREFIX@_INSN_FMACS, SEM_FN_NAME (@prefix@,fmacs) },
  { @PREFIX@_INSN_FMOVD, SEM_FN_NAME (@prefix@,fmovd) },
  { @PREFIX@_INSN_FMOVDQ, SEM_FN_NAME (@prefix@,fmovdq) },
  { @PREFIX@_INSN_FMOVLS, SEM_FN_NAME (@prefix@,fmovls) },
  { @PREFIX@_INSN_FMOVQD, SEM_FN_NAME (@prefix@,fmovqd) },
  { @PREFIX@_INSN_FMOVS, SEM_FN_NAME (@prefix@,fmovs) },
  { @PREFIX@_INSN_FMOVSL, SEM_FN_NAME (@prefix@,fmovsl) },
  { @PREFIX@_INSN_FMULD, SEM_FN_NAME (@prefix@,fmuld) },
  { @PREFIX@_INSN_FMULS, SEM_FN_NAME (@prefix@,fmuls) },
  { @PREFIX@_INSN_FNEGD, SEM_FN_NAME (@prefix@,fnegd) },
  { @PREFIX@_INSN_FNEGS, SEM_FN_NAME (@prefix@,fnegs) },
  { @PREFIX@_INSN_FPUTSCR, SEM_FN_NAME (@prefix@,fputscr) },
  { @PREFIX@_INSN_FSQRTD, SEM_FN_NAME (@prefix@,fsqrtd) },
  { @PREFIX@_INSN_FSQRTS, SEM_FN_NAME (@prefix@,fsqrts) },
  { @PREFIX@_INSN_FSTD, SEM_FN_NAME (@prefix@,fstd) },
  { @PREFIX@_INSN_FSTP, SEM_FN_NAME (@prefix@,fstp) },
  { @PREFIX@_INSN_FSTS, SEM_FN_NAME (@prefix@,fsts) },
  { @PREFIX@_INSN_FSTXD, SEM_FN_NAME (@prefix@,fstxd) },
  { @PREFIX@_INSN_FSTXP, SEM_FN_NAME (@prefix@,fstxp) },
  { @PREFIX@_INSN_FSTXS, SEM_FN_NAME (@prefix@,fstxs) },
  { @PREFIX@_INSN_FSUBD, SEM_FN_NAME (@prefix@,fsubd) },
  { @PREFIX@_INSN_FSUBS, SEM_FN_NAME (@prefix@,fsubs) },
  { @PREFIX@_INSN_FTRCDL, SEM_FN_NAME (@prefix@,ftrcdl) },
  { @PREFIX@_INSN_FTRCSL, SEM_FN_NAME (@prefix@,ftrcsl) },
  { @PREFIX@_INSN_FTRCDQ, SEM_FN_NAME (@prefix@,ftrcdq) },
  { @PREFIX@_INSN_FTRCSQ, SEM_FN_NAME (@prefix@,ftrcsq) },
  { @PREFIX@_INSN_FTRVS, SEM_FN_NAME (@prefix@,ftrvs) },
  { @PREFIX@_INSN_GETCFG, SEM_FN_NAME (@prefix@,getcfg) },
  { @PREFIX@_INSN_GETCON, SEM_FN_NAME (@prefix@,getcon) },
  { @PREFIX@_INSN_GETTR, SEM_FN_NAME (@prefix@,gettr) },
  { @PREFIX@_INSN_ICBI, SEM_FN_NAME (@prefix@,icbi) },
  { @PREFIX@_INSN_LDB, SEM_FN_NAME (@prefix@,ldb) },
  { @PREFIX@_INSN_LDL, SEM_FN_NAME (@prefix@,ldl) },
  { @PREFIX@_INSN_LDQ, SEM_FN_NAME (@prefix@,ldq) },
  { @PREFIX@_INSN_LDUB, SEM_FN_NAME (@prefix@,ldub) },
  { @PREFIX@_INSN_LDUW, SEM_FN_NAME (@prefix@,lduw) },
  { @PREFIX@_INSN_LDW, SEM_FN_NAME (@prefix@,ldw) },
  { @PREFIX@_INSN_LDHIL, SEM_FN_NAME (@prefix@,ldhil) },
  { @PREFIX@_INSN_LDHIQ, SEM_FN_NAME (@prefix@,ldhiq) },
  { @PREFIX@_INSN_LDLOL, SEM_FN_NAME (@prefix@,ldlol) },
  { @PREFIX@_INSN_LDLOQ, SEM_FN_NAME (@prefix@,ldloq) },
  { @PREFIX@_INSN_LDXB, SEM_FN_NAME (@prefix@,ldxb) },
  { @PREFIX@_INSN_LDXL, SEM_FN_NAME (@prefix@,ldxl) },
  { @PREFIX@_INSN_LDXQ, SEM_FN_NAME (@prefix@,ldxq) },
  { @PREFIX@_INSN_LDXUB, SEM_FN_NAME (@prefix@,ldxub) },
  { @PREFIX@_INSN_LDXUW, SEM_FN_NAME (@prefix@,ldxuw) },
  { @PREFIX@_INSN_LDXW, SEM_FN_NAME (@prefix@,ldxw) },
  { @PREFIX@_INSN_MABSL, SEM_FN_NAME (@prefix@,mabsl) },
  { @PREFIX@_INSN_MABSW, SEM_FN_NAME (@prefix@,mabsw) },
  { @PREFIX@_INSN_MADDL, SEM_FN_NAME (@prefix@,maddl) },
  { @PREFIX@_INSN_MADDW, SEM_FN_NAME (@prefix@,maddw) },
  { @PREFIX@_INSN_MADDSL, SEM_FN_NAME (@prefix@,maddsl) },
  { @PREFIX@_INSN_MADDSUB, SEM_FN_NAME (@prefix@,maddsub) },
  { @PREFIX@_INSN_MADDSW, SEM_FN_NAME (@prefix@,maddsw) },
  { @PREFIX@_INSN_MCMPEQB, SEM_FN_NAME (@prefix@,mcmpeqb) },
  { @PREFIX@_INSN_MCMPEQL, SEM_FN_NAME (@prefix@,mcmpeql) },
  { @PREFIX@_INSN_MCMPEQW, SEM_FN_NAME (@prefix@,mcmpeqw) },
  { @PREFIX@_INSN_MCMPGTL, SEM_FN_NAME (@prefix@,mcmpgtl) },
  { @PREFIX@_INSN_MCMPGTUB, SEM_FN_NAME (@prefix@,mcmpgtub) },
  { @PREFIX@_INSN_MCMPGTW, SEM_FN_NAME (@prefix@,mcmpgtw) },
  { @PREFIX@_INSN_MCMV, SEM_FN_NAME (@prefix@,mcmv) },
  { @PREFIX@_INSN_MCNVSLW, SEM_FN_NAME (@prefix@,mcnvslw) },
  { @PREFIX@_INSN_MCNVSWB, SEM_FN_NAME (@prefix@,mcnvswb) },
  { @PREFIX@_INSN_MCNVSWUB, SEM_FN_NAME (@prefix@,mcnvswub) },
  { @PREFIX@_INSN_MEXTR1, SEM_FN_NAME (@prefix@,mextr1) },
  { @PREFIX@_INSN_MEXTR2, SEM_FN_NAME (@prefix@,mextr2) },
  { @PREFIX@_INSN_MEXTR3, SEM_FN_NAME (@prefix@,mextr3) },
  { @PREFIX@_INSN_MEXTR4, SEM_FN_NAME (@prefix@,mextr4) },
  { @PREFIX@_INSN_MEXTR5, SEM_FN_NAME (@prefix@,mextr5) },
  { @PREFIX@_INSN_MEXTR6, SEM_FN_NAME (@prefix@,mextr6) },
  { @PREFIX@_INSN_MEXTR7, SEM_FN_NAME (@prefix@,mextr7) },
  { @PREFIX@_INSN_MMACFXWL, SEM_FN_NAME (@prefix@,mmacfxwl) },
  { @PREFIX@_INSN_MMACNFX_WL, SEM_FN_NAME (@prefix@,mmacnfx_wl) },
  { @PREFIX@_INSN_MMULL, SEM_FN_NAME (@prefix@,mmull) },
  { @PREFIX@_INSN_MMULW, SEM_FN_NAME (@prefix@,mmulw) },
  { @PREFIX@_INSN_MMULFXL, SEM_FN_NAME (@prefix@,mmulfxl) },
  { @PREFIX@_INSN_MMULFXW, SEM_FN_NAME (@prefix@,mmulfxw) },
  { @PREFIX@_INSN_MMULFXRPW, SEM_FN_NAME (@prefix@,mmulfxrpw) },
  { @PREFIX@_INSN_MMULHIWL, SEM_FN_NAME (@prefix@,mmulhiwl) },
  { @PREFIX@_INSN_MMULLOWL, SEM_FN_NAME (@prefix@,mmullowl) },
  { @PREFIX@_INSN_MMULSUMWQ, SEM_FN_NAME (@prefix@,mmulsumwq) },
  { @PREFIX@_INSN_MOVI, SEM_FN_NAME (@prefix@,movi) },
  { @PREFIX@_INSN_MPERMW, SEM_FN_NAME (@prefix@,mpermw) },
  { @PREFIX@_INSN_MSADUBQ, SEM_FN_NAME (@prefix@,msadubq) },
  { @PREFIX@_INSN_MSHALDSL, SEM_FN_NAME (@prefix@,mshaldsl) },
  { @PREFIX@_INSN_MSHALDSW, SEM_FN_NAME (@prefix@,mshaldsw) },
  { @PREFIX@_INSN_MSHARDL, SEM_FN_NAME (@prefix@,mshardl) },
  { @PREFIX@_INSN_MSHARDW, SEM_FN_NAME (@prefix@,mshardw) },
  { @PREFIX@_INSN_MSHARDSQ, SEM_FN_NAME (@prefix@,mshardsq) },
  { @PREFIX@_INSN_MSHFHIB, SEM_FN_NAME (@prefix@,mshfhib) },
  { @PREFIX@_INSN_MSHFHIL, SEM_FN_NAME (@prefix@,mshfhil) },
  { @PREFIX@_INSN_MSHFHIW, SEM_FN_NAME (@prefix@,mshfhiw) },
  { @PREFIX@_INSN_MSHFLOB, SEM_FN_NAME (@prefix@,mshflob) },
  { @PREFIX@_INSN_MSHFLOL, SEM_FN_NAME (@prefix@,mshflol) },
  { @PREFIX@_INSN_MSHFLOW, SEM_FN_NAME (@prefix@,mshflow) },
  { @PREFIX@_INSN_MSHLLDL, SEM_FN_NAME (@prefix@,mshlldl) },
  { @PREFIX@_INSN_MSHLLDW, SEM_FN_NAME (@prefix@,mshlldw) },
  { @PREFIX@_INSN_MSHLRDL, SEM_FN_NAME (@prefix@,mshlrdl) },
  { @PREFIX@_INSN_MSHLRDW, SEM_FN_NAME (@prefix@,mshlrdw) },
  { @PREFIX@_INSN_MSUBL, SEM_FN_NAME (@prefix@,msubl) },
  { @PREFIX@_INSN_MSUBW, SEM_FN_NAME (@prefix@,msubw) },
  { @PREFIX@_INSN_MSUBSL, SEM_FN_NAME (@prefix@,msubsl) },
  { @PREFIX@_INSN_MSUBSUB, SEM_FN_NAME (@prefix@,msubsub) },
  { @PREFIX@_INSN_MSUBSW, SEM_FN_NAME (@prefix@,msubsw) },
  { @PREFIX@_INSN_MULSL, SEM_FN_NAME (@prefix@,mulsl) },
  { @PREFIX@_INSN_MULUL, SEM_FN_NAME (@prefix@,mulul) },
  { @PREFIX@_INSN_NOP, SEM_FN_NAME (@prefix@,nop) },
  { @PREFIX@_INSN_NSB, SEM_FN_NAME (@prefix@,nsb) },
  { @PREFIX@_INSN_OCBI, SEM_FN_NAME (@prefix@,ocbi) },
  { @PREFIX@_INSN_OCBP, SEM_FN_NAME (@prefix@,ocbp) },
  { @PREFIX@_INSN_OCBWB, SEM_FN_NAME (@prefix@,ocbwb) },
  { @PREFIX@_INSN_OR, SEM_FN_NAME (@prefix@,or) },
  { @PREFIX@_INSN_ORI, SEM_FN_NAME (@prefix@,ori) },
  { @PREFIX@_INSN_PREFI, SEM_FN_NAME (@prefix@,prefi) },
  { @PREFIX@_INSN_PTA, SEM_FN_NAME (@prefix@,pta) },
  { @PREFIX@_INSN_PTABS, SEM_FN_NAME (@prefix@,ptabs) },
  { @PREFIX@_INSN_PTB, SEM_FN_NAME (@prefix@,ptb) },
  { @PREFIX@_INSN_PTREL, SEM_FN_NAME (@prefix@,ptrel) },
  { @PREFIX@_INSN_PUTCFG, SEM_FN_NAME (@prefix@,putcfg) },
  { @PREFIX@_INSN_PUTCON, SEM_FN_NAME (@prefix@,putcon) },
  { @PREFIX@_INSN_RTE, SEM_FN_NAME (@prefix@,rte) },
  { @PREFIX@_INSN_SHARD, SEM_FN_NAME (@prefix@,shard) },
  { @PREFIX@_INSN_SHARDL, SEM_FN_NAME (@prefix@,shardl) },
  { @PREFIX@_INSN_SHARI, SEM_FN_NAME (@prefix@,shari) },
  { @PREFIX@_INSN_SHARIL, SEM_FN_NAME (@prefix@,sharil) },
  { @PREFIX@_INSN_SHLLD, SEM_FN_NAME (@prefix@,shlld) },
  { @PREFIX@_INSN_SHLLDL, SEM_FN_NAME (@prefix@,shlldl) },
  { @PREFIX@_INSN_SHLLI, SEM_FN_NAME (@prefix@,shlli) },
  { @PREFIX@_INSN_SHLLIL, SEM_FN_NAME (@prefix@,shllil) },
  { @PREFIX@_INSN_SHLRD, SEM_FN_NAME (@prefix@,shlrd) },
  { @PREFIX@_INSN_SHLRDL, SEM_FN_NAME (@prefix@,shlrdl) },
  { @PREFIX@_INSN_SHLRI, SEM_FN_NAME (@prefix@,shlri) },
  { @PREFIX@_INSN_SHLRIL, SEM_FN_NAME (@prefix@,shlril) },
  { @PREFIX@_INSN_SHORI, SEM_FN_NAME (@prefix@,shori) },
  { @PREFIX@_INSN_SLEEP, SEM_FN_NAME (@prefix@,sleep) },
  { @PREFIX@_INSN_STB, SEM_FN_NAME (@prefix@,stb) },
  { @PREFIX@_INSN_STL, SEM_FN_NAME (@prefix@,stl) },
  { @PREFIX@_INSN_STQ, SEM_FN_NAME (@prefix@,stq) },
  { @PREFIX@_INSN_STW, SEM_FN_NAME (@prefix@,stw) },
  { @PREFIX@_INSN_STHIL, SEM_FN_NAME (@prefix@,sthil) },
  { @PREFIX@_INSN_STHIQ, SEM_FN_NAME (@prefix@,sthiq) },
  { @PREFIX@_INSN_STLOL, SEM_FN_NAME (@prefix@,stlol) },
  { @PREFIX@_INSN_STLOQ, SEM_FN_NAME (@prefix@,stloq) },
  { @PREFIX@_INSN_STXB, SEM_FN_NAME (@prefix@,stxb) },
  { @PREFIX@_INSN_STXL, SEM_FN_NAME (@prefix@,stxl) },
  { @PREFIX@_INSN_STXQ, SEM_FN_NAME (@prefix@,stxq) },
  { @PREFIX@_INSN_STXW, SEM_FN_NAME (@prefix@,stxw) },
  { @PREFIX@_INSN_SUB, SEM_FN_NAME (@prefix@,sub) },
  { @PREFIX@_INSN_SUBL, SEM_FN_NAME (@prefix@,subl) },
  { @PREFIX@_INSN_SWAPQ, SEM_FN_NAME (@prefix@,swapq) },
  { @PREFIX@_INSN_SYNCI, SEM_FN_NAME (@prefix@,synci) },
  { @PREFIX@_INSN_SYNCO, SEM_FN_NAME (@prefix@,synco) },
  { @PREFIX@_INSN_TRAPA, SEM_FN_NAME (@prefix@,trapa) },
  { @PREFIX@_INSN_XOR, SEM_FN_NAME (@prefix@,xor) },
  { @PREFIX@_INSN_XORI, SEM_FN_NAME (@prefix@,xori) },
  { 0, 0 }
};

/* Add the semantic fns to IDESC_TABLE.  */

void
SEM_FN_NAME (@prefix@,init_idesc_table) (SIM_CPU *current_cpu)
{
  IDESC *idesc_table = CPU_IDESC (current_cpu);
  const struct sem_fn_desc *sf;
  int mach_num = MACH_NUM (CPU_MACH (current_cpu));

  for (sf = &sem_fns[0]; sf->fn != 0; ++sf)
    {
      const CGEN_INSN *insn = idesc_table[sf->index].idata;
      int valid_p = (CGEN_INSN_VIRTUAL_P (insn)
		     || CGEN_INSN_MACH_HAS_P (insn, mach_num));
#if FAST_P
      if (valid_p)
	idesc_table[sf->index].sem_fast = sf->fn;
      else
	idesc_table[sf->index].sem_fast = SEM_FN_NAME (@prefix@,x_invalid);
#else
      if (valid_p)
	idesc_table[sf->index].sem_full = sf->fn;
      else
	idesc_table[sf->index].sem_full = SEM_FN_NAME (@prefix@,x_invalid);
#endif
    }
}

