/* Simulator instruction decoder for @prefix@.

THIS FILE IS MACHINE GENERATED WITH CGEN.

Copyright 1996, 1997, 1998, 1999, 2000, 2001, 2002 Free Software Foundation, Inc.

This file is part of the GNU simulators.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

*/

#define WANT_CPU @cpu@
#define WANT_CPU_@CPU@

#include "sim-main.h"
#include "sim-assert.h"

/* The instruction descriptor array.
   This is computed at runtime.  Space for it is not malloc'd to save a
   teensy bit of cpu in the decoder.  Moving it to malloc space is trivial
   but won't be done until necessary (we don't currently support the runtime
   addition of instructions nor an SMP machine with different cpus).  */
static IDESC @prefix@_insn_data[@PREFIX@_INSN_XORI + 1];

/* Commas between elements are contained in the macros.
   Some of these are conditionally compiled out.  */

static const struct insn_sem @prefix@_insn_sem[] =
{
  { VIRTUAL_INSN_X_INVALID, @PREFIX@_INSN_X_INVALID, @PREFIX@_SFMT_EMPTY },
  { VIRTUAL_INSN_X_AFTER, @PREFIX@_INSN_X_AFTER, @PREFIX@_SFMT_EMPTY },
  { VIRTUAL_INSN_X_BEFORE, @PREFIX@_INSN_X_BEFORE, @PREFIX@_SFMT_EMPTY },
  { VIRTUAL_INSN_X_CTI_CHAIN, @PREFIX@_INSN_X_CTI_CHAIN, @PREFIX@_SFMT_EMPTY },
  { VIRTUAL_INSN_X_CHAIN, @PREFIX@_INSN_X_CHAIN, @PREFIX@_SFMT_EMPTY },
  { VIRTUAL_INSN_X_BEGIN, @PREFIX@_INSN_X_BEGIN, @PREFIX@_SFMT_EMPTY },
  { @ARCH@_INSN_ADD, @PREFIX@_INSN_ADD, @PREFIX@_SFMT_ADD },
  { @ARCH@_INSN_ADDL, @PREFIX@_INSN_ADDL, @PREFIX@_SFMT_ADD },
  { @ARCH@_INSN_ADDI, @PREFIX@_INSN_ADDI, @PREFIX@_SFMT_ADDI },
  { @ARCH@_INSN_ADDIL, @PREFIX@_INSN_ADDIL, @PREFIX@_SFMT_ADDI },
  { @ARCH@_INSN_ADDZL, @PREFIX@_INSN_ADDZL, @PREFIX@_SFMT_ADD },
  { @ARCH@_INSN_ALLOCO, @PREFIX@_INSN_ALLOCO, @PREFIX@_SFMT_ALLOCO },
  { @ARCH@_INSN_AND, @PREFIX@_INSN_AND, @PREFIX@_SFMT_ADD },
  { @ARCH@_INSN_ANDC, @PREFIX@_INSN_ANDC, @PREFIX@_SFMT_ADD },
  { @ARCH@_INSN_ANDI, @PREFIX@_INSN_ANDI, @PREFIX@_SFMT_ADDI },
  { @ARCH@_INSN_BEQ, @PREFIX@_INSN_BEQ, @PREFIX@_SFMT_BEQ },
  { @ARCH@_INSN_BEQI, @PREFIX@_INSN_BEQI, @PREFIX@_SFMT_BEQI },
  { @ARCH@_INSN_BGE, @PREFIX@_INSN_BGE, @PREFIX@_SFMT_BEQ },
  { @ARCH@_INSN_BGEU, @PREFIX@_INSN_BGEU, @PREFIX@_SFMT_BEQ },
  { @ARCH@_INSN_BGT, @PREFIX@_INSN_BGT, @PREFIX@_SFMT_BEQ },
  { @ARCH@_INSN_BGTU, @PREFIX@_INSN_BGTU, @PREFIX@_SFMT_BEQ },
  { @ARCH@_INSN_BLINK, @PREFIX@_INSN_BLINK, @PREFIX@_SFMT_BLINK },
  { @ARCH@_INSN_BNE, @PREFIX@_INSN_BNE, @PREFIX@_SFMT_BEQ },
  { @ARCH@_INSN_BNEI, @PREFIX@_INSN_BNEI, @PREFIX@_SFMT_BEQI },
  { @ARCH@_INSN_BRK, @PREFIX@_INSN_BRK, @PREFIX@_SFMT_BRK },
  { @ARCH@_INSN_BYTEREV, @PREFIX@_INSN_BYTEREV, @PREFIX@_SFMT_BYTEREV },
  { @ARCH@_INSN_CMPEQ, @PREFIX@_INSN_CMPEQ, @PREFIX@_SFMT_ADD },
  { @ARCH@_INSN_CMPGT, @PREFIX@_INSN_CMPGT, @PREFIX@_SFMT_ADD },
  { @ARCH@_INSN_CMPGTU, @PREFIX@_INSN_CMPGTU, @PREFIX@_SFMT_ADD },
  { @ARCH@_INSN_CMVEQ, @PREFIX@_INSN_CMVEQ, @PREFIX@_SFMT_CMVEQ },
  { @ARCH@_INSN_CMVNE, @PREFIX@_INSN_CMVNE, @PREFIX@_SFMT_CMVEQ },
  { @ARCH@_INSN_FABSD, @PREFIX@_INSN_FABSD, @PREFIX@_SFMT_FABSD },
  { @ARCH@_INSN_FABSS, @PREFIX@_INSN_FABSS, @PREFIX@_SFMT_FABSS },
  { @ARCH@_INSN_FADDD, @PREFIX@_INSN_FADDD, @PREFIX@_SFMT_FADDD },
  { @ARCH@_INSN_FADDS, @PREFIX@_INSN_FADDS, @PREFIX@_SFMT_FADDS },
  { @ARCH@_INSN_FCMPEQD, @PREFIX@_INSN_FCMPEQD, @PREFIX@_SFMT_FCMPEQD },
  { @ARCH@_INSN_FCMPEQS, @PREFIX@_INSN_FCMPEQS, @PREFIX@_SFMT_FCMPEQS },
  { @ARCH@_INSN_FCMPGED, @PREFIX@_INSN_FCMPGED, @PREFIX@_SFMT_FCMPEQD },
  { @ARCH@_INSN_FCMPGES, @PREFIX@_INSN_FCMPGES, @PREFIX@_SFMT_FCMPEQS },
  { @ARCH@_INSN_FCMPGTD, @PREFIX@_INSN_FCMPGTD, @PREFIX@_SFMT_FCMPEQD },
  { @ARCH@_INSN_FCMPGTS, @PREFIX@_INSN_FCMPGTS, @PREFIX@_SFMT_FCMPEQS },
  { @ARCH@_INSN_FCMPUND, @PREFIX@_INSN_FCMPUND, @PREFIX@_SFMT_FCMPEQD },
  { @ARCH@_INSN_FCMPUNS, @PREFIX@_INSN_FCMPUNS, @PREFIX@_SFMT_FCMPEQS },
  { @ARCH@_INSN_FCNVDS, @PREFIX@_INSN_FCNVDS, @PREFIX@_SFMT_FCNVDS },
  { @ARCH@_INSN_FCNVSD, @PREFIX@_INSN_FCNVSD, @PREFIX@_SFMT_FCNVSD },
  { @ARCH@_INSN_FDIVD, @PREFIX@_INSN_FDIVD, @PREFIX@_SFMT_FADDD },
  { @ARCH@_INSN_FDIVS, @PREFIX@_INSN_FDIVS, @PREFIX@_SFMT_FADDS },
  { @ARCH@_INSN_FGETSCR, @PREFIX@_INSN_FGETSCR, @PREFIX@_SFMT_ALLOCO },
  { @ARCH@_INSN_FIPRS, @PREFIX@_INSN_FIPRS, @PREFIX@_SFMT_FIPRS },
  { @ARCH@_INSN_FLDD, @PREFIX@_INSN_FLDD, @PREFIX@_SFMT_FLDD },
  { @ARCH@_INSN_FLDP, @PREFIX@_INSN_FLDP, @PREFIX@_SFMT_FLDP },
  { @ARCH@_INSN_FLDS, @PREFIX@_INSN_FLDS, @PREFIX@_SFMT_FLDS },
  { @ARCH@_INSN_FLDXD, @PREFIX@_INSN_FLDXD, @PREFIX@_SFMT_FLDXD },
  { @ARCH@_INSN_FLDXP, @PREFIX@_INSN_FLDXP, @PREFIX@_SFMT_FLDXP },
  { @ARCH@_INSN_FLDXS, @PREFIX@_INSN_FLDXS, @PREFIX@_SFMT_FLDXS },
  { @ARCH@_INSN_FLOATLD, @PREFIX@_INSN_FLOATLD, @PREFIX@_SFMT_FCNVSD },
  { @ARCH@_INSN_FLOATLS, @PREFIX@_INSN_FLOATLS, @PREFIX@_SFMT_FABSS },
  { @ARCH@_INSN_FLOATQD, @PREFIX@_INSN_FLOATQD, @PREFIX@_SFMT_FABSD },
  { @ARCH@_INSN_FLOATQS, @PREFIX@_INSN_FLOATQS, @PREFIX@_SFMT_FCNVDS },
  { @ARCH@_INSN_FMACS, @PREFIX@_INSN_FMACS, @PREFIX@_SFMT_FMACS },
  { @ARCH@_INSN_FMOVD, @PREFIX@_INSN_FMOVD, @PREFIX@_SFMT_FABSD },
  { @ARCH@_INSN_FMOVDQ, @PREFIX@_INSN_FMOVDQ, @PREFIX@_SFMT_FMOVDQ },
  { @ARCH@_INSN_FMOVLS, @PREFIX@_INSN_FMOVLS, @PREFIX@_SFMT_FMOVLS },
  { @ARCH@_INSN_FMOVQD, @PREFIX@_INSN_FMOVQD, @PREFIX@_SFMT_FMOVQD },
  { @ARCH@_INSN_FMOVS, @PREFIX@_INSN_FMOVS, @PREFIX@_SFMT_FABSS },
  { @ARCH@_INSN_FMOVSL, @PREFIX@_INSN_FMOVSL, @PREFIX@_SFMT_FMOVSL },
  { @ARCH@_INSN_FMULD, @PREFIX@_INSN_FMULD, @PREFIX@_SFMT_FADDD },
  { @ARCH@_INSN_FMULS, @PREFIX@_INSN_FMULS, @PREFIX@_SFMT_FADDS },
  { @ARCH@_INSN_FNEGD, @PREFIX@_INSN_FNEGD, @PREFIX@_SFMT_FABSD },
  { @ARCH@_INSN_FNEGS, @PREFIX@_INSN_FNEGS, @PREFIX@_SFMT_FABSS },
  { @ARCH@_INSN_FPUTSCR, @PREFIX@_INSN_FPUTSCR, @PREFIX@_SFMT_ALLOCO },
  { @ARCH@_INSN_FSQRTD, @PREFIX@_INSN_FSQRTD, @PREFIX@_SFMT_FABSD },
  { @ARCH@_INSN_FSQRTS, @PREFIX@_INSN_FSQRTS, @PREFIX@_SFMT_FABSS },
  { @ARCH@_INSN_FSTD, @PREFIX@_INSN_FSTD, @PREFIX@_SFMT_FSTD },
  { @ARCH@_INSN_FSTP, @PREFIX@_INSN_FSTP, @PREFIX@_SFMT_FSTP },
  { @ARCH@_INSN_FSTS, @PREFIX@_INSN_FSTS, @PREFIX@_SFMT_FSTS },
  { @ARCH@_INSN_FSTXD, @PREFIX@_INSN_FSTXD, @PREFIX@_SFMT_FSTXD },
  { @ARCH@_INSN_FSTXP, @PREFIX@_INSN_FSTXP, @PREFIX@_SFMT_FSTXP },
  { @ARCH@_INSN_FSTXS, @PREFIX@_INSN_FSTXS, @PREFIX@_SFMT_FSTXS },
  { @ARCH@_INSN_FSUBD, @PREFIX@_INSN_FSUBD, @PREFIX@_SFMT_FADDD },
  { @ARCH@_INSN_FSUBS, @PREFIX@_INSN_FSUBS, @PREFIX@_SFMT_FADDS },
  { @ARCH@_INSN_FTRCDL, @PREFIX@_INSN_FTRCDL, @PREFIX@_SFMT_FCNVDS },
  { @ARCH@_INSN_FTRCSL, @PREFIX@_INSN_FTRCSL, @PREFIX@_SFMT_FABSS },
  { @ARCH@_INSN_FTRCDQ, @PREFIX@_INSN_FTRCDQ, @PREFIX@_SFMT_FABSD },
  { @ARCH@_INSN_FTRCSQ, @PREFIX@_INSN_FTRCSQ, @PREFIX@_SFMT_FCNVSD },
  { @ARCH@_INSN_FTRVS, @PREFIX@_INSN_FTRVS, @PREFIX@_SFMT_FTRVS },
  { @ARCH@_INSN_GETCFG, @PREFIX@_INSN_GETCFG, @PREFIX@_SFMT_ALLOCO },
  { @ARCH@_INSN_GETCON, @PREFIX@_INSN_GETCON, @PREFIX@_SFMT_GETCON },
  { @ARCH@_INSN_GETTR, @PREFIX@_INSN_GETTR, @PREFIX@_SFMT_GETTR },
  { @ARCH@_INSN_ICBI, @PREFIX@_INSN_ICBI, @PREFIX@_SFMT_ALLOCO },
  { @ARCH@_INSN_LDB, @PREFIX@_INSN_LDB, @PREFIX@_SFMT_LDB },
  { @ARCH@_INSN_LDL, @PREFIX@_INSN_LDL, @PREFIX@_SFMT_LDL },
  { @ARCH@_INSN_LDQ, @PREFIX@_INSN_LDQ, @PREFIX@_SFMT_LDQ },
  { @ARCH@_INSN_LDUB, @PREFIX@_INSN_LDUB, @PREFIX@_SFMT_LDUB },
  { @ARCH@_INSN_LDUW, @PREFIX@_INSN_LDUW, @PREFIX@_SFMT_LDUW },
  { @ARCH@_INSN_LDW, @PREFIX@_INSN_LDW, @PREFIX@_SFMT_LDUW },
  { @ARCH@_INSN_LDHIL, @PREFIX@_INSN_LDHIL, @PREFIX@_SFMT_LDHIL },
  { @ARCH@_INSN_LDHIQ, @PREFIX@_INSN_LDHIQ, @PREFIX@_SFMT_LDHIQ },
  { @ARCH@_INSN_LDLOL, @PREFIX@_INSN_LDLOL, @PREFIX@_SFMT_LDLOL },
  { @ARCH@_INSN_LDLOQ, @PREFIX@_INSN_LDLOQ, @PREFIX@_SFMT_LDLOQ },
  { @ARCH@_INSN_LDXB, @PREFIX@_INSN_LDXB, @PREFIX@_SFMT_LDXB },
  { @ARCH@_INSN_LDXL, @PREFIX@_INSN_LDXL, @PREFIX@_SFMT_LDXL },
  { @ARCH@_INSN_LDXQ, @PREFIX@_INSN_LDXQ, @PREFIX@_SFMT_LDXQ },
  { @ARCH@_INSN_LDXUB, @PREFIX@_INSN_LDXUB, @PREFIX@_SFMT_LDXUB },
  { @ARCH@_INSN_LDXUW, @PREFIX@_INSN_LDXUW, @PREFIX@_SFMT_LDXUW },
  { @ARCH@_INSN_LDXW, @PREFIX@_INSN_LDXW, @PREFIX@_SFMT_LDXW },
  { @ARCH@_INSN_MABSL, @PREFIX@_INSN_MABSL, @PREFIX@_SFMT_BYTEREV },
  { @ARCH@_INSN_MABSW, @PREFIX@_INSN_MABSW, @PREFIX@_SFMT_BYTEREV },
  { @ARCH@_INSN_MADDL, @PREFIX@_INSN_MADDL, @PREFIX@_SFMT_ADD },
  { @ARCH@_INSN_MADDW, @PREFIX@_INSN_MADDW, @PREFIX@_SFMT_ADD },
  { @ARCH@_INSN_MADDSL, @PREFIX@_INSN_MADDSL, @PREFIX@_SFMT_ADD },
  { @ARCH@_INSN_MADDSUB, @PREFIX@_INSN_MADDSUB, @PREFIX@_SFMT_ADD },
  { @ARCH@_INSN_MADDSW, @PREFIX@_INSN_MADDSW, @PREFIX@_SFMT_ADD },
  { @ARCH@_INSN_MCMPEQB, @PREFIX@_INSN_MCMPEQB, @PREFIX@_SFMT_ADD },
  { @ARCH@_INSN_MCMPEQL, @PREFIX@_INSN_MCMPEQL, @PREFIX@_SFMT_ADD },
  { @ARCH@_INSN_MCMPEQW, @PREFIX@_INSN_MCMPEQW, @PREFIX@_SFMT_ADD },
  { @ARCH@_INSN_MCMPGTL, @PREFIX@_INSN_MCMPGTL, @PREFIX@_SFMT_ADD },
  { @ARCH@_INSN_MCMPGTUB, @PREFIX@_INSN_MCMPGTUB, @PREFIX@_SFMT_ADD },
  { @ARCH@_INSN_MCMPGTW, @PREFIX@_INSN_MCMPGTW, @PREFIX@_SFMT_ADD },
  { @ARCH@_INSN_MCMV, @PREFIX@_INSN_MCMV, @PREFIX@_SFMT_MCMV },
  { @ARCH@_INSN_MCNVSLW, @PREFIX@_INSN_MCNVSLW, @PREFIX@_SFMT_ADD },
  { @ARCH@_INSN_MCNVSWB, @PREFIX@_INSN_MCNVSWB, @PREFIX@_SFMT_ADD },
  { @ARCH@_INSN_MCNVSWUB, @PREFIX@_INSN_MCNVSWUB, @PREFIX@_SFMT_ADD },
  { @ARCH@_INSN_MEXTR1, @PREFIX@_INSN_MEXTR1, @PREFIX@_SFMT_ADD },
  { @ARCH@_INSN_MEXTR2, @PREFIX@_INSN_MEXTR2, @PREFIX@_SFMT_ADD },
  { @ARCH@_INSN_MEXTR3, @PREFIX@_INSN_MEXTR3, @PREFIX@_SFMT_ADD },
  { @ARCH@_INSN_MEXTR4, @PREFIX@_INSN_MEXTR4, @PREFIX@_SFMT_ADD },
  { @ARCH@_INSN_MEXTR5, @PREFIX@_INSN_MEXTR5, @PREFIX@_SFMT_ADD },
  { @ARCH@_INSN_MEXTR6, @PREFIX@_INSN_MEXTR6, @PREFIX@_SFMT_ADD },
  { @ARCH@_INSN_MEXTR7, @PREFIX@_INSN_MEXTR7, @PREFIX@_SFMT_ADD },
  { @ARCH@_INSN_MMACFXWL, @PREFIX@_INSN_MMACFXWL, @PREFIX@_SFMT_MCMV },
  { @ARCH@_INSN_MMACNFX_WL, @PREFIX@_INSN_MMACNFX_WL, @PREFIX@_SFMT_MCMV },
  { @ARCH@_INSN_MMULL, @PREFIX@_INSN_MMULL, @PREFIX@_SFMT_ADD },
  { @ARCH@_INSN_MMULW, @PREFIX@_INSN_MMULW, @PREFIX@_SFMT_ADD },
  { @ARCH@_INSN_MMULFXL, @PREFIX@_INSN_MMULFXL, @PREFIX@_SFMT_ADD },
  { @ARCH@_INSN_MMULFXW, @PREFIX@_INSN_MMULFXW, @PREFIX@_SFMT_ADD },
  { @ARCH@_INSN_MMULFXRPW, @PREFIX@_INSN_MMULFXRPW, @PREFIX@_SFMT_ADD },
  { @ARCH@_INSN_MMULHIWL, @PREFIX@_INSN_MMULHIWL, @PREFIX@_SFMT_ADD },
  { @ARCH@_INSN_MMULLOWL, @PREFIX@_INSN_MMULLOWL, @PREFIX@_SFMT_ADD },
  { @ARCH@_INSN_MMULSUMWQ, @PREFIX@_INSN_MMULSUMWQ, @PREFIX@_SFMT_MCMV },
  { @ARCH@_INSN_MOVI, @PREFIX@_INSN_MOVI, @PREFIX@_SFMT_MOVI },
  { @ARCH@_INSN_MPERMW, @PREFIX@_INSN_MPERMW, @PREFIX@_SFMT_MPERMW },
  { @ARCH@_INSN_MSADUBQ, @PREFIX@_INSN_MSADUBQ, @PREFIX@_SFMT_MCMV },
  { @ARCH@_INSN_MSHALDSL, @PREFIX@_INSN_MSHALDSL, @PREFIX@_SFMT_ADD },
  { @ARCH@_INSN_MSHALDSW, @PREFIX@_INSN_MSHALDSW, @PREFIX@_SFMT_ADD },
  { @ARCH@_INSN_MSHARDL, @PREFIX@_INSN_MSHARDL, @PREFIX@_SFMT_ADD },
  { @ARCH@_INSN_MSHARDW, @PREFIX@_INSN_MSHARDW, @PREFIX@_SFMT_ADD },
  { @ARCH@_INSN_MSHARDSQ, @PREFIX@_INSN_MSHARDSQ, @PREFIX@_SFMT_ADD },
  { @ARCH@_INSN_MSHFHIB, @PREFIX@_INSN_MSHFHIB, @PREFIX@_SFMT_ADD },
  { @ARCH@_INSN_MSHFHIL, @PREFIX@_INSN_MSHFHIL, @PREFIX@_SFMT_ADD },
  { @ARCH@_INSN_MSHFHIW, @PREFIX@_INSN_MSHFHIW, @PREFIX@_SFMT_ADD },
  { @ARCH@_INSN_MSHFLOB, @PREFIX@_INSN_MSHFLOB, @PREFIX@_SFMT_ADD },
  { @ARCH@_INSN_MSHFLOL, @PREFIX@_INSN_MSHFLOL, @PREFIX@_SFMT_ADD },
  { @ARCH@_INSN_MSHFLOW, @PREFIX@_INSN_MSHFLOW, @PREFIX@_SFMT_ADD },
  { @ARCH@_INSN_MSHLLDL, @PREFIX@_INSN_MSHLLDL, @PREFIX@_SFMT_ADD },
  { @ARCH@_INSN_MSHLLDW, @PREFIX@_INSN_MSHLLDW, @PREFIX@_SFMT_ADD },
  { @ARCH@_INSN_MSHLRDL, @PREFIX@_INSN_MSHLRDL, @PREFIX@_SFMT_ADD },
  { @ARCH@_INSN_MSHLRDW, @PREFIX@_INSN_MSHLRDW, @PREFIX@_SFMT_ADD },
  { @ARCH@_INSN_MSUBL, @PREFIX@_INSN_MSUBL, @PREFIX@_SFMT_ADD },
  { @ARCH@_INSN_MSUBW, @PREFIX@_INSN_MSUBW, @PREFIX@_SFMT_ADD },
  { @ARCH@_INSN_MSUBSL, @PREFIX@_INSN_MSUBSL, @PREFIX@_SFMT_ADD },
  { @ARCH@_INSN_MSUBSUB, @PREFIX@_INSN_MSUBSUB, @PREFIX@_SFMT_ADD },
  { @ARCH@_INSN_MSUBSW, @PREFIX@_INSN_MSUBSW, @PREFIX@_SFMT_ADD },
  { @ARCH@_INSN_MULSL, @PREFIX@_INSN_MULSL, @PREFIX@_SFMT_ADD },
  { @ARCH@_INSN_MULUL, @PREFIX@_INSN_MULUL, @PREFIX@_SFMT_ADD },
  { @ARCH@_INSN_NOP, @PREFIX@_INSN_NOP, @PREFIX@_SFMT_ALLOCO },
  { @ARCH@_INSN_NSB, @PREFIX@_INSN_NSB, @PREFIX@_SFMT_BYTEREV },
  { @ARCH@_INSN_OCBI, @PREFIX@_INSN_OCBI, @PREFIX@_SFMT_ALLOCO },
  { @ARCH@_INSN_OCBP, @PREFIX@_INSN_OCBP, @PREFIX@_SFMT_ALLOCO },
  { @ARCH@_INSN_OCBWB, @PREFIX@_INSN_OCBWB, @PREFIX@_SFMT_ALLOCO },
  { @ARCH@_INSN_OR, @PREFIX@_INSN_OR, @PREFIX@_SFMT_ADD },
  { @ARCH@_INSN_ORI, @PREFIX@_INSN_ORI, @PREFIX@_SFMT_ORI },
  { @ARCH@_INSN_PREFI, @PREFIX@_INSN_PREFI, @PREFIX@_SFMT_ALLOCO },
  { @ARCH@_INSN_PTA, @PREFIX@_INSN_PTA, @PREFIX@_SFMT_PTA },
  { @ARCH@_INSN_PTABS, @PREFIX@_INSN_PTABS, @PREFIX@_SFMT_PTABS },
  { @ARCH@_INSN_PTB, @PREFIX@_INSN_PTB, @PREFIX@_SFMT_PTA },
  { @ARCH@_INSN_PTREL, @PREFIX@_INSN_PTREL, @PREFIX@_SFMT_PTREL },
  { @ARCH@_INSN_PUTCFG, @PREFIX@_INSN_PUTCFG, @PREFIX@_SFMT_ALLOCO },
  { @ARCH@_INSN_PUTCON, @PREFIX@_INSN_PUTCON, @PREFIX@_SFMT_PUTCON },
  { @ARCH@_INSN_RTE, @PREFIX@_INSN_RTE, @PREFIX@_SFMT_ALLOCO },
  { @ARCH@_INSN_SHARD, @PREFIX@_INSN_SHARD, @PREFIX@_SFMT_ADD },
  { @ARCH@_INSN_SHARDL, @PREFIX@_INSN_SHARDL, @PREFIX@_SFMT_ADD },
  { @ARCH@_INSN_SHARI, @PREFIX@_INSN_SHARI, @PREFIX@_SFMT_SHARI },
  { @ARCH@_INSN_SHARIL, @PREFIX@_INSN_SHARIL, @PREFIX@_SFMT_SHARIL },
  { @ARCH@_INSN_SHLLD, @PREFIX@_INSN_SHLLD, @PREFIX@_SFMT_ADD },
  { @ARCH@_INSN_SHLLDL, @PREFIX@_INSN_SHLLDL, @PREFIX@_SFMT_ADD },
  { @ARCH@_INSN_SHLLI, @PREFIX@_INSN_SHLLI, @PREFIX@_SFMT_SHARI },
  { @ARCH@_INSN_SHLLIL, @PREFIX@_INSN_SHLLIL, @PREFIX@_SFMT_SHARIL },
  { @ARCH@_INSN_SHLRD, @PREFIX@_INSN_SHLRD, @PREFIX@_SFMT_ADD },
  { @ARCH@_INSN_SHLRDL, @PREFIX@_INSN_SHLRDL, @PREFIX@_SFMT_ADD },
  { @ARCH@_INSN_SHLRI, @PREFIX@_INSN_SHLRI, @PREFIX@_SFMT_SHARI },
  { @ARCH@_INSN_SHLRIL, @PREFIX@_INSN_SHLRIL, @PREFIX@_SFMT_SHARIL },
  { @ARCH@_INSN_SHORI, @PREFIX@_INSN_SHORI, @PREFIX@_SFMT_SHORI },
  { @ARCH@_INSN_SLEEP, @PREFIX@_INSN_SLEEP, @PREFIX@_SFMT_ALLOCO },
  { @ARCH@_INSN_STB, @PREFIX@_INSN_STB, @PREFIX@_SFMT_STB },
  { @ARCH@_INSN_STL, @PREFIX@_INSN_STL, @PREFIX@_SFMT_STL },
  { @ARCH@_INSN_STQ, @PREFIX@_INSN_STQ, @PREFIX@_SFMT_STQ },
  { @ARCH@_INSN_STW, @PREFIX@_INSN_STW, @PREFIX@_SFMT_STW },
  { @ARCH@_INSN_STHIL, @PREFIX@_INSN_STHIL, @PREFIX@_SFMT_STHIL },
  { @ARCH@_INSN_STHIQ, @PREFIX@_INSN_STHIQ, @PREFIX@_SFMT_STHIQ },
  { @ARCH@_INSN_STLOL, @PREFIX@_INSN_STLOL, @PREFIX@_SFMT_STLOL },
  { @ARCH@_INSN_STLOQ, @PREFIX@_INSN_STLOQ, @PREFIX@_SFMT_STLOQ },
  { @ARCH@_INSN_STXB, @PREFIX@_INSN_STXB, @PREFIX@_SFMT_STXB },
  { @ARCH@_INSN_STXL, @PREFIX@_INSN_STXL, @PREFIX@_SFMT_STXL },
  { @ARCH@_INSN_STXQ, @PREFIX@_INSN_STXQ, @PREFIX@_SFMT_STXQ },
  { @ARCH@_INSN_STXW, @PREFIX@_INSN_STXW, @PREFIX@_SFMT_STXW },
  { @ARCH@_INSN_SUB, @PREFIX@_INSN_SUB, @PREFIX@_SFMT_ADD },
  { @ARCH@_INSN_SUBL, @PREFIX@_INSN_SUBL, @PREFIX@_SFMT_ADD },
  { @ARCH@_INSN_SWAPQ, @PREFIX@_INSN_SWAPQ, @PREFIX@_SFMT_SWAPQ },
  { @ARCH@_INSN_SYNCI, @PREFIX@_INSN_SYNCI, @PREFIX@_SFMT_ALLOCO },
  { @ARCH@_INSN_SYNCO, @PREFIX@_INSN_SYNCO, @PREFIX@_SFMT_ALLOCO },
  { @ARCH@_INSN_TRAPA, @PREFIX@_INSN_TRAPA, @PREFIX@_SFMT_TRAPA },
  { @ARCH@_INSN_XOR, @PREFIX@_INSN_XOR, @PREFIX@_SFMT_ADD },
  { @ARCH@_INSN_XORI, @PREFIX@_INSN_XORI, @PREFIX@_SFMT_XORI },
};

static const struct insn_sem @prefix@_insn_sem_invalid = {
  VIRTUAL_INSN_X_INVALID, @PREFIX@_INSN_X_INVALID, @PREFIX@_SFMT_EMPTY
};

/* Initialize an IDESC from the compile-time computable parts.  */

static INLINE void
init_idesc (SIM_CPU *cpu, IDESC *id, const struct insn_sem *t)
{
  const CGEN_INSN *insn_table = CGEN_CPU_INSN_TABLE (CPU_CPU_DESC (cpu))->init_entries;

  id->num = t->index;
  id->sfmt = t->sfmt;
  if ((int) t->type <= 0)
    id->idata = & cgen_virtual_insn_table[- (int) t->type];
  else
    id->idata = & insn_table[t->type];
  id->attrs = CGEN_INSN_ATTRS (id->idata);
  /* Oh my god, a magic number.  */
  id->length = CGEN_INSN_BITSIZE (id->idata) / 8;

#if WITH_PROFILE_MODEL_P
  id->timing = & MODEL_TIMING (CPU_MODEL (cpu)) [t->index];
  {
    SIM_DESC sd = CPU_STATE (cpu);
    SIM_ASSERT (t->index == id->timing->num);
  }
#endif

  /* Semantic pointers are initialized elsewhere.  */
}

/* Initialize the instruction descriptor table.  */

void
@prefix@_init_idesc_table (SIM_CPU *cpu)
{
  IDESC *id,*tabend;
  const struct insn_sem *t,*tend;
  int tabsize = sizeof (@prefix@_insn_data) / sizeof (IDESC);
  IDESC *table = @prefix@_insn_data;

  memset (table, 0, tabsize * sizeof (IDESC));

  /* First set all entries to the `invalid insn'.  */
  t = & @prefix@_insn_sem_invalid;
  for (id = table, tabend = table + tabsize; id < tabend; ++id)
    init_idesc (cpu, id, t);

  /* Now fill in the values for the chosen cpu.  */
  for (t = @prefix@_insn_sem, tend = t + sizeof (@prefix@_insn_sem) / sizeof (*t);
       t != tend; ++t)
    {
      init_idesc (cpu, & table[t->index], t);
    }

  /* Link the IDESC table into the cpu.  */
  CPU_IDESC (cpu) = table;
}

/* Given an instruction, return a pointer to its IDESC entry.  */

const IDESC *
@prefix@_decode (SIM_CPU *current_cpu, IADDR pc,
              CGEN_INSN_INT base_insn, CGEN_INSN_INT entire_insn,
              ARGBUF *abuf)
{
  /* Result of decoder.  */
  @PREFIX@_INSN_TYPE itype;

  {
    CGEN_INSN_INT insn = base_insn;

    {
      unsigned int val = (((insn >> 22) & (63 << 4)) | ((insn >> 16) & (15 << 0)));
      switch (val)
      {
      case 1 : itype = @PREFIX@_INSN_CMPEQ;goto done;
      case 3 : itype = @PREFIX@_INSN_CMPGT;goto done;
      case 7 : itype = @PREFIX@_INSN_CMPGTU;goto done;
      case 8 : itype = @PREFIX@_INSN_ADDL;goto done;
      case 9 : itype = @PREFIX@_INSN_ADD;goto done;
      case 10 : itype = @PREFIX@_INSN_SUBL;goto done;
      case 11 : itype = @PREFIX@_INSN_SUB;goto done;
      case 12 : itype = @PREFIX@_INSN_ADDZL;goto done;
      case 13 : itype = @PREFIX@_INSN_NSB;goto done;
      case 14 : itype = @PREFIX@_INSN_MULUL;goto done;
      case 15 : itype = @PREFIX@_INSN_BYTEREV;goto done;
      case 16 : itype = @PREFIX@_INSN_SHLLDL;goto done;
      case 17 : itype = @PREFIX@_INSN_SHLLD;goto done;
      case 18 : itype = @PREFIX@_INSN_SHLRDL;goto done;
      case 19 : itype = @PREFIX@_INSN_SHLRD;goto done;
      case 22 : itype = @PREFIX@_INSN_SHARDL;goto done;
      case 23 : itype = @PREFIX@_INSN_SHARD;goto done;
      case 25 : itype = @PREFIX@_INSN_OR;goto done;
      case 27 : itype = @PREFIX@_INSN_AND;goto done;
      case 29 : itype = @PREFIX@_INSN_XOR;goto done;
      case 30 : itype = @PREFIX@_INSN_MULSL;goto done;
      case 31 : itype = @PREFIX@_INSN_ANDC;goto done;
      case 33 : itype = @PREFIX@_INSN_MADDW;goto done;
      case 34 : itype = @PREFIX@_INSN_MADDL;goto done;
      case 36 : itype = @PREFIX@_INSN_MADDSUB;goto done;
      case 37 : itype = @PREFIX@_INSN_MADDSW;goto done;
      case 38 : itype = @PREFIX@_INSN_MADDSL;goto done;
      case 41 : itype = @PREFIX@_INSN_MSUBW;goto done;
      case 42 : itype = @PREFIX@_INSN_MSUBL;goto done;
      case 44 : itype = @PREFIX@_INSN_MSUBSUB;goto done;
      case 45 : itype = @PREFIX@_INSN_MSUBSW;goto done;
      case 46 : itype = @PREFIX@_INSN_MSUBSL;goto done;
      case 49 : itype = @PREFIX@_INSN_MSHLLDW;goto done;
      case 50 : itype = @PREFIX@_INSN_MSHLLDL;goto done;
      case 53 : itype = @PREFIX@_INSN_MSHALDSW;goto done;
      case 54 : itype = @PREFIX@_INSN_MSHALDSL;goto done;
      case 57 : itype = @PREFIX@_INSN_MSHARDW;goto done;
      case 58 : itype = @PREFIX@_INSN_MSHARDL;goto done;
      case 59 : itype = @PREFIX@_INSN_MSHARDSQ;goto done;
      case 61 : itype = @PREFIX@_INSN_MSHLRDW;goto done;
      case 62 : itype = @PREFIX@_INSN_MSHLRDL;goto done;
      case 86 : itype = @PREFIX@_INSN_FIPRS;goto done;
      case 94 : itype = @PREFIX@_INSN_FTRVS;goto done;
      case 96 : itype = @PREFIX@_INSN_FABSS;goto done;
      case 97 : itype = @PREFIX@_INSN_FABSD;goto done;
      case 98 : itype = @PREFIX@_INSN_FNEGS;goto done;
      case 99 : itype = @PREFIX@_INSN_FNEGD;goto done;
      case 112 : itype = @PREFIX@_INSN_FMOVLS;goto done;
      case 113 : itype = @PREFIX@_INSN_FMOVQD;goto done;
      case 114 : itype = @PREFIX@_INSN_FGETSCR;goto done;
      case 120 : itype = @PREFIX@_INSN_FLDXS;goto done;
      case 121 : itype = @PREFIX@_INSN_FLDXD;goto done;
      case 125 : itype = @PREFIX@_INSN_FLDXP;goto done;
      case 129 : itype = @PREFIX@_INSN_CMVEQ;goto done;
      case 131 : itype = @PREFIX@_INSN_SWAPQ;goto done;
      case 133 : itype = @PREFIX@_INSN_CMVNE;goto done;
      case 159 : itype = @PREFIX@_INSN_GETCON;goto done;
      case 160 : itype = @PREFIX@_INSN_MCMPEQB;goto done;
      case 161 : itype = @PREFIX@_INSN_MCMPEQW;goto done;
      case 162 : itype = @PREFIX@_INSN_MCMPEQL;goto done;
      case 164 : itype = @PREFIX@_INSN_MCMPGTUB;goto done;
      case 165 : itype = @PREFIX@_INSN_MCMPGTW;goto done;
      case 166 : itype = @PREFIX@_INSN_MCMPGTL;goto done;
      case 167 : itype = @PREFIX@_INSN_MEXTR1;goto done;
      case 169 : itype = @PREFIX@_INSN_MABSW;goto done;
      case 170 : itype = @PREFIX@_INSN_MABSL;goto done;
      case 171 : itype = @PREFIX@_INSN_MEXTR2;goto done;
      case 173 : itype = @PREFIX@_INSN_MPERMW;goto done;
      case 175 : itype = @PREFIX@_INSN_MEXTR3;goto done;
      case 176 : itype = @PREFIX@_INSN_MSHFLOB;goto done;
      case 177 : itype = @PREFIX@_INSN_MSHFLOW;goto done;
      case 178 : itype = @PREFIX@_INSN_MSHFLOL;goto done;
      case 179 : itype = @PREFIX@_INSN_MEXTR4;goto done;
      case 180 : itype = @PREFIX@_INSN_MSHFHIB;goto done;
      case 181 : itype = @PREFIX@_INSN_MSHFHIW;goto done;
      case 182 : itype = @PREFIX@_INSN_MSHFHIL;goto done;
      case 183 : itype = @PREFIX@_INSN_MEXTR5;goto done;
      case 187 : itype = @PREFIX@_INSN_MEXTR6;goto done;
      case 191 : itype = @PREFIX@_INSN_MEXTR7;goto done;
      case 192 : itype = @PREFIX@_INSN_FMOVSL;goto done;
      case 193 : itype = @PREFIX@_INSN_FMOVDQ;goto done;
      case 194 : itype = @PREFIX@_INSN_FPUTSCR;goto done;
      case 200 : itype = @PREFIX@_INSN_FCMPEQS;goto done;
      case 201 : itype = @PREFIX@_INSN_FCMPEQD;goto done;
      case 202 : itype = @PREFIX@_INSN_FCMPUNS;goto done;
      case 203 : itype = @PREFIX@_INSN_FCMPUND;goto done;
      case 204 : itype = @PREFIX@_INSN_FCMPGTS;goto done;
      case 205 : itype = @PREFIX@_INSN_FCMPGTD;goto done;
      case 206 : itype = @PREFIX@_INSN_FCMPGES;goto done;
      case 207 : itype = @PREFIX@_INSN_FCMPGED;goto done;
      case 208 : itype = @PREFIX@_INSN_FADDS;goto done;
      case 209 : itype = @PREFIX@_INSN_FADDD;goto done;
      case 210 : itype = @PREFIX@_INSN_FSUBS;goto done;
      case 211 : itype = @PREFIX@_INSN_FSUBD;goto done;
      case 212 : itype = @PREFIX@_INSN_FDIVS;goto done;
      case 213 : itype = @PREFIX@_INSN_FDIVD;goto done;
      case 214 : itype = @PREFIX@_INSN_FMULS;goto done;
      case 215 : itype = @PREFIX@_INSN_FMULD;goto done;
      case 222 : itype = @PREFIX@_INSN_FMACS;goto done;
      case 224 : itype = @PREFIX@_INSN_FMOVS;goto done;
      case 225 : itype = @PREFIX@_INSN_FMOVD;goto done;
      case 228 : itype = @PREFIX@_INSN_FSQRTS;goto done;
      case 229 : itype = @PREFIX@_INSN_FSQRTD;goto done;
      case 230 : itype = @PREFIX@_INSN_FCNVSD;goto done;
      case 231 : itype = @PREFIX@_INSN_FCNVDS;goto done;
      case 232 : itype = @PREFIX@_INSN_FTRCSL;goto done;
      case 233 : itype = @PREFIX@_INSN_FTRCDQ;goto done;
      case 234 : itype = @PREFIX@_INSN_FTRCSQ;goto done;
      case 235 : itype = @PREFIX@_INSN_FTRCDL;goto done;
      case 236 : itype = @PREFIX@_INSN_FLOATLS;goto done;
      case 237 : itype = @PREFIX@_INSN_FLOATQD;goto done;
      case 238 : itype = @PREFIX@_INSN_FLOATLD;goto done;
      case 239 : itype = @PREFIX@_INSN_FLOATQS;goto done;
      case 248 : itype = @PREFIX@_INSN_FSTXS;goto done;
      case 249 : itype = @PREFIX@_INSN_FSTXD;goto done;
      case 253 : itype = @PREFIX@_INSN_FSTXP;goto done;
      case 256 : itype = @PREFIX@_INSN_LDXB;goto done;
      case 257 : itype = @PREFIX@_INSN_LDXW;goto done;
      case 258 : itype = @PREFIX@_INSN_LDXL;goto done;
      case 259 : itype = @PREFIX@_INSN_LDXQ;goto done;
      case 260 : itype = @PREFIX@_INSN_LDXUB;goto done;
      case 261 : itype = @PREFIX@_INSN_LDXUW;goto done;
      case 273 : itype = @PREFIX@_INSN_BLINK;goto done;
      case 277 : itype = @PREFIX@_INSN_GETTR;goto done;
      case 288 : itype = @PREFIX@_INSN_MSADUBQ;goto done;
      case 289 : itype = @PREFIX@_INSN_MMACFXWL;goto done;
      case 291 : itype = @PREFIX@_INSN_MCMV;goto done;
      case 293 : itype = @PREFIX@_INSN_MMACNFX_WL;goto done;
      case 297 : itype = @PREFIX@_INSN_MMULSUMWQ;goto done;
      case 305 : itype = @PREFIX@_INSN_MMULW;goto done;
      case 306 : itype = @PREFIX@_INSN_MMULL;goto done;
      case 309 : itype = @PREFIX@_INSN_MMULFXW;goto done;
      case 310 : itype = @PREFIX@_INSN_MMULFXL;goto done;
      case 312 : itype = @PREFIX@_INSN_MCNVSWB;goto done;
      case 313 : itype = @PREFIX@_INSN_MMULFXRPW;goto done;
      case 314 : itype = @PREFIX@_INSN_MMULLOWL;goto done;
      case 316 : itype = @PREFIX@_INSN_MCNVSWUB;goto done;
      case 317 : itype = @PREFIX@_INSN_MCNVSLW;goto done;
      case 318 : itype = @PREFIX@_INSN_MMULHIWL;goto done;
      case 384 : itype = @PREFIX@_INSN_STXB;goto done;
      case 385 : itype = @PREFIX@_INSN_STXW;goto done;
      case 386 : itype = @PREFIX@_INSN_STXL;goto done;
      case 387 : itype = @PREFIX@_INSN_STXQ;goto done;
      case 401 : itype = @PREFIX@_INSN_BEQ;goto done;
      case 403 : itype = @PREFIX@_INSN_BGE;goto done;
      case 405 : itype = @PREFIX@_INSN_BNE;goto done;
      case 407 : itype = @PREFIX@_INSN_BGT;goto done;
      case 411 : itype = @PREFIX@_INSN_BGEU;goto done;
      case 415 : itype = @PREFIX@_INSN_BGTU;goto done;
      case 417 : itype = @PREFIX@_INSN_PTABS;goto done;
      case 421 : itype = @PREFIX@_INSN_PTREL;goto done;
      case 432 : itype = @PREFIX@_INSN_NOP;goto done;
      case 433 : itype = @PREFIX@_INSN_TRAPA;goto done;
      case 434 : itype = @PREFIX@_INSN_SYNCI;goto done;
      case 435 : itype = @PREFIX@_INSN_RTE;goto done;
      case 437 : itype = @PREFIX@_INSN_BRK;goto done;
      case 438 : itype = @PREFIX@_INSN_SYNCO;goto done;
      case 439 : itype = @PREFIX@_INSN_SLEEP;goto done;
      case 447 : itype = @PREFIX@_INSN_PUTCON;goto done;
      case 512 : /* fall through */
      case 513 : /* fall through */
      case 514 : /* fall through */
      case 515 : /* fall through */
      case 516 : /* fall through */
      case 517 : /* fall through */
      case 518 : /* fall through */
      case 519 : /* fall through */
      case 520 : /* fall through */
      case 521 : /* fall through */
      case 522 : /* fall through */
      case 523 : /* fall through */
      case 524 : /* fall through */
      case 525 : /* fall through */
      case 526 : /* fall through */
      case 527 : itype = @PREFIX@_INSN_LDB;goto done;
      case 528 : /* fall through */
      case 529 : /* fall through */
      case 530 : /* fall through */
      case 531 : /* fall through */
      case 532 : /* fall through */
      case 533 : /* fall through */
      case 534 : /* fall through */
      case 535 : /* fall through */
      case 536 : /* fall through */
      case 537 : /* fall through */
      case 538 : /* fall through */
      case 539 : /* fall through */
      case 540 : /* fall through */
      case 541 : /* fall through */
      case 542 : /* fall through */
      case 543 : itype = @PREFIX@_INSN_LDW;goto done;
      case 544 : /* fall through */
      case 545 : /* fall through */
      case 546 : /* fall through */
      case 547 : /* fall through */
      case 548 : /* fall through */
      case 549 : /* fall through */
      case 550 : /* fall through */
      case 551 : /* fall through */
      case 552 : /* fall through */
      case 553 : /* fall through */
      case 554 : /* fall through */
      case 555 : /* fall through */
      case 556 : /* fall through */
      case 557 : /* fall through */
      case 558 : /* fall through */
      case 559 : itype = @PREFIX@_INSN_LDL;goto done;
      case 560 : /* fall through */
      case 561 : /* fall through */
      case 562 : /* fall through */
      case 563 : /* fall through */
      case 564 : /* fall through */
      case 565 : /* fall through */
      case 566 : /* fall through */
      case 567 : /* fall through */
      case 568 : /* fall through */
      case 569 : /* fall through */
      case 570 : /* fall through */
      case 571 : /* fall through */
      case 572 : /* fall through */
      case 573 : /* fall through */
      case 574 : /* fall through */
      case 575 : itype = @PREFIX@_INSN_LDQ;goto done;
      case 576 : /* fall through */
      case 577 : /* fall through */
      case 578 : /* fall through */
      case 579 : /* fall through */
      case 580 : /* fall through */
      case 581 : /* fall through */
      case 582 : /* fall through */
      case 583 : /* fall through */
      case 584 : /* fall through */
      case 585 : /* fall through */
      case 586 : /* fall through */
      case 587 : /* fall through */
      case 588 : /* fall through */
      case 589 : /* fall through */
      case 590 : /* fall through */
      case 591 : itype = @PREFIX@_INSN_LDUB;goto done;
      case 592 : /* fall through */
      case 593 : /* fall through */
      case 594 : /* fall through */
      case 595 : /* fall through */
      case 596 : /* fall through */
      case 597 : /* fall through */
      case 598 : /* fall through */
      case 599 : /* fall through */
      case 600 : /* fall through */
      case 601 : /* fall through */
      case 602 : /* fall through */
      case 603 : /* fall through */
      case 604 : /* fall through */
      case 605 : /* fall through */
      case 606 : /* fall through */
      case 607 : itype = @PREFIX@_INSN_FLDS;goto done;
      case 608 : /* fall through */
      case 609 : /* fall through */
      case 610 : /* fall through */
      case 611 : /* fall through */
      case 612 : /* fall through */
      case 613 : /* fall through */
      case 614 : /* fall through */
      case 615 : /* fall through */
      case 616 : /* fall through */
      case 617 : /* fall through */
      case 618 : /* fall through */
      case 619 : /* fall through */
      case 620 : /* fall through */
      case 621 : /* fall through */
      case 622 : /* fall through */
      case 623 : itype = @PREFIX@_INSN_FLDP;goto done;
      case 624 : /* fall through */
      case 625 : /* fall through */
      case 626 : /* fall through */
      case 627 : /* fall through */
      case 628 : /* fall through */
      case 629 : /* fall through */
      case 630 : /* fall through */
      case 631 : /* fall through */
      case 632 : /* fall through */
      case 633 : /* fall through */
      case 634 : /* fall through */
      case 635 : /* fall through */
      case 636 : /* fall through */
      case 637 : /* fall through */
      case 638 : /* fall through */
      case 639 : itype = @PREFIX@_INSN_FLDD;goto done;
      case 640 : /* fall through */
      case 641 : /* fall through */
      case 642 : /* fall through */
      case 643 : /* fall through */
      case 644 : /* fall through */
      case 645 : /* fall through */
      case 646 : /* fall through */
      case 647 : /* fall through */
      case 648 : /* fall through */
      case 649 : /* fall through */
      case 650 : /* fall through */
      case 651 : /* fall through */
      case 652 : /* fall through */
      case 653 : /* fall through */
      case 654 : /* fall through */
      case 655 : itype = @PREFIX@_INSN_STB;goto done;
      case 656 : /* fall through */
      case 657 : /* fall through */
      case 658 : /* fall through */
      case 659 : /* fall through */
      case 660 : /* fall through */
      case 661 : /* fall through */
      case 662 : /* fall through */
      case 663 : /* fall through */
      case 664 : /* fall through */
      case 665 : /* fall through */
      case 666 : /* fall through */
      case 667 : /* fall through */
      case 668 : /* fall through */
      case 669 : /* fall through */
      case 670 : /* fall through */
      case 671 : itype = @PREFIX@_INSN_STW;goto done;
      case 672 : /* fall through */
      case 673 : /* fall through */
      case 674 : /* fall through */
      case 675 : /* fall through */
      case 676 : /* fall through */
      case 677 : /* fall through */
      case 678 : /* fall through */
      case 679 : /* fall through */
      case 680 : /* fall through */
      case 681 : /* fall through */
      case 682 : /* fall through */
      case 683 : /* fall through */
      case 684 : /* fall through */
      case 685 : /* fall through */
      case 686 : /* fall through */
      case 687 : itype = @PREFIX@_INSN_STL;goto done;
      case 688 : /* fall through */
      case 689 : /* fall through */
      case 690 : /* fall through */
      case 691 : /* fall through */
      case 692 : /* fall through */
      case 693 : /* fall through */
      case 694 : /* fall through */
      case 695 : /* fall through */
      case 696 : /* fall through */
      case 697 : /* fall through */
      case 698 : /* fall through */
      case 699 : /* fall through */
      case 700 : /* fall through */
      case 701 : /* fall through */
      case 702 : /* fall through */
      case 703 : itype = @PREFIX@_INSN_STQ;goto done;
      case 704 : /* fall through */
      case 705 : /* fall through */
      case 706 : /* fall through */
      case 707 : /* fall through */
      case 708 : /* fall through */
      case 709 : /* fall through */
      case 710 : /* fall through */
      case 711 : /* fall through */
      case 712 : /* fall through */
      case 713 : /* fall through */
      case 714 : /* fall through */
      case 715 : /* fall through */
      case 716 : /* fall through */
      case 717 : /* fall through */
      case 718 : /* fall through */
      case 719 : itype = @PREFIX@_INSN_LDUW;goto done;
      case 720 : /* fall through */
      case 721 : /* fall through */
      case 722 : /* fall through */
      case 723 : /* fall through */
      case 724 : /* fall through */
      case 725 : /* fall through */
      case 726 : /* fall through */
      case 727 : /* fall through */
      case 728 : /* fall through */
      case 729 : /* fall through */
      case 730 : /* fall through */
      case 731 : /* fall through */
      case 732 : /* fall through */
      case 733 : /* fall through */
      case 734 : /* fall through */
      case 735 : itype = @PREFIX@_INSN_FSTS;goto done;
      case 736 : /* fall through */
      case 737 : /* fall through */
      case 738 : /* fall through */
      case 739 : /* fall through */
      case 740 : /* fall through */
      case 741 : /* fall through */
      case 742 : /* fall through */
      case 743 : /* fall through */
      case 744 : /* fall through */
      case 745 : /* fall through */
      case 746 : /* fall through */
      case 747 : /* fall through */
      case 748 : /* fall through */
      case 749 : /* fall through */
      case 750 : /* fall through */
      case 751 : itype = @PREFIX@_INSN_FSTP;goto done;
      case 752 : /* fall through */
      case 753 : /* fall through */
      case 754 : /* fall through */
      case 755 : /* fall through */
      case 756 : /* fall through */
      case 757 : /* fall through */
      case 758 : /* fall through */
      case 759 : /* fall through */
      case 760 : /* fall through */
      case 761 : /* fall through */
      case 762 : /* fall through */
      case 763 : /* fall through */
      case 764 : /* fall through */
      case 765 : /* fall through */
      case 766 : /* fall through */
      case 767 : itype = @PREFIX@_INSN_FSTD;goto done;
      case 770 : itype = @PREFIX@_INSN_LDLOL;goto done;
      case 771 : itype = @PREFIX@_INSN_LDLOQ;goto done;
      case 774 : itype = @PREFIX@_INSN_LDHIL;goto done;
      case 775 : itype = @PREFIX@_INSN_LDHIQ;goto done;
      case 783 : itype = @PREFIX@_INSN_GETCFG;goto done;
      case 784 : itype = @PREFIX@_INSN_SHLLIL;goto done;
      case 785 : itype = @PREFIX@_INSN_SHLLI;goto done;
      case 786 : itype = @PREFIX@_INSN_SHLRIL;goto done;
      case 787 : itype = @PREFIX@_INSN_SHLRI;goto done;
      case 790 : itype = @PREFIX@_INSN_SHARIL;goto done;
      case 791 : itype = @PREFIX@_INSN_SHARI;goto done;
      case 797 : itype = @PREFIX@_INSN_XORI;goto done;
      case 800 : /* fall through */
      case 801 : /* fall through */
      case 802 : /* fall through */
      case 803 : /* fall through */
      case 804 : /* fall through */
      case 805 : /* fall through */
      case 806 : /* fall through */
      case 807 : /* fall through */
      case 808 : /* fall through */
      case 809 : /* fall through */
      case 810 : /* fall through */
      case 811 : /* fall through */
      case 812 : /* fall through */
      case 813 : /* fall through */
      case 814 : /* fall through */
      case 815 : itype = @PREFIX@_INSN_SHORI;goto done;
      case 816 : /* fall through */
      case 817 : /* fall through */
      case 818 : /* fall through */
      case 819 : /* fall through */
      case 820 : /* fall through */
      case 821 : /* fall through */
      case 822 : /* fall through */
      case 823 : /* fall through */
      case 824 : /* fall through */
      case 825 : /* fall through */
      case 826 : /* fall through */
      case 827 : /* fall through */
      case 828 : /* fall through */
      case 829 : /* fall through */
      case 830 : /* fall through */
      case 831 : itype = @PREFIX@_INSN_MOVI;goto done;
      case 832 : /* fall through */
      case 833 : /* fall through */
      case 834 : /* fall through */
      case 835 : /* fall through */
      case 836 : /* fall through */
      case 837 : /* fall through */
      case 838 : /* fall through */
      case 839 : /* fall through */
      case 840 : /* fall through */
      case 841 : /* fall through */
      case 842 : /* fall through */
      case 843 : /* fall through */
      case 844 : /* fall through */
      case 845 : /* fall through */
      case 846 : /* fall through */
      case 847 : itype = @PREFIX@_INSN_ADDI;goto done;
      case 848 : /* fall through */
      case 849 : /* fall through */
      case 850 : /* fall through */
      case 851 : /* fall through */
      case 852 : /* fall through */
      case 853 : /* fall through */
      case 854 : /* fall through */
      case 855 : /* fall through */
      case 856 : /* fall through */
      case 857 : /* fall through */
      case 858 : /* fall through */
      case 859 : /* fall through */
      case 860 : /* fall through */
      case 861 : /* fall through */
      case 862 : /* fall through */
      case 863 : itype = @PREFIX@_INSN_ADDIL;goto done;
      case 864 : /* fall through */
      case 865 : /* fall through */
      case 866 : /* fall through */
      case 867 : /* fall through */
      case 868 : /* fall through */
      case 869 : /* fall through */
      case 870 : /* fall through */
      case 871 : /* fall through */
      case 872 : /* fall through */
      case 873 : /* fall through */
      case 874 : /* fall through */
      case 875 : /* fall through */
      case 876 : /* fall through */
      case 877 : /* fall through */
      case 878 : /* fall through */
      case 879 : itype = @PREFIX@_INSN_ANDI;goto done;
      case 880 : /* fall through */
      case 881 : /* fall through */
      case 882 : /* fall through */
      case 883 : /* fall through */
      case 884 : /* fall through */
      case 885 : /* fall through */
      case 886 : /* fall through */
      case 887 : /* fall through */
      case 888 : /* fall through */
      case 889 : /* fall through */
      case 890 : /* fall through */
      case 891 : /* fall through */
      case 892 : /* fall through */
      case 893 : /* fall through */
      case 894 : /* fall through */
      case 895 : itype = @PREFIX@_INSN_ORI;goto done;
      case 897 : itype = @PREFIX@_INSN_PREFI;goto done;
      case 898 : itype = @PREFIX@_INSN_STLOL;goto done;
      case 899 : itype = @PREFIX@_INSN_STLOQ;goto done;
      case 900 : itype = @PREFIX@_INSN_ALLOCO;goto done;
      case 901 : itype = @PREFIX@_INSN_ICBI;goto done;
      case 902 : itype = @PREFIX@_INSN_STHIL;goto done;
      case 903 : itype = @PREFIX@_INSN_STHIQ;goto done;
      case 904 : itype = @PREFIX@_INSN_OCBP;goto done;
      case 905 : itype = @PREFIX@_INSN_OCBI;goto done;
      case 908 : itype = @PREFIX@_INSN_OCBWB;goto done;
      case 911 : itype = @PREFIX@_INSN_PUTCFG;goto done;
      case 913 : itype = @PREFIX@_INSN_BEQI;goto done;
      case 917 : itype = @PREFIX@_INSN_BNEI;goto done;
      case 928 : /* fall through */
      case 929 : /* fall through */
      case 930 : /* fall through */
      case 931 : /* fall through */
      case 932 : /* fall through */
      case 933 : /* fall through */
      case 934 : /* fall through */
      case 935 : /* fall through */
      case 936 : /* fall through */
      case 937 : /* fall through */
      case 938 : /* fall through */
      case 939 : /* fall through */
      case 940 : /* fall through */
      case 941 : /* fall through */
      case 942 : /* fall through */
      case 943 : itype = @PREFIX@_INSN_PTA;goto done;
      case 944 : /* fall through */
      case 945 : /* fall through */
      case 946 : /* fall through */
      case 947 : /* fall through */
      case 948 : /* fall through */
      case 949 : /* fall through */
      case 950 : /* fall through */
      case 951 : /* fall through */
      case 952 : /* fall through */
      case 953 : /* fall through */
      case 954 : /* fall through */
      case 955 : /* fall through */
      case 956 : /* fall through */
      case 957 : /* fall through */
      case 958 : /* fall through */
      case 959 : itype = @PREFIX@_INSN_PTB;goto done;
      default : itype = @PREFIX@_INSN_X_INVALID; goto done;
      }
    }
  }

  /* Extraction is defered until the semantic code.  */

 done:
  return &@prefix@_insn_data[itype];
}
