; NOTE: Assertions have been autogenerated by utils/update_mir_test_checks.py
; RUN: llc -global-isel -global-isel-abort=1 %s -stop-after=irtranslator -o - | FileCheck %s
target triple = "aarch64-apple-ios"

; Check that we correctly split %arg into two vector registers of
; size <2 x i64>.
define hidden fastcc <4 x float> @foo(<4 x i64> %arg) unnamed_addr #0 {
  ; CHECK-LABEL: name: foo
  ; CHECK: bb.1.bb:
  ; CHECK:   liveins: $q0, $q1
  ; CHECK:   [[COPY:%[0-9]+]]:_(<2 x s64>) = COPY $q0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(<2 x s64>) = COPY $q1
  ; CHECK:   [[CONCAT_VECTORS:%[0-9]+]]:_(<4 x s64>) = G_CONCAT_VECTORS [[COPY]](<2 x s64>), [[COPY1]](<2 x s64>)
  ; CHECK:   [[UITOFP:%[0-9]+]]:_(<4 x s32>) = G_UITOFP [[CONCAT_VECTORS]](<4 x s64>)
  ; CHECK:   $q0 = COPY [[UITOFP]](<4 x s32>)
  ; CHECK:   RET_ReallyLR implicit $q0
bb:
  %tmp = uitofp <4 x i64> %arg to <4 x float>
  ret <4 x float> %tmp
}

attributes #0 = { nounwind readnone }
