; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=aarch64-gnu-linux -mattr=+neon,+sve -vector-library=sleefgnuabi < %s | FileCheck %s -check-prefix=SLEEF
; RUN: llc -mtriple=aarch64-gnu-linux -mattr=+neon,+sve -vector-library=ArmPL < %s | FileCheck %s -check-prefix=ARMPL

define void @test_sincospi_v4f32(<4 x float> %x, ptr noalias %out_sin, ptr noalias %out_cos) {
; SLEEF-LABEL: test_sincospi_v4f32:
; SLEEF:       // %bb.0:
; SLEEF-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; SLEEF-NEXT:    .cfi_def_cfa_offset 16
; SLEEF-NEXT:    .cfi_offset w30, -16
; SLEEF-NEXT:    bl _ZGVnN4vl4l4_sincospif
; SLEEF-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; SLEEF-NEXT:    ret
;
; ARMPL-LABEL: test_sincospi_v4f32:
; ARMPL:       // %bb.0:
; ARMPL-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; ARMPL-NEXT:    .cfi_def_cfa_offset 16
; ARMPL-NEXT:    .cfi_offset w30, -16
; ARMPL-NEXT:    bl armpl_vsincospiq_f32
; ARMPL-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; ARMPL-NEXT:    ret
  %result = call { <4 x float>, <4 x float> } @llvm.sincospi.v4f32(<4 x float> %x)
  %result.0 = extractvalue { <4 x float>, <4 x float> } %result, 0
  %result.1 = extractvalue { <4 x float>, <4 x float> } %result, 1
  store <4 x float> %result.0, ptr %out_sin, align 4
  store <4 x float> %result.1, ptr %out_cos, align 4
  ret void
}

define void @test_sincospi_v2f64(<2 x double> %x, ptr noalias %out_sin, ptr noalias %out_cos) {
; SLEEF-LABEL: test_sincospi_v2f64:
; SLEEF:       // %bb.0:
; SLEEF-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; SLEEF-NEXT:    .cfi_def_cfa_offset 16
; SLEEF-NEXT:    .cfi_offset w30, -16
; SLEEF-NEXT:    bl _ZGVnN2vl8l8_sincospi
; SLEEF-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; SLEEF-NEXT:    ret
;
; ARMPL-LABEL: test_sincospi_v2f64:
; ARMPL:       // %bb.0:
; ARMPL-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; ARMPL-NEXT:    .cfi_def_cfa_offset 16
; ARMPL-NEXT:    .cfi_offset w30, -16
; ARMPL-NEXT:    bl armpl_vsincospiq_f64
; ARMPL-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; ARMPL-NEXT:    ret
  %result = call { <2 x double>, <2 x double> } @llvm.sincospi.v2f64(<2 x double> %x)
  %result.0 = extractvalue { <2 x double>, <2 x double> } %result, 0
  %result.1 = extractvalue { <2 x double>, <2 x double> } %result, 1
  store <2 x double> %result.0, ptr %out_sin, align 8
  store <2 x double> %result.1, ptr %out_cos, align 8
  ret void
}

define void @test_sincospi_nxv4f32(<vscale x 4 x float> %x, ptr noalias %out_sin, ptr noalias %out_cos) {
; SLEEF-LABEL: test_sincospi_nxv4f32:
; SLEEF:       // %bb.0:
; SLEEF-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; SLEEF-NEXT:    .cfi_def_cfa_offset 16
; SLEEF-NEXT:    .cfi_offset w30, -16
; SLEEF-NEXT:    bl _ZGVsNxvl4l4_sincospif
; SLEEF-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; SLEEF-NEXT:    ret
;
; ARMPL-LABEL: test_sincospi_nxv4f32:
; ARMPL:       // %bb.0:
; ARMPL-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; ARMPL-NEXT:    .cfi_def_cfa_offset 16
; ARMPL-NEXT:    .cfi_offset w30, -16
; ARMPL-NEXT:    ptrue p0.s
; ARMPL-NEXT:    bl armpl_svsincospi_f32_x
; ARMPL-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; ARMPL-NEXT:    ret
  %result = call { <vscale x 4 x float>, <vscale x 4 x float> } @llvm.sincospi.nxv4f32(<vscale x 4 x float> %x)
  %result.0 = extractvalue { <vscale x 4 x float>, <vscale x 4 x float> } %result, 0
  %result.1 = extractvalue { <vscale x 4 x float>, <vscale x 4 x float> } %result, 1
  store <vscale x 4 x float> %result.0, ptr %out_sin, align 4
  store <vscale x 4 x float> %result.1, ptr %out_cos, align 4
  ret void
}

define void @test_sincospi_nxv2f64(<vscale x 2 x double> %x, ptr noalias %out_sin, ptr noalias %out_cos) {
; SLEEF-LABEL: test_sincospi_nxv2f64:
; SLEEF:       // %bb.0:
; SLEEF-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; SLEEF-NEXT:    .cfi_def_cfa_offset 16
; SLEEF-NEXT:    .cfi_offset w30, -16
; SLEEF-NEXT:    bl _ZGVsNxvl8l8_sincospi
; SLEEF-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; SLEEF-NEXT:    ret
;
; ARMPL-LABEL: test_sincospi_nxv2f64:
; ARMPL:       // %bb.0:
; ARMPL-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; ARMPL-NEXT:    .cfi_def_cfa_offset 16
; ARMPL-NEXT:    .cfi_offset w30, -16
; ARMPL-NEXT:    ptrue p0.d
; ARMPL-NEXT:    bl armpl_svsincospi_f64_x
; ARMPL-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; ARMPL-NEXT:    ret
  %result = call { <vscale x 2 x double>, <vscale x 2 x double> } @llvm.sincospi.nxv2f64(<vscale x 2 x double> %x)
  %result.0 = extractvalue { <vscale x 2 x double>, <vscale x 2 x double> } %result, 0
  %result.1 = extractvalue { <vscale x 2 x double>, <vscale x 2 x double> } %result, 1
  store <vscale x 2 x double> %result.0, ptr %out_sin, align 8
  store <vscale x 2 x double> %result.1, ptr %out_cos, align 8
  ret void
}
