//- SystemZHLASMInstPrinter.h - Convert SystemZ MCInst to assembly -*- C++ -*-//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//
//
// This class prints a SystemZ MCInst to a .s file in HLASM assembly format.
//
//===----------------------------------------------------------------------===//

#ifndef LLVM_LIB_TARGET_SYSTEMZ_MCTARGETDESC_SYSTEMZHLASMINSTPRINTER_H
#define LLVM_LIB_TARGET_SYSTEMZ_MCTARGETDESC_SYSTEMZHLASMINSTPRINTER_H

#include "SystemZInstPrinterCommon.h"
#include "llvm/MC/MCInstPrinter.h"
#include <cstdint>

namespace llvm {

class MCOperand;

class SystemZHLASMInstPrinter : public SystemZInstPrinterCommon {
public:
  SystemZHLASMInstPrinter(const MCAsmInfo &MAI, const MCInstrInfo &MII,
                          const MCRegisterInfo &MRI)
      : SystemZInstPrinterCommon(MAI, MII, MRI) {}

  // Automatically generated by tblgen.
  std::pair<const char *, uint64_t>
  getMnemonic(const MCInst &MI) const override;
  void printInstruction(const MCInst *MI, uint64_t Address, raw_ostream &O);
  static const char *getRegisterName(MCRegister Reg);

  void printInst(const MCInst *MI, uint64_t Address, StringRef Annot,
                 const MCSubtargetInfo &STI, raw_ostream &O) override;

private:
  void printFormattedRegName(const MCAsmInfo *MAI, MCRegister Reg,
                             raw_ostream &O) override;
};

} // end namespace llvm

#endif // LLVM_LIB_TARGET_SYSTEMZ_MCTARGETDESC_SYSTEMZHLASMINSTPRINTER_H
