; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; Test that we are able to generate the Xqcicli instructions
; RUN: llc -mtriple=riscv32 -verify-machineinstrs < %s \
; RUN:   | FileCheck %s --check-prefixes=RV32I
; RUN: llc -mtriple=riscv32 -mattr=+experimental-xqcicli,+experimental-xqcics -verify-machineinstrs < %s \
; RUN:   | FileCheck %s --check-prefixes=RV32IXQCICLI
; RUN: llc -mtriple=riscv32 -mattr=+experimental-xqcicli,+experimental-xqcicm -verify-machineinstrs < %s \
; RUN:   | FileCheck %s --check-prefixes=RV32IXQCICLI

define i32 @select_cc_example_eq(i32 %a, i32 %b, i32 %x, i32 %y) {
; RV32I-LABEL: select_cc_example_eq:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    bne a1, a2, .LBB0_2
; RV32I-NEXT:  # %bb.1: # %entry
; RV32I-NEXT:    li a0, 11
; RV32I-NEXT:  .LBB0_2: # %entry
; RV32I-NEXT:    ret
;
; RV32IXQCICLI-LABEL: select_cc_example_eq:
; RV32IXQCICLI:       # %bb.0: # %entry
; RV32IXQCICLI-NEXT:    qc.lieq a0, a1, a2, 11
; RV32IXQCICLI-NEXT:    ret
entry:
  %cmp = icmp eq i32 %b, %x
  %sel = select i1 %cmp, i32 11, i32 %a
  ret i32 %sel
}

define i32 @select_cc_example_ne(i32 %a, i32 %b, i32 %x, i32 %y) {
; RV32I-LABEL: select_cc_example_ne:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    beq a1, a2, .LBB1_2
; RV32I-NEXT:  # %bb.1: # %entry
; RV32I-NEXT:    li a0, 11
; RV32I-NEXT:  .LBB1_2: # %entry
; RV32I-NEXT:    ret
;
; RV32IXQCICLI-LABEL: select_cc_example_ne:
; RV32IXQCICLI:       # %bb.0: # %entry
; RV32IXQCICLI-NEXT:    qc.line a0, a1, a2, 11
; RV32IXQCICLI-NEXT:    ret
entry:
  %cmp = icmp ne i32 %b, %x
  %sel = select i1 %cmp, i32 11, i32 %a
  ret i32 %sel
}

define i32 @select_cc_example_slt(i32 %a, i32 %b, i32 %x, i32 %y) {
; RV32I-LABEL: select_cc_example_slt:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    bge a1, a2, .LBB2_2
; RV32I-NEXT:  # %bb.1: # %entry
; RV32I-NEXT:    li a0, 11
; RV32I-NEXT:  .LBB2_2: # %entry
; RV32I-NEXT:    ret
;
; RV32IXQCICLI-LABEL: select_cc_example_slt:
; RV32IXQCICLI:       # %bb.0: # %entry
; RV32IXQCICLI-NEXT:    qc.lilt a0, a1, a2, 11
; RV32IXQCICLI-NEXT:    ret
entry:
  %cmp = icmp slt i32 %b, %x
  %sel = select i1 %cmp, i32 11, i32 %a
  ret i32 %sel
}

define i32 @select_cc_example_sge(i32 %a, i32 %b, i32 %x, i32 %y) {
; RV32I-LABEL: select_cc_example_sge:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    blt a1, a2, .LBB3_2
; RV32I-NEXT:  # %bb.1: # %entry
; RV32I-NEXT:    li a0, 11
; RV32I-NEXT:  .LBB3_2: # %entry
; RV32I-NEXT:    ret
;
; RV32IXQCICLI-LABEL: select_cc_example_sge:
; RV32IXQCICLI:       # %bb.0: # %entry
; RV32IXQCICLI-NEXT:    qc.lige a0, a1, a2, 11
; RV32IXQCICLI-NEXT:    ret
entry:
  %cmp = icmp sge i32 %b, %x
  %sel = select i1 %cmp, i32 11, i32 %a
  ret i32 %sel
}

define i32 @select_cc_example_uge(i32 %a, i32 %b, i32 %x, i32 %y) {
; RV32I-LABEL: select_cc_example_uge:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    bltu a1, a2, .LBB4_2
; RV32I-NEXT:  # %bb.1: # %entry
; RV32I-NEXT:    li a0, 11
; RV32I-NEXT:  .LBB4_2: # %entry
; RV32I-NEXT:    ret
;
; RV32IXQCICLI-LABEL: select_cc_example_uge:
; RV32IXQCICLI:       # %bb.0: # %entry
; RV32IXQCICLI-NEXT:    qc.ligeu a0, a1, a2, 11
; RV32IXQCICLI-NEXT:    ret
entry:
  %cmp = icmp uge i32 %b, %x
  %sel = select i1 %cmp, i32 11, i32 %a
  ret i32 %sel
}

define i32 @select_cc_example_ult(i32 %a, i32 %b, i32 %x, i32 %y) {
; RV32I-LABEL: select_cc_example_ult:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    bgeu a1, a2, .LBB5_2
; RV32I-NEXT:  # %bb.1: # %entry
; RV32I-NEXT:    li a0, 11
; RV32I-NEXT:  .LBB5_2: # %entry
; RV32I-NEXT:    ret
;
; RV32IXQCICLI-LABEL: select_cc_example_ult:
; RV32IXQCICLI:       # %bb.0: # %entry
; RV32IXQCICLI-NEXT:    qc.liltu a0, a1, a2, 11
; RV32IXQCICLI-NEXT:    ret
entry:
  %cmp = icmp ult i32 %b, %x
  %sel = select i1 %cmp, i32 11, i32 %a
  ret i32 %sel
}

define i32 @select_cc_example_eq_c(i32 %a, i32 %b, i32 %x, i32 %y) {
; RV32I-LABEL: select_cc_example_eq_c:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    beq a1, a2, .LBB6_2
; RV32I-NEXT:  # %bb.1: # %entry
; RV32I-NEXT:    li a0, 11
; RV32I-NEXT:  .LBB6_2: # %entry
; RV32I-NEXT:    ret
;
; RV32IXQCICLI-LABEL: select_cc_example_eq_c:
; RV32IXQCICLI:       # %bb.0: # %entry
; RV32IXQCICLI-NEXT:    qc.line a0, a1, a2, 11
; RV32IXQCICLI-NEXT:    ret
entry:
  %cmp = icmp eq i32 %b, %x
  %sel = select i1 %cmp, i32 %a, i32 11
  ret i32 %sel
}

define i32 @select_cc_example_ne_c(i32 %a, i32 %b, i32 %x, i32 %y) {
; RV32I-LABEL: select_cc_example_ne_c:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    bne a1, a2, .LBB7_2
; RV32I-NEXT:  # %bb.1: # %entry
; RV32I-NEXT:    li a0, 11
; RV32I-NEXT:  .LBB7_2: # %entry
; RV32I-NEXT:    ret
;
; RV32IXQCICLI-LABEL: select_cc_example_ne_c:
; RV32IXQCICLI:       # %bb.0: # %entry
; RV32IXQCICLI-NEXT:    qc.lieq a0, a1, a2, 11
; RV32IXQCICLI-NEXT:    ret
entry:
  %cmp = icmp ne i32 %b, %x
  %sel = select i1 %cmp, i32 %a, i32 11
  ret i32 %sel
}

define i32 @select_cc_example_slt_c(i32 %a, i32 %b, i32 %x, i32 %y) {
; RV32I-LABEL: select_cc_example_slt_c:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    blt a1, a2, .LBB8_2
; RV32I-NEXT:  # %bb.1: # %entry
; RV32I-NEXT:    li a0, 11
; RV32I-NEXT:  .LBB8_2: # %entry
; RV32I-NEXT:    ret
;
; RV32IXQCICLI-LABEL: select_cc_example_slt_c:
; RV32IXQCICLI:       # %bb.0: # %entry
; RV32IXQCICLI-NEXT:    qc.lige a0, a1, a2, 11
; RV32IXQCICLI-NEXT:    ret
entry:
  %cmp = icmp slt i32 %b, %x
  %sel = select i1 %cmp, i32 %a, i32 11
  ret i32 %sel
}

define i32 @select_cc_example_sge_c(i32 %a, i32 %b, i32 %x, i32 %y) {
; RV32I-LABEL: select_cc_example_sge_c:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    bge a1, a2, .LBB9_2
; RV32I-NEXT:  # %bb.1: # %entry
; RV32I-NEXT:    li a0, 11
; RV32I-NEXT:  .LBB9_2: # %entry
; RV32I-NEXT:    ret
;
; RV32IXQCICLI-LABEL: select_cc_example_sge_c:
; RV32IXQCICLI:       # %bb.0: # %entry
; RV32IXQCICLI-NEXT:    qc.lilt a0, a1, a2, 11
; RV32IXQCICLI-NEXT:    ret
entry:
  %cmp = icmp sge i32 %b, %x
  %sel = select i1 %cmp, i32 %a, i32 11
  ret i32 %sel
}

define i32 @select_cc_example_uge_c(i32 %a, i32 %b, i32 %x, i32 %y) {
; RV32I-LABEL: select_cc_example_uge_c:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    bgeu a1, a2, .LBB10_2
; RV32I-NEXT:  # %bb.1: # %entry
; RV32I-NEXT:    li a0, 11
; RV32I-NEXT:  .LBB10_2: # %entry
; RV32I-NEXT:    ret
;
; RV32IXQCICLI-LABEL: select_cc_example_uge_c:
; RV32IXQCICLI:       # %bb.0: # %entry
; RV32IXQCICLI-NEXT:    qc.liltu a0, a1, a2, 11
; RV32IXQCICLI-NEXT:    ret
entry:
  %cmp = icmp uge i32 %b, %x
  %sel = select i1 %cmp, i32 %a, i32 11
  ret i32 %sel
}

define i32 @select_cc_example_ult_c(i32 %a, i32 %b, i32 %x, i32 %y) {
; RV32I-LABEL: select_cc_example_ult_c:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    bltu a1, a2, .LBB11_2
; RV32I-NEXT:  # %bb.1: # %entry
; RV32I-NEXT:    li a0, 11
; RV32I-NEXT:  .LBB11_2: # %entry
; RV32I-NEXT:    ret
;
; RV32IXQCICLI-LABEL: select_cc_example_ult_c:
; RV32IXQCICLI:       # %bb.0: # %entry
; RV32IXQCICLI-NEXT:    qc.ligeu a0, a1, a2, 11
; RV32IXQCICLI-NEXT:    ret
entry:
  %cmp = icmp ult i32 %b, %x
  %sel = select i1 %cmp, i32 %a, i32 11
  ret i32 %sel
}

define i32 @select_cc_example_eqi(i32 %a, i32 %b, i32 %x, i32 %y) {
; RV32I-LABEL: select_cc_example_eqi:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    li a2, 12
; RV32I-NEXT:    bne a1, a2, .LBB12_2
; RV32I-NEXT:  # %bb.1: # %entry
; RV32I-NEXT:    li a0, 11
; RV32I-NEXT:  .LBB12_2: # %entry
; RV32I-NEXT:    ret
;
; RV32IXQCICLI-LABEL: select_cc_example_eqi:
; RV32IXQCICLI:       # %bb.0: # %entry
; RV32IXQCICLI-NEXT:    qc.lieqi a0, a1, 12, 11
; RV32IXQCICLI-NEXT:    ret
entry:
  %cmp = icmp eq i32 %b, 12
  %sel = select i1 %cmp, i32 11, i32 %a
  ret i32 %sel
}

define i32 @select_cc_example_nei(i32 %a, i32 %b, i32 %x, i32 %y) {
; RV32I-LABEL: select_cc_example_nei:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    li a2, 12
; RV32I-NEXT:    beq a1, a2, .LBB13_2
; RV32I-NEXT:  # %bb.1: # %entry
; RV32I-NEXT:    li a0, 11
; RV32I-NEXT:  .LBB13_2: # %entry
; RV32I-NEXT:    ret
;
; RV32IXQCICLI-LABEL: select_cc_example_nei:
; RV32IXQCICLI:       # %bb.0: # %entry
; RV32IXQCICLI-NEXT:    qc.linei a0, a1, 12, 11
; RV32IXQCICLI-NEXT:    ret
entry:
  %cmp = icmp ne i32 %b, 12
  %sel = select i1 %cmp, i32 11, i32 %a
  ret i32 %sel
}

define i32 @select_cc_example_slti(i32 %a, i32 %b, i32 %x, i32 %y) {
; RV32I-LABEL: select_cc_example_slti:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    li a2, 12
; RV32I-NEXT:    bge a1, a2, .LBB14_2
; RV32I-NEXT:  # %bb.1: # %entry
; RV32I-NEXT:    li a0, 11
; RV32I-NEXT:  .LBB14_2: # %entry
; RV32I-NEXT:    ret
;
; RV32IXQCICLI-LABEL: select_cc_example_slti:
; RV32IXQCICLI:       # %bb.0: # %entry
; RV32IXQCICLI-NEXT:    qc.lilti a0, a1, 12, 11
; RV32IXQCICLI-NEXT:    ret
entry:
  %cmp = icmp slt i32 %b, 12
  %sel = select i1 %cmp, i32 11, i32 %a
  ret i32 %sel
}

define i32 @select_cc_example_sgei(i32 %a, i32 %b, i32 %x, i32 %y) {
; RV32I-LABEL: select_cc_example_sgei:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    li a2, 11
; RV32I-NEXT:    bge a2, a1, .LBB15_2
; RV32I-NEXT:  # %bb.1: # %entry
; RV32I-NEXT:    li a0, 11
; RV32I-NEXT:  .LBB15_2: # %entry
; RV32I-NEXT:    ret
;
; RV32IXQCICLI-LABEL: select_cc_example_sgei:
; RV32IXQCICLI:       # %bb.0: # %entry
; RV32IXQCICLI-NEXT:    qc.ligei a0, a1, 12, 11
; RV32IXQCICLI-NEXT:    ret
entry:
  %cmp = icmp sge i32 %b, 12
  %sel = select i1 %cmp, i32 11, i32 %a
  ret i32 %sel
}

define i32 @select_cc_example_ulti(i32 %a, i32 %b, i32 %x, i32 %y) {
; RV32I-LABEL: select_cc_example_ulti:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    li a2, 12
; RV32I-NEXT:    bgeu a1, a2, .LBB16_2
; RV32I-NEXT:  # %bb.1: # %entry
; RV32I-NEXT:    li a0, 11
; RV32I-NEXT:  .LBB16_2: # %entry
; RV32I-NEXT:    ret
;
; RV32IXQCICLI-LABEL: select_cc_example_ulti:
; RV32IXQCICLI:       # %bb.0: # %entry
; RV32IXQCICLI-NEXT:    qc.liltui a0, a1, 12, 11
; RV32IXQCICLI-NEXT:    ret
entry:
  %cmp = icmp ult i32 %b, 12
  %sel = select i1 %cmp, i32 11, i32 %a
  ret i32 %sel
}

define i32 @select_cc_example_ugei(i32 %a, i32 %b, i32 %x, i32 %y) {
; RV32I-LABEL: select_cc_example_ugei:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    li a2, 11
; RV32I-NEXT:    bgeu a2, a1, .LBB17_2
; RV32I-NEXT:  # %bb.1: # %entry
; RV32I-NEXT:    li a0, 11
; RV32I-NEXT:  .LBB17_2: # %entry
; RV32I-NEXT:    ret
;
; RV32IXQCICLI-LABEL: select_cc_example_ugei:
; RV32IXQCICLI:       # %bb.0: # %entry
; RV32IXQCICLI-NEXT:    qc.ligeui a0, a1, 12, 11
; RV32IXQCICLI-NEXT:    ret
entry:
  %cmp = icmp uge i32 %b, 12
  %sel = select i1 %cmp, i32 11, i32 %a
  ret i32 %sel
}

define i32 @select_cc_example_eqi_c1(i32 %a, i32 %b, i32 %x, i32 %y) {
; RV32I-LABEL: select_cc_example_eqi_c1:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    li a2, 12
; RV32I-NEXT:    bne a1, a2, .LBB18_2
; RV32I-NEXT:  # %bb.1: # %entry
; RV32I-NEXT:    li a0, 11
; RV32I-NEXT:  .LBB18_2: # %entry
; RV32I-NEXT:    ret
;
; RV32IXQCICLI-LABEL: select_cc_example_eqi_c1:
; RV32IXQCICLI:       # %bb.0: # %entry
; RV32IXQCICLI-NEXT:    qc.lieqi a0, a1, 12, 11
; RV32IXQCICLI-NEXT:    ret
entry:
  %cmp = icmp eq i32 12, %b
  %sel = select i1 %cmp, i32 11, i32 %a
  ret i32 %sel
}

define i32 @select_cc_example_nei_c1(i32 %a, i32 %b, i32 %x, i32 %y) {
; RV32I-LABEL: select_cc_example_nei_c1:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    li a2, 12
; RV32I-NEXT:    beq a1, a2, .LBB19_2
; RV32I-NEXT:  # %bb.1: # %entry
; RV32I-NEXT:    li a0, 11
; RV32I-NEXT:  .LBB19_2: # %entry
; RV32I-NEXT:    ret
;
; RV32IXQCICLI-LABEL: select_cc_example_nei_c1:
; RV32IXQCICLI:       # %bb.0: # %entry
; RV32IXQCICLI-NEXT:    qc.linei a0, a1, 12, 11
; RV32IXQCICLI-NEXT:    ret
entry:
  %cmp = icmp ne i32 12, %b
  %sel = select i1 %cmp, i32 11, i32 %a
  ret i32 %sel
}

define i32 @select_cc_example_slti_c1(i32 %a, i32 %b, i32 %x, i32 %y) {
; RV32I-LABEL: select_cc_example_slti_c1:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    li a2, 12
; RV32I-NEXT:    bge a2, a1, .LBB20_2
; RV32I-NEXT:  # %bb.1: # %entry
; RV32I-NEXT:    li a0, 11
; RV32I-NEXT:  .LBB20_2: # %entry
; RV32I-NEXT:    ret
;
; RV32IXQCICLI-LABEL: select_cc_example_slti_c1:
; RV32IXQCICLI:       # %bb.0: # %entry
; RV32IXQCICLI-NEXT:    qc.ligei a0, a1, 13, 11
; RV32IXQCICLI-NEXT:    ret
entry:
  %cmp = icmp slt i32 12, %b
  %sel = select i1 %cmp, i32 11, i32 %a
  ret i32 %sel
}

define i32 @select_cc_example_sgei_c1(i32 %a, i32 %b, i32 %x, i32 %y) {
; RV32I-LABEL: select_cc_example_sgei_c1:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    li a2, 13
; RV32I-NEXT:    bge a1, a2, .LBB21_2
; RV32I-NEXT:  # %bb.1: # %entry
; RV32I-NEXT:    li a0, 11
; RV32I-NEXT:  .LBB21_2: # %entry
; RV32I-NEXT:    ret
;
; RV32IXQCICLI-LABEL: select_cc_example_sgei_c1:
; RV32IXQCICLI:       # %bb.0: # %entry
; RV32IXQCICLI-NEXT:    qc.lilti a0, a1, 13, 11
; RV32IXQCICLI-NEXT:    ret
entry:
  %cmp = icmp sge i32 12, %b
  %sel = select i1 %cmp, i32 11, i32 %a
  ret i32 %sel
}

define i32 @select_cc_example_ulti_c1(i32 %a, i32 %b, i32 %x, i32 %y) {
; RV32I-LABEL: select_cc_example_ulti_c1:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    li a2, 12
; RV32I-NEXT:    bgeu a2, a1, .LBB22_2
; RV32I-NEXT:  # %bb.1: # %entry
; RV32I-NEXT:    li a0, 11
; RV32I-NEXT:  .LBB22_2: # %entry
; RV32I-NEXT:    ret
;
; RV32IXQCICLI-LABEL: select_cc_example_ulti_c1:
; RV32IXQCICLI:       # %bb.0: # %entry
; RV32IXQCICLI-NEXT:    qc.ligeui a0, a1, 13, 11
; RV32IXQCICLI-NEXT:    ret
entry:
  %cmp = icmp ult i32 12, %b
  %sel = select i1 %cmp, i32 11, i32 %a
  ret i32 %sel
}

define i32 @select_cc_example_ugei_c1(i32 %a, i32 %b, i32 %x, i32 %y) {
; RV32I-LABEL: select_cc_example_ugei_c1:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    li a2, 13
; RV32I-NEXT:    bgeu a1, a2, .LBB23_2
; RV32I-NEXT:  # %bb.1: # %entry
; RV32I-NEXT:    li a0, 11
; RV32I-NEXT:  .LBB23_2: # %entry
; RV32I-NEXT:    ret
;
; RV32IXQCICLI-LABEL: select_cc_example_ugei_c1:
; RV32IXQCICLI:       # %bb.0: # %entry
; RV32IXQCICLI-NEXT:    qc.liltui a0, a1, 13, 11
; RV32IXQCICLI-NEXT:    ret
entry:
  %cmp = icmp uge i32 12, %b
  %sel = select i1 %cmp, i32 11, i32 %a
  ret i32 %sel
}

define i32 @select_cc_example_eqi_c2(i32 %a, i32 %b, i32 %x, i32 %y) {
; RV32I-LABEL: select_cc_example_eqi_c2:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    li a2, 12
; RV32I-NEXT:    beq a1, a2, .LBB24_2
; RV32I-NEXT:  # %bb.1: # %entry
; RV32I-NEXT:    li a0, 11
; RV32I-NEXT:  .LBB24_2: # %entry
; RV32I-NEXT:    ret
;
; RV32IXQCICLI-LABEL: select_cc_example_eqi_c2:
; RV32IXQCICLI:       # %bb.0: # %entry
; RV32IXQCICLI-NEXT:    qc.linei a0, a1, 12, 11
; RV32IXQCICLI-NEXT:    ret
entry:
  %cmp = icmp eq i32 12, %b
  %sel = select i1 %cmp, i32 %a, i32 11
  ret i32 %sel
}

define i32 @select_cc_example_nei_c2(i32 %a, i32 %b, i32 %x, i32 %y) {
; RV32I-LABEL: select_cc_example_nei_c2:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    li a2, 12
; RV32I-NEXT:    bne a1, a2, .LBB25_2
; RV32I-NEXT:  # %bb.1: # %entry
; RV32I-NEXT:    li a0, 11
; RV32I-NEXT:  .LBB25_2: # %entry
; RV32I-NEXT:    ret
;
; RV32IXQCICLI-LABEL: select_cc_example_nei_c2:
; RV32IXQCICLI:       # %bb.0: # %entry
; RV32IXQCICLI-NEXT:    qc.lieqi a0, a1, 12, 11
; RV32IXQCICLI-NEXT:    ret
entry:
  %cmp = icmp ne i32 12, %b
  %sel = select i1 %cmp, i32 %a, i32 11
  ret i32 %sel
}

define i32 @select_cc_example_slti_c2(i32 %a, i32 %b, i32 %x, i32 %y) {
; RV32I-LABEL: select_cc_example_slti_c2:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    li a2, 12
; RV32I-NEXT:    blt a2, a1, .LBB26_2
; RV32I-NEXT:  # %bb.1: # %entry
; RV32I-NEXT:    li a0, 11
; RV32I-NEXT:  .LBB26_2: # %entry
; RV32I-NEXT:    ret
;
; RV32IXQCICLI-LABEL: select_cc_example_slti_c2:
; RV32IXQCICLI:       # %bb.0: # %entry
; RV32IXQCICLI-NEXT:    qc.lilti a0, a1, 13, 11
; RV32IXQCICLI-NEXT:    ret
entry:
  %cmp = icmp slt i32 12, %b
  %sel = select i1 %cmp, i32 %a, i32 11
  ret i32 %sel
}

define i32 @select_cc_example_sgei_c2(i32 %a, i32 %b, i32 %x, i32 %y) {
; RV32I-LABEL: select_cc_example_sgei_c2:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    li a2, 13
; RV32I-NEXT:    blt a1, a2, .LBB27_2
; RV32I-NEXT:  # %bb.1: # %entry
; RV32I-NEXT:    li a0, 11
; RV32I-NEXT:  .LBB27_2: # %entry
; RV32I-NEXT:    ret
;
; RV32IXQCICLI-LABEL: select_cc_example_sgei_c2:
; RV32IXQCICLI:       # %bb.0: # %entry
; RV32IXQCICLI-NEXT:    qc.ligei a0, a1, 13, 11
; RV32IXQCICLI-NEXT:    ret
entry:
  %cmp = icmp sge i32 12, %b
  %sel = select i1 %cmp, i32 %a, i32 11
  ret i32 %sel
}

define i32 @select_cc_example_ulti_c2(i32 %a, i32 %b, i32 %x, i32 %y) {
; RV32I-LABEL: select_cc_example_ulti_c2:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    li a2, 12
; RV32I-NEXT:    bltu a2, a1, .LBB28_2
; RV32I-NEXT:  # %bb.1: # %entry
; RV32I-NEXT:    li a0, 11
; RV32I-NEXT:  .LBB28_2: # %entry
; RV32I-NEXT:    ret
;
; RV32IXQCICLI-LABEL: select_cc_example_ulti_c2:
; RV32IXQCICLI:       # %bb.0: # %entry
; RV32IXQCICLI-NEXT:    qc.liltui a0, a1, 13, 11
; RV32IXQCICLI-NEXT:    ret
entry:
  %cmp = icmp ult i32 12, %b
  %sel = select i1 %cmp, i32 %a, i32 11
  ret i32 %sel
}

define i32 @select_cc_example_ugei_c2(i32 %a, i32 %b, i32 %x, i32 %y) {
; RV32I-LABEL: select_cc_example_ugei_c2:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    li a2, 13
; RV32I-NEXT:    bltu a1, a2, .LBB29_2
; RV32I-NEXT:  # %bb.1: # %entry
; RV32I-NEXT:    li a0, 11
; RV32I-NEXT:  .LBB29_2: # %entry
; RV32I-NEXT:    ret
;
; RV32IXQCICLI-LABEL: select_cc_example_ugei_c2:
; RV32IXQCICLI:       # %bb.0: # %entry
; RV32IXQCICLI-NEXT:    qc.ligeui a0, a1, 13, 11
; RV32IXQCICLI-NEXT:    ret
entry:
  %cmp = icmp uge i32 12, %b
  %sel = select i1 %cmp, i32 %a, i32 11
  ret i32 %sel
}

define i32 @select_cc_example_eqi_c3(i32 %a, i32 %b, i32 %x, i32 %y) {
; RV32I-LABEL: select_cc_example_eqi_c3:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    li a2, 12
; RV32I-NEXT:    beq a1, a2, .LBB30_2
; RV32I-NEXT:  # %bb.1: # %entry
; RV32I-NEXT:    li a0, 11
; RV32I-NEXT:  .LBB30_2: # %entry
; RV32I-NEXT:    ret
;
; RV32IXQCICLI-LABEL: select_cc_example_eqi_c3:
; RV32IXQCICLI:       # %bb.0: # %entry
; RV32IXQCICLI-NEXT:    qc.linei a0, a1, 12, 11
; RV32IXQCICLI-NEXT:    ret
entry:
  %cmp = icmp eq i32 %b, 12
  %sel = select i1 %cmp, i32 %a, i32 11
  ret i32 %sel
}

define i32 @select_cc_example_nei_c3(i32 %a, i32 %b, i32 %x, i32 %y) {
; RV32I-LABEL: select_cc_example_nei_c3:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    li a2, 12
; RV32I-NEXT:    bne a1, a2, .LBB31_2
; RV32I-NEXT:  # %bb.1: # %entry
; RV32I-NEXT:    li a0, 11
; RV32I-NEXT:  .LBB31_2: # %entry
; RV32I-NEXT:    ret
;
; RV32IXQCICLI-LABEL: select_cc_example_nei_c3:
; RV32IXQCICLI:       # %bb.0: # %entry
; RV32IXQCICLI-NEXT:    qc.lieqi a0, a1, 12, 11
; RV32IXQCICLI-NEXT:    ret
entry:
  %cmp = icmp ne i32 %b, 12
  %sel = select i1 %cmp, i32 %a, i32 11
  ret i32 %sel
}

define i32 @select_cc_example_slti_c3(i32 %a, i32 %b, i32 %x, i32 %y) {
; RV32I-LABEL: select_cc_example_slti_c3:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    li a2, 12
; RV32I-NEXT:    blt a1, a2, .LBB32_2
; RV32I-NEXT:  # %bb.1: # %entry
; RV32I-NEXT:    li a0, 11
; RV32I-NEXT:  .LBB32_2: # %entry
; RV32I-NEXT:    ret
;
; RV32IXQCICLI-LABEL: select_cc_example_slti_c3:
; RV32IXQCICLI:       # %bb.0: # %entry
; RV32IXQCICLI-NEXT:    qc.ligei a0, a1, 12, 11
; RV32IXQCICLI-NEXT:    ret
entry:
  %cmp = icmp slt i32 %b, 12
  %sel = select i1 %cmp, i32 %a, i32 11
  ret i32 %sel
}

define i32 @select_cc_example_sgei_c3(i32 %a, i32 %b, i32 %x, i32 %y) {
; RV32I-LABEL: select_cc_example_sgei_c3:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    li a2, 11
; RV32I-NEXT:    blt a2, a1, .LBB33_2
; RV32I-NEXT:  # %bb.1: # %entry
; RV32I-NEXT:    li a0, 11
; RV32I-NEXT:  .LBB33_2: # %entry
; RV32I-NEXT:    ret
;
; RV32IXQCICLI-LABEL: select_cc_example_sgei_c3:
; RV32IXQCICLI:       # %bb.0: # %entry
; RV32IXQCICLI-NEXT:    qc.lilti a0, a1, 12, 11
; RV32IXQCICLI-NEXT:    ret
entry:
  %cmp = icmp sge i32 %b, 12
  %sel = select i1 %cmp, i32 %a, i32 11
  ret i32 %sel
}

define i32 @select_cc_example_ulti_c3(i32 %a, i32 %b, i32 %x, i32 %y) {
; RV32I-LABEL: select_cc_example_ulti_c3:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    li a2, 12
; RV32I-NEXT:    bltu a1, a2, .LBB34_2
; RV32I-NEXT:  # %bb.1: # %entry
; RV32I-NEXT:    li a0, 11
; RV32I-NEXT:  .LBB34_2: # %entry
; RV32I-NEXT:    ret
;
; RV32IXQCICLI-LABEL: select_cc_example_ulti_c3:
; RV32IXQCICLI:       # %bb.0: # %entry
; RV32IXQCICLI-NEXT:    qc.ligeui a0, a1, 12, 11
; RV32IXQCICLI-NEXT:    ret
entry:
  %cmp = icmp ult i32 %b, 12
  %sel = select i1 %cmp, i32 %a, i32 11
  ret i32 %sel
}

define i32 @select_cc_example_ugei_c3(i32 %a, i32 %b, i32 %x, i32 %y) {
; RV32I-LABEL: select_cc_example_ugei_c3:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    li a2, 11
; RV32I-NEXT:    bltu a2, a1, .LBB35_2
; RV32I-NEXT:  # %bb.1: # %entry
; RV32I-NEXT:    li a0, 11
; RV32I-NEXT:  .LBB35_2: # %entry
; RV32I-NEXT:    ret
;
; RV32IXQCICLI-LABEL: select_cc_example_ugei_c3:
; RV32IXQCICLI:       # %bb.0: # %entry
; RV32IXQCICLI-NEXT:    qc.liltui a0, a1, 12, 11
; RV32IXQCICLI-NEXT:    ret
entry:
  %cmp = icmp uge i32 %b, 12
  %sel = select i1 %cmp, i32 %a, i32 11
  ret i32 %sel
}

