; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=riscv32 -mattr=+d,+zvfh,+zfbfmin,+zvfbfmin,+v \
; RUN:     -target-abi=ilp32d -verify-machineinstrs < %s | FileCheck %s \
; RUN:     --check-prefixes=CHECK,ZVFH
; RUN: llc -mtriple=riscv64 -mattr=+d,+zvfh,+zfbfmin,+zvfbfmin,+v \
; RUN:     -target-abi=lp64d -verify-machineinstrs < %s | FileCheck %s \
; RUN:     --check-prefixes=CHECK,ZVFH
; RUN: llc -mtriple=riscv32 -mattr=+d,+zfhmin,+zvfhmin,+zfbfmin,+zvfbfmin,+v \
; RUN:     -target-abi=ilp32d -verify-machineinstrs < %s | FileCheck %s \
; RUN:     --check-prefixes=CHECK,ZVFHMIN
; RUN: llc -mtriple=riscv64 -mattr=+d,+zfhmin,+zvfhmin,+zfbfmin,+zvfbfmin,+v \
; RUN:     -target-abi=lp64d -verify-machineinstrs < %s | FileCheck %s \
; RUN:     --check-prefixes=CHECK,ZVFHMIN

declare <vscale x 1 x bfloat> @llvm.vp.roundeven.nxv1bf16(<vscale x 1 x bfloat>, <vscale x 1 x i1>, i32)

define <vscale x 1 x bfloat> @vp_roundeven_nxv1bf16(<vscale x 1 x bfloat> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_roundeven_nxv1bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-NEXT:    vmv1r.v v9, v0
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v8, v0.t
; CHECK-NEXT:    lui a0, 307200
; CHECK-NEXT:    vmv1r.v v8, v0
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfabs.v v11, v10, v0.t
; CHECK-NEXT:    fmv.w.x fa5, a0
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, mu
; CHECK-NEXT:    vmflt.vf v8, v11, fa5, v0.t
; CHECK-NEXT:    fsrmi a0, 0
; CHECK-NEXT:    vmv1r.v v0, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfcvt.x.f.v v11, v10, v0.t
; CHECK-NEXT:    fsrm a0
; CHECK-NEXT:    vfcvt.f.x.v v11, v11, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, mu
; CHECK-NEXT:    vfsgnj.vv v10, v11, v10, v0.t
; CHECK-NEXT:    vmv1r.v v0, v9
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v10, v0.t
; CHECK-NEXT:    ret
  %v = call <vscale x 1 x bfloat> @llvm.vp.roundeven.nxv1bf16(<vscale x 1 x bfloat> %va, <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x bfloat> %v
}

define <vscale x 1 x bfloat> @vp_roundeven_nxv1bf16_unmasked(<vscale x 1 x bfloat> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_roundeven_nxv1bf16_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v9, v8
; CHECK-NEXT:    lui a0, 307200
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfabs.v v8, v9
; CHECK-NEXT:    fmv.w.x fa5, a0
; CHECK-NEXT:    vmflt.vf v0, v8, fa5
; CHECK-NEXT:    fsrmi a0, 0
; CHECK-NEXT:    vfcvt.x.f.v v8, v9, v0.t
; CHECK-NEXT:    fsrm a0
; CHECK-NEXT:    vfcvt.f.x.v v8, v8, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, mu
; CHECK-NEXT:    vfsgnj.vv v9, v8, v9, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v9
; CHECK-NEXT:    ret
  %v = call <vscale x 1 x bfloat> @llvm.vp.roundeven.nxv1bf16(<vscale x 1 x bfloat> %va, <vscale x 1 x i1> splat (i1 true), i32 %evl)
  ret <vscale x 1 x bfloat> %v
}

declare <vscale x 2 x bfloat> @llvm.vp.roundeven.nxv2bf16(<vscale x 2 x bfloat>, <vscale x 2 x i1>, i32)

define <vscale x 2 x bfloat> @vp_roundeven_nxv2bf16(<vscale x 2 x bfloat> %va, <vscale x 2 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_roundeven_nxv2bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; CHECK-NEXT:    vmv1r.v v9, v0
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v8, v0.t
; CHECK-NEXT:    lui a0, 307200
; CHECK-NEXT:    vmv1r.v v8, v0
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfabs.v v11, v10, v0.t
; CHECK-NEXT:    fmv.w.x fa5, a0
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, ta, mu
; CHECK-NEXT:    vmflt.vf v8, v11, fa5, v0.t
; CHECK-NEXT:    fsrmi a0, 0
; CHECK-NEXT:    vmv.v.v v0, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfcvt.x.f.v v11, v10, v0.t
; CHECK-NEXT:    fsrm a0
; CHECK-NEXT:    vfcvt.f.x.v v11, v11, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, ta, mu
; CHECK-NEXT:    vfsgnj.vv v10, v11, v10, v0.t
; CHECK-NEXT:    vmv1r.v v0, v9
; CHECK-NEXT:    vsetvli zero, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v10, v0.t
; CHECK-NEXT:    ret
  %v = call <vscale x 2 x bfloat> @llvm.vp.roundeven.nxv2bf16(<vscale x 2 x bfloat> %va, <vscale x 2 x i1> %m, i32 %evl)
  ret <vscale x 2 x bfloat> %v
}

define <vscale x 2 x bfloat> @vp_roundeven_nxv2bf16_unmasked(<vscale x 2 x bfloat> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_roundeven_nxv2bf16_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v9, v8
; CHECK-NEXT:    lui a0, 307200
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfabs.v v8, v9
; CHECK-NEXT:    fmv.w.x fa5, a0
; CHECK-NEXT:    vmflt.vf v0, v8, fa5
; CHECK-NEXT:    fsrmi a0, 0
; CHECK-NEXT:    vfcvt.x.f.v v8, v9, v0.t
; CHECK-NEXT:    fsrm a0
; CHECK-NEXT:    vfcvt.f.x.v v8, v8, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, ta, mu
; CHECK-NEXT:    vfsgnj.vv v9, v8, v9, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v9
; CHECK-NEXT:    ret
  %v = call <vscale x 2 x bfloat> @llvm.vp.roundeven.nxv2bf16(<vscale x 2 x bfloat> %va, <vscale x 2 x i1> splat (i1 true), i32 %evl)
  ret <vscale x 2 x bfloat> %v
}

declare <vscale x 4 x bfloat> @llvm.vp.roundeven.nxv4bf16(<vscale x 4 x bfloat>, <vscale x 4 x i1>, i32)

define <vscale x 4 x bfloat> @vp_roundeven_nxv4bf16(<vscale x 4 x bfloat> %va, <vscale x 4 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_roundeven_nxv4bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    vmv1r.v v9, v0
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v8, v0.t
; CHECK-NEXT:    lui a0, 307200
; CHECK-NEXT:    vmv1r.v v8, v0
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfabs.v v12, v10, v0.t
; CHECK-NEXT:    fmv.w.x fa5, a0
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, mu
; CHECK-NEXT:    vmflt.vf v8, v12, fa5, v0.t
; CHECK-NEXT:    fsrmi a0, 0
; CHECK-NEXT:    vmv1r.v v0, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfcvt.x.f.v v12, v10, v0.t
; CHECK-NEXT:    fsrm a0
; CHECK-NEXT:    vfcvt.f.x.v v12, v12, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, mu
; CHECK-NEXT:    vfsgnj.vv v10, v12, v10, v0.t
; CHECK-NEXT:    vmv1r.v v0, v9
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v10, v0.t
; CHECK-NEXT:    ret
  %v = call <vscale x 4 x bfloat> @llvm.vp.roundeven.nxv4bf16(<vscale x 4 x bfloat> %va, <vscale x 4 x i1> %m, i32 %evl)
  ret <vscale x 4 x bfloat> %v
}

define <vscale x 4 x bfloat> @vp_roundeven_nxv4bf16_unmasked(<vscale x 4 x bfloat> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_roundeven_nxv4bf16_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v8
; CHECK-NEXT:    lui a0, 307200
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfabs.v v8, v10
; CHECK-NEXT:    fmv.w.x fa5, a0
; CHECK-NEXT:    vmflt.vf v0, v8, fa5
; CHECK-NEXT:    fsrmi a0, 0
; CHECK-NEXT:    vfcvt.x.f.v v8, v10, v0.t
; CHECK-NEXT:    fsrm a0
; CHECK-NEXT:    vfcvt.f.x.v v8, v8, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, mu
; CHECK-NEXT:    vfsgnj.vv v10, v8, v10, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v10
; CHECK-NEXT:    ret
  %v = call <vscale x 4 x bfloat> @llvm.vp.roundeven.nxv4bf16(<vscale x 4 x bfloat> %va, <vscale x 4 x i1> splat (i1 true), i32 %evl)
  ret <vscale x 4 x bfloat> %v
}

declare <vscale x 8 x bfloat> @llvm.vp.roundeven.nxv8bf16(<vscale x 8 x bfloat>, <vscale x 8 x i1>, i32)

define <vscale x 8 x bfloat> @vp_roundeven_nxv8bf16(<vscale x 8 x bfloat> %va, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_roundeven_nxv8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; CHECK-NEXT:    vmv1r.v v10, v0
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v8, v0.t
; CHECK-NEXT:    lui a0, 307200
; CHECK-NEXT:    vmv1r.v v8, v0
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfabs.v v16, v12, v0.t
; CHECK-NEXT:    fmv.w.x fa5, a0
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, mu
; CHECK-NEXT:    vmflt.vf v8, v16, fa5, v0.t
; CHECK-NEXT:    fsrmi a0, 0
; CHECK-NEXT:    vmv1r.v v0, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfcvt.x.f.v v16, v12, v0.t
; CHECK-NEXT:    fsrm a0
; CHECK-NEXT:    vfcvt.f.x.v v16, v16, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, mu
; CHECK-NEXT:    vfsgnj.vv v12, v16, v12, v0.t
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v12, v0.t
; CHECK-NEXT:    ret
  %v = call <vscale x 8 x bfloat> @llvm.vp.roundeven.nxv8bf16(<vscale x 8 x bfloat> %va, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x bfloat> %v
}

define <vscale x 8 x bfloat> @vp_roundeven_nxv8bf16_unmasked(<vscale x 8 x bfloat> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_roundeven_nxv8bf16_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v8
; CHECK-NEXT:    lui a0, 307200
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfabs.v v8, v12
; CHECK-NEXT:    fmv.w.x fa5, a0
; CHECK-NEXT:    vmflt.vf v0, v8, fa5
; CHECK-NEXT:    fsrmi a0, 0
; CHECK-NEXT:    vfcvt.x.f.v v8, v12, v0.t
; CHECK-NEXT:    fsrm a0
; CHECK-NEXT:    vfcvt.f.x.v v8, v8, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, mu
; CHECK-NEXT:    vfsgnj.vv v12, v8, v12, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v12
; CHECK-NEXT:    ret
  %v = call <vscale x 8 x bfloat> @llvm.vp.roundeven.nxv8bf16(<vscale x 8 x bfloat> %va, <vscale x 8 x i1> splat (i1 true), i32 %evl)
  ret <vscale x 8 x bfloat> %v
}

declare <vscale x 16 x bfloat> @llvm.vp.roundeven.nxv16bf16(<vscale x 16 x bfloat>, <vscale x 16 x i1>, i32)

define <vscale x 16 x bfloat> @vp_roundeven_nxv16bf16(<vscale x 16 x bfloat> %va, <vscale x 16 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_roundeven_nxv16bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    vmv1r.v v12, v0
; CHECK-NEXT:    vfwcvtbf16.f.f.v v16, v8, v0.t
; CHECK-NEXT:    lui a0, 307200
; CHECK-NEXT:    vmv1r.v v8, v0
; CHECK-NEXT:    vsetvli zero, zero, e32, m8, ta, ma
; CHECK-NEXT:    vfabs.v v24, v16, v0.t
; CHECK-NEXT:    fmv.w.x fa5, a0
; CHECK-NEXT:    vsetvli zero, zero, e32, m8, ta, mu
; CHECK-NEXT:    vmflt.vf v8, v24, fa5, v0.t
; CHECK-NEXT:    fsrmi a0, 0
; CHECK-NEXT:    vmv1r.v v0, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m8, ta, ma
; CHECK-NEXT:    vfcvt.x.f.v v24, v16, v0.t
; CHECK-NEXT:    fsrm a0
; CHECK-NEXT:    vfcvt.f.x.v v24, v24, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, m8, ta, mu
; CHECK-NEXT:    vfsgnj.vv v16, v24, v16, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vsetvli zero, zero, e16, m4, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v16, v0.t
; CHECK-NEXT:    ret
  %v = call <vscale x 16 x bfloat> @llvm.vp.roundeven.nxv16bf16(<vscale x 16 x bfloat> %va, <vscale x 16 x i1> %m, i32 %evl)
  ret <vscale x 16 x bfloat> %v
}

define <vscale x 16 x bfloat> @vp_roundeven_nxv16bf16_unmasked(<vscale x 16 x bfloat> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_roundeven_nxv16bf16_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v16, v8
; CHECK-NEXT:    lui a0, 307200
; CHECK-NEXT:    vsetvli zero, zero, e32, m8, ta, ma
; CHECK-NEXT:    vfabs.v v8, v16
; CHECK-NEXT:    fmv.w.x fa5, a0
; CHECK-NEXT:    vmflt.vf v0, v8, fa5
; CHECK-NEXT:    fsrmi a0, 0
; CHECK-NEXT:    vfcvt.x.f.v v8, v16, v0.t
; CHECK-NEXT:    fsrm a0
; CHECK-NEXT:    vfcvt.f.x.v v8, v8, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, m8, ta, mu
; CHECK-NEXT:    vfsgnj.vv v16, v8, v16, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e16, m4, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v16
; CHECK-NEXT:    ret
  %v = call <vscale x 16 x bfloat> @llvm.vp.roundeven.nxv16bf16(<vscale x 16 x bfloat> %va, <vscale x 16 x i1> splat (i1 true), i32 %evl)
  ret <vscale x 16 x bfloat> %v
}

declare <vscale x 32 x bfloat> @llvm.vp.roundeven.nxv32bf16(<vscale x 32 x bfloat>, <vscale x 32 x i1>, i32)

define <vscale x 32 x bfloat> @vp_roundeven_nxv32bf16(<vscale x 32 x bfloat> %va, <vscale x 32 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_roundeven_nxv32bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, mf2, ta, ma
; CHECK-NEXT:    vmv1r.v v7, v0
; CHECK-NEXT:    csrr a2, vlenb
; CHECK-NEXT:    lui a3, 307200
; CHECK-NEXT:    slli a1, a2, 1
; CHECK-NEXT:    srli a2, a2, 2
; CHECK-NEXT:    fmv.w.x fa5, a3
; CHECK-NEXT:    sub a3, a0, a1
; CHECK-NEXT:    vslidedown.vx v6, v0, a2
; CHECK-NEXT:    sltu a2, a0, a3
; CHECK-NEXT:    vmv1r.v v5, v6
; CHECK-NEXT:    addi a2, a2, -1
; CHECK-NEXT:    and a2, a2, a3
; CHECK-NEXT:    vmv1r.v v0, v6
; CHECK-NEXT:    vsetvli zero, a2, e16, m4, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v24, v12, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, m8, ta, ma
; CHECK-NEXT:    vfabs.v v16, v24, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, m8, ta, mu
; CHECK-NEXT:    vmflt.vf v5, v16, fa5, v0.t
; CHECK-NEXT:    fsrmi a2, 0
; CHECK-NEXT:    vmv1r.v v0, v5
; CHECK-NEXT:    vsetvli zero, zero, e32, m8, ta, ma
; CHECK-NEXT:    vfcvt.x.f.v v16, v24, v0.t
; CHECK-NEXT:    fsrm a2
; CHECK-NEXT:    vfcvt.f.x.v v16, v16, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, m8, ta, mu
; CHECK-NEXT:    vfsgnj.vv v24, v16, v24, v0.t
; CHECK-NEXT:    vmv1r.v v0, v6
; CHECK-NEXT:    vsetvli zero, zero, e16, m4, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v12, v24, v0.t
; CHECK-NEXT:    bltu a0, a1, .LBB10_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    mv a0, a1
; CHECK-NEXT:  .LBB10_2:
; CHECK-NEXT:    vmv1r.v v0, v7
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v24, v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v7
; CHECK-NEXT:    vsetvli zero, zero, e32, m8, ta, ma
; CHECK-NEXT:    vfabs.v v16, v24, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, m8, ta, mu
; CHECK-NEXT:    vmflt.vf v8, v16, fa5, v0.t
; CHECK-NEXT:    fsrmi a0, 0
; CHECK-NEXT:    vmv1r.v v0, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m8, ta, ma
; CHECK-NEXT:    vfcvt.x.f.v v16, v24, v0.t
; CHECK-NEXT:    fsrm a0
; CHECK-NEXT:    vfcvt.f.x.v v16, v16, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, m8, ta, mu
; CHECK-NEXT:    vfsgnj.vv v24, v16, v24, v0.t
; CHECK-NEXT:    vmv1r.v v0, v7
; CHECK-NEXT:    vsetvli zero, zero, e16, m4, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v24, v0.t
; CHECK-NEXT:    ret
  %v = call <vscale x 32 x bfloat> @llvm.vp.roundeven.nxv32bf16(<vscale x 32 x bfloat> %va, <vscale x 32 x i1> %m, i32 %evl)
  ret <vscale x 32 x bfloat> %v
}

define <vscale x 32 x bfloat> @vp_roundeven_nxv32bf16_unmasked(<vscale x 32 x bfloat> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_roundeven_nxv32bf16_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    csrr a2, vlenb
; CHECK-NEXT:    vsetvli a1, zero, e8, m4, ta, ma
; CHECK-NEXT:    vmset.m v16
; CHECK-NEXT:    lui a3, 307200
; CHECK-NEXT:    slli a1, a2, 1
; CHECK-NEXT:    srli a2, a2, 2
; CHECK-NEXT:    fmv.w.x fa5, a3
; CHECK-NEXT:    sub a3, a0, a1
; CHECK-NEXT:    vsetvli a4, zero, e8, mf2, ta, ma
; CHECK-NEXT:    vslidedown.vx v7, v16, a2
; CHECK-NEXT:    sltu a2, a0, a3
; CHECK-NEXT:    vmv1r.v v6, v7
; CHECK-NEXT:    addi a2, a2, -1
; CHECK-NEXT:    and a2, a2, a3
; CHECK-NEXT:    vmv1r.v v0, v7
; CHECK-NEXT:    vsetvli zero, a2, e16, m4, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v24, v12, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, m8, ta, ma
; CHECK-NEXT:    vfabs.v v16, v24, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, m8, ta, mu
; CHECK-NEXT:    vmflt.vf v6, v16, fa5, v0.t
; CHECK-NEXT:    fsrmi a2, 0
; CHECK-NEXT:    vmv1r.v v0, v6
; CHECK-NEXT:    vsetvli zero, zero, e32, m8, ta, ma
; CHECK-NEXT:    vfcvt.x.f.v v16, v24, v0.t
; CHECK-NEXT:    fsrm a2
; CHECK-NEXT:    vfcvt.f.x.v v16, v16, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, m8, ta, mu
; CHECK-NEXT:    vfsgnj.vv v24, v16, v24, v0.t
; CHECK-NEXT:    vmv1r.v v0, v7
; CHECK-NEXT:    vsetvli zero, zero, e16, m4, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v12, v24, v0.t
; CHECK-NEXT:    bltu a0, a1, .LBB11_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    mv a0, a1
; CHECK-NEXT:  .LBB11_2:
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v16, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m8, ta, ma
; CHECK-NEXT:    vfabs.v v24, v16
; CHECK-NEXT:    vmflt.vf v0, v24, fa5
; CHECK-NEXT:    fsrmi a0, 0
; CHECK-NEXT:    vfcvt.x.f.v v24, v16, v0.t
; CHECK-NEXT:    fsrm a0
; CHECK-NEXT:    vfcvt.f.x.v v24, v24, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, m8, ta, mu
; CHECK-NEXT:    vfsgnj.vv v16, v24, v16, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e16, m4, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v16
; CHECK-NEXT:    ret
  %v = call <vscale x 32 x bfloat> @llvm.vp.roundeven.nxv32bf16(<vscale x 32 x bfloat> %va, <vscale x 32 x i1> splat (i1 true), i32 %evl)
  ret <vscale x 32 x bfloat> %v
}
declare <vscale x 1 x half> @llvm.vp.roundeven.nxv1f16(<vscale x 1 x half>, <vscale x 1 x i1>, i32)

define <vscale x 1 x half> @vp_roundeven_nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: vp_roundeven_nxv1f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    lui a1, %hi(.LCPI12_0)
; ZVFH-NEXT:    flh fa5, %lo(.LCPI12_0)(a1)
; ZVFH-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; ZVFH-NEXT:    vfabs.v v9, v8, v0.t
; ZVFH-NEXT:    vsetvli zero, zero, e16, mf4, ta, mu
; ZVFH-NEXT:    vmflt.vf v0, v9, fa5, v0.t
; ZVFH-NEXT:    fsrmi a0, 0
; ZVFH-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; ZVFH-NEXT:    vfcvt.x.f.v v9, v8, v0.t
; ZVFH-NEXT:    fsrm a0
; ZVFH-NEXT:    vfcvt.f.x.v v9, v9, v0.t
; ZVFH-NEXT:    vsetvli zero, zero, e16, mf4, ta, mu
; ZVFH-NEXT:    vfsgnj.vv v8, v9, v8, v0.t
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vp_roundeven_nxv1f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vmv1r.v v9, v0
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8, v0.t
; ZVFHMIN-NEXT:    lui a0, 307200
; ZVFHMIN-NEXT:    vmv1r.v v8, v0
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vfabs.v v11, v10, v0.t
; ZVFHMIN-NEXT:    fmv.w.x fa5, a0
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, mf2, ta, mu
; ZVFHMIN-NEXT:    vmflt.vf v8, v11, fa5, v0.t
; ZVFHMIN-NEXT:    fsrmi a0, 0
; ZVFHMIN-NEXT:    vmv1r.v v0, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vfcvt.x.f.v v11, v10, v0.t
; ZVFHMIN-NEXT:    fsrm a0
; ZVFHMIN-NEXT:    vfcvt.f.x.v v11, v11, v0.t
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, mf2, ta, mu
; ZVFHMIN-NEXT:    vfsgnj.vv v10, v11, v10, v0.t
; ZVFHMIN-NEXT:    vmv1r.v v0, v9
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v10, v0.t
; ZVFHMIN-NEXT:    ret
  %v = call <vscale x 1 x half> @llvm.vp.roundeven.nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x half> %v
}

define <vscale x 1 x half> @vp_roundeven_nxv1f16_unmasked(<vscale x 1 x half> %va, i32 zeroext %evl) {
; ZVFH-LABEL: vp_roundeven_nxv1f16_unmasked:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    lui a1, %hi(.LCPI13_0)
; ZVFH-NEXT:    flh fa5, %lo(.LCPI13_0)(a1)
; ZVFH-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; ZVFH-NEXT:    vfabs.v v9, v8
; ZVFH-NEXT:    vmflt.vf v0, v9, fa5
; ZVFH-NEXT:    fsrmi a0, 0
; ZVFH-NEXT:    vfcvt.x.f.v v9, v8, v0.t
; ZVFH-NEXT:    fsrm a0
; ZVFH-NEXT:    vfcvt.f.x.v v9, v9, v0.t
; ZVFH-NEXT:    vsetvli zero, zero, e16, mf4, ta, mu
; ZVFH-NEXT:    vfsgnj.vv v8, v9, v8, v0.t
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vp_roundeven_nxv1f16_unmasked:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v8
; ZVFHMIN-NEXT:    lui a0, 307200
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vfabs.v v8, v9
; ZVFHMIN-NEXT:    fmv.w.x fa5, a0
; ZVFHMIN-NEXT:    vmflt.vf v0, v8, fa5
; ZVFHMIN-NEXT:    fsrmi a0, 0
; ZVFHMIN-NEXT:    vfcvt.x.f.v v8, v9, v0.t
; ZVFHMIN-NEXT:    fsrm a0
; ZVFHMIN-NEXT:    vfcvt.f.x.v v8, v8, v0.t
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, mf2, ta, mu
; ZVFHMIN-NEXT:    vfsgnj.vv v9, v8, v9, v0.t
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v9
; ZVFHMIN-NEXT:    ret
  %v = call <vscale x 1 x half> @llvm.vp.roundeven.nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x i1> splat (i1 true), i32 %evl)
  ret <vscale x 1 x half> %v
}

declare <vscale x 2 x half> @llvm.vp.roundeven.nxv2f16(<vscale x 2 x half>, <vscale x 2 x i1>, i32)

define <vscale x 2 x half> @vp_roundeven_nxv2f16(<vscale x 2 x half> %va, <vscale x 2 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: vp_roundeven_nxv2f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    lui a1, %hi(.LCPI14_0)
; ZVFH-NEXT:    flh fa5, %lo(.LCPI14_0)(a1)
; ZVFH-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; ZVFH-NEXT:    vfabs.v v9, v8, v0.t
; ZVFH-NEXT:    vsetvli zero, zero, e16, mf2, ta, mu
; ZVFH-NEXT:    vmflt.vf v0, v9, fa5, v0.t
; ZVFH-NEXT:    fsrmi a0, 0
; ZVFH-NEXT:    vsetvli zero, zero, e16, mf2, ta, ma
; ZVFH-NEXT:    vfcvt.x.f.v v9, v8, v0.t
; ZVFH-NEXT:    fsrm a0
; ZVFH-NEXT:    vfcvt.f.x.v v9, v9, v0.t
; ZVFH-NEXT:    vsetvli zero, zero, e16, mf2, ta, mu
; ZVFH-NEXT:    vfsgnj.vv v8, v9, v8, v0.t
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vp_roundeven_nxv2f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; ZVFHMIN-NEXT:    vmv1r.v v9, v0
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8, v0.t
; ZVFHMIN-NEXT:    lui a0, 307200
; ZVFHMIN-NEXT:    vmv1r.v v8, v0
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; ZVFHMIN-NEXT:    vfabs.v v11, v10, v0.t
; ZVFHMIN-NEXT:    fmv.w.x fa5, a0
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m1, ta, mu
; ZVFHMIN-NEXT:    vmflt.vf v8, v11, fa5, v0.t
; ZVFHMIN-NEXT:    fsrmi a0, 0
; ZVFHMIN-NEXT:    vmv.v.v v0, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; ZVFHMIN-NEXT:    vfcvt.x.f.v v11, v10, v0.t
; ZVFHMIN-NEXT:    fsrm a0
; ZVFHMIN-NEXT:    vfcvt.f.x.v v11, v11, v0.t
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m1, ta, mu
; ZVFHMIN-NEXT:    vfsgnj.vv v10, v11, v10, v0.t
; ZVFHMIN-NEXT:    vmv1r.v v0, v9
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, mf2, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v10, v0.t
; ZVFHMIN-NEXT:    ret
  %v = call <vscale x 2 x half> @llvm.vp.roundeven.nxv2f16(<vscale x 2 x half> %va, <vscale x 2 x i1> %m, i32 %evl)
  ret <vscale x 2 x half> %v
}

define <vscale x 2 x half> @vp_roundeven_nxv2f16_unmasked(<vscale x 2 x half> %va, i32 zeroext %evl) {
; ZVFH-LABEL: vp_roundeven_nxv2f16_unmasked:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    lui a1, %hi(.LCPI15_0)
; ZVFH-NEXT:    flh fa5, %lo(.LCPI15_0)(a1)
; ZVFH-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; ZVFH-NEXT:    vfabs.v v9, v8
; ZVFH-NEXT:    vmflt.vf v0, v9, fa5
; ZVFH-NEXT:    fsrmi a0, 0
; ZVFH-NEXT:    vfcvt.x.f.v v9, v8, v0.t
; ZVFH-NEXT:    fsrm a0
; ZVFH-NEXT:    vfcvt.f.x.v v9, v9, v0.t
; ZVFH-NEXT:    vsetvli zero, zero, e16, mf2, ta, mu
; ZVFH-NEXT:    vfsgnj.vv v8, v9, v8, v0.t
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vp_roundeven_nxv2f16_unmasked:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v8
; ZVFHMIN-NEXT:    lui a0, 307200
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; ZVFHMIN-NEXT:    vfabs.v v8, v9
; ZVFHMIN-NEXT:    fmv.w.x fa5, a0
; ZVFHMIN-NEXT:    vmflt.vf v0, v8, fa5
; ZVFHMIN-NEXT:    fsrmi a0, 0
; ZVFHMIN-NEXT:    vfcvt.x.f.v v8, v9, v0.t
; ZVFHMIN-NEXT:    fsrm a0
; ZVFHMIN-NEXT:    vfcvt.f.x.v v8, v8, v0.t
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m1, ta, mu
; ZVFHMIN-NEXT:    vfsgnj.vv v9, v8, v9, v0.t
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, mf2, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v9
; ZVFHMIN-NEXT:    ret
  %v = call <vscale x 2 x half> @llvm.vp.roundeven.nxv2f16(<vscale x 2 x half> %va, <vscale x 2 x i1> splat (i1 true), i32 %evl)
  ret <vscale x 2 x half> %v
}

declare <vscale x 4 x half> @llvm.vp.roundeven.nxv4f16(<vscale x 4 x half>, <vscale x 4 x i1>, i32)

define <vscale x 4 x half> @vp_roundeven_nxv4f16(<vscale x 4 x half> %va, <vscale x 4 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: vp_roundeven_nxv4f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    lui a1, %hi(.LCPI16_0)
; ZVFH-NEXT:    flh fa5, %lo(.LCPI16_0)(a1)
; ZVFH-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; ZVFH-NEXT:    vfabs.v v9, v8, v0.t
; ZVFH-NEXT:    vsetvli zero, zero, e16, m1, ta, mu
; ZVFH-NEXT:    vmflt.vf v0, v9, fa5, v0.t
; ZVFH-NEXT:    fsrmi a0, 0
; ZVFH-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFH-NEXT:    vfcvt.x.f.v v9, v8, v0.t
; ZVFH-NEXT:    fsrm a0
; ZVFH-NEXT:    vfcvt.f.x.v v9, v9, v0.t
; ZVFH-NEXT:    vsetvli zero, zero, e16, m1, ta, mu
; ZVFH-NEXT:    vfsgnj.vv v8, v9, v8, v0.t
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vp_roundeven_nxv4f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vmv1r.v v9, v0
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8, v0.t
; ZVFHMIN-NEXT:    lui a0, 307200
; ZVFHMIN-NEXT:    vmv1r.v v8, v0
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfabs.v v12, v10, v0.t
; ZVFHMIN-NEXT:    fmv.w.x fa5, a0
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, mu
; ZVFHMIN-NEXT:    vmflt.vf v8, v12, fa5, v0.t
; ZVFHMIN-NEXT:    fsrmi a0, 0
; ZVFHMIN-NEXT:    vmv1r.v v0, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfcvt.x.f.v v12, v10, v0.t
; ZVFHMIN-NEXT:    fsrm a0
; ZVFHMIN-NEXT:    vfcvt.f.x.v v12, v12, v0.t
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, mu
; ZVFHMIN-NEXT:    vfsgnj.vv v10, v12, v10, v0.t
; ZVFHMIN-NEXT:    vmv1r.v v0, v9
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v10, v0.t
; ZVFHMIN-NEXT:    ret
  %v = call <vscale x 4 x half> @llvm.vp.roundeven.nxv4f16(<vscale x 4 x half> %va, <vscale x 4 x i1> %m, i32 %evl)
  ret <vscale x 4 x half> %v
}

define <vscale x 4 x half> @vp_roundeven_nxv4f16_unmasked(<vscale x 4 x half> %va, i32 zeroext %evl) {
; ZVFH-LABEL: vp_roundeven_nxv4f16_unmasked:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    lui a1, %hi(.LCPI17_0)
; ZVFH-NEXT:    flh fa5, %lo(.LCPI17_0)(a1)
; ZVFH-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; ZVFH-NEXT:    vfabs.v v9, v8
; ZVFH-NEXT:    vmflt.vf v0, v9, fa5
; ZVFH-NEXT:    fsrmi a0, 0
; ZVFH-NEXT:    vfcvt.x.f.v v9, v8, v0.t
; ZVFH-NEXT:    fsrm a0
; ZVFH-NEXT:    vfcvt.f.x.v v9, v9, v0.t
; ZVFH-NEXT:    vsetvli zero, zero, e16, m1, ta, mu
; ZVFH-NEXT:    vfsgnj.vv v8, v9, v8, v0.t
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vp_roundeven_nxv4f16_unmasked:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8
; ZVFHMIN-NEXT:    lui a0, 307200
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfabs.v v8, v10
; ZVFHMIN-NEXT:    fmv.w.x fa5, a0
; ZVFHMIN-NEXT:    vmflt.vf v0, v8, fa5
; ZVFHMIN-NEXT:    fsrmi a0, 0
; ZVFHMIN-NEXT:    vfcvt.x.f.v v8, v10, v0.t
; ZVFHMIN-NEXT:    fsrm a0
; ZVFHMIN-NEXT:    vfcvt.f.x.v v8, v8, v0.t
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, mu
; ZVFHMIN-NEXT:    vfsgnj.vv v10, v8, v10, v0.t
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v10
; ZVFHMIN-NEXT:    ret
  %v = call <vscale x 4 x half> @llvm.vp.roundeven.nxv4f16(<vscale x 4 x half> %va, <vscale x 4 x i1> splat (i1 true), i32 %evl)
  ret <vscale x 4 x half> %v
}

declare <vscale x 8 x half> @llvm.vp.roundeven.nxv8f16(<vscale x 8 x half>, <vscale x 8 x i1>, i32)

define <vscale x 8 x half> @vp_roundeven_nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: vp_roundeven_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; ZVFH-NEXT:    vmv1r.v v10, v0
; ZVFH-NEXT:    lui a0, %hi(.LCPI18_0)
; ZVFH-NEXT:    flh fa5, %lo(.LCPI18_0)(a0)
; ZVFH-NEXT:    vfabs.v v12, v8, v0.t
; ZVFH-NEXT:    vsetvli zero, zero, e16, m2, ta, mu
; ZVFH-NEXT:    vmflt.vf v10, v12, fa5, v0.t
; ZVFH-NEXT:    fsrmi a0, 0
; ZVFH-NEXT:    vmv1r.v v0, v10
; ZVFH-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vfcvt.x.f.v v12, v8, v0.t
; ZVFH-NEXT:    fsrm a0
; ZVFH-NEXT:    vfcvt.f.x.v v12, v12, v0.t
; ZVFH-NEXT:    vsetvli zero, zero, e16, m2, ta, mu
; ZVFH-NEXT:    vfsgnj.vv v8, v12, v8, v0.t
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vp_roundeven_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vmv1r.v v10, v0
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8, v0.t
; ZVFHMIN-NEXT:    lui a0, 307200
; ZVFHMIN-NEXT:    vmv1r.v v8, v0
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vfabs.v v16, v12, v0.t
; ZVFHMIN-NEXT:    fmv.w.x fa5, a0
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, mu
; ZVFHMIN-NEXT:    vmflt.vf v8, v16, fa5, v0.t
; ZVFHMIN-NEXT:    fsrmi a0, 0
; ZVFHMIN-NEXT:    vmv1r.v v0, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vfcvt.x.f.v v16, v12, v0.t
; ZVFHMIN-NEXT:    fsrm a0
; ZVFHMIN-NEXT:    vfcvt.f.x.v v16, v16, v0.t
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, mu
; ZVFHMIN-NEXT:    vfsgnj.vv v12, v16, v12, v0.t
; ZVFHMIN-NEXT:    vmv1r.v v0, v10
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v12, v0.t
; ZVFHMIN-NEXT:    ret
  %v = call <vscale x 8 x half> @llvm.vp.roundeven.nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x half> %v
}

define <vscale x 8 x half> @vp_roundeven_nxv8f16_unmasked(<vscale x 8 x half> %va, i32 zeroext %evl) {
; ZVFH-LABEL: vp_roundeven_nxv8f16_unmasked:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    lui a1, %hi(.LCPI19_0)
; ZVFH-NEXT:    flh fa5, %lo(.LCPI19_0)(a1)
; ZVFH-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; ZVFH-NEXT:    vfabs.v v10, v8
; ZVFH-NEXT:    vmflt.vf v0, v10, fa5
; ZVFH-NEXT:    fsrmi a0, 0
; ZVFH-NEXT:    vfcvt.x.f.v v10, v8, v0.t
; ZVFH-NEXT:    fsrm a0
; ZVFH-NEXT:    vfcvt.f.x.v v10, v10, v0.t
; ZVFH-NEXT:    vsetvli zero, zero, e16, m2, ta, mu
; ZVFH-NEXT:    vfsgnj.vv v8, v10, v8, v0.t
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vp_roundeven_nxv8f16_unmasked:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    lui a0, 307200
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vfabs.v v8, v12
; ZVFHMIN-NEXT:    fmv.w.x fa5, a0
; ZVFHMIN-NEXT:    vmflt.vf v0, v8, fa5
; ZVFHMIN-NEXT:    fsrmi a0, 0
; ZVFHMIN-NEXT:    vfcvt.x.f.v v8, v12, v0.t
; ZVFHMIN-NEXT:    fsrm a0
; ZVFHMIN-NEXT:    vfcvt.f.x.v v8, v8, v0.t
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, mu
; ZVFHMIN-NEXT:    vfsgnj.vv v12, v8, v12, v0.t
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v12
; ZVFHMIN-NEXT:    ret
  %v = call <vscale x 8 x half> @llvm.vp.roundeven.nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x i1> splat (i1 true), i32 %evl)
  ret <vscale x 8 x half> %v
}

declare <vscale x 16 x half> @llvm.vp.roundeven.nxv16f16(<vscale x 16 x half>, <vscale x 16 x i1>, i32)

define <vscale x 16 x half> @vp_roundeven_nxv16f16(<vscale x 16 x half> %va, <vscale x 16 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: vp_roundeven_nxv16f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; ZVFH-NEXT:    vmv1r.v v12, v0
; ZVFH-NEXT:    lui a0, %hi(.LCPI20_0)
; ZVFH-NEXT:    flh fa5, %lo(.LCPI20_0)(a0)
; ZVFH-NEXT:    vfabs.v v16, v8, v0.t
; ZVFH-NEXT:    vsetvli zero, zero, e16, m4, ta, mu
; ZVFH-NEXT:    vmflt.vf v12, v16, fa5, v0.t
; ZVFH-NEXT:    fsrmi a0, 0
; ZVFH-NEXT:    vmv1r.v v0, v12
; ZVFH-NEXT:    vsetvli zero, zero, e16, m4, ta, ma
; ZVFH-NEXT:    vfcvt.x.f.v v16, v8, v0.t
; ZVFH-NEXT:    fsrm a0
; ZVFH-NEXT:    vfcvt.f.x.v v16, v16, v0.t
; ZVFH-NEXT:    vsetvli zero, zero, e16, m4, ta, mu
; ZVFH-NEXT:    vfsgnj.vv v8, v16, v8, v0.t
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vp_roundeven_nxv16f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vmv1r.v v12, v0
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v8, v0.t
; ZVFHMIN-NEXT:    lui a0, 307200
; ZVFHMIN-NEXT:    vmv1r.v v8, v0
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m8, ta, ma
; ZVFHMIN-NEXT:    vfabs.v v24, v16, v0.t
; ZVFHMIN-NEXT:    fmv.w.x fa5, a0
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m8, ta, mu
; ZVFHMIN-NEXT:    vmflt.vf v8, v24, fa5, v0.t
; ZVFHMIN-NEXT:    fsrmi a0, 0
; ZVFHMIN-NEXT:    vmv1r.v v0, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m8, ta, ma
; ZVFHMIN-NEXT:    vfcvt.x.f.v v24, v16, v0.t
; ZVFHMIN-NEXT:    fsrm a0
; ZVFHMIN-NEXT:    vfcvt.f.x.v v24, v24, v0.t
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m8, ta, mu
; ZVFHMIN-NEXT:    vfsgnj.vv v16, v24, v16, v0.t
; ZVFHMIN-NEXT:    vmv1r.v v0, v12
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v16, v0.t
; ZVFHMIN-NEXT:    ret
  %v = call <vscale x 16 x half> @llvm.vp.roundeven.nxv16f16(<vscale x 16 x half> %va, <vscale x 16 x i1> %m, i32 %evl)
  ret <vscale x 16 x half> %v
}

define <vscale x 16 x half> @vp_roundeven_nxv16f16_unmasked(<vscale x 16 x half> %va, i32 zeroext %evl) {
; ZVFH-LABEL: vp_roundeven_nxv16f16_unmasked:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    lui a1, %hi(.LCPI21_0)
; ZVFH-NEXT:    flh fa5, %lo(.LCPI21_0)(a1)
; ZVFH-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; ZVFH-NEXT:    vfabs.v v12, v8
; ZVFH-NEXT:    vmflt.vf v0, v12, fa5
; ZVFH-NEXT:    fsrmi a0, 0
; ZVFH-NEXT:    vfcvt.x.f.v v12, v8, v0.t
; ZVFH-NEXT:    fsrm a0
; ZVFH-NEXT:    vfcvt.f.x.v v12, v12, v0.t
; ZVFH-NEXT:    vsetvli zero, zero, e16, m4, ta, mu
; ZVFH-NEXT:    vfsgnj.vv v8, v12, v8, v0.t
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vp_roundeven_nxv16f16_unmasked:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v8
; ZVFHMIN-NEXT:    lui a0, 307200
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m8, ta, ma
; ZVFHMIN-NEXT:    vfabs.v v8, v16
; ZVFHMIN-NEXT:    fmv.w.x fa5, a0
; ZVFHMIN-NEXT:    vmflt.vf v0, v8, fa5
; ZVFHMIN-NEXT:    fsrmi a0, 0
; ZVFHMIN-NEXT:    vfcvt.x.f.v v8, v16, v0.t
; ZVFHMIN-NEXT:    fsrm a0
; ZVFHMIN-NEXT:    vfcvt.f.x.v v8, v8, v0.t
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m8, ta, mu
; ZVFHMIN-NEXT:    vfsgnj.vv v16, v8, v16, v0.t
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v16
; ZVFHMIN-NEXT:    ret
  %v = call <vscale x 16 x half> @llvm.vp.roundeven.nxv16f16(<vscale x 16 x half> %va, <vscale x 16 x i1> splat (i1 true), i32 %evl)
  ret <vscale x 16 x half> %v
}

declare <vscale x 32 x half> @llvm.vp.roundeven.nxv32f16(<vscale x 32 x half>, <vscale x 32 x i1>, i32)

define <vscale x 32 x half> @vp_roundeven_nxv32f16(<vscale x 32 x half> %va, <vscale x 32 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: vp_roundeven_nxv32f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m8, ta, ma
; ZVFH-NEXT:    vmv1r.v v16, v0
; ZVFH-NEXT:    lui a0, %hi(.LCPI22_0)
; ZVFH-NEXT:    flh fa5, %lo(.LCPI22_0)(a0)
; ZVFH-NEXT:    vfabs.v v24, v8, v0.t
; ZVFH-NEXT:    vsetvli zero, zero, e16, m8, ta, mu
; ZVFH-NEXT:    vmflt.vf v16, v24, fa5, v0.t
; ZVFH-NEXT:    fsrmi a0, 0
; ZVFH-NEXT:    vmv1r.v v0, v16
; ZVFH-NEXT:    vsetvli zero, zero, e16, m8, ta, ma
; ZVFH-NEXT:    vfcvt.x.f.v v24, v8, v0.t
; ZVFH-NEXT:    fsrm a0
; ZVFH-NEXT:    vfcvt.f.x.v v24, v24, v0.t
; ZVFH-NEXT:    vsetvli zero, zero, e16, m8, ta, mu
; ZVFH-NEXT:    vfsgnj.vv v8, v24, v8, v0.t
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vp_roundeven_nxv32f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a1, zero, e8, mf2, ta, ma
; ZVFHMIN-NEXT:    vmv1r.v v7, v0
; ZVFHMIN-NEXT:    csrr a2, vlenb
; ZVFHMIN-NEXT:    lui a3, 307200
; ZVFHMIN-NEXT:    slli a1, a2, 1
; ZVFHMIN-NEXT:    srli a2, a2, 2
; ZVFHMIN-NEXT:    fmv.w.x fa5, a3
; ZVFHMIN-NEXT:    sub a3, a0, a1
; ZVFHMIN-NEXT:    vslidedown.vx v6, v0, a2
; ZVFHMIN-NEXT:    sltu a2, a0, a3
; ZVFHMIN-NEXT:    vmv1r.v v5, v6
; ZVFHMIN-NEXT:    addi a2, a2, -1
; ZVFHMIN-NEXT:    and a2, a2, a3
; ZVFHMIN-NEXT:    vmv1r.v v0, v6
; ZVFHMIN-NEXT:    vsetvli zero, a2, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v24, v12, v0.t
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m8, ta, ma
; ZVFHMIN-NEXT:    vfabs.v v16, v24, v0.t
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m8, ta, mu
; ZVFHMIN-NEXT:    vmflt.vf v5, v16, fa5, v0.t
; ZVFHMIN-NEXT:    fsrmi a2, 0
; ZVFHMIN-NEXT:    vmv1r.v v0, v5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m8, ta, ma
; ZVFHMIN-NEXT:    vfcvt.x.f.v v16, v24, v0.t
; ZVFHMIN-NEXT:    fsrm a2
; ZVFHMIN-NEXT:    vfcvt.f.x.v v16, v16, v0.t
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m8, ta, mu
; ZVFHMIN-NEXT:    vfsgnj.vv v24, v16, v24, v0.t
; ZVFHMIN-NEXT:    vmv1r.v v0, v6
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v12, v24, v0.t
; ZVFHMIN-NEXT:    bltu a0, a1, .LBB22_2
; ZVFHMIN-NEXT:  # %bb.1:
; ZVFHMIN-NEXT:    mv a0, a1
; ZVFHMIN-NEXT:  .LBB22_2:
; ZVFHMIN-NEXT:    vmv1r.v v0, v7
; ZVFHMIN-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v24, v8, v0.t
; ZVFHMIN-NEXT:    vmv1r.v v8, v7
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m8, ta, ma
; ZVFHMIN-NEXT:    vfabs.v v16, v24, v0.t
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m8, ta, mu
; ZVFHMIN-NEXT:    vmflt.vf v8, v16, fa5, v0.t
; ZVFHMIN-NEXT:    fsrmi a0, 0
; ZVFHMIN-NEXT:    vmv1r.v v0, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m8, ta, ma
; ZVFHMIN-NEXT:    vfcvt.x.f.v v16, v24, v0.t
; ZVFHMIN-NEXT:    fsrm a0
; ZVFHMIN-NEXT:    vfcvt.f.x.v v16, v16, v0.t
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m8, ta, mu
; ZVFHMIN-NEXT:    vfsgnj.vv v24, v16, v24, v0.t
; ZVFHMIN-NEXT:    vmv1r.v v0, v7
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v24, v0.t
; ZVFHMIN-NEXT:    ret
  %v = call <vscale x 32 x half> @llvm.vp.roundeven.nxv32f16(<vscale x 32 x half> %va, <vscale x 32 x i1> %m, i32 %evl)
  ret <vscale x 32 x half> %v
}

define <vscale x 32 x half> @vp_roundeven_nxv32f16_unmasked(<vscale x 32 x half> %va, i32 zeroext %evl) {
; ZVFH-LABEL: vp_roundeven_nxv32f16_unmasked:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    lui a1, %hi(.LCPI23_0)
; ZVFH-NEXT:    flh fa5, %lo(.LCPI23_0)(a1)
; ZVFH-NEXT:    vsetvli zero, a0, e16, m8, ta, ma
; ZVFH-NEXT:    vfabs.v v16, v8
; ZVFH-NEXT:    vmflt.vf v0, v16, fa5
; ZVFH-NEXT:    fsrmi a0, 0
; ZVFH-NEXT:    vfcvt.x.f.v v16, v8, v0.t
; ZVFH-NEXT:    fsrm a0
; ZVFH-NEXT:    vfcvt.f.x.v v16, v16, v0.t
; ZVFH-NEXT:    vsetvli zero, zero, e16, m8, ta, mu
; ZVFH-NEXT:    vfsgnj.vv v8, v16, v8, v0.t
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vp_roundeven_nxv32f16_unmasked:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    csrr a2, vlenb
; ZVFHMIN-NEXT:    vsetvli a1, zero, e8, m4, ta, ma
; ZVFHMIN-NEXT:    vmset.m v16
; ZVFHMIN-NEXT:    lui a3, 307200
; ZVFHMIN-NEXT:    slli a1, a2, 1
; ZVFHMIN-NEXT:    srli a2, a2, 2
; ZVFHMIN-NEXT:    fmv.w.x fa5, a3
; ZVFHMIN-NEXT:    sub a3, a0, a1
; ZVFHMIN-NEXT:    vsetvli a4, zero, e8, mf2, ta, ma
; ZVFHMIN-NEXT:    vslidedown.vx v7, v16, a2
; ZVFHMIN-NEXT:    sltu a2, a0, a3
; ZVFHMIN-NEXT:    vmv1r.v v6, v7
; ZVFHMIN-NEXT:    addi a2, a2, -1
; ZVFHMIN-NEXT:    and a2, a2, a3
; ZVFHMIN-NEXT:    vmv1r.v v0, v7
; ZVFHMIN-NEXT:    vsetvli zero, a2, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v24, v12, v0.t
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m8, ta, ma
; ZVFHMIN-NEXT:    vfabs.v v16, v24, v0.t
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m8, ta, mu
; ZVFHMIN-NEXT:    vmflt.vf v6, v16, fa5, v0.t
; ZVFHMIN-NEXT:    fsrmi a2, 0
; ZVFHMIN-NEXT:    vmv1r.v v0, v6
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m8, ta, ma
; ZVFHMIN-NEXT:    vfcvt.x.f.v v16, v24, v0.t
; ZVFHMIN-NEXT:    fsrm a2
; ZVFHMIN-NEXT:    vfcvt.f.x.v v16, v16, v0.t
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m8, ta, mu
; ZVFHMIN-NEXT:    vfsgnj.vv v24, v16, v24, v0.t
; ZVFHMIN-NEXT:    vmv1r.v v0, v7
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v12, v24, v0.t
; ZVFHMIN-NEXT:    bltu a0, a1, .LBB23_2
; ZVFHMIN-NEXT:  # %bb.1:
; ZVFHMIN-NEXT:    mv a0, a1
; ZVFHMIN-NEXT:  .LBB23_2:
; ZVFHMIN-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m8, ta, ma
; ZVFHMIN-NEXT:    vfabs.v v24, v16
; ZVFHMIN-NEXT:    vmflt.vf v0, v24, fa5
; ZVFHMIN-NEXT:    fsrmi a0, 0
; ZVFHMIN-NEXT:    vfcvt.x.f.v v24, v16, v0.t
; ZVFHMIN-NEXT:    fsrm a0
; ZVFHMIN-NEXT:    vfcvt.f.x.v v24, v24, v0.t
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m8, ta, mu
; ZVFHMIN-NEXT:    vfsgnj.vv v16, v24, v16, v0.t
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v16
; ZVFHMIN-NEXT:    ret
  %v = call <vscale x 32 x half> @llvm.vp.roundeven.nxv32f16(<vscale x 32 x half> %va, <vscale x 32 x i1> splat (i1 true), i32 %evl)
  ret <vscale x 32 x half> %v
}

declare <vscale x 1 x float> @llvm.vp.roundeven.nxv1f32(<vscale x 1 x float>, <vscale x 1 x i1>, i32)

define <vscale x 1 x float> @vp_roundeven_nxv1f32(<vscale x 1 x float> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_roundeven_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    vfabs.v v9, v8, v0.t
; CHECK-NEXT:    lui a0, 307200
; CHECK-NEXT:    fmv.w.x fa5, a0
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, mu
; CHECK-NEXT:    vmflt.vf v0, v9, fa5, v0.t
; CHECK-NEXT:    fsrmi a0, 0
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfcvt.x.f.v v9, v8, v0.t
; CHECK-NEXT:    fsrm a0
; CHECK-NEXT:    vfcvt.f.x.v v9, v9, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v9, v8, v0.t
; CHECK-NEXT:    ret
  %v = call <vscale x 1 x float> @llvm.vp.roundeven.nxv1f32(<vscale x 1 x float> %va, <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x float> %v
}

define <vscale x 1 x float> @vp_roundeven_nxv1f32_unmasked(<vscale x 1 x float> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_roundeven_nxv1f32_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    vfabs.v v9, v8
; CHECK-NEXT:    lui a0, 307200
; CHECK-NEXT:    fmv.w.x fa5, a0
; CHECK-NEXT:    vmflt.vf v0, v9, fa5
; CHECK-NEXT:    fsrmi a0, 0
; CHECK-NEXT:    vfcvt.x.f.v v9, v8, v0.t
; CHECK-NEXT:    fsrm a0
; CHECK-NEXT:    vfcvt.f.x.v v9, v9, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v9, v8, v0.t
; CHECK-NEXT:    ret
  %v = call <vscale x 1 x float> @llvm.vp.roundeven.nxv1f32(<vscale x 1 x float> %va, <vscale x 1 x i1> splat (i1 true), i32 %evl)
  ret <vscale x 1 x float> %v
}

declare <vscale x 2 x float> @llvm.vp.roundeven.nxv2f32(<vscale x 2 x float>, <vscale x 2 x i1>, i32)

define <vscale x 2 x float> @vp_roundeven_nxv2f32(<vscale x 2 x float> %va, <vscale x 2 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_roundeven_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; CHECK-NEXT:    vfabs.v v9, v8, v0.t
; CHECK-NEXT:    lui a0, 307200
; CHECK-NEXT:    fmv.w.x fa5, a0
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, ta, mu
; CHECK-NEXT:    vmflt.vf v0, v9, fa5, v0.t
; CHECK-NEXT:    fsrmi a0, 0
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfcvt.x.f.v v9, v8, v0.t
; CHECK-NEXT:    fsrm a0
; CHECK-NEXT:    vfcvt.f.x.v v9, v9, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v9, v8, v0.t
; CHECK-NEXT:    ret
  %v = call <vscale x 2 x float> @llvm.vp.roundeven.nxv2f32(<vscale x 2 x float> %va, <vscale x 2 x i1> %m, i32 %evl)
  ret <vscale x 2 x float> %v
}

define <vscale x 2 x float> @vp_roundeven_nxv2f32_unmasked(<vscale x 2 x float> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_roundeven_nxv2f32_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; CHECK-NEXT:    vfabs.v v9, v8
; CHECK-NEXT:    lui a0, 307200
; CHECK-NEXT:    fmv.w.x fa5, a0
; CHECK-NEXT:    vmflt.vf v0, v9, fa5
; CHECK-NEXT:    fsrmi a0, 0
; CHECK-NEXT:    vfcvt.x.f.v v9, v8, v0.t
; CHECK-NEXT:    fsrm a0
; CHECK-NEXT:    vfcvt.f.x.v v9, v9, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v9, v8, v0.t
; CHECK-NEXT:    ret
  %v = call <vscale x 2 x float> @llvm.vp.roundeven.nxv2f32(<vscale x 2 x float> %va, <vscale x 2 x i1> splat (i1 true), i32 %evl)
  ret <vscale x 2 x float> %v
}

declare <vscale x 4 x float> @llvm.vp.roundeven.nxv4f32(<vscale x 4 x float>, <vscale x 4 x i1>, i32)

define <vscale x 4 x float> @vp_roundeven_nxv4f32(<vscale x 4 x float> %va, <vscale x 4 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_roundeven_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; CHECK-NEXT:    vmv1r.v v10, v0
; CHECK-NEXT:    vfabs.v v12, v8, v0.t
; CHECK-NEXT:    lui a0, 307200
; CHECK-NEXT:    fmv.w.x fa5, a0
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, mu
; CHECK-NEXT:    vmflt.vf v10, v12, fa5, v0.t
; CHECK-NEXT:    fsrmi a0, 0
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfcvt.x.f.v v12, v8, v0.t
; CHECK-NEXT:    fsrm a0
; CHECK-NEXT:    vfcvt.f.x.v v12, v12, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v12, v8, v0.t
; CHECK-NEXT:    ret
  %v = call <vscale x 4 x float> @llvm.vp.roundeven.nxv4f32(<vscale x 4 x float> %va, <vscale x 4 x i1> %m, i32 %evl)
  ret <vscale x 4 x float> %v
}

define <vscale x 4 x float> @vp_roundeven_nxv4f32_unmasked(<vscale x 4 x float> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_roundeven_nxv4f32_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; CHECK-NEXT:    vfabs.v v10, v8
; CHECK-NEXT:    lui a0, 307200
; CHECK-NEXT:    fmv.w.x fa5, a0
; CHECK-NEXT:    vmflt.vf v0, v10, fa5
; CHECK-NEXT:    fsrmi a0, 0
; CHECK-NEXT:    vfcvt.x.f.v v10, v8, v0.t
; CHECK-NEXT:    fsrm a0
; CHECK-NEXT:    vfcvt.f.x.v v10, v10, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v10, v8, v0.t
; CHECK-NEXT:    ret
  %v = call <vscale x 4 x float> @llvm.vp.roundeven.nxv4f32(<vscale x 4 x float> %va, <vscale x 4 x i1> splat (i1 true), i32 %evl)
  ret <vscale x 4 x float> %v
}

declare <vscale x 8 x float> @llvm.vp.roundeven.nxv8f32(<vscale x 8 x float>, <vscale x 8 x i1>, i32)

define <vscale x 8 x float> @vp_roundeven_nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_roundeven_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    vmv1r.v v12, v0
; CHECK-NEXT:    vfabs.v v16, v8, v0.t
; CHECK-NEXT:    lui a0, 307200
; CHECK-NEXT:    fmv.w.x fa5, a0
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, mu
; CHECK-NEXT:    vmflt.vf v12, v16, fa5, v0.t
; CHECK-NEXT:    fsrmi a0, 0
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfcvt.x.f.v v16, v8, v0.t
; CHECK-NEXT:    fsrm a0
; CHECK-NEXT:    vfcvt.f.x.v v16, v16, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v16, v8, v0.t
; CHECK-NEXT:    ret
  %v = call <vscale x 8 x float> @llvm.vp.roundeven.nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x float> %v
}

define <vscale x 8 x float> @vp_roundeven_nxv8f32_unmasked(<vscale x 8 x float> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_roundeven_nxv8f32_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    vfabs.v v12, v8
; CHECK-NEXT:    lui a0, 307200
; CHECK-NEXT:    fmv.w.x fa5, a0
; CHECK-NEXT:    vmflt.vf v0, v12, fa5
; CHECK-NEXT:    fsrmi a0, 0
; CHECK-NEXT:    vfcvt.x.f.v v12, v8, v0.t
; CHECK-NEXT:    fsrm a0
; CHECK-NEXT:    vfcvt.f.x.v v12, v12, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v12, v8, v0.t
; CHECK-NEXT:    ret
  %v = call <vscale x 8 x float> @llvm.vp.roundeven.nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x i1> splat (i1 true), i32 %evl)
  ret <vscale x 8 x float> %v
}

declare <vscale x 16 x float> @llvm.vp.roundeven.nxv16f32(<vscale x 16 x float>, <vscale x 16 x i1>, i32)

define <vscale x 16 x float> @vp_roundeven_nxv16f32(<vscale x 16 x float> %va, <vscale x 16 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_roundeven_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, m8, ta, ma
; CHECK-NEXT:    vmv1r.v v16, v0
; CHECK-NEXT:    vfabs.v v24, v8, v0.t
; CHECK-NEXT:    lui a0, 307200
; CHECK-NEXT:    fmv.w.x fa5, a0
; CHECK-NEXT:    vsetvli zero, zero, e32, m8, ta, mu
; CHECK-NEXT:    vmflt.vf v16, v24, fa5, v0.t
; CHECK-NEXT:    fsrmi a0, 0
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    vsetvli zero, zero, e32, m8, ta, ma
; CHECK-NEXT:    vfcvt.x.f.v v24, v8, v0.t
; CHECK-NEXT:    fsrm a0
; CHECK-NEXT:    vfcvt.f.x.v v24, v24, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, m8, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v24, v8, v0.t
; CHECK-NEXT:    ret
  %v = call <vscale x 16 x float> @llvm.vp.roundeven.nxv16f32(<vscale x 16 x float> %va, <vscale x 16 x i1> %m, i32 %evl)
  ret <vscale x 16 x float> %v
}

define <vscale x 16 x float> @vp_roundeven_nxv16f32_unmasked(<vscale x 16 x float> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_roundeven_nxv16f32_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, m8, ta, ma
; CHECK-NEXT:    vfabs.v v16, v8
; CHECK-NEXT:    lui a0, 307200
; CHECK-NEXT:    fmv.w.x fa5, a0
; CHECK-NEXT:    vmflt.vf v0, v16, fa5
; CHECK-NEXT:    fsrmi a0, 0
; CHECK-NEXT:    vfcvt.x.f.v v16, v8, v0.t
; CHECK-NEXT:    fsrm a0
; CHECK-NEXT:    vfcvt.f.x.v v16, v16, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e32, m8, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v16, v8, v0.t
; CHECK-NEXT:    ret
  %v = call <vscale x 16 x float> @llvm.vp.roundeven.nxv16f32(<vscale x 16 x float> %va, <vscale x 16 x i1> splat (i1 true), i32 %evl)
  ret <vscale x 16 x float> %v
}

declare <vscale x 1 x double> @llvm.vp.roundeven.nxv1f64(<vscale x 1 x double>, <vscale x 1 x i1>, i32)

define <vscale x 1 x double> @vp_roundeven_nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_roundeven_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lui a1, %hi(.LCPI34_0)
; CHECK-NEXT:    fld fa5, %lo(.LCPI34_0)(a1)
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vfabs.v v9, v8, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e64, m1, ta, mu
; CHECK-NEXT:    vmflt.vf v0, v9, fa5, v0.t
; CHECK-NEXT:    fsrmi a0, 0
; CHECK-NEXT:    vsetvli zero, zero, e64, m1, ta, ma
; CHECK-NEXT:    vfcvt.x.f.v v9, v8, v0.t
; CHECK-NEXT:    fsrm a0
; CHECK-NEXT:    vfcvt.f.x.v v9, v9, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e64, m1, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v9, v8, v0.t
; CHECK-NEXT:    ret
  %v = call <vscale x 1 x double> @llvm.vp.roundeven.nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x double> %v
}

define <vscale x 1 x double> @vp_roundeven_nxv1f64_unmasked(<vscale x 1 x double> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_roundeven_nxv1f64_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lui a1, %hi(.LCPI35_0)
; CHECK-NEXT:    fld fa5, %lo(.LCPI35_0)(a1)
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vfabs.v v9, v8
; CHECK-NEXT:    vmflt.vf v0, v9, fa5
; CHECK-NEXT:    fsrmi a0, 0
; CHECK-NEXT:    vfcvt.x.f.v v9, v8, v0.t
; CHECK-NEXT:    fsrm a0
; CHECK-NEXT:    vfcvt.f.x.v v9, v9, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e64, m1, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v9, v8, v0.t
; CHECK-NEXT:    ret
  %v = call <vscale x 1 x double> @llvm.vp.roundeven.nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x i1> splat (i1 true), i32 %evl)
  ret <vscale x 1 x double> %v
}

declare <vscale x 2 x double> @llvm.vp.roundeven.nxv2f64(<vscale x 2 x double>, <vscale x 2 x i1>, i32)

define <vscale x 2 x double> @vp_roundeven_nxv2f64(<vscale x 2 x double> %va, <vscale x 2 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_roundeven_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; CHECK-NEXT:    vmv1r.v v10, v0
; CHECK-NEXT:    lui a0, %hi(.LCPI36_0)
; CHECK-NEXT:    fld fa5, %lo(.LCPI36_0)(a0)
; CHECK-NEXT:    vfabs.v v12, v8, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e64, m2, ta, mu
; CHECK-NEXT:    vmflt.vf v10, v12, fa5, v0.t
; CHECK-NEXT:    fsrmi a0, 0
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vsetvli zero, zero, e64, m2, ta, ma
; CHECK-NEXT:    vfcvt.x.f.v v12, v8, v0.t
; CHECK-NEXT:    fsrm a0
; CHECK-NEXT:    vfcvt.f.x.v v12, v12, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e64, m2, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v12, v8, v0.t
; CHECK-NEXT:    ret
  %v = call <vscale x 2 x double> @llvm.vp.roundeven.nxv2f64(<vscale x 2 x double> %va, <vscale x 2 x i1> %m, i32 %evl)
  ret <vscale x 2 x double> %v
}

define <vscale x 2 x double> @vp_roundeven_nxv2f64_unmasked(<vscale x 2 x double> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_roundeven_nxv2f64_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lui a1, %hi(.LCPI37_0)
; CHECK-NEXT:    fld fa5, %lo(.LCPI37_0)(a1)
; CHECK-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; CHECK-NEXT:    vfabs.v v10, v8
; CHECK-NEXT:    vmflt.vf v0, v10, fa5
; CHECK-NEXT:    fsrmi a0, 0
; CHECK-NEXT:    vfcvt.x.f.v v10, v8, v0.t
; CHECK-NEXT:    fsrm a0
; CHECK-NEXT:    vfcvt.f.x.v v10, v10, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e64, m2, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v10, v8, v0.t
; CHECK-NEXT:    ret
  %v = call <vscale x 2 x double> @llvm.vp.roundeven.nxv2f64(<vscale x 2 x double> %va, <vscale x 2 x i1> splat (i1 true), i32 %evl)
  ret <vscale x 2 x double> %v
}

declare <vscale x 4 x double> @llvm.vp.roundeven.nxv4f64(<vscale x 4 x double>, <vscale x 4 x i1>, i32)

define <vscale x 4 x double> @vp_roundeven_nxv4f64(<vscale x 4 x double> %va, <vscale x 4 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_roundeven_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmv1r.v v12, v0
; CHECK-NEXT:    lui a0, %hi(.LCPI38_0)
; CHECK-NEXT:    fld fa5, %lo(.LCPI38_0)(a0)
; CHECK-NEXT:    vfabs.v v16, v8, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e64, m4, ta, mu
; CHECK-NEXT:    vmflt.vf v12, v16, fa5, v0.t
; CHECK-NEXT:    fsrmi a0, 0
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vsetvli zero, zero, e64, m4, ta, ma
; CHECK-NEXT:    vfcvt.x.f.v v16, v8, v0.t
; CHECK-NEXT:    fsrm a0
; CHECK-NEXT:    vfcvt.f.x.v v16, v16, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e64, m4, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v16, v8, v0.t
; CHECK-NEXT:    ret
  %v = call <vscale x 4 x double> @llvm.vp.roundeven.nxv4f64(<vscale x 4 x double> %va, <vscale x 4 x i1> %m, i32 %evl)
  ret <vscale x 4 x double> %v
}

define <vscale x 4 x double> @vp_roundeven_nxv4f64_unmasked(<vscale x 4 x double> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_roundeven_nxv4f64_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lui a1, %hi(.LCPI39_0)
; CHECK-NEXT:    fld fa5, %lo(.LCPI39_0)(a1)
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vfabs.v v12, v8
; CHECK-NEXT:    vmflt.vf v0, v12, fa5
; CHECK-NEXT:    fsrmi a0, 0
; CHECK-NEXT:    vfcvt.x.f.v v12, v8, v0.t
; CHECK-NEXT:    fsrm a0
; CHECK-NEXT:    vfcvt.f.x.v v12, v12, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e64, m4, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v12, v8, v0.t
; CHECK-NEXT:    ret
  %v = call <vscale x 4 x double> @llvm.vp.roundeven.nxv4f64(<vscale x 4 x double> %va, <vscale x 4 x i1> splat (i1 true), i32 %evl)
  ret <vscale x 4 x double> %v
}

declare <vscale x 7 x double> @llvm.vp.roundeven.nxv7f64(<vscale x 7 x double>, <vscale x 7 x i1>, i32)

define <vscale x 7 x double> @vp_roundeven_nxv7f64(<vscale x 7 x double> %va, <vscale x 7 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_roundeven_nxv7f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmv1r.v v16, v0
; CHECK-NEXT:    lui a0, %hi(.LCPI40_0)
; CHECK-NEXT:    fld fa5, %lo(.LCPI40_0)(a0)
; CHECK-NEXT:    vfabs.v v24, v8, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e64, m8, ta, mu
; CHECK-NEXT:    vmflt.vf v16, v24, fa5, v0.t
; CHECK-NEXT:    fsrmi a0, 0
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    vsetvli zero, zero, e64, m8, ta, ma
; CHECK-NEXT:    vfcvt.x.f.v v24, v8, v0.t
; CHECK-NEXT:    fsrm a0
; CHECK-NEXT:    vfcvt.f.x.v v24, v24, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e64, m8, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v24, v8, v0.t
; CHECK-NEXT:    ret
  %v = call <vscale x 7 x double> @llvm.vp.roundeven.nxv7f64(<vscale x 7 x double> %va, <vscale x 7 x i1> %m, i32 %evl)
  ret <vscale x 7 x double> %v
}

define <vscale x 7 x double> @vp_roundeven_nxv7f64_unmasked(<vscale x 7 x double> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_roundeven_nxv7f64_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lui a1, %hi(.LCPI41_0)
; CHECK-NEXT:    fld fa5, %lo(.LCPI41_0)(a1)
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vfabs.v v16, v8
; CHECK-NEXT:    vmflt.vf v0, v16, fa5
; CHECK-NEXT:    fsrmi a0, 0
; CHECK-NEXT:    vfcvt.x.f.v v16, v8, v0.t
; CHECK-NEXT:    fsrm a0
; CHECK-NEXT:    vfcvt.f.x.v v16, v16, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e64, m8, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v16, v8, v0.t
; CHECK-NEXT:    ret
  %v = call <vscale x 7 x double> @llvm.vp.roundeven.nxv7f64(<vscale x 7 x double> %va, <vscale x 7 x i1> splat (i1 true), i32 %evl)
  ret <vscale x 7 x double> %v
}

declare <vscale x 8 x double> @llvm.vp.roundeven.nxv8f64(<vscale x 8 x double>, <vscale x 8 x i1>, i32)

define <vscale x 8 x double> @vp_roundeven_nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_roundeven_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmv1r.v v16, v0
; CHECK-NEXT:    lui a0, %hi(.LCPI42_0)
; CHECK-NEXT:    fld fa5, %lo(.LCPI42_0)(a0)
; CHECK-NEXT:    vfabs.v v24, v8, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e64, m8, ta, mu
; CHECK-NEXT:    vmflt.vf v16, v24, fa5, v0.t
; CHECK-NEXT:    fsrmi a0, 0
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    vsetvli zero, zero, e64, m8, ta, ma
; CHECK-NEXT:    vfcvt.x.f.v v24, v8, v0.t
; CHECK-NEXT:    fsrm a0
; CHECK-NEXT:    vfcvt.f.x.v v24, v24, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e64, m8, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v24, v8, v0.t
; CHECK-NEXT:    ret
  %v = call <vscale x 8 x double> @llvm.vp.roundeven.nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x double> %v
}

define <vscale x 8 x double> @vp_roundeven_nxv8f64_unmasked(<vscale x 8 x double> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_roundeven_nxv8f64_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lui a1, %hi(.LCPI43_0)
; CHECK-NEXT:    fld fa5, %lo(.LCPI43_0)(a1)
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vfabs.v v16, v8
; CHECK-NEXT:    vmflt.vf v0, v16, fa5
; CHECK-NEXT:    fsrmi a0, 0
; CHECK-NEXT:    vfcvt.x.f.v v16, v8, v0.t
; CHECK-NEXT:    fsrm a0
; CHECK-NEXT:    vfcvt.f.x.v v16, v16, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e64, m8, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v16, v8, v0.t
; CHECK-NEXT:    ret
  %v = call <vscale x 8 x double> @llvm.vp.roundeven.nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x i1> splat (i1 true), i32 %evl)
  ret <vscale x 8 x double> %v
}

; Test splitting.
declare <vscale x 16 x double> @llvm.vp.roundeven.nxv16f64(<vscale x 16 x double>, <vscale x 16 x i1>, i32)

define <vscale x 16 x double> @vp_roundeven_nxv16f64(<vscale x 16 x double> %va, <vscale x 16 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_roundeven_nxv16f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, mf4, ta, ma
; CHECK-NEXT:    vmv1r.v v7, v0
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    lui a2, %hi(.LCPI44_0)
; CHECK-NEXT:    srli a3, a1, 3
; CHECK-NEXT:    fld fa5, %lo(.LCPI44_0)(a2)
; CHECK-NEXT:    sub a2, a0, a1
; CHECK-NEXT:    vslidedown.vx v6, v0, a3
; CHECK-NEXT:    sltu a3, a0, a2
; CHECK-NEXT:    addi a3, a3, -1
; CHECK-NEXT:    and a2, a3, a2
; CHECK-NEXT:    vmv1r.v v0, v6
; CHECK-NEXT:    vsetvli zero, a2, e64, m8, ta, ma
; CHECK-NEXT:    vfabs.v v24, v16, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e64, m8, ta, mu
; CHECK-NEXT:    vmflt.vf v6, v24, fa5, v0.t
; CHECK-NEXT:    fsrmi a2, 0
; CHECK-NEXT:    vmv1r.v v0, v6
; CHECK-NEXT:    vsetvli zero, zero, e64, m8, ta, ma
; CHECK-NEXT:    vfcvt.x.f.v v24, v16, v0.t
; CHECK-NEXT:    fsrm a2
; CHECK-NEXT:    vfcvt.f.x.v v24, v24, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e64, m8, ta, mu
; CHECK-NEXT:    vfsgnj.vv v16, v24, v16, v0.t
; CHECK-NEXT:    bltu a0, a1, .LBB44_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    mv a0, a1
; CHECK-NEXT:  .LBB44_2:
; CHECK-NEXT:    vmv1r.v v0, v7
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vfabs.v v24, v8, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e64, m8, ta, mu
; CHECK-NEXT:    vmflt.vf v7, v24, fa5, v0.t
; CHECK-NEXT:    fsrmi a0, 0
; CHECK-NEXT:    vmv1r.v v0, v7
; CHECK-NEXT:    vsetvli zero, zero, e64, m8, ta, ma
; CHECK-NEXT:    vfcvt.x.f.v v24, v8, v0.t
; CHECK-NEXT:    fsrm a0
; CHECK-NEXT:    vfcvt.f.x.v v24, v24, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e64, m8, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v24, v8, v0.t
; CHECK-NEXT:    ret
  %v = call <vscale x 16 x double> @llvm.vp.roundeven.nxv16f64(<vscale x 16 x double> %va, <vscale x 16 x i1> %m, i32 %evl)
  ret <vscale x 16 x double> %v
}

define <vscale x 16 x double> @vp_roundeven_nxv16f64_unmasked(<vscale x 16 x double> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_roundeven_nxv16f64_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    lui a2, %hi(.LCPI45_0)
; CHECK-NEXT:    sub a3, a0, a1
; CHECK-NEXT:    fld fa5, %lo(.LCPI45_0)(a2)
; CHECK-NEXT:    sltu a2, a0, a3
; CHECK-NEXT:    addi a2, a2, -1
; CHECK-NEXT:    and a2, a2, a3
; CHECK-NEXT:    vsetvli zero, a2, e64, m8, ta, ma
; CHECK-NEXT:    vfabs.v v24, v16
; CHECK-NEXT:    vmflt.vf v0, v24, fa5
; CHECK-NEXT:    fsrmi a2, 0
; CHECK-NEXT:    vfcvt.x.f.v v24, v16, v0.t
; CHECK-NEXT:    fsrm a2
; CHECK-NEXT:    vfcvt.f.x.v v24, v24, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e64, m8, ta, mu
; CHECK-NEXT:    vfsgnj.vv v16, v24, v16, v0.t
; CHECK-NEXT:    bltu a0, a1, .LBB45_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    mv a0, a1
; CHECK-NEXT:  .LBB45_2:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vfabs.v v24, v8
; CHECK-NEXT:    vmflt.vf v0, v24, fa5
; CHECK-NEXT:    fsrmi a0, 0
; CHECK-NEXT:    vfcvt.x.f.v v24, v8, v0.t
; CHECK-NEXT:    fsrm a0
; CHECK-NEXT:    vfcvt.f.x.v v24, v24, v0.t
; CHECK-NEXT:    vsetvli zero, zero, e64, m8, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v24, v8, v0.t
; CHECK-NEXT:    ret
  %v = call <vscale x 16 x double> @llvm.vp.roundeven.nxv16f64(<vscale x 16 x double> %va, <vscale x 16 x i1> splat (i1 true), i32 %evl)
  ret <vscale x 16 x double> %v
}
