; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -O3 < %s -aarch64-enable-atomic-cfg-tidy=0 -aarch64-enable-gep-opt=false -verify-machineinstrs | FileCheck %s
target triple = "arm64-apple-ios"

; rdar://12462006
; CSE between "icmp reg reg" and "sub reg reg".
; Both can be in the same basic block or in different basic blocks.
define ptr @t1(ptr %base, ptr nocapture %offset, i32 %size) nounwind {
; CHECK-LABEL: t1:
; CHECK:       ; %bb.0: ; %entry
; CHECK-NEXT:    ldr w8, [x1]
; CHECK-NEXT:    subs w9, w8, w2
; CHECK-NEXT:    b.ge LBB0_2
; CHECK-NEXT:  ; %bb.1:
; CHECK-NEXT:    mov x0, xzr
; CHECK-NEXT:    ret
; CHECK-NEXT:  LBB0_2: ; %if.end
; CHECK-NEXT:    add x0, x0, w9, sxtw
; CHECK-NEXT:    sub w8, w8, w9
; CHECK-NEXT:    str w8, [x1]
; CHECK-NEXT:    ret
entry:
 %0 = load i32, ptr %offset, align 4
 %cmp = icmp slt i32 %0, %size
 %s = sub nsw i32 %0, %size
 br i1 %cmp, label %return, label %if.end

if.end:
 %sub = sub nsw i32 %0, %size
 %s2 = sub nsw i32 %s, %size
 %s3 = sub nsw i32 %sub, %s2
 store i32 %s3, ptr %offset, align 4
 %add.ptr = getelementptr inbounds i8, ptr %base, i32 %sub
 br label %return

return:
 %retval.0 = phi ptr [ %add.ptr, %if.end ], [ null, %entry ]
 ret ptr %retval.0
}

; CSE between "icmp reg imm" and "sub reg imm".
define ptr @t2(ptr %base, ptr nocapture %offset) nounwind {
; CHECK-LABEL: t2:
; CHECK:       ; %bb.0: ; %entry
; CHECK-NEXT:    ldr w8, [x1]
; CHECK-NEXT:    subs w8, w8, #1
; CHECK-NEXT:    b.lt LBB1_2
; CHECK-NEXT:  ; %bb.1: ; %if.end
; CHECK-NEXT:    add x0, x0, w8, sxtw
; CHECK-NEXT:    str w8, [x1]
; CHECK-NEXT:    ret
; CHECK-NEXT:  LBB1_2:
; CHECK-NEXT:    mov x0, xzr
; CHECK-NEXT:    ret
entry:
 %0 = load i32, ptr %offset, align 4
 %cmp = icmp slt i32 %0, 1
 br i1 %cmp, label %return, label %if.end

if.end:
 %sub = sub nsw i32 %0, 1
 store i32 %sub, ptr %offset, align 4
 %add.ptr = getelementptr inbounds i8, ptr %base, i32 %sub
 br label %return

return:
 %retval.0 = phi ptr [ %add.ptr, %if.end ], [ null, %entry ]
 ret ptr %retval.0
}
