; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -mtriple=nvptx64 -mcpu=sm_90 -mattr=+ptx80| FileCheck --check-prefixes=CHECK-PTX64 %s
; RUN: llc < %s -mtriple=nvptx64 -mcpu=sm_90 -mattr=+ptx80 --nvptx-short-ptr| FileCheck --check-prefixes=CHECK-PTX-SHARED32 %s
; RUN: %if ptxas-12.3 %{ llc < %s -mtriple=nvptx64 -mcpu=sm_90 -mattr=+ptx80| %ptxas-verify -arch=sm_90 %}
; RUN: %if ptxas-12.3 %{ llc < %s -mtriple=nvptx64 -mcpu=sm_90 -mattr=+ptx80 --nvptx-short-ptr| %ptxas-verify -arch=sm_90 %}

target triple = "nvptx64-nvidia-cuda"

declare void @llvm.nvvm.cp.async.bulk.tensor.s2g.tile.1d(ptr addrspace(3) %s, ptr %tm, i32 %d0, i64 %ch, i1 %flag);
declare void @llvm.nvvm.cp.async.bulk.tensor.s2g.tile.2d(ptr addrspace(3) %s, ptr %tm, i32 %d0, i32 %d1, i64 %ch, i1 %flag);
declare void @llvm.nvvm.cp.async.bulk.tensor.s2g.tile.3d(ptr addrspace(3) %s, ptr %tm, i32 %d0, i32 %d1, i32 %d2, i64 %ch, i1 %flag);
declare void @llvm.nvvm.cp.async.bulk.tensor.s2g.tile.4d(ptr addrspace(3) %s, ptr %tm, i32 %d0, i32 %d1, i32 %d2, i32 %d3, i64 %ch, i1 %flag);
declare void @llvm.nvvm.cp.async.bulk.tensor.s2g.tile.5d(ptr addrspace(3) %s, ptr %tm, i32 %d0, i32 %d1, i32 %d2, i32 %d3, i32 %d4, i64 %ch, i1 %flag);

declare void @llvm.nvvm.cp.async.bulk.tensor.s2g.im2col.3d(ptr addrspace(3) %s, ptr %tm, i32 %d0, i32 %d1, i32 %d2, i64 %ch, i1 %flag);
declare void @llvm.nvvm.cp.async.bulk.tensor.s2g.im2col.4d(ptr addrspace(3) %s, ptr %tm, i32 %d0, i32 %d1, i32 %d2, i32 %d3, i64 %ch, i1 %flag);
declare void @llvm.nvvm.cp.async.bulk.tensor.s2g.im2col.5d(ptr addrspace(3) %s, ptr %tm, i32 %d0, i32 %d1, i32 %d2, i32 %d3, i32 %d4, i64 %ch, i1 %flag);

; CHECK-LABEL: cp_async_bulk_tensor_s2g_tile_1d
define void @cp_async_bulk_tensor_s2g_tile_1d(ptr addrspace(3) %src, ptr %tmap, i32 %d0, i64 %ch) {
; CHECK-PTX64-LABEL: cp_async_bulk_tensor_s2g_tile_1d(
; CHECK-PTX64:       {
; CHECK-PTX64-NEXT:    .reg .b32 %r<2>;
; CHECK-PTX64-NEXT:    .reg .b64 %rd<4>;
; CHECK-PTX64-EMPTY:
; CHECK-PTX64-NEXT:  // %bb.0:
; CHECK-PTX64-NEXT:    ld.param.u64 %rd1, [cp_async_bulk_tensor_s2g_tile_1d_param_0];
; CHECK-PTX64-NEXT:    ld.param.u64 %rd2, [cp_async_bulk_tensor_s2g_tile_1d_param_1];
; CHECK-PTX64-NEXT:    ld.param.u32 %r1, [cp_async_bulk_tensor_s2g_tile_1d_param_2];
; CHECK-PTX64-NEXT:    cp.async.bulk.tensor.1d.global.shared::cta.tile.bulk_group [%rd2, {%r1}], [%rd1];
; CHECK-PTX64-NEXT:    ld.param.u64 %rd3, [cp_async_bulk_tensor_s2g_tile_1d_param_3];
; CHECK-PTX64-NEXT:    cp.async.bulk.tensor.1d.global.shared::cta.tile.bulk_group.L2::cache_hint [%rd2, {%r1}], [%rd1], %rd3;
; CHECK-PTX64-NEXT:    ret;
;
; CHECK-PTX-SHARED32-LABEL: cp_async_bulk_tensor_s2g_tile_1d(
; CHECK-PTX-SHARED32:       {
; CHECK-PTX-SHARED32-NEXT:    .reg .b32 %r<3>;
; CHECK-PTX-SHARED32-NEXT:    .reg .b64 %rd<3>;
; CHECK-PTX-SHARED32-EMPTY:
; CHECK-PTX-SHARED32-NEXT:  // %bb.0:
; CHECK-PTX-SHARED32-NEXT:    ld.param.u32 %r1, [cp_async_bulk_tensor_s2g_tile_1d_param_0];
; CHECK-PTX-SHARED32-NEXT:    ld.param.u64 %rd1, [cp_async_bulk_tensor_s2g_tile_1d_param_1];
; CHECK-PTX-SHARED32-NEXT:    ld.param.u32 %r2, [cp_async_bulk_tensor_s2g_tile_1d_param_2];
; CHECK-PTX-SHARED32-NEXT:    cp.async.bulk.tensor.1d.global.shared::cta.tile.bulk_group [%rd1, {%r2}], [%r1];
; CHECK-PTX-SHARED32-NEXT:    ld.param.u64 %rd2, [cp_async_bulk_tensor_s2g_tile_1d_param_3];
; CHECK-PTX-SHARED32-NEXT:    cp.async.bulk.tensor.1d.global.shared::cta.tile.bulk_group.L2::cache_hint [%rd1, {%r2}], [%r1], %rd2;
; CHECK-PTX-SHARED32-NEXT:    ret;
  tail call void @llvm.nvvm.cp.async.bulk.tensor.s2g.tile.1d(ptr addrspace(3) %src, ptr %tmap, i32 %d0, i64 undef, i1 0)
  tail call void @llvm.nvvm.cp.async.bulk.tensor.s2g.tile.1d(ptr addrspace(3) %src, ptr %tmap, i32 %d0, i64 %ch, i1 1)
  ret void
}

; CHECK-LABEL: cp_async_bulk_tensor_s2g_tile_2d
define void @cp_async_bulk_tensor_s2g_tile_2d(i32 %flag, ptr addrspace(3) %src, ptr %tmap, i32 %d0, i32 %d1, i64 %ch) {
; CHECK-PTX64-LABEL: cp_async_bulk_tensor_s2g_tile_2d(
; CHECK-PTX64:       {
; CHECK-PTX64-NEXT:    .reg .b32 %r<3>;
; CHECK-PTX64-NEXT:    .reg .b64 %rd<4>;
; CHECK-PTX64-EMPTY:
; CHECK-PTX64-NEXT:  // %bb.0:
; CHECK-PTX64-NEXT:    ld.param.u64 %rd1, [cp_async_bulk_tensor_s2g_tile_2d_param_1];
; CHECK-PTX64-NEXT:    ld.param.u64 %rd2, [cp_async_bulk_tensor_s2g_tile_2d_param_2];
; CHECK-PTX64-NEXT:    ld.param.u32 %r1, [cp_async_bulk_tensor_s2g_tile_2d_param_3];
; CHECK-PTX64-NEXT:    ld.param.u32 %r2, [cp_async_bulk_tensor_s2g_tile_2d_param_4];
; CHECK-PTX64-NEXT:    cp.async.bulk.tensor.2d.global.shared::cta.tile.bulk_group [%rd2, {%r1, %r2}], [%rd1];
; CHECK-PTX64-NEXT:    ld.param.u64 %rd3, [cp_async_bulk_tensor_s2g_tile_2d_param_5];
; CHECK-PTX64-NEXT:    cp.async.bulk.tensor.2d.global.shared::cta.tile.bulk_group.L2::cache_hint [%rd2, {%r1, %r2}], [%rd1], %rd3;
; CHECK-PTX64-NEXT:    ret;
;
; CHECK-PTX-SHARED32-LABEL: cp_async_bulk_tensor_s2g_tile_2d(
; CHECK-PTX-SHARED32:       {
; CHECK-PTX-SHARED32-NEXT:    .reg .b32 %r<4>;
; CHECK-PTX-SHARED32-NEXT:    .reg .b64 %rd<3>;
; CHECK-PTX-SHARED32-EMPTY:
; CHECK-PTX-SHARED32-NEXT:  // %bb.0:
; CHECK-PTX-SHARED32-NEXT:    ld.param.u32 %r1, [cp_async_bulk_tensor_s2g_tile_2d_param_1];
; CHECK-PTX-SHARED32-NEXT:    ld.param.u64 %rd1, [cp_async_bulk_tensor_s2g_tile_2d_param_2];
; CHECK-PTX-SHARED32-NEXT:    ld.param.u32 %r2, [cp_async_bulk_tensor_s2g_tile_2d_param_3];
; CHECK-PTX-SHARED32-NEXT:    ld.param.u32 %r3, [cp_async_bulk_tensor_s2g_tile_2d_param_4];
; CHECK-PTX-SHARED32-NEXT:    cp.async.bulk.tensor.2d.global.shared::cta.tile.bulk_group [%rd1, {%r2, %r3}], [%r1];
; CHECK-PTX-SHARED32-NEXT:    ld.param.u64 %rd2, [cp_async_bulk_tensor_s2g_tile_2d_param_5];
; CHECK-PTX-SHARED32-NEXT:    cp.async.bulk.tensor.2d.global.shared::cta.tile.bulk_group.L2::cache_hint [%rd1, {%r2, %r3}], [%r1], %rd2;
; CHECK-PTX-SHARED32-NEXT:    ret;
  tail call void @llvm.nvvm.cp.async.bulk.tensor.s2g.tile.2d(ptr addrspace(3) %src, ptr %tmap, i32 %d0, i32 %d1, i64 undef, i1 0)
  tail call void @llvm.nvvm.cp.async.bulk.tensor.s2g.tile.2d(ptr addrspace(3) %src, ptr %tmap, i32 %d0, i32 %d1, i64 %ch, i1 1)
  ret void
}

; CHECK-LABEL: cp_async_bulk_tensor_s2g_3d
define void @cp_async_bulk_tensor_s2g_3d(i32 %flag, ptr addrspace(3) %src, ptr %tmap, i32 %d0, i32 %d1, i32 %d2, i64 %ch) {
; CHECK-PTX64-LABEL: cp_async_bulk_tensor_s2g_3d(
; CHECK-PTX64:       {
; CHECK-PTX64-NEXT:    .reg .b32 %r<4>;
; CHECK-PTX64-NEXT:    .reg .b64 %rd<4>;
; CHECK-PTX64-EMPTY:
; CHECK-PTX64-NEXT:  // %bb.0:
; CHECK-PTX64-NEXT:    ld.param.u64 %rd1, [cp_async_bulk_tensor_s2g_3d_param_1];
; CHECK-PTX64-NEXT:    ld.param.u64 %rd2, [cp_async_bulk_tensor_s2g_3d_param_2];
; CHECK-PTX64-NEXT:    ld.param.u32 %r1, [cp_async_bulk_tensor_s2g_3d_param_3];
; CHECK-PTX64-NEXT:    ld.param.u32 %r2, [cp_async_bulk_tensor_s2g_3d_param_4];
; CHECK-PTX64-NEXT:    ld.param.u32 %r3, [cp_async_bulk_tensor_s2g_3d_param_5];
; CHECK-PTX64-NEXT:    cp.async.bulk.tensor.3d.global.shared::cta.tile.bulk_group [%rd2, {%r1, %r2, %r3}], [%rd1];
; CHECK-PTX64-NEXT:    ld.param.u64 %rd3, [cp_async_bulk_tensor_s2g_3d_param_6];
; CHECK-PTX64-NEXT:    cp.async.bulk.tensor.3d.global.shared::cta.tile.bulk_group.L2::cache_hint [%rd2, {%r1, %r2, %r3}], [%rd1], %rd3;
; CHECK-PTX64-NEXT:    cp.async.bulk.tensor.3d.global.shared::cta.im2col_no_offs.bulk_group [%rd2, {%r1, %r2, %r3}], [%rd1];
; CHECK-PTX64-NEXT:    cp.async.bulk.tensor.3d.global.shared::cta.im2col_no_offs.bulk_group.L2::cache_hint [%rd2, {%r1, %r2, %r3}], [%rd1], %rd3;
; CHECK-PTX64-NEXT:    ret;
;
; CHECK-PTX-SHARED32-LABEL: cp_async_bulk_tensor_s2g_3d(
; CHECK-PTX-SHARED32:       {
; CHECK-PTX-SHARED32-NEXT:    .reg .b32 %r<5>;
; CHECK-PTX-SHARED32-NEXT:    .reg .b64 %rd<3>;
; CHECK-PTX-SHARED32-EMPTY:
; CHECK-PTX-SHARED32-NEXT:  // %bb.0:
; CHECK-PTX-SHARED32-NEXT:    ld.param.u32 %r1, [cp_async_bulk_tensor_s2g_3d_param_1];
; CHECK-PTX-SHARED32-NEXT:    ld.param.u64 %rd1, [cp_async_bulk_tensor_s2g_3d_param_2];
; CHECK-PTX-SHARED32-NEXT:    ld.param.u32 %r2, [cp_async_bulk_tensor_s2g_3d_param_3];
; CHECK-PTX-SHARED32-NEXT:    ld.param.u32 %r3, [cp_async_bulk_tensor_s2g_3d_param_4];
; CHECK-PTX-SHARED32-NEXT:    ld.param.u32 %r4, [cp_async_bulk_tensor_s2g_3d_param_5];
; CHECK-PTX-SHARED32-NEXT:    cp.async.bulk.tensor.3d.global.shared::cta.tile.bulk_group [%rd1, {%r2, %r3, %r4}], [%r1];
; CHECK-PTX-SHARED32-NEXT:    ld.param.u64 %rd2, [cp_async_bulk_tensor_s2g_3d_param_6];
; CHECK-PTX-SHARED32-NEXT:    cp.async.bulk.tensor.3d.global.shared::cta.tile.bulk_group.L2::cache_hint [%rd1, {%r2, %r3, %r4}], [%r1], %rd2;
; CHECK-PTX-SHARED32-NEXT:    cp.async.bulk.tensor.3d.global.shared::cta.im2col_no_offs.bulk_group [%rd1, {%r2, %r3, %r4}], [%r1];
; CHECK-PTX-SHARED32-NEXT:    cp.async.bulk.tensor.3d.global.shared::cta.im2col_no_offs.bulk_group.L2::cache_hint [%rd1, {%r2, %r3, %r4}], [%r1], %rd2;
; CHECK-PTX-SHARED32-NEXT:    ret;
  tail call void @llvm.nvvm.cp.async.bulk.tensor.s2g.tile.3d(ptr addrspace(3) %src, ptr %tmap, i32 %d0, i32 %d1, i32 %d2, i64 undef, i1 0)
  tail call void @llvm.nvvm.cp.async.bulk.tensor.s2g.tile.3d(ptr addrspace(3) %src, ptr %tmap, i32 %d0, i32 %d1, i32 %d2, i64 %ch, i1 1)

  tail call void @llvm.nvvm.cp.async.bulk.tensor.s2g.im2col.3d(ptr addrspace(3) %src, ptr %tmap, i32 %d0, i32 %d1, i32 %d2, i64 undef, i1 0)
  tail call void @llvm.nvvm.cp.async.bulk.tensor.s2g.im2col.3d(ptr addrspace(3) %src, ptr %tmap, i32 %d0, i32 %d1, i32 %d2, i64 %ch, i1 1)
  ret void
}

; CHECK-LABEL: cp_async_bulk_tensor_s2g_4d
define void @cp_async_bulk_tensor_s2g_4d(i32 %flag, ptr addrspace(3) %src, ptr %tmap, i32 %d0, i32 %d1, i32 %d2, i32 %d3, i64 %ch) {
; CHECK-PTX64-LABEL: cp_async_bulk_tensor_s2g_4d(
; CHECK-PTX64:       {
; CHECK-PTX64-NEXT:    .reg .b32 %r<5>;
; CHECK-PTX64-NEXT:    .reg .b64 %rd<4>;
; CHECK-PTX64-EMPTY:
; CHECK-PTX64-NEXT:  // %bb.0:
; CHECK-PTX64-NEXT:    ld.param.u64 %rd1, [cp_async_bulk_tensor_s2g_4d_param_1];
; CHECK-PTX64-NEXT:    ld.param.u64 %rd2, [cp_async_bulk_tensor_s2g_4d_param_2];
; CHECK-PTX64-NEXT:    ld.param.u32 %r1, [cp_async_bulk_tensor_s2g_4d_param_3];
; CHECK-PTX64-NEXT:    ld.param.u32 %r2, [cp_async_bulk_tensor_s2g_4d_param_4];
; CHECK-PTX64-NEXT:    ld.param.u32 %r3, [cp_async_bulk_tensor_s2g_4d_param_5];
; CHECK-PTX64-NEXT:    ld.param.u32 %r4, [cp_async_bulk_tensor_s2g_4d_param_6];
; CHECK-PTX64-NEXT:    cp.async.bulk.tensor.4d.global.shared::cta.tile.bulk_group [%rd2, {%r1, %r2, %r3, %r4}], [%rd1];
; CHECK-PTX64-NEXT:    ld.param.u64 %rd3, [cp_async_bulk_tensor_s2g_4d_param_7];
; CHECK-PTX64-NEXT:    cp.async.bulk.tensor.4d.global.shared::cta.tile.bulk_group.L2::cache_hint [%rd2, {%r1, %r2, %r3, %r4}], [%rd1], %rd3;
; CHECK-PTX64-NEXT:    cp.async.bulk.tensor.4d.global.shared::cta.im2col_no_offs.bulk_group [%rd2, {%r1, %r2, %r3, %r4}], [%rd1];
; CHECK-PTX64-NEXT:    cp.async.bulk.tensor.4d.global.shared::cta.im2col_no_offs.bulk_group.L2::cache_hint [%rd2, {%r1, %r2, %r3, %r4}], [%rd1], %rd3;
; CHECK-PTX64-NEXT:    ret;
;
; CHECK-PTX-SHARED32-LABEL: cp_async_bulk_tensor_s2g_4d(
; CHECK-PTX-SHARED32:       {
; CHECK-PTX-SHARED32-NEXT:    .reg .b32 %r<6>;
; CHECK-PTX-SHARED32-NEXT:    .reg .b64 %rd<3>;
; CHECK-PTX-SHARED32-EMPTY:
; CHECK-PTX-SHARED32-NEXT:  // %bb.0:
; CHECK-PTX-SHARED32-NEXT:    ld.param.u32 %r1, [cp_async_bulk_tensor_s2g_4d_param_1];
; CHECK-PTX-SHARED32-NEXT:    ld.param.u64 %rd1, [cp_async_bulk_tensor_s2g_4d_param_2];
; CHECK-PTX-SHARED32-NEXT:    ld.param.u32 %r2, [cp_async_bulk_tensor_s2g_4d_param_3];
; CHECK-PTX-SHARED32-NEXT:    ld.param.u32 %r3, [cp_async_bulk_tensor_s2g_4d_param_4];
; CHECK-PTX-SHARED32-NEXT:    ld.param.u32 %r4, [cp_async_bulk_tensor_s2g_4d_param_5];
; CHECK-PTX-SHARED32-NEXT:    ld.param.u32 %r5, [cp_async_bulk_tensor_s2g_4d_param_6];
; CHECK-PTX-SHARED32-NEXT:    cp.async.bulk.tensor.4d.global.shared::cta.tile.bulk_group [%rd1, {%r2, %r3, %r4, %r5}], [%r1];
; CHECK-PTX-SHARED32-NEXT:    ld.param.u64 %rd2, [cp_async_bulk_tensor_s2g_4d_param_7];
; CHECK-PTX-SHARED32-NEXT:    cp.async.bulk.tensor.4d.global.shared::cta.tile.bulk_group.L2::cache_hint [%rd1, {%r2, %r3, %r4, %r5}], [%r1], %rd2;
; CHECK-PTX-SHARED32-NEXT:    cp.async.bulk.tensor.4d.global.shared::cta.im2col_no_offs.bulk_group [%rd1, {%r2, %r3, %r4, %r5}], [%r1];
; CHECK-PTX-SHARED32-NEXT:    cp.async.bulk.tensor.4d.global.shared::cta.im2col_no_offs.bulk_group.L2::cache_hint [%rd1, {%r2, %r3, %r4, %r5}], [%r1], %rd2;
; CHECK-PTX-SHARED32-NEXT:    ret;
  tail call void @llvm.nvvm.cp.async.bulk.tensor.s2g.tile.4d(ptr addrspace(3) %src, ptr %tmap, i32 %d0, i32 %d1, i32 %d2, i32 %d3, i64 undef, i1 0)
  tail call void @llvm.nvvm.cp.async.bulk.tensor.s2g.tile.4d(ptr addrspace(3) %src, ptr %tmap, i32 %d0, i32 %d1, i32 %d2, i32 %d3, i64 %ch, i1 1)

  tail call void @llvm.nvvm.cp.async.bulk.tensor.s2g.im2col.4d(ptr addrspace(3) %src, ptr %tmap, i32 %d0, i32 %d1, i32 %d2, i32 %d3, i64 undef, i1 0)
  tail call void @llvm.nvvm.cp.async.bulk.tensor.s2g.im2col.4d(ptr addrspace(3) %src, ptr %tmap, i32 %d0, i32 %d1, i32 %d2, i32 %d3, i64 %ch, i1 1)
  ret void
}

; CHECK-LABEL: cp_async_bulk_tensor_s2g_5d
define void @cp_async_bulk_tensor_s2g_5d(i32 %flag, ptr addrspace(3) %src, ptr %tmap, i32 %d0, i32 %d1, i32 %d2, i32 %d3, i32 %d4, i64 %ch) {
; CHECK-PTX64-LABEL: cp_async_bulk_tensor_s2g_5d(
; CHECK-PTX64:       {
; CHECK-PTX64-NEXT:    .reg .b32 %r<6>;
; CHECK-PTX64-NEXT:    .reg .b64 %rd<4>;
; CHECK-PTX64-EMPTY:
; CHECK-PTX64-NEXT:  // %bb.0:
; CHECK-PTX64-NEXT:    ld.param.u64 %rd1, [cp_async_bulk_tensor_s2g_5d_param_1];
; CHECK-PTX64-NEXT:    ld.param.u64 %rd2, [cp_async_bulk_tensor_s2g_5d_param_2];
; CHECK-PTX64-NEXT:    ld.param.u32 %r1, [cp_async_bulk_tensor_s2g_5d_param_3];
; CHECK-PTX64-NEXT:    ld.param.u32 %r2, [cp_async_bulk_tensor_s2g_5d_param_4];
; CHECK-PTX64-NEXT:    ld.param.u32 %r3, [cp_async_bulk_tensor_s2g_5d_param_5];
; CHECK-PTX64-NEXT:    ld.param.u32 %r4, [cp_async_bulk_tensor_s2g_5d_param_6];
; CHECK-PTX64-NEXT:    ld.param.u32 %r5, [cp_async_bulk_tensor_s2g_5d_param_7];
; CHECK-PTX64-NEXT:    cp.async.bulk.tensor.5d.global.shared::cta.tile.bulk_group [%rd2, {%r1, %r2, %r3, %r4, %r5}], [%rd1];
; CHECK-PTX64-NEXT:    ld.param.u64 %rd3, [cp_async_bulk_tensor_s2g_5d_param_8];
; CHECK-PTX64-NEXT:    cp.async.bulk.tensor.5d.global.shared::cta.tile.bulk_group.L2::cache_hint [%rd2, {%r1, %r2, %r3, %r4, %r5}], [%rd1], %rd3;
; CHECK-PTX64-NEXT:    cp.async.bulk.tensor.5d.global.shared::cta.im2col_no_offs.bulk_group [%rd2, {%r1, %r2, %r3, %r4, %r5}], [%rd1];
; CHECK-PTX64-NEXT:    cp.async.bulk.tensor.5d.global.shared::cta.im2col_no_offs.bulk_group.L2::cache_hint [%rd2, {%r1, %r2, %r3, %r4, %r5}], [%rd1], %rd3;
; CHECK-PTX64-NEXT:    ret;
;
; CHECK-PTX-SHARED32-LABEL: cp_async_bulk_tensor_s2g_5d(
; CHECK-PTX-SHARED32:       {
; CHECK-PTX-SHARED32-NEXT:    .reg .b32 %r<7>;
; CHECK-PTX-SHARED32-NEXT:    .reg .b64 %rd<3>;
; CHECK-PTX-SHARED32-EMPTY:
; CHECK-PTX-SHARED32-NEXT:  // %bb.0:
; CHECK-PTX-SHARED32-NEXT:    ld.param.u32 %r1, [cp_async_bulk_tensor_s2g_5d_param_1];
; CHECK-PTX-SHARED32-NEXT:    ld.param.u64 %rd1, [cp_async_bulk_tensor_s2g_5d_param_2];
; CHECK-PTX-SHARED32-NEXT:    ld.param.u32 %r2, [cp_async_bulk_tensor_s2g_5d_param_3];
; CHECK-PTX-SHARED32-NEXT:    ld.param.u32 %r3, [cp_async_bulk_tensor_s2g_5d_param_4];
; CHECK-PTX-SHARED32-NEXT:    ld.param.u32 %r4, [cp_async_bulk_tensor_s2g_5d_param_5];
; CHECK-PTX-SHARED32-NEXT:    ld.param.u32 %r5, [cp_async_bulk_tensor_s2g_5d_param_6];
; CHECK-PTX-SHARED32-NEXT:    ld.param.u32 %r6, [cp_async_bulk_tensor_s2g_5d_param_7];
; CHECK-PTX-SHARED32-NEXT:    cp.async.bulk.tensor.5d.global.shared::cta.tile.bulk_group [%rd1, {%r2, %r3, %r4, %r5, %r6}], [%r1];
; CHECK-PTX-SHARED32-NEXT:    ld.param.u64 %rd2, [cp_async_bulk_tensor_s2g_5d_param_8];
; CHECK-PTX-SHARED32-NEXT:    cp.async.bulk.tensor.5d.global.shared::cta.tile.bulk_group.L2::cache_hint [%rd1, {%r2, %r3, %r4, %r5, %r6}], [%r1], %rd2;
; CHECK-PTX-SHARED32-NEXT:    cp.async.bulk.tensor.5d.global.shared::cta.im2col_no_offs.bulk_group [%rd1, {%r2, %r3, %r4, %r5, %r6}], [%r1];
; CHECK-PTX-SHARED32-NEXT:    cp.async.bulk.tensor.5d.global.shared::cta.im2col_no_offs.bulk_group.L2::cache_hint [%rd1, {%r2, %r3, %r4, %r5, %r6}], [%r1], %rd2;
; CHECK-PTX-SHARED32-NEXT:    ret;
  tail call void @llvm.nvvm.cp.async.bulk.tensor.s2g.tile.5d(ptr addrspace(3) %src, ptr %tmap, i32 %d0, i32 %d1, i32 %d2, i32 %d3, i32 %d4, i64 undef, i1 0)
  tail call void @llvm.nvvm.cp.async.bulk.tensor.s2g.tile.5d(ptr addrspace(3) %src, ptr %tmap, i32 %d0, i32 %d1, i32 %d2, i32 %d3, i32 %d4, i64 %ch, i1 1)

  tail call void @llvm.nvvm.cp.async.bulk.tensor.s2g.im2col.5d(ptr addrspace(3) %src, ptr %tmap, i32 %d0, i32 %d1, i32 %d2, i32 %d3, i32 %d4, i64 undef, i1 0)
  tail call void @llvm.nvvm.cp.async.bulk.tensor.s2g.im2col.5d(ptr addrspace(3) %src, ptr %tmap, i32 %d0, i32 %d1, i32 %d2, i32 %d3, i32 %d4, i64 %ch, i1 1)
  ret void
}
