; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -passes=instsimplify %s | FileCheck %s

define float @sitofp_floor(i32 %arg) {
; CHECK-LABEL: @sitofp_floor(
; CHECK-NEXT:    [[CVT:%.*]] = sitofp i32 [[ARG:%.*]] to float
; CHECK-NEXT:    ret float [[CVT]]
;
  %cvt = sitofp i32 %arg to float
  %round = call float @llvm.floor.f32(float %cvt)
  ret float %round
}

define float @uitofp_floor(i32 %arg) {
; CHECK-LABEL: @uitofp_floor(
; CHECK-NEXT:    [[CVT:%.*]] = uitofp i32 [[ARG:%.*]] to float
; CHECK-NEXT:    ret float [[CVT]]
;
  %cvt = uitofp i32 %arg to float
  %round = call float @llvm.floor.f32(float %cvt)
  ret float %round
}

define float @sitofp_trunc(i32 %arg) {
; CHECK-LABEL: @sitofp_trunc(
; CHECK-NEXT:    [[CVT:%.*]] = sitofp i32 [[ARG:%.*]] to float
; CHECK-NEXT:    ret float [[CVT]]
;
  %cvt = sitofp i32 %arg to float
  %round = call float @llvm.trunc.f32(float %cvt)
  ret float %round
}

define float @uitofp_trunc(i32 %arg) {
; CHECK-LABEL: @uitofp_trunc(
; CHECK-NEXT:    [[CVT:%.*]] = uitofp i32 [[ARG:%.*]] to float
; CHECK-NEXT:    ret float [[CVT]]
;
  %cvt = uitofp i32 %arg to float
  %round = call float @llvm.trunc.f32(float %cvt)
  ret float %round
}

define float @sitofp_ceil(i32 %arg) {
; CHECK-LABEL: @sitofp_ceil(
; CHECK-NEXT:    [[CVT:%.*]] = sitofp i32 [[ARG:%.*]] to float
; CHECK-NEXT:    ret float [[CVT]]
;
  %cvt = sitofp i32 %arg to float
  %round = call float @llvm.ceil.f32(float %cvt)
  ret float %round
}

define float @uitofp_ceil(i32 %arg) {
; CHECK-LABEL: @uitofp_ceil(
; CHECK-NEXT:    [[CVT:%.*]] = uitofp i32 [[ARG:%.*]] to float
; CHECK-NEXT:    ret float [[CVT]]
;
  %cvt = uitofp i32 %arg to float
  %round = call float @llvm.ceil.f32(float %cvt)
  ret float %round
}

define float @sitofp_round(i32 %arg) {
; CHECK-LABEL: @sitofp_round(
; CHECK-NEXT:    [[CVT:%.*]] = sitofp i32 [[ARG:%.*]] to float
; CHECK-NEXT:    ret float [[CVT]]
;
  %cvt = sitofp i32 %arg to float
  %round = call float @llvm.round.f32(float %cvt)
  ret float %round
}

define float @uitofp_round(i32 %arg) {
; CHECK-LABEL: @uitofp_round(
; CHECK-NEXT:    [[CVT:%.*]] = uitofp i32 [[ARG:%.*]] to float
; CHECK-NEXT:    ret float [[CVT]]
;
  %cvt = uitofp i32 %arg to float
  %round = call float @llvm.round.f32(float %cvt)
  ret float %round
}

define float @uitofp_roundeven(i32 %arg) {
; CHECK-LABEL: @uitofp_roundeven(
; CHECK-NEXT:    [[CVT:%.*]] = uitofp i32 [[ARG:%.*]] to float
; CHECK-NEXT:    ret float [[CVT]]
;
  %cvt = uitofp i32 %arg to float
  %round = call float @llvm.roundeven.f32(float %cvt)
  ret float %round
}

define float @sitofp_nearbyint(i32 %arg) {
; CHECK-LABEL: @sitofp_nearbyint(
; CHECK-NEXT:    [[CVT:%.*]] = sitofp i32 [[ARG:%.*]] to float
; CHECK-NEXT:    ret float [[CVT]]
;
  %cvt = sitofp i32 %arg to float
  %nearbyint = call float @llvm.nearbyint.f32(float %cvt)
  ret float %nearbyint
}

define float @uitofp_nearbyint(i32 %arg) {
; CHECK-LABEL: @uitofp_nearbyint(
; CHECK-NEXT:    [[CVT:%.*]] = uitofp i32 [[ARG:%.*]] to float
; CHECK-NEXT:    ret float [[CVT]]
;
  %cvt = uitofp i32 %arg to float
  %nearbyint = call float @llvm.nearbyint.f32(float %cvt)
  ret float %nearbyint
}

define float @sitofp_rint(i32 %arg) {
; CHECK-LABEL: @sitofp_rint(
; CHECK-NEXT:    [[CVT:%.*]] = sitofp i32 [[ARG:%.*]] to float
; CHECK-NEXT:    ret float [[CVT]]
;
  %cvt = sitofp i32 %arg to float
  %rint = call float @llvm.rint.f32(float %cvt)
  ret float %rint
}

define float @uitofp_rint(i32 %arg) {
; CHECK-LABEL: @uitofp_rint(
; CHECK-NEXT:    [[CVT:%.*]] = uitofp i32 [[ARG:%.*]] to float
; CHECK-NEXT:    ret float [[CVT]]
;
  %cvt = uitofp i32 %arg to float
  %rint = call float @llvm.rint.f32(float %cvt)
  ret float %rint
}

define float @floor_trunc(float %x) {
; CHECK-LABEL: @floor_trunc(
; CHECK-NEXT:    [[A:%.*]] = call float @llvm.floor.f32(float [[X:%.*]])
; CHECK-NEXT:    ret float [[A]]
;
  %a = call float @llvm.floor.f32(float %x)
  %r = call float @llvm.trunc.f32(float %a)
  ret float %r
}

define float @floor_ceil(float %x) {
; CHECK-LABEL: @floor_ceil(
; CHECK-NEXT:    [[A:%.*]] = call float @llvm.floor.f32(float [[X:%.*]])
; CHECK-NEXT:    ret float [[A]]
;
  %a = call float @llvm.floor.f32(float %x)
  %r = call float @llvm.ceil.f32(float %a)
  ret float %r
}

define float @floor_round(float %x) {
; CHECK-LABEL: @floor_round(
; CHECK-NEXT:    [[A:%.*]] = call float @llvm.floor.f32(float [[X:%.*]])
; CHECK-NEXT:    ret float [[A]]
;
  %a = call float @llvm.floor.f32(float %x)
  %r = call float @llvm.round.f32(float %a)
  ret float %r
}

define float @floor_roundeven(float %x) {
; CHECK-LABEL: @floor_roundeven(
; CHECK-NEXT:    [[A:%.*]] = call float @llvm.floor.f32(float [[X:%.*]])
; CHECK-NEXT:    ret float [[A]]
;
  %a = call float @llvm.floor.f32(float %x)
  %r = call float @llvm.roundeven.f32(float %a)
  ret float %r
}

define float @floor_nearbyint(float %x) {
; CHECK-LABEL: @floor_nearbyint(
; CHECK-NEXT:    [[A:%.*]] = call float @llvm.floor.f32(float [[X:%.*]])
; CHECK-NEXT:    ret float [[A]]
;
  %a = call float @llvm.floor.f32(float %x)
  %r = call float @llvm.nearbyint.f32(float %a)
  ret float %r
}

define float @floor_rint(float %x) {
; CHECK-LABEL: @floor_rint(
; CHECK-NEXT:    [[A:%.*]] = call float @llvm.floor.f32(float [[X:%.*]])
; CHECK-NEXT:    ret float [[A]]
;
  %a = call float @llvm.floor.f32(float %x)
  %r = call float @llvm.rint.f32(float %a)
  ret float %r
}

define float @trunc_floor(float %x) {
; CHECK-LABEL: @trunc_floor(
; CHECK-NEXT:    [[A:%.*]] = call float @llvm.trunc.f32(float [[X:%.*]])
; CHECK-NEXT:    ret float [[A]]
;
  %a = call float @llvm.trunc.f32(float %x)
  %r = call float @llvm.floor.f32(float %a)
  ret float %r
}

define float @trunc_ceil(float %x) {
; CHECK-LABEL: @trunc_ceil(
; CHECK-NEXT:    [[A:%.*]] = call float @llvm.trunc.f32(float [[X:%.*]])
; CHECK-NEXT:    ret float [[A]]
;
  %a = call float @llvm.trunc.f32(float %x)
  %r = call float @llvm.ceil.f32(float %a)
  ret float %r
}

define float @trunc_round(float %x) {
; CHECK-LABEL: @trunc_round(
; CHECK-NEXT:    [[A:%.*]] = call float @llvm.trunc.f32(float [[X:%.*]])
; CHECK-NEXT:    ret float [[A]]
;
  %a = call float @llvm.trunc.f32(float %x)
  %r = call float @llvm.round.f32(float %a)
  ret float %r
}

define float @trunc_roundeven(float %x) {
; CHECK-LABEL: @trunc_roundeven(
; CHECK-NEXT:    [[A:%.*]] = call float @llvm.trunc.f32(float [[X:%.*]])
; CHECK-NEXT:    ret float [[A]]
;
  %a = call float @llvm.trunc.f32(float %x)
  %r = call float @llvm.roundeven.f32(float %a)
  ret float %r
}

define float @trunc_nearbyint(float %x) {
; CHECK-LABEL: @trunc_nearbyint(
; CHECK-NEXT:    [[A:%.*]] = call float @llvm.trunc.f32(float [[X:%.*]])
; CHECK-NEXT:    ret float [[A]]
;
  %a = call float @llvm.trunc.f32(float %x)
  %r = call float @llvm.nearbyint.f32(float %a)
  ret float %r
}

define float @trunc_rint(float %x) {
; CHECK-LABEL: @trunc_rint(
; CHECK-NEXT:    [[A:%.*]] = call float @llvm.trunc.f32(float [[X:%.*]])
; CHECK-NEXT:    ret float [[A]]
;
  %a = call float @llvm.trunc.f32(float %x)
  %r = call float @llvm.rint.f32(float %a)
  ret float %r
}

define float @ceil_floor(float %x) {
; CHECK-LABEL: @ceil_floor(
; CHECK-NEXT:    [[A:%.*]] = call float @llvm.ceil.f32(float [[X:%.*]])
; CHECK-NEXT:    ret float [[A]]
;
  %a = call float @llvm.ceil.f32(float %x)
  %r = call float @llvm.floor.f32(float %a)
  ret float %r
}

define float @ceil_trunc(float %x) {
; CHECK-LABEL: @ceil_trunc(
; CHECK-NEXT:    [[A:%.*]] = call float @llvm.ceil.f32(float [[X:%.*]])
; CHECK-NEXT:    ret float [[A]]
;
  %a = call float @llvm.ceil.f32(float %x)
  %r = call float @llvm.trunc.f32(float %a)
  ret float %r
}

define float @ceil_round(float %x) {
; CHECK-LABEL: @ceil_round(
; CHECK-NEXT:    [[A:%.*]] = call float @llvm.ceil.f32(float [[X:%.*]])
; CHECK-NEXT:    ret float [[A]]
;
  %a = call float @llvm.ceil.f32(float %x)
  %r = call float @llvm.round.f32(float %a)
  ret float %r
}

define float @ceil_roundeven(float %x) {
; CHECK-LABEL: @ceil_roundeven(
; CHECK-NEXT:    [[A:%.*]] = call float @llvm.ceil.f32(float [[X:%.*]])
; CHECK-NEXT:    ret float [[A]]
;
  %a = call float @llvm.ceil.f32(float %x)
  %r = call float @llvm.roundeven.f32(float %a)
  ret float %r
}

define float @ceil_nearbyint(float %x) {
; CHECK-LABEL: @ceil_nearbyint(
; CHECK-NEXT:    [[A:%.*]] = call float @llvm.ceil.f32(float [[X:%.*]])
; CHECK-NEXT:    ret float [[A]]
;
  %a = call float @llvm.ceil.f32(float %x)
  %r = call float @llvm.nearbyint.f32(float %a)
  ret float %r
}

define float @ceil_rint(float %x) {
; CHECK-LABEL: @ceil_rint(
; CHECK-NEXT:    [[A:%.*]] = call float @llvm.ceil.f32(float [[X:%.*]])
; CHECK-NEXT:    ret float [[A]]
;
  %a = call float @llvm.ceil.f32(float %x)
  %r = call float @llvm.rint.f32(float %a)
  ret float %r
}

define float @round_floor(float %x) {
; CHECK-LABEL: @round_floor(
; CHECK-NEXT:    [[A:%.*]] = call float @llvm.round.f32(float [[X:%.*]])
; CHECK-NEXT:    ret float [[A]]
;
  %a = call float @llvm.round.f32(float %x)
  %r = call float @llvm.floor.f32(float %a)
  ret float %r
}

define float @round_trunc(float %x) {
; CHECK-LABEL: @round_trunc(
; CHECK-NEXT:    [[A:%.*]] = call float @llvm.round.f32(float [[X:%.*]])
; CHECK-NEXT:    ret float [[A]]
;
  %a = call float @llvm.round.f32(float %x)
  %r = call float @llvm.trunc.f32(float %a)
  ret float %r
}

define float @round_ceil(float %x) {
; CHECK-LABEL: @round_ceil(
; CHECK-NEXT:    [[A:%.*]] = call float @llvm.round.f32(float [[X:%.*]])
; CHECK-NEXT:    ret float [[A]]
;
  %a = call float @llvm.round.f32(float %x)
  %r = call float @llvm.ceil.f32(float %a)
  ret float %r
}

define float @round_roundeven(float %x) {
; CHECK-LABEL: @round_roundeven(
; CHECK-NEXT:    [[A:%.*]] = call float @llvm.round.f32(float [[X:%.*]])
; CHECK-NEXT:    ret float [[A]]
;
  %a = call float @llvm.round.f32(float %x)
  %r = call float @llvm.roundeven.f32(float %a)
  ret float %r
}

define float @round_nearbyint(float %x) {
; CHECK-LABEL: @round_nearbyint(
; CHECK-NEXT:    [[A:%.*]] = call float @llvm.round.f32(float [[X:%.*]])
; CHECK-NEXT:    ret float [[A]]
;
  %a = call float @llvm.round.f32(float %x)
  %r = call float @llvm.nearbyint.f32(float %a)
  ret float %r
}

define float @round_rint(float %x) {
; CHECK-LABEL: @round_rint(
; CHECK-NEXT:    [[A:%.*]] = call float @llvm.round.f32(float [[X:%.*]])
; CHECK-NEXT:    ret float [[A]]
;
  %a = call float @llvm.round.f32(float %x)
  %r = call float @llvm.rint.f32(float %a)
  ret float %r
}

define float @roundeven_floor(float %x) {
; CHECK-LABEL: @roundeven_floor(
; CHECK-NEXT:    [[A:%.*]] = call float @llvm.roundeven.f32(float [[X:%.*]])
; CHECK-NEXT:    ret float [[A]]
;
  %a = call float @llvm.roundeven.f32(float %x)
  %r = call float @llvm.floor.f32(float %a)
  ret float %r
}

define float @roundeven_trunc(float %x) {
; CHECK-LABEL: @roundeven_trunc(
; CHECK-NEXT:    [[A:%.*]] = call float @llvm.roundeven.f32(float [[X:%.*]])
; CHECK-NEXT:    ret float [[A]]
;
  %a = call float @llvm.roundeven.f32(float %x)
  %r = call float @llvm.trunc.f32(float %a)
  ret float %r
}

define float @roundeven_ceil(float %x) {
; CHECK-LABEL: @roundeven_ceil(
; CHECK-NEXT:    [[A:%.*]] = call float @llvm.roundeven.f32(float [[X:%.*]])
; CHECK-NEXT:    ret float [[A]]
;
  %a = call float @llvm.roundeven.f32(float %x)
  %r = call float @llvm.ceil.f32(float %a)
  ret float %r
}

define float @roundeven_round(float %x) {
; CHECK-LABEL: @roundeven_round(
; CHECK-NEXT:    [[A:%.*]] = call float @llvm.roundeven.f32(float [[X:%.*]])
; CHECK-NEXT:    ret float [[A]]
;
  %a = call float @llvm.roundeven.f32(float %x)
  %r = call float @llvm.round.f32(float %a)
  ret float %r
}

define float @roundeven_nearbyint(float %x) {
; CHECK-LABEL: @roundeven_nearbyint(
; CHECK-NEXT:    [[A:%.*]] = call float @llvm.roundeven.f32(float [[X:%.*]])
; CHECK-NEXT:    ret float [[A]]
;
  %a = call float @llvm.roundeven.f32(float %x)
  %r = call float @llvm.nearbyint.f32(float %a)
  ret float %r
}

define float @roundeven_rint(float %x) {
; CHECK-LABEL: @roundeven_rint(
; CHECK-NEXT:    [[A:%.*]] = call float @llvm.roundeven.f32(float [[X:%.*]])
; CHECK-NEXT:    ret float [[A]]
;
  %a = call float @llvm.roundeven.f32(float %x)
  %r = call float @llvm.rint.f32(float %a)
  ret float %r
}

define float @nearbyint_floor(float %x) {
; CHECK-LABEL: @nearbyint_floor(
; CHECK-NEXT:    [[A:%.*]] = call float @llvm.nearbyint.f32(float [[X:%.*]])
; CHECK-NEXT:    ret float [[A]]
;
  %a = call float @llvm.nearbyint.f32(float %x)
  %r = call float @llvm.floor.f32(float %a)
  ret float %r
}

define float @nearbyint_trunc(float %x) {
; CHECK-LABEL: @nearbyint_trunc(
; CHECK-NEXT:    [[A:%.*]] = call float @llvm.nearbyint.f32(float [[X:%.*]])
; CHECK-NEXT:    ret float [[A]]
;
  %a = call float @llvm.nearbyint.f32(float %x)
  %r = call float @llvm.trunc.f32(float %a)
  ret float %r
}

define float @nearbyint_ceil(float %x) {
; CHECK-LABEL: @nearbyint_ceil(
; CHECK-NEXT:    [[A:%.*]] = call float @llvm.nearbyint.f32(float [[X:%.*]])
; CHECK-NEXT:    ret float [[A]]
;
  %a = call float @llvm.nearbyint.f32(float %x)
  %r = call float @llvm.ceil.f32(float %a)
  ret float %r
}

define float @nearbyint_round(float %x) {
; CHECK-LABEL: @nearbyint_round(
; CHECK-NEXT:    [[A:%.*]] = call float @llvm.nearbyint.f32(float [[X:%.*]])
; CHECK-NEXT:    ret float [[A]]
;
  %a = call float @llvm.nearbyint.f32(float %x)
  %r = call float @llvm.round.f32(float %a)
  ret float %r
}

define float @nearbyint_roundeven(float %x) {
; CHECK-LABEL: @nearbyint_roundeven(
; CHECK-NEXT:    [[A:%.*]] = call float @llvm.nearbyint.f32(float [[X:%.*]])
; CHECK-NEXT:    ret float [[A]]
;
  %a = call float @llvm.nearbyint.f32(float %x)
  %r = call float @llvm.roundeven.f32(float %a)
  ret float %r
}

define float @nearbyint_rint(float %x) {
; CHECK-LABEL: @nearbyint_rint(
; CHECK-NEXT:    [[A:%.*]] = call float @llvm.nearbyint.f32(float [[X:%.*]])
; CHECK-NEXT:    ret float [[A]]
;
  %a = call float @llvm.nearbyint.f32(float %x)
  %r = call float @llvm.rint.f32(float %a)
  ret float %r
}

define float @rint_floor(float %x) {
; CHECK-LABEL: @rint_floor(
; CHECK-NEXT:    [[A:%.*]] = call float @llvm.rint.f32(float [[X:%.*]])
; CHECK-NEXT:    ret float [[A]]
;
  %a = call float @llvm.rint.f32(float %x)
  %r = call float @llvm.floor.f32(float %a)
  ret float %r
}

define float @rint_trunc(float %x) {
; CHECK-LABEL: @rint_trunc(
; CHECK-NEXT:    [[A:%.*]] = call float @llvm.rint.f32(float [[X:%.*]])
; CHECK-NEXT:    ret float [[A]]
;
  %a = call float @llvm.rint.f32(float %x)
  %r = call float @llvm.trunc.f32(float %a)
  ret float %r
}

define float @rint_ceil(float %x) {
; CHECK-LABEL: @rint_ceil(
; CHECK-NEXT:    [[A:%.*]] = call float @llvm.rint.f32(float [[X:%.*]])
; CHECK-NEXT:    ret float [[A]]
;
  %a = call float @llvm.rint.f32(float %x)
  %r = call float @llvm.ceil.f32(float %a)
  ret float %r
}

define float @rint_round(float %x) {
; CHECK-LABEL: @rint_round(
; CHECK-NEXT:    [[A:%.*]] = call float @llvm.rint.f32(float [[X:%.*]])
; CHECK-NEXT:    ret float [[A]]
;
  %a = call float @llvm.rint.f32(float %x)
  %r = call float @llvm.round.f32(float %a)
  ret float %r
}

define float @rint_roundeven(float %x) {
; CHECK-LABEL: @rint_roundeven(
; CHECK-NEXT:    [[A:%.*]] = call float @llvm.rint.f32(float [[X:%.*]])
; CHECK-NEXT:    ret float [[A]]
;
  %a = call float @llvm.rint.f32(float %x)
  %r = call float @llvm.roundeven.f32(float %a)
  ret float %r
}

define float @rint_nearbyint(float %x) {
; CHECK-LABEL: @rint_nearbyint(
; CHECK-NEXT:    [[A:%.*]] = call float @llvm.rint.f32(float [[X:%.*]])
; CHECK-NEXT:    ret float [[A]]
;
  %a = call float @llvm.rint.f32(float %x)
  %r = call float @llvm.nearbyint.f32(float %a)
  ret float %r
}

declare float @llvm.floor.f32(float) #0
declare float @llvm.trunc.f32(float) #0
declare float @llvm.ceil.f32(float) #0
declare float @llvm.round.f32(float) #0
declare float @llvm.roundeven.f32(float) #0
declare float @llvm.nearbyint.f32(float) #0
declare float @llvm.rint.f32(float) #0

attributes #0 = { nounwind readnone speculatable }
