; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:     -mcpu=pwr8 -ppc-asm-full-reg-names < %s | FileCheck %s
define dso_local <4 x i32> @test(<4 x i32> %a, <4 x i32> %b, <4 x i32> %c) {
; CHECK-LABEL: test:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxsel vs34, vs34, vs35, vs36
; CHECK-NEXT:    blr
entry:
  %neg.i = xor <4 x i32> %c, <i32 -1, i32 -1, i32 -1, i32 -1>
  %and.i = and <4 x i32> %neg.i, %a
  %and1.i = and <4 x i32> %c, %b
  %or.i = or <4 x i32> %and1.i, %and.i
  ret <4 x i32> %or.i
}

define dso_local <8 x i16> @test2(<8 x i16> %a, <8 x i16> %b, <8 x i16> %c) {
; CHECK-LABEL: test2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxsel vs34, vs34, vs35, vs36
; CHECK-NEXT:    blr
entry:
  %neg.i = xor <8 x i16> %c, <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>
  %and.i = and <8 x i16> %a, %neg.i
  %and1.i = and <8 x i16> %c, %b
  %or.i = or <8 x i16> %and.i, %and1.i
  ret <8 x i16> %or.i
}

define dso_local <16 x i8> @test3(<16 x i8> %a, <16 x i8> %b, <16 x i8> %c) {
; CHECK-LABEL: test3:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxsel vs34, vs34, vs35, vs36
; CHECK-NEXT:    blr
entry:
  %neg.i = xor <16 x i8> %c, <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>
  %and.i = and <16 x i8> %neg.i, %a
  %and1.i = and <16 x i8> %c, %b
  %or.i = or <16 x i8> %and.i, %and1.i
  ret <16 x i8> %or.i
}

define dso_local <2 x i64> @test4(<2 x i64> %a, <2 x i64> %b, <2 x i64> %c) {
; CHECK-LABEL: test4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxsel vs34, vs34, vs35, vs36
; CHECK-NEXT:    blr
entry:
  %neg.i = xor <2 x i64> %c, <i64 -1, i64 -1>
  %and.i = and <2 x i64> %a, %neg.i
  %and1.i = and <2 x i64> %c, %b
  %or.i = or <2 x i64> %and.i, %and1.i
  ret <2 x i64> %or.i
}

; vXi1 constants are sign-extended to preserve XXSEL pattern.
define dso_local <4 x i1> @test5(<4 x i1> %a, <4 x i1> %b, <4 x i1> %c) {
; CHECK-LABEL: test5:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxsel vs34, vs34, vs35, vs36
; CHECK-NEXT:    blr
entry:
  %neg.i = xor <4 x i1> %c, <i1 -1, i1 -1, i1 -1, i1 -1>
  %and.i = and <4 x i1> %a, %neg.i
  %and1.i = and <4 x i1> %c, %b
  %or.i = or <4 x i1> %and.i, %and1.i
  ret <4 x i1> %or.i
}
