; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=riscv32 -mattr=+v,m -O2 | FileCheck -check-prefixes=CHECK,RV32 %s
; RUN: llc < %s -mtriple=riscv64 -mattr=+v,m -O2 | FileCheck -check-prefixes=CHECK,RV64 %s

; ------------------------------------------------------------------------------
; Loads
; ------------------------------------------------------------------------------

; FIXME: This should be widened to a vlseg2 of <4 x i32> with VL set to 3
define {<3 x i32>, <3 x i32>} @load_factor2_v3(ptr %ptr) {
; RV32-LABEL: load_factor2_v3:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 6, e32, m2, ta, ma
; RV32-NEXT:    vle32.v v10, (a0)
; RV32-NEXT:    li a0, 32
; RV32-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; RV32-NEXT:    vnsrl.wi v8, v10, 0
; RV32-NEXT:    vnsrl.wx v9, v10, a0
; RV32-NEXT:    ret
;
; RV64-LABEL: load_factor2_v3:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 6, e32, m2, ta, ma
; RV64-NEXT:    vle32.v v10, (a0)
; RV64-NEXT:    li a0, 32
; RV64-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; RV64-NEXT:    vnsrl.wx v9, v10, a0
; RV64-NEXT:    vnsrl.wi v8, v10, 0
; RV64-NEXT:    ret
  %interleaved.vec = load <6 x i32>, ptr %ptr
  %v0 = shufflevector <6 x i32> %interleaved.vec, <6 x i32> poison, <3 x i32> <i32 0, i32 2, i32 4>
  %v1 = shufflevector <6 x i32> %interleaved.vec, <6 x i32> poison, <3 x i32> <i32 1, i32 3, i32 5>
  %res0 = insertvalue {<3 x i32>, <3 x i32>} undef, <3 x i32> %v0, 0
  %res1 = insertvalue {<3 x i32>, <3 x i32>} %res0, <3 x i32> %v1, 1
  ret {<3 x i32>, <3 x i32>} %res1
}

define {<4 x i32>, <4 x i32>} @load_factor2(ptr %ptr) {
; CHECK-LABEL: load_factor2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vlseg2e32.v v8, (a0)
; CHECK-NEXT:    ret
  %interleaved.vec = load <8 x i32>, ptr %ptr
  %v0 = shufflevector <8 x i32> %interleaved.vec, <8 x i32> poison, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
  %v1 = shufflevector <8 x i32> %interleaved.vec, <8 x i32> poison, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
  %res0 = insertvalue {<4 x i32>, <4 x i32>} undef, <4 x i32> %v0, 0
  %res1 = insertvalue {<4 x i32>, <4 x i32>} %res0, <4 x i32> %v1, 1
  ret {<4 x i32>, <4 x i32>} %res1
}


define {<4 x i32>, <4 x i32>, <4 x i32>} @load_factor3(ptr %ptr) {
; CHECK-LABEL: load_factor3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vlseg3e32.v v8, (a0)
; CHECK-NEXT:    ret
  %interleaved.vec = load <12 x i32>, ptr %ptr
  %v0 = shufflevector <12 x i32> %interleaved.vec, <12 x i32> poison, <4 x i32> <i32 0, i32 3, i32 6, i32 9>
  %v1 = shufflevector <12 x i32> %interleaved.vec, <12 x i32> poison, <4 x i32> <i32 1, i32 4, i32 7, i32 10>
  %v2 = shufflevector <12 x i32> %interleaved.vec, <12 x i32> poison, <4 x i32> <i32 2, i32 5, i32 8, i32 11>
  %res0 = insertvalue {<4 x i32>, <4 x i32>, <4 x i32>} undef, <4 x i32> %v0, 0
  %res1 = insertvalue {<4 x i32>, <4 x i32>, <4 x i32>} %res0, <4 x i32> %v1, 1
  %res2 = insertvalue {<4 x i32>, <4 x i32>, <4 x i32>} %res1, <4 x i32> %v2, 2
  ret {<4 x i32>, <4 x i32>, <4 x i32>} %res2
}

define {<4 x i32>, <4 x i32>, <4 x i32>, <4 x i32>} @load_factor4(ptr %ptr) {
; CHECK-LABEL: load_factor4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vlseg4e32.v v8, (a0)
; CHECK-NEXT:    ret
  %interleaved.vec = load <16 x i32>, ptr %ptr
  %v0 = shufflevector <16 x i32> %interleaved.vec, <16 x i32> poison, <4 x i32> <i32 0, i32 4, i32 8, i32 12>
  %v1 = shufflevector <16 x i32> %interleaved.vec, <16 x i32> poison, <4 x i32> <i32 1, i32 5, i32 9, i32 13>
  %v2 = shufflevector <16 x i32> %interleaved.vec, <16 x i32> poison, <4 x i32> <i32 2, i32 6, i32 10, i32 14>
  %v3 = shufflevector <16 x i32> %interleaved.vec, <16 x i32> poison, <4 x i32> <i32 3, i32 7, i32 11, i32 15>
  %res0 = insertvalue {<4 x i32>, <4 x i32>, <4 x i32>, <4 x i32>} undef, <4 x i32> %v0, 0
  %res1 = insertvalue {<4 x i32>, <4 x i32>, <4 x i32>, <4 x i32>} %res0, <4 x i32> %v1, 1
  %res2 = insertvalue {<4 x i32>, <4 x i32>, <4 x i32>, <4 x i32>} %res1, <4 x i32> %v2, 2
  %res3 = insertvalue {<4 x i32>, <4 x i32>, <4 x i32>, <4 x i32>} %res2, <4 x i32> %v3, 3
  ret {<4 x i32>, <4 x i32>, <4 x i32>, <4 x i32>} %res3
}

define {<4 x i32>, <4 x i32>, <4 x i32>, <4 x i32>, <4 x i32>} @load_factor5(ptr %ptr) {
; CHECK-LABEL: load_factor5:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vlseg5e32.v v8, (a0)
; CHECK-NEXT:    ret
  %interleaved.vec = load <20 x i32>, ptr %ptr
  %v0 = shufflevector <20 x i32> %interleaved.vec, <20 x i32> poison, <4 x i32> <i32 0, i32 5, i32 10, i32 15>
  %v1 = shufflevector <20 x i32> %interleaved.vec, <20 x i32> poison, <4 x i32> <i32 1, i32 6, i32 11, i32 16>
  %v2 = shufflevector <20 x i32> %interleaved.vec, <20 x i32> poison, <4 x i32> <i32 2, i32 7, i32 12, i32 17>
  %v3 = shufflevector <20 x i32> %interleaved.vec, <20 x i32> poison, <4 x i32> <i32 3, i32 8, i32 13, i32 18>
  %v4 = shufflevector <20 x i32> %interleaved.vec, <20 x i32> poison, <4 x i32> <i32 4, i32 9, i32 14, i32 19>
  %res0 = insertvalue {<4 x i32>, <4 x i32>, <4 x i32>, <4 x i32>, <4 x i32>} undef, <4 x i32> %v0, 0
  %res1 = insertvalue {<4 x i32>, <4 x i32>, <4 x i32>, <4 x i32>, <4 x i32>} %res0, <4 x i32> %v1, 1
  %res2 = insertvalue {<4 x i32>, <4 x i32>, <4 x i32>, <4 x i32>, <4 x i32>} %res1, <4 x i32> %v2, 2
  %res3 = insertvalue {<4 x i32>, <4 x i32>, <4 x i32>, <4 x i32>, <4 x i32>} %res2, <4 x i32> %v3, 3
  %res4 = insertvalue {<4 x i32>, <4 x i32>, <4 x i32>, <4 x i32>, <4 x i32>} %res3, <4 x i32> %v4, 4
  ret {<4 x i32>, <4 x i32>, <4 x i32>, <4 x i32>, <4 x i32>} %res4
}

define {<2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>} @load_factor6(ptr %ptr) {
; CHECK-LABEL: load_factor6:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vlseg6e16.v v8, (a0)
; CHECK-NEXT:    ret
  %interleaved.vec = load <12 x i16>, ptr %ptr
  %v0 = shufflevector <12 x i16> %interleaved.vec, <12 x i16> poison, <2 x i32> <i32 0, i32 6>
  %v1 = shufflevector <12 x i16> %interleaved.vec, <12 x i16> poison, <2 x i32> <i32 1, i32 7>
  %v2 = shufflevector <12 x i16> %interleaved.vec, <12 x i16> poison, <2 x i32> <i32 2, i32 8>
  %v3 = shufflevector <12 x i16> %interleaved.vec, <12 x i16> poison, <2 x i32> <i32 3, i32 9>
  %v4 = shufflevector <12 x i16> %interleaved.vec, <12 x i16> poison, <2 x i32> <i32 4, i32 10>
  %v5 = shufflevector <12 x i16> %interleaved.vec, <12 x i16> poison, <2 x i32> <i32 5, i32 11>
  %res0 = insertvalue {<2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>} undef, <2 x i16> %v0, 0
  %res1 = insertvalue {<2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>} %res0, <2 x i16> %v1, 1
  %res2 = insertvalue {<2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>} %res1, <2 x i16> %v2, 2
  %res3 = insertvalue {<2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>} %res2, <2 x i16> %v3, 3
  %res4 = insertvalue {<2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>} %res3, <2 x i16> %v4, 4
  %res5 = insertvalue {<2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>} %res4, <2 x i16> %v5, 5
  ret {<2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>} %res5
}

define {<2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>} @load_factor7(ptr %ptr) {
; CHECK-LABEL: load_factor7:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vlseg7e16.v v8, (a0)
; CHECK-NEXT:    ret
  %interleaved.vec = load <14 x i16>, ptr %ptr
  %v0 = shufflevector <14 x i16> %interleaved.vec, <14 x i16> poison, <2 x i32> <i32 0, i32 7>
  %v1 = shufflevector <14 x i16> %interleaved.vec, <14 x i16> poison, <2 x i32> <i32 1, i32 8>
  %v2 = shufflevector <14 x i16> %interleaved.vec, <14 x i16> poison, <2 x i32> <i32 2, i32 9>
  %v3 = shufflevector <14 x i16> %interleaved.vec, <14 x i16> poison, <2 x i32> <i32 3, i32 10>
  %v4 = shufflevector <14 x i16> %interleaved.vec, <14 x i16> poison, <2 x i32> <i32 4, i32 11>
  %v5 = shufflevector <14 x i16> %interleaved.vec, <14 x i16> poison, <2 x i32> <i32 5, i32 12>
  %v6 = shufflevector <14 x i16> %interleaved.vec, <14 x i16> poison, <2 x i32> <i32 6, i32 13>
  %res0 = insertvalue {<2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>} undef, <2 x i16> %v0, 0
  %res1 = insertvalue {<2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>} %res0, <2 x i16> %v1, 1
  %res2 = insertvalue {<2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>} %res1, <2 x i16> %v2, 2
  %res3 = insertvalue {<2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>} %res2, <2 x i16> %v3, 3
  %res4 = insertvalue {<2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>} %res3, <2 x i16> %v4, 4
  %res5 = insertvalue {<2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>} %res4, <2 x i16> %v5, 5
  %res6 = insertvalue {<2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>} %res5, <2 x i16> %v6, 6
  ret {<2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>} %res6
}

define {<2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>} @load_factor8(ptr %ptr) {
; CHECK-LABEL: load_factor8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vlseg8e16.v v8, (a0)
; CHECK-NEXT:    ret
  %interleaved.vec = load <16 x i16>, ptr %ptr
  %v0 = shufflevector <16 x i16> %interleaved.vec, <16 x i16> poison, <2 x i32> <i32 0, i32 8>
  %v1 = shufflevector <16 x i16> %interleaved.vec, <16 x i16> poison, <2 x i32> <i32 1, i32 9>
  %v2 = shufflevector <16 x i16> %interleaved.vec, <16 x i16> poison, <2 x i32> <i32 2, i32 10>
  %v3 = shufflevector <16 x i16> %interleaved.vec, <16 x i16> poison, <2 x i32> <i32 3, i32 11>
  %v4 = shufflevector <16 x i16> %interleaved.vec, <16 x i16> poison, <2 x i32> <i32 4, i32 12>
  %v5 = shufflevector <16 x i16> %interleaved.vec, <16 x i16> poison, <2 x i32> <i32 5, i32 13>
  %v6 = shufflevector <16 x i16> %interleaved.vec, <16 x i16> poison, <2 x i32> <i32 6, i32 14>
  %v7 = shufflevector <16 x i16> %interleaved.vec, <16 x i16> poison, <2 x i32> <i32 7, i32 15>
  %res0 = insertvalue {<2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>} undef, <2 x i16> %v0, 0
  %res1 = insertvalue {<2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>} %res0, <2 x i16> %v1, 1
  %res2 = insertvalue {<2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>} %res1, <2 x i16> %v2, 2
  %res3 = insertvalue {<2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>} %res2, <2 x i16> %v3, 3
  %res4 = insertvalue {<2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>} %res3, <2 x i16> %v4, 4
  %res5 = insertvalue {<2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>} %res4, <2 x i16> %v5, 5
  %res6 = insertvalue {<2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>} %res5, <2 x i16> %v6, 6
  %res7 = insertvalue {<2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>} %res6, <2 x i16> %v7, 7
  ret {<2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>, <2 x i16>} %res7
}

; LMUL * NF is > 8 here and so shouldn't be lowered to a vlseg
define {<8 x i64>, <8 x i64>, <8 x i64>, <8 x i64>, <8 x i64>, <8 x i64>} @load_factor6_too_big(ptr %ptr) {
; RV32-LABEL: load_factor6_too_big:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    csrr a2, vlenb
; RV32-NEXT:    li a3, 92
; RV32-NEXT:    mul a2, a2, a3
; RV32-NEXT:    sub sp, sp, a2
; RV32-NEXT:    .cfi_escape 0x0f, 0x0e, 0x72, 0x00, 0x11, 0x10, 0x22, 0x11, 0xdc, 0x00, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 16 + 92 * vlenb
; RV32-NEXT:    addi a3, a1, 256
; RV32-NEXT:    addi a4, a1, 128
; RV32-NEXT:    li a2, 32
; RV32-NEXT:    lui a5, 12291
; RV32-NEXT:    lui a6, %hi(.LCPI8_0)
; RV32-NEXT:    addi a6, a6, %lo(.LCPI8_0)
; RV32-NEXT:    li a7, 768
; RV32-NEXT:    lui t0, 49164
; RV32-NEXT:    vsetvli zero, a2, e32, m8, ta, ma
; RV32-NEXT:    vle32.v v16, (a1)
; RV32-NEXT:    csrr a1, vlenb
; RV32-NEXT:    li t1, 76
; RV32-NEXT:    mul a1, a1, t1
; RV32-NEXT:    add a1, sp, a1
; RV32-NEXT:    addi a1, a1, 16
; RV32-NEXT:    vs8r.v v16, (a1) # Unknown-size Folded Spill
; RV32-NEXT:    vle32.v v8, (a4)
; RV32-NEXT:    csrr a1, vlenb
; RV32-NEXT:    li a4, 68
; RV32-NEXT:    mul a1, a1, a4
; RV32-NEXT:    add a1, sp, a1
; RV32-NEXT:    addi a1, a1, 16
; RV32-NEXT:    vs8r.v v8, (a1) # Unknown-size Folded Spill
; RV32-NEXT:    addi a5, a5, 3
; RV32-NEXT:    vsetivli zero, 16, e32, m4, ta, ma
; RV32-NEXT:    vle16.v v6, (a6)
; RV32-NEXT:    vmv.s.x v0, a5
; RV32-NEXT:    lui a1, %hi(.LCPI8_1)
; RV32-NEXT:    addi a1, a1, %lo(.LCPI8_1)
; RV32-NEXT:    vsetvli zero, a2, e32, m8, ta, ma
; RV32-NEXT:    vmerge.vvm v16, v8, v16, v0
; RV32-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; RV32-NEXT:    vrgatherei16.vv v24, v16, v6
; RV32-NEXT:    csrr a4, vlenb
; RV32-NEXT:    li a5, 52
; RV32-NEXT:    mul a4, a4, a5
; RV32-NEXT:    add a4, sp, a4
; RV32-NEXT:    addi a4, a4, 16
; RV32-NEXT:    vs8r.v v24, (a4) # Unknown-size Folded Spill
; RV32-NEXT:    vsetvli zero, a2, e32, m8, ta, ma
; RV32-NEXT:    vle32.v v16, (a3)
; RV32-NEXT:    addi t0, t0, 12
; RV32-NEXT:    vmv.s.x v0, a7
; RV32-NEXT:    vmv.s.x v7, t0
; RV32-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; RV32-NEXT:    vle16.v v4, (a1)
; RV32-NEXT:    vsetivli zero, 16, e32, m8, ta, ma
; RV32-NEXT:    vslidedown.vi v24, v16, 16
; RV32-NEXT:    csrr a1, vlenb
; RV32-NEXT:    li a3, 60
; RV32-NEXT:    mul a1, a1, a3
; RV32-NEXT:    add a1, sp, a1
; RV32-NEXT:    addi a1, a1, 16
; RV32-NEXT:    vs8r.v v24, (a1) # Unknown-size Folded Spill
; RV32-NEXT:    csrr a1, vlenb
; RV32-NEXT:    li a3, 84
; RV32-NEXT:    mul a1, a1, a3
; RV32-NEXT:    add a1, sp, a1
; RV32-NEXT:    addi a1, a1, 16
; RV32-NEXT:    vs8r.v v16, (a1) # Unknown-size Folded Spill
; RV32-NEXT:    vsetivli zero, 16, e32, m4, ta, ma
; RV32-NEXT:    vmerge.vvm v20, v24, v16, v0
; RV32-NEXT:    csrr a1, vlenb
; RV32-NEXT:    li a3, 40
; RV32-NEXT:    mul a1, a1, a3
; RV32-NEXT:    add a1, sp, a1
; RV32-NEXT:    addi a1, a1, 16
; RV32-NEXT:    vs4r.v v20, (a1) # Unknown-size Folded Spill
; RV32-NEXT:    vmv1r.v v0, v7
; RV32-NEXT:    csrr a1, vlenb
; RV32-NEXT:    li a3, 76
; RV32-NEXT:    mul a1, a1, a3
; RV32-NEXT:    add a1, sp, a1
; RV32-NEXT:    addi a1, a1, 16
; RV32-NEXT:    vl8r.v v16, (a1) # Unknown-size Folded Reload
; RV32-NEXT:    vsetvli zero, a2, e32, m8, ta, ma
; RV32-NEXT:    vmerge.vvm v24, v8, v16, v0
; RV32-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; RV32-NEXT:    vrgatherei16.vv v8, v24, v4
; RV32-NEXT:    csrr a1, vlenb
; RV32-NEXT:    li a3, 44
; RV32-NEXT:    mul a1, a1, a3
; RV32-NEXT:    add a1, sp, a1
; RV32-NEXT:    addi a1, a1, 16
; RV32-NEXT:    vs8r.v v8, (a1) # Unknown-size Folded Spill
; RV32-NEXT:    li a1, 3
; RV32-NEXT:    lui a3, 196656
; RV32-NEXT:    lui a4, %hi(.LCPI8_2)
; RV32-NEXT:    addi a4, a4, %lo(.LCPI8_2)
; RV32-NEXT:    slli a1, a1, 10
; RV32-NEXT:    addi a3, a3, 48
; RV32-NEXT:    vmv.s.x v0, a1
; RV32-NEXT:    vle16.v v14, (a4)
; RV32-NEXT:    vmv.s.x v12, a3
; RV32-NEXT:    csrr a1, vlenb
; RV32-NEXT:    li a3, 84
; RV32-NEXT:    mul a1, a1, a3
; RV32-NEXT:    add a1, sp, a1
; RV32-NEXT:    addi a1, a1, 16
; RV32-NEXT:    vl8r.v v24, (a1) # Unknown-size Folded Reload
; RV32-NEXT:    vmv4r.v v8, v24
; RV32-NEXT:    csrr a1, vlenb
; RV32-NEXT:    li a3, 60
; RV32-NEXT:    mul a1, a1, a3
; RV32-NEXT:    add a1, sp, a1
; RV32-NEXT:    addi a1, a1, 16
; RV32-NEXT:    vl8r.v v24, (a1) # Unknown-size Folded Reload
; RV32-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; RV32-NEXT:    vmerge.vvm v8, v24, v8, v0
; RV32-NEXT:    csrr a1, vlenb
; RV32-NEXT:    li a3, 24
; RV32-NEXT:    mul a1, a1, a3
; RV32-NEXT:    add a1, sp, a1
; RV32-NEXT:    addi a1, a1, 16
; RV32-NEXT:    vs4r.v v8, (a1) # Unknown-size Folded Spill
; RV32-NEXT:    vmv1r.v v0, v12
; RV32-NEXT:    csrr a1, vlenb
; RV32-NEXT:    li a3, 68
; RV32-NEXT:    mul a1, a1, a3
; RV32-NEXT:    add a1, sp, a1
; RV32-NEXT:    addi a1, a1, 16
; RV32-NEXT:    vl8r.v v24, (a1) # Unknown-size Folded Reload
; RV32-NEXT:    vsetvli zero, a2, e32, m8, ta, ma
; RV32-NEXT:    vmerge.vvm v24, v24, v16, v0
; RV32-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; RV32-NEXT:    vrgatherei16.vv v16, v24, v14
; RV32-NEXT:    csrr a1, vlenb
; RV32-NEXT:    slli a1, a1, 5
; RV32-NEXT:    add a1, sp, a1
; RV32-NEXT:    addi a1, a1, 16
; RV32-NEXT:    vs8r.v v16, (a1) # Unknown-size Folded Spill
; RV32-NEXT:    lui a1, 3
; RV32-NEXT:    lui a3, 786624
; RV32-NEXT:    lui a4, 12
; RV32-NEXT:    lui a5, 768
; RV32-NEXT:    li a6, 48
; RV32-NEXT:    lui a7, 3073
; RV32-NEXT:    li t0, 192
; RV32-NEXT:    addi a1, a1, 3
; RV32-NEXT:    addi a3, a3, 192
; RV32-NEXT:    addi a4, a4, 12
; RV32-NEXT:    addi a5, a5, 768
; RV32-NEXT:    addi a7, a7, -1024
; RV32-NEXT:    vmv.s.x v1, a6
; RV32-NEXT:    vmv.s.x v12, t0
; RV32-NEXT:    vmv.s.x v0, a1
; RV32-NEXT:    vmv.s.x v3, a3
; RV32-NEXT:    vmv.s.x v2, a4
; RV32-NEXT:    vmv.s.x v13, a5
; RV32-NEXT:    vmv.s.x v14, a7
; RV32-NEXT:    csrr a1, vlenb
; RV32-NEXT:    li a3, 60
; RV32-NEXT:    mul a1, a1, a3
; RV32-NEXT:    add a1, sp, a1
; RV32-NEXT:    addi a1, a1, 16
; RV32-NEXT:    vl8r.v v16, (a1) # Unknown-size Folded Reload
; RV32-NEXT:    vmv4r.v v8, v16
; RV32-NEXT:    csrr a1, vlenb
; RV32-NEXT:    li a3, 84
; RV32-NEXT:    mul a1, a1, a3
; RV32-NEXT:    add a1, sp, a1
; RV32-NEXT:    addi a1, a1, 16
; RV32-NEXT:    vl8r.v v16, (a1) # Unknown-size Folded Reload
; RV32-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; RV32-NEXT:    vmerge.vvm v20, v8, v16, v0
; RV32-NEXT:    addi a1, sp, 16
; RV32-NEXT:    vs4r.v v20, (a1) # Unknown-size Folded Spill
; RV32-NEXT:    vmv1r.v v0, v3
; RV32-NEXT:    csrr a1, vlenb
; RV32-NEXT:    li a3, 68
; RV32-NEXT:    mul a1, a1, a3
; RV32-NEXT:    add a1, sp, a1
; RV32-NEXT:    addi a1, a1, 16
; RV32-NEXT:    vl8r.v v16, (a1) # Unknown-size Folded Reload
; RV32-NEXT:    csrr a1, vlenb
; RV32-NEXT:    li a3, 76
; RV32-NEXT:    mul a1, a1, a3
; RV32-NEXT:    add a1, sp, a1
; RV32-NEXT:    addi a1, a1, 16
; RV32-NEXT:    vl8r.v v24, (a1) # Unknown-size Folded Reload
; RV32-NEXT:    vsetvli zero, a2, e32, m8, ta, ma
; RV32-NEXT:    vmerge.vvm v24, v16, v24, v0
; RV32-NEXT:    csrr a1, vlenb
; RV32-NEXT:    slli a1, a1, 4
; RV32-NEXT:    add a1, sp, a1
; RV32-NEXT:    addi a1, a1, 16
; RV32-NEXT:    vs8r.v v24, (a1) # Unknown-size Folded Spill
; RV32-NEXT:    vmv1r.v v0, v2
; RV32-NEXT:    csrr a1, vlenb
; RV32-NEXT:    li a3, 84
; RV32-NEXT:    mul a1, a1, a3
; RV32-NEXT:    add a1, sp, a1
; RV32-NEXT:    addi a1, a1, 16
; RV32-NEXT:    vl8r.v v24, (a1) # Unknown-size Folded Reload
; RV32-NEXT:    vsetivli zero, 16, e32, m4, ta, ma
; RV32-NEXT:    vmerge.vvm v24, v8, v24, v0
; RV32-NEXT:    csrr a1, vlenb
; RV32-NEXT:    li a3, 12
; RV32-NEXT:    mul a1, a1, a3
; RV32-NEXT:    add a1, sp, a1
; RV32-NEXT:    addi a1, a1, 16
; RV32-NEXT:    vs4r.v v24, (a1) # Unknown-size Folded Spill
; RV32-NEXT:    vmv1r.v v0, v13
; RV32-NEXT:    csrr a1, vlenb
; RV32-NEXT:    li a3, 76
; RV32-NEXT:    mul a1, a1, a3
; RV32-NEXT:    add a1, sp, a1
; RV32-NEXT:    addi a1, a1, 16
; RV32-NEXT:    vl8r.v v24, (a1) # Unknown-size Folded Reload
; RV32-NEXT:    vsetvli zero, a2, e32, m8, ta, ma
; RV32-NEXT:    vmerge.vvm v24, v16, v24, v0
; RV32-NEXT:    csrr a1, vlenb
; RV32-NEXT:    slli a1, a1, 2
; RV32-NEXT:    add a1, sp, a1
; RV32-NEXT:    addi a1, a1, 16
; RV32-NEXT:    vs8r.v v24, (a1) # Unknown-size Folded Spill
; RV32-NEXT:    vmv1r.v v0, v1
; RV32-NEXT:    csrr a1, vlenb
; RV32-NEXT:    li a3, 84
; RV32-NEXT:    mul a1, a1, a3
; RV32-NEXT:    add a1, sp, a1
; RV32-NEXT:    addi a1, a1, 16
; RV32-NEXT:    vl8r.v v24, (a1) # Unknown-size Folded Reload
; RV32-NEXT:    vsetivli zero, 16, e32, m4, ta, ma
; RV32-NEXT:    vmerge.vvm v4, v8, v24, v0
; RV32-NEXT:    csrr a1, vlenb
; RV32-NEXT:    li a3, 28
; RV32-NEXT:    mul a1, a1, a3
; RV32-NEXT:    add a1, sp, a1
; RV32-NEXT:    addi a1, a1, 16
; RV32-NEXT:    vs4r.v v4, (a1) # Unknown-size Folded Spill
; RV32-NEXT:    vmv1r.v v0, v14
; RV32-NEXT:    csrr a1, vlenb
; RV32-NEXT:    li a3, 76
; RV32-NEXT:    mul a1, a1, a3
; RV32-NEXT:    add a1, sp, a1
; RV32-NEXT:    addi a1, a1, 16
; RV32-NEXT:    vl8r.v v16, (a1) # Unknown-size Folded Reload
; RV32-NEXT:    csrr a1, vlenb
; RV32-NEXT:    li a3, 68
; RV32-NEXT:    mul a1, a1, a3
; RV32-NEXT:    add a1, sp, a1
; RV32-NEXT:    addi a1, a1, 16
; RV32-NEXT:    vl8r.v v24, (a1) # Unknown-size Folded Reload
; RV32-NEXT:    vsetvli zero, a2, e32, m8, ta, ma
; RV32-NEXT:    vmerge.vvm v16, v24, v16, v0
; RV32-NEXT:    csrr a1, vlenb
; RV32-NEXT:    li a2, 76
; RV32-NEXT:    mul a1, a1, a2
; RV32-NEXT:    add a1, sp, a1
; RV32-NEXT:    addi a1, a1, 16
; RV32-NEXT:    vs8r.v v16, (a1) # Unknown-size Folded Spill
; RV32-NEXT:    vmv1r.v v0, v12
; RV32-NEXT:    csrr a1, vlenb
; RV32-NEXT:    li a2, 84
; RV32-NEXT:    mul a1, a1, a2
; RV32-NEXT:    add a1, sp, a1
; RV32-NEXT:    addi a1, a1, 16
; RV32-NEXT:    vl8r.v v16, (a1) # Unknown-size Folded Reload
; RV32-NEXT:    vsetivli zero, 16, e32, m4, ta, ma
; RV32-NEXT:    vmerge.vvm v8, v8, v16, v0
; RV32-NEXT:    csrr a1, vlenb
; RV32-NEXT:    li a2, 68
; RV32-NEXT:    mul a1, a1, a2
; RV32-NEXT:    add a1, sp, a1
; RV32-NEXT:    addi a1, a1, 16
; RV32-NEXT:    vs4r.v v8, (a1) # Unknown-size Folded Spill
; RV32-NEXT:    lui a1, 32
; RV32-NEXT:    addi a1, a1, 4
; RV32-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; RV32-NEXT:    vmv.v.x v16, a1
; RV32-NEXT:    csrr a1, vlenb
; RV32-NEXT:    li a2, 40
; RV32-NEXT:    mul a1, a1, a2
; RV32-NEXT:    add a1, sp, a1
; RV32-NEXT:    addi a1, a1, 16
; RV32-NEXT:    vl4r.v v8, (a1) # Unknown-size Folded Reload
; RV32-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; RV32-NEXT:    vrgatherei16.vv v20, v8, v16
; RV32-NEXT:    csrr a1, vlenb
; RV32-NEXT:    li a2, 52
; RV32-NEXT:    mul a1, a1, a2
; RV32-NEXT:    add a1, sp, a1
; RV32-NEXT:    addi a1, a1, 16
; RV32-NEXT:    vl8r.v v8, (a1) # Unknown-size Folded Reload
; RV32-NEXT:    vsetivli zero, 12, e32, m4, tu, ma
; RV32-NEXT:    vmv.v.v v20, v8
; RV32-NEXT:    csrr a1, vlenb
; RV32-NEXT:    li a2, 84
; RV32-NEXT:    mul a1, a1, a2
; RV32-NEXT:    add a1, sp, a1
; RV32-NEXT:    addi a1, a1, 16
; RV32-NEXT:    vs4r.v v20, (a1) # Unknown-size Folded Spill
; RV32-NEXT:    lui a1, 48
; RV32-NEXT:    lui a2, %hi(.LCPI8_3)
; RV32-NEXT:    addi a2, a2, %lo(.LCPI8_3)
; RV32-NEXT:    addi a1, a1, 5
; RV32-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; RV32-NEXT:    vle16.v v28, (a2)
; RV32-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; RV32-NEXT:    vmv.v.x v20, a1
; RV32-NEXT:    csrr a1, vlenb
; RV32-NEXT:    li a2, 24
; RV32-NEXT:    mul a1, a1, a2
; RV32-NEXT:    add a1, sp, a1
; RV32-NEXT:    addi a1, a1, 16
; RV32-NEXT:    vl4r.v v12, (a1) # Unknown-size Folded Reload
; RV32-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; RV32-NEXT:    vrgatherei16.vv v8, v12, v20
; RV32-NEXT:    csrr a1, vlenb
; RV32-NEXT:    li a2, 44
; RV32-NEXT:    mul a1, a1, a2
; RV32-NEXT:    add a1, sp, a1
; RV32-NEXT:    addi a1, a1, 16
; RV32-NEXT:    vl8r.v v16, (a1) # Unknown-size Folded Reload
; RV32-NEXT:    vsetivli zero, 12, e32, m4, tu, ma
; RV32-NEXT:    vmv.v.v v8, v16
; RV32-NEXT:    csrr a1, vlenb
; RV32-NEXT:    li a2, 52
; RV32-NEXT:    mul a1, a1, a2
; RV32-NEXT:    add a1, sp, a1
; RV32-NEXT:    addi a1, a1, 16
; RV32-NEXT:    vs4r.v v8, (a1) # Unknown-size Folded Spill
; RV32-NEXT:    addi a1, sp, 16
; RV32-NEXT:    vl4r.v v12, (a1) # Unknown-size Folded Reload
; RV32-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; RV32-NEXT:    vrgatherei16.vv v24, v12, v28
; RV32-NEXT:    csrr a1, vlenb
; RV32-NEXT:    slli a1, a1, 5
; RV32-NEXT:    add a1, sp, a1
; RV32-NEXT:    addi a1, a1, 16
; RV32-NEXT:    vl8r.v v16, (a1) # Unknown-size Folded Reload
; RV32-NEXT:    vsetivli zero, 10, e32, m4, tu, ma
; RV32-NEXT:    vmv.v.v v24, v16
; RV32-NEXT:    lui a1, %hi(.LCPI8_4)
; RV32-NEXT:    addi a1, a1, %lo(.LCPI8_4)
; RV32-NEXT:    lui a2, %hi(.LCPI8_5)
; RV32-NEXT:    addi a2, a2, %lo(.LCPI8_5)
; RV32-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; RV32-NEXT:    vle16.v v12, (a1)
; RV32-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; RV32-NEXT:    vle16.v v28, (a2)
; RV32-NEXT:    lui a1, %hi(.LCPI8_6)
; RV32-NEXT:    addi a1, a1, %lo(.LCPI8_6)
; RV32-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; RV32-NEXT:    vle16.v v30, (a1)
; RV32-NEXT:    csrr a1, vlenb
; RV32-NEXT:    slli a1, a1, 4
; RV32-NEXT:    add a1, sp, a1
; RV32-NEXT:    addi a1, a1, 16
; RV32-NEXT:    vl8r.v v0, (a1) # Unknown-size Folded Reload
; RV32-NEXT:    vrgatherei16.vv v16, v0, v12
; RV32-NEXT:    csrr a1, vlenb
; RV32-NEXT:    li a2, 12
; RV32-NEXT:    mul a1, a1, a2
; RV32-NEXT:    add a1, sp, a1
; RV32-NEXT:    addi a1, a1, 16
; RV32-NEXT:    vl4r.v v20, (a1) # Unknown-size Folded Reload
; RV32-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; RV32-NEXT:    vrgatherei16.vv v12, v20, v28
; RV32-NEXT:    vsetivli zero, 10, e32, m4, tu, ma
; RV32-NEXT:    vmv.v.v v12, v16
; RV32-NEXT:    csrr a1, vlenb
; RV32-NEXT:    slli a1, a1, 2
; RV32-NEXT:    add a1, sp, a1
; RV32-NEXT:    addi a1, a1, 16
; RV32-NEXT:    vl8r.v v0, (a1) # Unknown-size Folded Reload
; RV32-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; RV32-NEXT:    vrgatherei16.vv v16, v0, v30
; RV32-NEXT:    lui a1, %hi(.LCPI8_7)
; RV32-NEXT:    addi a1, a1, %lo(.LCPI8_7)
; RV32-NEXT:    lui a2, %hi(.LCPI8_8)
; RV32-NEXT:    addi a2, a2, %lo(.LCPI8_8)
; RV32-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; RV32-NEXT:    vle16.v v20, (a1)
; RV32-NEXT:    lui a1, %hi(.LCPI8_9)
; RV32-NEXT:    addi a1, a1, %lo(.LCPI8_9)
; RV32-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; RV32-NEXT:    vle16.v v8, (a2)
; RV32-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; RV32-NEXT:    vle16.v v10, (a1)
; RV32-NEXT:    csrr a1, vlenb
; RV32-NEXT:    li a2, 28
; RV32-NEXT:    mul a1, a1, a2
; RV32-NEXT:    add a1, sp, a1
; RV32-NEXT:    addi a1, a1, 16
; RV32-NEXT:    vl4r.v v0, (a1) # Unknown-size Folded Reload
; RV32-NEXT:    vrgatherei16.vv v28, v0, v20
; RV32-NEXT:    vsetivli zero, 10, e32, m4, tu, ma
; RV32-NEXT:    vmv.v.v v28, v16
; RV32-NEXT:    csrr a1, vlenb
; RV32-NEXT:    li a2, 76
; RV32-NEXT:    mul a1, a1, a2
; RV32-NEXT:    add a1, sp, a1
; RV32-NEXT:    addi a1, a1, 16
; RV32-NEXT:    vl8r.v v0, (a1) # Unknown-size Folded Reload
; RV32-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; RV32-NEXT:    vrgatherei16.vv v16, v0, v8
; RV32-NEXT:    csrr a1, vlenb
; RV32-NEXT:    li a2, 60
; RV32-NEXT:    mul a1, a1, a2
; RV32-NEXT:    add a1, sp, a1
; RV32-NEXT:    addi a1, a1, 16
; RV32-NEXT:    vs8r.v v16, (a1) # Unknown-size Folded Spill
; RV32-NEXT:    csrr a1, vlenb
; RV32-NEXT:    li a2, 68
; RV32-NEXT:    mul a1, a1, a2
; RV32-NEXT:    add a1, sp, a1
; RV32-NEXT:    addi a1, a1, 16
; RV32-NEXT:    vl4r.v v4, (a1) # Unknown-size Folded Reload
; RV32-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; RV32-NEXT:    vrgatherei16.vv v16, v4, v10
; RV32-NEXT:    csrr a1, vlenb
; RV32-NEXT:    li a2, 60
; RV32-NEXT:    mul a1, a1, a2
; RV32-NEXT:    add a1, sp, a1
; RV32-NEXT:    addi a1, a1, 16
; RV32-NEXT:    vl8r.v v0, (a1) # Unknown-size Folded Reload
; RV32-NEXT:    vsetivli zero, 10, e32, m4, tu, ma
; RV32-NEXT:    vmv.v.v v16, v0
; RV32-NEXT:    addi a1, a0, 320
; RV32-NEXT:    vsetivli zero, 16, e32, m4, ta, ma
; RV32-NEXT:    vse32.v v16, (a1)
; RV32-NEXT:    addi a1, a0, 256
; RV32-NEXT:    vse32.v v28, (a1)
; RV32-NEXT:    addi a1, a0, 192
; RV32-NEXT:    vse32.v v12, (a1)
; RV32-NEXT:    addi a1, a0, 128
; RV32-NEXT:    vse32.v v24, (a1)
; RV32-NEXT:    addi a1, a0, 64
; RV32-NEXT:    csrr a2, vlenb
; RV32-NEXT:    li a3, 52
; RV32-NEXT:    mul a2, a2, a3
; RV32-NEXT:    add a2, sp, a2
; RV32-NEXT:    addi a2, a2, 16
; RV32-NEXT:    vl4r.v v8, (a2) # Unknown-size Folded Reload
; RV32-NEXT:    vse32.v v8, (a1)
; RV32-NEXT:    csrr a1, vlenb
; RV32-NEXT:    li a2, 84
; RV32-NEXT:    mul a1, a1, a2
; RV32-NEXT:    add a1, sp, a1
; RV32-NEXT:    addi a1, a1, 16
; RV32-NEXT:    vl4r.v v8, (a1) # Unknown-size Folded Reload
; RV32-NEXT:    vse32.v v8, (a0)
; RV32-NEXT:    csrr a0, vlenb
; RV32-NEXT:    li a1, 92
; RV32-NEXT:    mul a0, a0, a1
; RV32-NEXT:    add sp, sp, a0
; RV32-NEXT:    .cfi_def_cfa sp, 16
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    .cfi_def_cfa_offset 0
; RV32-NEXT:    ret
;
; RV64-LABEL: load_factor6_too_big:
; RV64:       # %bb.0:
; RV64-NEXT:    addi sp, sp, -16
; RV64-NEXT:    .cfi_def_cfa_offset 16
; RV64-NEXT:    csrr a2, vlenb
; RV64-NEXT:    li a3, 88
; RV64-NEXT:    mul a2, a2, a3
; RV64-NEXT:    sub sp, sp, a2
; RV64-NEXT:    .cfi_escape 0x0f, 0x0e, 0x72, 0x00, 0x11, 0x10, 0x22, 0x11, 0xd8, 0x00, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 16 + 88 * vlenb
; RV64-NEXT:    addi a3, a1, 128
; RV64-NEXT:    addi a6, a1, 256
; RV64-NEXT:    li a4, 128
; RV64-NEXT:    lui a2, 1
; RV64-NEXT:    lui a5, %hi(.LCPI8_0)
; RV64-NEXT:    addi a5, a5, %lo(.LCPI8_0)
; RV64-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; RV64-NEXT:    vmv.v.i v16, 6
; RV64-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; RV64-NEXT:    vle64.v v8, (a6)
; RV64-NEXT:    lui a6, 16
; RV64-NEXT:    addi a6, a6, 7
; RV64-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; RV64-NEXT:    vmv.v.x v17, a6
; RV64-NEXT:    addi a6, a2, 65
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; RV64-NEXT:    vrgather.vi v24, v8, 4
; RV64-NEXT:    vrgather.vi v20, v8, 5
; RV64-NEXT:    csrr a7, vlenb
; RV64-NEXT:    li t0, 68
; RV64-NEXT:    mul a7, a7, t0
; RV64-NEXT:    add a7, sp, a7
; RV64-NEXT:    addi a7, a7, 16
; RV64-NEXT:    vs4r.v v20, (a7) # Unknown-size Folded Spill
; RV64-NEXT:    vrgatherei16.vv v20, v8, v16
; RV64-NEXT:    csrr a7, vlenb
; RV64-NEXT:    li t0, 84
; RV64-NEXT:    mul a7, a7, t0
; RV64-NEXT:    add a7, sp, a7
; RV64-NEXT:    addi a7, a7, 16
; RV64-NEXT:    vs4r.v v20, (a7) # Unknown-size Folded Spill
; RV64-NEXT:    vrgatherei16.vv v20, v8, v17
; RV64-NEXT:    csrr a7, vlenb
; RV64-NEXT:    li t0, 72
; RV64-NEXT:    mul a7, a7, t0
; RV64-NEXT:    add a7, sp, a7
; RV64-NEXT:    addi a7, a7, 16
; RV64-NEXT:    vs4r.v v20, (a7) # Unknown-size Folded Spill
; RV64-NEXT:    vrgather.vi v16, v8, 2
; RV64-NEXT:    csrr a7, vlenb
; RV64-NEXT:    slli a7, a7, 6
; RV64-NEXT:    add a7, sp, a7
; RV64-NEXT:    addi a7, a7, 16
; RV64-NEXT:    vs4r.v v16, (a7) # Unknown-size Folded Spill
; RV64-NEXT:    vrgather.vi v16, v8, 3
; RV64-NEXT:    csrr a7, vlenb
; RV64-NEXT:    li t0, 56
; RV64-NEXT:    mul a7, a7, t0
; RV64-NEXT:    add a7, sp, a7
; RV64-NEXT:    addi a7, a7, 16
; RV64-NEXT:    vs4r.v v16, (a7) # Unknown-size Folded Spill
; RV64-NEXT:    vsetivli zero, 8, e64, m8, ta, ma
; RV64-NEXT:    vslidedown.vi v16, v8, 8
; RV64-NEXT:    csrr a7, vlenb
; RV64-NEXT:    li t0, 48
; RV64-NEXT:    mul a7, a7, t0
; RV64-NEXT:    add a7, sp, a7
; RV64-NEXT:    addi a7, a7, 16
; RV64-NEXT:    vs8r.v v16, (a7) # Unknown-size Folded Spill
; RV64-NEXT:    vmv.s.x v21, a4
; RV64-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; RV64-NEXT:    vle64.v v8, (a1)
; RV64-NEXT:    vle64.v v0, (a3)
; RV64-NEXT:    csrr a1, vlenb
; RV64-NEXT:    li a3, 40
; RV64-NEXT:    mul a1, a1, a3
; RV64-NEXT:    add a1, sp, a1
; RV64-NEXT:    addi a1, a1, 16
; RV64-NEXT:    vs8r.v v0, (a1) # Unknown-size Folded Spill
; RV64-NEXT:    vle16.v v2, (a5)
; RV64-NEXT:    vmv.s.x v20, a6
; RV64-NEXT:    vmv1r.v v0, v21
; RV64-NEXT:    vmv1r.v v7, v21
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vrgather.vi v24, v16, 2, v0.t
; RV64-NEXT:    csrr a1, vlenb
; RV64-NEXT:    li a3, 60
; RV64-NEXT:    mul a1, a1, a3
; RV64-NEXT:    add a1, sp, a1
; RV64-NEXT:    addi a1, a1, 16
; RV64-NEXT:    vs4r.v v24, (a1) # Unknown-size Folded Spill
; RV64-NEXT:    vmv1r.v v0, v20
; RV64-NEXT:    csrr a1, vlenb
; RV64-NEXT:    li a3, 40
; RV64-NEXT:    mul a1, a1, a3
; RV64-NEXT:    add a1, sp, a1
; RV64-NEXT:    addi a1, a1, 16
; RV64-NEXT:    vl8r.v v16, (a1) # Unknown-size Folded Reload
; RV64-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; RV64-NEXT:    vmerge.vvm v24, v16, v8, v0
; RV64-NEXT:    vmv8r.v v16, v8
; RV64-NEXT:    csrr a1, vlenb
; RV64-NEXT:    li a3, 76
; RV64-NEXT:    mul a1, a1, a3
; RV64-NEXT:    add a1, sp, a1
; RV64-NEXT:    addi a1, a1, 16
; RV64-NEXT:    vs8r.v v8, (a1) # Unknown-size Folded Spill
; RV64-NEXT:    vrgatherei16.vv v8, v24, v2
; RV64-NEXT:    csrr a1, vlenb
; RV64-NEXT:    slli a1, a1, 5
; RV64-NEXT:    add a1, sp, a1
; RV64-NEXT:    addi a1, a1, 16
; RV64-NEXT:    vs8r.v v8, (a1) # Unknown-size Folded Spill
; RV64-NEXT:    lui a1, 2
; RV64-NEXT:    lui a3, %hi(.LCPI8_1)
; RV64-NEXT:    addi a3, a3, %lo(.LCPI8_1)
; RV64-NEXT:    addi a1, a1, 130
; RV64-NEXT:    vle16.v v8, (a3)
; RV64-NEXT:    csrr a3, vlenb
; RV64-NEXT:    slli a3, a3, 4
; RV64-NEXT:    add a3, sp, a3
; RV64-NEXT:    addi a3, a3, 16
; RV64-NEXT:    vs2r.v v8, (a3) # Unknown-size Folded Spill
; RV64-NEXT:    vmv.s.x v2, a1
; RV64-NEXT:    vmv1r.v v0, v7
; RV64-NEXT:    addi a1, sp, 16
; RV64-NEXT:    vs1r.v v7, (a1) # Unknown-size Folded Spill
; RV64-NEXT:    csrr a1, vlenb
; RV64-NEXT:    li a3, 68
; RV64-NEXT:    mul a1, a1, a3
; RV64-NEXT:    add a1, sp, a1
; RV64-NEXT:    addi a1, a1, 16
; RV64-NEXT:    vl4r.v v24, (a1) # Unknown-size Folded Reload
; RV64-NEXT:    csrr a1, vlenb
; RV64-NEXT:    li a3, 48
; RV64-NEXT:    mul a1, a1, a3
; RV64-NEXT:    add a1, sp, a1
; RV64-NEXT:    addi a1, a1, 16
; RV64-NEXT:    vl8r.v v8, (a1) # Unknown-size Folded Reload
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vrgather.vi v24, v8, 3, v0.t
; RV64-NEXT:    csrr a1, vlenb
; RV64-NEXT:    li a3, 68
; RV64-NEXT:    mul a1, a1, a3
; RV64-NEXT:    add a1, sp, a1
; RV64-NEXT:    addi a1, a1, 16
; RV64-NEXT:    vs4r.v v24, (a1) # Unknown-size Folded Spill
; RV64-NEXT:    vmv1r.v v0, v2
; RV64-NEXT:    csrr a1, vlenb
; RV64-NEXT:    li a3, 40
; RV64-NEXT:    mul a1, a1, a3
; RV64-NEXT:    add a1, sp, a1
; RV64-NEXT:    addi a1, a1, 16
; RV64-NEXT:    vl8r.v v8, (a1) # Unknown-size Folded Reload
; RV64-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; RV64-NEXT:    vmerge.vvm v24, v8, v16, v0
; RV64-NEXT:    csrr a1, vlenb
; RV64-NEXT:    slli a1, a1, 4
; RV64-NEXT:    add a1, sp, a1
; RV64-NEXT:    addi a1, a1, 16
; RV64-NEXT:    vl2r.v v16, (a1) # Unknown-size Folded Reload
; RV64-NEXT:    vrgatherei16.vv v0, v24, v16
; RV64-NEXT:    csrr a1, vlenb
; RV64-NEXT:    li a3, 24
; RV64-NEXT:    mul a1, a1, a3
; RV64-NEXT:    add a1, sp, a1
; RV64-NEXT:    addi a1, a1, 16
; RV64-NEXT:    vs8r.v v0, (a1) # Unknown-size Folded Spill
; RV64-NEXT:    lui a1, 4
; RV64-NEXT:    lui a3, 8
; RV64-NEXT:    addi a1, a1, 260
; RV64-NEXT:    addi a3, a3, 520
; RV64-NEXT:    vmv.s.x v0, a1
; RV64-NEXT:    vmv.s.x v2, a3
; RV64-NEXT:    csrr a1, vlenb
; RV64-NEXT:    li a3, 76
; RV64-NEXT:    mul a1, a1, a3
; RV64-NEXT:    add a1, sp, a1
; RV64-NEXT:    addi a1, a1, 16
; RV64-NEXT:    vl8r.v v16, (a1) # Unknown-size Folded Reload
; RV64-NEXT:    vmerge.vvm v24, v8, v16, v0
; RV64-NEXT:    csrr a1, vlenb
; RV64-NEXT:    slli a1, a1, 3
; RV64-NEXT:    add a1, sp, a1
; RV64-NEXT:    addi a1, a1, 16
; RV64-NEXT:    vs8r.v v24, (a1) # Unknown-size Folded Spill
; RV64-NEXT:    addi a1, sp, 16
; RV64-NEXT:    vl1r.v v7, (a1) # Unknown-size Folded Reload
; RV64-NEXT:    vmv1r.v v0, v7
; RV64-NEXT:    csrr a1, vlenb
; RV64-NEXT:    li a3, 84
; RV64-NEXT:    mul a1, a1, a3
; RV64-NEXT:    add a1, sp, a1
; RV64-NEXT:    addi a1, a1, 16
; RV64-NEXT:    vl4r.v v24, (a1) # Unknown-size Folded Reload
; RV64-NEXT:    csrr a1, vlenb
; RV64-NEXT:    li a3, 48
; RV64-NEXT:    mul a1, a1, a3
; RV64-NEXT:    add a1, sp, a1
; RV64-NEXT:    addi a1, a1, 16
; RV64-NEXT:    vl8r.v v16, (a1) # Unknown-size Folded Reload
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vrgather.vi v24, v16, 4, v0.t
; RV64-NEXT:    csrr a1, vlenb
; RV64-NEXT:    li a3, 84
; RV64-NEXT:    mul a1, a1, a3
; RV64-NEXT:    add a1, sp, a1
; RV64-NEXT:    addi a1, a1, 16
; RV64-NEXT:    vs4r.v v24, (a1) # Unknown-size Folded Spill
; RV64-NEXT:    vmv1r.v v0, v2
; RV64-NEXT:    csrr a1, vlenb
; RV64-NEXT:    li a3, 76
; RV64-NEXT:    mul a1, a1, a3
; RV64-NEXT:    add a1, sp, a1
; RV64-NEXT:    addi a1, a1, 16
; RV64-NEXT:    vl8r.v v16, (a1) # Unknown-size Folded Reload
; RV64-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; RV64-NEXT:    vmerge.vvm v24, v8, v16, v0
; RV64-NEXT:    csrr a1, vlenb
; RV64-NEXT:    slli a1, a1, 4
; RV64-NEXT:    add a1, sp, a1
; RV64-NEXT:    addi a1, a1, 16
; RV64-NEXT:    vs8r.v v24, (a1) # Unknown-size Folded Spill
; RV64-NEXT:    vmv8r.v v16, v8
; RV64-NEXT:    vmv1r.v v0, v7
; RV64-NEXT:    csrr a1, vlenb
; RV64-NEXT:    li a3, 72
; RV64-NEXT:    mul a1, a1, a3
; RV64-NEXT:    add a1, sp, a1
; RV64-NEXT:    addi a1, a1, 16
; RV64-NEXT:    vl4r.v v12, (a1) # Unknown-size Folded Reload
; RV64-NEXT:    csrr a1, vlenb
; RV64-NEXT:    li a3, 48
; RV64-NEXT:    mul a1, a1, a3
; RV64-NEXT:    add a1, sp, a1
; RV64-NEXT:    addi a1, a1, 16
; RV64-NEXT:    vl8r.v v24, (a1) # Unknown-size Folded Reload
; RV64-NEXT:    vmv4r.v v8, v24
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vrgather.vi v12, v24, 5, v0.t
; RV64-NEXT:    csrr a1, vlenb
; RV64-NEXT:    li a3, 72
; RV64-NEXT:    mul a1, a1, a3
; RV64-NEXT:    add a1, sp, a1
; RV64-NEXT:    addi a1, a1, 16
; RV64-NEXT:    vs4r.v v12, (a1) # Unknown-size Folded Spill
; RV64-NEXT:    lui a1, 96
; RV64-NEXT:    li a3, 192
; RV64-NEXT:    vmv.s.x v3, a3
; RV64-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; RV64-NEXT:    vmv.v.x v12, a1
; RV64-NEXT:    vmv1r.v v0, v3
; RV64-NEXT:    csrr a1, vlenb
; RV64-NEXT:    slli a1, a1, 6
; RV64-NEXT:    add a1, sp, a1
; RV64-NEXT:    addi a1, a1, 16
; RV64-NEXT:    vl4r.v v24, (a1) # Unknown-size Folded Reload
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vrgatherei16.vv v24, v8, v12, v0.t
; RV64-NEXT:    csrr a1, vlenb
; RV64-NEXT:    slli a1, a1, 6
; RV64-NEXT:    add a1, sp, a1
; RV64-NEXT:    addi a1, a1, 16
; RV64-NEXT:    vs4r.v v24, (a1) # Unknown-size Folded Spill
; RV64-NEXT:    lui a1, %hi(.LCPI8_2)
; RV64-NEXT:    addi a1, a1, %lo(.LCPI8_2)
; RV64-NEXT:    li a3, 1040
; RV64-NEXT:    lui a4, 112
; RV64-NEXT:    addi a4, a4, 1
; RV64-NEXT:    vmv.s.x v0, a3
; RV64-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; RV64-NEXT:    vmv.v.x v12, a4
; RV64-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; RV64-NEXT:    vle16.v v6, (a1)
; RV64-NEXT:    vmv8r.v v24, v16
; RV64-NEXT:    csrr a1, vlenb
; RV64-NEXT:    li a3, 76
; RV64-NEXT:    mul a1, a1, a3
; RV64-NEXT:    add a1, sp, a1
; RV64-NEXT:    addi a1, a1, 16
; RV64-NEXT:    vl8r.v v16, (a1) # Unknown-size Folded Reload
; RV64-NEXT:    vmerge.vvm v16, v24, v16, v0
; RV64-NEXT:    addi a1, sp, 16
; RV64-NEXT:    vs8r.v v16, (a1) # Unknown-size Folded Spill
; RV64-NEXT:    vmv1r.v v0, v3
; RV64-NEXT:    csrr a1, vlenb
; RV64-NEXT:    li a3, 56
; RV64-NEXT:    mul a1, a1, a3
; RV64-NEXT:    add a1, sp, a1
; RV64-NEXT:    addi a1, a1, 16
; RV64-NEXT:    vl4r.v v16, (a1) # Unknown-size Folded Reload
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vrgatherei16.vv v16, v8, v12, v0.t
; RV64-NEXT:    csrr a1, vlenb
; RV64-NEXT:    li a3, 56
; RV64-NEXT:    mul a1, a1, a3
; RV64-NEXT:    add a1, sp, a1
; RV64-NEXT:    addi a1, a1, 16
; RV64-NEXT:    vs4r.v v16, (a1) # Unknown-size Folded Spill
; RV64-NEXT:    addi a1, a2, -2016
; RV64-NEXT:    vmv.s.x v0, a1
; RV64-NEXT:    csrr a1, vlenb
; RV64-NEXT:    slli a1, a1, 3
; RV64-NEXT:    add a1, sp, a1
; RV64-NEXT:    addi a1, a1, 16
; RV64-NEXT:    vl8r.v v8, (a1) # Unknown-size Folded Reload
; RV64-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; RV64-NEXT:    vrgatherei16.vv v16, v8, v6
; RV64-NEXT:    csrr a1, vlenb
; RV64-NEXT:    li a2, 76
; RV64-NEXT:    mul a1, a1, a2
; RV64-NEXT:    add a1, sp, a1
; RV64-NEXT:    addi a1, a1, 16
; RV64-NEXT:    vl8r.v v8, (a1) # Unknown-size Folded Reload
; RV64-NEXT:    vmerge.vvm v8, v24, v8, v0
; RV64-NEXT:    csrr a1, vlenb
; RV64-NEXT:    li a2, 76
; RV64-NEXT:    mul a1, a1, a2
; RV64-NEXT:    add a1, sp, a1
; RV64-NEXT:    addi a1, a1, 16
; RV64-NEXT:    vs8r.v v8, (a1) # Unknown-size Folded Spill
; RV64-NEXT:    lui a1, %hi(.LCPI8_3)
; RV64-NEXT:    addi a1, a1, %lo(.LCPI8_3)
; RV64-NEXT:    vle16.v v24, (a1)
; RV64-NEXT:    csrr a1, vlenb
; RV64-NEXT:    slli a1, a1, 5
; RV64-NEXT:    add a1, sp, a1
; RV64-NEXT:    addi a1, a1, 16
; RV64-NEXT:    vl8r.v v0, (a1) # Unknown-size Folded Reload
; RV64-NEXT:    csrr a1, vlenb
; RV64-NEXT:    li a2, 60
; RV64-NEXT:    mul a1, a1, a2
; RV64-NEXT:    add a1, sp, a1
; RV64-NEXT:    addi a1, a1, 16
; RV64-NEXT:    vl4r.v v8, (a1) # Unknown-size Folded Reload
; RV64-NEXT:    vsetivli zero, 6, e64, m4, tu, ma
; RV64-NEXT:    vmv.v.v v8, v0
; RV64-NEXT:    csrr a1, vlenb
; RV64-NEXT:    li a2, 60
; RV64-NEXT:    mul a1, a1, a2
; RV64-NEXT:    add a1, sp, a1
; RV64-NEXT:    addi a1, a1, 16
; RV64-NEXT:    vs4r.v v8, (a1) # Unknown-size Folded Spill
; RV64-NEXT:    csrr a1, vlenb
; RV64-NEXT:    li a2, 68
; RV64-NEXT:    mul a1, a1, a2
; RV64-NEXT:    add a1, sp, a1
; RV64-NEXT:    addi a1, a1, 16
; RV64-NEXT:    vl4r.v v0, (a1) # Unknown-size Folded Reload
; RV64-NEXT:    csrr a1, vlenb
; RV64-NEXT:    li a2, 24
; RV64-NEXT:    mul a1, a1, a2
; RV64-NEXT:    add a1, sp, a1
; RV64-NEXT:    addi a1, a1, 16
; RV64-NEXT:    vl8r.v v8, (a1) # Unknown-size Folded Reload
; RV64-NEXT:    vmv.v.v v0, v8
; RV64-NEXT:    csrr a1, vlenb
; RV64-NEXT:    li a2, 84
; RV64-NEXT:    mul a1, a1, a2
; RV64-NEXT:    add a1, sp, a1
; RV64-NEXT:    addi a1, a1, 16
; RV64-NEXT:    vl4r.v v8, (a1) # Unknown-size Folded Reload
; RV64-NEXT:    vsetivli zero, 5, e64, m4, tu, ma
; RV64-NEXT:    vmv.v.v v8, v16
; RV64-NEXT:    csrr a1, vlenb
; RV64-NEXT:    li a2, 84
; RV64-NEXT:    mul a1, a1, a2
; RV64-NEXT:    add a1, sp, a1
; RV64-NEXT:    addi a1, a1, 16
; RV64-NEXT:    vs4r.v v8, (a1) # Unknown-size Folded Spill
; RV64-NEXT:    csrr a1, vlenb
; RV64-NEXT:    slli a1, a1, 4
; RV64-NEXT:    add a1, sp, a1
; RV64-NEXT:    addi a1, a1, 16
; RV64-NEXT:    vl8r.v v8, (a1) # Unknown-size Folded Reload
; RV64-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; RV64-NEXT:    vrgatherei16.vv v16, v8, v24
; RV64-NEXT:    lui a1, %hi(.LCPI8_4)
; RV64-NEXT:    addi a1, a1, %lo(.LCPI8_4)
; RV64-NEXT:    vle16.v v8, (a1)
; RV64-NEXT:    lui a1, %hi(.LCPI8_5)
; RV64-NEXT:    addi a1, a1, %lo(.LCPI8_5)
; RV64-NEXT:    vle16.v v6, (a1)
; RV64-NEXT:    csrr a1, vlenb
; RV64-NEXT:    li a2, 72
; RV64-NEXT:    mul a1, a1, a2
; RV64-NEXT:    add a1, sp, a1
; RV64-NEXT:    addi a1, a1, 16
; RV64-NEXT:    vl4r.v v12, (a1) # Unknown-size Folded Reload
; RV64-NEXT:    vsetivli zero, 5, e64, m4, tu, ma
; RV64-NEXT:    vmv.v.v v12, v16
; RV64-NEXT:    addi a1, sp, 16
; RV64-NEXT:    vl8r.v v16, (a1) # Unknown-size Folded Reload
; RV64-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; RV64-NEXT:    vrgatherei16.vv v24, v16, v8
; RV64-NEXT:    csrr a1, vlenb
; RV64-NEXT:    slli a1, a1, 6
; RV64-NEXT:    add a1, sp, a1
; RV64-NEXT:    addi a1, a1, 16
; RV64-NEXT:    vl4r.v v8, (a1) # Unknown-size Folded Reload
; RV64-NEXT:    vsetivli zero, 5, e64, m4, tu, ma
; RV64-NEXT:    vmv.v.v v8, v24
; RV64-NEXT:    csrr a1, vlenb
; RV64-NEXT:    li a2, 76
; RV64-NEXT:    mul a1, a1, a2
; RV64-NEXT:    add a1, sp, a1
; RV64-NEXT:    addi a1, a1, 16
; RV64-NEXT:    vl8r.v v16, (a1) # Unknown-size Folded Reload
; RV64-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; RV64-NEXT:    vrgatherei16.vv v24, v16, v6
; RV64-NEXT:    csrr a1, vlenb
; RV64-NEXT:    li a2, 56
; RV64-NEXT:    mul a1, a1, a2
; RV64-NEXT:    add a1, sp, a1
; RV64-NEXT:    addi a1, a1, 16
; RV64-NEXT:    vl4r.v v16, (a1) # Unknown-size Folded Reload
; RV64-NEXT:    vsetivli zero, 5, e64, m4, tu, ma
; RV64-NEXT:    vmv.v.v v16, v24
; RV64-NEXT:    addi a1, a0, 256
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; RV64-NEXT:    vse64.v v8, (a1)
; RV64-NEXT:    addi a1, a0, 320
; RV64-NEXT:    vse64.v v16, (a1)
; RV64-NEXT:    addi a1, a0, 192
; RV64-NEXT:    vse64.v v12, (a1)
; RV64-NEXT:    addi a1, a0, 128
; RV64-NEXT:    csrr a2, vlenb
; RV64-NEXT:    li a3, 84
; RV64-NEXT:    mul a2, a2, a3
; RV64-NEXT:    add a2, sp, a2
; RV64-NEXT:    addi a2, a2, 16
; RV64-NEXT:    vl4r.v v8, (a2) # Unknown-size Folded Reload
; RV64-NEXT:    vse64.v v8, (a1)
; RV64-NEXT:    addi a1, a0, 64
; RV64-NEXT:    vse64.v v0, (a1)
; RV64-NEXT:    csrr a1, vlenb
; RV64-NEXT:    li a2, 60
; RV64-NEXT:    mul a1, a1, a2
; RV64-NEXT:    add a1, sp, a1
; RV64-NEXT:    addi a1, a1, 16
; RV64-NEXT:    vl4r.v v8, (a1) # Unknown-size Folded Reload
; RV64-NEXT:    vse64.v v8, (a0)
; RV64-NEXT:    csrr a0, vlenb
; RV64-NEXT:    li a1, 88
; RV64-NEXT:    mul a0, a0, a1
; RV64-NEXT:    add sp, sp, a0
; RV64-NEXT:    .cfi_def_cfa sp, 16
; RV64-NEXT:    addi sp, sp, 16
; RV64-NEXT:    .cfi_def_cfa_offset 0
; RV64-NEXT:    ret
  %interleaved.vec = load <48 x i64>, ptr %ptr
  %v0 = shufflevector <48 x i64> %interleaved.vec, <48 x i64> poison, <8 x i32> <i32 0, i32 6, i32 12, i32 18, i32 24, i32 30, i32 36, i32 42>
  %v1 = shufflevector <48 x i64> %interleaved.vec, <48 x i64> poison, <8 x i32> <i32 1, i32 7, i32 13, i32 19, i32 25, i32 31, i32 37, i32 43>
  %v2 = shufflevector <48 x i64> %interleaved.vec, <48 x i64> poison, <8 x i32> <i32 2, i32 8, i32 14, i32 20, i32 26, i32 32, i32 38, i32 44>
  %v3 = shufflevector <48 x i64> %interleaved.vec, <48 x i64> poison, <8 x i32> <i32 3, i32 9, i32 15, i32 21, i32 27, i32 33, i32 39, i32 45>
  %v4 = shufflevector <48 x i64> %interleaved.vec, <48 x i64> poison, <8 x i32> <i32 4, i32 10, i32 16, i32 22, i32 28, i32 34, i32 40, i32 46>
  %v5 = shufflevector <48 x i64> %interleaved.vec, <48 x i64> poison, <8 x i32> <i32 5, i32 11, i32 17, i32 23, i32 29, i32 35, i32 41, i32 47>
  %res0 = insertvalue {<8 x i64>, <8 x i64>, <8 x i64>, <8 x i64>, <8 x i64>, <8 x i64>} undef, <8 x i64> %v0, 0
  %res1 = insertvalue {<8 x i64>, <8 x i64>, <8 x i64>, <8 x i64>, <8 x i64>, <8 x i64>} %res0, <8 x i64> %v1, 1
  %res2 = insertvalue {<8 x i64>, <8 x i64>, <8 x i64>, <8 x i64>, <8 x i64>, <8 x i64>} %res1, <8 x i64> %v2, 2
  %res3 = insertvalue {<8 x i64>, <8 x i64>, <8 x i64>, <8 x i64>, <8 x i64>, <8 x i64>} %res2, <8 x i64> %v3, 3
  %res4 = insertvalue {<8 x i64>, <8 x i64>, <8 x i64>, <8 x i64>, <8 x i64>, <8 x i64>} %res3, <8 x i64> %v4, 4
  %res5 = insertvalue {<8 x i64>, <8 x i64>, <8 x i64>, <8 x i64>, <8 x i64>, <8 x i64>} %res4, <8 x i64> %v5, 5
  ret {<8 x i64>, <8 x i64>, <8 x i64>, <8 x i64>, <8 x i64>, <8 x i64>} %res5
}


; ------------------------------------------------------------------------------
; Stores
; ------------------------------------------------------------------------------

define void @store_factor2(ptr %ptr, <4 x i32> %v0, <4 x i32> %v1) {
; CHECK-LABEL: store_factor2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vsseg2e32.v v8, (a0)
; CHECK-NEXT:    ret
  %interleaved.vec = shufflevector <4 x i32> %v0, <4 x i32> %v1, <8 x i32> <i32 0, i32 4, i32 1, i32 5, i32 2, i32 6, i32 3, i32 7>
  store <8 x i32> %interleaved.vec, ptr %ptr
  ret void
}

define void @store_factor3(ptr %ptr, <4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2) {
; CHECK-LABEL: store_factor3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vsseg3e32.v v8, (a0)
; CHECK-NEXT:    ret
  %s0 = shufflevector <4 x i32> %v0, <4 x i32> %v1, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %s1 = shufflevector <4 x i32> %v2, <4 x i32> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 undef, i32 undef, i32 undef, i32 undef>
  %interleaved.vec = shufflevector <8 x i32> %s0, <8 x i32> %s1, <12 x i32> <i32 0, i32 4, i32 8, i32 1, i32 5, i32 9, i32 2, i32 6, i32 10, i32 3, i32 7, i32 11>
  store <12 x i32> %interleaved.vec, ptr %ptr
  ret void
}

define void @store_factor4(ptr %ptr, <4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2, <4 x i32> %v3) {
; CHECK-LABEL: store_factor4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vsseg4e32.v v8, (a0)
; CHECK-NEXT:    ret
  %s0 = shufflevector <4 x i32> %v0, <4 x i32> %v1, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %s1 = shufflevector <4 x i32> %v2, <4 x i32> %v3, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %interleaved.vec = shufflevector <8 x i32> %s0, <8 x i32> %s1, <16 x i32> <i32 0, i32 4, i32 8, i32 12, i32 1, i32 5, i32 9, i32 13, i32 2, i32 6, i32 10, i32 14, i32 3, i32 7, i32 11, i32 15>
  store <16 x i32> %interleaved.vec, ptr %ptr
  ret void
}

define void @store_factor5(ptr %ptr, <4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2, <4 x i32> %v3, <4 x i32> %v4) {
; CHECK-LABEL: store_factor5:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vsseg5e32.v v8, (a0)
; CHECK-NEXT:    ret
  %s0 = shufflevector <4 x i32> %v0, <4 x i32> %v1, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %s1 = shufflevector <4 x i32> %v2, <4 x i32> %v3, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %s2 = shufflevector <8 x i32> %s0, <8 x i32> %s1, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %s3 = shufflevector <4 x i32> %v4, <4 x i32> poison, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %interleaved.vec = shufflevector <16 x i32> %s2, <16 x i32> %s3, <20 x i32> <i32 0, i32 4, i32 8, i32 12, i32 16, i32 1, i32 5, i32 9, i32 13, i32 17, i32 2, i32 6, i32 10, i32 14, i32 18, i32 3, i32 7, i32 11, i32 15, i32 19>
  store <20 x i32> %interleaved.vec, ptr %ptr
  ret void
}

define void @store_factor6(ptr %ptr, <2 x i16> %v0, <2 x i16> %v1, <2 x i16> %v2, <2 x i16> %v3, <2 x i16> %v4, <2 x i16> %v5) {
; CHECK-LABEL: store_factor6:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vsseg6e16.v v8, (a0)
; CHECK-NEXT:    ret
  %s0 = shufflevector <2 x i16> %v0, <2 x i16> %v1, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %s1 = shufflevector <2 x i16> %v2, <2 x i16> %v3, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %s2 = shufflevector <4 x i16> %s0, <4 x i16> %s1, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %s3 = shufflevector <2 x i16> %v4, <2 x i16> %v5, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 undef, i32 undef, i32 undef, i32 undef>
  %interleaved.vec = shufflevector <8 x i16> %s2, <8 x i16> %s3, <12 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 1, i32 3, i32 5, i32 7, i32 9, i32 11>
  store <12 x i16> %interleaved.vec, ptr %ptr
  ret void
}


define <4 x i32> @load_factor2_one_active(ptr %ptr) {
; CHECK-LABEL: load_factor2_one_active:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vlseg2e32.v v8, (a0)
; CHECK-NEXT:    ret
  %interleaved.vec = load <8 x i32>, ptr %ptr
  %v0 = shufflevector <8 x i32> %interleaved.vec, <8 x i32> poison, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
  ret <4 x i32> %v0
}


define <4 x i32> @load_factor3_one_active(ptr %ptr) {
; CHECK-LABEL: load_factor3_one_active:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 12
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vlse32.v v8, (a0), a1
; CHECK-NEXT:    ret
  %interleaved.vec = load <12 x i32>, ptr %ptr
  %v0 = shufflevector <12 x i32> %interleaved.vec, <12 x i32> poison, <4 x i32> <i32 0, i32 3, i32 6, i32 9>
  ret <4 x i32> %v0
}

define <4 x i32> @load_factor4_one_active(ptr %ptr) {
; CHECK-LABEL: load_factor4_one_active:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 16
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vlse32.v v8, (a0), a1
; CHECK-NEXT:    ret
  %interleaved.vec = load <16 x i32>, ptr %ptr
  %v0 = shufflevector <16 x i32> %interleaved.vec, <16 x i32> poison, <4 x i32> <i32 0, i32 4, i32 8, i32 12>
  ret <4 x i32> %v0
}

define <4 x i32> @load_factor5_one_active(ptr %ptr) {
; CHECK-LABEL: load_factor5_one_active:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 20
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vlse32.v v8, (a0), a1
; CHECK-NEXT:    ret
  %interleaved.vec = load <20 x i32>, ptr %ptr
  %v0 = shufflevector <20 x i32> %interleaved.vec, <20 x i32> poison, <4 x i32> <i32 0, i32 5, i32 10, i32 15>
  ret <4 x i32> %v0
}

define <2 x i16> @load_factor6_one_active(ptr %ptr) {
; CHECK-LABEL: load_factor6_one_active:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a0, a0, 10
; CHECK-NEXT:    li a1, 12
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vlse16.v v8, (a0), a1
; CHECK-NEXT:    ret
  %interleaved.vec = load <12 x i16>, ptr %ptr
  %v0 = shufflevector <12 x i16> %interleaved.vec, <12 x i16> poison, <2 x i32> <i32 5, i32 11>
  ret <2 x i16> %v0
}

define <4 x i8> @load_factor7_one_active(ptr %ptr) vscale_range(8,1024) {
; CHECK-LABEL: load_factor7_one_active:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a0, a0, 1
; CHECK-NEXT:    li a1, 7
; CHECK-NEXT:    vsetivli zero, 4, e8, mf8, ta, ma
; CHECK-NEXT:    vlse8.v v8, (a0), a1
; CHECK-NEXT:    ret
  %interleaved.vec = load <32 x i8>, ptr %ptr
  %v0 = shufflevector <32 x i8> %interleaved.vec, <32 x i8> poison, <4 x i32> <i32 1, i32 8, i32 15, i32 22>
  ret <4 x i8> %v0
}

define <4 x i8> @load_factor8_one_active(ptr %ptr) vscale_range(8,1024) {
; CHECK-LABEL: load_factor8_one_active:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 8
; CHECK-NEXT:    vsetivli zero, 4, e8, mf8, ta, ma
; CHECK-NEXT:    vlse8.v v8, (a0), a1
; CHECK-NEXT:    ret
  %interleaved.vec = load <32 x i8>, ptr %ptr
  %v0 = shufflevector <32 x i8> %interleaved.vec, <32 x i8> poison, <4 x i32> <i32 0, i32 8, i32 16, i32 24>
  ret <4 x i8> %v0
}

define void @load_factor4_one_active_storeback(ptr %ptr) {
; CHECK-LABEL: load_factor4_one_active_storeback:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 16
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vlse32.v v8, (a0), a1
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
  %interleaved.vec = load <16 x i32>, ptr %ptr
  %v0 = shufflevector <16 x i32> %interleaved.vec, <16 x i32> poison, <4 x i32> <i32 0, i32 4, i32 8, i32 12>
  store <4 x i32> %v0, ptr %ptr
  ret void
}

; TODO: This should be a strided load
define void @load_factor4_one_active_storeback_full(ptr %ptr) {
; CHECK-LABEL: load_factor4_one_active_storeback_full:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vsetivli zero, 4, e32, m2, ta, ma
; CHECK-NEXT:    vslidedown.vi v12, v8, 4
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vsetivli zero, 4, e32, m4, ta, ma
; CHECK-NEXT:    vslidedown.vi v16, v8, 8
; CHECK-NEXT:    vmv1r.v v15, v16
; CHECK-NEXT:    vslidedown.vi v16, v8, 12
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vsseg4e32.v v13, (a0)
; CHECK-NEXT:    ret
  %interleaved.vec = load <16 x i32>, ptr %ptr
  %v0 = shufflevector <16 x i32> %interleaved.vec, <16 x i32> poison, <16 x i32> <i32 0, i32 4, i32 8, i32 12, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  store <16 x i32> %v0, ptr %ptr
  ret void
}

define void @store_factor4_one_active(ptr %ptr, <4 x i32> %v) {
; CHECK-LABEL: store_factor4_one_active:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 16
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vsse32.v v8, (a0), a1
; CHECK-NEXT:    ret
  %v0 = shufflevector <4 x i32> %v, <4 x i32> poison, <16 x i32> <i32 0, i32 undef, i32 undef, i32 undef, i32 1, i32 undef, i32 undef, i32 undef, i32 2, i32 undef, i32 undef, i32 undef, i32 3,  i32 undef, i32 undef, i32 undef>
  store <16 x i32> %v0, ptr %ptr
  ret void
}

define void @store_factor4_one_active_idx1(ptr %ptr, <4 x i32> %v) {
; CHECK-LABEL: store_factor4_one_active_idx1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a0, a0, 4
; CHECK-NEXT:    li a1, 16
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vsse32.v v8, (a0), a1
; CHECK-NEXT:    ret
  %v0 = shufflevector <4 x i32> %v, <4 x i32> poison, <16 x i32> <i32 undef, i32 0, i32 undef, i32 undef, i32 undef, i32 1, i32 undef, i32 undef, i32 undef, i32 2, i32 undef, i32 undef, i32 undef, i32 3,  i32 undef, i32 undef>
  store <16 x i32> %v0, ptr %ptr
  ret void
}

define void @store_factor4_one_active_fullwidth(ptr %ptr, <16 x i32> %v) {
; CHECK-LABEL: store_factor4_one_active_fullwidth:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 16
; CHECK-NEXT:    vsetivli zero, 4, e32, m4, ta, ma
; CHECK-NEXT:    vsse32.v v8, (a0), a1
; CHECK-NEXT:    ret
  %v0 = shufflevector <16 x i32> %v, <16 x i32> poison, <16 x i32> <i32 0, i32 undef, i32 undef, i32 undef, i32 1, i32 undef, i32 undef, i32 undef, i32 2, i32 undef, i32 undef, i32 undef, i32 3,  i32 undef, i32 undef, i32 undef>
  store <16 x i32> %v0, ptr %ptr
  ret void
}

; TODO: This could be a vslidedown followed by a strided store
define void @store_factor4_one_active_slidedown(ptr %ptr, <4 x i32> %v) {
; CHECK-LABEL: store_factor4_one_active_slidedown:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vslidedown.vi v9, v8, 1
; CHECK-NEXT:    vslideup.vi v10, v8, 1
; CHECK-NEXT:    vmv.v.v v11, v10
; CHECK-NEXT:    vmv.v.v v12, v10
; CHECK-NEXT:    vsseg4e32.v v9, (a0)
; CHECK-NEXT:    ret
  %v0 = shufflevector <4 x i32> %v, <4 x i32> poison, <16 x i32> <i32 1, i32 undef, i32 undef, i32 undef, i32 2, i32 undef, i32 undef, i32 undef, i32 3, i32 undef, i32 undef, i32 undef, i32 4,  i32 undef, i32 undef, i32 undef>
  store <16 x i32> %v0, ptr %ptr
  ret void
}
