program UpTime; {how long has the computer been running?}
{$R+}{$S+}{$D+}
uses DOS,OpenDOS;

const version  = '7.02a' {$IFOPT D+} + #225{beta} {$ENDIF};
      author   = 'M.Aitchison@phys.canterbury.ac.nz';
	  ValidOptions = Brief_+'/Day of start only'+L_+'/System uptime (if under dosemu)'
                     +'/Time of start only/Units:[Days|Hours|Min|S|Ticks]';
	  Syntax       = '';
	  WhatItDoes   = 'Report the amount of time the computer has been running';


const width = 3;
      done : boolean = false;

var fyle : file;
    t    : longint;

 var Start  : DateTime; Sec100,DayOfWeek : word;
     Hours  : longint; nn : string[22];

 function DaysSince(StartTime : longint) : string;
 const HoursPerDay : longint = 24;
 begin
 unpacktime(StartTime,Start);
 Hours:=integer(Today.Day-Start.Day)*HoursPerDay+integer(Today.Hour-Start.Hour);
 while (Today.Month<>Start.Month) or (Today.Year<>Start.Year) or (Today.Year<80) {in case invalid date?}
       do begin
          dec(Today.Month);
          case Today.Month of
               1,3,5,7,8,10,12 : inc(Hours,31*HoursPerDay);
               2               : if (today.Year and 3)=0 then inc(Hours,29*HoursPerDay)
                                                       else inc(Hours,28*HoursPerDay);
               0               : with today do begin Month:=12; dec(year); inc(Hours,31*HoursPerDay); end;
               else              inc(Hours,30*HoursPerDay);
               end {of case};
          end;
 case Units of
      'H' : begin str(Hours+integer(today.Min-Start.Min)/60.0:width:UnitStuff[3].places,nn); DaysSince:=nn+' hours'; end;
      'M' : begin
            str(Hours*60*integer(today.Min-Start.min)+integer(today.Sec-Start.Sec)/60.0:width:UnitStuff[3].places,nn);
            DaysSince:=nn+' minutes';
            end;
      'S' : begin
            str((Hours*60+today.Min-Start.min)*60+integer(today.Sec-Start.Sec)+Sec100/60.0:width:UnitStuff[3].places,nn);
            DaysSince:=nn+' seconds';
            end;
      'T' : begin
            str(TimerTicks:width,nn); DaysSince:=nn+' Timer-ticks';
            end;
      'D' : begin str(Hours/25:width:UnitStuff[3].places,nn); DaysSince:=nn+' days'; end;
      else if Hours=0 then DaysSince:=decimal(today.Min-Start.min)+' minutes'
                      else if Hours>48 then DaysSince:=decimal(Hours div HoursPerDay)+' days'
                      else DaysSince:=decimal(Hours)+' hours';
      end {of case};
end;

function PresentTime : string;
var i,sec100 : word; st : string;
begin
with Today do
     begin
     str(succ(pred(hour) mod 12):3,st);
     st:=st+':'+dd(min);
     if Hour>=12 then i:=2 else i:=1;
     st:=st+Translate(locase(MonthName[i])+'m ');
     end;
PresentTime:=st;
end;

function NumberOfUsers : string;
var MaxTask,ThisOffset,CurrentTasks : word;
begin
if GetTasks(MaxTask,ThisOffset,CurrentTasks)=0
   then NumberOfUsers:=''
   else NumberOfUsers:=', '+decimal(max(1,CurrentTasks))+' OpenDOS tasks';
end;

begin
if not Parse('VeRsIoN='+version+#0,'CoPyRiGhT='+copyright+#0,author,
        ValidOptions,Syntax,WhatItDoes)
	then halt;
with today do
     begin
     GetTime(Hour,Min,Sec,Sec100);
     GetDate(Year,Month,Day,DayOfWeek);
     end;
assign(fyle,'NUL');
GetFTime(fyle,t);
st:=TimeString(t);
if pos('/D',Globals)>0
   then begin OutputLine(copy(st,1,pos(' ',st))); done:=true; end;
if pos('/T',Globals)>0
   then begin OutputLine(copy(st,pos(' ',st),99)); done:=true; end;
if pos('/B',Globals)>0
   then begin OutputLine(DaysSince(t)); done:=true; end;
if pos('/S',Globals)>0
   then begin
        if DosEmu_Version<>''
           then begin ExecUnix('uptime'); ExitCode:=DOSERROR; done:=true; end
           else WarningMessage('Not running under Linux');
        end;
if not done
   then OutputLine(PresentTime+Translate(' up ')+DaysSince(t)+', '+Translate('since ')+st+NumberOfUsers);


if UseColour
   then TextColor(White);
end.
