;       SHARE Extender, V2.0, (C), by Gennady S. Kolesnik, 1995

;       API functions codes:
INSTCHECK               equ     00h
EXTSERVICE              equ     01h
SETGLOBREADPATTERN      equ     02h
SETGLOBWRITEPATTERN     equ     03h
SETREADPATTERN          equ     04h
SETWRITEPATTERN         equ     05h
GETPATTERN              equ     06h
SETALWAYSONTOP          equ     07h

;       Files open modes:
READ                    equ     0h
WRITE                   equ     1h
RDWR                    equ     2h

;       Extended service modes:
ON                      equ     1h
OFF                     equ     0h
ALWAYS_ON_TOP           equ     1h

;       Sharing modes:
TEST_COMPAT_MODE        equ     11110000B
DENY_WRITE              equ     00100000B
DENY_ALL                equ     00010000B

;       Miscellanious constants:
ENV_ADDR                equ     2Ch
DEF_MUX_NO              equ     81h
CMD_LINE_LEN            equ     80h
CMD_LINE_OFS            equ     82h

        .186
        .model  tiny
        .code
        org     100h
Start:
        jmp     Main
ResData         label   byte
Signature       db      'ESFSS 2.0.', 0 ; Signature
Version         dw      0002h           ; Extender version
MuxNo           db      DEF_MUX_NO      ; Multiplex number
Old21           dd      0               ; Original INT 21h handler address
Old2F           dd      0               ; Original INT 2Fh handler address
Switch          db      ON              ; Extended service ON/OFF switch
SharingMode     label   word
ReadMode        db      DENY_WRITE      ; Bit pattern for read-only mode
WriteMode       db      DENY_ALL        ; Bit pattern for read-write mode
AlwaysOnTop     db      0               ; When set to ALWAYS_ON_TOP, 
                                        ; vectors 21h & 2Fh always point to
                                        ; extender
LastDrive       db      0               ; Drives number
DrvTable        dw      offset DrivesTable
;       int ToUpper(int Ch);
;       Uppercases the character
ToUpper         proc    near
        push    bp
        mov     bp, sp
        mov     al, [bp+4]
        cmp     al, 'a'
        jl      @UpperCase
        sub     al, 'a'
        add     al, 'A'
@UpperCase:
        xor     ah, ah
        pop     bp
        ret
ToUpper         endp

;       int WhatDrive(const char _far *path);
;       Determines the drive letter, specified in the path
;       If no drive letter specified in the path string, assumes
;       it's a current drive.
;       Returns the drive as: 0-A:, 1-B:, etc.
WhatDrive       proc    near
        push    bp
        mov     bp, sp
        push    bx
        push    es
        les     bx, [bp+4]
        cmp     byte ptr es:[bx+1], ':'         ; Check is drive letter
        jne     @CurDrive                       ; present in the path string
        push    es:[bx]                         ; If yes, uppercase it and
        call    ToUpper                         ; subtract 'A' to bring it
        inc     sp
        inc     sp
        sub     al, 'A'                         ; to digital presentation
        xor     ah, ah
        jmp     @WhatDriveEnd

@CurDrive:
        mov     ah, 19h                         ; If no, ask DOS for current
        pushf                                   ; drive
        call    dword ptr cs:Old21
        xor     ah, ah
@WhatDriveEnd:
        pop     es
        pop     bx
        pop     bp
        ret
WhatDrive       endp

; New INT 21h handler
New21   proc    far                     
        cmp     cs:AlwaysOnTop, ALWAYS_ON_TOP
        jne     CheckMode               ; If ALWAYS_ON_TOP mode is off, skip
                                        ; Fn 25h and 35h interception

; The following code is intended to process GetVect() and SetVect() DOS
; calls for 21h and 2Fh vectors when ALWAYS_ON_TOP mode is ON. This will
; force that GetVect() will return values of INT 21h and INT 2Fh that point
; to handlers used before SHARE Extender has been installed, and SetVect()
; will change Old21 and Old2F variables, leaving interrupts vectors unchanged,
; so these vectors will always call Extender's handlers first. By default
; this mode is turned OFF.
        cmp     ax, 3521h               ; Intercept reading of INT 21h vector
        jne     Check_SetVect21
        push    si
        lea     si, Old21               ; Lie to other TSRs - return previous 
        mov     bx, cs:[si+2]           ; INT 21h vector
        mov     es, bx
        mov     bx, cs:[si]
        pop     si
        retf    2

Check_SetVect21:
        cmp     ax, 2521h               ; Intercept changing of INT 21h vector
        jne     Check_GetVect2F         ; Change Old21 instead.
        push    bx
        lea     bx, Old21
        mov     cs:[bx], dx
        push    dx
        mov     dx, ds
        mov     cs:[bx+2], dx
        pop     dx
        pop     bx
        retf    2

Check_GetVect2F:
        cmp     ax, 352Fh               ; Intercept reading of INT 2Fh vector
        jne     Check_SetVect2F
        push    si
        lea     si, Old2F               ; Lie to other TSRs - return previous 
        mov     bx, cs:[si+2]           ; INT 2Fh vector
        mov     es, bx
        mov     bx, cs:[si]
        pop     si
        retf    2

Check_SetVect2F:
        cmp     ax, 252Fh               ; Intercept changing of INT 2Fh vector
        jne     CheckMode               ; Change Old2F instead
        push    bx        
        lea     bx, Old2F
        mov     cs:[bx], dx
        push    dx
        mov     dx, ds
        mov     cs:[bx+2], dx
        pop     dx
        pop     bx
        retf    2

CheckMode:
        cmp     cs:Switch, ON           ; Check extended service switch
        jne     CallOrigHandler         ; Extended service is OFF

        cmp     ah, 3Dh                 ; For greater performance check
        je      Process                 ; DOS function number twice - 
        cmp     ah, 6Ch                 ; if not 3Dh or 6Ch jump to original
        je      Process                 ; handler, otherwise process the call
        jmp     CallOrigHandler

Process:
        push    ax                      ; Determine drive number
        push    bx                      ; Save AX, BX, ES registers
        push    es
        push    ds                      ; Pass DS:DX path string to WhatDrive()
        push    dx                      ; function to determine which drive is
        call    WhatDrive               ; to be referenced
        add     sp, 4
        mov     bx, ax                  ; AX contains drive number
        shl     bx, 1                   
        lea     ax, cs:DrivesTable      
        add     bx, ax                  ; BX contains the offset of the
                                        ; record in the DrivesTable array
        mov     ax, cs:[bx]             ; AX contains open modes for the specified drive
        mov     cs:SharingMode, ax      ; Set SharingMode pattern
        pop     es                      ; Restore registers
        pop     bx
        pop     ax

        cmp     ah, 3Dh                 ; Check is it a call to DOS open() 
        jne     Check6C                 ; (3Dh) function

;       Process 3Dh DOS function call here
        test    al, TEST_COMPAT_MODE
        jnz     CallOrigHandler

        cmp     al, READ                ; Open file for reading?
        je      Read3D
;       File is open for writing - open in exclusive mode
        or      al, cs:WriteMode
        jmp     CallOrigHandler
Read3D:
        ;       File is open for reading - deny write
        or      al, cs:ReadMode
        jmp     CallOrigHandler

Check6C:
        cmp     ah, 6Ch
        jne     CallOrigHandler

;       Process 6Ch DOS function call here
        test    bl, TEST_COMPAT_MODE
        jnz     CallOrigHandler
        cmp     bl, READ           ; Is file goes to be open for reading?
        je      Read6C
        ;       File is open for writing - open in exclusive mode
        or      bl, cs:WriteMode
        jmp     CallOrigHandler
Read6C:
        ;       File is open for reading - deny write
        or      bl, cs:ReadMode

CallOrigHandler:
;       Call original INT 21h handler
        jmp     dword ptr cs:Old21
New21   endp

; New INT 2Fh handler
New2F   proc    far
        cmp     ah, cs:MuxNo
        je      ProcessMux
        jmp     ChainMux

ProcessMux:
; Installation check function
; If installed AL=0FFh, 
; ES keeps the segment address of the resident block,
; BL - read-only sharing mode for current drive,
; BH - read-write sharing mode for current drive,
; CX - extender version (CL - main number, CH - subversion number),
; DL=1 if extended service is ON,
;    0 - if extended service is OFF.

        cmp     al, INSTCHECK           
        jne     TurnExtService
        mov     ah, 19h
        pushf
        call    cs:Old21
        xor     ah, ah
        shl     ax, 1
        push    si
        mov     si, ax
        lea     ax, cs:DrivesTable
        add     si, ax
        mov     bx, cs:[si]
        pop     si
        mov     dl, cs:Switch
        mov     ax, cs
        mov     es, ax
        mov     cx, cs:Version
        mov     ax, 0FFFFh
        retf    2

TurnExtService:
; Turn extended service OFF
; BL=1 to turn ON,
; BL=0 to turn OFF
; If CH=0FFh CL-new multiplex number
        cmp     al, EXTSERVICE
        jne     SetGlobalReadPattern
        mov     cs:Switch, bl
        cmp     ch, 0FFh
        jne     QuitExtService
        mov     cs:MuxNo, cl
QuitExtService:
        retf    2

SetGlobalReadPattern:                         
; Set global read-only sharing mode
; BL contains sharing mode pattern        
        cmp     al, SETGLOBREADPATTERN
        jne     SetGlobalWritePattern
        push    si
        lea     si, cs:DrivesTable
        mov     cl, cs:LastDrive
        xor     ch, ch
@ReadNext:
        mov     cs:[si], bl
        inc     si
        inc     si
        loop    @ReadNext
        pop     si
        retf    2

SetGlobalWritePattern:
; Set global read-write sharing mode
; BL contains sharing mode pattern
        cmp     al, SETGLOBWRITEPATTERN
        jne     SetReadPattern
        push    si
        lea     si, cs:DrivesTable
        mov     cl, cs:LastDrive
        xor     ch, ch
@WriteNext:
        mov     cs:[si+1], bl
        inc     si
        inc     si
        loop    @WriteNext
        pop     si
        retf    2

SetReadPattern:
; Set read-only sharing mode for the specified drive
; BH contains drive (0 - A:, 1 - B:, etc.)
; BL contains sharing mode pattern
; Returns:
;   no errors:                  CF=0, AX=0
;   invalid drive letter:       CF=1, AX - DOS error code (invalid drive)
        cmp     al, SETREADPATTERN
        jne     SetWritePattern
        cmp     bh, cs:LastDrive
        jle     ContReadPattern
        mov     ax, 0Fh
        stc
        retf    2
ContReadPattern:
        push    si
        mov     si, bx
        shr     si, 7
        lea     dx, cs:DrivesTable
        add     si, dx
        mov     byte ptr cs:[si], bl
        xor     ax, ax
        pop     si
        clc
        retf    2

SetWritePattern:
; Set read-write sharing mode for the specified drive
; BH contains drive (0 - A:, 1 - B:, etc.)
; BL contains sharing mode pattern
; Returns:
;   no errors:                  CF=0, AX=0
;   invalid drive letter:       CF=1, AX - DOS error code (invalid drive)
        cmp     al, SETWRITEPATTERN
        jne     GetPattern
        cmp     bh, cs:LastDrive
        jle     ContWritePattern
        mov     ax, 0Fh
        stc
        retf    2
ContWritePattern:
        push    si
        mov     si, bx
        shr     si, 7
        lea     dx, cs:DrivesTable
        add     si, dx
        mov     byte ptr cs:[si+1], bl
        xor     ax, ax
        pop     si
        clc
        retf    2

GetPattern:
; Get read-only pattern for the specified drive
; BH - drive
; Returns:
;       AL - read-only pattern
;       AH - read-write pattern
        cmp     al, GETPATTERN
        jne     SetAlwaysOnTop
        cmp     bh, cs:LastDrive
        jnle    InvDrive
        push    si
        mov     si, bx
        shr     si, 7
        lea     ax, cs:DrivesTable
        add     si, ax
        mov     ax, cs:[si]
        pop     si
        clc
        retf    2
InvDrive:
        mov     ax, 0Fh
        stc
        retf    2

SetAlwaysOnTop:
; Turn ALWAYS_ON_TOP mode ON/OFF, get current state
; BX=0 - do not change ALWAYS_ON_TOP mode
; BX=1 - turn ALWAYS_ON_TOP mode OFF
; BX=2 - turn ALWAYS_ON_TOP mode ON
; Returns current state in AX if CF=0 or error code if CF=1
        cmp     al, SETALWAYSONTOP
        jne     ChainMux
        cmp     bx, 2
        jle     ContAlwaysOnTop
        mov     ax, 1           ; Invalid function number
        stc
        retf    2
ContAlwaysOnTop:
        cmp     bx, 0
        je      ReturnState
        cmp     bx, 1
        jne     CheckOn
        mov     cs:AlwaysOnTop, 0
        jmp     ReturnState
CheckOn:
        mov     ax, 3521h
        pushf
        call    dword ptr cs:Old21
        mov     ax, es
        mov     cx, cs
        cmp     ax, cx
        je      Check2F
        mov     ax, 5           ; Access denied
        stc
        retf    2
Check2F:
        mov     ax, 352Fh
        pushf
        call    dword ptr cs:Old21
        mov     ax, es
        mov     cx, cs
        cmp     ax, cx
        je      TurnOnTopON
        mov     ax, 5           ; Access denied
        stc
        retf    2
TurnOnTopON:
        mov     cs:AlwaysOnTop, 1
ReturnState:
        mov     al, cs:AlwaysOnTop
        and     ax, 0FFh
        clc
        retf    2

ChainMux:                               ; Chain multiplex interrupt
        jmp     dword ptr cs:Old2F
New2F   endp
ResEnd          label   byte
DrivesTable     dw      256 dup(DENY_WRITE+DENY_ALL*256)

;       *****************       End of resident part       *****************

;       *****************         Nonresident part         *****************
NonResident     label   byte
Install proc    near
;       Check is SHARE installed
        mov     ax, 1000h
        int     2Fh
        cmp     al, 0FFh
        jne     NoShare

;       SHARE installed - check is patch installed
        mov     ah, DEF_MUX_NO
        mov     al, INSTCHECK
        int     2Fh
        cmp     al, 0FFh
        je      AlreadyInstalled

;       Patch not installed
        mov     ax, 352Fh       ;       Set new INT 2FH handler
        int     21h
        lea     si, cs:Old2F
        mov     cs:[si], bx
        mov     ax, es
        mov     cs:[si+2], ax
        mov     ax, 252Fh
        lea     dx, New2F
        int     21h
        mov     ax, 3521h       ;       Set new INT 21H handler
        int     21h
        lea     si, cs:Old21
        mov     cs:[si], bx
        mov     ax, es
        mov     cs:[si+2], ax
        mov     ax, 2521h
        lea     dx, New21
        int     21h
        mov     bx, 2Ch
        mov     ax, cs:[bx]
        mov     es, ax
        mov     ah, 49h
        int     21h
        jmp     Resident

AlreadyInstalled:
        lea     dx, AlreadyInstMsg
        jmp     NotResidentQuit

NoShare:                                ; Share not installed
        lea     dx, NoShareMsg
        jmp     NotResidentQuit

NotResidentQuit:                        ; Non-resident quit
        ret
Resident:                               ; Resident quit
        lea     dx, InstalledMsg        ; Print message
        mov     ah, 9h
        int     21h
        cmp     AlwaysOnTop, 0
        je      SkipAlwaysOnTop
        lea     dx, AlwaysOnTopMsg
        mov     ah, 9h
        int     21h
SkipAlwaysOnTop:
        mov     ah, 19h                 ; Determine disk drives number
        int     21h
        mov     dx, ax
        mov     ah, 0Eh
        int     21h
        and     ax, 0FFh
        mov     LastDrive, al
        push    ax                      ; Print LastDrive= message
        add     al, 'A'-1
        mov     LastDriveLetter, al
        mov     ah, 9h
        lea     dx, LastDriveMsg
        int     21h
        pop     ax
        shl     ax, 1
        lea     dx, ResEnd              ; Stay resident
        add     dx, ax
        int     27h
Install         endp

Uninstall       proc    near
;       Check is extended service installed
        mov     al, INSTCHECK
        mov     ah, DEF_MUX_NO
        int     2Fh
        cmp     al, 0FFh
        jne     NotInstalled

        cmp     ah, 0FFh
        jne     WrongVersion
        cmp     cx, Version
        jne     WrongVersion

;       Check is it safe to uninstall
        mov     ah, DEF_MUX_NO          ; Get ALWAYS_ON_TOP mode
        mov     al, SETALWAYSONTOP      ; If ON it is always safe to
        xor     bx, bx                  ; uninstall
        int     2Fh
        jc      NotSafe                 ; Quit on error
        cmp     ax, 1
        je      Safe

        push    es
        mov     ax, 3521h
        int     21h
        mov     bx, es
        pop     es
        mov     ax, es
        cmp     ax, bx
        jne     NotSafe

        push    es
        mov     ax, 352Fh
        int     21h
        mov     bx, es
        pop     es
        mov     ax, es
        cmp     ax, bx
        jne     NotSafe
        jmp     Safe

NotInstalled:
        lea     dx, NotInstMsg
        ret     
NotSafe:
        lea     dx, VectIntrcptMsg
        ret
WrongVersion:
        lea     dx, WrongVerMsg
        ret
Safe:
;       Turn ALWAYS_ON_TOP mode OFF.
        mov     ah, DEF_MUX_NO
        mov     al, SETALWAYSONTOP
        mov     bx, 1
        int     2Fh
        jc      NotSafe

        push    ds
        push    es
        lea     si, es:Old21    ; Restore INT 21h handler
        mov     dx, es:[si]
        mov     ax, es:[si+2]
        mov     ds, ax
        mov     ax, 2521h
        int     21h
        pop     es        
        
        push    es
        lea     si, es:Old2F    ; Restore INT 2Fh handler
        mov     dx, es:[si]
        mov     ax, es:[si+2]
        mov     ds, ax
        mov     ax, 252Fh
        int     21h
        pop     es
        pop     ds

        mov     ah, 49h         ; Release resident block
        int     21h
        lea     dx, UninstalledMsg
        ret
Uninstall       endp

Main:
;       Check computer type
        mov     ax, 0F000h
        mov     es, ax
        mov     bx, 0FFFEh
        mov     al, es:[bx]
        cmp     al, 0FCh
        jne     CheckPS2
        jmp     CheckDOS
CheckPS2:
        cmp     al, 0F8h
        je      CheckDOS
        lea     dx, WrongPCMsg
        jmp     NotResident

;       Check DOS version
CheckDOS:
        mov     ah, 30h                 ; Get DOS version
        int     21h
        cmp     al, 04h                 ; Not running on DOS older than 4.00
        jl      WrongDOS
        
        mov     bx, ENV_ADDR            ; Release environment block
        mov     ax, cs:[bx]
        mov     es, ax
        mov     ah, 49h
        int     21h

        mov     bx, CMD_LINE_LEN        ; Parse command line
        cmp     byte ptr [bx], 2
        jnl     ProcCmdLine
        call    Install
        jmp     NotResident

ProcCmdLine:
        cmp     byte ptr [bx+3], 'u'
        jne     NextKey1
        jmp     Uninst

NextKey1:
        cmp     byte ptr [bx+3], 'U'
        jne     NextKey2
        jmp     Uninst

NextKey2:
        cmp     byte ptr [bx+3], '?'
        jne     NextKey3
        lea     dx, HelpMsg
        jmp     NotResident

NextKey3:
        cmp     byte ptr [bx+3], 't'
        jne     NextKey4
        mov     AlwaysOnTop, 1
        call    Install
        jmp     NotResident

NextKey4:
        cmp     byte ptr [bx+3], 'T'
        jne     WrongKey
        mov     AlwaysOnTop, 1
        call    Install
        jmp     NotResident

WrongDOS:
        lea     dx, WrongDOSMsg
        jmp     NotResident

Uninst:
        call    Uninstall
        jmp     NotResident

WrongKey:
        lea     dx, WrongKeyMsg

NotResident:    ;       Non-resident quit
        mov     ah, 9h
        int     21h
        mov     ax, 4C00h
        int     21h

        .data
InstalledMsg    db      'SHARE extended service installed.', 10, 13, '$'
UninstalledMsg  db      'SHARE extended service uninstalled.', 10, 13, '$'
AlwaysOnTopMsg  db      'Interrupts vectors are intercepted using ''Always-On-Top'' technique.', 10, 13
                db      'SHARE extended service may be uninstalled any moment.', 10, 13, '$'
LastDriveMsg    db      'LastDrive='
LastDriveLetter db      0, ':', 10, 13, '$'

AlreadyInstMsg  db      'SHARE extended service support already installed.', 10, 13, '$'
NotInstMsg      db      'SHARE extended service support not installed.', 10, 13, '$'
NoShareMsg      db      'SHARE not installed.', 10, 13, '$'
WrongPCMsg      db      'AT or PS/2 compatible computer required.', 10, 13, '$'
WrongDOSMsg     db      'Incorrect DOS version.', 10, 13, '$'
WrongKeyMsg     db      'Wrong command line option specified.', 10, 13, '$'
VectIntrcptMsg  db      'Not safe to uninstall.', 10, 13, '$'
WrongVerMsg     db      'Wrong ESFSS version.', 10, 13, '$' 

HelpMsg         db      'Shared file system extended service V2.0, (C), by Gennady S. Kolesnik, 1995', 10, 13
                db      'Usage:', 10, 13, 9
                db      'SHAREEXT [/?|/t|/u]', 10, 13, 9, 9
                db      '/? - get this help screen,', 10, 13, 9, 9
                db      '/t - install using Always-On-Top technique.', 10, 13, 9, 9
                db      '/u - uninstall extended service support.', 10, 13, 9
                db      'Use SHEXTCTL to control the extended services mode.', 10, 13, 10, 10
Copyright       db      'This program is a shareware product, that may be used FOR YOUR OWN NEEDS ONLY', 10, 13
                db      'FREE OF CHARGE. This program MAY NOT be distributed within other commercial', 10, 13
                db      'software packages. NO FEES may be taken for this program. No code modifi-', 10, 13
                db      'cations allowed.', 10, 13, '$'
ParmCount       dw      0
CurParm         dw      0

        public  Signature
        public  ResData
        public  NonResident
        public  New21
        public  New2F
        public  WhatDrive
        public  ToUpper
        public  Version
        public  MuxNo
        public  Old21
        public  Old2F
        public  Switch
        public  ReadMode
        public  WriteMode
        public  AlwaysOnTop
        public  LastDrive
        public  DrvTable
        end     Start
