/* Copyright (C) 2002 Aitor Santamaria_Merino <aitor.sm@wanadoo.es> */

/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef __ISHRDDRV_H__
#define __ISHRDDRV_H__

#include "CExt.h"

//////////// PART 1:  HD DETECTION  ////////////////////////////////////

#define DISALLOW_REMOTE_DRIVE
//#define DISALLOW_RAMDISK
#define DISALLOW_REMOVABLE_DRIVE
#define DISALLOW_CDROM

/* uncomment the below to allow checking is drive is REMOVABLE,
   note: if this is commented then DISALLOW_REMOVABLE_DRIVE has no effect
*/
#define PERFORM_REMOVABLE_CHECK

/* uncomment the below to allow checking for CDROM via MSCDEX,
   note: if this is commented then DISALLOW_CDROM has no effect
*/
#define PERFORM_CDROM_CHECK


///// Defines for various types of devices
#define DRV_INVALID 0
#define DRV_EXISTS 1
#define DRV_IFS 2      // remote/cd/etc
#define DRV_CDROM 4    // cd-rom as determined by MSCDEX or equivalent
#define DRV_RAMDISK 8  // ramdisk & under NT5 NTFS drive
#define DRV_REMOVABLE 16

/* returns status of drivenum, 1=A:,2=B:, ... */
BYTE isHardDrive (BYTE drivenum);

#endif /* __ISHRDDRV_H__ */
