/* Copyright (C) 2002 Aitor Santamaria_Merino <aitor.sm@wanadoo.es> */

/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdlib.h>  // for NULL
#include <string.h>
#include "FS_INIT.H"
#include "FILLTBL.H"
#include "ISPRGAVL.H"
#include "INT24.H"
#include "FS_CMDS.H"
#include "GLOBALS.H"


// if you really really want to put a ; after BUILDCMD or BUILDCMDMONO
// then alter from { ... } to do { ... } while (0)

#define BUILDCMD(buffer, flag, progname) \
{ \
  if (aflg_##flag) \
  { \
    if ((buffer = (char *)malloc(2 + strlen(cmd_##flag) + strlen(progname##_OPT))) == NULL) \
      aflg_##flag = 0; \
    else \
    { \
      strcpy(buffer, cmd_##flag); \
      strcat(buffer, " "); \
      strcat(buffer, progname##_OPT); \
      \
      cmd_##flag = buffer; \
    } \
  } \
}

#define BUILDCMDMONO(buffer, flag, progname) \
{ \
  if (aflg_##flag) \
  { \
    if ((buffer = (char *)malloc(3 + strlen(cmd_##flag) + strlen(progname##_OPT) + strlen(progname##_OPT_MONO))) == NULL) \
      aflg_##flag = 0; \
    else \
    { \
      strcpy(buffer, cmd_##flag); \
      strcat(buffer, " "); \
      strcat(buffer, progname##_OPT); \
      strcat(buffer, " "); \
      strcat(buffer, progname##_OPT_MONO); \
      \
      cmd_##flag = buffer; \
    } \
  } \
}

// Don't forget isProgramAvailable returns a pointer to static buffer (overwritten each call)
#define CHECKFOR(flag, progname) aflg_##flag = ((cmd_##flag = isProgramAvailable(progname, PROGRAM_EXT)) != NULL)

/* initializes global data & any other necessary initialization */
void fmtsys_init ( void )
{
      char *cmdbuffer;
      int mono = 0;   // TODO: eventually add check for monochrome mode

      // register our handlers (be sure to uninstall before exiting)
      install_24();
      atexit(uninstall_24);

      // get list of valid drives
	filltable();


      // check for each external program

      // build full paths (do not put a ; after BUILDCMD/BUILDCMDMONO
      CHECKFOR(format, FORMAT_COMMAND);
#ifdef FORMAT_COMMAND_OPT_MONO
      if (mono)
        BUILDCMDMONO(cmdbuffer, format, FORMAT_COMMAND)
      else
#endif
        BUILDCMD(cmdbuffer, format, FORMAT_COMMAND)

      CHECKFOR(qformat, QFORMAT_COMMAND);
#ifdef QFORMAT_COMMAND_OPT_MONO
      if (mono)
        BUILDCMDMONO(cmdbuffer, qformat, QFORMAT_COMMAND)
      else
#endif
        BUILDCMD(cmdbuffer, qformat, QFORMAT_COMMAND)

      CHECKFOR(sys, SYS_COMMAND);
#ifdef SYS_COMMAND_OPT_MONO
      if (mono)
        BUILDCMDMONO(cmdbuffer, sys, SYS_COMMAND)
      else
#endif
        BUILDCMD(cmdbuffer, sys, SYS_COMMAND)

      CHECKFOR(ranishpm, PMANAGER_COMMAND);
#ifdef PMANAGER_COMMAND_OPT_MONO
      if (mono)
        BUILDCMDMONO(cmdbuffer, ranishpm, PMANAGER_COMMAND)
      else
#endif
        BUILDCMD(cmdbuffer, ranishpm, PMANAGER_COMMAND)

      CHECKFOR(fdisk, FDISK_COMMAND);
#ifdef FDISK_COMMAND_OPT_MONO
      if (mono)
        BUILDCMDMONO(cmdbuffer, fdisk, FDISK_COMMAND)
      else
#endif
        BUILDCMD(cmdbuffer, fdisk, FDISK_COMMAND)

      CHECKFOR(fips, FIPS_COMMAND);
#ifdef FIPS_COMMAND_OPT_MONO
      if (mono)
        BUILDCMDMONO(cmdbuffer, fips, FIPS_COMMAND)
      else
#endif
        BUILDCMD(cmdbuffer, fips, FIPS_COMMAND)

        
        // disable commands that don't make sense if there is no drive
        if (list == NULL)
        {
          aflg_format = 0;
          aflg_qformat = 0;
          aflg_sys = 0;
        }
}
