/* Copyright (C) 2002 Aitor Santamaria_Merino <aitor.sm@wanadoo.es> */

/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdlib.h>
#include <stdio.h>
#include <conIO.h>
#include <string.h>

#include "DRAWTBL.H"
#include "STRREP.H"
#include "SHRTSIZE.H"
#include "HDTBL.H"
#include "ISHRDDRV.H"
#include "GLOBALS.H"


#define TBL_START_X 7
#define TBL_START_Y 9
#define TBL_WIDTH 38   /* including border lines */

/* draws the given line in table for drive in list specified by
   offset num (ie num is index in table, not drive letter).
   If act is true then draw this one as selected, otherwise 
   draw as unselected (not active choice).
*/
void hddraw (BOOL act, BYTE num)
{
	char incl[10];
	char ruler[/*31*/40];
	hdtbl *phd = gethd(num);

	if (!phd) return;
	strrep (ruler, ' ', TBL_WIDTH-2);
	/* update string: letter, label and size */
	ruler[1] = phd->letter + 'A' - 1;
	ruler[3] = '(';
	memcpy (ruler+4,phd->label,strlen(phd->label));
	ruler[4+strlen(phd->label)] = ')';

	shortsize (incl, phd->size);          // string in form '####.#XB'
	memcpy (ruler+17,incl,strlen(incl));
	ruler[26] = '/';
	shortsize (incl, phd->total);
	memcpy (ruler+27,incl,strlen(incl));

	/* printing */
	textbackground (1 + (!!act * 6));
	gotoxy ( TBL_START_X+1, TBL_START_Y+num-base);
	cputs (ruler);
	textbackground (1);
}


/* draws the complete table, all drives in list (within scroll window) */
void drawalltable(void)
{
	BYTE i,end;
	char s[TBL_WIDTH+1];

	/** Headers of the Box **/
	gotoxy (TBL_START_X+3,TBL_START_Y-1);
	cputs ("Drive            Space available");

	/** TB of the Box **/
	strrep (s,'',TBL_WIDTH);
	s[0]=''; s[TBL_WIDTH-1]='';
	gotoxy (TBL_START_X,TBL_START_Y);
	cputs (s);
	strrep (s,'',TBL_WIDTH);
	s[0]=''; s[TBL_WIDTH-1]='';
	if (maxhd > MAXHDSHOW)
		gotoxy (TBL_START_X, TBL_START_Y+1+MAXHDSHOW);
	else
		gotoxy (TBL_START_X, TBL_START_Y+1+maxhd);
	cputs (s);

	/** Rows and LR of the box **/
	if (maxhd > MAXHDSHOW)
		end = MAXHDSHOW;
	else
		end = maxhd;
	for (i=1; i<=end; i++)
	{
		hddraw ((i+base)==cursor, (i+base));
		gotoxy (TBL_START_X,TBL_START_Y+i); cputs ("");
		gotoxy (TBL_START_X+TBL_WIDTH-1,TBL_START_Y+i); cputs ("");
	}
}
