{
    This file is the source for a series of routines to read the BIOS
    configuration area.
    Copyright (C) 1998 by Phil Brutsche

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the
    Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA  02111-1307  USA.
}

program getConfiguration;

uses dos, strs;

const indent = '     ';

type
  tromtable = record
    size : word;
    model : byte;
    submodel : byte;
    revision : byte;
    features : array [1..5] of byte;
  end;
  bios_str = array [1..8] of char;

var
  regs : registers;
  romtable : ^tromtable;
  bios_date : ^bios_str;
  computer_type : string;
  model, submodel, revision : byte;

begin
  regs.ah := $c0;
  intr ($15, regs);
  romtable := ptr (regs.es, regs.bx);
  model := romtable^.model;
  submodel := romtable^.submodel;
  revision := romtable^.revision;
  bios_date := ptr ($F000, $FFF5);
  computer_type := 'Unknown system model';
  case model of
    $ff : begin
      case submodel of
        $00 : computer_type := 'Tandy 1000SL';
        $01 : computer_type := 'Tandy 1000TL';
        $40 : computer_type := 'Olivetti M15';
        else begin
          if bios_date^ = '04/24/81' then
            computer_type := 'Original PC'
          else if bios_date^ = '10/19/81' then
            computer_type := 'Original bugfixed PC'
          else if bios_date^ = '10/27/82' then
            computer_type := 'Original PC with 640K, HD and EGA';
        end;
      end;
    end;
    $fe : begin
      case submodel of
        $43 : computer_type := 'Olivetti M240';
        $A6 : computer_type := 'Quadram Quad386';
        else begin
          if bios_date^ = '08/16/82' then
            computer_type := 'PC XT'
          else if bios_date^ = '11/08/82' then
            computer_type := 'PC XT or Portable';
        end;
      end;
    end;
    $fd : begin
      if bios_date^ = '06/01/83' then
        computer_type := 'PCjr';
    end;
    $fc : begin
      case submodel of
        $00 : case revision of
          $00 : computer_type := 'PC3720/AT';
          $01 : if bios_date^ = '06/10/85' then
            computer_type := 'AT model 239'
          else
            computer_type := '7531/2 Industrial AT';
        end; { case revision $00 }
        $01 : if (revision = $04) and (bios_date^ = '02/25/93') then
          computer_type := 'DOSEmu'
        else
          computer_type := 'AT Clone';
        $02 : begin
          if bios_date^ = '08/11/88' then
            computer_type := 'SoftWindows'
        end;
        $04 : begin
          if (bios_date^ = '02/13/87') and (revision = $00) then
            computer_type := 'PS/2 Model 50 (''286 @ 10 MHz)'
          else if (bios_date^ = '05/09/87') and (revision = $01) then
            computer_type := 'PS/2 Model 50 (''286 @ 10 MHz)'
          else if (revision = $02) and (bios_date^ <> '01/28/88') then
            computer_type := 'PS/2 Model 50 (''286 @ 10 MHz)'
          else
            computer_type := 'PS/2 Model 50Z (''286 @ 10 MHz)';
        end;
        $05 : computer_type := 'PS/2 Model 60 (''286 @ 10 MHz)';
        $06 : begin
          case revision of
            $00 : computer_type := 'IBM 7552-140 "Gearbox"';
            $01 : computer_type := 'IBM 7552-540 "Gearbox"';
          end;
        end;
        $09 : computer_type := 'PS/2 Model 25 or Model 30';
        else begin
          if bios_date^ = '01/10/84' then
            computer_type := 'AT model 068 or model 099'
        end;
      end;
    end;
    $fa : begin
      case submodel of
        $00 : computer_type := 'PS/2 Model 30 (8 MHz ''86)';
        $01 : computer_type := 'PS/2 Model 25/25L (8 MHz ''86)';
        $30 : computer_type := 'IBM Restaurant Terminal';
        $FE : computer_type := 'IBM PCradio 9075';
      end;
    end;
    $f8 : begin
      case submodel of
        $00 : begin
          if revision = $00 then begin
            if bios_date^ = '03/30/87' then
              computer_type := 'PS/2 Model 80 (16 MHz ''386)'
            else
              computer_type := 'PS/2 Model 75 486 (33 Mhz ''486)'
          end;
        end;
        $01 : computer_type := 'PS/2 Model 80 (20 MHz ''386)';
        $02 : computer_type := 'PS/2 Model 55-5571';
        $04 : computer_type := 'PS/2 Model 70 (20 MHz ''386DX)';
        $05 : computer_type := 'IBM PC 7568';
        $06 : computer_type := 'PS/2 Model 55-5571';
        $07 : begin
          case revision of
            $00 : computer_type := 'IBM PC 7561/2';
            $01 : computer_type := 'PS/2 Model 55-5551';
            $02 : computer_type := 'IBM PC 7561/2';
            $03 : computer_type := 'PS/2 Model 55-5551';
          end;
        end;
        $09 : computer_type := 'PS/2 Model 70 (16 MHz ''386DX)';
        $0B : computer_type := 'PS/2 Model P70';
        $0C : computer_type := 'PS/2 Model 55SX (16 MHz ''386SX)';
        $0D : begin
          if bios_date^ = '12/01/89' then
            computer_type := 'PS/2 Model 70 (25 MHz ''486)'
          else
            computer_type := 'PS/2 Model 70 (25 MHz ''386)';
        end;
        $0E : computer_type := 'PS/1 ''486SX';
        $0F : computer_type := 'PS/1 ''486DX';
        $10 : computer_type := 'PS/2 Model 55-5551';
        $11 : computer_type := 'PS/2 Model 90 XP (25 MHz ''486)';
        $12 : computer_type := 'PS/2 Model 95 XP';
        $13 : computer_type := 'PS/2 Model 90 XP (33 MHz ''486)';
        $14 : computer_type := 'PS/2 Model 90-AK9 (25 MHz ''486) or 95 XP';
        $15 : computer_type := 'PS/2 Model 90 XP';
        $16 : computer_type := 'PS/2 Model 90-AKD/95XP486 (33 MHz ''486)';
        $17 : computer_type := 'PS/2 Model 90 XP';
        $19 : computer_type := 'PS/2 Model 35/35LS/35SX/40/40SX (20 MHz ''386 SX)';
        $1A : computer_type := 'PS/2 Model 95 XP';
        $1B : begin
          computer_type := 'PS/2 Model 70-486';
          if bios_date^ = '09/29/89' then
            computer_type := computer_type + ' (25 MHz ''386DX)'
          else
            computer_type := computer_type + ' (25 MHz ''486)';
        end;
        $1C : computer_type := 'PS/2 Model 65-121/65SX (16 MHz ''386SX)';
        $1E : computer_type := 'PS/2 Model 55LS (16 MHz ''386SX)';
        $23 : computer_type := 'PS/2 Model L40 SX (20 MHz ''386SX)';
        $25 : begin
          case revision of
            $00 : computer_type := 'PS/2 Model 57 SLC';
            $06 : computer_type := 'PS/2 Model M57 (20 MHz ''386SLC)';
            $09 : computer_type := 'PS/2 Model 56 SLC (20 MHz ''386SLC)';
          end;
        end;
        $26 : begin
          case revision of
            $00 : computer_type := 'PS/2 Model 57 SX';
            $01 : computer_type := 'PS/2 Model 57 (20 MHz ''386SX)';
            $02 : computer_type := 'PS/2 Model 57 SX (20 MHz ''386SX, SCSI)';
          end;
        end;
        $28 : computer_type := 'PS/2 Model 95 XP';
        $29 : computer_type := 'PS/2 Model 90 XP';
        $2A : computer_type := 'PS/2 Model 95 XP (50 MHz ''486DX)';
        $2B : computer_type := 'PS/2 Model 90/90XP486 (50 MHz ''486DX)';
        $2C : begin
          case revision of
            $02 : computer_type := 'PS/2 Model 95 XP';
            $01 : computer_type := 'PS/2 Model 95 (20 MHz ''486SX)';
          end;
        end;
        $2D : computer_type := 'PS/2 Model 90 XP (20 MHz ''486SX)';
        $2E : begin
          computer_type := 'PS/2 Model 95 XP/XP486';
          if revision = $01 then
            computer_type := 'PS/2 Model 95 (20 MHz ''486SX + ''487SX)';
        end;
        $2F : computer_type := 'PS/2 Model 90 XP (20 MHz ''486SX + ''487SX)';
        $30 : computer_type := 'PS/1 Model 2121 (16 MHz ''386SX)';
        $33 : computer_type := 'PS/2 Model 30-''386';
        $34 : computer_type := 'PS/2 Model 25-''386';
        $36 : computer_type := 'PS/2 Model 95 XP';
        $37 : computer_type := 'PS/2 Model 90 XP';
        $38 : computer_type := 'PS/2 Model 57';
        $39, $40 : computer_type := 'PS/2 Model 95 XP';
        $3F : computer_type := 'PS/2 Model 90 XP';
        $41 : computer_type := 'PS/2 Model 77';
        $45 : computer_type := 'PS/2 Model 90 XP (Pentium)';
        $46 : computer_type := 'PS/2 Model 95 XP (Pentium)';
        $47 : computer_type := 'PS/2 Model 90/95 E (Pentium)';
        $48 : computer_type := 'PS/2 Model 85';
        $49 : computer_type := 'PS/ValuePoint 325T';
        $4A : computer_type := 'PS/ValuePoint 425SX';
        $4B : computer_type := 'PS/ValuePoint 433DX';
        $4E : computer_type := 'PS/2 Model 295';
        $50 : computer_type := 'PS/2 Model P70';
        $52 : computer_type := 'PS/2 Model P75 (33 MHz ''486)';
        $56 : computer_type := 'PS/2 Model CL57 SX';
        $57, $59, $5B : computer_type := 'PS/2 Model 90 XP';
        $58, $5A, $5C : computer_type := 'PS/2 Model 95 XP';
        $5D : computer_type := 'PS/2 Model N51 SLC';
        $5E : computer_type := 'IBM ThinkPad 700';
        $80 : computer_type := 'PS/2 Model 80 (20 MHz ''386)';
        $81 : computer_type := 'PS/2 Model 55-5502';
        $87 : computer_type := 'PS/2 Model N33SX';
        $88 : computer_type := 'PS/2 Model 55-5530T';
        $97 : computer_type := 'PS/2 Model 55 Note N23SX';
        $99 : computer_type := 'PS/2 Model N51 SX';
      end;
    end;
  end;
  if model = $e1 then computer_type := 'PS/2 Model 55-5530';
  writeln ('System information:');
  write (indent + 'BIOS Model is ' + dectohex8 (model) + dectohex8 (submodel)
         + dectohex8 (revision));
  writeln (' (' + computer_type + ')');
  writeln (indent + 'BIOS Date is ' + bios_date^);
end.
