#!/bin/sh
#
# bbchkhosts.sh:	Check the host file for invalid entries
#
# Version 1.9
# Mar 13th, 2002
#
# (c) Copyright Quest Software, Inc.  1997-2002  All rights reserved.
#

# Check if the BB program paths are correct
#
exec < /dev/null

OLDIFS=$IFS
IFS='='
set `grep "^BBHOME" ../runbb.sh 2>/dev/null` >/dev/null 2>&1
IFS=$OLDIFS
if [ "$#" -ne 2 ]
then
	echo "BBHOME is not set in runbb.sh"
else
	bbhome=`eval "echo $2"`
	if [ ! -d "$bbhome" ]
	then
		echo "\"$bbhome\" is not a valid directory for BBHOME"
	fi
fi

BBHOME=$bbhome;export BBHOME

. ./bbdef.sh


echo
echo "If any comments are displayed, please fix the entries in your configuration"
echo
echo "Note that some error messages may be for tags of external scripts"
echo

grep "^[0-9]" ./bb-hosts |\
while read line
do
	# A config line needs at least two parameters
	set $line
	if [ "$#" -lt 2 ]
	then
		echo "bb-hosts: \"$line\" -- missing information"
		echo ""
		contiue
	fi
	numargs=$#
	arg1=$1
	shift
	arg99=$*
	OLDIFS=$IFS
	IFS=.
	set $arg1
	IFS=$OLDIFS
	# Is it a valid ip address
	if [ "$#" -ne 4 ]
	then
		echo "bb-hosts: \"$line\" -- invalid IP address"
		echo ""
		continue
	fi

	ipmatch=`echo "$arg1" | grep "^[0-9.]*$" 2>/dev/null`
	if [ "$ipmatch" = "" ]
	then
		echo "bb-hosts: \"$line\" -- invalid IP address"
		echo ""
		continue
	fi

	if [ "$1" -lt 0 -o "$1" -gt 255 ]
	then
		echo "bb-hosts: \"$line\" -- invalid IP address"
		echo ""
		continue
	fi
	if [ "$2" -lt 0 -o "$2" -gt 255 ]
	then
		echo "bb-hosts: \"$line\" -- invalid IP address"
		echo ""
		continue
	fi

	if [ "$3" -lt 0 -o "$3" -gt 255 ]
	then
		echo "bb-hosts: \"$line\" -- invalid IP address"
		echo ""
		continue
	fi

	if [ "$4" -lt 0 -o "$4" -gt 255 ]
	then
		echo "bb-hosts: \"$line\" -- invalid IP address"
		echo ""
		continue
	fi

	set $arg99
	
	arg1=$1
	shift
	arg99=$*
	# If FQDN is set, is the hostname valid
	if [ "$FQDN" = TRUE ]
	then
		OLDIFS=$IFS
		IFS=.
		set $arg1
		IFS=$OLDIFS
		if [ "$#" -lt 3 ]
		then
			echo "bb-hosts: \"$line\" -- invalid host name (FQDN=TRUE)"
			echo ""
			continue
		fi
	fi

	if [ "$numargs" -eq 2 ]
	then
		continue
	fi

	set $arg99
	
	arg1=$1
	shift
	arg99=$*
	# If the 3rd arg of cfg line is not a '#', then an alias was defined
	if [ "$arg1" != "#" ]
	then
		if [ "$FQDN" = "TRUE" ]
		then
			OLDIFS=$IFS
			IFS=.
			set $arg1
			IFS=$OLDIFS
			if [ "$#" -lt 3 ]
			then
				echo "bb-hosts: \"$line\" -- invalid alias name (FQDN=TRUE)"
				echo ""
				continue
			fi
		fi
	fi

	# Any more arguments ?
	if [ -z "$arg99" ]
	then
		continue
	fi

	for param in $arg99
	do
		case $param
		in

		http* | dns | dig | BBNET | BBDISPLAY | BBPAGER | BBRELAY:* | dialup | noping | testip | noconn )

			case $param
			in
				BBRELAY:* )
					echo "$line" | grep BBDISPLAY >/dev/null 2>&1
					if [ "$?" -ne 0 ]
					then
						echo "$line" | grep BBDISPLAY >/dev/null 2>&1
						if [ "$?" -ne 0 ]
						then
							echo "bb-hosts: directive ($param) not defined in an entry with a BBDISPLAY and/or BBPAGER directive"
							echo ""
							continue
						fi
					fi

					OLDIFS=$IFS
					IFS=":"
					set $param
					IFS=$OLDIFS
					if [ "$2" = "" ]
					then
						echo "bb-hosts: directive ($param) improperly defined should be BBRELAY:<hostname|IP addr>"
						echo ""
						continue
					fi
					;;
			esac

			continue
			;;
		*)
			OLDIFS=$IFS
			IFS=':'
			set ${param}
			IFS=$OLDIFS
			nettest=$1

			echo " ${BBNETSVCS} " | grep "[ 	]${nettest}[ 	]" >/dev/null 2>&1
			if [ "$?" -eq 0 ]
			then
			case $param
			in
				!* )
					param=`echo $param | sed 's/!//1'`
					;;
				\~* )
					param=`echo $param | sed 's/~//1'`
					;;
				\?* )
					param=`echo $param | sed 's/?//1'`
					;;
			esac
			OLDIFS=$IFS
			IFS=':'
			set ${param}
			IFS=$OLDIFS
			if [ "$#" -eq 2 ]
			then
				# Check for "svc:port" construct
				case $2
				in
					[0-9]* )
						continue
						;;
				esac
			fi
			grep "^${1}[ 	]" /etc/services >/dev/null 2>/dev/null
			if [ "$?" -ne 0 ]
			then
				echo "bb-hosts: \"$line\"
	-- unknown service ($param)
	-- ignore if it is an external script tag"
				echo ""
			fi
			shift
			while [ "$#" -gt 0 ]
			do
				case $1
				in
					[qQs] )
						;;
					* )
						echo "bb-hosts: \"$line\"
	-- invalid qualifier ($param) Valid qualifiers are [qQs]"
						echo ""
						;;
				esac
				shift
			done
			else
				echo "bb-hosts: \"$line\"
	-- unknown directive ($param)"
				echo ""

			fi
			;;
		esac
	done
done
