#
# Copyright (c) 1990 Universities Research Association, Inc.        
#       All Rights Reserved                                                    
#
#
# This material resulted from work developed under a Government Contract and   
# is subject to the following license:  The Government retains a paid-up,      
# nonexclusive, irrevocable worldwide license to reproduce, prepare derivative 
# works, perform publicly and display publicly by or for the Government,       
# including the right to distribute to other Government contractors.  Neither  
# the United States nor the United States Department of Energy, nor any of     
# their employees, makes any warrenty, express or implied, or assumes any      
# legal liability or responsibility for the accuracy, completeness, or         
# usefulness of any information, apparatus, product, or process disclosed, or  
# represents that its use would not infringe privately owned rights.
#

# @(#) fermi.cshrc 4.32 Delta: 94/09/29 22:22:46 Extraction 94/09/29 22:34:39 @(#)

# fermi.cshrc settings for all users; will be called by the default .cshrc
set MACH_ID=`/usr/local/bin/funame -n`
set MACH_TYPE=`/usr/local/bin/funame -m`
set MACH_OS=`/usr/local/bin/funame -s`

#Determine if this is the first time the fermi.cshrc file has been executed
#on this machine
if ($?FERMICSHRC) then
        if ( $FERMICSHRC == "$MACH_ID" ) then
                set firsttime=0
        else
                set firsttime=1
                setenv FERMICSHRC "$MACH_ID"
        endif
else
        setenv FERMICSHRC "$MACH_ID"
        set firsttime=1
endif

#Execute the things that are only done the first time through
if ( $firsttime == "1" ) then
	# set path
	if ( -r /usr/local/etc/setpath.csh ) then
        	source /usr/local/etc/setpath.csh
	endif
	#
	# Establish MANPATH
	#
	setenv MANPATH /p/cluster_disk/man:/usr/catman:/usr/man:/usr/share/catman:/usr/share/man:/usr/local/catman:/usr/local/man

endif

#Execute the items done each time (basically only aliases)

#
# Setup UPS
#
if ( -r /fnal/ups/Linux/etc/setups.csh ) then
       	source /fnal/ups/Linux/etc/setups.csh
endif

switch ($MACH_OS)
case IRIX:
	alias fermimail '/usr/sbin/Mail'	# Berkely mail
breaksw
case SunOS:
	alias fermimail '/usr/ucb/Mail'		# Berkely mail
breaksw
case AIX:
	alias fermimail '/usr/ucb/Mail'			#Berkely Mail
breaksw
case ULTRIX:
	alias fermimail '/usr/ucb/Mail'			# Berkely Mail
breaksw
case OSF1:
	alias fermimail '/usr/bin/Mail'			# Berkely Mail
breaksw
case HP-UX:
	alias fermimail '/usr/bin/mailx'	#Berkely Mail
breaksw
default
	if ( -x /usr/ucb/Mail ) then
		alias fermimail '/usr/ucb/Mail'         #Berkely Mail
	endif
	if ( -x /usr/sbin/Mail ) then
		alias fermimail '/usr/sbin/Mail'        #Berkely Mail
	endif
	if ( -x /usr/bsd/Mail ) then
		alias fermimail '/usr/bsd/Mail'         #Berkely Mail
	endif
	if ( -x /usr/bin/mailx ) then
		alias fermimail '/usr/bin/mailx'        #Berkely Mail
	endif
	if ( -x /usr/bin/Mail ) then
		alias fermimail '/usr/bin/Mail'        #Berkely Mail
	endif
breaksw
endsw
#
# Check for existance of local.cshsrc file. This is the file admins should
# put in any changes, additions, etc. so that they don't need to re-edit this
# file every release.
#
if ( -r /usr/local/etc/local.cshrc ) then
	source /usr/local/etc/local.cshrc
endif
