/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import oracle.net.ns.NetException;
import oracle.net.nt.ConnOption;

public class ConnStrategy {
    static final boolean DEBUG = false;
    private boolean optFound = false;
    public boolean reuseOpt = false;
    private ConnOption copt;
    public int sdu;
    public int tdu;
    public int nextOptToTry = 0;
    public Properties socketOptions = new Properties();
    private String osuser;
    private String programName;
    public int connectTimeout = -1;
    public int retryCount = 0;
    private int lastRetryCounter = 0;
    public Vector cOpts = new Vector(10, 10);

    public ConnStrategy(Properties properties) {
        this.osuser = properties.getProperty("oracle.jdbc.v$session.osuser");
        this.programName = properties.getProperty("oracle.jdbc.v$session.program");
        this.createSocketOptions(properties);
    }

    public String getOSUsername() {
        return this.osuser;
    }

    public String getProgramName() {
        return this.programName;
    }

    public void createSocketOptions(Properties properties) {
        String string = null;
        String string2 = null;
        boolean bl = false;
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (string.equalsIgnoreCase("TCP.NODELAY")) {
                bl = true;
                string2 = properties.getProperty("TCP.NODELAY").toUpperCase();
                if (string2.equals("NO")) {
                    this.socketOptions.put((Object)0, "NO");
                    continue;
                }
                this.socketOptions.put((Object)0, "YES");
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.READ_TIMEOUT")) {
                string2 = properties.getProperty("oracle.net.READ_TIMEOUT");
                this.socketOptions.put((Object)3, string2);
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.CONNECT_TIMEOUT")) {
                string2 = properties.getProperty("oracle.net.CONNECT_TIMEOUT");
                this.socketOptions.put((Object)2, string2);
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.ssl_server_dn_match")) {
                string2 = properties.getProperty("oracle.net.ssl_server_dn_match");
                this.socketOptions.put((Object)4, string2);
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.wallet_location")) {
                string2 = properties.getProperty("oracle.net.wallet_location");
                this.socketOptions.put((Object)5, string2);
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.wallet_password")) {
                string2 = properties.getProperty("oracle.net.wallet_password");
                this.socketOptions.put((Object)16, string2);
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.ssl_version")) {
                string2 = properties.getProperty("oracle.net.ssl_version");
                this.socketOptions.put((Object)6, string2);
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.ssl_cipher_suites")) {
                string2 = properties.getProperty("oracle.net.ssl_cipher_suites");
                this.socketOptions.put((Object)7, string2);
                continue;
            }
            if (string.equalsIgnoreCase("javax.net.ssl.keyStore")) {
                string2 = properties.getProperty("javax.net.ssl.keyStore");
                this.socketOptions.put((Object)8, string2);
                continue;
            }
            if (string.equalsIgnoreCase("javax.net.ssl.keyStoreType")) {
                string2 = properties.getProperty("javax.net.ssl.keyStoreType");
                this.socketOptions.put((Object)9, string2);
                continue;
            }
            if (string.equalsIgnoreCase("javax.net.ssl.keyStorePassword")) {
                string2 = properties.getProperty("javax.net.ssl.keyStorePassword");
                this.socketOptions.put((Object)10, string2);
                continue;
            }
            if (string.equalsIgnoreCase("javax.net.ssl.trustStore")) {
                string2 = properties.getProperty("javax.net.ssl.trustStore");
                this.socketOptions.put((Object)11, string2);
                continue;
            }
            if (string.equalsIgnoreCase("javax.net.ssl.trustStoreType")) {
                string2 = properties.getProperty("javax.net.ssl.trustStoreType");
                this.socketOptions.put((Object)12, string2);
                continue;
            }
            if (string.equalsIgnoreCase("javax.net.ssl.trustStorePassword")) {
                string2 = properties.getProperty("javax.net.ssl.trustStorePassword");
                this.socketOptions.put((Object)13, string2);
                continue;
            }
            if (string.equalsIgnoreCase("ssl.keyManagerFactory.algorithm")) {
                string2 = properties.getProperty("ssl.keyManagerFactory.algorithm");
                this.socketOptions.put((Object)14, string2);
                continue;
            }
            if (string.equalsIgnoreCase("FORCE_DNS_LOAD_BALANCING")) {
                string2 = properties.getProperty("FORCE_DNS_LOAD_BALANCING");
                this.socketOptions.put((Object)18, string2);
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.SDP")) {
                string2 = properties.getProperty("oracle.net.SDP");
                this.socketOptions.put((Object)19, string2);
                continue;
            }
            if (!string.equalsIgnoreCase("oracle.net.keepAlive")) continue;
            string2 = properties.getProperty("oracle.net.keepAlive");
            if (Boolean.parseBoolean(string2)) {
                this.socketOptions.put((Object)1, "YES");
                continue;
            }
            this.socketOptions.put((Object)1, "NO");
        }
        if (!bl && !this.reuseOpt) {
            this.socketOptions.put((Object)0, "YES");
        }
    }

    public void addSocketOptions(boolean bl) {
        if (bl) {
            this.socketOptions.put((Object)1, "YES");
        } else if (!this.reuseOpt) {
            this.socketOptions.put((Object)1, "NO");
        }
    }

    public void addOption(ConnOption connOption) {
        this.cOpts.addElement(connOption);
    }

    public boolean hasMoreOptions() {
        return this.nextOptToTry < this.cOpts.size();
    }

    public ConnOption execute() throws NetException {
        IOException iOException = null;
        if (this.connectTimeout == -1) {
            if (this.socketOptions.get(2) == null) {
                this.socketOptions.put((Object)2, Integer.toString(60000));
            }
        } else {
            this.socketOptions.put((Object)2, Integer.toString(this.connectTimeout));
        }
        if (this.retryCount < 0) {
            this.retryCount = 0;
        }
        this.socketOptions.put((Object)17, Integer.toString(this.retryCount));
        for (int i2 = this.lastRetryCounter; i2 <= this.retryCount; ++i2) {
            while (this.nextOptToTry < this.cOpts.size()) {
                try {
                    this.copt = (ConnOption)this.cOpts.elementAt(this.nextOptToTry);
                    this.copt.connect(this.socketOptions);
                    this.copt.sdu = this.sdu;
                    this.copt.tdu = this.tdu;
                    this.optFound = true;
                    ++this.nextOptToTry;
                    this.lastRetryCounter = i2;
                    return this.copt;
                }
                catch (IOException iOException2) {
                    ++this.nextOptToTry;
                    iOException = iOException2;
                }
            }
            this.nextOptToTry = 0;
        }
        if (iOException == null) {
            throw new NetException(20);
        }
        throw (NetException)new NetException(20).initCause(iOException);
    }

    public boolean optAvailable() {
        return this.optFound;
    }

    public void clearElements() {
        this.cOpts.removeAllElements();
    }

    public ConnOption getOption() {
        return this.copt;
    }

    public boolean isConnectionSocketKeepAlive() throws SocketException {
        return this.copt.isConnectionSocketKeepAlive();
    }
}

