# Copyright 2024-2026 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

# Autogenerated by pycargoebuild 0.15.0

EAPI=8

CRATES="
"

RUST_MIN_VER="1.88.0"
inherit cargo systemd

DESCRIPTION="Stalwart Mail Server"
HOMEPAGE="https://stalw.art"
SRC_URI="https://github.com/stalwartlabs/stalwart/archive/refs/tags/v${PV}.tar.gz -> ${P}.tar.gz
	${CARGO_CRATE_URIS}
"
if [[ ${PKGBUMPING} != ${PVR} ]]; then
	SRC_URI+="
		https://dev.gentoo.org/~lordvan/stalwart-0.15.5-crates.tar.xz
	"
fi

S="${WORKDIR}/stalwart-${PV}"

LICENSE="|| ( AGPL-3 )"
# Dependent crate licenses
LICENSE+="
	AGPL-3 Apache-2.0 BSD-2 BSD Boost-1.0 CC0-1.0 CDLA-Permissive-2.0
	ISC LGPL-2+ MIT MPL-2.0 Unicode-3.0 ZLIB BZIP2
"

# 0.14.x has breaking changes so avoid installing new server with old cli
DEPEND+="
	!!<net-mail/stalwart-cli-0.15.0
"

RDEPEND="acct-group/stalwart-mail
		 acct-user/stalwart-mail"

SLOT="0"
KEYWORDS="~amd64"
IUSE="sqlite postgres mysql +rocks"

DOCS="resources/config CHANGELOG.md  CONTRIBUTING.md  README.md  SECURITY.md  SECURITY_PROCESS.md  SECURITY_TEMPLATE.md"

src_unpack() {
	cargo_src_unpack
	sed -i -e "s%__PATH__/etc/%/opt/stalwart-mail/etc/%g" "${S}"/resources/systemd/stalwart-mail.service || die
	sed -i -e "s%__PATH__/bin/%/usr/bin/%g" "${S}"/resources/systemd/stalwart-mail.service || die
}

# src_prepare() {
# 	pushd .
# 	cd "${WORKDIR}/cargo_home/gentoo/librocksdb-sys-0.17.1+9.9.3/rocksdb"
# 	eapply "${FILESDIR}/rocksdb-10.1-fixincludes.patch"
# 	popd
# 	eapply_user
# }

src_configure() {
	local myfeatures=(
		$(usev sqlite)
		$(usev postgres)
		$(usev mysql)
		$(usev rocks)
	)
	# TODO: consider "enterprise" USE flag, which requires a premium license
	cargo_src_configure --no-default-features
}

src_compile() {
	cargo_src_compile --bin stalwart
}

src_install() {
	cargo_src_install --path crates/main

	newinitd "${FILESDIR}"/stalwart-mail.initd stalwart-mail
	systemd_dounit "${S}"/resources/systemd/stalwart-mail.service

	einstalldocs
}

pkg_config() {
	if [[ ! -d ${ROOT}/opt/stalwart-mail ]]; then
		einfo "Initializing standard config in ${ROOT}/opt/stalwart-mail"
		"${ROOT}"/usr/bin/stalwart-mail --init "${ROOT}"/opt/stalwart-mail
	else
		einfo "It appears you already have a config in stalwart-mail."
		einfo "Please remove ${ROOT}/opt/stalwart-mail and run this again"
		einfo "if you want to create a new clean standard config."
	fi
}

pkg_postinst() {
	ewarn "If you are upgrading from v0.14.1 and below, this version includes"
	ewarn "breaking changes to the internal directory, calendar and contacts."
	ewarn "Please read the upgrading documentation for more information on "
	ewarn "how to upgrade from previous versions."
	ewarn "It can be found here: https://stalw.art/docs/install/upgrade/"
	ewarn "0.15 upgrade instructions are here:"
	ewarn "https://github.com/stalwartlabs/stalwart/blob/main/UPGRADING/v0_15.md"
}
