# Copyright 2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

# Autogenerated by pycargoebuild 0.15.0

EAPI=8

CRATES="
	aho-corasick@1.1.3
	ansi_colours@1.2.3
	anstream@0.6.20
	anstyle-parse@0.2.7
	anstyle@1.0.13
	anyhow@1.0.100
	approx@0.5.1
	assert_float_eq@1.2.0
	autocfg@1.5.0
	bitflags@2.9.4
	bpaf@0.9.20
	by_address@1.2.1
	cfg-if@1.0.3
	colorchoice@1.0.4
	crossterm@0.29.0
	crossterm_winapi@0.9.1
	deranged@0.3.11
	deranged@0.5.4
	directories@6.0.0
	dirs-sys@0.5.0
	document-features@0.2.11
	either@1.15.0
	enable-ansi-support@0.2.1
	enterpolation@0.2.1
	env_home@0.1.0
	equivalent@1.0.2
	errno@0.3.14
	fast-srgb8@1.0.0
	fastrand@2.3.0
	fs_extra@1.3.0
	getrandom@0.2.16
	hashbrown@0.16.0
	heck@0.5.0
	indexmap@2.11.4
	is_ci@1.2.0
	is_terminal_polyfill@1.70.1
	itertools@0.14.0
	itoa@1.0.15
	lazy_static@1.5.0
	libc@0.2.176
	libredox@0.1.10
	linux-raw-sys@0.11.0
	litrs@0.4.2
	lock_api@0.4.13
	log@0.4.28
	memchr@2.7.6
	mio@1.0.4
	normpath@1.5.0
	nu-ansi-term@0.50.1
	num-conv@0.1.0
	num-traits@0.2.19
	num_threads@0.1.7
	once_cell@1.21.3
	option-ext@0.2.0
	owo-colors@4.2.3
	palette@0.7.6
	palette_derive@0.7.6
	parking_lot@0.12.4
	parking_lot_core@0.9.11
	pin-project-lite@0.2.16
	powerfmt@0.2.0
	proc-macro2@1.0.101
	quote@1.0.41
	redox_syscall@0.5.17
	redox_users@0.5.2
	regex-automata@0.4.11
	regex-syntax@0.8.6
	regex@1.11.3
	rustix@1.1.2
	ryu@1.0.20
	same-file@1.0.6
	scopeguard@1.2.0
	serde@1.0.228
	serde_core@1.0.228
	serde_derive@1.0.228
	serde_json@1.0.145
	serde_path_to_error@0.1.20
	sharded-slab@0.1.7
	shell-words@1.1.0
	smallvec@1.15.1
	strum@0.27.2
	strum_macros@0.27.2
	supports-color@3.0.2
	syn@2.0.106
	tempfile@3.23.0
	terminal-colorsaurus@1.0.0
	terminal-trx@0.2.4
	terminal_size@0.4.3
	thiserror-impl@1.0.69
	thiserror-impl@2.0.17
	thiserror@1.0.69
	thiserror@2.0.17
	thread_local@1.1.9
	time-core@0.1.6
	time@0.3.44
	tinyvec@1.10.0
	tinyvec_macros@0.1.1
	toml_datetime@0.7.2
	toml_edit@0.23.6
	toml_writer@1.0.3
	topology-traits@0.1.2
	tracing-attributes@0.1.30
	tracing-core@0.1.34
	tracing-log@0.2.0
	tracing-subscriber@0.3.20
	tracing@0.1.41
	unicode-ident@1.0.19
	unicode-normalization@0.1.24
	unicode-segmentation@1.12.0
	utf8parse@0.2.2
	valuable@0.1.1
	wasi@0.11.1+wasi-snapshot-preview1
	which@7.0.3
	winapi-i686-pc-windows-gnu@0.4.0
	winapi-util@0.1.11
	winapi-x86_64-pc-windows-gnu@0.4.0
	winapi@0.3.9
	windows-link@0.2.0
	windows-sys@0.42.0
	windows-sys@0.52.0
	windows-sys@0.59.0
	windows-sys@0.60.2
	windows-sys@0.61.1
	windows-targets@0.52.6
	windows-targets@0.53.4
	windows_aarch64_gnullvm@0.42.2
	windows_aarch64_gnullvm@0.52.6
	windows_aarch64_gnullvm@0.53.0
	windows_aarch64_msvc@0.42.2
	windows_aarch64_msvc@0.52.6
	windows_aarch64_msvc@0.53.0
	windows_i686_gnu@0.42.2
	windows_i686_gnu@0.52.6
	windows_i686_gnu@0.53.0
	windows_i686_gnullvm@0.52.6
	windows_i686_gnullvm@0.53.0
	windows_i686_msvc@0.42.2
	windows_i686_msvc@0.52.6
	windows_i686_msvc@0.53.0
	windows_x86_64_gnu@0.42.2
	windows_x86_64_gnu@0.52.6
	windows_x86_64_gnu@0.53.0
	windows_x86_64_gnullvm@0.42.2
	windows_x86_64_gnullvm@0.52.6
	windows_x86_64_gnullvm@0.53.0
	windows_x86_64_msvc@0.42.2
	windows_x86_64_msvc@0.52.6
	windows_x86_64_msvc@0.53.0
	winsafe@0.0.19
	xterm-color@1.0.1
"

RUST_MIN_VER="1.81.0"
inherit cargo shell-completion optfeature

DESCRIPTION="Neofetch with LGBTQ+ pride flags!"
HOMEPAGE="https://github.com/hykilpikonna/hyfetch"
SRC_URI="https://github.com/hykilpikonna/hyfetch/archive/${PV}/${P}.tar.gz
	${CARGO_CRATE_URIS}
"

LICENSE="MIT"
# Dependent crate licenses
LICENSE+=" Apache-2.0 ISC LGPL-3+ MIT MPL-2.0 Unicode-3.0"
SLOT="0"
KEYWORDS="~amd64"

src_install() {
	dodir usr/bin
	dobin target/release/hyfetch
	newbin neofetch neowofetch
	doman docs/hyfetch.1
	newman docs/neofetch.1 neowofetch.1
	newbashcomp hyfetch/scripts/autocomplete.bash ${PN}
	newzshcomp hyfetch/scripts/autocomplete.zsh _${PN}
}
pkg_postinst() {
	optfeature "displaying images" "media-libs/imlib2 www-client/w3m[imlib]"
	optfeature "gpu detection" sys-apps/pciutils
	optfeature "thumbnail creation" media-gfx/imagemagick
	optfeature "wallpaper" media-gfx/feh x11-misc/nitrogen
	optfeature "window size" x11-misc/xdotool "x11-apps/xwininfo x11-apps/xprop" "x11-apps/xwininfo x11-apps/xdpyinfo"
	elog "The standard neofetch is installed as 'neowofetch', to avoid name conflicts."
	elog "So if you do not wish to use the pride flag functionality, you can call the"
	elog "tool that way instead."
}
