# Copyright 1999-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

inherit elisp

DESCRIPTION="Unobtrusively trim extraneous white-space *ONLY* in lines edited"
HOMEPAGE="https://github.com/lewang/ws-butler"

if [[ "${PV}" == *9999* ]]; then
	inherit git-r3
	EGIT_REPO_URL="https://github.com/lewang/${PN}.git"
else
	SRC_URI="https://github.com/lewang/${PN}/archive/refs/tags/v${PV}.tar.gz -> ${P}.tar.gz"
fi

LICENSE="GPL-3+"
SLOT="0"
KEYWORDS="~amd64 ~x86"

SITEFILE="50${PN}-gentoo.el"

elisp-enable-tests ert tests -l tests/run-test.el
