# Copyright 2026 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

DISTUTILS_USE_PEP517=setuptools
PYTHON_COMPAT=( python3_{11..14} )

inherit distutils-r1

DESCRIPTION="Realistic password strength estimator"
HOMEPAGE="
	https://github.com/dwolfhub/zxcvbn-python/
	https://pypi.org/project/zxcvbn/
"
# no tests in sdist
SRC_URI="
	https://github.com/dwolfhub/zxcvbn-python/archive/refs/tags/v${PV}.tar.gz
		-> ${P}.gh.tar.gz
"
S="${WORKDIR}/zxcvbn-python-${PV}"

LICENSE="MIT"
SLOT="0"
KEYWORDS="amd64"

EPYTEST_PLUGINS=()
distutils_enable_tests pytest
