//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package generated

// CopyFileSMBInfo contains a group of parameters for the DirectoryClient.Rename method.
type CopyFileSMBInfo struct {
	// Specifies either the option to copy file attributes from a source file(source) to a target file or a list of attributes
	// to set on a target file.
	FileAttributes *string

	// Specifies either the option to copy file last write time from a source file(source) to a target file or a time value in
	// ISO 8601 format to set as last write time on a target file.
	FileChangeTime *string

	// Specifies either the option to copy file creation time from a source file(source) to a target file or a time value in ISO
	// 8601 format to set as creation time on a target file.
	FileCreationTime *string

	// Specifies either the option to copy file last write time from a source file(source) to a target file or a time value in
	// ISO 8601 format to set as last write time on a target file.
	FileLastWriteTime *string

	// Specifies the option to copy file security descriptor from source file or to set it using the value which is defined by
	// the header value of x-ms-file-permission or x-ms-file-permission-key.
	FilePermissionCopyMode *PermissionCopyModeType

	// Specifies the option to overwrite the target file if it already exists and has read-only attribute set.
	IgnoreReadOnly *bool

	// Specifies the option to set archive attribute on a target file. True means archive attribute will be set on a target file
	// despite attribute overrides or a source file state.
	SetArchiveAttribute *bool
}

// DestinationLeaseAccessConditions contains a group of parameters for the DirectoryClient.Rename method.
type DestinationLeaseAccessConditions struct {
	// Required if the destination file has an active infinite lease. The lease ID specified for this header must match the lease
	// ID of the destination file. If the request does not include the lease ID or
	// it is not valid, the operation fails with status code 412 (Precondition Failed). If this header is specified and the destination
	// file does not currently have an active lease, the operation will also
	// fail with status code 412 (Precondition Failed).
	DestinationLeaseID *string
}

// DirectoryClientCreateOptions contains the optional parameters for the DirectoryClient.Create method.
type DirectoryClientCreateOptions struct {
	// If specified, the provided file attributes shall be set. Default value: ‘Archive’ for file and ‘Directory’ for directory.
	// ‘None’ can also be specified as default.
	FileAttributes *string

	// Change time for the file/directory. Default value: Now.
	FileChangeTime *string

	// Creation time for the file/directory. Default value: Now.
	FileCreationTime *string

	// Last write time for the file/directory. Default value: Now.
	FileLastWriteTime *string

	// Optional, NFS only. The file mode of the file or directory
	FileMode *string

	// If specified the permission (security descriptor) shall be set for the directory/file. This header can be used if Permission
	// size is <= 8KB, else x-ms-file-permission-key header shall be used. Default
	// value: Inherit. If SDDL is specified as input, it must have owner, group and dacl. Note: Only one of the x-ms-file-permission
	// or x-ms-file-permission-key should be specified.
	FilePermission *string

	// Optional. Available for version 2023-06-01 and later. Specifies the format in which the permission is returned. Acceptable
	// values are SDDL or binary. If x-ms-file-permission-format is unspecified or
	// explicitly set to SDDL, the permission is returned in SDDL format. If x-ms-file-permission-format is explicitly set to
	// binary, the permission is returned as a base64 string representing the binary
	// encoding of the permission
	FilePermissionFormat *FilePermissionFormat

	// Key of the permission to be set for the directory/file. Note: Only one of the x-ms-file-permission or x-ms-file-permission-key
	// should be specified.
	FilePermissionKey *string

	// Optional, NFS only. The owning group of the file or directory.
	Group *string

	// A name-value pair to associate with a file storage object.
	Metadata map[string]*string

	// Optional, NFS only. The owner of the file or directory.
	Owner *string

	// The timeout parameter is expressed in seconds. For more information, see Setting Timeouts for File Service Operations.
	// [https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations]
	Timeout *int32
}

// DirectoryClientDeleteOptions contains the optional parameters for the DirectoryClient.Delete method.
type DirectoryClientDeleteOptions struct {
	// The timeout parameter is expressed in seconds. For more information, see Setting Timeouts for File Service Operations.
	// [https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations]
	Timeout *int32
}

// DirectoryClientForceCloseHandlesOptions contains the optional parameters for the DirectoryClient.ForceCloseHandles method.
type DirectoryClientForceCloseHandlesOptions struct {
	// A string value that identifies the portion of the list to be returned with the next list operation. The operation returns
	// a marker value within the response body if the list returned was not complete.
	// The marker value may then be used in a subsequent call to request the next set of list items. The marker value is opaque
	// to the client.
	Marker *string

	// Specifies operation should apply to the directory specified in the URI, its files, its subdirectories and their files.
	Recursive *bool

	// The snapshot parameter is an opaque DateTime value that, when present, specifies the share snapshot to query.
	Sharesnapshot *string

	// The timeout parameter is expressed in seconds. For more information, see Setting Timeouts for File Service Operations.
	// [https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations]
	Timeout *int32
}

// DirectoryClientGetPropertiesOptions contains the optional parameters for the DirectoryClient.GetProperties method.
type DirectoryClientGetPropertiesOptions struct {
	// The snapshot parameter is an opaque DateTime value that, when present, specifies the share snapshot to query.
	Sharesnapshot *string

	// The timeout parameter is expressed in seconds. For more information, see Setting Timeouts for File Service Operations.
	// [https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations]
	Timeout *int32
}

// DirectoryClientListFilesAndDirectoriesSegmentOptions contains the optional parameters for the DirectoryClient.NewListFilesAndDirectoriesSegmentPager
// method.
type DirectoryClientListFilesAndDirectoriesSegmentOptions struct {
	// Include this parameter to specify one or more datasets to include in the response.
	Include []ListFilesIncludeType

	// Include extended information.
	IncludeExtendedInfo *bool

	// A string value that identifies the portion of the list to be returned with the next list operation. The operation returns
	// a marker value within the response body if the list returned was not complete.
	// The marker value may then be used in a subsequent call to request the next set of list items. The marker value is opaque
	// to the client.
	Marker *string

	// Specifies the maximum number of entries to return. If the request does not specify maxresults, or specifies a value greater
	// than 5,000, the server will return up to 5,000 items.
	Maxresults *int32

	// Filters the results to return only entries whose name begins with the specified prefix.
	Prefix *string

	// The snapshot parameter is an opaque DateTime value that, when present, specifies the share snapshot to query.
	Sharesnapshot *string

	// The timeout parameter is expressed in seconds. For more information, see Setting Timeouts for File Service Operations.
	// [https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations]
	Timeout *int32
}

// DirectoryClientListHandlesOptions contains the optional parameters for the DirectoryClient.ListHandles method.
type DirectoryClientListHandlesOptions struct {
	// A string value that identifies the portion of the list to be returned with the next list operation. The operation returns
	// a marker value within the response body if the list returned was not complete.
	// The marker value may then be used in a subsequent call to request the next set of list items. The marker value is opaque
	// to the client.
	Marker *string

	// Specifies the maximum number of entries to return. If the request does not specify maxresults, or specifies a value greater
	// than 5,000, the server will return up to 5,000 items.
	Maxresults *int32

	// Specifies operation should apply to the directory specified in the URI, its files, its subdirectories and their files.
	Recursive *bool

	// The snapshot parameter is an opaque DateTime value that, when present, specifies the share snapshot to query.
	Sharesnapshot *string

	// The timeout parameter is expressed in seconds. For more information, see Setting Timeouts for File Service Operations.
	// [https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations]
	Timeout *int32
}

// DirectoryClientRenameOptions contains the optional parameters for the DirectoryClient.Rename method.
type DirectoryClientRenameOptions struct {
	// If specified the permission (security descriptor) shall be set for the directory/file. This header can be used if Permission
	// size is <= 8KB, else x-ms-file-permission-key header shall be used. Default
	// value: Inherit. If SDDL is specified as input, it must have owner, group and dacl. Note: Only one of the x-ms-file-permission
	// or x-ms-file-permission-key should be specified.
	FilePermission *string

	// Optional. Available for version 2023-06-01 and later. Specifies the format in which the permission is returned. Acceptable
	// values are SDDL or binary. If x-ms-file-permission-format is unspecified or
	// explicitly set to SDDL, the permission is returned in SDDL format. If x-ms-file-permission-format is explicitly set to
	// binary, the permission is returned as a base64 string representing the binary
	// encoding of the permission
	FilePermissionFormat *FilePermissionFormat

	// Key of the permission to be set for the directory/file. Note: Only one of the x-ms-file-permission or x-ms-file-permission-key
	// should be specified.
	FilePermissionKey *string

	// Optional. A boolean value that specifies whether the ReadOnly attribute on a preexisting destination file should be respected.
	// If true, the rename will succeed, otherwise, a previous file at the
	// destination with the ReadOnly attribute set will cause the rename to fail.
	IgnoreReadOnly *bool

	// A name-value pair to associate with a file storage object.
	Metadata map[string]*string

	// Optional. A boolean value for if the destination file already exists, whether this request will overwrite the file or not.
	// If true, the rename will succeed and will overwrite the destination file. If
	// not provided or if false and the destination file does exist, the request will not overwrite the destination file. If provided
	// and the destination file doesn’t exist, the rename will succeed. Note:
	// This value does not override the x-ms-file-copy-ignore-read-only header value.
	ReplaceIfExists *bool

	// The timeout parameter is expressed in seconds. For more information, see Setting Timeouts for File Service Operations.
	// [https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations]
	Timeout *int32
}

// DirectoryClientSetMetadataOptions contains the optional parameters for the DirectoryClient.SetMetadata method.
type DirectoryClientSetMetadataOptions struct {
	// A name-value pair to associate with a file storage object.
	Metadata map[string]*string

	// The timeout parameter is expressed in seconds. For more information, see Setting Timeouts for File Service Operations.
	// [https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations]
	Timeout *int32
}

// DirectoryClientSetPropertiesOptions contains the optional parameters for the DirectoryClient.SetProperties method.
type DirectoryClientSetPropertiesOptions struct {
	// If specified, the provided file attributes shall be set. Default value: ‘Archive’ for file and ‘Directory’ for directory.
	// ‘None’ can also be specified as default.
	FileAttributes *string

	// Change time for the file/directory. Default value: Now.
	FileChangeTime *string

	// Creation time for the file/directory. Default value: Now.
	FileCreationTime *string

	// Last write time for the file/directory. Default value: Now.
	FileLastWriteTime *string

	// Optional, NFS only. The file mode of the file or directory
	FileMode *string

	// If specified the permission (security descriptor) shall be set for the directory/file. This header can be used if Permission
	// size is <= 8KB, else x-ms-file-permission-key header shall be used. Default
	// value: Inherit. If SDDL is specified as input, it must have owner, group and dacl. Note: Only one of the x-ms-file-permission
	// or x-ms-file-permission-key should be specified.
	FilePermission *string

	// Optional. Available for version 2023-06-01 and later. Specifies the format in which the permission is returned. Acceptable
	// values are SDDL or binary. If x-ms-file-permission-format is unspecified or
	// explicitly set to SDDL, the permission is returned in SDDL format. If x-ms-file-permission-format is explicitly set to
	// binary, the permission is returned as a base64 string representing the binary
	// encoding of the permission
	FilePermissionFormat *FilePermissionFormat

	// Key of the permission to be set for the directory/file. Note: Only one of the x-ms-file-permission or x-ms-file-permission-key
	// should be specified.
	FilePermissionKey *string

	// Optional, NFS only. The owning group of the file or directory.
	Group *string

	// Optional, NFS only. The owner of the file or directory.
	Owner *string

	// The timeout parameter is expressed in seconds. For more information, see Setting Timeouts for File Service Operations.
	// [https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations]
	Timeout *int32
}

// FileClientAbortCopyOptions contains the optional parameters for the FileClient.AbortCopy method.
type FileClientAbortCopyOptions struct {
	// The timeout parameter is expressed in seconds. For more information, see Setting Timeouts for File Service Operations.
	// [https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations]
	Timeout *int32
}

// FileClientAcquireLeaseOptions contains the optional parameters for the FileClient.AcquireLease method.
type FileClientAcquireLeaseOptions struct {
	// Proposed lease ID, in a GUID string format. The File service returns 400 (Invalid request) if the proposed lease ID is
	// not in the correct format. See Guid Constructor (String) for a list of valid GUID
	// string formats.
	ProposedLeaseID *string

	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage
	// analytics logging is enabled.
	RequestID *string

	// The timeout parameter is expressed in seconds. For more information, see Setting Timeouts for File Service Operations.
	// [https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations]
	Timeout *int32
}

// FileClientBreakLeaseOptions contains the optional parameters for the FileClient.BreakLease method.
type FileClientBreakLeaseOptions struct {
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage
	// analytics logging is enabled.
	RequestID *string

	// The timeout parameter is expressed in seconds. For more information, see Setting Timeouts for File Service Operations.
	// [https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations]
	Timeout *int32
}

// FileClientChangeLeaseOptions contains the optional parameters for the FileClient.ChangeLease method.
type FileClientChangeLeaseOptions struct {
	// Proposed lease ID, in a GUID string format. The File service returns 400 (Invalid request) if the proposed lease ID is
	// not in the correct format. See Guid Constructor (String) for a list of valid GUID
	// string formats.
	ProposedLeaseID *string

	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage
	// analytics logging is enabled.
	RequestID *string

	// The timeout parameter is expressed in seconds. For more information, see Setting Timeouts for File Service Operations.
	// [https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations]
	Timeout *int32
}

// FileClientCreateHardLinkOptions contains the optional parameters for the FileClient.CreateHardLink method.
type FileClientCreateHardLinkOptions struct {
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage
	// analytics logging is enabled.
	RequestID *string

	// The timeout parameter is expressed in seconds. For more information, see Setting Timeouts for File Service Operations.
	// [https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations]
	Timeout *int32
}

// FileClientCreateOptions contains the optional parameters for the FileClient.Create method.
type FileClientCreateOptions struct {
	// If specified, the provided file attributes shall be set. Default value: ‘Archive’ for file and ‘Directory’ for directory.
	// ‘None’ can also be specified as default.
	FileAttributes *string

	// Change time for the file/directory. Default value: Now.
	FileChangeTime *string

	// Creation time for the file/directory. Default value: Now.
	FileCreationTime *string

	// Last write time for the file/directory. Default value: Now.
	FileLastWriteTime *string

	// Optional, NFS only. The file mode of the file or directory
	FileMode *string

	// If specified the permission (security descriptor) shall be set for the directory/file. This header can be used if Permission
	// size is <= 8KB, else x-ms-file-permission-key header shall be used. Default
	// value: Inherit. If SDDL is specified as input, it must have owner, group and dacl. Note: Only one of the x-ms-file-permission
	// or x-ms-file-permission-key should be specified.
	FilePermission *string

	// Optional. Available for version 2023-06-01 and later. Specifies the format in which the permission is returned. Acceptable
	// values are SDDL or binary. If x-ms-file-permission-format is unspecified or
	// explicitly set to SDDL, the permission is returned in SDDL format. If x-ms-file-permission-format is explicitly set to
	// binary, the permission is returned as a base64 string representing the binary
	// encoding of the permission
	FilePermissionFormat *FilePermissionFormat

	// Key of the permission to be set for the directory/file. Note: Only one of the x-ms-file-permission or x-ms-file-permission-key
	// should be specified.
	FilePermissionKey *string

	// Optional, NFS only. The owning group of the file or directory.
	Group *string

	// A name-value pair to associate with a file storage object.
	Metadata map[string]*string

	// Optional, NFS only. Type of the file or directory.
	NFSFileType *NFSFileType

	// Optional, NFS only. The owner of the file or directory.
	Owner *string

	// The timeout parameter is expressed in seconds. For more information, see Setting Timeouts for File Service Operations.
	// [https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations]
	Timeout *int32
}

// FileClientCreateSymbolicLinkOptions contains the optional parameters for the FileClient.CreateSymbolicLink method.
type FileClientCreateSymbolicLinkOptions struct {
	// Creation time for the file/directory. Default value: Now.
	FileCreationTime *string

	// Last write time for the file/directory. Default value: Now.
	FileLastWriteTime *string

	// Optional, NFS only. The owning group of the file or directory.
	Group *string

	// A name-value pair to associate with a file storage object.
	Metadata map[string]*string

	// Optional, NFS only. The owner of the file or directory.
	Owner *string

	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage
	// analytics logging is enabled.
	RequestID *string

	// The timeout parameter is expressed in seconds. For more information, see Setting Timeouts for File Service Operations.
	// [https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations]
	Timeout *int32
}

// FileClientDeleteOptions contains the optional parameters for the FileClient.Delete method.
type FileClientDeleteOptions struct {
	// The timeout parameter is expressed in seconds. For more information, see Setting Timeouts for File Service Operations.
	// [https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations]
	Timeout *int32
}

// FileClientDownloadOptions contains the optional parameters for the FileClient.Download method.
type FileClientDownloadOptions struct {
	// Return file data only from the specified byte range.
	Range *string

	// When this header is set to true and specified together with the Range header, the service returns the MD5 hash for the
	// range, as long as the range is less than or equal to 4 MB in size.
	RangeGetContentMD5 *bool

	// Specifies the response content should be returned as a structured message and specifies the message schema version and
	// properties.
	StructuredBodyType *string

	// The timeout parameter is expressed in seconds. For more information, see Setting Timeouts for File Service Operations.
	// [https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations]
	Timeout *int32
}

// FileClientForceCloseHandlesOptions contains the optional parameters for the FileClient.ForceCloseHandles method.
type FileClientForceCloseHandlesOptions struct {
	// A string value that identifies the portion of the list to be returned with the next list operation. The operation returns
	// a marker value within the response body if the list returned was not complete.
	// The marker value may then be used in a subsequent call to request the next set of list items. The marker value is opaque
	// to the client.
	Marker *string

	// The snapshot parameter is an opaque DateTime value that, when present, specifies the share snapshot to query.
	Sharesnapshot *string

	// The timeout parameter is expressed in seconds. For more information, see Setting Timeouts for File Service Operations.
	// [https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations]
	Timeout *int32
}

// FileClientGetPropertiesOptions contains the optional parameters for the FileClient.GetProperties method.
type FileClientGetPropertiesOptions struct {
	// The snapshot parameter is an opaque DateTime value that, when present, specifies the share snapshot to query.
	Sharesnapshot *string

	// The timeout parameter is expressed in seconds. For more information, see Setting Timeouts for File Service Operations.
	// [https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations]
	Timeout *int32
}

// FileClientGetRangeListOptions contains the optional parameters for the FileClient.GetRangeList method.
type FileClientGetRangeListOptions struct {
	// The previous snapshot parameter is an opaque DateTime value that, when present, specifies the previous snapshot.
	Prevsharesnapshot *string

	// Specifies the range of bytes over which to list ranges, inclusively.
	Range *string

	// The snapshot parameter is an opaque DateTime value that, when present, specifies the share snapshot to query.
	Sharesnapshot *string

	// This header is allowed only when PrevShareSnapshot query parameter is set. Determines whether the changed ranges for a
	// file that has been renamed or moved between the target snapshot (or the live
	// file) and the previous snapshot should be listed. If the value is true, the valid changed ranges for the file will be returned.
	// If the value is false, the operation will result in a failure with 409
	// (Conflict) response. The default value is false.
	SupportRename *bool

	// The timeout parameter is expressed in seconds. For more information, see Setting Timeouts for File Service Operations.
	// [https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations]
	Timeout *int32
}

// FileClientGetSymbolicLinkOptions contains the optional parameters for the FileClient.GetSymbolicLink method.
type FileClientGetSymbolicLinkOptions struct {
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage
	// analytics logging is enabled.
	RequestID *string

	// The snapshot parameter is an opaque DateTime value that, when present, specifies the share snapshot to query.
	Sharesnapshot *string

	// The timeout parameter is expressed in seconds. For more information, see Setting Timeouts for File Service Operations.
	// [https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations]
	Timeout *int32
}

// FileClientListHandlesOptions contains the optional parameters for the FileClient.ListHandles method.
type FileClientListHandlesOptions struct {
	// A string value that identifies the portion of the list to be returned with the next list operation. The operation returns
	// a marker value within the response body if the list returned was not complete.
	// The marker value may then be used in a subsequent call to request the next set of list items. The marker value is opaque
	// to the client.
	Marker *string

	// Specifies the maximum number of entries to return. If the request does not specify maxresults, or specifies a value greater
	// than 5,000, the server will return up to 5,000 items.
	Maxresults *int32

	// The snapshot parameter is an opaque DateTime value that, when present, specifies the share snapshot to query.
	Sharesnapshot *string

	// The timeout parameter is expressed in seconds. For more information, see Setting Timeouts for File Service Operations.
	// [https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations]
	Timeout *int32
}

// FileClientReleaseLeaseOptions contains the optional parameters for the FileClient.ReleaseLease method.
type FileClientReleaseLeaseOptions struct {
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage
	// analytics logging is enabled.
	RequestID *string

	// The timeout parameter is expressed in seconds. For more information, see Setting Timeouts for File Service Operations.
	// [https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations]
	Timeout *int32
}

// FileClientRenameOptions contains the optional parameters for the FileClient.Rename method.
type FileClientRenameOptions struct {
	// If specified the permission (security descriptor) shall be set for the directory/file. This header can be used if Permission
	// size is <= 8KB, else x-ms-file-permission-key header shall be used. Default
	// value: Inherit. If SDDL is specified as input, it must have owner, group and dacl. Note: Only one of the x-ms-file-permission
	// or x-ms-file-permission-key should be specified.
	FilePermission *string

	// Optional. Available for version 2023-06-01 and later. Specifies the format in which the permission is returned. Acceptable
	// values are SDDL or binary. If x-ms-file-permission-format is unspecified or
	// explicitly set to SDDL, the permission is returned in SDDL format. If x-ms-file-permission-format is explicitly set to
	// binary, the permission is returned as a base64 string representing the binary
	// encoding of the permission
	FilePermissionFormat *FilePermissionFormat

	// Key of the permission to be set for the directory/file. Note: Only one of the x-ms-file-permission or x-ms-file-permission-key
	// should be specified.
	FilePermissionKey *string

	// Optional. A boolean value that specifies whether the ReadOnly attribute on a preexisting destination file should be respected.
	// If true, the rename will succeed, otherwise, a previous file at the
	// destination with the ReadOnly attribute set will cause the rename to fail.
	IgnoreReadOnly *bool

	// A name-value pair to associate with a file storage object.
	Metadata map[string]*string

	// Optional. A boolean value for if the destination file already exists, whether this request will overwrite the file or not.
	// If true, the rename will succeed and will overwrite the destination file. If
	// not provided or if false and the destination file does exist, the request will not overwrite the destination file. If provided
	// and the destination file doesn’t exist, the rename will succeed. Note:
	// This value does not override the x-ms-file-copy-ignore-read-only header value.
	ReplaceIfExists *bool

	// The timeout parameter is expressed in seconds. For more information, see Setting Timeouts for File Service Operations.
	// [https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations]
	Timeout *int32
}

// FileClientSetHTTPHeadersOptions contains the optional parameters for the FileClient.SetHTTPHeaders method.
type FileClientSetHTTPHeadersOptions struct {
	// If specified, the provided file attributes shall be set. Default value: ‘Archive’ for file and ‘Directory’ for directory.
	// ‘None’ can also be specified as default.
	FileAttributes *string

	// Change time for the file/directory. Default value: Now.
	FileChangeTime *string

	// Resizes a file to the specified size. If the specified byte value is less than the current size of the file, then all ranges
	// above the specified byte value are cleared.
	FileContentLength *int64

	// Creation time for the file/directory. Default value: Now.
	FileCreationTime *string

	// Last write time for the file/directory. Default value: Now.
	FileLastWriteTime *string

	// Optional, NFS only. The file mode of the file or directory
	FileMode *string

	// If specified the permission (security descriptor) shall be set for the directory/file. This header can be used if Permission
	// size is <= 8KB, else x-ms-file-permission-key header shall be used. Default
	// value: Inherit. If SDDL is specified as input, it must have owner, group and dacl. Note: Only one of the x-ms-file-permission
	// or x-ms-file-permission-key should be specified.
	FilePermission *string

	// Optional. Available for version 2023-06-01 and later. Specifies the format in which the permission is returned. Acceptable
	// values are SDDL or binary. If x-ms-file-permission-format is unspecified or
	// explicitly set to SDDL, the permission is returned in SDDL format. If x-ms-file-permission-format is explicitly set to
	// binary, the permission is returned as a base64 string representing the binary
	// encoding of the permission
	FilePermissionFormat *FilePermissionFormat

	// Key of the permission to be set for the directory/file. Note: Only one of the x-ms-file-permission or x-ms-file-permission-key
	// should be specified.
	FilePermissionKey *string

	// Optional, NFS only. The owning group of the file or directory.
	Group *string

	// Optional, NFS only. The owner of the file or directory.
	Owner *string

	// The timeout parameter is expressed in seconds. For more information, see Setting Timeouts for File Service Operations.
	// [https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations]
	Timeout *int32
}

// FileClientSetMetadataOptions contains the optional parameters for the FileClient.SetMetadata method.
type FileClientSetMetadataOptions struct {
	// A name-value pair to associate with a file storage object.
	Metadata map[string]*string

	// The timeout parameter is expressed in seconds. For more information, see Setting Timeouts for File Service Operations.
	// [https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations]
	Timeout *int32
}

// FileClientStartCopyOptions contains the optional parameters for the FileClient.StartCopy method.
type FileClientStartCopyOptions struct {
	// Optional, NFS only. The file mode of the file or directory
	FileMode *string

	// NFS only. Applicable only when the copy source is a File. Determines the copy behavior of the mode bits of the file. source:
	// The mode on the destination file is copied from the source file. override:
	// The mode on the destination file is determined via the x-ms-mode header.
	FileModeCopyMode *ModeCopyMode

	// NFS only. Determines the copy behavior of the owner user identifier (UID) and group identifier (GID) of the file. source:
	// The owner user identifier (UID) and group identifier (GID) on the destination
	// file is copied from the source file. override: The owner user identifier (UID) and group identifier (GID) on the destination
	// file is determined via the x-ms-owner and x-ms-group headers.
	FileOwnerCopyMode *OwnerCopyMode

	// If specified the permission (security descriptor) shall be set for the directory/file. This header can be used if Permission
	// size is <= 8KB, else x-ms-file-permission-key header shall be used. Default
	// value: Inherit. If SDDL is specified as input, it must have owner, group and dacl. Note: Only one of the x-ms-file-permission
	// or x-ms-file-permission-key should be specified.
	FilePermission *string

	// Optional. Available for version 2023-06-01 and later. Specifies the format in which the permission is returned. Acceptable
	// values are SDDL or binary. If x-ms-file-permission-format is unspecified or
	// explicitly set to SDDL, the permission is returned in SDDL format. If x-ms-file-permission-format is explicitly set to
	// binary, the permission is returned as a base64 string representing the binary
	// encoding of the permission
	FilePermissionFormat *FilePermissionFormat

	// Key of the permission to be set for the directory/file. Note: Only one of the x-ms-file-permission or x-ms-file-permission-key
	// should be specified.
	FilePermissionKey *string

	// Optional, NFS only. The owning group of the file or directory.
	Group *string

	// A name-value pair to associate with a file storage object.
	Metadata map[string]*string

	// Optional, NFS only. The owner of the file or directory.
	Owner *string

	// The timeout parameter is expressed in seconds. For more information, see Setting Timeouts for File Service Operations.
	// [https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations]
	Timeout *int32
}

// FileClientUploadRangeFromURLOptions contains the optional parameters for the FileClient.UploadRangeFromURL method.
type FileClientUploadRangeFromURLOptions struct {
	// Only Bearer type is supported. Credentials should be a valid OAuth access token to copy source.
	CopySourceAuthorization *string

	// If the file last write time should be preserved or overwritten
	FileLastWrittenMode *FileLastWrittenMode

	// Specify the crc64 calculated for the range of bytes that must be read from the copy source.
	SourceContentCRC64 []byte

	// Bytes of source data in the specified range.
	SourceRange *string

	// The timeout parameter is expressed in seconds. For more information, see Setting Timeouts for File Service Operations.
	// [https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations]
	Timeout *int32
}

// FileClientUploadRangeOptions contains the optional parameters for the FileClient.UploadRange method.
type FileClientUploadRangeOptions struct {
	// An MD5 hash of the content. This hash is used to verify the integrity of the data during transport. When the Content-MD5
	// header is specified, the File service compares the hash of the content that has
	// arrived with the header value that was sent. If the two hashes do not match, the operation will fail with error code 400
	// (Bad Request).
	ContentMD5 []byte

	// If the file last write time should be preserved or overwritten
	FileLastWrittenMode *FileLastWrittenMode

	// Required if the request body is a structured message. Specifies the message schema version and properties.
	StructuredBodyType *string

	// Required if the request body is a structured message. Specifies the length of the blob/file content inside the message
	// body. Will always be smaller than Content-Length.
	StructuredContentLength *int64

	// The timeout parameter is expressed in seconds. For more information, see Setting Timeouts for File Service Operations.
	// [https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations]
	Timeout *int32
}

// LeaseAccessConditions contains a group of parameters for the ShareClient.GetProperties method.
type LeaseAccessConditions struct {
	// If specified, the operation only succeeds if the resource's lease is active and matches this ID.
	LeaseID *string
}

// ServiceClientGetPropertiesOptions contains the optional parameters for the ServiceClient.GetProperties method.
type ServiceClientGetPropertiesOptions struct {
	// The timeout parameter is expressed in seconds. For more information, see Setting Timeouts for File Service Operations.
	// [https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations]
	Timeout *int32
}

// ServiceClientListSharesSegmentOptions contains the optional parameters for the ServiceClient.NewListSharesSegmentPager
// method.
type ServiceClientListSharesSegmentOptions struct {
	// Include this parameter to specify one or more datasets to include in the response.
	Include []ListSharesIncludeType

	// A string value that identifies the portion of the list to be returned with the next list operation. The operation returns
	// a marker value within the response body if the list returned was not complete.
	// The marker value may then be used in a subsequent call to request the next set of list items. The marker value is opaque
	// to the client.
	Marker *string

	// Specifies the maximum number of entries to return. If the request does not specify maxresults, or specifies a value greater
	// than 5,000, the server will return up to 5,000 items.
	Maxresults *int32

	// Filters the results to return only entries whose name begins with the specified prefix.
	Prefix *string

	// The timeout parameter is expressed in seconds. For more information, see Setting Timeouts for File Service Operations.
	// [https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations]
	Timeout *int32
}

// ServiceClientSetPropertiesOptions contains the optional parameters for the ServiceClient.SetProperties method.
type ServiceClientSetPropertiesOptions struct {
	// The timeout parameter is expressed in seconds. For more information, see Setting Timeouts for File Service Operations.
	// [https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations]
	Timeout *int32
}

// ShareClientAcquireLeaseOptions contains the optional parameters for the ShareClient.AcquireLease method.
type ShareClientAcquireLeaseOptions struct {
	// Proposed lease ID, in a GUID string format. The File service returns 400 (Invalid request) if the proposed lease ID is
	// not in the correct format. See Guid Constructor (String) for a list of valid GUID
	// string formats.
	ProposedLeaseID *string

	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage
	// analytics logging is enabled.
	RequestID *string

	// The snapshot parameter is an opaque DateTime value that, when present, specifies the share snapshot to query.
	Sharesnapshot *string

	// The timeout parameter is expressed in seconds. For more information, see Setting Timeouts for File Service Operations.
	// [https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations]
	Timeout *int32
}

// ShareClientBreakLeaseOptions contains the optional parameters for the ShareClient.BreakLease method.
type ShareClientBreakLeaseOptions struct {
	// For a break operation, proposed duration the lease should continue before it is broken, in seconds, between 0 and 60. This
	// break period is only used if it is shorter than the time remaining on the
	// lease. If longer, the time remaining on the lease is used. A new lease will not be available before the break period has
	// expired, but the lease may be held for longer than the break period. If this
	// header does not appear with a break operation, a fixed-duration lease breaks after the remaining lease period elapses,
	// and an infinite lease breaks immediately.
	BreakPeriod *int32

	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage
	// analytics logging is enabled.
	RequestID *string

	// The snapshot parameter is an opaque DateTime value that, when present, specifies the share snapshot to query.
	Sharesnapshot *string

	// The timeout parameter is expressed in seconds. For more information, see Setting Timeouts for File Service Operations.
	// [https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations]
	Timeout *int32
}

// ShareClientChangeLeaseOptions contains the optional parameters for the ShareClient.ChangeLease method.
type ShareClientChangeLeaseOptions struct {
	// Proposed lease ID, in a GUID string format. The File service returns 400 (Invalid request) if the proposed lease ID is
	// not in the correct format. See Guid Constructor (String) for a list of valid GUID
	// string formats.
	ProposedLeaseID *string

	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage
	// analytics logging is enabled.
	RequestID *string

	// The snapshot parameter is an opaque DateTime value that, when present, specifies the share snapshot to query.
	Sharesnapshot *string

	// The timeout parameter is expressed in seconds. For more information, see Setting Timeouts for File Service Operations.
	// [https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations]
	Timeout *int32
}

// ShareClientCreateOptions contains the optional parameters for the ShareClient.Create method.
type ShareClientCreateOptions struct {
	// Specifies the access tier of the share.
	AccessTier                           *ShareAccessTier
	EnableSnapshotVirtualDirectoryAccess *bool

	// Protocols to enable on the share.
	EnabledProtocols *string

	// A name-value pair to associate with a file storage object.
	Metadata map[string]*string

	// Optional. Boolean. Default if not specified is false. This property enables paid bursting.
	PaidBurstingEnabled *bool

	// Optional. Integer. Default if not specified is the maximum throughput the file share can support. Current maximum for a
	// file share is 10,340 MiB/sec.
	PaidBurstingMaxBandwidthMibps *int64

	// Optional. Integer. Default if not specified is the maximum IOPS the file share can support. Current maximum for a file
	// share is 102,400 IOPS.
	PaidBurstingMaxIops *int64

	// Specifies the maximum size of the share, in gigabytes.
	Quota *int32

	// Root squash to set on the share. Only valid for NFS shares.
	RootSquash *ShareRootSquash

	// Optional. Supported in version 2025-01-05 and later. Only allowed for provisioned v2 file shares. Specifies the provisioned
	// bandwidth of the share, in mebibytes per second (MiBps). If this is not
	// specified, the provisioned bandwidth is set to value calculated based on recommendation formula.
	ShareProvisionedBandwidthMibps *int64

	// Optional. Supported in version 2025-01-05 and later. Only allowed for provisioned v2 file shares. Specifies the provisioned
	// number of input/output operations per second (IOPS) of the share. If this is
	// not specified, the provisioned IOPS is set to value calculated based on recommendation formula.
	ShareProvisionedIops *int64

	// The timeout parameter is expressed in seconds. For more information, see Setting Timeouts for File Service Operations.
	// [https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations]
	Timeout *int32
}

// ShareClientCreatePermissionOptions contains the optional parameters for the ShareClient.CreatePermission method.
type ShareClientCreatePermissionOptions struct {
	// The timeout parameter is expressed in seconds. For more information, see Setting Timeouts for File Service Operations.
	// [https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations]
	Timeout *int32
}

// ShareClientCreateSnapshotOptions contains the optional parameters for the ShareClient.CreateSnapshot method.
type ShareClientCreateSnapshotOptions struct {
	// A name-value pair to associate with a file storage object.
	Metadata map[string]*string

	// The timeout parameter is expressed in seconds. For more information, see Setting Timeouts for File Service Operations.
	// [https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations]
	Timeout *int32
}

// ShareClientDeleteOptions contains the optional parameters for the ShareClient.Delete method.
type ShareClientDeleteOptions struct {
	// Specifies the option include to delete the base share and all of its snapshots.
	DeleteSnapshots *DeleteSnapshotsOptionType

	// The snapshot parameter is an opaque DateTime value that, when present, specifies the share snapshot to query.
	Sharesnapshot *string

	// The timeout parameter is expressed in seconds. For more information, see Setting Timeouts for File Service Operations.
	// [https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations]
	Timeout *int32
}

// ShareClientGetAccessPolicyOptions contains the optional parameters for the ShareClient.GetAccessPolicy method.
type ShareClientGetAccessPolicyOptions struct {
	// The timeout parameter is expressed in seconds. For more information, see Setting Timeouts for File Service Operations.
	// [https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations]
	Timeout *int32
}

// ShareClientGetPermissionOptions contains the optional parameters for the ShareClient.GetPermission method.
type ShareClientGetPermissionOptions struct {
	// Optional. Available for version 2023-06-01 and later. Specifies the format in which the permission is returned. Acceptable
	// values are SDDL or binary. If x-ms-file-permission-format is unspecified or
	// explicitly set to SDDL, the permission is returned in SDDL format. If x-ms-file-permission-format is explicitly set to
	// binary, the permission is returned as a base64 string representing the binary
	// encoding of the permission
	FilePermissionFormat *FilePermissionFormat

	// The timeout parameter is expressed in seconds. For more information, see Setting Timeouts for File Service Operations.
	// [https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations]
	Timeout *int32
}

// ShareClientGetPropertiesOptions contains the optional parameters for the ShareClient.GetProperties method.
type ShareClientGetPropertiesOptions struct {
	// The snapshot parameter is an opaque DateTime value that, when present, specifies the share snapshot to query.
	Sharesnapshot *string

	// The timeout parameter is expressed in seconds. For more information, see Setting Timeouts for File Service Operations.
	// [https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations]
	Timeout *int32
}

// ShareClientGetStatisticsOptions contains the optional parameters for the ShareClient.GetStatistics method.
type ShareClientGetStatisticsOptions struct {
	// The timeout parameter is expressed in seconds. For more information, see Setting Timeouts for File Service Operations.
	// [https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations]
	Timeout *int32
}

// ShareClientReleaseLeaseOptions contains the optional parameters for the ShareClient.ReleaseLease method.
type ShareClientReleaseLeaseOptions struct {
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage
	// analytics logging is enabled.
	RequestID *string

	// The snapshot parameter is an opaque DateTime value that, when present, specifies the share snapshot to query.
	Sharesnapshot *string

	// The timeout parameter is expressed in seconds. For more information, see Setting Timeouts for File Service Operations.
	// [https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations]
	Timeout *int32
}

// ShareClientRenewLeaseOptions contains the optional parameters for the ShareClient.RenewLease method.
type ShareClientRenewLeaseOptions struct {
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage
	// analytics logging is enabled.
	RequestID *string

	// The snapshot parameter is an opaque DateTime value that, when present, specifies the share snapshot to query.
	Sharesnapshot *string

	// The timeout parameter is expressed in seconds. For more information, see Setting Timeouts for File Service Operations.
	// [https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations]
	Timeout *int32
}

// ShareClientRestoreOptions contains the optional parameters for the ShareClient.Restore method.
type ShareClientRestoreOptions struct {
	// Specifies the name of the previously-deleted share.
	DeletedShareName *string

	// Specifies the version of the previously-deleted share.
	DeletedShareVersion *string

	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage
	// analytics logging is enabled.
	RequestID *string

	// The timeout parameter is expressed in seconds. For more information, see Setting Timeouts for File Service Operations.
	// [https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations]
	Timeout *int32
}

// ShareClientSetAccessPolicyOptions contains the optional parameters for the ShareClient.SetAccessPolicy method.
type ShareClientSetAccessPolicyOptions struct {
	// The timeout parameter is expressed in seconds. For more information, see Setting Timeouts for File Service Operations.
	// [https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations]
	Timeout *int32
}

// ShareClientSetMetadataOptions contains the optional parameters for the ShareClient.SetMetadata method.
type ShareClientSetMetadataOptions struct {
	// A name-value pair to associate with a file storage object.
	Metadata map[string]*string

	// The timeout parameter is expressed in seconds. For more information, see Setting Timeouts for File Service Operations.
	// [https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations]
	Timeout *int32
}

// ShareClientSetPropertiesOptions contains the optional parameters for the ShareClient.SetProperties method.
type ShareClientSetPropertiesOptions struct {
	// Specifies the access tier of the share.
	AccessTier                           *ShareAccessTier
	EnableSnapshotVirtualDirectoryAccess *bool

	// Optional. Boolean. Default if not specified is false. This property enables paid bursting.
	PaidBurstingEnabled *bool

	// Optional. Integer. Default if not specified is the maximum throughput the file share can support. Current maximum for a
	// file share is 10,340 MiB/sec.
	PaidBurstingMaxBandwidthMibps *int64

	// Optional. Integer. Default if not specified is the maximum IOPS the file share can support. Current maximum for a file
	// share is 102,400 IOPS.
	PaidBurstingMaxIops *int64

	// Specifies the maximum size of the share, in gigabytes.
	Quota *int32

	// Root squash to set on the share. Only valid for NFS shares.
	RootSquash *ShareRootSquash

	// Optional. Supported in version 2025-01-05 and later. Only allowed for provisioned v2 file shares. Specifies the provisioned
	// bandwidth of the share, in mebibytes per second (MiBps). If this is not
	// specified, the provisioned bandwidth is set to value calculated based on recommendation formula.
	ShareProvisionedBandwidthMibps *int64

	// Optional. Supported in version 2025-01-05 and later. Only allowed for provisioned v2 file shares. Specifies the provisioned
	// number of input/output operations per second (IOPS) of the share. If this is
	// not specified, the provisioned IOPS is set to value calculated based on recommendation formula.
	ShareProvisionedIops *int64

	// The timeout parameter is expressed in seconds. For more information, see Setting Timeouts for File Service Operations.
	// [https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations]
	Timeout *int32
}

// ShareFileHTTPHeaders contains a group of parameters for the FileClient.Create method.
type ShareFileHTTPHeaders struct {
	// Sets the file's cache control. The File service stores this value but does not use or modify it.
	CacheControl *string

	// Sets the file's Content-Disposition header.
	ContentDisposition *string

	// Specifies which content encodings have been applied to the file.
	ContentEncoding *string

	// Specifies the natural languages used by this resource.
	ContentLanguage *string

	// Sets the file's MD5 hash.
	ContentMD5 []byte

	// Sets the MIME content type of the file. The default type is 'application/octet-stream'.
	ContentType *string
}

// SourceLeaseAccessConditions contains a group of parameters for the DirectoryClient.Rename method.
type SourceLeaseAccessConditions struct {
	// Required if the source file has an active infinite lease.
	SourceLeaseID *string
}

// SourceModifiedAccessConditions contains a group of parameters for the FileClient.UploadRangeFromURL method.
type SourceModifiedAccessConditions struct {
	// Specify the crc64 value to operate only on range with a matching crc64 checksum.
	SourceIfMatchCRC64 []byte

	// Specify the crc64 value to operate only on range without a matching crc64 checksum.
	SourceIfNoneMatchCRC64 []byte
}
