/*
 * Copyright 2024-2025 Great Scott Gadgets <info@greatscottgadgets.com>
 *
 * This file is part of HackRF.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street,
 * Boston, MA 02110-1301, USA.
 */

#ifndef __TUNE_CONFIG_H__
#define __TUNE_CONFIG_H__

#ifdef PRALINE
	#include "fpga.h"

typedef struct {
	uint16_t rf_range_end_mhz;
	uint16_t if_mhz;
	bool high_lo;
	fpga_quarter_shift_mode_t shift;
} tune_config_t;

// clang-format off
/* tuning table optimized for TX */
static const tune_config_t praline_tune_config_tx[] = {
	{ 2100, 2375,  true, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2105, 2375, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2115, 2425, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2130, 2375, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2150, 2425, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2160, 2475, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2175, 2425, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2190, 2475, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2195, 2425, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2210, 2375, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2248, 2425, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2265, 2525, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2300, 2425, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2320, 2525, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2580,    0, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 3000, 2325, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 3140, 2375, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 3200, 2425, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 3280, 2375, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 3340, 2425, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 3420, 2475, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 3480, 2525, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 3500, 2475, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 3595, 2425, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 3625, 2375, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 3670, 2475, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 3710, 2425, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 3760, 2525, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 3790, 2475, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 3860, 2425, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 3915, 2375, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 4000, 2425, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 4055, 2375, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 4125, 2425, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 4700, 2375, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 4800, 2425, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 5000, 2375, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 5260, 2475, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 5465, 2525, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 5560, 2375, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 5720, 2425, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 5860, 2475, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 5970, 2575, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 6000, 2375, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 6500, 2325, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 6750, 2375, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 6850, 2425, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 6950, 2475, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 7000, 2525, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 7251, 2575, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{    0,    0, false, 0                            },
};

/* tuning table optimized for 20 Msps interleaved RX sweep mode */
static const tune_config_t praline_tune_config_rx_sweep[] = {
	{  140, 2330, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{  424, 2570,  true, FPGA_QUARTER_SHIFT_MODE_NONE },
	{  557, 2520,  true, FPGA_QUARTER_SHIFT_MODE_NONE },
	{  593, 2380,  true, FPGA_QUARTER_SHIFT_MODE_NONE },
	{  776, 2360,  true, FPGA_QUARTER_SHIFT_MODE_NONE },
	{  846, 2570,  true, FPGA_QUARTER_SHIFT_MODE_NONE },
	{  926, 2500,  true, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 1055, 2380,  true, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 1175, 2360,  true, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 1391, 2340,  true, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 1529, 2570,  true, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 1671, 2520,  true, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 1979, 2380,  true, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2150, 2330,  true, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2160, 2550, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2170, 2560, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2179, 2570, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2184, 2520, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2187, 2560, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2194, 2530, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2203, 2540, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2212, 2550, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2222, 2560, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2231, 2570, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2233, 2530, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2237, 2520, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2241, 2550, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2245, 2570, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2250, 2560, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2252, 2550, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2258, 2570, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2261, 2560, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2266, 2540, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2271, 2570, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2275, 2550, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2280, 2500, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2284, 2560, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2285, 2530, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2289, 2510, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2293, 2570, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2294, 2540, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2298, 2520, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2301, 2570, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2302, 2550, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2307, 2530, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2308, 2560, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2312, 2560, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2316, 2540, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2317, 2570, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2320, 2570, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2580,    0, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2585, 2360, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2588, 2340, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2594, 2350, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2606, 2330, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2617, 2340, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2627, 2350, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2638, 2360, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2649, 2370, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2659, 2380, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2664, 2350, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2675, 2360, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2686, 2370, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2697, 2380, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2705, 2350, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2716, 2360, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2728, 2370, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2739, 2380, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2757, 2330, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2779, 2350, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2790, 2360, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2801, 2370, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2812, 2380, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2821, 2570, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2831, 2520, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2852, 2330, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2874, 2350, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2897, 2370, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2913, 2510, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2925, 2570, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2937, 2530, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2948, 2540, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2960, 2550, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2975, 2330, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 2988, 2340, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 3002, 2330, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 3014, 2360, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 3027, 2370, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 3041, 2500, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 3052, 2510, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 3064, 2520, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 3082, 2500, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 3107, 2520, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 3132, 2540, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 3157, 2560, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 3170, 2570, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 3192, 2500, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 3216, 2340, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 3270, 2330, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 3319, 2370, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 3341, 2340, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 3370, 2330, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 3400, 2350, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 3430, 2370, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 3464, 2520, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 3491, 2540, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 3519, 2560, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 3553, 2510, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 3595, 2540, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 3638, 2570, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 3665, 2540, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 3685, 2560, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 3726, 2330, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 3790, 2370, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 3910, 2350, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 4014, 2510, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 4123, 2380, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 4191, 2550, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 4349, 2510, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 4452, 2570, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 4579, 2500, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 4707, 2570, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 4831, 2560, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 4851, 2570, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 4871, 2560, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 4891, 2570, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 4911, 2540, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 4931, 2550, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 4951, 2560, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 5044, 2330, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 5065, 2340, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 5174, 2330, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 5285, 2380, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 5449, 2340, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 5574, 2510, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 5717, 2340, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 5892, 2530, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 6096, 2350, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 6254, 2560, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 6625, 2340, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 6764, 2540, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 6930, 2530, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{ 7251, 2570, false, FPGA_QUARTER_SHIFT_MODE_NONE },
	{    0,    0, false, 0                            },
};

/* tuning table optimized for RX */
static const tune_config_t praline_tune_config_rx[] = {
	{    0, 2360,  true, FPGA_QUARTER_SHIFT_MODE_NONE },
	{   50, 2320,  true, FPGA_QUARTER_SHIFT_MODE_UP   },
	{  100, 2320,  true, FPGA_QUARTER_SHIFT_MODE_DOWN },
	{  140, 2320,  true, FPGA_QUARTER_SHIFT_MODE_UP   },
	{  406, 2560,  true, FPGA_QUARTER_SHIFT_MODE_UP   },
	{  511, 2380,  true, FPGA_QUARTER_SHIFT_MODE_UP   },
	{  578, 2560,  true, FPGA_QUARTER_SHIFT_MODE_DOWN },
	{  741, 2340,  true, FPGA_QUARTER_SHIFT_MODE_UP   },
	{  861, 2560,  true, FPGA_QUARTER_SHIFT_MODE_DOWN },
	{  921, 2560,  true, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 1049, 2340,  true, FPGA_QUARTER_SHIFT_MODE_DOWN },
	{ 1169, 2380,  true, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 1360, 2340,  true, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 1544, 2560,  true, FPGA_QUARTER_SHIFT_MODE_DOWN },
	{ 1675, 2560,  true, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 1992, 2380,  true, FPGA_QUARTER_SHIFT_MODE_DOWN },
	{ 2070, 2340,  true, FPGA_QUARTER_SHIFT_MODE_DOWN },
	{ 2150, 2360,  true, FPGA_QUARTER_SHIFT_MODE_DOWN },
	{ 2168, 2560, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 2185, 2580, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 2202, 2580, false, FPGA_QUARTER_SHIFT_MODE_DOWN },
	{ 2205, 2520, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 2216, 2560, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 2223, 2540, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 2234, 2580, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 2240, 2560, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 2251, 2580, false, FPGA_QUARTER_SHIFT_MODE_DOWN },
	{ 2258, 2580, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 2265, 2540, false, FPGA_QUARTER_SHIFT_MODE_DOWN },
	{ 2271, 2580, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 2273, 2560, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 2275, 2580, false, FPGA_QUARTER_SHIFT_MODE_DOWN },
	{ 2280, 2500, false, FPGA_QUARTER_SHIFT_MODE_DOWN },
	{ 2284, 2540, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 2289, 2580, false, FPGA_QUARTER_SHIFT_MODE_DOWN },
	{ 2293, 2540, false, FPGA_QUARTER_SHIFT_MODE_DOWN },
	{ 2298, 2520, false, FPGA_QUARTER_SHIFT_MODE_DOWN },
	{ 2300, 2580, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 2302, 2540, false, FPGA_QUARTER_SHIFT_MODE_DOWN },
	{ 2309, 2560, false, FPGA_QUARTER_SHIFT_MODE_DOWN },
	{ 2311, 2580, false, FPGA_QUARTER_SHIFT_MODE_DOWN },
	{ 2314, 2540, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 2315, 2540, false, FPGA_QUARTER_SHIFT_MODE_DOWN },
	{ 2320, 2580, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 2380,    0, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 2440,    0, false, FPGA_QUARTER_SHIFT_MODE_DOWN },
	{ 2500,    0, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 2580,    0, false, FPGA_QUARTER_SHIFT_MODE_DOWN },
	{ 2583, 2360, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 2584, 2380, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 2587, 2340, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 2593, 2340, false, FPGA_QUARTER_SHIFT_MODE_DOWN },
	{ 2607, 2340, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 2609, 2360, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 2615, 2360, false, FPGA_QUARTER_SHIFT_MODE_DOWN },
	{ 2627, 2340, false, FPGA_QUARTER_SHIFT_MODE_DOWN },
	{ 2629, 2360, false, FPGA_QUARTER_SHIFT_MODE_DOWN },
	{ 2631, 2380, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 2644, 2340, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 2649, 2380, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 2651, 2380, false, FPGA_QUARTER_SHIFT_MODE_DOWN },
	{ 2654, 2500, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 2665, 2360, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 2669, 2380, false, FPGA_QUARTER_SHIFT_MODE_DOWN },
	{ 2672, 2360, false, FPGA_QUARTER_SHIFT_MODE_DOWN },
	{ 2682, 2340, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 2687, 2380, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 2692, 2340, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 2695, 2500, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 2705, 2360, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 2707, 2380, false, FPGA_QUARTER_SHIFT_MODE_DOWN },
	{ 2712, 2340, false, FPGA_QUARTER_SHIFT_MODE_DOWN },
	{ 2717, 2520, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 2728, 2380, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 2730, 2560, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 2734, 2500, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 2758, 2340, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 2780, 2360, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 2787, 2520, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 2802, 2380, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 2809, 2540, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 2822, 2380, false, FPGA_QUARTER_SHIFT_MODE_DOWN },
	{ 2831, 2560, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 2854, 2340, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 2875, 2360, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 2898, 2380, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 2918, 2380, false, FPGA_QUARTER_SHIFT_MODE_DOWN },
	{ 2936, 2520, false, FPGA_QUARTER_SHIFT_MODE_DOWN },
	{ 2944, 2380, false, FPGA_QUARTER_SHIFT_MODE_DOWN },
	{ 2959, 2560, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 2976, 2340, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 2985, 2500, false, FPGA_QUARTER_SHIFT_MODE_DOWN },
	{ 3003, 2340, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 3009, 2540, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 3027, 2380, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 3034, 2560, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 3050, 2380, false, FPGA_QUARTER_SHIFT_MODE_DOWN },
	{ 3069, 2500, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 3094, 2520, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 3119, 2540, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 3144, 2560, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 3169, 2560, false, FPGA_QUARTER_SHIFT_MODE_DOWN },
	{ 3180, 2500, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 3204, 2340, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 3232, 2360, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 3292, 2340, false, FPGA_QUARTER_SHIFT_MODE_DOWN },
	{ 3340, 2380, false, FPGA_QUARTER_SHIFT_MODE_DOWN },
	{ 3369, 2340, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 3399, 2360, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 3429, 2380, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 3464, 2500, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 3489, 2520, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 3512, 2540, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 3551, 2500, false, FPGA_QUARTER_SHIFT_MODE_DOWN },
	{ 3582, 2540, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 3611, 2560, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 3639, 2520, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 3729, 2340, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 3817, 2380, false, FPGA_QUARTER_SHIFT_MODE_DOWN },
	{ 3942, 2360, false, FPGA_QUARTER_SHIFT_MODE_DOWN },
	{ 4049, 2540, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 4134, 2500, false, FPGA_QUARTER_SHIFT_MODE_DOWN },
	{ 4194, 2560, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 4353, 2520, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 4449, 2360, false, FPGA_QUARTER_SHIFT_MODE_DOWN },
	{ 4562, 2500, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 4672, 2560, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 4769, 2540, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 4849, 2560, false, FPGA_QUARTER_SHIFT_MODE_DOWN },
	{ 4889, 2560, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 4929, 2560, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 4969, 2560, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 5009, 2560, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 5049, 2560, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 5092, 2360, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 5209, 2340, false, FPGA_QUARTER_SHIFT_MODE_DOWN },
	{ 5298, 2380, false, FPGA_QUARTER_SHIFT_MODE_DOWN },
	{ 5468, 2340, false, FPGA_QUARTER_SHIFT_MODE_DOWN },
	{ 5582, 2520, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 5702, 2340, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 5888, 2520, false, FPGA_QUARTER_SHIFT_MODE_DOWN },
	{ 6092, 2340, false, FPGA_QUARTER_SHIFT_MODE_DOWN },
	{ 6240, 2560, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 6609, 2340, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 6752, 2380, false, FPGA_QUARTER_SHIFT_MODE_DOWN },
	{ 6930, 2520, false, FPGA_QUARTER_SHIFT_MODE_DOWN },
	{ 7000, 2560, false, FPGA_QUARTER_SHIFT_MODE_UP   },
	{ 7070, 2560, false, FPGA_QUARTER_SHIFT_MODE_DOWN },
	{ 7251, 2580, false, FPGA_QUARTER_SHIFT_MODE_DOWN },
	{    0,    0, false, 0                            },
};
// clang-format on
#endif

#endif /*__TUNE_CONFIG_H__*/
