local function choose( t ) return t[rnd.rnd(1,#t)] end
local function rnd_colour() return 'rgb('..rnd.rnd(0,255)..', '..rnd.rnd(0,255)..', '..rnd.rnd(0,255)..')' end
local skin_colour = { '#F7C4C4', '#b2bfc0', '#dcb6b6', '#dbd3ca', '#E4D2E1', '#e9decf' }
local lips_colour = { '#c98d8d', '#9f9e87', '#ac8e8e', '#927d72', '#D2AFC5', '#cab19b' }
local metal_colour = { '#5A6266', '#dc970f', '#aaa59c', '#995607', '#494C47' }

local overtop_svgs = {
   {
      back = false,
      front = false,
   }, {
      back = "overtop_back_ver1.svg",
      front = "overtop_front_ver1.svg",
   }, {
      back = false,
      front = "overtop_front_ver2.svg",
   },
}
local ears_svgs = {
   {
      back = "head_ears_back_ver1.svg",
      mid = "head_ears_mid_ver1.svg",
      front = "head_ears_ver1.svg",
   },
   {
      back = "head_ears_back_ver2.svg",
      mid = "head_ears_mid_ver2.svg",
      front = "head_ears_ver2.svg",
   },
   {
      back = "head_ears_back_ver3.svg",
      mid = "head_ears_mid_ver3.svg",
      front = "head_ears_ver3.svg",
   },
}
return function ()
   local skin_colour_id = rnd.rnd(1,#skin_colour)
   local choose_skin = skin_colour[skin_colour_id]
   local choose_lips = lips_colour[skin_colour_id]

   local overtop = choose(overtop_svgs)
   local ears = choose(ears_svgs)
   return {
      portraitview = {
         --Viewport is reference to the image coordinates
         viewxs = 0,
         viewys = 100,
         viewxe = 800,
         viewye = 550,
         -- Width and height are final render
         width  = 400,
         height = 300,
      },
      replace = {
         {"#aaaaaa", choose_skin}, -- skin
         {"#cccccc", rnd_colour()}, -- hair
         {"#bbbbbb", rnd_colour()}, -- eye colour
         {"#ff0000", rnd_colour()}, -- clothes main
         {"#00ff00", rnd_colour()}, -- clothes secondary
         {"#0000ff", rnd_colour()}, -- clothes trim
         {"#0ffff0", choose(metal_colour)}, -- clothes metal
         {"#f0000f", choose(metal_colour)}, -- clothes dmetal
         {"#ababab", choose_lips}, -- lips
         {"#ca0000", rnd_colour()}, -- red
      },
      overtop.back,
      choose{
         "right_hand.svg",
      },
      choose{
         "right_hand_acc_ver1.svg",
         "right_hand_acc_ver2.svg",
         "right_hand_acc_ver3.svg",
      },
      choose{
         "body.svg",
      },
      choose{
         "left_hand.svg",
      },
      choose{
         "left_hand_acc.svg",
      },
      choose{
         "clothes_ver1.svg",
         "clothes_ver2.svg",
      },
      overtop.front,
      ears.back,
      choose{
         "head_base_ver1.svg",
         "head_base_ver2.svg",
         "head_base_ver3.svg",
      }, choose{
         "head_mouth_ver1.svg",
         "head_mouth_ver2.svg",
         "head_mouth_ver3.svg",
      },
      ears.mid,
      choose{
         "head_eyes_ver1.svg",
         "head_eyes_ver2.svg",
         "head_eyes_ver3.svg",
      },
      choose{
         "head_nose_ver1.svg",
         "head_nose_ver2.svg",
         "head_nose_ver3.svg",
      },
      ears.front,
   }
end
