# Security Policy

## Reporting a Vulnerability

The KubeVirt project treats security vulnerabilities seriously, so we
strive to take action quickly when required.

The project requests that security issues be disclosed in a responsible
manner to allow adequate time to respond.  If a security issue or
vulnerability has been found, please disclose the details to our
dedicated email address:

cncf-kubevirt-security@lists.cncf.io

Please include as much information as possible with the report. The
following details assist with analysis efforts:
  - Description of the vulnerability
  - Affected component (version, commit, branch etc)
  - Affected code (file path, line numbers)
  - Exploit code

Any confidential information disclosed to the security team will be
handled appropriately to prevent misuse or accidental disclosure.

## Security Notices

Security notices will be sent to the kubevirt-dev@googlegroups.com
mailing list and published to the
[Security Advisories](https://github.com/kubevirt/kubevirt/security/advisories)
page.

## Security Team

The security team currently consists of the Maintainers of KubeVirt and is
supported by security teams of involved vendors.

List of involved vendor security teams:
- Red Hat <secalert@redhat.com>
- SUSE <security@suse.de>

## Alternate Reporting Mechanism

If you are unable to report the vulnerability to the dedicated email address, you can use the [GitHub vulnerability report mechanism](https://docs.github.com/en/code-security/security-advisories/guidance-on-reporting-and-writing-information-about-vulnerabilities/privately-reporting-a-security-vulnerability#privately-reporting-a-security-vulnerability). 
