/***************************************************************************
*   Copyright (C) 2004 by karye                                           *
*   karye@users.sourceforge.net                                           *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/

#ifndef SCANHISTORYJOB_H
#define SCANHISTORYJOB_H

#include <qmap.h>                           // for QMap<>::key_iterator, QMap
#include <qstring.h>                        // for QString, operator<
#include <qstringlist.h>                    // for QStringList
#include <threadweaver/job.h>               // for Job
#include <threadweaver/jobinterface.h>      // for JobPointer
#include <threadweaver/qobjectdecorator.h>  // for QObjectDecorator
#include <QObject>
#include <ThreadWeaver/Job>
#include <ThreadWeaver/JobPointer>
#include <ThreadWeaver/QObjectDecorator>
#include <ThreadWeaver/Thread>

#include "packageemergetime.h"              // for PackageEmergeTime

class DbConnection;
class PackageEmergeTime;

namespace ThreadWeaver {
class Thread;
}  // namespace ThreadWeaver

typedef QMap<QString, PackageEmergeTime> EmergeTimeMap;

/**
 * @class ScanHistoryJob
 * @short Thread for parsing emerge/unmerge entries found in emerge.log.
 */
class ScanHistoryJob : public ThreadWeaver::QObjectDecorator
{
	Q_OBJECT
public:
	ScanHistoryJob( const QStringList& logLines = QStringList() );
};
class ScanHistoryJobImpl : public ThreadWeaver::Job
{
public:
	ScanHistoryJobImpl( QStringList  logLines = QStringList() );
	~ScanHistoryJobImpl();

private:
    void 						run( ThreadWeaver::JobPointer, ThreadWeaver::Thread* ) override;
	//void 						completeJob();

	static QString 					escapeString( const QString& ) ;

private:
	DbConnection* const			m_db;

	// Log lines to parse
	QStringList 				m_logLines;
	Q_DISABLE_COPY(ScanHistoryJobImpl)
};

#endif
