//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/metal/mtlautoreleasedargument?language=objc)
#[cfg(feature = "MTLArgument")]
pub type MTLAutoreleasedArgument = MTLArgument;

/// [Apple's documentation](https://developer.apple.com/documentation/metal/mtlpatchtype?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct MTLPatchType(pub NSUInteger);
impl MTLPatchType {
    #[doc(alias = "MTLPatchTypeNone")]
    pub const None: Self = Self(0);
    #[doc(alias = "MTLPatchTypeTriangle")]
    pub const Triangle: Self = Self(1);
    #[doc(alias = "MTLPatchTypeQuad")]
    pub const Quad: Self = Self(2);
}

unsafe impl Encode for MTLPatchType {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for MTLPatchType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/metal/mtlvertexattribute?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct MTLVertexAttribute;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for MTLVertexAttribute {}
);

impl MTLVertexAttribute {
    extern_methods!(
        #[unsafe(method(name))]
        #[unsafe(method_family = none)]
        pub fn name(&self) -> Retained<NSString>;

        #[unsafe(method(attributeIndex))]
        #[unsafe(method_family = none)]
        pub fn attributeIndex(&self) -> NSUInteger;

        #[cfg(feature = "MTLArgument")]
        #[unsafe(method(attributeType))]
        #[unsafe(method_family = none)]
        pub fn attributeType(&self) -> MTLDataType;

        #[unsafe(method(isActive))]
        #[unsafe(method_family = none)]
        pub fn isActive(&self) -> bool;

        #[unsafe(method(isPatchData))]
        #[unsafe(method_family = none)]
        pub fn isPatchData(&self) -> bool;

        #[unsafe(method(isPatchControlPointData))]
        #[unsafe(method_family = none)]
        pub fn isPatchControlPointData(&self) -> bool;
    );
}

/// Methods declared on superclass `NSObject`.
impl MTLVertexAttribute {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/metal/mtlattribute?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct MTLAttribute;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for MTLAttribute {}
);

impl MTLAttribute {
    extern_methods!(
        #[unsafe(method(name))]
        #[unsafe(method_family = none)]
        pub fn name(&self) -> Retained<NSString>;

        #[unsafe(method(attributeIndex))]
        #[unsafe(method_family = none)]
        pub fn attributeIndex(&self) -> NSUInteger;

        #[cfg(feature = "MTLArgument")]
        #[unsafe(method(attributeType))]
        #[unsafe(method_family = none)]
        pub fn attributeType(&self) -> MTLDataType;

        #[unsafe(method(isActive))]
        #[unsafe(method_family = none)]
        pub fn isActive(&self) -> bool;

        #[unsafe(method(isPatchData))]
        #[unsafe(method_family = none)]
        pub fn isPatchData(&self) -> bool;

        #[unsafe(method(isPatchControlPointData))]
        #[unsafe(method_family = none)]
        pub fn isPatchControlPointData(&self) -> bool;
    );
}

/// Methods declared on superclass `NSObject`.
impl MTLAttribute {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

/// An identifier for a top-level Metal function.
///
/// Each location in the API where a program is used requires a function written for that specific usage.
///
///
/// A vertex shader, usable for a MTLRenderPipelineState.
///
///
/// A fragment shader, usable for a MTLRenderPipelineState.
///
///
/// A compute kernel, usable to create a MTLComputePipelineState.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/metal/mtlfunctiontype?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct MTLFunctionType(pub NSUInteger);
impl MTLFunctionType {
    #[doc(alias = "MTLFunctionTypeVertex")]
    pub const Vertex: Self = Self(1);
    #[doc(alias = "MTLFunctionTypeFragment")]
    pub const Fragment: Self = Self(2);
    #[doc(alias = "MTLFunctionTypeKernel")]
    pub const Kernel: Self = Self(3);
    #[doc(alias = "MTLFunctionTypeVisible")]
    pub const Visible: Self = Self(5);
    #[doc(alias = "MTLFunctionTypeIntersection")]
    pub const Intersection: Self = Self(6);
    #[doc(alias = "MTLFunctionTypeMesh")]
    pub const Mesh: Self = Self(7);
    #[doc(alias = "MTLFunctionTypeObject")]
    pub const Object: Self = Self(8);
}

unsafe impl Encode for MTLFunctionType {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for MTLFunctionType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// describe an uberShader constant used by the function
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/metal/mtlfunctionconstant?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct MTLFunctionConstant;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for MTLFunctionConstant {}
);

impl MTLFunctionConstant {
    extern_methods!(
        #[unsafe(method(name))]
        #[unsafe(method_family = none)]
        pub fn name(&self) -> Retained<NSString>;

        #[cfg(feature = "MTLArgument")]
        #[unsafe(method(type))]
        #[unsafe(method_family = none)]
        pub unsafe fn r#type(&self) -> MTLDataType;

        #[unsafe(method(index))]
        #[unsafe(method_family = none)]
        pub fn index(&self) -> NSUInteger;

        #[unsafe(method(required))]
        #[unsafe(method_family = none)]
        pub fn required(&self) -> bool;
    );
}

/// Methods declared on superclass `NSObject`.
impl MTLFunctionConstant {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

extern_protocol!(
    /// A handle to intermediate code used as inputs for either a MTLComputePipelineState or a MTLRenderPipelineState.
    ///
    /// MTLFunction is a single vertex shader, fragment shader, or compute function.  A Function can only be used with the device that it was created against.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/metal/mtlfunction?language=objc)
    pub unsafe trait MTLFunction: NSObjectProtocol {
        /// A string to help identify this object.
        #[unsafe(method(label))]
        #[unsafe(method_family = none)]
        fn label(&self) -> Option<Retained<NSString>>;

        /// Setter for [`label`][Self::label].
        #[unsafe(method(setLabel:))]
        #[unsafe(method_family = none)]
        fn setLabel(&self, label: Option<&NSString>);

        #[cfg(feature = "MTLDevice")]
        /// The device this resource was created against.  This resource can only be used with this device.
        #[unsafe(method(device))]
        #[unsafe(method_family = none)]
        fn device(&self) -> Retained<ProtocolObject<dyn MTLDevice>>;

        /// The overall kind of entry point: compute, vertex, or fragment.
        #[unsafe(method(functionType))]
        #[unsafe(method_family = none)]
        fn functionType(&self) -> MTLFunctionType;

        /// Returns the patch type. MTLPatchTypeNone if it is not a post tessellation vertex shader.
        #[unsafe(method(patchType))]
        #[unsafe(method_family = none)]
        fn patchType(&self) -> MTLPatchType;

        /// Returns the number of patch control points if it was specified in the shader. Returns -1 if it
        /// was not specified.
        #[unsafe(method(patchControlPointCount))]
        #[unsafe(method_family = none)]
        fn patchControlPointCount(&self) -> NSInteger;

        #[unsafe(method(vertexAttributes))]
        #[unsafe(method_family = none)]
        fn vertexAttributes(&self) -> Option<Retained<NSArray<MTLVertexAttribute>>>;

        /// Returns an array describing the attributes
        #[unsafe(method(stageInputAttributes))]
        #[unsafe(method_family = none)]
        fn stageInputAttributes(&self) -> Option<Retained<NSArray<MTLAttribute>>>;

        /// The name of the function in the shading language.
        #[unsafe(method(name))]
        #[unsafe(method_family = none)]
        fn name(&self) -> Retained<NSString>;

        /// A dictionary containing information about all function contents, keyed by the constant names.
        #[unsafe(method(functionConstantsDictionary))]
        #[unsafe(method_family = none)]
        fn functionConstantsDictionary(
            &self,
        ) -> Retained<NSDictionary<NSString, MTLFunctionConstant>>;

        #[cfg(feature = "MTLArgumentEncoder")]
        /// Creates an argument encoder which will encode arguments matching the layout of the argument buffer at the given bind point index.
        #[unsafe(method(newArgumentEncoderWithBufferIndex:))]
        #[unsafe(method_family = new)]
        unsafe fn newArgumentEncoderWithBufferIndex(
            &self,
            buffer_index: NSUInteger,
        ) -> Retained<ProtocolObject<dyn MTLArgumentEncoder>>;

        #[cfg(all(feature = "MTLArgument", feature = "MTLArgumentEncoder"))]
        /// Creates an argument encoder which will encode arguments matching the layout of the argument buffer at the given bind point index.
        #[deprecated = "Use MTLDevice's newArgumentEncoderWithBufferBinding: instead"]
        #[unsafe(method(newArgumentEncoderWithBufferIndex:reflection:))]
        #[unsafe(method_family = new)]
        unsafe fn newArgumentEncoderWithBufferIndex_reflection(
            &self,
            buffer_index: NSUInteger,
            reflection: Option<&mut Option<Retained<MTLAutoreleasedArgument>>>,
        ) -> Retained<ProtocolObject<dyn MTLArgumentEncoder>>;

        #[cfg(feature = "MTLFunctionDescriptor")]
        /// The options this function was created with.
        #[unsafe(method(options))]
        #[unsafe(method_family = none)]
        fn options(&self) -> MTLFunctionOptions;
    }
);

/// [Apple's documentation](https://developer.apple.com/documentation/metal/mtllanguageversion?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct MTLLanguageVersion(pub NSUInteger);
impl MTLLanguageVersion {
    #[doc(alias = "MTLLanguageVersion1_0")]
    #[deprecated = "Use a newer language standard"]
    pub const Version1_0: Self = Self(1 << 16);
    #[doc(alias = "MTLLanguageVersion1_1")]
    pub const Version1_1: Self = Self((1 << 16) + 1);
    #[doc(alias = "MTLLanguageVersion1_2")]
    pub const Version1_2: Self = Self((1 << 16) + 2);
    #[doc(alias = "MTLLanguageVersion2_0")]
    pub const Version2_0: Self = Self(2 << 16);
    #[doc(alias = "MTLLanguageVersion2_1")]
    pub const Version2_1: Self = Self((2 << 16) + 1);
    #[doc(alias = "MTLLanguageVersion2_2")]
    pub const Version2_2: Self = Self((2 << 16) + 2);
    #[doc(alias = "MTLLanguageVersion2_3")]
    pub const Version2_3: Self = Self((2 << 16) + 3);
    #[doc(alias = "MTLLanguageVersion2_4")]
    pub const Version2_4: Self = Self((2 << 16) + 4);
    #[doc(alias = "MTLLanguageVersion3_0")]
    pub const Version3_0: Self = Self((3 << 16) + 0);
    #[doc(alias = "MTLLanguageVersion3_1")]
    pub const Version3_1: Self = Self((3 << 16) + 1);
    #[doc(alias = "MTLLanguageVersion3_2")]
    pub const Version3_2: Self = Self((3 << 16) + 2);
}

unsafe impl Encode for MTLLanguageVersion {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for MTLLanguageVersion {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/metal/mtllibrarytype?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct MTLLibraryType(pub NSInteger);
impl MTLLibraryType {
    #[doc(alias = "MTLLibraryTypeExecutable")]
    pub const Executable: Self = Self(0);
    #[doc(alias = "MTLLibraryTypeDynamic")]
    pub const Dynamic: Self = Self(1);
}

unsafe impl Encode for MTLLibraryType {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for MTLLibraryType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Optimization level for the Metal compiler.
///
///
/// Optimize for program performance.
///
///
/// Like default, with extra optimizations to reduce code size.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/metal/mtllibraryoptimizationlevel?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct MTLLibraryOptimizationLevel(pub NSInteger);
impl MTLLibraryOptimizationLevel {
    #[doc(alias = "MTLLibraryOptimizationLevelDefault")]
    pub const Default: Self = Self(0);
    #[doc(alias = "MTLLibraryOptimizationLevelSize")]
    pub const Size: Self = Self(1);
}

unsafe impl Encode for MTLLibraryOptimizationLevel {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for MTLLibraryOptimizationLevel {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/metal/mtlcompilesymbolvisibility?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct MTLCompileSymbolVisibility(pub NSInteger);
impl MTLCompileSymbolVisibility {
    #[doc(alias = "MTLCompileSymbolVisibilityDefault")]
    pub const Default: Self = Self(0);
    #[doc(alias = "MTLCompileSymbolVisibilityHidden")]
    pub const Hidden: Self = Self(1);
}

unsafe impl Encode for MTLCompileSymbolVisibility {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for MTLCompileSymbolVisibility {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// An enum to indicate if the compiler can perform optimizations for floating-point arithmetic that may violate the IEEE 754 standard
///
///
/// Disables unsafe floating-point optimizations
///
///
/// Allows aggressive, unsafe floating-point optimizations but preserves infs and nans
///
///
/// Allows aggressive, unsafe floating-point optimizations
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/metal/mtlmathmode?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct MTLMathMode(pub NSInteger);
impl MTLMathMode {
    #[doc(alias = "MTLMathModeSafe")]
    pub const Safe: Self = Self(0);
    #[doc(alias = "MTLMathModeRelaxed")]
    pub const Relaxed: Self = Self(1);
    #[doc(alias = "MTLMathModeFast")]
    pub const Fast: Self = Self(2);
}

unsafe impl Encode for MTLMathMode {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for MTLMathMode {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// An enum to indicate the default math functions for single precision floating-point
///
///
/// Sets the default math functions for single precision floating-point to the corresponding functions in `metal::fast` namespace
///
///
/// Sets the default math functions for single precision floating-point to the corresponding functions in 'metal::precise' namespace
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/metal/mtlmathfloatingpointfunctions?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct MTLMathFloatingPointFunctions(pub NSInteger);
impl MTLMathFloatingPointFunctions {
    #[doc(alias = "MTLMathFloatingPointFunctionsFast")]
    pub const Fast: Self = Self(0);
    #[doc(alias = "MTLMathFloatingPointFunctionsPrecise")]
    pub const Precise: Self = Self(1);
}

unsafe impl Encode for MTLMathFloatingPointFunctions {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for MTLMathFloatingPointFunctions {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/metal/mtlcompileoptions?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct MTLCompileOptions;
);

extern_conformance!(
    unsafe impl NSCopying for MTLCompileOptions {}
);

unsafe impl CopyingHelper for MTLCompileOptions {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for MTLCompileOptions {}
);

impl MTLCompileOptions {
    extern_methods!(
        /// List of preprocessor macros to consider to when compiling this program. Specified as key value pairs, using a NSDictionary. The keys must be NSString objects and values can be either NSString or NSNumber objects.
        ///
        /// The default value is nil.
        #[unsafe(method(preprocessorMacros))]
        #[unsafe(method_family = none)]
        pub fn preprocessorMacros(&self) -> Option<Retained<NSDictionary<NSString, NSObject>>>;

        /// Setter for [`preprocessorMacros`][Self::preprocessorMacros].
        #[unsafe(method(setPreprocessorMacros:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setPreprocessorMacros(
            &self,
            preprocessor_macros: Option<&NSDictionary<NSString, NSObject>>,
        );

        /// If YES, enables the compiler to perform optimizations for floating-point arithmetic that may violate the IEEE 754 standard. It also enables the high precision variant of math functions for single precision floating-point scalar and vector types. fastMathEnabled defaults to YES.
        #[deprecated = "Use mathMode instead"]
        #[unsafe(method(fastMathEnabled))]
        #[unsafe(method_family = none)]
        pub fn fastMathEnabled(&self) -> bool;

        /// Setter for [`fastMathEnabled`][Self::fastMathEnabled].
        #[deprecated = "Use mathMode instead"]
        #[unsafe(method(setFastMathEnabled:))]
        #[unsafe(method_family = none)]
        pub fn setFastMathEnabled(&self, fast_math_enabled: bool);

        /// Sets the floating-point arithmetic optimizations. Default depends on the language standard version.
        #[unsafe(method(mathMode))]
        #[unsafe(method_family = none)]
        pub unsafe fn mathMode(&self) -> MTLMathMode;

        /// Setter for [`mathMode`][Self::mathMode].
        #[unsafe(method(setMathMode:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setMathMode(&self, math_mode: MTLMathMode);

        /// Sets the default math functions for single precision floating-point. Default is `MTLMathFloatingPointFunctionsFast`.
        #[unsafe(method(mathFloatingPointFunctions))]
        #[unsafe(method_family = none)]
        pub unsafe fn mathFloatingPointFunctions(&self) -> MTLMathFloatingPointFunctions;

        /// Setter for [`mathFloatingPointFunctions`][Self::mathFloatingPointFunctions].
        #[unsafe(method(setMathFloatingPointFunctions:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setMathFloatingPointFunctions(
            &self,
            math_floating_point_functions: MTLMathFloatingPointFunctions,
        );

        /// set the metal language version used to interpret the source.
        #[unsafe(method(languageVersion))]
        #[unsafe(method_family = none)]
        pub fn languageVersion(&self) -> MTLLanguageVersion;

        /// Setter for [`languageVersion`][Self::languageVersion].
        #[unsafe(method(setLanguageVersion:))]
        #[unsafe(method_family = none)]
        pub fn setLanguageVersion(&self, language_version: MTLLanguageVersion);

        /// Which type the library should be compiled as. The default value is MTLLibraryTypeExecutable.
        ///
        /// MTLLibraryTypeExecutable is suitable to build a library of "kernel", "vertex" and "fragment" qualified functions.
        /// MTLLibraryType is suitable when the compilation result will instead be used to instantiate a MTLDynamicLibrary.
        /// MTLDynamicLibrary contains no qualified functions, but it's unqualified functions and variables can be used as an external dependency for compiling other libraries.
        #[unsafe(method(libraryType))]
        #[unsafe(method_family = none)]
        pub fn libraryType(&self) -> MTLLibraryType;

        /// Setter for [`libraryType`][Self::libraryType].
        #[unsafe(method(setLibraryType:))]
        #[unsafe(method_family = none)]
        pub fn setLibraryType(&self, library_type: MTLLibraryType);

        /// The install name of this dynamic library.
        ///
        /// The install name is used when a pipeline state is created that depends, directly or indirectly, on a dynamic library.
        /// The installName is embedded into any other MTLLibrary that links against the compilation result.
        /// This property should be set such that the dynamic library can be found in the file system at the time a pipeline state is created.
        /// Specify one of:
        /// - an absolute path to a file from which the dynamic library can be loaded, or
        /// - a path relative to
        /// @
        /// executable_path, where
        /// @
        /// executable_path is substituted with the directory name from which the MTLLibrary containing the MTLFunction entrypoint used to create the pipeline state is loaded, or
        /// - a path relative to
        /// @
        /// loader_path, where
        /// @
        /// loader_path is substituted with the directory name from which the MTLLibrary with the reference to this installName embedded is loaded.
        /// The first is appropriate for MTLDynamicLibrary written to the file-system using its serializeToURL:error: method on the current device.
        /// The others are appropriate when the MTLDynamicLibrary is installed as part of a bundle or app, where the absolute path is not known.
        /// This property is ignored when the type property is not set to MTLLibraryTypeDynamic.
        /// This propery should not be null if the property type is set to MTLLibraryTypeDynamic: the compilation will fail in that scenario.
        #[unsafe(method(installName))]
        #[unsafe(method_family = none)]
        pub fn installName(&self) -> Option<Retained<NSString>>;

        /// Setter for [`installName`][Self::installName].
        #[unsafe(method(setInstallName:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setInstallName(&self, install_name: Option<&NSString>);

        #[cfg(feature = "MTLDynamicLibrary")]
        /// A set of MTLDynamicLibrary instances to link against.
        /// The installName of the provided MTLDynamicLibrary is embedded into the compilation result.
        /// When a function from the resulting MTLLibrary is used (either as an MTLFunction, or as an to create a pipeline state, the embedded install names are used to automatically load the MTLDynamicLibrary instances.
        /// This property can be null if no libraries should be automatically loaded, either because the MTLLibrary has no external dependencies, or because you will use preloadedLibraries to specify the libraries to use at pipeline creation time.
        #[unsafe(method(libraries))]
        #[unsafe(method_family = none)]
        pub fn libraries(&self)
            -> Option<Retained<NSArray<ProtocolObject<dyn MTLDynamicLibrary>>>>;

        #[cfg(feature = "MTLDynamicLibrary")]
        /// Setter for [`libraries`][Self::libraries].
        #[unsafe(method(setLibraries:))]
        #[unsafe(method_family = none)]
        pub fn setLibraries(
            &self,
            libraries: Option<&NSArray<ProtocolObject<dyn MTLDynamicLibrary>>>,
        );

        /// If YES,  set the compiler to compile shaders to preserve invariance.  The default is false.
        #[unsafe(method(preserveInvariance))]
        #[unsafe(method_family = none)]
        pub fn preserveInvariance(&self) -> bool;

        /// Setter for [`preserveInvariance`][Self::preserveInvariance].
        #[unsafe(method(setPreserveInvariance:))]
        #[unsafe(method_family = none)]
        pub fn setPreserveInvariance(&self, preserve_invariance: bool);

        /// Sets the compiler optimization level.
        #[unsafe(method(optimizationLevel))]
        #[unsafe(method_family = none)]
        pub unsafe fn optimizationLevel(&self) -> MTLLibraryOptimizationLevel;

        /// Setter for [`optimizationLevel`][Self::optimizationLevel].
        #[unsafe(method(setOptimizationLevel:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setOptimizationLevel(&self, optimization_level: MTLLibraryOptimizationLevel);

        /// Adds a compiler command to force the default visibility of symbols to be hidden
        #[unsafe(method(compileSymbolVisibility))]
        #[unsafe(method_family = none)]
        pub unsafe fn compileSymbolVisibility(&self) -> MTLCompileSymbolVisibility;

        /// Setter for [`compileSymbolVisibility`][Self::compileSymbolVisibility].
        #[unsafe(method(setCompileSymbolVisibility:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setCompileSymbolVisibility(
            &self,
            compile_symbol_visibility: MTLCompileSymbolVisibility,
        );

        /// Adds a compiler command to allow the reference of undefined symbols
        #[unsafe(method(allowReferencingUndefinedSymbols))]
        #[unsafe(method_family = none)]
        pub unsafe fn allowReferencingUndefinedSymbols(&self) -> bool;

        /// Setter for [`allowReferencingUndefinedSymbols`][Self::allowReferencingUndefinedSymbols].
        #[unsafe(method(setAllowReferencingUndefinedSymbols:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAllowReferencingUndefinedSymbols(
            &self,
            allow_referencing_undefined_symbols: bool,
        );

        /// Adds a compiler command to specify the total threads per threadgroup
        #[unsafe(method(maxTotalThreadsPerThreadgroup))]
        #[unsafe(method_family = none)]
        pub unsafe fn maxTotalThreadsPerThreadgroup(&self) -> NSUInteger;

        /// Setter for [`maxTotalThreadsPerThreadgroup`][Self::maxTotalThreadsPerThreadgroup].
        #[unsafe(method(setMaxTotalThreadsPerThreadgroup:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setMaxTotalThreadsPerThreadgroup(
            &self,
            max_total_threads_per_threadgroup: NSUInteger,
        );

        /// If YES,  set the compiler to enable any logging in the shader. The default is false.
        #[unsafe(method(enableLogging))]
        #[unsafe(method_family = none)]
        pub unsafe fn enableLogging(&self) -> bool;

        /// Setter for [`enableLogging`][Self::enableLogging].
        #[unsafe(method(setEnableLogging:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setEnableLogging(&self, enable_logging: bool);
    );
}

/// Methods declared on superclass `NSObject`.
impl MTLCompileOptions {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new() -> Retained<Self>;
    );
}

impl DefaultRetained for MTLCompileOptions {
    #[inline]
    fn default_retained() -> Retained<Self> {
        Self::new()
    }
}

extern "C" {
    /// NSErrors raised when creating a library.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/metal/mtllibraryerrordomain?language=objc)
    pub static MTLLibraryErrorDomain: &'static NSErrorDomain;
}

/// NSErrors raised when creating a library.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/metal/mtllibraryerror?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct MTLLibraryError(pub NSUInteger);
impl MTLLibraryError {
    #[doc(alias = "MTLLibraryErrorUnsupported")]
    pub const Unsupported: Self = Self(1);
    #[doc(alias = "MTLLibraryErrorInternal")]
    pub const Internal: Self = Self(2);
    #[doc(alias = "MTLLibraryErrorCompileFailure")]
    pub const CompileFailure: Self = Self(3);
    #[doc(alias = "MTLLibraryErrorCompileWarning")]
    pub const CompileWarning: Self = Self(4);
    #[doc(alias = "MTLLibraryErrorFunctionNotFound")]
    pub const FunctionNotFound: Self = Self(5);
    #[doc(alias = "MTLLibraryErrorFileNotFound")]
    pub const FileNotFound: Self = Self(6);
}

unsafe impl Encode for MTLLibraryError {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for MTLLibraryError {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/metal/mtllibrary?language=objc)
    pub unsafe trait MTLLibrary: NSObjectProtocol {
        /// A string to help identify this object.
        #[unsafe(method(label))]
        #[unsafe(method_family = none)]
        fn label(&self) -> Option<Retained<NSString>>;

        /// Setter for [`label`][Self::label].
        #[unsafe(method(setLabel:))]
        #[unsafe(method_family = none)]
        fn setLabel(&self, label: Option<&NSString>);

        #[cfg(feature = "MTLDevice")]
        /// The device this resource was created against.  This resource can only be used with this device.
        #[unsafe(method(device))]
        #[unsafe(method_family = none)]
        fn device(&self) -> Retained<ProtocolObject<dyn MTLDevice>>;

        /// Returns a pointer to a function object, return nil if the function is not found in the library.
        #[unsafe(method(newFunctionWithName:))]
        #[unsafe(method_family = new)]
        fn newFunctionWithName(
            &self,
            function_name: &NSString,
        ) -> Option<Retained<ProtocolObject<dyn MTLFunction>>>;

        #[cfg(feature = "MTLFunctionConstantValues")]
        /// Returns a pointer to a function object obtained by applying the constant values to the named function.
        ///
        /// This method will call the compiler. Use newFunctionWithName:constantValues:completionHandler: to
        /// avoid waiting on the compiler.
        #[unsafe(method(newFunctionWithName:constantValues:error:_))]
        #[unsafe(method_family = new)]
        fn newFunctionWithName_constantValues_error(
            &self,
            name: &NSString,
            constant_values: &MTLFunctionConstantValues,
        ) -> Result<Retained<ProtocolObject<dyn MTLFunction>>, Retained<NSError>>;

        #[cfg(all(feature = "MTLFunctionConstantValues", feature = "block2"))]
        /// Returns a pointer to a function object obtained by applying the constant values to the named function.
        ///
        /// This method is asynchronous since it is will call the compiler.
        #[unsafe(method(newFunctionWithName:constantValues:completionHandler:))]
        #[unsafe(method_family = none)]
        unsafe fn newFunctionWithName_constantValues_completionHandler(
            &self,
            name: &NSString,
            constant_values: &MTLFunctionConstantValues,
            completion_handler: &block2::DynBlock<
                dyn Fn(*mut ProtocolObject<dyn MTLFunction>, *mut NSError),
            >,
        );

        #[cfg(all(feature = "MTLFunctionDescriptor", feature = "block2"))]
        /// Create a new MTLFunction object asynchronously.
        #[unsafe(method(newFunctionWithDescriptor:completionHandler:))]
        #[unsafe(method_family = none)]
        unsafe fn newFunctionWithDescriptor_completionHandler(
            &self,
            descriptor: &MTLFunctionDescriptor,
            completion_handler: &block2::DynBlock<
                dyn Fn(*mut ProtocolObject<dyn MTLFunction>, *mut NSError),
            >,
        );

        #[cfg(feature = "MTLFunctionDescriptor")]
        /// Create  a new MTLFunction object synchronously.
        #[unsafe(method(newFunctionWithDescriptor:error:_))]
        #[unsafe(method_family = new)]
        fn newFunctionWithDescriptor_error(
            &self,
            descriptor: &MTLFunctionDescriptor,
        ) -> Result<Retained<ProtocolObject<dyn MTLFunction>>, Retained<NSError>>;

        #[cfg(all(feature = "MTLFunctionDescriptor", feature = "block2"))]
        /// Create a new MTLFunction object asynchronously.
        #[unsafe(method(newIntersectionFunctionWithDescriptor:completionHandler:))]
        #[unsafe(method_family = none)]
        unsafe fn newIntersectionFunctionWithDescriptor_completionHandler(
            &self,
            descriptor: &MTLIntersectionFunctionDescriptor,
            completion_handler: &block2::DynBlock<
                dyn Fn(*mut ProtocolObject<dyn MTLFunction>, *mut NSError),
            >,
        );

        #[cfg(feature = "MTLFunctionDescriptor")]
        /// Create  a new MTLFunction object synchronously.
        #[unsafe(method(newIntersectionFunctionWithDescriptor:error:_))]
        #[unsafe(method_family = new)]
        fn newIntersectionFunctionWithDescriptor_error(
            &self,
            descriptor: &MTLIntersectionFunctionDescriptor,
        ) -> Result<Retained<ProtocolObject<dyn MTLFunction>>, Retained<NSError>>;

        /// The array contains NSString objects, with the name of each function in library.
        #[unsafe(method(functionNames))]
        #[unsafe(method_family = none)]
        fn functionNames(&self) -> Retained<NSArray<NSString>>;

        /// The library type provided when this MTLLibrary was created.
        /// Libraries with MTLLibraryTypeExecutable can be used to obtain MTLFunction from.
        /// Libraries with MTLLibraryTypeDynamic can be used to resolve external references in other MTLLibrary from.
        ///
        /// See: MTLCompileOptions
        #[unsafe(method(type))]
        #[unsafe(method_family = none)]
        unsafe fn r#type(&self) -> MTLLibraryType;

        /// The installName provided when this MTLLibrary was created.
        ///
        /// Always nil if the type of the library is not MTLLibraryTypeDynamic.
        ///
        /// See: MTLCompileOptions
        #[unsafe(method(installName))]
        #[unsafe(method_family = none)]
        fn installName(&self) -> Option<Retained<NSString>>;
    }
);
