## RabbitMQ 4.0.3

RabbitMQ `4.0.3` is a maintenance release in the `4.0.x` [release series](https://www.rabbitmq.com/release-information).

Starting June 1st, 2024, community support for this series will only be provided to [regularly contributing users](https://github.com/rabbitmq/rabbitmq-server/blob/main/COMMUNITY_SUPPORT.md) and those
who hold a valid [commercial support license](https://tanzu.vmware.com/rabbitmq/oss).

It is **strongly recommended** that you read [4.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v4.0.1)
in detail if upgrading from a version prior to `4.0.0`.


### Minimum Supported Erlang Version

This release requires Erlang 26 and supports Erlang versions up to `26.2.x`.
[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/docs/which-erlang) has more details on
Erlang version requirements for RabbitMQ.

Nodes **will fail to start** on older Erlang releases.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v4.0.x/release-notes).

### Core Broker

#### Bug Fixes

 * Classic queues could run into an exception.

   Kudos to @netrmqdev for helping the core team reproduce this rare behavior.

   GitHub issue: [#12367](https://github.com/rabbitmq/rabbitmq-server/issues/12367)

 * [Continuous membership reconciliation](https://www.rabbitmq.com/docs/quorum-queues#replica-reconciliation) of quorum queues did not propagate a timeout error.

   Contributed by @SimonUnge.

   GitHub issue: [#12578](https://github.com/rabbitmq/rabbitmq-server/pull/12578)

 * Quorum queues could truncate the log too aggresively (by one entry too many).

   GitHub issue: [#12358](https://github.com/rabbitmq/rabbitmq-server/pull/12358)

 * Quorum queues failed to requeue a message with a specific workload where consumers
   requeued a delivery and then immediately cancelled themselves.

   GitHub issue: [#12442](https://github.com/rabbitmq/rabbitmq-server/pull/12442)

 * When a quorum queue was forced to shrink, it did not stop the replicas on the nodes that were
   removed from the list of replicas. In many cases this had no visible effects because the node
   in question is stopped or even removed entirely from the cluster.

   Contributed by @Ayanda-D.

   GitHub issue: [#12475](https://github.com/rabbitmq/rabbitmq-server/pull/12475)

 * AMQP 1.0 implementation now complies with the Anonymous Terminus extension (section [2.2.2 Routing Errors](https://docs.oasis-open.org/amqp/anonterm/v1.0/cs01/anonterm-v1.0-cs01.html#doc-routingerrors)).

   GitHub issue: [#12397](https://github.com/rabbitmq/rabbitmq-server/pull/12397)

 * For AMQP 1.0 clients, correct (compatible, sensible) combinations of the settle mode and a transfer's `settled` field
   are now enforced.

   GitHub issue: [#12371](https://github.com/rabbitmq/rabbitmq-server/pull/12371)

 * If an AMQP 1.0 client used a reserved annotation key, the connection was closed
   with an exception.

   GitHub issue: [#12527](https://github.com/rabbitmq/rabbitmq-server/pull/12527)

 * Messages with arrays in annotations published by AMQP 1.0 publishers and consumed by AMQP 0-9-1 consumers
   lead to an exception.

   GitHub issue: [#12572](https://github.com/rabbitmq/rabbitmq-server/pull/12572)

 * Quorum queues with a configured [delivery limit](https://www.rabbitmq.com/docs/quorum-queues#poison-message-handling) could run into an exception.

   GitHub issue: [#12405](https://github.com/rabbitmq/rabbitmq-server/pull/12405)

 * Publisher ID length is now validated to not exceed its internal limit of 255 bytes.

   GitHub issue: [#12499](https://github.com/rabbitmq/rabbitmq-server/issues/12499)

#### Enhancements

 * Initial support for Erlang/OTP 27, starting with [`27.1.2`](https://github.com/erlang/otp/releases/tag/OTP-27.1.2).

   Releases prior to `27.1.2` are affected
   by several bugs that can seriously affect RabbitMQ users, in particular those using TLS for client connections.

   RPM and Debian packages will reflect Erlang 27 support in their metadata starting with a later patch release, `4.0.4`.

   GitHub issue: [#12208](https://github.com/rabbitmq/rabbitmq-server/pull/12208) (and many others, including on the Erlang/OTP side)

 * Delivery requeue history is now better tracked using [AMQP 1.0's Modified Outcome](https://www.rabbitmq.com/blog/2024/10/11/modified-outcome) feature.

   GitHub issue: [#12506](https://github.com/rabbitmq/rabbitmq-server/pull/12506)

 * Nodes now avoid logging potentially confusing messages about schema data store operations when
   querying for traces of any deprecated (or removed) features in the system.

   GitHub issue: [#12348](https://github.com/rabbitmq/rabbitmq-server/pull/12348)



### Prometheus Plugin

#### Bug Fixes

 * `rabbitmq_queue_exchange_messages_published_total` included a duplicate `vhost` label.

   Contributed by @LoisSotoLopez.

   GitHub issue: [#12347](https://github.com/rabbitmq/rabbitmq-server/issues/12347)


### Management Plugin

#### Bug Fixes

 * `GET /api/queues/{vhost}` and similar endpoints ran into an exception when a sorting parameter was provided and one of the
   queues in the result set was a quorum one.

   GitHub issue: [#12374](https://github.com/rabbitmq/rabbitmq-server/issues/12374)


### Dependency Changes

 * CSV was upgraded to [`3.2.1`](https://github.com/beatrichartz/csv/blob/main/CHANGELOG.md)

## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-4.0.3.tar.xz`
instead of the source tarball produced by GitHub.
